/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.security;

import com.sun.jmx.remote.security.JMXSubjectDomainCombiner;
import com.sun.jmx.remote.util.CacheMap;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.management.remote.SubjectDelegationPermission;
import javax.security.auth.Subject;

public class SubjectDelegator {
    private static final int PRINCIPALS_CACHE_SIZE = 10;
    private static final int ACC_CACHE_SIZE = 10;
    private CacheMap principalsCache;
    private CacheMap accCache;

    public synchronized AccessControlContext delegatedContext(AccessControlContext accessControlContext, Subject subject) throws SecurityException {
        Principal[] principalArray;
        AccessControlContext accessControlContext2;
        Principal[] principalArray2;
        if (this.principalsCache == null || this.accCache == null) {
            this.principalsCache = new CacheMap(10);
            this.accCache = new CacheMap(10);
        }
        if ((principalArray2 = (Principal[])this.principalsCache.get(subject)) == null) {
            principalArray2 = subject.getPrincipals().toArray(new Principal[0]);
            this.principalsCache.put(subject, principalArray2);
        }
        if ((accessControlContext2 = (AccessControlContext)this.accCache.get(subject)) == null) {
            principalArray = new JMXSubjectDomainCombiner(subject);
            accessControlContext2 = new AccessControlContext(AccessController.getContext(), (DomainCombiner)principalArray);
            this.accCache.put(subject, accessControlContext2);
        }
        principalArray = principalArray2;
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                for (int i2 = 0; i2 < principalArray.length; ++i2) {
                    String string = principalArray[i2].getClass().getName() + "." + principalArray[i2].getName();
                    SubjectDelegationPermission subjectDelegationPermission = new SubjectDelegationPermission(string);
                    AccessController.checkPermission(subjectDelegationPermission);
                }
                return null;
            }
        };
        AccessController.doPrivileged(privilegedAction, accessControlContext);
        return accessControlContext2;
    }
}

