/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Toolkit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;

abstract class AbstractDataLine
extends AbstractLine
implements DataLine {
    protected AudioFormat defaultFormat;
    protected int defaultBufferSize;
    protected Object lock = new Object();
    protected AudioFormat format;
    protected int bufferSize;
    protected boolean running = false;
    private boolean started = false;
    private boolean active = false;

    protected AbstractDataLine(DataLine.Info info, AbstractMixer abstractMixer, Control[] controlArray) {
        this(info, abstractMixer, controlArray, new AudioFormat(44100.0f, 16, 2, true, Platform.isBigEndian()), 88200);
    }

    protected AbstractDataLine(DataLine.Info info, AbstractMixer abstractMixer, Control[] controlArray, AudioFormat audioFormat, int n2) {
        super(info, abstractMixer, controlArray);
        this.defaultFormat = audioFormat;
        this.defaultBufferSize = n2;
        this.format = this.defaultFormat;
        this.bufferSize = this.defaultBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (!this.isOpen()) {
                Toolkit.isFullySpecifiedAudioFormat(audioFormat);
                this.mixer.open(this);
                try {
                    this.implOpen(audioFormat, n2);
                    this.setOpen(true);
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.mixer.close(this);
                    throw lineUnavailableException;
                }
            } else {
                if (!audioFormat.matches(this.getFormat())) {
                    throw new IllegalStateException("Line is already open with format " + this.getFormat() + " and bufferSize " + this.getBufferSize());
                }
                if (n2 > 0) {
                    this.setBufferSize(n2);
                }
            }
        }
    }

    public void open(AudioFormat audioFormat) throws LineUnavailableException {
        this.open(audioFormat, -1);
    }

    public int available() {
        return 0;
    }

    public void drain() {
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.mixer;
        synchronized (object) {
            if (this.isOpen() && !this.isStartedRunning()) {
                this.mixer.start(this);
                this.implStart();
                this.running = true;
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mixer;
        synchronized (object) {
            if (this.isOpen() && this.isStartedRunning()) {
                this.implStop();
                this.mixer.stop(this);
                this.running = false;
                if (this.started && !this.isActive()) {
                    this.setStarted(false);
                }
            }
        }
        object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isActive() {
        return this.active;
    }

    public long getMicrosecondPosition() {
        long l2 = -1L;
        int n2 = this.getFramePosition();
        if (n2 != -1) {
            l2 = (long)((double)n2 * 1000000.0 / (double)this.getFormat().getFrameRate());
        }
        return l2;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int setBufferSize(int n2) {
        return this.getBufferSize();
    }

    public float getLevel() {
        return -1.0f;
    }

    protected boolean isStartedRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(boolean bl2) {
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.active != bl2) {
                this.active = bl2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStarted(boolean bl2) {
        boolean bl3 = false;
        int n2 = this.getFramePosition();
        AbstractDataLine abstractDataLine = this;
        synchronized (abstractDataLine) {
            if (this.started != bl2) {
                this.started = bl2;
                bl3 = true;
            }
        }
        if (bl3) {
            if (bl2) {
                this.sendEvents(new LineEvent(this, LineEvent.Type.START, n2));
            } else {
                this.sendEvents(new LineEvent(this, LineEvent.Type.STOP, n2));
            }
        }
    }

    protected void setEOM() {
        this.setStarted(false);
    }

    public void open() throws LineUnavailableException {
        this.open(this.format, this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (this.isOpen()) {
                this.stop();
                this.setOpen(false);
                this.implClose();
                this.mixer.close(this);
                this.format = this.defaultFormat;
                this.bufferSize = this.defaultBufferSize;
            }
        }
    }

    abstract void implOpen(AudioFormat var1, int var2) throws LineUnavailableException;

    abstract void implClose();

    abstract void implStart();

    abstract void implStop();
}

