/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AutoConnectSequencer;
import com.sun.media.sound.EventDispatcher;
import com.sun.media.sound.JSSecurityManager;
import com.sun.media.sound.MidiUtils;
import com.sun.media.sound.MixerSequencer;
import com.sun.media.sound.ReferenceCountingDevice;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.ControllerEventListener;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;

class RealTimeSequencer
extends AbstractMidiDevice
implements Sequencer,
AutoConnectSequencer {
    private static final boolean DEBUG_PUMP = false;
    private static final boolean DEBUG_PUMP_ALL = false;
    private static final boolean RMF = true;
    private static final EventDispatcher eventDispatcher;
    static final RealTimeSequencerInfo info;
    private static Sequencer.SyncMode[] masterSyncModes;
    private static Sequencer.SyncMode[] slaveSyncModes;
    private static Sequencer.SyncMode masterSyncMode;
    private static Sequencer.SyncMode slaveSyncMode;
    private Sequence sequence = null;
    private double cacheTempoMPQ = -1.0;
    private float cacheTempoFactor = -1.0f;
    private boolean[] trackMuted = null;
    private boolean[] trackSolo = null;
    private MidiUtils.TempoCache tempoCache = new MidiUtils.TempoCache();
    private boolean running = false;
    private PlayThread playThread;
    private boolean recording = false;
    private List recordingTracks = new ArrayList();
    private long loopStart = 0L;
    private long loopEnd = -1L;
    private int loopCount = 0;
    private ArrayList metaEventListeners = new ArrayList();
    private ArrayList controllerEventListeners = new ArrayList();
    private MixerSequencer seqBridge = null;
    private boolean autoConnect = false;
    private boolean doAutoConnectAtNextOpen = false;
    Receiver autoConnectedReceiver = null;

    protected RealTimeSequencer() throws MidiUnavailableException {
        super(info);
    }

    public synchronized void setSequence(Sequence sequence) throws InvalidMidiDataException {
        if (sequence != this.sequence) {
            if (this.sequence != null && sequence == null) {
                this.setCaches();
                this.stop();
                this.trackMuted = null;
                this.trackSolo = null;
                this.loopStart = 0L;
                this.loopEnd = -1L;
                this.loopCount = 0;
                if (this.getDataPump() != null) {
                    this.getDataPump().setTickPos(0L);
                    this.getDataPump().resetLoopCount();
                }
            }
            if (this.playThread != null) {
                this.playThread.setSequence(sequence);
            }
            this.sequence = sequence;
            if (sequence != null) {
                this.tempoCache.refresh(sequence);
                this.setTickPosition(0L);
                this.propagateCaches();
            }
        } else if (sequence != null) {
            this.tempoCache.refresh(sequence);
            if (this.playThread != null) {
                this.playThread.setSequence(sequence);
            }
        }
        if (this.seqBridge != null) {
            this.seqBridge.close();
            this.seqBridge = null;
        }
        if (this.isOpen() && sequence != null && this.playThread == null) {
            try {
                this.implOpen();
            }
            catch (MidiUnavailableException midiUnavailableException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSequence(InputStream inputStream) throws IOException, InvalidMidiDataException {
        if (inputStream == null) {
            this.setSequence((Sequence)null);
            return;
        }
        Object object = MidiSystem.getMidiFileFormat(inputStream);
        int n2 = ((MidiFileFormat)object).getType();
        int n3 = ((MidiFileFormat)object).getResolution();
        if (n3 == -1) {
            int n4;
            if (this.seqBridge == null) {
                try {
                    this.seqBridge = new MixerSequencer();
                    if (this.isOpen()) {
                        this.seqBridge.open();
                    }
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    throw new InvalidMidiDataException(midiUnavailableException.getMessage());
                }
            }
            this.seqBridge.setSequence(inputStream);
            this.seqBridge.setTempoFactor(this.getTempoFactor());
            ArrayList arrayList = this.metaEventListeners;
            synchronized (arrayList) {
                for (n4 = 0; n4 < this.metaEventListeners.size(); ++n4) {
                    this.seqBridge.addMetaEventListener((MetaEventListener)this.metaEventListeners.get(n4));
                }
            }
            arrayList = this.controllerEventListeners;
            synchronized (arrayList) {
                for (n4 = 0; n4 < this.controllerEventListeners.size(); ++n4) {
                    ControllerListElement controllerListElement = (ControllerListElement)this.controllerEventListeners.get(n4);
                    this.seqBridge.addControllerEventListener(controllerListElement.listener, controllerListElement.controllers);
                }
            }
            this.sequence = null;
            return;
        }
        if (this.seqBridge != null) {
            this.seqBridge.close();
            this.seqBridge = null;
        }
        object = MidiSystem.getSequence(inputStream);
        this.setSequence((Sequence)object);
    }

    public Sequence getSequence() {
        if (this.seqBridge != null) {
            return this.seqBridge.getSequence();
        }
        return this.sequence;
    }

    public synchronized void start() {
        if (this.seqBridge != null) {
            this.seqBridge.start();
            return;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("sequencer not open");
        }
        if (this.sequence == null) {
            throw new IllegalStateException("sequence not set");
        }
        if (this.running) {
            return;
        }
        this.implStart();
    }

    public synchronized void stop() {
        if (this.seqBridge != null) {
            this.seqBridge.stop();
            return;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("sequencer not open");
        }
        this.stopRecording();
        if (!this.running) {
            return;
        }
        this.implStop();
    }

    public boolean isRunning() {
        if (this.seqBridge != null) {
            return this.seqBridge.isRunning();
        }
        return this.running;
    }

    public void startRecording() {
        if (this.seqBridge != null) {
            this.seqBridge.startRecording();
            return;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.start();
        this.recording = true;
    }

    public void stopRecording() {
        if (this.seqBridge != null) {
            this.seqBridge.stopRecording();
            return;
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Sequencer not open");
        }
        this.recording = false;
    }

    public boolean isRecording() {
        if (this.seqBridge != null) {
            return this.seqBridge.isRecording();
        }
        return this.recording;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordEnable(Track track, int n2) {
        if (this.seqBridge != null) {
            this.seqBridge.recordEnable(track, n2);
            return;
        }
        if (!this.findTrack(track)) {
            throw new IllegalArgumentException("Track does not exist in the current sequence");
        }
        List list = this.recordingTracks;
        synchronized (list) {
            RecordingTrack recordingTrack = RecordingTrack.get(this.recordingTracks, track);
            if (recordingTrack != null) {
                recordingTrack.channel = n2;
            } else {
                this.recordingTracks.add(new RecordingTrack(track, n2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordDisable(Track track) {
        if (this.seqBridge != null) {
            this.seqBridge.recordDisable(track);
            return;
        }
        List list = this.recordingTracks;
        synchronized (list) {
            RecordingTrack recordingTrack = RecordingTrack.get(this.recordingTracks, track);
            if (recordingTrack != null) {
                this.recordingTracks.remove(recordingTrack);
            }
        }
    }

    private boolean findTrack(Track track) {
        boolean bl2 = false;
        if (this.sequence != null) {
            Track[] trackArray = this.sequence.getTracks();
            for (int i2 = 0; i2 < trackArray.length; ++i2) {
                if (track != trackArray[i2]) continue;
                bl2 = true;
                break;
            }
        }
        return bl2;
    }

    public float getTempoInBPM() {
        if (this.seqBridge != null) {
            return this.seqBridge.getTempoInBPM();
        }
        return (float)MidiUtils.convertTempo(this.getTempoInMPQ());
    }

    public void setTempoInBPM(float f2) {
        if (this.seqBridge != null) {
            this.seqBridge.setTempoInBPM(f2);
            return;
        }
        if (f2 <= 0.0f) {
            f2 = 1.0f;
        }
        this.setTempoInMPQ((float)MidiUtils.convertTempo(f2));
    }

    public float getTempoInMPQ() {
        if (this.seqBridge != null) {
            return this.seqBridge.getTempoInMPQ();
        }
        if (this.needCaching()) {
            if (this.cacheTempoMPQ != -1.0) {
                return (float)this.cacheTempoMPQ;
            }
            if (this.sequence != null) {
                return this.tempoCache.getTempoMPQAt(this.getTickPosition());
            }
            return 500000.0f;
        }
        return this.getDataPump().getTempoMPQ();
    }

    public void setTempoInMPQ(float f2) {
        if (this.seqBridge != null) {
            this.seqBridge.setTempoInMPQ(f2);
            return;
        }
        if (f2 <= 0.0f) {
            f2 = 1.0f;
        }
        if (this.needCaching()) {
            this.cacheTempoMPQ = f2;
        } else {
            this.getDataPump().setTempoMPQ(f2);
            this.cacheTempoMPQ = -1.0;
        }
    }

    public void setTempoFactor(float f2) {
        if (this.seqBridge != null) {
            this.seqBridge.setTempoFactor(f2);
            return;
        }
        if (f2 <= 0.0f) {
            return;
        }
        if (this.needCaching()) {
            this.cacheTempoFactor = f2;
        } else {
            this.getDataPump().setTempoFactor(f2);
            this.cacheTempoFactor = -1.0f;
        }
    }

    public float getTempoFactor() {
        if (this.seqBridge != null) {
            return this.seqBridge.getTempoFactor();
        }
        if (this.needCaching()) {
            if (this.cacheTempoFactor != -1.0f) {
                return this.cacheTempoFactor;
            }
            return 1.0f;
        }
        return this.getDataPump().getTempoFactor();
    }

    public long getTickLength() {
        if (this.seqBridge != null) {
            return this.seqBridge.getTickLength();
        }
        if (this.sequence == null) {
            return 0L;
        }
        return this.sequence.getTickLength();
    }

    public synchronized long getTickPosition() {
        if (this.seqBridge != null) {
            return this.seqBridge.getTickPosition();
        }
        if (this.getDataPump() == null || this.sequence == null) {
            return 0L;
        }
        return this.getDataPump().getTickPos();
    }

    public synchronized void setTickPosition(long l2) {
        if (this.seqBridge != null) {
            this.seqBridge.setTickPosition(l2);
            return;
        }
        if (l2 < 0L) {
            return;
        }
        if (this.getDataPump() == null) {
            if (l2 != 0L) {
                // empty if block
            }
        } else if (this.sequence == null) {
            if (l2 != 0L) {
                // empty if block
            }
        } else {
            this.getDataPump().setTickPos(l2);
        }
    }

    public long getMicrosecondLength() {
        if (this.seqBridge != null) {
            return this.seqBridge.getMicrosecondLength();
        }
        if (this.sequence == null) {
            return 0L;
        }
        return this.sequence.getMicrosecondLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMicrosecondPosition() {
        if (this.seqBridge != null) {
            return this.seqBridge.getMicrosecondPosition();
        }
        if (this.getDataPump() == null || this.sequence == null) {
            return 0L;
        }
        MidiUtils.TempoCache tempoCache = this.tempoCache;
        synchronized (tempoCache) {
            return MidiUtils.tick2microsecond(this.sequence, this.getDataPump().getTickPos(), this.tempoCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMicrosecondPosition(long l2) {
        if (this.seqBridge != null) {
            this.seqBridge.setMicrosecondPosition(l2);
            return;
        }
        if (l2 < 0L) {
            return;
        }
        if (this.getDataPump() == null) {
            if (l2 != 0L) {
                // empty if block
            }
        } else if (this.sequence == null) {
            if (l2 != 0L) {
                // empty if block
            }
        } else {
            MidiUtils.TempoCache tempoCache = this.tempoCache;
            synchronized (tempoCache) {
                this.setTickPosition(MidiUtils.microsecond2tick(this.sequence, l2, this.tempoCache));
            }
        }
    }

    public void setMasterSyncMode(Sequencer.SyncMode syncMode) {
        if (this.seqBridge != null) {
            this.seqBridge.setMasterSyncMode(syncMode);
            return;
        }
    }

    public Sequencer.SyncMode getMasterSyncMode() {
        if (this.seqBridge != null) {
            return this.seqBridge.getMasterSyncMode();
        }
        return masterSyncMode;
    }

    public Sequencer.SyncMode[] getMasterSyncModes() {
        if (this.seqBridge != null) {
            return this.seqBridge.getMasterSyncModes();
        }
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[masterSyncModes.length];
        System.arraycopy(masterSyncModes, 0, syncModeArray, 0, masterSyncModes.length);
        return syncModeArray;
    }

    public void setSlaveSyncMode(Sequencer.SyncMode syncMode) {
        if (this.seqBridge != null) {
            this.seqBridge.setSlaveSyncMode(syncMode);
            return;
        }
    }

    public Sequencer.SyncMode getSlaveSyncMode() {
        if (this.seqBridge != null) {
            return this.seqBridge.getSlaveSyncMode();
        }
        return slaveSyncMode;
    }

    public Sequencer.SyncMode[] getSlaveSyncModes() {
        if (this.seqBridge != null) {
            return this.seqBridge.getSlaveSyncModes();
        }
        Sequencer.SyncMode[] syncModeArray = new Sequencer.SyncMode[slaveSyncModes.length];
        System.arraycopy(slaveSyncModes, 0, syncModeArray, 0, slaveSyncModes.length);
        return syncModeArray;
    }

    protected int getTrackCount() {
        Sequence sequence = this.getSequence();
        if (sequence != null) {
            return this.sequence.getTracks().length;
        }
        return 0;
    }

    public synchronized void setTrackMute(int n2, boolean bl2) {
        if (this.seqBridge != null) {
            this.seqBridge.setTrackMute(n2, bl2);
            return;
        }
        int n3 = this.getTrackCount();
        if (n2 < 0 || n2 >= this.getTrackCount()) {
            return;
        }
        this.trackMuted = RealTimeSequencer.ensureBoolArraySize(this.trackMuted, n3);
        this.trackMuted[n2] = bl2;
        if (this.getDataPump() != null) {
            this.getDataPump().muteSoloChanged();
        }
    }

    public synchronized boolean getTrackMute(int n2) {
        if (this.seqBridge != null) {
            return this.seqBridge.getTrackMute(n2);
        }
        if (n2 < 0 || n2 >= this.getTrackCount()) {
            return false;
        }
        if (this.trackMuted == null || this.trackMuted.length <= n2) {
            return false;
        }
        return this.trackMuted[n2];
    }

    public synchronized void setTrackSolo(int n2, boolean bl2) {
        if (this.seqBridge != null) {
            this.seqBridge.setTrackSolo(n2, bl2);
            return;
        }
        int n3 = this.getTrackCount();
        if (n2 < 0 || n2 >= this.getTrackCount()) {
            return;
        }
        this.trackSolo = RealTimeSequencer.ensureBoolArraySize(this.trackSolo, n3);
        this.trackSolo[n2] = bl2;
        if (this.getDataPump() != null) {
            this.getDataPump().muteSoloChanged();
        }
    }

    public synchronized boolean getTrackSolo(int n2) {
        if (this.seqBridge != null) {
            return this.seqBridge.getTrackSolo(n2);
        }
        if (n2 < 0 || n2 >= this.getTrackCount()) {
            return false;
        }
        if (this.trackSolo == null || this.trackSolo.length <= n2) {
            return false;
        }
        return this.trackSolo[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMetaEventListener(MetaEventListener metaEventListener) {
        if (this.seqBridge != null) {
            this.seqBridge.addMetaEventListener(metaEventListener);
        }
        ArrayList arrayList = this.metaEventListeners;
        synchronized (arrayList) {
            if (!this.metaEventListeners.contains(metaEventListener)) {
                this.metaEventListeners.add(metaEventListener);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetaEventListener(MetaEventListener metaEventListener) {
        if (this.seqBridge != null) {
            this.seqBridge.removeMetaEventListener(metaEventListener);
        }
        ArrayList arrayList = this.metaEventListeners;
        synchronized (arrayList) {
            int n2 = this.metaEventListeners.indexOf(metaEventListener);
            if (n2 >= 0) {
                this.metaEventListeners.remove(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] addControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        if (this.seqBridge != null) {
            this.seqBridge.addControllerEventListener(controllerEventListener, nArray);
        }
        ArrayList arrayList = this.controllerEventListeners;
        synchronized (arrayList) {
            ControllerListElement controllerListElement = null;
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.controllerEventListeners.size(); ++i2) {
                controllerListElement = (ControllerListElement)this.controllerEventListeners.get(i2);
                if (!controllerListElement.listener.equals(controllerEventListener)) continue;
                controllerListElement.addControllers(nArray);
                bl2 = true;
                break;
            }
            if (!bl2) {
                controllerListElement = new ControllerListElement(controllerEventListener, nArray);
                this.controllerEventListeners.add(controllerListElement);
            }
            return controllerListElement.getControllers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] removeControllerEventListener(ControllerEventListener controllerEventListener, int[] nArray) {
        if (this.seqBridge != null) {
            this.seqBridge.removeControllerEventListener(controllerEventListener, nArray);
        }
        ArrayList arrayList = this.controllerEventListeners;
        synchronized (arrayList) {
            int n2;
            ControllerListElement controllerListElement = null;
            boolean bl2 = false;
            for (n2 = 0; n2 < this.controllerEventListeners.size(); ++n2) {
                controllerListElement = (ControllerListElement)this.controllerEventListeners.get(n2);
                if (!controllerListElement.listener.equals(controllerEventListener)) continue;
                controllerListElement.removeControllers(nArray);
                bl2 = true;
                break;
            }
            if (!bl2) {
                return new int[0];
            }
            if (nArray == null) {
                n2 = this.controllerEventListeners.indexOf(controllerListElement);
                if (n2 >= 0) {
                    this.controllerEventListeners.remove(n2);
                }
                return new int[0];
            }
            return controllerListElement.getControllers();
        }
    }

    public void setLoopStartPoint(long l2) {
        if (this.seqBridge != null) {
            this.seqBridge.setLoopStartPoint(l2);
            return;
        }
        if (l2 > this.getTickLength() || this.loopEnd != -1L && l2 > this.loopEnd || l2 < 0L) {
            throw new IllegalArgumentException("invalid loop start point: " + l2);
        }
        this.loopStart = l2;
    }

    public long getLoopStartPoint() {
        if (this.seqBridge != null) {
            return this.seqBridge.getLoopStartPoint();
        }
        return this.loopStart;
    }

    public void setLoopEndPoint(long l2) {
        if (this.seqBridge != null) {
            this.seqBridge.setLoopEndPoint(l2);
            return;
        }
        if (l2 > this.getTickLength() || this.loopStart > l2 && l2 != -1L || l2 < -1L) {
            throw new IllegalArgumentException("invalid loop end point: " + l2);
        }
        this.loopEnd = l2;
    }

    public long getLoopEndPoint() {
        if (this.seqBridge != null) {
            return this.seqBridge.getLoopEndPoint();
        }
        return this.loopEnd;
    }

    public void setLoopCount(int n2) {
        if (this.seqBridge != null) {
            this.seqBridge.setLoopCount(n2);
            return;
        }
        if (n2 != -1 && n2 < 0) {
            throw new IllegalArgumentException("illegal value for loop count: " + n2);
        }
        this.loopCount = n2;
        if (this.getDataPump() != null) {
            this.getDataPump().resetLoopCount();
        }
    }

    public int getLoopCount() {
        if (this.seqBridge != null) {
            return this.seqBridge.getLoopCount();
        }
        return this.loopCount;
    }

    protected void implOpen() throws MidiUnavailableException {
        if (this.seqBridge != null) {
            this.seqBridge.open();
            return;
        }
        this.playThread = new PlayThread();
        if (this.sequence != null) {
            this.playThread.setSequence(this.sequence);
        }
        this.propagateCaches();
        if (this.doAutoConnectAtNextOpen) {
            this.doAutoConnect();
        }
    }

    private void doAutoConnect() {
        Receiver receiver = null;
        try {
            Synthesizer synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            if (synthesizer instanceof ReferenceCountingDevice) {
                receiver = ((ReferenceCountingDevice)((Object)synthesizer)).getReceiverReferenceCounting();
                if (synthesizer.getClass().toString().contains("com.sun.media.sound.MixerSynth") && synthesizer.getDefaultSoundbank() == null) {
                    receiver = null;
                    synthesizer.close();
                }
            } else {
                receiver = synthesizer.getReceiver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (receiver == null) {
            try {
                receiver = MidiSystem.getReceiver();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (receiver != null) {
            this.autoConnectedReceiver = receiver;
            try {
                this.getTransmitter().setReceiver(receiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void propagateCaches() {
        if (this.sequence != null && this.isOpen()) {
            if (this.cacheTempoFactor != -1.0f) {
                this.setTempoFactor(this.cacheTempoFactor);
            }
            if (this.cacheTempoMPQ == -1.0) {
                this.setTempoInMPQ(new MidiUtils.TempoCache(this.sequence).getTempoMPQAt(this.getTickPosition()));
            } else {
                this.setTempoInMPQ((float)this.cacheTempoMPQ);
            }
        }
    }

    private synchronized void setCaches() {
        this.cacheTempoFactor = this.getTempoFactor();
        this.cacheTempoMPQ = this.getTempoInMPQ();
    }

    protected synchronized void implClose() {
        if (this.seqBridge != null) {
            this.seqBridge.close();
        }
        if (this.playThread != null) {
            this.playThread.close();
            this.playThread = null;
        }
        super.implClose();
        this.sequence = null;
        this.running = false;
        this.cacheTempoMPQ = -1.0;
        this.cacheTempoFactor = -1.0f;
        this.trackMuted = null;
        this.trackSolo = null;
        this.loopStart = 0L;
        this.loopEnd = -1L;
        this.loopCount = 0;
        this.doAutoConnectAtNextOpen = this.autoConnect;
        if (this.autoConnectedReceiver != null) {
            try {
                this.autoConnectedReceiver.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.autoConnectedReceiver = null;
        }
    }

    protected void implStart() {
        if (this.playThread == null) {
            return;
        }
        this.tempoCache.refresh(this.sequence);
        if (!this.running) {
            this.running = true;
            this.playThread.start();
        }
    }

    protected void implStop() {
        if (this.playThread == null) {
            return;
        }
        this.recording = false;
        if (this.running) {
            this.running = false;
            this.playThread.stop();
        }
    }

    protected void sendMetaEvents(MidiMessage midiMessage) {
        if (this.metaEventListeners.size() == 0) {
            return;
        }
        eventDispatcher.sendAudioEvents(midiMessage, this.metaEventListeners);
    }

    protected void sendControllerEvents(MidiMessage midiMessage) {
        int n2 = this.controllerEventListeners.size();
        if (n2 == 0) {
            return;
        }
        if (!(midiMessage instanceof ShortMessage)) {
            return;
        }
        ShortMessage shortMessage = (ShortMessage)midiMessage;
        int n3 = shortMessage.getData1();
        ArrayList<ControllerEventListener> arrayList = new ArrayList<ControllerEventListener>();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            ControllerListElement controllerListElement = (ControllerListElement)this.controllerEventListeners.get(i2);
            for (int i3 = 0; i3 < controllerListElement.controllers.length; ++i3) {
                if (controllerListElement.controllers[i3] != n3) continue;
                arrayList.add(controllerListElement.listener);
                continue block0;
            }
        }
        eventDispatcher.sendAudioEvents(midiMessage, arrayList);
    }

    private boolean needCaching() {
        return !this.isOpen() || this.sequence == null || this.playThread == null;
    }

    private DataPump getDataPump() {
        if (this.playThread != null) {
            return this.playThread.getDataPump();
        }
        return null;
    }

    private MidiUtils.TempoCache getTempoCache() {
        return this.tempoCache;
    }

    private static boolean[] ensureBoolArraySize(boolean[] blArray, int n2) {
        if (blArray == null) {
            return new boolean[n2];
        }
        if (blArray.length < n2) {
            boolean[] blArray2 = new boolean[n2];
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
            return blArray2;
        }
        return blArray;
    }

    protected boolean hasReceivers() {
        return this.seqBridge == null;
    }

    protected Receiver createReceiver() throws MidiUnavailableException {
        return new SequencerReceiver();
    }

    protected boolean hasTransmitters() {
        return this.seqBridge == null;
    }

    protected Transmitter createTransmitter() throws MidiUnavailableException {
        return new SequencerTransmitter();
    }

    public void setAutoConnect(Receiver receiver) {
        this.autoConnect = receiver != null;
        this.autoConnectedReceiver = receiver;
    }

    static {
        info = new RealTimeSequencerInfo();
        masterSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.INTERNAL_CLOCK};
        slaveSyncModes = new Sequencer.SyncMode[]{Sequencer.SyncMode.NO_SYNC};
        masterSyncMode = Sequencer.SyncMode.INTERNAL_CLOCK;
        slaveSyncMode = Sequencer.SyncMode.NO_SYNC;
        eventDispatcher = new EventDispatcher();
        eventDispatcher.start();
    }

    private class ControllerListElement {
        int[] controllers;
        ControllerEventListener listener;

        private ControllerListElement(ControllerEventListener controllerEventListener, int[] nArray) {
            this.listener = controllerEventListener;
            if (nArray == null) {
                nArray = new int[128];
                for (int i2 = 0; i2 < 128; ++i2) {
                    nArray[i2] = i2;
                }
            }
            this.controllers = nArray;
        }

        private void addControllers(int[] nArray) {
            int n2;
            int n3;
            if (nArray == null) {
                this.controllers = new int[128];
                for (int i2 = 0; i2 < 128; ++i2) {
                    this.controllers[i2] = i2;
                }
                return;
            }
            int[] nArray2 = new int[this.controllers.length + nArray.length];
            for (n3 = 0; n3 < this.controllers.length; ++n3) {
                nArray2[n3] = this.controllers[n3];
            }
            int n4 = this.controllers.length;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = 0;
                for (int i3 = 0; i3 < this.controllers.length; ++i3) {
                    if (nArray[n3] != this.controllers[i3]) continue;
                    n2 = 1;
                    break;
                }
                if (n2 != 0) continue;
                nArray2[n4++] = nArray[n3];
            }
            int[] nArray3 = new int[n4];
            for (n2 = 0; n2 < n4; ++n2) {
                nArray3[n2] = nArray2[n2];
            }
            this.controllers = nArray3;
        }

        private void removeControllers(int[] nArray) {
            if (nArray == null) {
                this.controllers = new int[0];
            } else {
                int n2;
                int[] nArray2 = new int[this.controllers.length];
                int n3 = 0;
                for (int i2 = 0; i2 < this.controllers.length; ++i2) {
                    n2 = 0;
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        if (this.controllers[i2] != nArray[i3]) continue;
                        n2 = 1;
                        break;
                    }
                    if (n2 != 0) continue;
                    nArray2[n3++] = this.controllers[i2];
                }
                int[] nArray3 = new int[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    nArray3[n2] = nArray2[n2];
                }
                this.controllers = nArray3;
            }
        }

        private int[] getControllers() {
            if (this.controllers == null) {
                return null;
            }
            int[] nArray = new int[this.controllers.length];
            for (int i2 = 0; i2 < this.controllers.length; ++i2) {
                nArray[i2] = this.controllers[i2];
            }
            return nArray;
        }
    }

    private class DataPump {
        private float currTempo;
        private float tempoFactor;
        private float inverseTempoFactor;
        private long ignoreTempoEventAt;
        private int resolution;
        private float divisionType;
        private long checkPointMillis;
        private long checkPointTick;
        private int[] noteOnCache;
        private Track[] tracks;
        private boolean[] trackDisabled;
        private int[] trackReadPos;
        private long lastTick;
        private boolean needReindex = false;
        private int currLoopCounter = 0;

        DataPump() {
            this.init();
        }

        synchronized void init() {
            this.ignoreTempoEventAt = -1L;
            this.tempoFactor = 1.0f;
            this.inverseTempoFactor = 1.0f;
            this.noteOnCache = new int[128];
            this.tracks = null;
            this.trackDisabled = null;
        }

        synchronized void setTickPos(long l2) {
            long l3 = l2;
            this.lastTick = l2;
            if (RealTimeSequencer.this.running) {
                this.notesOff(false);
            }
            if (RealTimeSequencer.this.running || l2 > 0L) {
                this.chaseEvents(l3, l2);
            } else {
                this.needReindex = true;
            }
            if (!this.hasCachedTempo()) {
                this.setTempoMPQ(RealTimeSequencer.this.getTempoCache().getTempoMPQAt(this.lastTick, this.currTempo));
                this.ignoreTempoEventAt = -1L;
            }
            this.checkPointMillis = 0L;
        }

        long getTickPos() {
            return this.lastTick;
        }

        boolean hasCachedTempo() {
            if (this.ignoreTempoEventAt != this.lastTick) {
                this.ignoreTempoEventAt = -1L;
            }
            return this.ignoreTempoEventAt >= 0L;
        }

        synchronized void setTempoMPQ(float f2) {
            if (f2 > 0.0f && f2 != this.currTempo) {
                this.ignoreTempoEventAt = this.lastTick;
                this.currTempo = f2;
                this.checkPointMillis = 0L;
            }
        }

        float getTempoMPQ() {
            return this.currTempo;
        }

        synchronized void setTempoFactor(float f2) {
            if (f2 > 0.0f && f2 != this.tempoFactor) {
                this.tempoFactor = f2;
                this.inverseTempoFactor = 1.0f / f2;
                this.checkPointMillis = 0L;
            }
        }

        float getTempoFactor() {
            return this.tempoFactor;
        }

        synchronized void muteSoloChanged() {
            boolean[] blArray = this.makeDisabledArray();
            if (RealTimeSequencer.this.running) {
                this.applyDisabledTracks(this.trackDisabled, blArray);
            }
            this.trackDisabled = blArray;
        }

        synchronized void setSequence(Sequence sequence) {
            if (sequence == null) {
                this.init();
                return;
            }
            this.tracks = sequence.getTracks();
            this.muteSoloChanged();
            this.resolution = sequence.getResolution();
            this.divisionType = sequence.getDivisionType();
            this.trackReadPos = new int[this.tracks.length];
            this.checkPointMillis = 0L;
            this.needReindex = true;
        }

        synchronized void resetLoopCount() {
            this.currLoopCounter = RealTimeSequencer.this.loopCount;
        }

        void clearNoteOnCache() {
            for (int i2 = 0; i2 < 128; ++i2) {
                this.noteOnCache[i2] = 0;
            }
        }

        void notesOff(boolean bl2) {
            int n2 = 0;
            for (int i2 = 0; i2 < 16; ++i2) {
                int n3 = 1 << i2;
                for (int i3 = 0; i3 < 128; ++i3) {
                    if ((this.noteOnCache[i3] & n3) == 0) continue;
                    int n4 = i3;
                    this.noteOnCache[n4] = this.noteOnCache[n4] ^ n3;
                    RealTimeSequencer.this.getTransmitterList().sendMessage(0x90 | i2 | i3 << 8, -1L);
                    ++n2;
                }
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | i2 | 0x7B00, -1L);
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | i2 | 0x4000, -1L);
                if (!bl2) continue;
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | i2 | 0x7900, -1L);
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean[] makeDisabledArray() {
            int n2;
            boolean[] blArray;
            boolean[] blArray2;
            if (this.tracks == null) {
                return null;
            }
            boolean[] blArray3 = new boolean[this.tracks.length];
            RealTimeSequencer realTimeSequencer = RealTimeSequencer.this;
            synchronized (realTimeSequencer) {
                blArray2 = RealTimeSequencer.this.trackMuted;
                blArray = RealTimeSequencer.this.trackSolo;
            }
            boolean bl2 = false;
            if (blArray != null) {
                for (n2 = 0; n2 < blArray.length; ++n2) {
                    if (!blArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                for (n2 = 0; n2 < blArray3.length; ++n2) {
                    blArray3[n2] = n2 >= blArray.length || !blArray[n2];
                }
            } else {
                for (n2 = 0; n2 < blArray3.length; ++n2) {
                    blArray3[n2] = blArray2 != null && n2 < blArray2.length && blArray2[n2];
                }
            }
            return blArray3;
        }

        private void sendNoteOffIfOn(Track track, long l2) {
            int n2 = track.size();
            int n3 = 0;
            try {
                MidiEvent midiEvent;
                for (int i2 = 0; i2 < n2 && (midiEvent = track.get(i2)).getTick() <= l2; ++i2) {
                    int n4;
                    Object object;
                    MidiMessage midiMessage = midiEvent.getMessage();
                    int n5 = midiMessage.getStatus();
                    int n6 = midiMessage.getLength();
                    if (n6 != 3 || (n5 & 0xF0) != 144) continue;
                    int n7 = -1;
                    if (midiMessage instanceof ShortMessage) {
                        object = (ShortMessage)midiMessage;
                        if (((ShortMessage)object).getData2() > 0) {
                            n7 = ((ShortMessage)object).getData1();
                        }
                    } else {
                        object = midiMessage.getMessage();
                        if ((object[2] & 0x7F) > 0) {
                            n7 = object[1] & 0x7F;
                        }
                    }
                    if (n7 < 0 || (this.noteOnCache[n7] & (n4 = 1 << (n5 & 0xF))) == 0) continue;
                    RealTimeSequencer.this.getTransmitterList().sendMessage(n5 | n7 << 8, -1L);
                    int n8 = n7;
                    this.noteOnCache[n8] = this.noteOnCache[n8] & (0xFFFF ^ n4);
                    ++n3;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyDisabledTracks(boolean[] blArray, boolean[] blArray2) {
            byte[][] byArray = null;
            RealTimeSequencer realTimeSequencer = RealTimeSequencer.this;
            synchronized (realTimeSequencer) {
                for (int i2 = 0; i2 < blArray2.length; ++i2) {
                    if ((blArray == null || i2 >= blArray.length || !blArray[i2]) && blArray2[i2]) {
                        if (this.tracks.length <= i2) continue;
                        this.sendNoteOffIfOn(this.tracks[i2], this.lastTick);
                        continue;
                    }
                    if (blArray == null || i2 >= blArray.length || !blArray[i2] || blArray2[i2]) continue;
                    if (byArray == null) {
                        byArray = new byte[128][16];
                    }
                    this.chaseTrackEvents(i2, 0L, this.lastTick, true, byArray);
                }
            }
        }

        private void chaseTrackEvents(int n2, long l2, long l3, boolean bl2, byte[][] byArray) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (l2 > l3) {
                l2 = 0L;
            }
            byte[] byArray2 = new byte[16];
            for (int i2 = 0; i2 < 16; ++i2) {
                byArray2[i2] = -1;
                for (n6 = 0; n6 < 128; ++n6) {
                    byArray[n6][i2] = -1;
                }
            }
            Track track = this.tracks[n2];
            n6 = track.size();
            try {
                for (n5 = 0; n5 < n6; ++n5) {
                    Object object;
                    MidiEvent midiEvent = track.get(n5);
                    if (midiEvent.getTick() >= l3) {
                        if (bl2 && n2 < this.trackReadPos.length) {
                            this.trackReadPos[n2] = n5 > 0 ? n5 - 1 : 0;
                        }
                        break;
                    }
                    MidiMessage midiMessage = midiEvent.getMessage();
                    n4 = midiMessage.getStatus();
                    n3 = midiMessage.getLength();
                    if (n3 == 3 && (n4 & 0xF0) == 176) {
                        if (midiMessage instanceof ShortMessage) {
                            object = (ShortMessage)midiMessage;
                            byArray[((ShortMessage)object).getData1() & 0x7F][n4 & 0xF] = (byte)((ShortMessage)object).getData2();
                        } else {
                            object = midiMessage.getMessage();
                            byArray[object[1] & 0x7F][n4 & 0xF] = (byte)object[2];
                        }
                    }
                    if (n3 != 2 || (n4 & 0xF0) != 192) continue;
                    if (midiMessage instanceof ShortMessage) {
                        object = (ShortMessage)midiMessage;
                        byArray2[n4 & 0xF] = (byte)((ShortMessage)object).getData1();
                        continue;
                    }
                    object = midiMessage.getMessage();
                    byArray2[n4 & 0xF] = (byte)object[1];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            n5 = 0;
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 128; ++i4) {
                    n4 = byArray[i4][i3];
                    if (n4 < 0) continue;
                    n3 = 0xB0 | i3 | i4 << 8 | n4 << 16;
                    RealTimeSequencer.this.getTransmitterList().sendMessage(n3, -1L);
                    ++n5;
                }
                if (byArray2[i3] >= 0) {
                    RealTimeSequencer.this.getTransmitterList().sendMessage(0xC0 | i3 | byArray2[i3] << 8, -1L);
                }
                if (byArray2[i3] < 0 && l2 != 0L && l3 != 0L) continue;
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xE0 | i3 | 0x400000, -1L);
                RealTimeSequencer.this.getTransmitterList().sendMessage(0xB0 | i3 | 0x4000, -1L);
            }
        }

        synchronized void chaseEvents(long l2, long l3) {
            byte[][] byArray = new byte[128][16];
            for (int i2 = 0; i2 < this.tracks.length; ++i2) {
                if (this.trackDisabled != null && this.trackDisabled.length > i2 && this.trackDisabled[i2]) continue;
                this.chaseTrackEvents(i2, l2, l3, true, byArray);
            }
        }

        private long getCurrentTimeMillis() {
            return System.nanoTime() / 1000000L;
        }

        private long millis2tick(long l2) {
            if (this.divisionType != 0.0f) {
                double d2 = (double)l2 * (double)this.tempoFactor * (double)this.divisionType * (double)this.resolution / 1000.0;
                return (long)d2;
            }
            return MidiUtils.microsec2ticks(l2 * 1000L, this.currTempo * this.inverseTempoFactor, this.resolution);
        }

        private long tick2millis(long l2) {
            if (this.divisionType != 0.0f) {
                double d2 = (double)l2 * 1000.0 / ((double)this.tempoFactor * (double)this.divisionType * (double)this.resolution);
                return (long)d2;
            }
            return MidiUtils.ticks2microsec(l2, this.currTempo * this.inverseTempoFactor, this.resolution) / 1000L;
        }

        private void ReindexTrack(int n2, long l2) {
            if (n2 < this.trackReadPos.length && n2 < this.tracks.length) {
                this.trackReadPos[n2] = MidiUtils.tick2index(this.tracks[n2], l2);
            }
        }

        private boolean dispatchMessage(int n2, MidiEvent midiEvent) {
            boolean bl2 = false;
            MidiMessage midiMessage = midiEvent.getMessage();
            int n3 = midiMessage.getStatus();
            int n4 = midiMessage.getLength();
            if (n3 == 255 && n4 >= 2) {
                int n5;
                if (n2 == 0 && (n5 = MidiUtils.getTempoMPQ(midiMessage)) > 0) {
                    if (midiEvent.getTick() != this.ignoreTempoEventAt) {
                        this.setTempoMPQ(n5);
                        bl2 = true;
                    }
                    this.ignoreTempoEventAt = -1L;
                }
                RealTimeSequencer.this.sendMetaEvents(midiMessage);
            } else {
                RealTimeSequencer.this.getTransmitterList().sendMessage(midiMessage, -1L);
                switch (n3 & 0xF0) {
                    case 128: {
                        int n6;
                        int n7 = n6 = ((ShortMessage)midiMessage).getData1() & 0x7F;
                        this.noteOnCache[n7] = this.noteOnCache[n7] & (0xFFFF ^ 1 << (n3 & 0xF));
                        break;
                    }
                    case 144: {
                        ShortMessage shortMessage = (ShortMessage)midiMessage;
                        int n8 = shortMessage.getData1() & 0x7F;
                        int n9 = shortMessage.getData2() & 0x7F;
                        if (n9 > 0) {
                            int n10 = n8;
                            this.noteOnCache[n10] = this.noteOnCache[n10] | 1 << (n3 & 0xF);
                            break;
                        }
                        int n11 = n8;
                        this.noteOnCache[n11] = this.noteOnCache[n11] & (0xFFFF ^ 1 << (n3 & 0xF));
                        break;
                    }
                    case 176: {
                        RealTimeSequencer.this.sendControllerEvents(midiMessage);
                    }
                }
            }
            return bl2;
        }

        synchronized boolean pump() {
            long l2 = this.lastTick;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            long l3 = this.getCurrentTimeMillis();
            int n2 = 0;
            do {
                int n3;
                bl2 = false;
                if (this.needReindex) {
                    if (this.trackReadPos.length < this.tracks.length) {
                        this.trackReadPos = new int[this.tracks.length];
                    }
                    for (n3 = 0; n3 < this.tracks.length; ++n3) {
                        this.ReindexTrack(n3, l2);
                    }
                    this.needReindex = false;
                    this.checkPointMillis = 0L;
                }
                if (this.checkPointMillis == 0L) {
                    this.checkPointMillis = l3 = this.getCurrentTimeMillis();
                    this.checkPointTick = l2 = this.lastTick;
                } else {
                    l2 = this.checkPointTick + this.millis2tick(l3 - this.checkPointMillis);
                    if (RealTimeSequencer.this.loopEnd != -1L && (RealTimeSequencer.this.loopCount > 0 && this.currLoopCounter > 0 || RealTimeSequencer.this.loopCount == -1) && this.lastTick <= RealTimeSequencer.this.loopEnd && l2 >= RealTimeSequencer.this.loopEnd) {
                        l2 = RealTimeSequencer.this.loopEnd - 1L;
                        bl3 = true;
                    }
                    this.lastTick = l2;
                }
                n2 = 0;
                for (n3 = 0; n3 < this.tracks.length; ++n3) {
                    block14: {
                        try {
                            MidiEvent midiEvent;
                            int n4;
                            boolean bl5 = this.trackDisabled[n3];
                            Track track = this.tracks[n3];
                            int n5 = track.size();
                            for (n4 = this.trackReadPos[n3]; !bl2 && n4 < n5 && (midiEvent = track.get(n4)).getTick() <= l2; ++n4) {
                                if (n4 != n5 - 1 || !MidiUtils.isMetaEndOfTrack(midiEvent.getMessage())) continue;
                                n4 = n5;
                                break;
                            }
                            if (n4 >= n5) {
                                ++n2;
                            }
                            this.trackReadPos[n3] = n4;
                        }
                        catch (Exception exception) {
                            if (!(exception instanceof ArrayIndexOutOfBoundsException)) break block14;
                            this.needReindex = true;
                            bl2 = true;
                        }
                    }
                    if (bl2) break;
                }
                boolean bl6 = bl4 = n2 == this.tracks.length;
                if (!bl3 && ((RealTimeSequencer.this.loopCount <= 0 || this.currLoopCounter <= 0) && RealTimeSequencer.this.loopCount != -1 || bl2 || RealTimeSequencer.this.loopEnd != -1L || !bl4)) continue;
                long l4 = this.checkPointMillis;
                long l5 = RealTimeSequencer.this.loopEnd;
                if (l5 == -1L) {
                    l5 = this.lastTick;
                }
                if (RealTimeSequencer.this.loopCount != -1) {
                    --this.currLoopCounter;
                }
                this.setTickPos(RealTimeSequencer.this.loopStart);
                this.checkPointMillis = l4 + this.tick2millis(l5 - this.checkPointTick);
                this.checkPointTick = RealTimeSequencer.this.loopStart;
                this.needReindex = false;
                bl2 = false;
                bl3 = false;
                bl4 = false;
            } while (bl2);
            return bl4;
        }
    }

    class PlayThread
    implements Runnable {
        private Thread thread;
        private Object lock = new Object();
        boolean interrupted = false;
        boolean isPumping = false;
        private DataPump dataPump = new DataPump();

        PlayThread() {
            int n2 = 8;
            this.thread = JSSecurityManager.createThread(this, "Java Sound Sequencer", false, n2, true);
        }

        DataPump getDataPump() {
            return this.dataPump;
        }

        synchronized void setSequence(Sequence sequence) {
            this.dataPump.setSequence(sequence);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void start() {
            RealTimeSequencer.this.running = true;
            if (!this.dataPump.hasCachedTempo()) {
                long l2 = RealTimeSequencer.this.getTickPosition();
                this.dataPump.setTempoMPQ(RealTimeSequencer.this.tempoCache.getTempoMPQAt(l2));
            }
            this.dataPump.checkPointMillis = 0L;
            this.dataPump.clearNoteOnCache();
            this.dataPump.needReindex = true;
            this.dataPump.resetLoopCount();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stop() {
            this.playThreadImplStop();
            long l2 = System.nanoTime() / 1000000L;
            while (this.isPumping) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        this.lock.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (System.nanoTime() / 1000000L - l2 <= 1900L) continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void playThreadImplStop() {
            RealTimeSequencer.this.running = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Thread thread = null;
            Object object = this;
            synchronized (object) {
                this.interrupted = true;
                thread = this.thread;
                this.thread = null;
            }
            if (thread != null) {
                object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            if (thread != null) {
                try {
                    thread.join(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                Object object;
                boolean bl2 = false;
                boolean bl3 = RealTimeSequencer.this.running;
                boolean bl4 = this.isPumping = !this.interrupted && RealTimeSequencer.this.running;
                while (!bl2 && !this.interrupted && RealTimeSequencer.this.running) {
                    bl2 = this.dataPump.pump();
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.playThreadImplStop();
                if (bl3) {
                    this.dataPump.notesOff(true);
                }
                if (bl2) {
                    this.dataPump.setTickPos(RealTimeSequencer.this.sequence.getTickLength());
                    object = new MetaMessage();
                    try {
                        ((MetaMessage)object).setMessage(47, new byte[0], 0);
                    }
                    catch (InvalidMidiDataException invalidMidiDataException) {
                        // empty catch block
                    }
                    RealTimeSequencer.this.sendMetaEvents((MidiMessage)object);
                }
                object = this.lock;
                synchronized (object) {
                    this.isPumping = false;
                    this.lock.notifyAll();
                    while (!RealTimeSequencer.this.running && !this.interrupted) {
                        try {
                            this.lock.wait();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    private static class RealTimeSequencerInfo
    extends MidiDevice.Info {
        private static final String name = "Real Time Sequencer";
        private static final String vendor = "Sun Microsystems";
        private static final String description = "Software sequencer";
        private static final String version = "Version 1.0";

        private RealTimeSequencerInfo() {
            super(name, vendor, description, version);
        }
    }

    static class RecordingTrack {
        private Track track;
        private int channel;

        RecordingTrack(Track track, int n2) {
            this.track = track;
            this.channel = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RecordingTrack get(List list, Track track) {
            List list2 = list;
            synchronized (list2) {
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    RecordingTrack recordingTrack = (RecordingTrack)list.get(i2);
                    if (recordingTrack.track != track) continue;
                    return recordingTrack;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Track get(List list, int n2) {
            List list2 = list;
            synchronized (list2) {
                int n3 = list.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    RecordingTrack recordingTrack = (RecordingTrack)list.get(i2);
                    if (recordingTrack.channel != n2 && recordingTrack.channel != -1) continue;
                    return recordingTrack.track;
                }
            }
            return null;
        }
    }

    class SequencerReceiver
    extends AbstractMidiDevice.AbstractReceiver {
        SequencerReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void implSend(MidiMessage midiMessage, long l2) {
            if (RealTimeSequencer.this.recording) {
                Object object;
                long l3 = 0L;
                if (l2 < 0L) {
                    l3 = RealTimeSequencer.this.getTickPosition();
                } else {
                    object = RealTimeSequencer.this.tempoCache;
                    synchronized (object) {
                        l3 = MidiUtils.microsecond2tick(RealTimeSequencer.this.sequence, l2, RealTimeSequencer.this.tempoCache);
                    }
                }
                object = new MidiEvent(midiMessage, l3);
                Track track = null;
                track = midiMessage instanceof ShortMessage ? RecordingTrack.get(RealTimeSequencer.this.recordingTracks, ((ShortMessage)midiMessage).getChannel()) : RecordingTrack.get(RealTimeSequencer.this.recordingTracks, -1);
                if (track != null) {
                    track.add((MidiEvent)object);
                }
            }
        }
    }

    private class SequencerTransmitter
    extends AbstractMidiDevice.BasicTransmitter {
        private SequencerTransmitter() {
        }
    }
}

