/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs;

import com.sun.org.apache.xerces.internal.impl.xs.XSAnnotationImpl;
import com.sun.org.apache.xerces.internal.impl.xs.XSParticleDecl;
import com.sun.org.apache.xerces.internal.impl.xs.util.XSObjectListImpl;
import com.sun.org.apache.xerces.internal.xs.XSAnnotation;
import com.sun.org.apache.xerces.internal.xs.XSModelGroup;
import com.sun.org.apache.xerces.internal.xs.XSNamespaceItem;
import com.sun.org.apache.xerces.internal.xs.XSObjectList;

public class XSModelGroupImpl
implements XSModelGroup {
    public static final short MODELGROUP_CHOICE = 101;
    public static final short MODELGROUP_SEQUENCE = 102;
    public static final short MODELGROUP_ALL = 103;
    public short fCompositor;
    public XSParticleDecl[] fParticles = null;
    public int fParticleCount = 0;
    public XSAnnotationImpl fAnnotation;
    private String fDescription = null;

    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.fParticleCount; ++i2) {
            if (this.fParticles[i2].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int minEffectiveTotalRange() {
        if (this.fCompositor == 101) {
            return this.minEffectiveTotalRangeChoice();
        }
        return this.minEffectiveTotalRangeAllSeq();
    }

    private int minEffectiveTotalRangeAllSeq() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fParticleCount; ++i2) {
            n2 += this.fParticles[i2].minEffectiveTotalRange();
        }
        return n2;
    }

    private int minEffectiveTotalRangeChoice() {
        int n2 = 0;
        if (this.fParticleCount > 0) {
            n2 = this.fParticles[0].minEffectiveTotalRange();
        }
        for (int i2 = 1; i2 < this.fParticleCount; ++i2) {
            int n3 = this.fParticles[i2].minEffectiveTotalRange();
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public int maxEffectiveTotalRange() {
        if (this.fCompositor == 101) {
            return this.maxEffectiveTotalRangeChoice();
        }
        return this.maxEffectiveTotalRangeAllSeq();
    }

    private int maxEffectiveTotalRangeAllSeq() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.fParticleCount; ++i2) {
            int n3 = this.fParticles[i2].maxEffectiveTotalRange();
            if (n3 == -1) {
                return -1;
            }
            n2 += n3;
        }
        return n2;
    }

    private int maxEffectiveTotalRangeChoice() {
        int n2 = 0;
        if (this.fParticleCount > 0 && (n2 = this.fParticles[0].minEffectiveTotalRange()) == -1) {
            return -1;
        }
        for (int i2 = 1; i2 < this.fParticleCount; ++i2) {
            int n3 = this.fParticles[i2].maxEffectiveTotalRange();
            if (n3 == -1) {
                return -1;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public String toString() {
        if (this.fDescription == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.fCompositor == 103) {
                stringBuffer.append("all(");
            } else {
                stringBuffer.append('(');
            }
            if (this.fParticleCount > 0) {
                stringBuffer.append(this.fParticles[0].toString());
            }
            for (int i2 = 1; i2 < this.fParticleCount; ++i2) {
                if (this.fCompositor == 101) {
                    stringBuffer.append('|');
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.fParticles[i2].toString());
            }
            stringBuffer.append(')');
            this.fDescription = stringBuffer.toString();
        }
        return this.fDescription;
    }

    public void reset() {
        this.fCompositor = (short)102;
        this.fParticles = null;
        this.fParticleCount = 0;
        this.fDescription = null;
        this.fAnnotation = null;
    }

    public short getType() {
        return 7;
    }

    public String getName() {
        return null;
    }

    public String getNamespace() {
        return null;
    }

    public short getCompositor() {
        if (this.fCompositor == 101) {
            return 2;
        }
        if (this.fCompositor == 102) {
            return 1;
        }
        return 3;
    }

    public XSObjectList getParticles() {
        return new XSObjectListImpl(this.fParticles, this.fParticleCount);
    }

    public XSAnnotation getAnnotation() {
        return this.fAnnotation;
    }

    public XSNamespaceItem getNamespaceItem() {
        return null;
    }
}

