/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.identity;

import com.sun.org.apache.xerces.internal.impl.xpath.XPath;
import com.sun.org.apache.xerces.internal.util.IntStack;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xs.AttributePSVI;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;

public class XPathMatcher {
    protected static final boolean DEBUG_ALL = false;
    protected static final boolean DEBUG_METHODS = false;
    protected static final boolean DEBUG_METHODS2 = false;
    protected static final boolean DEBUG_METHODS3 = false;
    protected static final boolean DEBUG_MATCH = false;
    protected static final boolean DEBUG_STACK = false;
    protected static final boolean DEBUG_ANY = false;
    protected static final int MATCHED = 1;
    protected static final int MATCHED_ATTRIBUTE = 3;
    protected static final int MATCHED_DESCENDANT = 5;
    protected static final int MATCHED_DESCENDANT_PREVIOUS = 13;
    private XPath.LocationPath[] fLocationPaths;
    private int[] fMatched;
    protected Object fMatchedString;
    private IntStack[] fStepIndexes;
    private int[] fCurrentStep;
    private int[] fNoMatchDepth;
    final QName fQName = new QName();

    public XPathMatcher(XPath xPath) {
        this.fLocationPaths = xPath.getLocationPaths();
        this.fStepIndexes = new IntStack[this.fLocationPaths.length];
        for (int i2 = 0; i2 < this.fStepIndexes.length; ++i2) {
            this.fStepIndexes[i2] = new IntStack();
        }
        this.fCurrentStep = new int[this.fLocationPaths.length];
        this.fNoMatchDepth = new int[this.fLocationPaths.length];
        this.fMatched = new int[this.fLocationPaths.length];
    }

    public boolean isMatched() {
        for (int i2 = 0; i2 < this.fLocationPaths.length; ++i2) {
            if ((this.fMatched[i2] & 1) != 1 || (this.fMatched[i2] & 0xD) == 13 || this.fNoMatchDepth[i2] != 0 && (this.fMatched[i2] & 5) != 5) continue;
            return true;
        }
        return false;
    }

    protected void handleContent(XSTypeDefinition xSTypeDefinition, boolean bl2, Object object) {
    }

    protected void matched(Object object, boolean bl2) {
    }

    public void startDocumentFragment() {
        this.fMatchedString = null;
        for (int i2 = 0; i2 < this.fLocationPaths.length; ++i2) {
            this.fStepIndexes[i2].clear();
            this.fCurrentStep[i2] = 0;
            this.fNoMatchDepth[i2] = 0;
            this.fMatched[i2] = 0;
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes) {
        for (int i2 = 0; i2 < this.fLocationPaths.length; ++i2) {
            XPath.NodeTest nodeTest;
            boolean bl2;
            int n2 = this.fCurrentStep[i2];
            this.fStepIndexes[i2].push(n2);
            if ((this.fMatched[i2] & 5) == 1 || this.fNoMatchDepth[i2] > 0) {
                int n3 = i2;
                this.fNoMatchDepth[n3] = this.fNoMatchDepth[n3] + 1;
                continue;
            }
            if ((this.fMatched[i2] & 5) == 5) {
                this.fMatched[i2] = 13;
            }
            XPath.Step[] stepArray = this.fLocationPaths[i2].steps;
            while (this.fCurrentStep[i2] < stepArray.length && stepArray[this.fCurrentStep[i2]].axis.type == 3) {
                int n4 = i2;
                this.fCurrentStep[n4] = this.fCurrentStep[n4] + 1;
            }
            if (this.fCurrentStep[i2] == stepArray.length) {
                this.fMatched[i2] = 1;
                continue;
            }
            int n5 = this.fCurrentStep[i2];
            while (this.fCurrentStep[i2] < stepArray.length && stepArray[this.fCurrentStep[i2]].axis.type == 4) {
                int n6 = i2;
                this.fCurrentStep[n6] = this.fCurrentStep[n6] + 1;
            }
            boolean bl3 = bl2 = this.fCurrentStep[i2] > n5;
            if (this.fCurrentStep[i2] == stepArray.length) {
                int n7 = i2;
                this.fNoMatchDepth[n7] = this.fNoMatchDepth[n7] + 1;
                continue;
            }
            if ((this.fCurrentStep[i2] == n2 || this.fCurrentStep[i2] > n5) && stepArray[this.fCurrentStep[i2]].axis.type == 1) {
                XPath.Step step = stepArray[this.fCurrentStep[i2]];
                nodeTest = step.nodeTest;
                if (nodeTest.type == 1 && !nodeTest.name.equals(qName)) {
                    if (this.fCurrentStep[i2] > n5) {
                        this.fCurrentStep[i2] = n5;
                        continue;
                    }
                    int n8 = i2;
                    this.fNoMatchDepth[n8] = this.fNoMatchDepth[n8] + 1;
                    continue;
                }
                int n9 = i2;
                this.fCurrentStep[n9] = this.fCurrentStep[n9] + 1;
            }
            if (this.fCurrentStep[i2] == stepArray.length) {
                if (bl2) {
                    this.fCurrentStep[i2] = n5;
                    this.fMatched[i2] = 5;
                    continue;
                }
                this.fMatched[i2] = 1;
                continue;
            }
            if (this.fCurrentStep[i2] >= stepArray.length || stepArray[this.fCurrentStep[i2]].axis.type != 2) continue;
            int n10 = xMLAttributes.getLength();
            if (n10 > 0) {
                nodeTest = stepArray[this.fCurrentStep[i2]].nodeTest;
                for (int i3 = 0; i3 < n10; ++i3) {
                    int n11;
                    xMLAttributes.getName(i3, this.fQName);
                    if (nodeTest.type == 1 && !nodeTest.name.equals(this.fQName)) continue;
                    int n12 = i2;
                    this.fCurrentStep[n12] = this.fCurrentStep[n12] + 1;
                    if (this.fCurrentStep[i2] != stepArray.length) break;
                    this.fMatched[i2] = 3;
                    for (n11 = 0; n11 < i2 && (this.fMatched[n11] & 1) != 1; ++n11) {
                    }
                    if (n11 != i2) break;
                    AttributePSVI attributePSVI = (AttributePSVI)xMLAttributes.getAugmentations(i3).getItem("ATTRIBUTE_PSVI");
                    this.fMatchedString = attributePSVI.getActualNormalizedValue();
                    this.matched(this.fMatchedString, false);
                    break;
                }
            }
            if ((this.fMatched[i2] & 1) == 1) continue;
            if (this.fCurrentStep[i2] > n5) {
                this.fCurrentStep[i2] = n5;
                continue;
            }
            int n13 = i2;
            this.fNoMatchDepth[n13] = this.fNoMatchDepth[n13] + 1;
        }
    }

    public void endElement(QName qName, XSTypeDefinition xSTypeDefinition, boolean bl2, Object object) {
        for (int i2 = 0; i2 < this.fLocationPaths.length; ++i2) {
            int n2;
            this.fCurrentStep[i2] = this.fStepIndexes[i2].pop();
            if (this.fNoMatchDepth[i2] > 0) {
                int n3 = i2;
                this.fNoMatchDepth[n3] = this.fNoMatchDepth[n3] - 1;
                continue;
            }
            for (n2 = 0; n2 < i2 && (this.fMatched[n2] & 1) != 1; ++n2) {
            }
            if (n2 < i2 || this.fMatched[n2] == 0 || (this.fMatched[n2] & 3) == 3) continue;
            this.handleContent(xSTypeDefinition, bl2, object);
            this.fMatched[i2] = 0;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.toString();
        int n2 = string.lastIndexOf(46);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        stringBuffer.append(string);
        for (int i2 = 0; i2 < this.fLocationPaths.length; ++i2) {
            stringBuffer.append('[');
            XPath.Step[] stepArray = this.fLocationPaths[i2].steps;
            for (int i3 = 0; i3 < stepArray.length; ++i3) {
                if (i3 == this.fCurrentStep[i2]) {
                    stringBuffer.append('^');
                }
                stringBuffer.append(stepArray[i3].toString());
                if (i3 >= stepArray.length - 1) continue;
                stringBuffer.append('/');
            }
            if (this.fCurrentStep[i2] == stepArray.length) {
                stringBuffer.append('^');
            }
            stringBuffer.append(']');
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    private String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        block3: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block3;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }
}

