/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderImpl;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;

public class DocumentBuilderFactoryImpl
extends DocumentBuilderFactory {
    private Hashtable attributes;
    private Schema grammar;
    private boolean isXIncludeAware;

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (this.attributes != null && this.attributes.containsKey("http://java.sun.com/xml/jaxp/properties/schemaLanguage") && this.grammar != null) {
            throw new ParserConfigurationException("Both the setSchema method and the schemaLanguage property is used");
        }
        try {
            return new DocumentBuilderImpl(this, this.attributes);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException(sAXException.getMessage());
        }
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            if (this.attributes != null) {
                this.attributes.remove(string);
            }
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(string, object);
        try {
            new DocumentBuilderImpl(this, this.attributes);
        }
        catch (Exception exception) {
            this.attributes.remove(string);
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        DOMParser dOMParser;
        if (this.attributes != null && (dOMParser = (DOMParser)this.attributes.get(string)) != null) {
            return dOMParser;
        }
        dOMParser = null;
        try {
            dOMParser = new DocumentBuilderImpl(this, this.attributes).getDOMParser();
            return dOMParser.getProperty(string);
        }
        catch (SAXException sAXException) {
            try {
                boolean bl2 = dOMParser.getFeature(string);
                return bl2 ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (SAXException sAXException2) {
                throw new IllegalArgumentException(sAXException.getMessage());
            }
        }
    }

    public Schema getSchema() {
        return this.grammar;
    }

    public void setSchema(Schema schema) {
        this.grammar = schema;
    }

    public boolean isXIncludeAware() {
        return this.isXIncludeAware;
    }

    public void setXIncludeAware(boolean bl2) {
        this.isXIncludeAware = bl2;
    }

    public void setFeature(String string, boolean bl2) throws ParserConfigurationException {
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        if (!string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            throw new ParserConfigurationException("Feature " + string + " is not supported");
        }
        this.attributes.put("http://javax.xml.XMLConstants/feature/secure-processing", bl2);
    }

    public boolean getFeature(String string) throws ParserConfigurationException {
        if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            Object v2 = this.attributes.get("http://javax.xml.XMLConstants/feature/secure-processing");
            if (v2 == null) {
                return false;
            }
            return (Boolean)v2;
        }
        throw new ParserConfigurationException("Feature " + string + " is not supported");
    }
}

