/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.dom.DOMInputImpl;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.jaxp.XNI2SAX;
import com.sun.org.apache.xerces.internal.util.AugmentationsImpl;
import com.sun.org.apache.xerces.internal.util.DraconianErrorHandler;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerProxy;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.TeeXMLDocumentFilterImpl;
import com.sun.org.apache.xerces.internal.util.XMLResourceIdentifierImpl;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLDocumentHandler;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import java.io.IOException;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JAXPValidatorComponent
extends TeeXMLDocumentFilterImpl
implements XMLComponent {
    private final ValidatorHandler validator;
    private final XNI2SAX xni2sax = new XNI2SAX();
    private final SAX2XNI sax2xni = new SAX2XNI();
    private final TypeInfoProvider typeInfoProvider;
    private Augmentations fCurrentAug;
    private XMLAttributes fCurrentAttributes;
    private SymbolTable fSymbolTable;
    private XMLErrorReporter fErrorReporter;
    private XMLEntityResolver fEntityResolver;
    private static final TypeInfoProvider noInfoProvider = new TypeInfoProvider(){

        public TypeInfo getElementTypeInfo() {
            return null;
        }

        public TypeInfo getAttributeTypeInfo(int n2) {
            return null;
        }

        public TypeInfo getAttributeTypeInfo(String string) {
            return null;
        }

        public TypeInfo getAttributeTypeInfo(String string, String string2) {
            return null;
        }

        public boolean isIdAttribute(int n2) {
            return false;
        }

        public boolean isSpecified(int n2) {
            return false;
        }
    };

    public JAXPValidatorComponent(ValidatorHandler validatorHandler) {
        this.validator = validatorHandler;
        TypeInfoProvider typeInfoProvider = validatorHandler.getTypeInfoProvider();
        if (typeInfoProvider == null) {
            typeInfoProvider = noInfoProvider;
        }
        this.typeInfoProvider = typeInfoProvider;
        this.xni2sax.setContentHandler(this.validator);
        this.validator.setContentHandler(this.sax2xni);
        this.setSide(this.xni2sax);
        this.validator.setErrorHandler(new ErrorHandlerProxy(){

            protected XMLErrorHandler getErrorHandler() {
                XMLErrorHandler xMLErrorHandler = JAXPValidatorComponent.this.fErrorReporter.getErrorHandler();
                if (xMLErrorHandler != null) {
                    return xMLErrorHandler;
                }
                return new ErrorHandlerWrapper(DraconianErrorHandler.theInstance);
            }
        });
        this.validator.setResourceResolver(new LSResourceResolver(){

            public LSInput resolveResource(String string, String string2, String string3, String string4, String string5) {
                if (JAXPValidatorComponent.this.fEntityResolver == null) {
                    return null;
                }
                try {
                    XMLInputSource xMLInputSource = JAXPValidatorComponent.this.fEntityResolver.resolveEntity(new XMLResourceIdentifierImpl(string3, string4, string5, string4));
                    if (xMLInputSource == null) {
                        return null;
                    }
                    DOMInputImpl dOMInputImpl = new DOMInputImpl();
                    dOMInputImpl.setBaseURI(xMLInputSource.getBaseSystemId());
                    dOMInputImpl.setByteStream(xMLInputSource.getByteStream());
                    dOMInputImpl.setCharacterStream(xMLInputSource.getCharacterStream());
                    dOMInputImpl.setEncoding(xMLInputSource.getEncoding());
                    dOMInputImpl.setPublicId(xMLInputSource.getPublicId());
                    dOMInputImpl.setSystemId(xMLInputSource.getSystemId());
                    return dOMInputImpl;
                }
                catch (IOException iOException) {
                    throw new XNIException(iOException);
                }
            }
        });
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fCurrentAttributes = xMLAttributes;
        this.fCurrentAug = augmentations;
        this.xni2sax.startElement(qName, xMLAttributes, null);
        this.fCurrentAttributes = null;
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.fCurrentAug = augmentations;
        this.xni2sax.endElement(qName, null);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        this.endElement(qName, augmentations);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fCurrentAug = augmentations;
        this.xni2sax.characters(xMLString, null);
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fCurrentAug = augmentations;
        this.xni2sax.ignorableWhitespace(xMLString, null);
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty("http://apache.org/xml/properties/internal/error-reporter");
    }

    private void updateAttributes(Attributes attributes) {
        int n2 = attributes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            String string = attributes.getQName(i2);
            int n3 = this.fCurrentAttributes.getIndex(string);
            String string2 = attributes.getValue(i2);
            if (n3 == -1) {
                int n4 = string.indexOf(58);
                object = n4 < 0 ? null : this.symbolize(string.substring(0, n4));
                n3 = this.fCurrentAttributes.addAttribute(new QName((String)object, this.symbolize(attributes.getLocalName(i2)), this.symbolize(string), this.symbolize(attributes.getURI(i2))), attributes.getType(i2), string2);
            } else if (!string2.equals(this.fCurrentAttributes.getValue(n3))) {
                this.fCurrentAttributes.setValue(n3, string2);
            }
            object = this.fCurrentAttributes.getAugmentations(n3);
            object.putItem("org.w3c.dom.TypeInfo", this.typeInfoProvider.getAttributeTypeInfo(i2));
            object.putItem("ID_ATTRIBUTE", this.typeInfoProvider.isIdAttribute(i2) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    private String symbolize(String string) {
        return this.fSymbolTable.addSymbol(string);
    }

    public String[] getRecognizedFeatures() {
        return null;
    }

    public void setFeature(String string, boolean bl2) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return new String[]{"http://apache.org/xml/properties/internal/entity-resolver"};
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.equals("http://apache.org/xml/properties/internal/entity-resolver")) {
            this.fEntityResolver = (XMLEntityResolver)object;
        }
    }

    public Boolean getFeatureDefault(String string) {
        return null;
    }

    public Object getPropertyDefault(String string) {
        return null;
    }

    private final class SAX2XNI
    extends DefaultHandler {
        private final Augmentations fAugmentations = new AugmentationsImpl();
        private final QName fQName = new QName();

        private SAX2XNI() {
        }

        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            try {
                this.handler().characters(new XMLString(cArray, n2, n3), this.aug());
            }
            catch (XNIException xNIException) {
                throw this.toSAXException(xNIException);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
            try {
                this.handler().ignorableWhitespace(new XMLString(cArray, n2, n3), this.aug());
            }
            catch (XNIException xNIException) {
                throw this.toSAXException(xNIException);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                JAXPValidatorComponent.this.updateAttributes(attributes);
                this.handler().startElement(this.toQName(string, string2, string3), JAXPValidatorComponent.this.fCurrentAttributes, this.elementAug());
            }
            catch (XNIException xNIException) {
                throw this.toSAXException(xNIException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            try {
                this.handler().endElement(this.toQName(string, string2, string3), this.elementAug());
            }
            catch (XNIException xNIException) {
                throw this.toSAXException(xNIException);
            }
        }

        private Augmentations elementAug() {
            Augmentations augmentations = this.aug();
            augmentations.putItem("org.w3c.dom.TypeInfo", JAXPValidatorComponent.this.typeInfoProvider.getElementTypeInfo());
            return augmentations;
        }

        private Augmentations aug() {
            if (JAXPValidatorComponent.this.fCurrentAug != null) {
                Augmentations augmentations = JAXPValidatorComponent.this.fCurrentAug;
                JAXPValidatorComponent.this.fCurrentAug = null;
                return augmentations;
            }
            this.fAugmentations.removeAllItems();
            return this.fAugmentations;
        }

        private XMLDocumentHandler handler() {
            return JAXPValidatorComponent.this.getDocumentHandler();
        }

        private SAXException toSAXException(XNIException xNIException) {
            Exception exception = xNIException.getException();
            if (exception == null) {
                exception = xNIException;
            }
            if (exception instanceof SAXException) {
                return (SAXException)exception;
            }
            return new SAXException(exception);
        }

        private QName toQName(String string, String string2, String string3) {
            String string4 = null;
            int n2 = string3.indexOf(58);
            if (n2 > 0) {
                string4 = JAXPValidatorComponent.this.symbolize(string3.substring(0, n2));
            }
            string2 = JAXPValidatorComponent.this.symbolize(string2);
            string3 = JAXPValidatorComponent.this.symbolize(string3);
            string = JAXPValidatorComponent.this.symbolize(string);
            this.fQName.setValues(string4, string2, string3, string);
            return this.fQName;
        }
    }
}

