/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.datatype;

import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class DurationImpl
extends Duration
implements Serializable {
    private static final int FIELD_NUM = 6;
    private static final DatatypeConstants.Field[] FIELDS = new DatatypeConstants.Field[]{DatatypeConstants.YEARS, DatatypeConstants.MONTHS, DatatypeConstants.DAYS, DatatypeConstants.HOURS, DatatypeConstants.MINUTES, DatatypeConstants.SECONDS};
    private static final int[] FIELD_IDS = new int[]{DatatypeConstants.YEARS.getId(), DatatypeConstants.MONTHS.getId(), DatatypeConstants.DAYS.getId(), DatatypeConstants.HOURS.getId(), DatatypeConstants.MINUTES.getId(), DatatypeConstants.SECONDS.getId()};
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    private final int signum;
    private final BigInteger years;
    private final BigInteger months;
    private final BigInteger days;
    private final BigInteger hours;
    private final BigInteger minutes;
    private final BigDecimal seconds;
    private static final XMLGregorianCalendar[] TEST_POINTS = new XMLGregorianCalendar[]{XMLGregorianCalendarImpl.parse("1696-09-01T00:00:00Z"), XMLGregorianCalendarImpl.parse("1697-02-01T00:00:00Z"), XMLGregorianCalendarImpl.parse("1903-03-01T00:00:00Z"), XMLGregorianCalendarImpl.parse("1903-07-01T00:00:00Z")};
    private static final BigDecimal[] FACTORS = new BigDecimal[]{BigDecimal.valueOf(12L), null, BigDecimal.valueOf(24L), BigDecimal.valueOf(60L), BigDecimal.valueOf(60L)};
    private static final long serialVersionUID = 1L;

    public QName getXMLSchemaType() {
        throw new UnsupportedOperationException(this.getClass().getName() + "#getXMLSchemaType() not implemented.");
    }

    public int getSign() {
        return this.signum;
    }

    private int calcSignum(boolean bl2) {
        if (!(this.years != null && this.years.signum() != 0 || this.months != null && this.months.signum() != 0 || this.days != null && this.days.signum() != 0 || this.hours != null && this.hours.signum() != 0 || this.minutes != null && this.minutes.signum() != 0 || this.seconds != null && this.seconds.signum() != 0)) {
            return 0;
        }
        if (bl2) {
            return 1;
        }
        return -1;
    }

    protected DurationImpl(boolean bl2, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigDecimal bigDecimal) {
        this.years = bigInteger;
        this.months = bigInteger2;
        this.days = bigInteger3;
        this.hours = bigInteger4;
        this.minutes = bigInteger5;
        this.seconds = bigDecimal;
        this.signum = this.calcSignum(bl2);
        if (bigInteger == null && bigInteger2 == null && bigInteger3 == null && bigInteger4 == null && bigInteger5 == null && bigDecimal == null) {
            throw new IllegalArgumentException("all the fields are null");
        }
        DurationImpl.testNonNegative(bigInteger, DatatypeConstants.YEARS);
        DurationImpl.testNonNegative(bigInteger2, DatatypeConstants.MONTHS);
        DurationImpl.testNonNegative(bigInteger3, DatatypeConstants.DAYS);
        DurationImpl.testNonNegative(bigInteger4, DatatypeConstants.HOURS);
        DurationImpl.testNonNegative(bigInteger5, DatatypeConstants.MINUTES);
        DurationImpl.testNonNegative(bigDecimal, DatatypeConstants.SECONDS);
    }

    private static void testNonNegative(BigInteger bigInteger, DatatypeConstants.Field field) {
        if (bigInteger != null && bigInteger.signum() < 0) {
            throw new IllegalArgumentException(field.toString() + " is negative");
        }
    }

    private static void testNonNegative(BigDecimal bigDecimal, DatatypeConstants.Field field) {
        if (bigDecimal != null && bigDecimal.signum() < 0) {
            throw new IllegalArgumentException(field.toString() + " is negative");
        }
    }

    protected DurationImpl(boolean bl2, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(bl2, DurationImpl.wrap(n2), DurationImpl.wrap(n3), DurationImpl.wrap(n4), DurationImpl.wrap(n5), DurationImpl.wrap(n6), n7 != 0 ? new BigDecimal(String.valueOf(n7)) : null);
    }

    private static BigInteger wrap(int n2) {
        if (n2 == 0) {
            return null;
        }
        return new BigInteger(String.valueOf(n2));
    }

    protected DurationImpl(long l2) {
        boolean bl2 = false;
        long l3 = l2;
        if (l3 > 0L) {
            this.signum = 1;
        } else if (l3 < 0L) {
            this.signum = -1;
            if (l3 == Long.MIN_VALUE) {
                ++l3;
                bl2 = true;
            }
            l3 *= -1L;
        } else {
            this.signum = 0;
        }
        this.years = null;
        this.months = null;
        this.seconds = BigDecimal.valueOf(l3 % 60000L + (long)(bl2 ? 1 : 0), 3);
        this.minutes = (l3 /= 60000L) == 0L ? null : BigInteger.valueOf(l3 % 60L);
        this.hours = (l3 /= 60L) == 0L ? null : BigInteger.valueOf(l3 % 24L);
        this.days = (l3 /= 24L) == 0L ? null : BigInteger.valueOf(l3);
    }

    protected DurationImpl(String string) throws IllegalArgumentException {
        boolean bl2;
        String string2 = string;
        int[] nArray = new int[1];
        int n2 = string2.length();
        boolean bl3 = false;
        if (string == null) {
            throw new NullPointerException();
        }
        nArray[0] = 0;
        if (n2 != nArray[0] && string2.charAt(nArray[0]) == '-') {
            nArray[0] = nArray[0] + 1;
            bl2 = false;
        } else {
            bl2 = true;
        }
        if (n2 != nArray[0]) {
            int n3 = nArray[0];
            nArray[0] = n3 + 1;
            if (string2.charAt(n3) != 'P') {
                throw new IllegalArgumentException(string2);
            }
        }
        int n4 = 0;
        String[] stringArray = new String[3];
        int[] nArray2 = new int[3];
        while (n2 != nArray[0] && DurationImpl.isDigit(string2.charAt(nArray[0])) && n4 < 3) {
            nArray2[n4] = nArray[0];
            stringArray[n4++] = DurationImpl.parsePiece(string2, nArray);
        }
        if (n2 != nArray[0]) {
            int n5 = nArray[0];
            nArray[0] = n5 + 1;
            if (string2.charAt(n5) == 'T') {
                bl3 = true;
            } else {
                throw new IllegalArgumentException(string2);
            }
        }
        int n6 = 0;
        String[] stringArray2 = new String[3];
        int[] nArray3 = new int[3];
        while (n2 != nArray[0] && DurationImpl.isDigitOrPeriod(string2.charAt(nArray[0])) && n6 < 3) {
            nArray3[n6] = nArray[0];
            stringArray2[n6++] = DurationImpl.parsePiece(string2, nArray);
        }
        if (bl3 && n6 == 0) {
            throw new IllegalArgumentException(string2);
        }
        if (n2 != nArray[0]) {
            throw new IllegalArgumentException(string2);
        }
        if (n4 == 0 && n6 == 0) {
            throw new IllegalArgumentException(string2);
        }
        DurationImpl.organizeParts(string2, stringArray, nArray2, n4, "YMD");
        DurationImpl.organizeParts(string2, stringArray2, nArray3, n6, "HMS");
        this.years = DurationImpl.parseBigInteger(string2, stringArray[0], nArray2[0]);
        this.months = DurationImpl.parseBigInteger(string2, stringArray[1], nArray2[1]);
        this.days = DurationImpl.parseBigInteger(string2, stringArray[2], nArray2[2]);
        this.hours = DurationImpl.parseBigInteger(string2, stringArray2[0], nArray3[0]);
        this.minutes = DurationImpl.parseBigInteger(string2, stringArray2[1], nArray3[1]);
        this.seconds = DurationImpl.parseBigDecimal(string2, stringArray2[2], nArray3[2]);
        this.signum = this.calcSignum(bl2);
    }

    private static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    private static boolean isDigitOrPeriod(char c2) {
        return DurationImpl.isDigit(c2) || c2 == '.';
    }

    private static String parsePiece(String string, int[] nArray) throws IllegalArgumentException {
        int n2 = nArray[0];
        while (nArray[0] < string.length() && DurationImpl.isDigitOrPeriod(string.charAt(nArray[0]))) {
            nArray[0] = nArray[0] + 1;
        }
        if (nArray[0] == string.length()) {
            throw new IllegalArgumentException(string);
        }
        nArray[0] = nArray[0] + 1;
        return string.substring(n2, nArray[0]);
    }

    private static void organizeParts(String string, String[] stringArray, int[] nArray, int n2, String string2) throws IllegalArgumentException {
        int n3 = string2.length();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            int n4 = string2.lastIndexOf(stringArray[i2].charAt(stringArray[i2].length() - 1), n3 - 1);
            if (n4 == -1) {
                throw new IllegalArgumentException(string);
            }
            for (int i3 = n4 + 1; i3 < n3; ++i3) {
                stringArray[i3] = null;
            }
            n3 = n4;
            stringArray[n3] = stringArray[i2];
            nArray[n3] = nArray[i2];
        }
        --n3;
        while (n3 >= 0) {
            stringArray[n3] = null;
            --n3;
        }
    }

    private static BigInteger parseBigInteger(String string, String string2, int n2) throws IllegalArgumentException {
        if (string2 == null) {
            return null;
        }
        string2 = string2.substring(0, string2.length() - 1);
        return new BigInteger(string2);
    }

    private static BigDecimal parseBigDecimal(String string, String string2, int n2) throws IllegalArgumentException {
        if (string2 == null) {
            return null;
        }
        string2 = string2.substring(0, string2.length() - 1);
        return new BigDecimal(string2);
    }

    public int compare(Duration duration) {
        DurationImpl durationImpl = this;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (int i2 = 0; i2 < 4; ++i2) {
            XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)TEST_POINTS[i2].clone();
            XMLGregorianCalendar xMLGregorianCalendar2 = (XMLGregorianCalendar)xMLGregorianCalendar.clone();
            xMLGregorianCalendar.add(durationImpl);
            xMLGregorianCalendar2.add(duration);
            int n2 = xMLGregorianCalendar.compare(xMLGregorianCalendar2);
            if (n2 == -1) {
                bl3 = true;
                continue;
            }
            if (n2 == 0) {
                bl2 = true;
                continue;
            }
            if (n2 == 1) {
                bl4 = true;
                continue;
            }
            bl5 = true;
            break;
        }
        if (bl2 && bl3 || bl3 && bl4 || bl4 && bl2 || bl5) {
            return 2;
        }
        if (bl3) {
            return -1;
        }
        if (bl2) {
            return 0;
        }
        if (bl4) {
            return 1;
        }
        return 2;
    }

    public boolean isLongerThan(Duration duration) {
        return this.compare(duration) == 1;
    }

    public boolean isShorterThan(Duration duration) {
        return this.compare(duration) == -1;
    }

    public boolean equals(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Duration)) {
            return false;
        }
        return this.compare((Duration)object) == 0;
    }

    public int hashCode() {
        GregorianCalendar gregorianCalendar = TEST_POINTS[0].toGregorianCalendar();
        this.addTo(gregorianCalendar);
        return (int)DurationImpl.getCalendarTimeInMillis(gregorianCalendar);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.signum < 0) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (this.years != null) {
            stringBuffer.append(this.years + "Y");
        }
        if (this.months != null) {
            stringBuffer.append(this.months + "M");
        }
        if (this.days != null) {
            stringBuffer.append(this.days + "D");
        }
        if (this.hours != null || this.minutes != null || this.seconds != null) {
            stringBuffer.append('T');
            if (this.hours != null) {
                stringBuffer.append(this.hours + "H");
            }
            if (this.minutes != null) {
                stringBuffer.append(this.minutes + "M");
            }
            if (this.seconds != null) {
                stringBuffer.append(this.toString(this.seconds) + "S");
            }
        }
        return stringBuffer.toString();
    }

    private String toString(BigDecimal bigDecimal) {
        StringBuffer stringBuffer;
        String string = bigDecimal.unscaledValue().toString();
        int n2 = bigDecimal.scale();
        if (n2 == 0) {
            return string;
        }
        int n3 = string.length() - n2;
        if (n3 == 0) {
            return "0." + string;
        }
        if (n3 > 0) {
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(n3, '.');
        } else {
            stringBuffer = new StringBuffer(3 - n3 + string.length());
            stringBuffer.append("0.");
            for (int i2 = 0; i2 < -n3; ++i2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean isSet(DatatypeConstants.Field field) {
        if (field == null) {
            throw new NullPointerException(this.getClass().getName() + "#isSet(DatatypeConstants.Field field) cannot be called with field == null");
        }
        if (field == DatatypeConstants.YEARS) {
            return this.years != null;
        }
        if (field == DatatypeConstants.MONTHS) {
            return this.months != null;
        }
        if (field == DatatypeConstants.DAYS) {
            return this.days != null;
        }
        if (field == DatatypeConstants.HOURS) {
            return this.hours != null;
        }
        if (field == DatatypeConstants.MINUTES) {
            return this.minutes != null;
        }
        if (field == DatatypeConstants.SECONDS) {
            return this.seconds != null;
        }
        throw new IllegalArgumentException(this.getClass().getName() + "#(isSet(DatatypeConstants.Field field) called with an unknown field: " + field.toString());
    }

    public Number getField(DatatypeConstants.Field field) {
        if (field == null) {
            throw new NullPointerException(this.getClass().getName() + "#isSet(DatatypeConstants.Field field) cannot be called with field == null");
        }
        if (field == DatatypeConstants.YEARS) {
            return this.years;
        }
        if (field == DatatypeConstants.MONTHS) {
            return this.months;
        }
        if (field == DatatypeConstants.DAYS) {
            return this.days;
        }
        if (field == DatatypeConstants.HOURS) {
            return this.hours;
        }
        if (field == DatatypeConstants.MINUTES) {
            return this.minutes;
        }
        if (field == DatatypeConstants.SECONDS) {
            return this.seconds;
        }
        throw new IllegalArgumentException(this.getClass().getName() + "#(getSet(DatatypeConstants.Field field) called with an unknown field: " + field.toString());
    }

    public int getYears() {
        return this.getInt(DatatypeConstants.YEARS);
    }

    public int getMonths() {
        return this.getInt(DatatypeConstants.MONTHS);
    }

    public int getDays() {
        return this.getInt(DatatypeConstants.DAYS);
    }

    public int getHours() {
        return this.getInt(DatatypeConstants.HOURS);
    }

    public int getMinutes() {
        return this.getInt(DatatypeConstants.MINUTES);
    }

    public int getSeconds() {
        return this.getInt(DatatypeConstants.SECONDS);
    }

    private int getInt(DatatypeConstants.Field field) {
        Number number = this.getField(field);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public long getTimeInMillis(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        this.addTo(calendar2);
        return DurationImpl.getCalendarTimeInMillis(calendar2) - DurationImpl.getCalendarTimeInMillis(calendar);
    }

    public long getTimeInMillis(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.addTo(gregorianCalendar);
        return DurationImpl.getCalendarTimeInMillis(gregorianCalendar) - date.getTime();
    }

    public Duration normalizeWith(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(1, this.getYears() * this.signum);
        calendar2.add(2, this.getMonths() * this.signum);
        calendar2.add(5, this.getDays() * this.signum);
        long l2 = DurationImpl.getCalendarTimeInMillis(calendar2) - DurationImpl.getCalendarTimeInMillis(calendar);
        int n2 = (int)(l2 / 86400000L);
        return new DurationImpl(n2 >= 0, null, null, DurationImpl.wrap(Math.abs(n2)), (BigInteger)this.getField(DatatypeConstants.HOURS), (BigInteger)this.getField(DatatypeConstants.MINUTES), (BigDecimal)this.getField(DatatypeConstants.SECONDS));
    }

    public Duration multiply(int n2) {
        return this.multiply(BigDecimal.valueOf(n2));
    }

    public Duration multiply(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = ZERO;
        int n2 = bigDecimal.signum();
        bigDecimal = bigDecimal.abs();
        BigDecimal[] bigDecimalArray = new BigDecimal[6];
        for (int i2 = 0; i2 < 5; ++i2) {
            BigDecimal bigDecimal3 = this.getFieldAsBigDecimal(FIELDS[i2]);
            bigDecimal3 = bigDecimal3.multiply(bigDecimal).add(bigDecimal2);
            bigDecimalArray[i2] = bigDecimal3.setScale(0, 1);
            bigDecimal3 = bigDecimal3.subtract(bigDecimalArray[i2]);
            if (i2 == 1) {
                if (bigDecimal3.signum() != 0) {
                    throw new IllegalStateException();
                }
                bigDecimal2 = ZERO;
                continue;
            }
            bigDecimal2 = bigDecimal3.multiply(FACTORS[i2]);
        }
        bigDecimalArray[5] = this.seconds != null ? this.seconds.multiply(bigDecimal).add(bigDecimal2) : bigDecimal2;
        return new DurationImpl(this.signum * n2 >= 0, DurationImpl.toBigInteger(bigDecimalArray[0], null == this.years), DurationImpl.toBigInteger(bigDecimalArray[1], null == this.months), DurationImpl.toBigInteger(bigDecimalArray[2], null == this.days), DurationImpl.toBigInteger(bigDecimalArray[3], null == this.hours), DurationImpl.toBigInteger(bigDecimalArray[4], null == this.minutes), (BigDecimal)(bigDecimalArray[5].signum() == 0 && this.seconds == null ? null : bigDecimalArray[5]));
    }

    private BigDecimal getFieldAsBigDecimal(DatatypeConstants.Field field) {
        if (field == DatatypeConstants.SECONDS) {
            if (this.seconds != null) {
                return this.seconds;
            }
            return ZERO;
        }
        BigInteger bigInteger = (BigInteger)this.getField(field);
        if (bigInteger == null) {
            return ZERO;
        }
        return new BigDecimal(bigInteger);
    }

    private static BigInteger toBigInteger(BigDecimal bigDecimal, boolean bl2) {
        if (bl2 && bigDecimal.signum() == 0) {
            return null;
        }
        return bigDecimal.unscaledValue();
    }

    public Duration add(Duration duration) {
        DurationImpl durationImpl = this;
        BigDecimal[] bigDecimalArray = new BigDecimal[]{DurationImpl.sanitize((BigInteger)((Duration)durationImpl).getField(DatatypeConstants.YEARS), ((Duration)durationImpl).getSign()).add(DurationImpl.sanitize((BigInteger)duration.getField(DatatypeConstants.YEARS), duration.getSign())), DurationImpl.sanitize((BigInteger)((Duration)durationImpl).getField(DatatypeConstants.MONTHS), ((Duration)durationImpl).getSign()).add(DurationImpl.sanitize((BigInteger)duration.getField(DatatypeConstants.MONTHS), duration.getSign())), DurationImpl.sanitize((BigInteger)((Duration)durationImpl).getField(DatatypeConstants.DAYS), ((Duration)durationImpl).getSign()).add(DurationImpl.sanitize((BigInteger)duration.getField(DatatypeConstants.DAYS), duration.getSign())), DurationImpl.sanitize((BigInteger)((Duration)durationImpl).getField(DatatypeConstants.HOURS), ((Duration)durationImpl).getSign()).add(DurationImpl.sanitize((BigInteger)duration.getField(DatatypeConstants.HOURS), duration.getSign())), DurationImpl.sanitize((BigInteger)((Duration)durationImpl).getField(DatatypeConstants.MINUTES), ((Duration)durationImpl).getSign()).add(DurationImpl.sanitize((BigInteger)duration.getField(DatatypeConstants.MINUTES), duration.getSign())), DurationImpl.sanitize((BigDecimal)((Duration)durationImpl).getField(DatatypeConstants.SECONDS), ((Duration)durationImpl).getSign()).add(DurationImpl.sanitize((BigDecimal)duration.getField(DatatypeConstants.SECONDS), duration.getSign()))};
        DurationImpl.alignSigns(bigDecimalArray, 0, 2);
        DurationImpl.alignSigns(bigDecimalArray, 2, 6);
        int n2 = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            if (n2 * bigDecimalArray[i2].signum() < 0) {
                throw new IllegalStateException();
            }
            if (n2 != 0) continue;
            n2 = bigDecimalArray[i2].signum();
        }
        return new DurationImpl(n2 >= 0, DurationImpl.toBigInteger(DurationImpl.sanitize(bigDecimalArray[0], n2), ((Duration)durationImpl).getField(DatatypeConstants.YEARS) == null && duration.getField(DatatypeConstants.YEARS) == null), DurationImpl.toBigInteger(DurationImpl.sanitize(bigDecimalArray[1], n2), ((Duration)durationImpl).getField(DatatypeConstants.MONTHS) == null && duration.getField(DatatypeConstants.MONTHS) == null), DurationImpl.toBigInteger(DurationImpl.sanitize(bigDecimalArray[2], n2), ((Duration)durationImpl).getField(DatatypeConstants.DAYS) == null && duration.getField(DatatypeConstants.DAYS) == null), DurationImpl.toBigInteger(DurationImpl.sanitize(bigDecimalArray[3], n2), ((Duration)durationImpl).getField(DatatypeConstants.HOURS) == null && duration.getField(DatatypeConstants.HOURS) == null), DurationImpl.toBigInteger(DurationImpl.sanitize(bigDecimalArray[4], n2), ((Duration)durationImpl).getField(DatatypeConstants.MINUTES) == null && duration.getField(DatatypeConstants.MINUTES) == null), (BigDecimal)(bigDecimalArray[5].signum() == 0 && ((Duration)durationImpl).getField(DatatypeConstants.SECONDS) == null && duration.getField(DatatypeConstants.SECONDS) == null ? null : DurationImpl.sanitize(bigDecimalArray[5], n2)));
    }

    private static void alignSigns(BigDecimal[] bigDecimalArray, int n2, int n3) {
        boolean bl2;
        do {
            bl2 = false;
            int n4 = 0;
            for (int i2 = n2; i2 < n3; ++i2) {
                if (n4 * bigDecimalArray[i2].signum() < 0) {
                    bl2 = true;
                    BigDecimal bigDecimal = bigDecimalArray[i2].abs().divide(FACTORS[i2 - 1], 0);
                    if (bigDecimalArray[i2].signum() > 0) {
                        bigDecimal = bigDecimal.negate();
                    }
                    bigDecimalArray[i2 - 1] = bigDecimalArray[i2 - 1].subtract(bigDecimal);
                    bigDecimalArray[i2] = bigDecimalArray[i2].add(bigDecimal.multiply(FACTORS[i2 - 1]));
                }
                if (bigDecimalArray[i2].signum() == 0) continue;
                n4 = bigDecimalArray[i2].signum();
            }
        } while (bl2);
    }

    private static BigDecimal sanitize(BigInteger bigInteger, int n2) {
        if (n2 == 0 || bigInteger == null) {
            return ZERO;
        }
        if (n2 > 0) {
            return new BigDecimal(bigInteger);
        }
        return new BigDecimal(bigInteger.negate());
    }

    static BigDecimal sanitize(BigDecimal bigDecimal, int n2) {
        if (n2 == 0 || bigDecimal == null) {
            return ZERO;
        }
        if (n2 > 0) {
            return bigDecimal;
        }
        return bigDecimal.negate();
    }

    public Duration subtract(Duration duration) {
        return this.add(duration.negate());
    }

    public Duration negate() {
        return new DurationImpl(this.signum <= 0, this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    public int signum() {
        return this.signum;
    }

    public void addTo(Calendar calendar) {
        calendar.add(1, this.getYears() * this.signum);
        calendar.add(2, this.getMonths() * this.signum);
        calendar.add(5, this.getDays() * this.signum);
        calendar.add(10, this.getHours() * this.signum);
        calendar.add(12, this.getMinutes() * this.signum);
        calendar.add(13, this.getSeconds() * this.signum);
        if (this.seconds != null) {
            BigDecimal bigDecimal = this.seconds.subtract(this.seconds.setScale(0, 1));
            int n2 = bigDecimal.movePointRight(3).intValue();
            calendar.add(14, n2 * this.signum);
        }
    }

    public void addTo(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.addTo(gregorianCalendar);
        date.setTime(DurationImpl.getCalendarTimeInMillis(gregorianCalendar));
    }

    private Object writeReplace() throws IOException {
        return new DurationStream(this.toString());
    }

    private static long getCalendarTimeInMillis(Calendar calendar) {
        return calendar.getTime().getTime();
    }

    private static class DurationStream
    implements Serializable {
        private final String lexical;
        private static final long serialVersionUID = 1L;

        private DurationStream(String string) {
            this.lexical = string;
        }

        private Object readResolve() throws ObjectStreamException {
            return new DurationImpl(this.lexical);
        }
    }
}

