/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.datatype;

import com.sun.org.apache.xerces.internal.jaxp.datatype.DurationImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class XMLGregorianCalendarImpl
extends XMLGregorianCalendar
implements Serializable,
Cloneable {
    private BigInteger eon = null;
    private int year = Integer.MIN_VALUE;
    private int month = Integer.MIN_VALUE;
    private int day = Integer.MIN_VALUE;
    private int timezone = Integer.MIN_VALUE;
    private int hour = Integer.MIN_VALUE;
    private int minute = Integer.MIN_VALUE;
    private int second = Integer.MIN_VALUE;
    private BigDecimal fractionalSecond = null;
    private static final BigInteger BILLION = new BigInteger("1000000000");
    private static final Date PURE_GREGORIAN_CHANGE = new Date(Long.MIN_VALUE);
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DAY = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECOND = 5;
    private static final int MILLISECOND = 6;
    private static final int TIMEZONE = 7;
    private static final int[] MIN_FIELD_VALUE = new int[]{Integer.MIN_VALUE, 1, 1, 0, 0, 0, 0, -840};
    private static final int[] MAX_FIELD_VALUE = new int[]{Integer.MAX_VALUE, 12, 31, 23, 59, 60, 999, 840};
    private static final String[] FIELD_NAME = new String[]{"Year", "Month", "Day", "Hour", "Minute", "Second", "Millisecond", "Timezone"};
    private static final long serialVersionUID = 1L;
    public static final XMLGregorianCalendar LEAP_YEAR_DEFAULT = XMLGregorianCalendarImpl.createDateTime(400, 1, 1, 0, 0, 0, Integer.MIN_VALUE, Integer.MIN_VALUE);
    public static final QName DATETIME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
    public static final QName TIME = new QName("http://www.w3.org/2001/XMLSchema", "time");
    public static final QName DATE = new QName("http://www.w3.org/2001/XMLSchema", "date");
    public static final QName GYEARMONTH = new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth");
    public static final QName GMONTHDAY = new QName("http://www.w3.org/2001/XMLSchema", "gMonthDay");
    public static final QName GYEAR = new QName("http://www.w3.org/2001/XMLSchema", "gYear");
    public static final QName GMONTH = new QName("http://www.w3.org/2001/XMLSchema", "gMonth");
    public static final QName GDAY = new QName("http://www.w3.org/2001/XMLSchema", "gDay");
    public static final int MAX_TIMEZONE_OFFSET = -840;
    public static final int MIN_TIMEZONE_OFFSET = 840;
    private static final BigInteger FOUR = BigInteger.valueOf(4L);
    private static final BigInteger HUNDRED = BigInteger.valueOf(100L);
    private static final BigInteger FOUR_HUNDRED = BigInteger.valueOf(400L);
    private static final BigInteger SIXTY = BigInteger.valueOf(60L);
    private static final BigInteger TWENTY_FOUR = BigInteger.valueOf(24L);
    private static final BigInteger TWELVE = BigInteger.valueOf(12L);
    private static final BigDecimal DECIMAL_ZERO = new BigDecimal("0");
    private static final BigDecimal DECIMAL_ONE = new BigDecimal("1");
    private static final BigDecimal DECIMAL_SIXTY = new BigDecimal("60");
    private static int[] daysInMonth = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    protected XMLGregorianCalendarImpl(String string) throws IllegalArgumentException {
        String string2 = null;
        String string3 = string;
        int n2 = string3.length();
        if (string3.indexOf(84) != -1) {
            string2 = "%Y-%M-%DT%h:%m:%s%z";
        } else if (n2 >= 3 && string3.charAt(2) == ':') {
            string2 = "%h:%m:%s%z";
        } else if (string3.startsWith("--")) {
            string2 = n2 >= 3 && string3.charAt(2) == '-' ? "---%D%z" : (n2 >= 6 && string3.charAt(5) == '-' && string3.charAt(4) == '-' ? "--%M--%z" : "--%M-%D%z");
        } else {
            int n3 = 0;
            int n4 = string3.indexOf(58);
            if (n4 != -1) {
                n2 -= 6;
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                if (string3.charAt(i2) != '-') continue;
                ++n3;
            }
            string2 = n3 == 0 ? "%Y%z" : (n3 == 1 ? "%Y-%M%z" : "%Y-%M-%D%z");
        }
        Parser parser2 = new Parser(string2, string3);
        parser2.parse();
        if (!this.isValid()) {
            throw new IllegalArgumentException("\"" + string + "\" is not a valid representation of an XML Gregorian Calendar value.");
        }
    }

    public XMLGregorianCalendarImpl() {
    }

    protected XMLGregorianCalendarImpl(BigInteger bigInteger, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, int n7) {
        this.setYear(bigInteger);
        this.setMonth(n2);
        this.setDay(n3);
        this.setTime(n4, n5, n6, bigDecimal);
        this.setTimezone(n7);
        if (!this.isValid()) {
            String string = "null";
            if (bigInteger != null) {
                string = bigInteger.toString();
            }
            String string2 = "null";
            if (bigDecimal != null) {
                string2 = bigDecimal.toString();
            }
            throw new IllegalArgumentException("year = " + string + ", month = " + n2 + ", day = " + n3 + ", hour = " + n4 + ", minute = " + n5 + ", second = " + n6 + ", fractionalSecond = " + string2 + ", timezone = " + n7 + ", is not a valid representation of an XML Gregorian Calendar value.");
        }
    }

    private XMLGregorianCalendarImpl(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setYear(n2);
        this.setMonth(n3);
        this.setDay(n4);
        this.setTime(n5, n6, n7);
        this.setTimezone(n9);
        this.setMillisecond(n8);
        if (!this.isValid()) {
            throw new IllegalArgumentException("year = " + n2 + ", month = " + n3 + ", day = " + n4 + ", hour = " + n5 + ", minute = " + n6 + ", second = " + n7 + ", millisecond = " + n8 + ", timezone = " + n9 + ", is not a valid representation of an XML Gregorian Calendar value.");
        }
    }

    public XMLGregorianCalendarImpl(GregorianCalendar gregorianCalendar) {
        int n2 = gregorianCalendar.get(1);
        if (gregorianCalendar.get(0) == 0) {
            n2 = -n2;
        }
        this.setYear(n2);
        this.setMonth(gregorianCalendar.get(2) + 1);
        this.setDay(gregorianCalendar.get(5));
        this.setTime(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13), gregorianCalendar.get(14));
        int n3 = (gregorianCalendar.get(15) + gregorianCalendar.get(16)) / 60000;
        this.setTimezone(n3);
    }

    public static XMLGregorianCalendar createDateTime(BigInteger bigInteger, int n2, int n3, int n4, int n5, int n6, BigDecimal bigDecimal, int n7) {
        return new XMLGregorianCalendarImpl(bigInteger, n2, n3, n4, n5, n6, bigDecimal, n7);
    }

    public static XMLGregorianCalendar createDateTime(int n2, int n3, int n4, int n5, int n6, int n7) {
        return new XMLGregorianCalendarImpl(n2, n3, n4, n5, n6, n7, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static XMLGregorianCalendar createDateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new XMLGregorianCalendarImpl(n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static XMLGregorianCalendar createDate(int n2, int n3, int n4, int n5) {
        return new XMLGregorianCalendarImpl(n2, n3, n4, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, n5);
    }

    public static XMLGregorianCalendar createTime(int n2, int n3, int n4, int n5) {
        return new XMLGregorianCalendarImpl(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, n2, n3, n4, Integer.MIN_VALUE, n5);
    }

    public static XMLGregorianCalendar createTime(int n2, int n3, int n4, BigDecimal bigDecimal, int n5) {
        return new XMLGregorianCalendarImpl(null, Integer.MIN_VALUE, Integer.MIN_VALUE, n2, n3, n4, bigDecimal, n5);
    }

    public static XMLGregorianCalendar createTime(int n2, int n3, int n4, int n5, int n6) {
        return new XMLGregorianCalendarImpl(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, n2, n3, n4, n5, n6);
    }

    public BigInteger getEon() {
        return this.eon;
    }

    public int getYear() {
        return this.year;
    }

    public BigInteger getEonAndYear() {
        if (this.year != Integer.MIN_VALUE && this.eon != null) {
            return this.eon.add(BigInteger.valueOf(this.year));
        }
        if (this.year != Integer.MIN_VALUE && this.eon == null) {
            return BigInteger.valueOf(this.year);
        }
        return null;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getTimezone() {
        return this.timezone;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    private BigDecimal getSeconds() {
        if (this.second == Integer.MIN_VALUE) {
            return DECIMAL_ZERO;
        }
        BigDecimal bigDecimal = BigDecimal.valueOf(this.second);
        if (this.fractionalSecond != null) {
            return bigDecimal.add(this.fractionalSecond);
        }
        return bigDecimal;
    }

    public int getMillisecond() {
        if (this.fractionalSecond == null) {
            return Integer.MIN_VALUE;
        }
        return this.fractionalSecond.movePointRight(3).intValue();
    }

    public BigDecimal getFractionalSecond() {
        return this.fractionalSecond;
    }

    public void setYear(BigInteger bigInteger) {
        if (bigInteger == null) {
            this.eon = null;
            this.year = Integer.MIN_VALUE;
        } else {
            BigInteger bigInteger2 = bigInteger.remainder(BILLION);
            this.year = bigInteger2.intValue();
            this.setEon(bigInteger.subtract(bigInteger2));
        }
    }

    public void setYear(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.year = Integer.MIN_VALUE;
            this.eon = null;
        } else if (Math.abs(n2) < BILLION.intValue()) {
            this.year = n2;
            this.eon = null;
        } else {
            BigInteger bigInteger = BigInteger.valueOf(n2);
            BigInteger bigInteger2 = bigInteger.remainder(BILLION);
            this.year = bigInteger2.intValue();
            this.setEon(bigInteger.subtract(bigInteger2));
        }
    }

    private void setEon(BigInteger bigInteger) {
        this.eon = bigInteger != null && bigInteger.compareTo(BigInteger.ZERO) == 0 ? null : bigInteger;
    }

    public void setMonth(int n2) {
        this.checkFieldValueConstraint(1, n2);
        this.month = n2;
    }

    public void setDay(int n2) {
        this.checkFieldValueConstraint(2, n2);
        this.day = n2;
    }

    public void setTimezone(int n2) {
        this.checkFieldValueConstraint(7, n2);
        this.timezone = n2;
    }

    public void setTime(int n2, int n3, int n4) {
        this.setTime(n2, n3, n4, null);
    }

    private void checkFieldValueConstraint(int n2, int n3) throws IllegalArgumentException {
        if (n3 < MIN_FIELD_VALUE[n2] && n3 != Integer.MIN_VALUE || n3 > MAX_FIELD_VALUE[n2]) {
            throw new IllegalArgumentException("invalid value " + n3 + " for " + FIELD_NAME[n2] + " field");
        }
    }

    public void setHour(int n2) {
        this.checkFieldValueConstraint(3, n2);
        this.hour = n2;
    }

    public void setMinute(int n2) {
        this.checkFieldValueConstraint(4, n2);
        this.minute = n2;
    }

    public void setSecond(int n2) {
        this.checkFieldValueConstraint(5, n2);
        this.second = n2;
    }

    public void setTime(int n2, int n3, int n4, BigDecimal bigDecimal) {
        this.setHour(n2);
        this.setMinute(n3);
        this.setSecond(n4);
        this.setFractionalSecond(bigDecimal);
    }

    public void setTime(int n2, int n3, int n4, int n5) {
        this.setHour(n2);
        this.setMinute(n3);
        this.setSecond(n4);
        this.setMillisecond(n5);
    }

    public int compare(XMLGregorianCalendar xMLGregorianCalendar) {
        XMLGregorianCalendar xMLGregorianCalendar2;
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl = this;
        int n2 = 2;
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl2 = xMLGregorianCalendarImpl;
        XMLGregorianCalendarImpl xMLGregorianCalendarImpl3 = (XMLGregorianCalendarImpl)xMLGregorianCalendar;
        if (xMLGregorianCalendarImpl2.getTimezone() == xMLGregorianCalendarImpl3.getTimezone()) {
            return XMLGregorianCalendarImpl.internalCompare(xMLGregorianCalendarImpl2, xMLGregorianCalendarImpl3);
        }
        if (xMLGregorianCalendarImpl2.getTimezone() != Integer.MIN_VALUE && xMLGregorianCalendarImpl3.getTimezone() != Integer.MIN_VALUE) {
            xMLGregorianCalendarImpl2 = (XMLGregorianCalendarImpl)xMLGregorianCalendarImpl2.normalize();
            xMLGregorianCalendarImpl3 = (XMLGregorianCalendarImpl)xMLGregorianCalendarImpl3.normalize();
            return XMLGregorianCalendarImpl.internalCompare(xMLGregorianCalendarImpl2, xMLGregorianCalendarImpl3);
        }
        if (xMLGregorianCalendarImpl2.getTimezone() != Integer.MIN_VALUE) {
            XMLGregorianCalendar xMLGregorianCalendar3;
            if (xMLGregorianCalendarImpl2.getTimezone() != 0) {
                xMLGregorianCalendarImpl2 = (XMLGregorianCalendarImpl)xMLGregorianCalendarImpl2.normalize();
            }
            if ((n2 = XMLGregorianCalendarImpl.internalCompare(xMLGregorianCalendarImpl2, xMLGregorianCalendar3 = xMLGregorianCalendarImpl3.normalizeToTimezone(840))) == -1) {
                return n2;
            }
            XMLGregorianCalendar xMLGregorianCalendar4 = xMLGregorianCalendarImpl3.normalizeToTimezone(-840);
            n2 = XMLGregorianCalendarImpl.internalCompare(xMLGregorianCalendarImpl2, xMLGregorianCalendar4);
            if (n2 == 1) {
                return n2;
            }
            return 2;
        }
        if (xMLGregorianCalendarImpl3.getTimezone() != 0) {
            xMLGregorianCalendarImpl3 = (XMLGregorianCalendarImpl)xMLGregorianCalendarImpl3.normalizeToTimezone(xMLGregorianCalendarImpl3.getTimezone());
        }
        if ((n2 = XMLGregorianCalendarImpl.internalCompare(xMLGregorianCalendar2 = xMLGregorianCalendarImpl2.normalizeToTimezone(-840), xMLGregorianCalendarImpl3)) == -1) {
            return n2;
        }
        XMLGregorianCalendar xMLGregorianCalendar5 = xMLGregorianCalendarImpl2.normalizeToTimezone(840);
        n2 = XMLGregorianCalendarImpl.internalCompare(xMLGregorianCalendar5, xMLGregorianCalendarImpl3);
        if (n2 == 1) {
            return n2;
        }
        return 2;
    }

    public XMLGregorianCalendar normalize() {
        return this.normalizeToTimezone(this.timezone);
    }

    private XMLGregorianCalendar normalizeToTimezone(int n2) {
        int n3 = n2;
        XMLGregorianCalendar xMLGregorianCalendar = (XMLGregorianCalendar)this.clone();
        DurationImpl durationImpl = new DurationImpl((n3 = -n3) >= 0, 0, 0, 0, 0, n3 < 0 ? -n3 : n3, 0);
        xMLGregorianCalendar.add(durationImpl);
        xMLGregorianCalendar.setTimezone(0);
        return xMLGregorianCalendar;
    }

    private static int internalCompare(XMLGregorianCalendar xMLGregorianCalendar, XMLGregorianCalendar xMLGregorianCalendar2) {
        int n2;
        if (xMLGregorianCalendar.getEon() == xMLGregorianCalendar2.getEon() ? (n2 = XMLGregorianCalendarImpl.compareField(xMLGregorianCalendar.getYear(), xMLGregorianCalendar2.getYear())) != 0 : (n2 = XMLGregorianCalendarImpl.compareField(xMLGregorianCalendar.getEonAndYear(), xMLGregorianCalendar2.getEonAndYear())) != 0) {
            return n2;
        }
        n2 = XMLGregorianCalendarImpl.compareField(xMLGregorianCalendar.getMonth(), xMLGregorianCalendar2.getMonth());
        if (n2 != 0) {
            return n2;
        }
        n2 = XMLGregorianCalendarImpl.compareField(xMLGregorianCalendar.getDay(), xMLGregorianCalendar2.getDay());
        if (n2 != 0) {
            return n2;
        }
        n2 = XMLGregorianCalendarImpl.compareField(xMLGregorianCalendar.getHour(), xMLGregorianCalendar2.getHour());
        if (n2 != 0) {
            return n2;
        }
        n2 = XMLGregorianCalendarImpl.compareField(xMLGregorianCalendar.getMinute(), xMLGregorianCalendar2.getMinute());
        if (n2 != 0) {
            return n2;
        }
        n2 = XMLGregorianCalendarImpl.compareField(xMLGregorianCalendar.getSecond(), xMLGregorianCalendar2.getSecond());
        if (n2 != 0) {
            return n2;
        }
        n2 = XMLGregorianCalendarImpl.compareField(xMLGregorianCalendar.getFractionalSecond(), xMLGregorianCalendar2.getFractionalSecond());
        return n2;
    }

    private static int compareField(int n2, int n3) {
        if (n2 == n3) {
            return 0;
        }
        if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE) {
            return 2;
        }
        return n2 < n3 ? -1 : 1;
    }

    private static int compareField(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            return bigInteger2 == null ? 0 : 2;
        }
        if (bigInteger2 == null) {
            return 2;
        }
        return bigInteger.compareTo(bigInteger2);
    }

    private static int compareField(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal == bigDecimal2) {
            return 0;
        }
        if (bigDecimal == null) {
            bigDecimal = DECIMAL_ZERO;
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = DECIMAL_ZERO;
        }
        return bigDecimal.compareTo(bigDecimal2);
    }

    public boolean equals(Object object) {
        boolean bl2 = false;
        if (object instanceof XMLGregorianCalendar) {
            bl2 = this.compare((XMLGregorianCalendar)object) == 0;
        }
        return bl2;
    }

    public int hashCode() {
        int n2 = this.getTimezone();
        if (n2 == Integer.MIN_VALUE) {
            n2 = 0;
        }
        XMLGregorianCalendar xMLGregorianCalendar = this;
        if (n2 != 0) {
            xMLGregorianCalendar = this.normalizeToTimezone(this.getTimezone());
        }
        return xMLGregorianCalendar.getYear() + xMLGregorianCalendar.getMonth() + xMLGregorianCalendar.getDay() + xMLGregorianCalendar.getHour() + xMLGregorianCalendar.getMinute() + xMLGregorianCalendar.getSecond();
    }

    public static XMLGregorianCalendar parse(String string) {
        return new XMLGregorianCalendarImpl(string);
    }

    public String toXMLFormat() {
        QName qName = this.getXMLSchemaType();
        String string = null;
        if (qName == DATETIME) {
            string = "%Y-%M-%DT%h:%m:%s%z";
        } else if (qName == DATE) {
            string = "%Y-%M-%D%z";
        } else if (qName == TIME) {
            string = "%h:%m:%s%z";
        } else if (qName == GMONTH) {
            string = "--%M--%z";
        } else if (qName == GDAY) {
            string = "---%D%z";
        } else if (qName == GYEAR) {
            string = "%Y%z";
        } else if (qName == GYEARMONTH) {
            string = "%Y-%M%z";
        } else if (qName == GMONTHDAY) {
            string = "--%M-%D%z";
        }
        return this.format(string);
    }

    public QName getXMLSchemaType() {
        if (this.hour != Integer.MIN_VALUE) {
            if (this.minute == Integer.MIN_VALUE || this.second == Integer.MIN_VALUE) {
                throw new IllegalStateException("invalid set of fields set for XMLGregorianCalendar");
            }
            if (this.year == Integer.MIN_VALUE) {
                if (this.month != Integer.MIN_VALUE || this.day != Integer.MIN_VALUE) {
                    throw new IllegalStateException("invalid set of fields set for XMLGregorianCalendar");
                }
                return TIME;
            }
            if (this.month == Integer.MIN_VALUE || this.day == Integer.MIN_VALUE) {
                throw new IllegalStateException("invalid set of fields set for XMLGregorianCalendar");
            }
            return DATETIME;
        }
        if (this.minute != Integer.MIN_VALUE || this.second != Integer.MIN_VALUE) {
            throw new IllegalStateException("invalid set of fields set for XMLGregorianCalendar");
        }
        if (this.year != Integer.MIN_VALUE) {
            if (this.month != Integer.MIN_VALUE) {
                if (this.day != Integer.MIN_VALUE) {
                    return DATE;
                }
                return GYEARMONTH;
            }
            if (this.day == Integer.MIN_VALUE) {
                return GYEAR;
            }
        } else {
            if (this.month != Integer.MIN_VALUE) {
                if (this.day != Integer.MIN_VALUE) {
                    return GMONTHDAY;
                }
                return GMONTH;
            }
            if (this.day != Integer.MIN_VALUE) {
                return GDAY;
            }
        }
        throw new IllegalStateException("invalid set of fields set for XMLGregorianCalendar");
    }

    public String toString() {
        return this.toXMLFormat();
    }

    public boolean isValid() {
        int n2;
        BigInteger bigInteger;
        if (this.getMonth() == 2) {
            int n3 = Integer.MIN_VALUE;
            BigInteger bigInteger2 = this.getEonAndYear();
            n3 = bigInteger2 != null ? XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), 2) : 29;
            if (this.getDay() > n3) {
                return false;
            }
        }
        if (this.getHour() == 24) {
            if (this.getMinute() != 0) {
                return false;
            }
            if (this.getSecond() != 0) {
                return false;
            }
        }
        return !(this.eon == null ? this.year == 0 : (bigInteger = this.getEonAndYear()) != null && (n2 = XMLGregorianCalendarImpl.compareField(bigInteger, BigInteger.ZERO)) == 0);
    }

    public void add(Duration duration) {
        int n2;
        BigDecimal bigDecimal;
        boolean[] blArray = new boolean[]{false, false, false, false, false, false};
        int n3 = duration.getSign();
        int n4 = this.getMonth();
        if (n4 == Integer.MIN_VALUE) {
            n4 = MIN_FIELD_VALUE[1];
            blArray[1] = true;
        }
        BigInteger bigInteger = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.MONTHS), n3);
        BigInteger bigInteger2 = BigInteger.valueOf(n4).add(bigInteger);
        this.setMonth(bigInteger2.subtract(BigInteger.ONE).mod(TWELVE).intValue() + 1);
        BigInteger bigInteger3 = new BigDecimal(bigInteger2.subtract(BigInteger.ONE)).divide(new BigDecimal(TWELVE), 3).toBigInteger();
        BigInteger bigInteger4 = this.getEonAndYear();
        if (bigInteger4 == null) {
            blArray[0] = true;
            bigInteger4 = BigInteger.ZERO;
        }
        BigInteger bigInteger5 = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.YEARS), n3);
        BigInteger bigInteger6 = bigInteger4.add(bigInteger5).add(bigInteger3);
        this.setYear(bigInteger6);
        if (this.getSecond() == Integer.MIN_VALUE) {
            blArray[5] = true;
            bigDecimal = DECIMAL_ZERO;
        } else {
            bigDecimal = this.getSeconds();
        }
        BigDecimal bigDecimal2 = DurationImpl.sanitize((BigDecimal)duration.getField(DatatypeConstants.SECONDS), n3);
        BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
        BigDecimal bigDecimal4 = new BigDecimal(new BigDecimal(bigDecimal3.toBigInteger()).divide(DECIMAL_SIXTY, 3).toBigInteger());
        BigDecimal bigDecimal5 = bigDecimal3.subtract(bigDecimal4.multiply(DECIMAL_SIXTY));
        bigInteger3 = bigDecimal4.toBigInteger();
        this.setSecond(bigDecimal5.intValue());
        BigDecimal bigDecimal6 = bigDecimal5.subtract(new BigDecimal(BigInteger.valueOf(this.getSecond())));
        if (bigDecimal6.compareTo(DECIMAL_ZERO) < 0) {
            this.setFractionalSecond(DECIMAL_ONE.add(bigDecimal6));
            if (this.getSecond() == 0) {
                this.setSecond(59);
                bigInteger3 = bigInteger3.subtract(BigInteger.ONE);
            } else {
                this.setSecond(this.getSecond() - 1);
            }
        } else {
            this.setFractionalSecond(bigDecimal6);
        }
        int n5 = this.getMinute();
        if (n5 == Integer.MIN_VALUE) {
            blArray[4] = true;
            n5 = MIN_FIELD_VALUE[4];
        }
        BigInteger bigInteger7 = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.MINUTES), n3);
        bigInteger2 = BigInteger.valueOf(n5).add(bigInteger7).add(bigInteger3);
        this.setMinute(bigInteger2.mod(SIXTY).intValue());
        bigInteger3 = new BigDecimal(bigInteger2).divide(DECIMAL_SIXTY, 3).toBigInteger();
        int n6 = this.getHour();
        if (n6 == Integer.MIN_VALUE) {
            blArray[3] = true;
            n6 = MIN_FIELD_VALUE[3];
        }
        BigInteger bigInteger8 = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.HOURS), n3);
        bigInteger2 = BigInteger.valueOf(n6).add(bigInteger8).add(bigInteger3);
        this.setHour(bigInteger2.mod(TWENTY_FOUR).intValue());
        bigInteger3 = new BigDecimal(bigInteger2).divide(new BigDecimal(TWENTY_FOUR), 3).toBigInteger();
        int n7 = this.getDay();
        if (n7 == Integer.MIN_VALUE) {
            blArray[2] = true;
            n7 = MIN_FIELD_VALUE[2];
        }
        BigInteger bigInteger9 = XMLGregorianCalendarImpl.sanitize(duration.getField(DatatypeConstants.DAYS), n3);
        int n8 = XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth());
        BigInteger bigInteger10 = n7 > n8 ? BigInteger.valueOf(n8) : (n7 < 1 ? BigInteger.ONE : BigInteger.valueOf(n7));
        BigInteger bigInteger11 = bigInteger10.add(bigInteger9).add(bigInteger3);
        while (true) {
            int n9;
            int n10;
            if (bigInteger11.compareTo(BigInteger.ONE) < 0) {
                BigInteger bigInteger12 = null;
                bigInteger12 = this.month >= 2 ? BigInteger.valueOf(XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth() - 1)) : BigInteger.valueOf(XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear().subtract(BigInteger.valueOf(1L)), 12));
                bigInteger11 = bigInteger11.add(bigInteger12);
                n10 = -1;
            } else {
                if (bigInteger11.compareTo(BigInteger.valueOf(XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth()))) <= 0) break;
                bigInteger11 = bigInteger11.add(BigInteger.valueOf(-XMLGregorianCalendarImpl.maximumDayInMonthFor(this.getEonAndYear(), this.getMonth())));
                n10 = 1;
            }
            int n11 = this.getMonth() + n10;
            n2 = (n11 - 1) % 12;
            if (n2 < 0) {
                n2 = 12 + n2 + 1;
                n9 = new BigDecimal(n11 - 1).divide(new BigDecimal(TWELVE), 0).intValue();
            } else {
                n9 = (n11 - 1) / 12;
                ++n2;
            }
            this.setMonth(n2);
            if (n9 == 0) continue;
            this.setYear(this.getEonAndYear().add(BigInteger.valueOf(n9)));
        }
        this.setDay(bigInteger11.intValue());
        block9: for (n2 = 0; n2 <= 5; ++n2) {
            if (!blArray[n2]) continue;
            switch (n2) {
                case 0: {
                    this.setYear(Integer.MIN_VALUE);
                    continue block9;
                }
                case 1: {
                    this.setMonth(Integer.MIN_VALUE);
                    continue block9;
                }
                case 2: {
                    this.setDay(Integer.MIN_VALUE);
                    continue block9;
                }
                case 3: {
                    this.setHour(Integer.MIN_VALUE);
                    continue block9;
                }
                case 4: {
                    this.setMinute(Integer.MIN_VALUE);
                    continue block9;
                }
                case 5: {
                    this.setSecond(Integer.MIN_VALUE);
                    this.setFractionalSecond(null);
                }
            }
        }
    }

    private static int maximumDayInMonthFor(BigInteger bigInteger, int n2) {
        if (n2 != 2) {
            return daysInMonth[n2];
        }
        if (bigInteger.mod(FOUR_HUNDRED).equals(BigInteger.ZERO) || !bigInteger.mod(HUNDRED).equals(BigInteger.ZERO) && bigInteger.mod(FOUR).equals(BigInteger.ZERO)) {
            return 29;
        }
        return daysInMonth[n2];
    }

    private static int maximumDayInMonthFor(int n2, int n3) {
        if (n3 != 2) {
            return daysInMonth[n3];
        }
        if (n2 % 400 == 0 || n2 % 100 != 0 && n2 % 4 == 0) {
            return 29;
        }
        return daysInMonth[2];
    }

    public GregorianCalendar toGregorianCalendar() {
        GregorianCalendar gregorianCalendar = null;
        TimeZone timeZone = this.getTimeZone(Integer.MIN_VALUE);
        Locale locale = Locale.getDefault();
        gregorianCalendar = new GregorianCalendar(timeZone, locale);
        gregorianCalendar.clear();
        gregorianCalendar.setGregorianChange(PURE_GREGORIAN_CHANGE);
        BigInteger bigInteger = this.getEonAndYear();
        if (bigInteger != null) {
            gregorianCalendar.set(0, bigInteger.signum() == -1 ? 0 : 1);
            gregorianCalendar.set(1, bigInteger.abs().intValue());
        }
        if (this.month != Integer.MIN_VALUE) {
            gregorianCalendar.set(2, this.month - 1);
        }
        if (this.day != Integer.MIN_VALUE) {
            gregorianCalendar.set(5, this.day);
        }
        if (this.hour != Integer.MIN_VALUE) {
            gregorianCalendar.set(11, this.hour);
        }
        if (this.minute != Integer.MIN_VALUE) {
            gregorianCalendar.set(12, this.minute);
        }
        if (this.second != Integer.MIN_VALUE) {
            gregorianCalendar.set(13, this.second);
        }
        if (this.fractionalSecond != null) {
            gregorianCalendar.set(14, this.getMillisecond());
        }
        return gregorianCalendar;
    }

    public GregorianCalendar toGregorianCalendar(TimeZone timeZone, Locale locale, XMLGregorianCalendar xMLGregorianCalendar) {
        Number number;
        GregorianCalendar gregorianCalendar = null;
        TimeZone timeZone2 = timeZone;
        if (timeZone2 == null) {
            int n2 = Integer.MIN_VALUE;
            if (xMLGregorianCalendar != null) {
                n2 = xMLGregorianCalendar.getTimezone();
            }
            timeZone2 = this.getTimeZone(n2);
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        gregorianCalendar = new GregorianCalendar(timeZone2, locale);
        gregorianCalendar.clear();
        gregorianCalendar.setGregorianChange(PURE_GREGORIAN_CHANGE);
        BigInteger bigInteger = this.getEonAndYear();
        if (bigInteger != null) {
            gregorianCalendar.set(0, bigInteger.signum() == -1 ? 0 : 1);
            gregorianCalendar.set(1, bigInteger.abs().intValue());
        } else {
            number = xMLGregorianCalendar.getEonAndYear();
            if (number != null) {
                gregorianCalendar.set(0, number.signum() == -1 ? 0 : 1);
                gregorianCalendar.set(1, number.abs().intValue());
            }
        }
        if (this.month != Integer.MIN_VALUE) {
            gregorianCalendar.set(2, this.month - 1);
        } else {
            int n3 = xMLGregorianCalendar.getMonth();
            if (n3 != Integer.MIN_VALUE) {
                gregorianCalendar.set(2, n3 - 1);
            }
        }
        if (this.day != Integer.MIN_VALUE) {
            gregorianCalendar.set(5, this.day);
        } else {
            int n4 = xMLGregorianCalendar.getDay();
            if (n4 != Integer.MIN_VALUE) {
                gregorianCalendar.set(5, n4);
            }
        }
        if (this.hour != Integer.MIN_VALUE) {
            gregorianCalendar.set(11, this.hour);
        } else {
            int n5 = xMLGregorianCalendar.getHour();
            if (n5 != Integer.MIN_VALUE) {
                gregorianCalendar.set(11, n5);
            }
        }
        if (this.minute != Integer.MIN_VALUE) {
            gregorianCalendar.set(12, this.minute);
        } else {
            int n6 = xMLGregorianCalendar.getMinute();
            if (n6 != Integer.MIN_VALUE) {
                gregorianCalendar.set(12, n6);
            }
        }
        if (this.second != Integer.MIN_VALUE) {
            gregorianCalendar.set(13, this.second);
        } else {
            int n7 = xMLGregorianCalendar.getSecond();
            if (n7 != Integer.MIN_VALUE) {
                gregorianCalendar.set(13, n7);
            }
        }
        if (this.fractionalSecond != null) {
            gregorianCalendar.set(14, this.getMillisecond());
        } else {
            number = xMLGregorianCalendar.getFractionalSecond();
            if (number != null) {
                gregorianCalendar.set(14, xMLGregorianCalendar.getMillisecond());
            }
        }
        return gregorianCalendar;
    }

    public TimeZone getTimeZone(int n2) {
        TimeZone timeZone = null;
        int n3 = this.getTimezone();
        if (n3 == Integer.MIN_VALUE) {
            n3 = n2;
        }
        if (n3 == Integer.MIN_VALUE) {
            timeZone = TimeZone.getDefault();
        } else {
            char c2;
            char c3 = c2 = n3 < 0 ? (char)'-' : '+';
            if (c2 == '-') {
                n3 = -n3;
            }
            int n4 = n3 / 60;
            int n5 = n3 - n4 * 60;
            StringBuffer stringBuffer = new StringBuffer(8);
            stringBuffer.append("GMT");
            stringBuffer.append(c2);
            stringBuffer.append(n4);
            if (n5 != 0) {
                stringBuffer.append(n5);
            }
            timeZone = TimeZone.getTimeZone(stringBuffer.toString());
        }
        return timeZone;
    }

    public Object clone() {
        return new XMLGregorianCalendarImpl(this.getEonAndYear(), this.month, this.day, this.hour, this.minute, this.second, this.fractionalSecond, this.timezone);
    }

    public void clear() {
        this.eon = null;
        this.year = Integer.MIN_VALUE;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.timezone = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.fractionalSecond = null;
    }

    public void setMillisecond(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.fractionalSecond = null;
        } else {
            this.checkFieldValueConstraint(6, n2);
            this.fractionalSecond = new BigDecimal((long)n2).movePointLeft(3);
        }
    }

    public void setFractionalSecond(BigDecimal bigDecimal) {
        if (bigDecimal != null && (bigDecimal.compareTo(DECIMAL_ZERO) < 0 || bigDecimal.compareTo(DECIMAL_ONE) > 0)) {
            throw new IllegalArgumentException("invalid value " + bigDecimal + " for fractional second");
        }
        this.fractionalSecond = bigDecimal;
    }

    private static boolean isDigit(char c2) {
        return '0' <= c2 && c2 <= '9';
    }

    private String format(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string.length();
        block9: while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) != '%') {
                stringBuffer.append(c2);
                continue;
            }
            switch (string.charAt(n2++)) {
                case 'Y': {
                    this.printNumber(stringBuffer, this.getEonAndYear(), 4);
                    continue block9;
                }
                case 'M': {
                    this.printNumber(stringBuffer, this.getMonth(), 2);
                    continue block9;
                }
                case 'D': {
                    this.printNumber(stringBuffer, this.getDay(), 2);
                    continue block9;
                }
                case 'h': {
                    this.printNumber(stringBuffer, this.getHour(), 2);
                    continue block9;
                }
                case 'm': {
                    this.printNumber(stringBuffer, this.getMinute(), 2);
                    continue block9;
                }
                case 's': {
                    this.printNumber(stringBuffer, this.getSecond(), 2);
                    if (this.getFractionalSecond() == null) continue block9;
                    String string2 = this.getFractionalSecond().toString();
                    stringBuffer.append(string2.substring(1, string2.length()));
                    continue block9;
                }
                case 'z': {
                    int n4 = this.getTimezone();
                    if (n4 == 0) {
                        stringBuffer.append('Z');
                        continue block9;
                    }
                    if (n4 == Integer.MIN_VALUE) continue block9;
                    if (n4 < 0) {
                        stringBuffer.append('-');
                        n4 *= -1;
                    } else {
                        stringBuffer.append('+');
                    }
                    this.printNumber(stringBuffer, n4 / 60, 2);
                    stringBuffer.append(':');
                    this.printNumber(stringBuffer, n4 % 60, 2);
                    continue block9;
                }
            }
            throw new InternalError();
        }
        return stringBuffer.toString();
    }

    private void printNumber(StringBuffer stringBuffer, int n2, int n3) {
        String string = String.valueOf(n2);
        for (int i2 = string.length(); i2 < n3; ++i2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
    }

    private void printNumber(StringBuffer stringBuffer, BigInteger bigInteger, int n2) {
        String string = bigInteger.toString();
        for (int i2 = string.length(); i2 < n2; ++i2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
    }

    static BigInteger sanitize(Number number, int n2) {
        if (n2 == 0 || number == null) {
            return BigInteger.ZERO;
        }
        return n2 < 0 ? ((BigInteger)number).negate() : (BigInteger)number;
    }

    public void reset() {
    }

    private final class Parser {
        private final String format;
        private final String value;
        private final int flen;
        private final int vlen;
        private int fidx;
        private int vidx;

        private Parser(String string, String string2) {
            this.format = string;
            this.value = string2;
            this.flen = string.length();
            this.vlen = string2.length();
        }

        public void parse() throws IllegalArgumentException {
            block9: while (this.fidx < this.flen) {
                char c2;
                if ((c2 = this.format.charAt(this.fidx++)) != '%') {
                    this.skip(c2);
                    continue;
                }
                switch (this.format.charAt(this.fidx++)) {
                    case 'Y': {
                        XMLGregorianCalendarImpl.this.setYear(this.parseBigInteger(4));
                        continue block9;
                    }
                    case 'M': {
                        XMLGregorianCalendarImpl.this.setMonth(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 'D': {
                        XMLGregorianCalendarImpl.this.setDay(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 'h': {
                        XMLGregorianCalendarImpl.this.setHour(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 'm': {
                        XMLGregorianCalendarImpl.this.setMinute(this.parseInt(2, 2));
                        continue block9;
                    }
                    case 's': {
                        XMLGregorianCalendarImpl.this.setSecond(this.parseInt(2, 2));
                        if (this.peek() != '.') continue block9;
                        XMLGregorianCalendarImpl.this.setFractionalSecond(this.parseBigDecimal());
                        continue block9;
                    }
                    case 'z': {
                        char c3 = this.peek();
                        if (c3 == 'Z') {
                            ++this.vidx;
                            XMLGregorianCalendarImpl.this.setTimezone(0);
                            continue block9;
                        }
                        if (c3 != '+' && c3 != '-') continue block9;
                        ++this.vidx;
                        int n2 = this.parseInt(2, 2);
                        this.skip(':');
                        int n3 = this.parseInt(2, 2);
                        XMLGregorianCalendarImpl.this.setTimezone((n2 * 60 + n3) * (c3 == '+' ? 1 : -1));
                        continue block9;
                    }
                }
                throw new InternalError();
            }
            if (this.vidx != this.vlen) {
                throw new IllegalArgumentException(this.value);
            }
        }

        private char peek() throws IllegalArgumentException {
            if (this.vidx == this.vlen) {
                return '\uffff';
            }
            return this.value.charAt(this.vidx);
        }

        private char read() throws IllegalArgumentException {
            if (this.vidx == this.vlen) {
                throw new IllegalArgumentException(this.value);
            }
            return this.value.charAt(this.vidx++);
        }

        private void skip(char c2) throws IllegalArgumentException {
            if (this.read() != c2) {
                throw new IllegalArgumentException(this.value);
            }
        }

        private int parseInt(int n2, int n3) throws IllegalArgumentException {
            int n4 = this.vidx;
            while (XMLGregorianCalendarImpl.isDigit(this.peek()) && this.vidx - n4 <= n3) {
                ++this.vidx;
            }
            if (this.vidx - n4 < n2) {
                throw new IllegalArgumentException(this.value);
            }
            return Integer.parseInt(this.value.substring(n4, this.vidx));
        }

        private BigInteger parseBigInteger(int n2) throws IllegalArgumentException {
            int n3 = this.vidx++;
            if (this.peek() == '-') {
                // empty if block
            }
            while (XMLGregorianCalendarImpl.isDigit(this.peek())) {
                ++this.vidx;
            }
            if (this.vidx - n3 < n2) {
                throw new IllegalArgumentException(this.value);
            }
            return new BigInteger(this.value.substring(n3, this.vidx));
        }

        private BigDecimal parseBigDecimal() throws IllegalArgumentException {
            int n2 = this.vidx++;
            if (this.peek() != '.') {
                throw new IllegalArgumentException(this.value);
            }
            while (XMLGregorianCalendarImpl.isDigit(this.peek())) {
                ++this.vidx;
            }
            return new BigDecimal(this.value.substring(n2, this.vidx));
        }
    }
}

