/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.parsers;

import com.sun.org.apache.xerces.internal.parsers.AbstractXMLDocumentParser;
import com.sun.org.apache.xerces.internal.util.EntityResolver2Wrapper;
import com.sun.org.apache.xerces.internal.util.EntityResolverWrapper;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.SAXMessageFormatter;
import com.sun.org.apache.xerces.internal.util.SymbolHash;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLResourceIdentifier;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLErrorHandler;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParseException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration;
import com.sun.org.apache.xerces.internal.xs.AttributePSVI;
import com.sun.org.apache.xerces.internal.xs.ElementPSVI;
import com.sun.org.apache.xerces.internal.xs.PSVIProvider;
import java.io.IOException;
import java.util.Locale;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.LocatorImpl;

public abstract class AbstractSAXParser
extends AbstractXMLDocumentParser
implements PSVIProvider,
Parser,
XMLReader {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    protected static final String ALLOW_UE_AND_NOTATION_EVENTS = "http://xml.org/sax/features/allow-dtd-events-after-endDTD";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://xml.org/sax/features/namespace-prefixes", "http://xml.org/sax/features/string-interning"};
    protected static final String LEXICAL_HANDLER = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DECLARATION_HANDLER = "http://xml.org/sax/properties/declaration-handler";
    protected static final String DOM_NODE = "http://xml.org/sax/properties/dom-node";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://xml.org/sax/properties/lexical-handler", "http://xml.org/sax/properties/declaration-handler", "http://xml.org/sax/properties/dom-node"};
    protected boolean fNamespaces;
    protected boolean fNamespacePrefixes = false;
    protected boolean fLexicalHandlerParameterEntities = true;
    protected ContentHandler fContentHandler;
    protected DocumentHandler fDocumentHandler;
    protected NamespaceContext fNamespaceContext;
    protected DTDHandler fDTDHandler;
    protected DeclHandler fDeclHandler;
    protected LexicalHandler fLexicalHandler;
    protected QName fQName = new QName();
    protected boolean resolve_dtd_uris = true;
    protected boolean startDocumentCalled = false;
    protected boolean resolverType = true;
    protected boolean locatorType = false;
    protected boolean attributeType = true;
    protected boolean isStandalone = false;
    protected boolean fParseInProgress = false;
    protected String fVersion;
    private final AttributesProxy fAttributesProxy = new AttributesProxy();
    private Augmentations fAugmentations = null;
    private static final int BUFFER_SIZE = 20;
    private char[] fCharBuffer = new char[20];
    protected SymbolHash fDeclaredAttrs = null;

    protected AbstractSAXParser(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        xMLParserConfiguration.addRecognizedFeatures(RECOGNIZED_FEATURES);
        xMLParserConfiguration.addRecognizedProperties(RECOGNIZED_PROPERTIES);
        try {
            xMLParserConfiguration.setFeature(ALLOW_UE_AND_NOTATION_EVENTS, false);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        this.startDocumentCalled = true;
        try {
            if (this.fDocumentHandler != null) {
                if (xMLLocator != null) {
                    this.fDocumentHandler.setDocumentLocator(new LocatorProxy(xMLLocator));
                }
                this.fDocumentHandler.startDocument();
            }
            if (this.fContentHandler != null) {
                if (xMLLocator != null) {
                    this.locatorType = true;
                    this.fContentHandler.setDocumentLocator(new LocatorProxy(xMLLocator));
                }
                this.fContentHandler.startDocument();
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.fVersion = string;
        this.isStandalone = string3 != null && string3.equalsIgnoreCase("yes");
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.fInDTD = true;
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startDTD(string, string2, string3);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
        if (this.fDeclHandler != null) {
            this.fDeclaredAttrs = new SymbolHash();
        }
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        try {
            if (augmentations != null && Boolean.TRUE.equals(augmentations.getItem("ENTITY_SKIPPED"))) {
                if (this.fContentHandler != null) {
                    this.fContentHandler.skippedEntity(string);
                }
            } else if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startEntity(string);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        try {
            if (!(augmentations != null && Boolean.TRUE.equals(augmentations.getItem("ENTITY_SKIPPED")) || this.fLexicalHandler == null)) {
                this.fLexicalHandler.endEntity(string);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fAttributesProxy.setAttributes(xMLAttributes);
                this.fDocumentHandler.startElement(qName.rawname, this.fAttributesProxy);
            }
            if (this.fContentHandler != null) {
                if (this.fNamespaces) {
                    this.startNamespaceMapping();
                    int n2 = xMLAttributes.getLength();
                    for (int i2 = n2 - 1; i2 >= 0; --i2) {
                        xMLAttributes.getName(i2, this.fQName);
                        if (this.fQName.prefix != XMLSymbols.PREFIX_XMLNS && this.fQName.rawname != XMLSymbols.PREFIX_XMLNS) continue;
                        if (!this.fNamespacePrefixes) {
                            xMLAttributes.removeAttributeAt(i2);
                            continue;
                        }
                        this.fQName.prefix = "";
                        this.fQName.uri = "";
                        this.fQName.localpart = "";
                        xMLAttributes.setName(i2, this.fQName);
                    }
                }
                this.fAugmentations = augmentations;
                String string = qName.uri != null ? qName.uri : "";
                String string2 = this.fNamespaces ? qName.localpart : "";
                this.fAttributesProxy.setAttributes(xMLAttributes);
                this.fContentHandler.startElement(string, string2, qName.rawname, this.fAttributesProxy);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (xMLString.length == 0) {
            return;
        }
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.characters(xMLString.ch, xMLString.offset, xMLString.length);
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.characters(xMLString.ch, xMLString.offset, xMLString.length);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.ignorableWhitespace(xMLString.ch, xMLString.offset, xMLString.length);
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.ignorableWhitespace(xMLString.ch, xMLString.offset, xMLString.length);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endElement(qName.rawname);
            }
            if (this.fContentHandler != null) {
                this.fAugmentations = augmentations;
                String string = qName.uri != null ? qName.uri : "";
                String string2 = this.fNamespaces ? qName.localpart : "";
                this.fContentHandler.endElement(string, string2, qName.rawname);
                if (this.fNamespaces) {
                    this.endNamespaceMapping();
                }
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.startCDATA();
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.endCDATA();
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.comment(xMLString.ch, 0, xMLString.length);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.processingInstruction(string, xMLString.toString());
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.processingInstruction(string, xMLString.toString());
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        try {
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.endDocument();
            }
            if (this.fContentHandler != null) {
                this.fContentHandler.endDocument();
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void startExternalSubset(XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.startParameterEntity("[dtd]", null, null, augmentations);
    }

    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        this.endParameterEntity("[dtd]", augmentations);
    }

    public void startParameterEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        try {
            if (augmentations != null && Boolean.TRUE.equals(augmentations.getItem("ENTITY_SKIPPED"))) {
                if (this.fContentHandler != null) {
                    this.fContentHandler.skippedEntity(string);
                }
            } else if (this.fLexicalHandler != null && this.fLexicalHandlerParameterEntities) {
                this.fLexicalHandler.startEntity(string);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endParameterEntity(String string, Augmentations augmentations) throws XNIException {
        try {
            if ((augmentations == null || !Boolean.TRUE.equals(augmentations.getItem("ENTITY_SKIPPED"))) && this.fLexicalHandler != null && this.fLexicalHandlerParameterEntities) {
                this.fLexicalHandler.endEntity(string);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void elementDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                this.fDeclHandler.elementDecl(string, string2);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                CharSequence charSequence;
                String string5 = new StringBuffer(string).append("<").append(string2).toString();
                if (this.fDeclaredAttrs.get(string5) != null) {
                    return;
                }
                this.fDeclaredAttrs.put(string5, Boolean.TRUE);
                if (string3.equals("NOTATION") || string3.equals("ENUMERATION")) {
                    charSequence = new StringBuffer();
                    if (string3.equals("NOTATION")) {
                        ((StringBuffer)charSequence).append(string3);
                        ((StringBuffer)charSequence).append(" (");
                    } else {
                        ((StringBuffer)charSequence).append("(");
                    }
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        ((StringBuffer)charSequence).append(stringArray[i2]);
                        if (i2 >= stringArray.length - 1) continue;
                        ((StringBuffer)charSequence).append('|');
                    }
                    ((StringBuffer)charSequence).append(')');
                    string3 = ((StringBuffer)charSequence).toString();
                }
                charSequence = xMLString == null ? null : xMLString.toString();
                this.fDeclHandler.attributeDecl(string, string2, string3, string4, (String)charSequence);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void internalEntityDecl(String string, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        try {
            if (this.fDeclHandler != null) {
                this.fDeclHandler.internalEntityDecl(string, xMLString.toString());
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void externalEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        String string2 = xMLResourceIdentifier.getPublicId();
        String string3 = xMLResourceIdentifier.getLiteralSystemId();
        String string4 = xMLResourceIdentifier.getExpandedSystemId();
        try {
            if (this.fDeclHandler != null) {
                this.fDeclHandler.externalEntityDecl(string, string2, this.resolve_dtd_uris ? string4 : string3);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void unparsedEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        String string3 = xMLResourceIdentifier.getPublicId();
        String string4 = xMLResourceIdentifier.getExpandedSystemId();
        String string5 = xMLResourceIdentifier.getLiteralSystemId();
        try {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.unparsedEntityDecl(string, string3, this.resolve_dtd_uris ? string4 : string5, string2);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void notationDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        String string2 = xMLResourceIdentifier.getPublicId();
        String string3 = xMLResourceIdentifier.getExpandedSystemId();
        String string4 = xMLResourceIdentifier.getLiteralSystemId();
        try {
            if (this.fDTDHandler != null) {
                this.fDTDHandler.notationDecl(string, string2, this.resolve_dtd_uris ? string3 : string4);
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
        this.fInDTD = false;
        try {
            if (this.fLexicalHandler != null) {
                this.fLexicalHandler.endDTD();
            }
        }
        catch (SAXException sAXException) {
            throw new XNIException(sAXException);
        }
        if (this.fDeclaredAttrs != null) {
            this.fDeclaredAttrs.clear();
        }
    }

    public void parse(String string) throws SAXException, IOException {
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
        try {
            this.parse(xMLInputSource);
        }
        catch (XMLParseException xMLParseException) {
            Exception exception = xMLParseException.getException();
            if (exception == null) {
                this.locatorType = true;
                LocatorImpl locatorImpl = new LocatorImpl(){

                    public String getXMLVersion() {
                        return AbstractSAXParser.this.fVersion;
                    }

                    public String getEncoding() {
                        return null;
                    }
                };
                locatorImpl.setPublicId(xMLParseException.getPublicId());
                locatorImpl.setSystemId(xMLParseException.getExpandedSystemId());
                locatorImpl.setLineNumber(xMLParseException.getLineNumber());
                locatorImpl.setColumnNumber(xMLParseException.getColumnNumber());
                throw new SAXParseException(xMLParseException.getMessage(), locatorImpl);
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
        catch (XNIException xNIException) {
            Exception exception = xNIException.getException();
            if (exception == null) {
                throw new SAXException(xNIException.getMessage());
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(inputSource.getPublicId(), inputSource.getSystemId(), null);
            xMLInputSource.setByteStream(inputSource.getByteStream());
            xMLInputSource.setCharacterStream(inputSource.getCharacterStream());
            xMLInputSource.setEncoding(inputSource.getEncoding());
            this.parse(xMLInputSource);
        }
        catch (XMLParseException xMLParseException) {
            Exception exception = xMLParseException.getException();
            if (exception == null) {
                this.locatorType = true;
                LocatorImpl locatorImpl = new LocatorImpl(){

                    public String getXMLVersion() {
                        return AbstractSAXParser.this.fVersion;
                    }

                    public String getEncoding() {
                        return null;
                    }
                };
                locatorImpl.setPublicId(xMLParseException.getPublicId());
                locatorImpl.setSystemId(xMLParseException.getExpandedSystemId());
                locatorImpl.setLineNumber(xMLParseException.getLineNumber());
                locatorImpl.setColumnNumber(xMLParseException.getColumnNumber());
                throw new SAXParseException(xMLParseException.getMessage(), locatorImpl);
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
        catch (XNIException xNIException) {
            Exception exception = xNIException.getException();
            if (exception == null) {
                throw new SAXException(xNIException.getMessage());
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new SAXException(exception);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        try {
            if (entityResolver instanceof EntityResolver2) {
                this.resolverType = true;
                this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolver2Wrapper((EntityResolver2)entityResolver));
            } else {
                this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolverWrapper(entityResolver));
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public EntityResolver getEntityResolver() {
        EntityResolver entityResolver = null;
        try {
            XMLEntityResolver xMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            if (xMLEntityResolver != null && xMLEntityResolver instanceof EntityResolverWrapper) {
                entityResolver = ((EntityResolverWrapper)xMLEntityResolver).getEntityResolver();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", new ErrorHandlerWrapper(errorHandler));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = null;
        try {
            XMLErrorHandler xMLErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
            if (xMLErrorHandler != null && xMLErrorHandler instanceof ErrorHandlerWrapper) {
                errorHandler = ((ErrorHandlerWrapper)xMLErrorHandler).getErrorHandler();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return errorHandler;
    }

    public void setLocale(Locale locale) throws SAXException {
        this.fConfiguration.setLocale(locale);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.fDTDHandler = dTDHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.fDocumentHandler = documentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fContentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fContentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setFeature(String string, boolean bl2) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (string.startsWith("http://xml.org/sax/features/")) {
                int n2 = string.length() - "http://xml.org/sax/features/".length();
                if (n2 == "namespaces".length() && string.endsWith("namespaces")) {
                    this.fConfiguration.setFeature(string, bl2);
                    this.fNamespaces = bl2;
                    return;
                }
                if (n2 == "namespace-prefixes".length() && string.endsWith("namespace-prefixes")) {
                    this.fConfiguration.setFeature(string, bl2);
                    this.fNamespacePrefixes = bl2;
                    return;
                }
                if (n2 == "string-interning".length() && string.endsWith("string-interning")) {
                    if (!bl2) {
                        throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "false-not-supported", new Object[]{string}));
                    }
                    return;
                }
                if (n2 == "lexical-handler/parameter-entities".length() && string.endsWith("lexical-handler/parameter-entities")) {
                    this.fLexicalHandlerParameterEntities = bl2;
                    return;
                }
                if (n2 == "resolve-dtd-uris".length() && string.endsWith("resolve-dtd-uris")) {
                    this.resolve_dtd_uris = bl2;
                    this.fConfiguration.setFeature(string, bl2);
                    return;
                }
                if (n2 == "xml-1.1".length() && string.endsWith("xml-1.1") || n2 == "use-entity-resolver2".length() && string.endsWith("use-entity-resolver2") || n2 == "use-locator2".length() && string.endsWith("use-locator2") || n2 == "use-attributes2".length() && string.endsWith("use-attributes2") || n2 == "is-standalone".length() && string.endsWith("is-standalone")) {
                    throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-read-only", new Object[]{string}));
                }
            }
            this.fConfiguration.setFeature(string, bl2);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-recognized", new Object[]{string2}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-supported", new Object[]{string2}));
        }
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (string.startsWith("http://xml.org/sax/features/")) {
                int n2 = string.length() - "http://xml.org/sax/features/".length();
                if (n2 == "namespace-prefixes".length() && string.endsWith("namespace-prefixes")) {
                    boolean bl2 = this.fConfiguration.getFeature(string);
                    return bl2;
                }
                if (n2 == "string-interning".length() && string.endsWith("string-interning")) {
                    return true;
                }
                if (n2 == "lexical-handler/parameter-entities".length() && string.endsWith("lexical-handler/parameter-entities")) {
                    return this.fLexicalHandlerParameterEntities;
                }
                if (n2 == "use-entity-resolver2".length() && string.endsWith("use-entity-resolver2")) {
                    return this.resolverType;
                }
                if (n2 == "use-locator2".length() && string.endsWith("use-locator2")) {
                    return this.locatorType;
                }
                if (n2 == "use-attributes2".length() && string.endsWith("use-attributes2")) {
                    return this.attributeType;
                }
                if (n2 == "is-standalone".length() && string.endsWith("is-standalone")) {
                    return this.isStandalone;
                }
            }
            return this.fConfiguration.getFeature(string);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-recognized", new Object[]{string2}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-supported", new Object[]{string2}));
        }
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (string.startsWith("http://xml.org/sax/properties/")) {
                int n2 = string.length() - "http://xml.org/sax/properties/".length();
                if (n2 == "lexical-handler".length() && string.endsWith("lexical-handler")) {
                    try {
                        this.setLexicalHandler((LexicalHandler)object);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "incompatible-class", new Object[]{string, "org.xml.sax.ext.LexicalHandler"}));
                    }
                    return;
                }
                if (n2 == "declaration-handler".length() && string.endsWith("declaration-handler")) {
                    try {
                        this.setDeclHandler((DeclHandler)object);
                    }
                    catch (ClassCastException classCastException) {
                        throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "incompatible-class", new Object[]{string, "org.xml.sax.ext.DeclHandler"}));
                    }
                    return;
                }
                if (n2 == "dom-node".length() && string.endsWith("dom-node")) {
                    throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-read-only", new Object[]{string}));
                }
                if (n2 == "document-xml-version".length() && string.endsWith("document-xml-version")) {
                    throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-read-only", new Object[]{string}));
                }
            }
            this.fConfiguration.setProperty(string, object);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-recognized", new Object[]{string2}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-supported", new Object[]{string2}));
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            if (string.startsWith("http://xml.org/sax/properties/")) {
                int n2 = string.length() - "http://xml.org/sax/properties/".length();
                if (n2 == "lexical-handler".length() && string.endsWith("lexical-handler")) {
                    return this.getLexicalHandler();
                }
                if (n2 == "declaration-handler".length() && string.endsWith("declaration-handler")) {
                    return this.getDeclHandler();
                }
                if (n2 == "dom-node".length() && string.endsWith("dom-node")) {
                    throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "dom-node-read-not-supported", null));
                }
                if (n2 == "document-xml-version".length() && string.endsWith("document-xml-version")) {
                    if (this.startDocumentCalled) {
                        return this.fVersion;
                    }
                    throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "start-document-not-called", new Object[]{string}));
                }
            }
            return this.fConfiguration.getProperty(string);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            String string2 = xMLConfigurationException.getIdentifier();
            if (xMLConfigurationException.getType() == 0) {
                throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-recognized", new Object[]{string2}));
            }
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-supported", new Object[]{string2}));
        }
    }

    protected void setDeclHandler(DeclHandler declHandler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-parsing-supported", new Object[]{DECLARATION_HANDLER}));
        }
        this.fDeclHandler = declHandler;
    }

    protected DeclHandler getDeclHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fDeclHandler;
    }

    protected void setLexicalHandler(LexicalHandler lexicalHandler) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.fParseInProgress) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-parsing-supported", new Object[]{LEXICAL_HANDLER}));
        }
        this.fLexicalHandler = lexicalHandler;
    }

    protected LexicalHandler getLexicalHandler() throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.fLexicalHandler;
    }

    protected final void startNamespaceMapping() throws SAXException {
        int n2 = this.fNamespaceContext.getDeclaredPrefixCount();
        if (n2 > 0) {
            String string = null;
            String string2 = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                string2 = this.fNamespaceContext.getURI(string = this.fNamespaceContext.getDeclaredPrefixAt(i2));
                this.fContentHandler.startPrefixMapping(string, string2 == null ? "" : string2);
            }
        }
    }

    protected final void endNamespaceMapping() throws SAXException {
        int n2 = this.fNamespaceContext.getDeclaredPrefixCount();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.fContentHandler.endPrefixMapping(this.fNamespaceContext.getDeclaredPrefixAt(i2));
            }
        }
    }

    public void reset() throws XNIException {
        super.reset();
        this.fInDTD = false;
        this.fVersion = "1.0";
        this.fNamespaces = this.fConfiguration.getFeature(NAMESPACES);
        this.fNamespacePrefixes = this.fConfiguration.getFeature(NAMESPACE_PREFIXES);
        this.fAugmentations = null;
        this.fDeclaredAttrs = null;
    }

    public ElementPSVI getElementPSVI() {
        return this.fAugmentations != null ? (ElementPSVI)this.fAugmentations.getItem("ELEMENT_PSVI") : null;
    }

    public AttributePSVI getAttributePSVI(int n2) {
        return (AttributePSVI)this.fAttributesProxy.fAttributes.getAugmentations(n2).getItem("ATTRIBUTE_PSVI");
    }

    public AttributePSVI getAttributePSVIByName(String string, String string2) {
        return (AttributePSVI)this.fAttributesProxy.fAttributes.getAugmentations(string, string2).getItem("ATTRIBUTE_PSVI");
    }

    protected static final class AttributesProxy
    implements AttributeList,
    Attributes2 {
        protected XMLAttributes fAttributes;

        protected AttributesProxy() {
        }

        public void setAttributes(XMLAttributes xMLAttributes) {
            this.fAttributes = xMLAttributes;
        }

        public int getLength() {
            return this.fAttributes.getLength();
        }

        public String getName(int n2) {
            return this.fAttributes.getQName(n2);
        }

        public String getQName(int n2) {
            return this.fAttributes.getQName(n2);
        }

        public String getURI(int n2) {
            String string = this.fAttributes.getURI(n2);
            return string != null ? string : "";
        }

        public String getLocalName(int n2) {
            return this.fAttributes.getLocalName(n2);
        }

        public String getType(int n2) {
            return this.fAttributes.getType(n2);
        }

        public String getType(String string) {
            return this.fAttributes.getType(string);
        }

        public String getType(String string, String string2) {
            return string.equals("") ? this.fAttributes.getType(null, string2) : this.fAttributes.getType(string, string2);
        }

        public String getValue(int n2) {
            return this.fAttributes.getValue(n2);
        }

        public String getValue(String string) {
            return this.fAttributes.getValue(string);
        }

        public String getValue(String string, String string2) {
            return string.equals("") ? this.fAttributes.getValue(null, string2) : this.fAttributes.getValue(string, string2);
        }

        public int getIndex(String string) {
            return this.fAttributes.getIndex(string);
        }

        public int getIndex(String string, String string2) {
            return string.equals("") ? this.fAttributes.getIndex(null, string2) : this.fAttributes.getIndex(string, string2);
        }

        public boolean isDeclared(int n2) {
            if (n2 < 0 || n2 >= this.fAttributes.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
            return Boolean.TRUE.equals(this.fAttributes.getAugmentations(n2).getItem("ATTRIBUTE_DECLARED"));
        }

        public boolean isDeclared(String string) {
            int n2 = this.getIndex(string);
            if (n2 == -1) {
                throw new IllegalArgumentException(string);
            }
            return Boolean.TRUE.equals(this.fAttributes.getAugmentations(n2).getItem("ATTRIBUTE_DECLARED"));
        }

        public boolean isDeclared(String string, String string2) {
            int n2 = this.getIndex(string, string2);
            if (n2 == -1) {
                throw new IllegalArgumentException(string2);
            }
            return Boolean.TRUE.equals(this.fAttributes.getAugmentations(n2).getItem("ATTRIBUTE_DECLARED"));
        }

        public boolean isSpecified(int n2) {
            if (n2 < 0 || n2 >= this.fAttributes.getLength()) {
                throw new ArrayIndexOutOfBoundsException(n2);
            }
            return this.fAttributes.isSpecified(n2);
        }

        public boolean isSpecified(String string) {
            int n2 = this.getIndex(string);
            if (n2 == -1) {
                throw new IllegalArgumentException(string);
            }
            return this.fAttributes.isSpecified(n2);
        }

        public boolean isSpecified(String string, String string2) {
            int n2 = this.getIndex(string, string2);
            if (n2 == -1) {
                throw new IllegalArgumentException(string2);
            }
            return this.fAttributes.isSpecified(n2);
        }
    }

    protected class LocatorProxy
    implements Locator2 {
        protected XMLLocator fLocator;

        public LocatorProxy(XMLLocator xMLLocator) {
            this.fLocator = xMLLocator;
        }

        public String getPublicId() {
            return this.fLocator.getPublicId();
        }

        public String getSystemId() {
            return this.fLocator.getExpandedSystemId();
        }

        public int getLineNumber() {
            return this.fLocator.getLineNumber();
        }

        public int getColumnNumber() {
            return this.fLocator.getColumnNumber();
        }

        public String getXMLVersion() {
            return AbstractSAXParser.this.fVersion;
        }

        public String getEncoding() {
            return this.fLocator.getEncoding();
        }
    }
}

