/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class WriterToUTF8Buffered
extends Writer {
    private static final int BYTES_MAX = 16384;
    private static final int CHARS_MAX = 5461;
    private final OutputStream m_os;
    private final byte[] m_outputBytes;
    private final char[] m_inputChars;
    private int count;

    public WriterToUTF8Buffered(OutputStream outputStream) throws UnsupportedEncodingException {
        this.m_os = outputStream;
        this.m_outputBytes = new byte[16387];
        this.m_inputChars = new char[5462];
        this.count = 0;
    }

    public void write(int n2) throws IOException {
        if (this.count >= 16384) {
            this.flushBuffer();
        }
        if (n2 < 128) {
            this.m_outputBytes[this.count++] = (byte)n2;
        } else if (n2 < 2048) {
            this.m_outputBytes[this.count++] = (byte)(192 + (n2 >> 6));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 & 0x3F));
        } else {
            this.m_outputBytes[this.count++] = (byte)(224 + (n2 >> 12));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 >> 6 & 0x3F));
            this.m_outputBytes[this.count++] = (byte)(128 + (n2 & 0x3F));
        }
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        char c2;
        int n4;
        int n5 = 3 * n3;
        if (n5 >= 16384 - this.count) {
            this.flushBuffer();
            if (n5 >= 16384) {
                int n6 = 1 + n3 / 5461;
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n7 = n2 + n3 * i2 / n6;
                    int n8 = n2 + n3 * (i2 + 1) / n6;
                    int n9 = n8 - n7;
                    this.write(cArray, n7, n9);
                }
                return;
            }
        }
        int n10 = n3 + n2;
        byte[] byArray = this.m_outputBytes;
        int n11 = this.count;
        for (n4 = n2; n4 < n10 && (c2 = cArray[n4]) < '\u0080'; ++n4) {
            byArray[n11++] = (byte)c2;
        }
        while (n4 < n10) {
            c2 = cArray[n4];
            if (c2 < '\u0080') {
                byArray[n11++] = (byte)c2;
            } else if (c2 < '\u0800') {
                byArray[n11++] = (byte)(192 + (c2 >> 6));
                byArray[n11++] = (byte)(128 + (c2 & 0x3F));
            } else {
                byArray[n11++] = (byte)(224 + (c2 >> 12));
                byArray[n11++] = (byte)(128 + (c2 >> 6 & 0x3F));
                byArray[n11++] = (byte)(128 + (c2 & 0x3F));
            }
            ++n4;
        }
        this.count = n11;
    }

    private void directWrite(char[] cArray, int n2, int n3) throws IOException {
        if (n3 >= 16384 - this.count) {
            this.flushBuffer();
            if (n3 >= 16384) {
                int n4 = 1 + n3 / 5461;
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n5 = n2 + n3 * i2 / n4;
                    int n6 = n2 + n3 * (i2 + 1) / n4;
                    int n7 = n6 - n5;
                    this.directWrite(cArray, n5, n7);
                }
                return;
            }
        }
        int n8 = n3 + n2;
        byte[] byArray = this.m_outputBytes;
        int n9 = this.count;
        for (int i3 = n2; i3 < n8; ++i3) {
            byArray[n9++] = byArray[i3];
        }
        this.count = n9;
    }

    public void write(String string) throws IOException {
        char c2;
        int n2;
        int n3 = string.length();
        int n4 = 3 * n3;
        if (n4 >= 16384 - this.count) {
            this.flushBuffer();
            if (n4 >= 16384) {
                int n5 = 1 + n3 / 5461;
                for (int i2 = 0; i2 < n5; ++i2) {
                    int n6 = 0 + n3 * i2 / n5;
                    int n7 = 0 + n3 * (i2 + 1) / n5;
                    int n8 = n7 - n6;
                    string.getChars(n6, n7, this.m_inputChars, 0);
                    this.write(this.m_inputChars, 0, n8);
                }
                return;
            }
        }
        string.getChars(0, n3, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        int n9 = n3;
        byte[] byArray = this.m_outputBytes;
        int n10 = this.count;
        for (n2 = 0; n2 < n9 && (c2 = cArray[n2]) < '\u0080'; ++n2) {
            byArray[n10++] = (byte)c2;
        }
        while (n2 < n9) {
            c2 = cArray[n2];
            if (c2 < '\u0080') {
                byArray[n10++] = (byte)c2;
            } else if (c2 < '\u0800') {
                byArray[n10++] = (byte)(192 + (c2 >> 6));
                byArray[n10++] = (byte)(128 + (c2 & 0x3F));
            } else {
                byArray[n10++] = (byte)(224 + (c2 >> 12));
                byArray[n10++] = (byte)(128 + (c2 >> 6 & 0x3F));
                byArray[n10++] = (byte)(128 + (c2 & 0x3F));
            }
            ++n2;
        }
        this.count = n10;
    }

    public void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.m_os.write(this.m_outputBytes, 0, this.count);
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }

    public void directWrite(String string) throws IOException {
        int n2 = string.length();
        if (n2 >= 16384 - this.count) {
            this.flushBuffer();
            if (n2 >= 16384) {
                int n3 = 1 + n2 / 5461;
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = 0 + n2 * i2 / n3;
                    int n5 = 0 + n2 * (i2 + 1) / n3;
                    int n6 = n5 - n4;
                    string.getChars(n4, n5, this.m_inputChars, 0);
                    this.directWrite(this.m_inputChars, 0, n6);
                }
                return;
            }
        }
        string.getChars(0, n2, this.m_inputChars, 0);
        char[] cArray = this.m_inputChars;
        byte[] byArray = this.m_outputBytes;
        int n7 = this.count;
        int n8 = 0;
        while (n8 < n2) {
            byArray[n7++] = (byte)cArray[n8++];
        }
        this.count = n7;
    }
}

