/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.jaxp;

import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xpath.internal.XPath;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.jaxp.JAXPExtensionsProvider;
import com.sun.org.apache.xpath.internal.jaxp.JAXPPrefixResolver;
import com.sun.org.apache.xpath.internal.jaxp.JAXPVariableStack;
import com.sun.org.apache.xpath.internal.objects.XObject;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class XPathExpressionImpl
implements XPathExpression {
    XPathFunctionResolver functionResolver;
    XPathVariableResolver variableResolver;
    JAXPPrefixResolver prefixResolver;
    XPath xpath;
    static DocumentBuilderFactory dbf = null;
    static DocumentBuilder db = null;
    static Document d = null;

    protected XPathExpressionImpl() {
    }

    protected XPathExpressionImpl(XPath xPath, JAXPPrefixResolver jAXPPrefixResolver, XPathFunctionResolver xPathFunctionResolver, XPathVariableResolver xPathVariableResolver) {
        this.xpath = xPath;
        this.prefixResolver = jAXPPrefixResolver;
        this.functionResolver = xPathFunctionResolver;
        this.variableResolver = xPathVariableResolver;
    }

    public void setXPath(XPath xPath) {
        this.xpath = xPath;
    }

    public Object eval(Object object, QName qName) throws XPathExpressionException {
        try {
            XObject xObject = this.eval(object);
            return this.getResultAsType(xObject, qName);
        }
        catch (TransformerException transformerException) {
            throw new XPathExpressionException(transformerException);
        }
    }

    private XObject eval(Object object) throws XPathExpressionException {
        Object object2;
        XPathContext xPathContext = null;
        if (this.functionResolver != null) {
            object2 = new JAXPExtensionsProvider(this.functionResolver);
            xPathContext = new XPathContext(object2);
        } else {
            xPathContext = new XPathContext();
        }
        xPathContext.setVarStack(new JAXPVariableStack(this.variableResolver));
        object2 = null;
        try {
            Node node = (Node)object;
            if (node == null) {
                node = XPathExpressionImpl.getDummyDocument();
            }
            object2 = this.xpath.execute(xPathContext, node, (PrefixResolver)this.prefixResolver);
            return object2;
        }
        catch (TransformerException transformerException) {
            throw new XPathExpressionException(transformerException);
        }
    }

    public Object evaluate(Object object, QName qName) throws XPathExpressionException {
        if (qName == null) {
            throw new NullPointerException("returnType can't be null");
        }
        if (!this.isSupported(qName)) {
            throw new IllegalArgumentException("Unsupported returnType : " + qName);
        }
        return this.eval(object, qName);
    }

    public String evaluate(Object object) throws XPathExpressionException {
        return (String)this.evaluate(object, XPathConstants.STRING);
    }

    public Object evaluate(InputSource inputSource, QName qName) throws XPathExpressionException {
        if (inputSource == null || qName == null) {
            throw new NullPointerException("source and/or returnType can't be null");
        }
        if (!this.isSupported(qName)) {
            throw new IllegalArgumentException("Unsupported returnType : " + qName);
        }
        try {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
            }
            db = dbf.newDocumentBuilder();
            Document document = db.parse(inputSource);
            return this.eval(document, qName);
        }
        catch (Exception exception) {
            throw new XPathExpressionException(exception);
        }
    }

    public String evaluate(InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(inputSource, XPathConstants.STRING);
    }

    private boolean isSupported(QName qName) {
        return qName.equals(XPathConstants.STRING) || qName.equals(XPathConstants.NUMBER) || qName.equals(XPathConstants.BOOLEAN) || qName.equals(XPathConstants.NODE) || qName.equals(XPathConstants.NODESET);
    }

    private Object getResultAsType(XObject xObject, QName qName) throws TransformerException {
        if (qName.equals(XPathConstants.STRING)) {
            return xObject.str();
        }
        if (qName.equals(XPathConstants.NUMBER)) {
            return new Double(xObject.num());
        }
        if (qName.equals(XPathConstants.BOOLEAN)) {
            return new Boolean(xObject.bool());
        }
        if (qName.equals(XPathConstants.NODESET)) {
            return xObject.nodelist();
        }
        if (qName.equals(XPathConstants.NODE)) {
            NodeIterator nodeIterator = xObject.nodeset();
            return nodeIterator.nextNode();
        }
        throw new IllegalArgumentException("Unsupported returnType : " + qName);
    }

    private static Document getDummyDocument() {
        try {
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setValidating(false);
            }
            db = dbf.newDocumentBuilder();
            DOMImplementation dOMImplementation = db.getDOMImplementation();
            d = dOMImplementation.createDocument("http://java.sun.com/jaxp/xpath", "dummyroot", null);
            return d;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

