/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import java.beans.PropertyChangeSupport;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.BaseRowSet;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.Joinable;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.RowSetWarning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcRowSetImpl
extends BaseRowSet
implements JdbcRowSet,
Joinable {
    private Connection conn;
    private PreparedStatement ps;
    private ResultSet rs;
    private RowSetMetaDataImpl rowsMD;
    private ResultSetMetaData resMD;
    private PropertyChangeSupport propertyChangeSupport;
    private Vector iMatchColumns;
    private Vector strMatchColumns;

    public JdbcRowSetImpl() {
        int n2;
        this.conn = null;
        this.ps = null;
        this.rs = null;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        try {
            this.setShowDeleted(false);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setShowDeleted) :" + sQLException.getMessage());
        }
        try {
            this.setQueryTimeout(0);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setQueryTimeout) :" + sQLException.getMessage());
        }
        try {
            this.setMaxRows(0);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxRows) :" + sQLException.getMessage());
        }
        try {
            this.setMaxFieldSize(0);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxFieldSize) :" + sQLException.getMessage());
        }
        try {
            this.setEscapeProcessing(true);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setEscapeProcessing) :" + sQLException.getMessage());
        }
        try {
            this.setConcurrency(1008);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setConcurrency) :" + sQLException.getMessage());
        }
        this.setTypeMap(null);
        try {
            this.setType(1004);
        }
        catch (SQLException sQLException) {
            sQLException.getMessage();
        }
        this.setReadOnly(true);
        try {
            this.setTransactionIsolation(2);
        }
        catch (SQLException sQLException) {
            sQLException.getMessage();
        }
        this.iMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.iMatchColumns.add(n2, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.strMatchColumns.add(n2, null);
        }
    }

    public JdbcRowSetImpl(Connection connection) throws SQLException {
        int n2;
        this.conn = connection;
        this.ps = null;
        this.rs = null;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setParams();
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.iMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.iMatchColumns.add(n2, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.strMatchColumns.add(n2, null);
        }
    }

    public JdbcRowSetImpl(String string, String string2, String string3) throws SQLException {
        int n2;
        this.conn = null;
        this.ps = null;
        this.rs = null;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        this.setUsername(string2);
        this.setPassword(string3);
        this.setUrl(string);
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setParams();
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.connect();
        this.iMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.iMatchColumns.add(n2, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.strMatchColumns.add(n2, null);
        }
    }

    public JdbcRowSetImpl(ResultSet resultSet) throws SQLException {
        int n2;
        this.conn = null;
        this.ps = null;
        this.rs = resultSet;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.initParams();
        this.setShowDeleted(false);
        this.setQueryTimeout(0);
        this.setMaxRows(0);
        this.setMaxFieldSize(0);
        this.setParams();
        this.setReadOnly(true);
        this.setTransactionIsolation(2);
        this.setEscapeProcessing(true);
        this.setTypeMap(null);
        this.resMD = this.rs.getMetaData();
        this.rowsMD = new RowSetMetaDataImpl();
        this.initMetaData(this.rowsMD, this.resMD);
        this.iMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.iMatchColumns.add(n2, new Integer(-1));
        }
        this.strMatchColumns = new Vector(10);
        for (n2 = 0; n2 < 10; ++n2) {
            this.strMatchColumns.add(n2, null);
        }
    }

    protected void initMetaData(RowSetMetaData rowSetMetaData, ResultSetMetaData resultSetMetaData) throws SQLException {
        int n2 = resultSetMetaData.getColumnCount();
        rowSetMetaData.setColumnCount(n2);
        for (int i2 = 1; i2 <= n2; ++i2) {
            rowSetMetaData.setAutoIncrement(i2, resultSetMetaData.isAutoIncrement(i2));
            rowSetMetaData.setCaseSensitive(i2, resultSetMetaData.isCaseSensitive(i2));
            rowSetMetaData.setCurrency(i2, resultSetMetaData.isCurrency(i2));
            rowSetMetaData.setNullable(i2, resultSetMetaData.isNullable(i2));
            rowSetMetaData.setSigned(i2, resultSetMetaData.isSigned(i2));
            rowSetMetaData.setSearchable(i2, resultSetMetaData.isSearchable(i2));
            rowSetMetaData.setColumnDisplaySize(i2, resultSetMetaData.getColumnDisplaySize(i2));
            rowSetMetaData.setColumnLabel(i2, resultSetMetaData.getColumnLabel(i2));
            rowSetMetaData.setColumnName(i2, resultSetMetaData.getColumnName(i2));
            rowSetMetaData.setSchemaName(i2, resultSetMetaData.getSchemaName(i2));
            rowSetMetaData.setPrecision(i2, resultSetMetaData.getPrecision(i2));
            rowSetMetaData.setScale(i2, resultSetMetaData.getScale(i2));
            rowSetMetaData.setTableName(i2, resultSetMetaData.getTableName(i2));
            rowSetMetaData.setCatalogName(i2, resultSetMetaData.getCatalogName(i2));
            rowSetMetaData.setColumnType(i2, resultSetMetaData.getColumnType(i2));
            rowSetMetaData.setColumnTypeName(i2, resultSetMetaData.getColumnTypeName(i2));
        }
    }

    protected void checkState() throws SQLException {
        if (this.conn == null && this.ps == null && this.rs == null) {
            throw new SQLException("Invalid State");
        }
    }

    @Override
    public void execute() throws SQLException {
        this.prepare();
        this.setProperties(this.ps);
        this.decodeParams(this.getParams(), this.ps);
        this.rs = this.ps.executeQuery();
        this.notifyRowSetChanged();
    }

    protected void setProperties(PreparedStatement preparedStatement) throws SQLException {
        try {
            preparedStatement.setEscapeProcessing(this.getEscapeProcessing());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setEscapeProcessing): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setMaxFieldSize(this.getMaxFieldSize());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxFieldSize): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setMaxRows(this.getMaxRows());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setMaxRows): " + sQLException.getMessage());
        }
        try {
            preparedStatement.setQueryTimeout(this.getQueryTimeout());
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setQueryTimeout): " + sQLException.getMessage());
        }
    }

    protected Connection connect() throws SQLException {
        if (this.conn != null) {
            return this.conn;
        }
        if (this.getDataSourceName() != null) {
            try {
                InitialContext initialContext = new InitialContext();
                DataSource dataSource = (DataSource)initialContext.lookup(this.getDataSourceName());
                if (this.getUsername() != null) {
                    return dataSource.getConnection(this.getUsername(), this.getPassword());
                }
                return dataSource.getConnection();
            }
            catch (NamingException namingException) {
                throw new SQLException("JdcbRowSet (connect): (JNDI) Unable to connect");
            }
        }
        if (this.getUrl() != null) {
            return DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        return null;
    }

    protected PreparedStatement prepare() throws SQLException {
        this.conn = this.connect();
        try {
            if (this.conn == null) {
                // empty if block
            }
            this.conn.setTransactionIsolation(this.getTransactionIsolation());
            this.conn.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (setTransactionIsolation): " + sQLException.getMessage());
        }
        try {
            this.conn.setTypeMap(this.getTypeMap());
        }
        catch (Throwable throwable) {
            System.err.println("JdbcRowSet (setTypeMap): " + throwable.getMessage());
        }
        try {
            this.ps = this.conn.prepareStatement(this.getCommand(), 1004, 1008);
        }
        catch (SQLException sQLException) {
            System.err.println("JdbcRowSet (execute): " + sQLException.getMessage());
            if (this.ps != null) {
                this.ps.close();
            }
            if (this.conn != null) {
                this.conn.close();
            }
            throw new SQLException(sQLException.getMessage());
        }
        return this.ps;
    }

    private void decodeParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        Object[] objectArray2 = null;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof Object[]) {
                objectArray2 = (Object[])objectArray[i2];
                if (objectArray2.length == 2) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(i2 + 1, (Integer)objectArray2[1]);
                        continue;
                    }
                    if (objectArray2[0] instanceof Date || objectArray2[0] instanceof Time || objectArray2[0] instanceof Timestamp) {
                        System.err.println("Detected a Date");
                        if (objectArray2[1] instanceof Calendar) {
                            System.err.println("Detected a Calendar");
                            preparedStatement.setDate(i2 + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                            continue;
                        }
                        throw new SQLException("Unable to deduce param type");
                    }
                    if (objectArray2[0] instanceof Reader) {
                        preparedStatement.setCharacterStream(i2 + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                        continue;
                    }
                    if (!(objectArray2[1] instanceof Integer)) continue;
                    preparedStatement.setObject(i2 + 1, objectArray2[0], (Integer)objectArray2[1]);
                    continue;
                }
                if (objectArray2.length == 3) {
                    if (objectArray2[0] == null) {
                        preparedStatement.setNull(i2 + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                        continue;
                    }
                    if (objectArray2[0] instanceof InputStream) {
                        switch ((Integer)objectArray2[2]) {
                            case 0: {
                                preparedStatement.setUnicodeStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                            case 1: {
                                preparedStatement.setBinaryStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                            case 2: {
                                preparedStatement.setAsciiStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                            }
                        }
                        throw new SQLException("Unable to deduce parameter type");
                    }
                    if (objectArray2[1] instanceof Integer && objectArray2[2] instanceof Integer) {
                        preparedStatement.setObject(i2 + 1, objectArray2[0], (Integer)objectArray2[1], (Integer)objectArray2[2]);
                        continue;
                    }
                    throw new SQLException("Unable to deduce param type");
                }
                preparedStatement.setObject(i2 + 1, objectArray[i2]);
                continue;
            }
            preparedStatement.setObject(i2 + 1, objectArray[i2]);
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkState();
        boolean bl2 = this.rs.next();
        this.notifyCursorMoved();
        return bl2;
    }

    @Override
    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkState();
        return this.rs.wasNull();
    }

    @Override
    public String getString(int n2) throws SQLException {
        this.checkState();
        return this.rs.getString(n2);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBoolean(n2);
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        this.checkState();
        return this.rs.getByte(n2);
    }

    @Override
    public short getShort(int n2) throws SQLException {
        this.checkState();
        return this.rs.getShort(n2);
    }

    @Override
    public int getInt(int n2) throws SQLException {
        this.checkState();
        return this.rs.getInt(n2);
    }

    @Override
    public long getLong(int n2) throws SQLException {
        this.checkState();
        return this.rs.getLong(n2);
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        this.checkState();
        return this.rs.getFloat(n2);
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        this.checkState();
        return this.rs.getDouble(n2);
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(n2, n3);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBytes(n2);
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        this.checkState();
        return this.rs.getDate(n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        this.checkState();
        return this.rs.getTime(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(n2);
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        this.checkState();
        return this.rs.getAsciiStream(n2);
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        this.checkState();
        return this.rs.getUnicodeStream(n2);
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBinaryStream(n2);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        return this.rs.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkState();
        this.rs.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkState();
        return this.rs.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        try {
            this.checkState();
        }
        catch (SQLException sQLException) {
            this.prepare();
            return this.ps.getMetaData();
        }
        return this.rs.getMetaData();
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        this.checkState();
        return this.rs.getObject(n2);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.checkState();
        return this.rs.findColumn(string);
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkState();
        return this.rs.getCharacterStream(n2);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBigDecimal(n2);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkState();
        return this.rs.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkState();
        return this.rs.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkState();
        return this.rs.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkState();
        return this.rs.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkState();
        this.rs.beforeFirst();
        this.notifyCursorMoved();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkState();
        this.rs.afterLast();
        this.notifyCursorMoved();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkState();
        boolean bl2 = this.rs.first();
        this.notifyCursorMoved();
        return bl2;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkState();
        boolean bl2 = this.rs.last();
        this.notifyCursorMoved();
        return bl2;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkState();
        return this.rs.getRow();
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        this.checkState();
        boolean bl2 = this.rs.absolute(n2);
        this.notifyCursorMoved();
        return bl2;
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        this.checkState();
        boolean bl2 = this.rs.relative(n2);
        this.notifyCursorMoved();
        return bl2;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkState();
        boolean bl2 = this.rs.previous();
        this.notifyCursorMoved();
        return bl2;
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        this.checkState();
        this.rs.setFetchDirection(n2);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sQLException) {
            super.getFetchDirection();
        }
        return this.rs.getFetchDirection();
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        this.checkState();
        this.rs.setFetchSize(n2);
    }

    @Override
    public int getType() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sQLException) {
            return super.getType();
        }
        return this.rs.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            this.checkState();
        }
        catch (SQLException sQLException) {
            super.getConcurrency();
        }
        return this.rs.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkState();
        return this.rs.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkState();
        return this.rs.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkState();
        return this.rs.rowDeleted();
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateNull(n2);
    }

    @Override
    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBoolean(n2, bl2);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateByte(n2, by);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateShort(n2, s2);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateInt(n2, n3);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateLong(n2, l2);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateFloat(n2, f2);
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateDouble(n2, d2);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBigDecimal(n2, bigDecimal);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateString(n2, string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBytes(n2, byArray);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateDate(n2, date);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateTime(n2, time);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateTimestamp(n2, timestamp);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateAsciiStream(n2, inputStream, n3);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateBinaryStream(n2, inputStream, n3);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateCharacterStream(n2, reader, n3);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateObject(n2, object, n3);
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.checkState();
        this.checkTypeConcurrency();
        this.rs.updateObject(n2, object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl2);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.findColumn(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.findColumn(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.findColumn(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.findColumn(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.findColumn(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.findColumn(string), object, n2);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkState();
        this.rs.insertRow();
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkState();
        this.rs.updateRow();
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkState();
        this.rs.deleteRow();
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkState();
        this.rs.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkState();
        this.rs.cancelRowUpdates();
        this.notifyRowChanged();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkState();
        this.rs.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkState();
        this.rs.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.rs != null) {
            return this.rs.getStatement();
        }
        return null;
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        this.checkState();
        return this.rs.getObject(n2, map);
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        this.checkState();
        return this.rs.getRef(n2);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        this.checkState();
        return this.rs.getBlob(n2);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        this.checkState();
        return this.rs.getClob(n2);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        this.checkState();
        return this.rs.getArray(n2);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getDate(n2, calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTime(n2, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkState();
        return this.rs.getTimestamp(n2, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        this.checkState();
        this.rs.updateRef(n2, ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.checkState();
        this.rs.updateClob(n2, clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.checkState();
        this.rs.updateBlob(n2, blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        this.checkState();
        this.rs.updateArray(n2, array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        this.checkState();
        return this.rs.getURL(n2);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    @Override
    public void unsetMatchColumn(int[] nArray) throws SQLException {
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n3 = Integer.parseInt(this.iMatchColumns.get(n2).toString());
            if (nArray[n2] == n3) continue;
            throw new SQLException("Match Columns are not the same as those set");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.iMatchColumns.set(n2, new Integer(-1));
        }
    }

    @Override
    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].equals(this.strMatchColumns.get(n2))) continue;
            throw new SQLException("Match Columns are not the same that were set");
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.strMatchColumns.set(n2, null);
        }
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        Object[] objectArray = new String[this.strMatchColumns.size()];
        if (this.strMatchColumns.get(0) == null) {
            throw new SQLException("Set match Columns before getting them");
        }
        this.strMatchColumns.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        Object[] objectArray = new Integer[this.iMatchColumns.size()];
        int[] nArray = new int[this.iMatchColumns.size()];
        int n2 = (Integer)this.iMatchColumns.get(0);
        if (n2 == -1) {
            throw new SQLException("Set the match columns before getting them");
        }
        this.iMatchColumns.copyInto(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            nArray[i2] = (Integer)objectArray[i2];
        }
        return nArray;
    }

    @Override
    public void setMatchColumn(int[] nArray) throws SQLException {
        int n2;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0) continue;
            throw new SQLException("Match Column should be greater than 0");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.iMatchColumns.add(n2, new Integer(nArray[n2]));
        }
    }

    @Override
    public void setMatchColumn(String[] stringArray) throws SQLException {
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] != null && !stringArray[n2].equals("")) continue;
            throw new SQLException("Match Column cannot be null or empty string");
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.strMatchColumns.add(n2, stringArray[n2]);
        }
    }

    @Override
    public void setMatchColumn(int n2) throws SQLException {
        if (n2 < 0) {
            throw new SQLException("Column ID has to be >0");
        }
        this.iMatchColumns.set(0, new Integer(n2));
    }

    @Override
    public void setMatchColumn(String string) throws SQLException {
        if ((string = string.trim()) == "" || string.equals(null)) {
            throw new SQLException("Column ID has to be a non null value");
        }
        this.strMatchColumns.set(0, string);
    }

    @Override
    public void unsetMatchColumn(int n2) throws SQLException {
        if (!this.iMatchColumns.get(0).equals(new Integer(n2))) {
            throw new SQLException("Column being unset is not same as set");
        }
        if (this.strMatchColumns.get(0) != null) {
            throw new SQLException("Use column name as argument to unsetMatchColumn");
        }
        this.iMatchColumns.set(0, new Integer(-1));
    }

    @Override
    public void unsetMatchColumn(String string) throws SQLException {
        string = string.trim();
        if (!this.strMatchColumns.get(0).equals(string)) {
            throw new SQLException("Column being unset is not same as set");
        }
        if ((Integer)this.iMatchColumns.get(0) > 0) {
            throw new SQLException("Use column id as argument to unsetMatchColumn");
        }
        this.strMatchColumns.set(0, null);
    }

    public DatabaseMetaData getDatabaseMetaData() throws SQLException {
        Connection connection = this.connect();
        return connection.getMetaData();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.prepare();
        return this.ps.getParameterMetaData();
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
        if (this.conn.getHoldability() != 1) {
            ResultSet resultSet = this.rs;
            this.rs = null;
        }
    }

    @Override
    public void setAutoCommit(boolean bl2) throws SQLException {
        this.conn.setAutoCommit(bl2);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
        ResultSet resultSet = this.rs;
        this.rs = null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    protected void setParams() throws SQLException {
        if (this.rs == null) {
            this.setType(1004);
            this.setConcurrency(1008);
        } else {
            this.setType(this.rs.getType());
            this.setConcurrency(this.rs.getConcurrency());
        }
    }

    private void checkTypeConcurrency() throws SQLException {
        if (this.rs.getType() == 1003 || this.rs.getConcurrency() == 1007) {
            throw new SQLException("Result Set is not updatable");
        }
    }

    protected Connection getConnection() {
        return this.conn;
    }

    protected void setConnection(Connection connection) {
        this.conn = connection;
    }

    protected PreparedStatement getPreparedStatement() {
        return this.ps;
    }

    protected void setPreparedStatement(PreparedStatement preparedStatement) {
        this.ps = preparedStatement;
    }

    protected ResultSet getResultSet() throws SQLException {
        this.checkState();
        return this.rs;
    }

    protected void setResultSet(ResultSet resultSet) {
        this.rs = resultSet;
    }

    @Override
    public void setCommand(String string) throws SQLException {
        if (this.getCommand() != null) {
            if (!this.getCommand().equals(string)) {
                String string2 = this.getCommand();
                super.setCommand(string);
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("command", string2, string);
            }
        } else {
            super.setCommand(string);
            this.propertyChangeSupport.firePropertyChange("command", null, string);
        }
    }

    @Override
    public void setDataSourceName(String string) throws SQLException {
        if (this.getDataSourceName() != null) {
            if (!this.getDataSourceName().equals(string)) {
                String string2 = this.getDataSourceName();
                super.setDataSourceName(string);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("dataSourceName", string2, string);
            }
        } else {
            super.setDataSourceName(string);
            this.propertyChangeSupport.firePropertyChange("dataSourceName", null, string);
        }
    }

    @Override
    public void setUrl(String string) throws SQLException {
        if (this.getUrl() != null) {
            if (!this.getUrl().equals(string)) {
                String string2 = this.getUrl();
                super.setUrl(string);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("url", string2, string);
            }
        } else {
            super.setUrl(string);
            this.propertyChangeSupport.firePropertyChange("url", null, string);
        }
    }

    @Override
    public void setUsername(String string) {
        if (this.getUsername() != null) {
            if (!this.getUsername().equals(string)) {
                String string2 = this.getUsername();
                super.setUsername(string);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("username", string2, string);
            }
        } else {
            super.setUsername(string);
            this.propertyChangeSupport.firePropertyChange("username", null, string);
        }
    }

    @Override
    public void setPassword(String string) {
        if (this.getPassword() != null) {
            if (!this.getPassword().equals(string)) {
                String string2 = this.getPassword();
                super.setPassword(string);
                this.conn = null;
                this.ps = null;
                this.rs = null;
                this.propertyChangeSupport.firePropertyChange("password", string2, string);
            }
        } else {
            super.setPassword(string);
            this.propertyChangeSupport.firePropertyChange("password", null, string);
        }
    }

    @Override
    public void setType(int n2) throws SQLException {
        int n3;
        try {
            n3 = this.getType();
        }
        catch (NullPointerException nullPointerException) {
            n3 = 0;
        }
        if (n3 != n2) {
            super.setType(n2);
            this.propertyChangeSupport.firePropertyChange("type", n3, n2);
        }
    }

    @Override
    public void setConcurrency(int n2) throws SQLException {
        int n3;
        try {
            n3 = this.getConcurrency();
        }
        catch (NullPointerException nullPointerException) {
            n3 = 0;
        }
        if (n3 != n2) {
            super.setConcurrency(n2);
            this.propertyChangeSupport.firePropertyChange("concurrency", n3, n2);
        }
    }

    @Override
    public void setTransactionIsolation(int n2) throws SQLException {
        int n3;
        try {
            n3 = this.getTransactionIsolation();
        }
        catch (NullPointerException nullPointerException) {
            n3 = 0;
        }
        if (n3 != n2) {
            super.setTransactionIsolation(n2);
            this.propertyChangeSupport.firePropertyChange("transactionIsolation", n3, n2);
        }
    }

    @Override
    public void setMaxRows(int n2) throws SQLException {
        int n3;
        try {
            n3 = this.getMaxRows();
        }
        catch (NullPointerException nullPointerException) {
            n3 = 0;
        }
        if (n3 != n2) {
            super.setMaxRows(n2);
            this.propertyChangeSupport.firePropertyChange("maxRows", n3, n2);
        }
    }
}

