/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BufferCapabilities;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsCallback;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferStrategy;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import sun.awt.AppContext;
import sun.awt.ConstrainableGraphics;
import sun.awt.DebugHelper;
import sun.awt.WindowClosingListener;
import sun.awt.dnd.SunDropTargetEvent;
import sun.awt.im.CompositionArea;
import sun.font.FontManager;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    private static final Logger focusLog;
    private static final Logger log;
    transient ComponentPeer peer;
    transient Container parent;
    transient AppContext appContext;
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale;
    transient GraphicsConfiguration graphicsConfig = null;
    transient BufferStrategy bufferStrategy = null;
    boolean ignoreRepaint = false;
    boolean visible = true;
    boolean enabled = true;
    boolean valid = false;
    DropTarget dropTarget;
    Vector popups;
    private String name;
    private boolean nameExplicitlySet = false;
    private boolean focusable = true;
    private static final int FOCUS_TRAVERSABLE_UNKNOWN = 0;
    private static final int FOCUS_TRAVERSABLE_DEFAULT = 1;
    private static final int FOCUS_TRAVERSABLE_SET = 2;
    private int isFocusTraversableOverridden = 0;
    Set[] focusTraversalKeys;
    private static final String[] focusTraversalKeyPropertyNames;
    private boolean focusTraversalKeysEnabled = true;
    static final Object LOCK;
    Dimension minSize;
    boolean minSizeSet;
    Dimension prefSize;
    boolean prefSizeSet;
    Dimension maxSize;
    boolean maxSizeSet;
    transient ComponentOrientation componentOrientation = ComponentOrientation.UNKNOWN;
    boolean newEventsOnly = false;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient MouseWheelListener mouseWheelListener;
    transient InputMethodListener inputMethodListener;
    transient RuntimeException windowClosingException = null;
    static final String actionListenerK = "actionL";
    static final String adjustmentListenerK = "adjustmentL";
    static final String componentListenerK = "componentL";
    static final String containerListenerK = "containerL";
    static final String focusListenerK = "focusL";
    static final String itemListenerK = "itemL";
    static final String keyListenerK = "keyL";
    static final String mouseListenerK = "mouseL";
    static final String mouseMotionListenerK = "mouseMotionL";
    static final String mouseWheelListenerK = "mouseWheelL";
    static final String textListenerK = "textL";
    static final String ownedWindowK = "ownedL";
    static final String windowListenerK = "windowL";
    static final String inputMethodListenerK = "inputMethodL";
    static final String hierarchyListenerK = "hierarchyL";
    static final String hierarchyBoundsListenerK = "hierarchyBoundsL";
    static final String windowStateListenerK = "windowStateL";
    static final String windowFocusListenerK = "windowFocusL";
    long eventMask = 4096L;
    private static final DebugHelper dbg;
    static boolean isInc;
    static int incRate;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    private static final long serialVersionUID = -7644114512714619750L;
    private PropertyChangeSupport changeSupport;
    boolean isPacked = false;
    private transient Object privateKey = new Object();
    private int boundsOp = 3;
    static Hashtable metrics;
    private int componentSerializedDataVersion = 4;
    transient NativeInLightFixer nativeInLightFixer;
    AccessibleContext accessibleContext = null;

    int getBoundsOp() {
        assert (Thread.holdsLock(this.getTreeLock()));
        return this.boundsOp;
    }

    void setBoundsOp(int n2) {
        assert (Thread.holdsLock(this.getTreeLock()));
        if (n2 == 5) {
            this.boundsOp = 3;
        } else if (this.boundsOp == 3) {
            this.boundsOp = n2;
        }
    }

    protected Component() {
        this.appContext = AppContext.getAppContext();
    }

    void initializeFocusTraversalKeys() {
        this.focusTraversalKeys = new Set[3];
    }

    String constructComponentName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            Component component = this;
            synchronized (component) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = this.constructComponentName();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        String string2;
        Component component = this;
        synchronized (component) {
            string2 = this.name;
            this.name = string;
            this.nameExplicitlySet = true;
        }
        this.firePropertyChange("name", string2, string);
    }

    public Container getParent() {
        return this.getParent_NoClientCode();
    }

    final Container getParent_NoClientCode() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public synchronized void setDropTarget(DropTarget dropTarget) {
        block12: {
            if (dropTarget == this.dropTarget || this.dropTarget != null && this.dropTarget.equals(dropTarget)) {
                return;
            }
            DropTarget dropTarget2 = this.dropTarget;
            if (dropTarget2 != null) {
                if (this.peer != null) {
                    this.dropTarget.removeNotify(this.peer);
                }
                DropTarget dropTarget3 = this.dropTarget;
                this.dropTarget = null;
                try {
                    dropTarget3.setComponent(null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((this.dropTarget = dropTarget) != null) {
                try {
                    this.dropTarget.setComponent(this);
                    if (this.peer != null) {
                        this.dropTarget.addNotify(this.peer);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (dropTarget2 == null) break block12;
                    try {
                        dropTarget2.setComponent(this);
                        if (this.peer != null) {
                            this.dropTarget.addNotify(this.peer);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public synchronized DropTarget getDropTarget() {
        return this.dropTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsConfiguration getGraphicsConfiguration() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.graphicsConfig != null) {
                return this.graphicsConfig;
            }
            if (this.getParent() != null) {
                return this.getParent().getGraphicsConfiguration();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetGC() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.graphicsConfig = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGCFromPeer() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.graphicsConfig = this.peer != null ? this.peer.getGraphicsConfiguration() : null;
        }
    }

    void checkGD(String string) {
        if (this.graphicsConfig != null && !this.graphicsConfig.getDevice().getIDstring().equals(string)) {
            throw new IllegalArgumentException("adding a container to a container on a different GraphicsDevice");
        }
    }

    public final Object getTreeLock() {
        return LOCK;
    }

    public Toolkit getToolkit() {
        return this.getToolkitImpl();
    }

    final Toolkit getToolkitImpl() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getToolkit();
        }
        Container container = this.parent;
        if (container != null) {
            return container.getToolkitImpl();
        }
        return Toolkit.getDefaultToolkit();
    }

    public boolean isValid() {
        return this.peer != null && this.valid;
    }

    public boolean isDisplayable() {
        return this.getPeer() != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    boolean isRecursivelyVisible() {
        return this.visible && (this.parent == null || this.parent.isRecursivelyVisible());
    }

    Point pointRelativeToComponent(Point point) {
        Point point2 = this.getLocationOnScreen();
        return new Point(point.x - point2.x, point.y - point2.y);
    }

    Component findUnderMouseInWindow(PointerInfo pointerInfo) {
        if (!this.isShowing()) {
            return null;
        }
        Window window = this.getContainingWindow();
        if (!Toolkit.getDefaultToolkit().getMouseInfoPeer().isWindowUnderMouse(window)) {
            return null;
        }
        Point point = window.pointRelativeToComponent(pointerInfo.getLocation());
        Component component = window.findComponentAt(point.x, point.y, true);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getMousePosition() throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        PointerInfo pointerInfo = (PointerInfo)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return MouseInfo.getPointerInfo();
            }
        });
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this.findUnderMouseInWindow(pointerInfo);
            if (!this.isSameOrAncestorOf(component, true)) {
                return null;
            }
            return this.pointRelativeToComponent(pointerInfo.getLocation());
        }
    }

    boolean isSameOrAncestorOf(Component component, boolean bl2) {
        return component == this;
    }

    public boolean isShowing() {
        if (this.visible && this.peer != null) {
            Container container = this.parent;
            return container == null || container.isShowing();
        }
        return false;
    }

    public boolean isEnabled() {
        return this.isEnabledImpl();
    }

    final boolean isEnabledImpl() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        this.enable(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        if (!this.enabled) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.enabled = true;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.enable();
                    if (this.visible) {
                        this.updateCursorImmediately();
                    }
                }
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    public void enable(boolean bl2) {
        if (bl2) {
            this.enable();
        } else {
            this.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        if (this.enabled) {
            KeyboardFocusManager.clearMostRecentFocusOwner(this);
            Object object = this.getTreeLock();
            synchronized (object) {
                ComponentPeer componentPeer;
                this.enabled = false;
                if (this.isFocusOwner()) {
                    this.autoTransferFocus(false);
                }
                if ((componentPeer = this.peer) != null) {
                    componentPeer.disable();
                    if (this.visible) {
                        this.updateCursorImmediately();
                    }
                }
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean bl2) {
        if (bl2) {
            InputContext inputContext;
            if ((this.eventMask & 0x1000L) != 0L) {
                return;
            }
            if (this.isFocusOwner() && (inputContext = this.getInputContext()) != null) {
                FocusEvent focusEvent = new FocusEvent(this, 1004);
                inputContext.dispatchEvent(focusEvent);
            }
            this.eventMask |= 0x1000L;
        } else {
            InputContext inputContext;
            if ((this.eventMask & 0x1000L) != 0L && (inputContext = this.getInputContext()) != null) {
                inputContext.endComposition();
                inputContext.removeNotify(this);
            }
            this.eventMask &= 0xFFFFFFFFFFFFEFFFL;
        }
    }

    public void setVisible(boolean bl2) {
        this.show(bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        if (!this.visible) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.visible = true;
                ComponentPeer componentPeer = this.peer;
                if (componentPeer != null) {
                    componentPeer.show();
                    this.createHierarchyEvents(1400, this, this.parent, 4L, Toolkit.enabledOnToolkit(32768L));
                    if (componentPeer instanceof LightweightPeer) {
                        this.repaint();
                    }
                    this.updateCursorImmediately();
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L)) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 102);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public void show(boolean bl2) {
        if (bl2) {
            this.show();
        } else {
            this.hide();
        }
    }

    boolean containsFocus() {
        return this.isFocusOwner();
    }

    void clearMostRecentFocusOwnerOnHide() {
        KeyboardFocusManager.clearMostRecentFocusOwner(this);
    }

    void clearCurrentFocusCycleRootOnHide() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        this.isPacked = false;
        if (this.visible) {
            this.clearCurrentFocusCycleRootOnHide();
            this.clearMostRecentFocusOwnerOnHide();
            Object object = this.getTreeLock();
            synchronized (object) {
                ComponentPeer componentPeer;
                this.visible = false;
                if (this.containsFocus()) {
                    this.autoTransferFocus(true);
                }
                if ((componentPeer = this.peer) != null) {
                    componentPeer.hide();
                    this.createHierarchyEvents(1400, this, this.parent, 4L, Toolkit.enabledOnToolkit(32768L));
                    if (componentPeer instanceof LightweightPeer) {
                        this.repaint();
                    }
                    this.updateCursorImmediately();
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L)) {
                    ComponentEvent componentEvent = new ComponentEvent(this, 103);
                    Toolkit.getEventQueue().postEvent(componentEvent);
                }
            }
            object = this.parent;
            if (object != null) {
                ((Container)object).invalidate();
            }
        }
    }

    public Color getForeground() {
        Color color = this.foreground;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        return container != null ? container.getForeground() : null;
    }

    public void setForeground(Color color) {
        Color color2 = this.foreground;
        ComponentPeer componentPeer = this.peer;
        this.foreground = color;
        if (componentPeer != null && (color = this.getForeground()) != null) {
            componentPeer.setForeground(color);
        }
        this.firePropertyChange("foreground", color2, color);
    }

    public boolean isForegroundSet() {
        return this.foreground != null;
    }

    public Color getBackground() {
        Color color = this.background;
        if (color != null) {
            return color;
        }
        Container container = this.parent;
        return container != null ? container.getBackground() : null;
    }

    public void setBackground(Color color) {
        Color color2 = this.background;
        ComponentPeer componentPeer = this.peer;
        this.background = color;
        if (componentPeer != null && (color = this.getBackground()) != null) {
            componentPeer.setBackground(color);
        }
        this.firePropertyChange("background", color2, color);
    }

    public boolean isBackgroundSet() {
        return this.background != null;
    }

    @Override
    public Font getFont() {
        return this.getFont_NoClientCode();
    }

    final Font getFont_NoClientCode() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        Container container = this.parent;
        return container != null ? container.getFont_NoClientCode() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        Font font2;
        Font font3;
        Component component = this;
        synchronized (component) {
            font3 = this.font;
            ComponentPeer componentPeer = this.peer;
            font2 = this.font = font;
            if (componentPeer != null && (font = this.getFont()) != null) {
                componentPeer.setFont(font);
                this.peerFont = font;
            }
        }
        this.firePropertyChange("font", font3, font2);
        if (this.valid) {
            this.invalidate();
        }
    }

    public boolean isFontSet() {
        return this.font != null;
    }

    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale != null) {
            return locale;
        }
        Container container = this.parent;
        if (container == null) {
            throw new IllegalComponentStateException("This component must have a parent in order to determine its locale");
        }
        return container.getLocale();
    }

    public void setLocale(Locale locale) {
        Locale locale2 = this.locale;
        this.locale = locale;
        this.firePropertyChange("locale", locale2, locale);
        if (this.valid) {
            this.invalidate();
        }
    }

    public ColorModel getColorModel() {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.getColorModel();
        }
        if (GraphicsEnvironment.isHeadless()) {
            return ColorModel.getRGBdefault();
        }
        return this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return this.location();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.getLocationOnScreen_NoTreeLock();
        }
    }

    final Point getLocationOnScreen_NoTreeLock() {
        if (this.peer != null && this.isShowing()) {
            if (this.peer instanceof LightweightPeer) {
                Container container = this.getNativeContainer();
                Point point = container.peer.getLocationOnScreen();
                for (Component component = this; component != container; component = component.getParent()) {
                    point.x += component.x;
                    point.y += component.y;
                }
                return point;
            }
            Point point = this.peer.getLocationOnScreen();
            return point;
        }
        throw new IllegalComponentStateException("component must be showing on the screen to determine its location");
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int n2, int n3) {
        this.move(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(int n2, int n3) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.setBoundsOp(1);
            this.setBounds(n2, n3, this.width, this.height);
        }
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public Dimension getSize() {
        return this.size();
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int n2, int n3) {
        this.resize(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n2, int n3) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.setBoundsOp(2);
            this.setBounds(this.x, this.y, n2, n3);
        }
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        this.reshape(n2, n3, n4, n5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(int n2, int n3, int n4, int n5) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                boolean bl2;
                this.setBoundsOp(3);
                boolean bl3 = this.width != n4 || this.height != n5;
                boolean bl4 = bl2 = this.x != n2 || this.y != n3;
                if (!bl3 && !bl2) {
                    return;
                }
                int n6 = this.x;
                int n7 = this.y;
                int n8 = this.width;
                int n9 = this.height;
                this.x = n2;
                this.y = n3;
                this.width = n4;
                this.height = n5;
                if (bl3) {
                    this.isPacked = false;
                }
                if (this.peer != null) {
                    if (!(this.peer instanceof LightweightPeer)) {
                        this.reshapeNativePeer(n2, n3, n4, n5, this.getBoundsOp());
                        bl3 = n8 != this.width || n9 != this.height;
                        boolean bl5 = bl2 = n6 != this.x || n7 != this.y;
                    }
                    if (bl3) {
                        this.invalidate();
                    }
                    if (this.parent != null && this.parent.valid) {
                        this.parent.invalidate();
                    }
                }
                this.notifyNewBounds(bl3, bl2);
                this.repaintParentIfNeeded(n6, n7, n8, n9);
            }
            finally {
                this.setBoundsOp(5);
            }
        }
    }

    private void repaintParentIfNeeded(int n2, int n3, int n4, int n5) {
        if (this.parent != null && this.peer instanceof LightweightPeer && this.isShowing()) {
            this.parent.repaint(n2, n3, n4, n5);
            this.repaint();
        }
    }

    private void reshapeNativePeer(int n2, int n3, int n4, int n5, int n6) {
        int n7 = n2;
        int n8 = n3;
        Container container = this.parent;
        while (container != null && container.peer instanceof LightweightPeer) {
            n7 += container.x;
            n8 += container.y;
            container = container.parent;
        }
        this.peer.setBounds(n7, n8, n4, n5, n6);
    }

    private void notifyNewBounds(boolean bl2, boolean bl3) {
        if (this.componentListener != null || (this.eventMask & 1L) != 0L || Toolkit.enabledOnToolkit(1L)) {
            ComponentEvent componentEvent;
            if (bl2) {
                componentEvent = new ComponentEvent(this, 101);
                Toolkit.getEventQueue().postEvent(componentEvent);
            }
            if (bl3) {
                componentEvent = new ComponentEvent(this, 100);
                Toolkit.getEventQueue().postEvent(componentEvent);
            }
        } else if (this instanceof Container && ((Container)this).ncomponents > 0) {
            boolean bl4 = Toolkit.enabledOnToolkit(65536L);
            if (bl2) {
                ((Container)this).createChildHierarchyEvents(1402, 0L, bl4);
            }
            if (bl3) {
                ((Container)this).createChildHierarchyEvents(1401, 0L, bl4);
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    public boolean isOpaque() {
        if (this.getPeer() == null) {
            return false;
        }
        return !this.isLightweight();
    }

    public boolean isLightweight() {
        return this.getPeer() instanceof LightweightPeer;
    }

    public void setPreferredSize(Dimension dimension) {
        Dimension dimension2 = this.prefSizeSet ? this.prefSize : null;
        this.prefSize = dimension;
        this.prefSizeSet = dimension != null;
        this.firePropertyChange("preferredSize", dimension2, dimension);
    }

    public boolean isPreferredSizeSet() {
        return this.prefSizeSet;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredSize() {
        Dimension dimension = this.prefSize;
        if (dimension == null || !this.isPreferredSizeSet() && !this.isValid()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                dimension = this.prefSize = this.peer != null ? this.peer.preferredSize() : this.getMinimumSize();
            }
        }
        return new Dimension(dimension);
    }

    public void setMinimumSize(Dimension dimension) {
        Dimension dimension2 = this.minSizeSet ? this.minSize : null;
        this.minSize = dimension;
        this.minSizeSet = dimension != null;
        this.firePropertyChange("minimumSize", dimension2, dimension);
    }

    public boolean isMinimumSizeSet() {
        return this.minSizeSet;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumSize() {
        Dimension dimension = this.minSize;
        if (dimension == null || !this.isMinimumSizeSet() && !this.isValid()) {
            Object object = this.getTreeLock();
            synchronized (object) {
                dimension = this.minSize = this.peer != null ? this.peer.minimumSize() : this.size();
            }
        }
        return new Dimension(dimension);
    }

    public void setMaximumSize(Dimension dimension) {
        Dimension dimension2 = this.maxSizeSet ? this.maxSize : null;
        this.maxSize = dimension;
        this.maxSizeSet = dimension != null;
        this.firePropertyChange("maximumSize", dimension2, dimension);
    }

    public boolean isMaximumSizeSet() {
        return this.maxSizeSet;
    }

    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return new Dimension(this.maxSize);
        }
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (!this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                ComponentPeer componentPeer = this.peer;
                if (!this.valid && componentPeer != null) {
                    Font font;
                    Font font2 = this.getFont();
                    if (!(font2 == (font = this.peerFont) || font != null && font.equals(font2))) {
                        componentPeer.setFont(font2);
                        this.peerFont = font2;
                    }
                    componentPeer.layout();
                }
            }
            this.valid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.valid = false;
            if (!this.isPreferredSizeSet()) {
                this.prefSize = null;
            }
            if (!this.isMinimumSizeSet()) {
                this.minSize = null;
            }
            if (!this.isMaximumSizeSet()) {
                this.maxSize = null;
            }
            if (this.parent != null && this.parent.valid) {
                this.parent.invalidate();
            }
        }
    }

    public Graphics getGraphics() {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent == null) {
                return null;
            }
            Graphics graphics = this.parent.getGraphics();
            if (graphics == null) {
                return null;
            }
            if (graphics instanceof ConstrainableGraphics) {
                ((ConstrainableGraphics)((Object)graphics)).constrain(this.x, this.y, this.width, this.height);
            } else {
                graphics.translate(this.x, this.y);
                graphics.setClip(0, 0, this.width, this.height);
            }
            graphics.setFont(this.getFont());
            return graphics;
        }
        ComponentPeer componentPeer = this.peer;
        return componentPeer != null ? componentPeer.getGraphics() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMetrics getFontMetrics(Font font) {
        Graphics graphics;
        FontMetrics fontMetrics = (FontMetrics)metrics.get(font);
        if (fontMetrics != null) {
            return fontMetrics;
        }
        if (FontManager.usePlatformFontMetrics() && this.peer != null && !(this.peer instanceof LightweightPeer)) {
            fontMetrics = this.peer.getFontMetrics(font);
            metrics.put(font, fontMetrics);
            return fontMetrics;
        }
        if (this.parent != null && (graphics = this.parent.getGraphics()) != null) {
            try {
                fontMetrics = graphics.getFontMetrics(font);
                metrics.put(font, fontMetrics);
                FontMetrics fontMetrics2 = fontMetrics;
                return fontMetrics2;
            }
            finally {
                graphics.dispose();
            }
        }
        fontMetrics = this.getToolkit().getFontMetrics(font);
        metrics.put(font, fontMetrics);
        return fontMetrics;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        this.updateCursorImmediately();
    }

    final void updateCursorImmediately() {
        if (this.peer instanceof LightweightPeer) {
            Container container = this.getNativeContainer();
            if (container == null) {
                return;
            }
            ComponentPeer componentPeer = container.getPeer();
            if (componentPeer != null) {
                componentPeer.updateCursorImmediately();
            }
        } else if (this.peer != null) {
            this.peer.updateCursorImmediately();
        }
    }

    public Cursor getCursor() {
        Cursor cursor = this.cursor;
        if (cursor != null) {
            return cursor;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getCursor();
        }
        return Cursor.getPredefinedCursor(0);
    }

    public boolean isCursorSet() {
        return this.cursor != null;
    }

    public void paint(Graphics graphics) {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PeerPaintCallback.getInstance().runOneComponent(this, new Rectangle(0, 0, this.width, this.height), graphics, graphics.getClip(), 3);
        }
    }

    void lightweightPaint(Graphics graphics) {
        this.paint(graphics);
    }

    void paintHeavyweightComponents(Graphics graphics) {
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(long l2) {
        this.repaint(l2, 0, 0, this.width, this.height);
    }

    public void repaint(int n2, int n3, int n4, int n5) {
        this.repaint(0L, n2, n3, n4, n5);
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        if (this.peer instanceof LightweightPeer) {
            if (this.parent != null) {
                int n6 = this.x + (n2 < 0 ? 0 : n2);
                int n7 = this.y + (n3 < 0 ? 0 : n3);
                int n8 = n4 > this.width ? this.width : n4;
                int n9 = n5 > this.height ? this.height : n5;
                this.parent.repaint(l2, n6, n7, n8, n9);
            }
        } else if (this.isVisible() && this.peer != null && n4 > 0 && n5 > 0) {
            PaintEvent paintEvent = new PaintEvent(this, 801, new Rectangle(n2, n3, n4, n5));
            Toolkit.getEventQueue().postEvent(paintEvent);
        }
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void printAll(Graphics graphics) {
        if (this.isShowing()) {
            GraphicsCallback.PeerPrintCallback.getInstance().runOneComponent(this, new Rectangle(0, 0, this.width, this.height), graphics, graphics.getClip(), 3);
        }
    }

    void lightweightPrint(Graphics graphics) {
        this.print(graphics);
    }

    void printHeavyweightComponents(Graphics graphics) {
    }

    @Override
    public boolean imageUpdate(Image image, int n2, int n3, int n4, int n5, int n6) {
        int n7 = -1;
        if ((n2 & 0x30) != 0) {
            n7 = 0;
        } else if ((n2 & 8) != 0 && isInc && (n7 = incRate) < 0) {
            n7 = 0;
        }
        if (n7 >= 0) {
            this.repaint(n7, 0, 0, this.width, this.height);
        }
        return (n2 & 0xA0) == 0;
    }

    public Image createImage(ImageProducer imageProducer) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer != null && !(componentPeer instanceof LightweightPeer)) {
            return componentPeer.createImage(imageProducer);
        }
        return this.getToolkit().createImage(imageProducer);
    }

    public Image createImage(int n2, int n3) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            if (this.parent != null) {
                return this.parent.createImage(n2, n3);
            }
            return null;
        }
        return componentPeer != null ? componentPeer.createImage(n2, n3) : null;
    }

    public VolatileImage createVolatileImage(int n2, int n3) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            if (this.parent != null) {
                return this.parent.createVolatileImage(n2, n3);
            }
            return null;
        }
        return componentPeer != null ? componentPeer.createVolatileImage(n2, n3) : null;
    }

    public VolatileImage createVolatileImage(int n2, int n3, ImageCapabilities imageCapabilities) throws AWTException {
        return this.createVolatileImage(n2, n3);
    }

    public boolean prepareImage(Image image, ImageObserver imageObserver) {
        return this.prepareImage(image, -1, -1, imageObserver);
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent != null ? this.parent.prepareImage(image, n2, n3, imageObserver) : this.getToolkit().prepareImage(image, n2, n3, imageObserver);
        }
        return componentPeer != null ? componentPeer.prepareImage(image, n2, n3, imageObserver) : this.getToolkit().prepareImage(image, n2, n3, imageObserver);
    }

    public int checkImage(Image image, ImageObserver imageObserver) {
        return this.checkImage(image, -1, -1, imageObserver);
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        ComponentPeer componentPeer = this.peer;
        if (componentPeer instanceof LightweightPeer) {
            return this.parent != null ? this.parent.checkImage(image, n2, n3, imageObserver) : this.getToolkit().checkImage(image, n2, n3, imageObserver);
        }
        return componentPeer != null ? componentPeer.checkImage(image, n2, n3, imageObserver) : this.getToolkit().checkImage(image, n2, n3, imageObserver);
    }

    void createBufferStrategy(int n2) {
        BufferCapabilities bufferCapabilities;
        if (n2 > 1) {
            bufferCapabilities = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), BufferCapabilities.FlipContents.UNDEFINED);
            try {
                this.createBufferStrategy(n2, bufferCapabilities);
                return;
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
        bufferCapabilities = new BufferCapabilities(new ImageCapabilities(true), new ImageCapabilities(true), null);
        try {
            this.createBufferStrategy(n2, bufferCapabilities);
            return;
        }
        catch (AWTException aWTException) {
            bufferCapabilities = new BufferCapabilities(new ImageCapabilities(false), new ImageCapabilities(false), null);
            try {
                this.createBufferStrategy(n2, bufferCapabilities);
                return;
            }
            catch (AWTException aWTException2) {
                throw new InternalError("Could not create a buffer strategy");
            }
        }
    }

    void createBufferStrategy(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
        if (n2 < 1) {
            throw new IllegalArgumentException("Number of buffers must be at least 1");
        }
        if (bufferCapabilities == null) {
            throw new IllegalArgumentException("No capabilities specified");
        }
        if (this.bufferStrategy instanceof FlipBufferStrategy) {
            ((FlipBufferStrategy)this.bufferStrategy).destroyBuffers();
        }
        this.bufferStrategy = n2 == 1 ? new SingleBufferStrategy(bufferCapabilities) : (bufferCapabilities.isPageFlipping() ? new FlipBufferStrategy(n2, bufferCapabilities) : new BltBufferStrategy(n2, bufferCapabilities));
    }

    BufferStrategy getBufferStrategy() {
        if (this.bufferStrategy == null) {
            this.createBufferStrategy(1);
        }
        return this.bufferStrategy;
    }

    Image getBackBuffer() {
        if (this.bufferStrategy != null) {
            if (this.bufferStrategy instanceof BltBufferStrategy) {
                BltBufferStrategy bltBufferStrategy = (BltBufferStrategy)this.bufferStrategy;
                return bltBufferStrategy.getBackBuffer();
            }
            if (this.bufferStrategy instanceof FlipBufferStrategy) {
                FlipBufferStrategy flipBufferStrategy = (FlipBufferStrategy)this.bufferStrategy;
                return flipBufferStrategy.getBackBuffer();
            }
        }
        return null;
    }

    public void setIgnoreRepaint(boolean bl2) {
        this.ignoreRepaint = bl2;
    }

    public boolean getIgnoreRepaint() {
        return this.ignoreRepaint;
    }

    public boolean contains(int n2, int n3) {
        return this.inside(n2, n3);
    }

    public boolean inside(int n2, int n3) {
        return n2 >= 0 && n2 < this.width && n3 >= 0 && n3 < this.height;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public Component getComponentAt(int n2, int n3) {
        return this.locate(n2, n3);
    }

    public Component locate(int n2, int n3) {
        return this.contains(n2, n3) ? this : null;
    }

    public Component getComponentAt(Point point) {
        return this.getComponentAt(point.x, point.y);
    }

    public void deliverEvent(Event event) {
        this.postEvent(event);
    }

    public final void dispatchEvent(AWTEvent aWTEvent) {
        this.dispatchEventImpl(aWTEvent);
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        Object object;
        int n2 = aWTEvent.getID();
        AppContext appContext = this.appContext;
        if (appContext != null && !appContext.equals(AppContext.getAppContext())) {
            log.fine("Event " + aWTEvent + " is being dispatched on the wrong AppContext");
        }
        EventQueue.setCurrentEventAndMostRecentTime(aWTEvent);
        if (aWTEvent instanceof SunDropTargetEvent) {
            ((SunDropTargetEvent)aWTEvent).dispatch();
            return;
        }
        if (!aWTEvent.focusManagerIsDispatching) {
            if (aWTEvent.isPosted) {
                aWTEvent = KeyboardFocusManager.retargetFocusEvent(aWTEvent);
                aWTEvent.isPosted = true;
            }
            if (KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(aWTEvent)) {
                return;
            }
        }
        if (aWTEvent instanceof FocusEvent && focusLog.isLoggable(Level.FINE)) {
            focusLog.fine("" + aWTEvent);
        }
        if (n2 == 507 && !this.eventTypeEnabled(n2) && this.peer != null && !this.peer.handlesWheelScrolling() && this.dispatchMouseWheelToAncestor((MouseWheelEvent)aWTEvent)) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.notifyAWTEventListeners(aWTEvent);
        if (!aWTEvent.isConsumed() && aWTEvent instanceof KeyEvent) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().processKeyEvent(this, (KeyEvent)aWTEvent);
            if (aWTEvent.isConsumed()) {
                return;
            }
        }
        if (this.areInputMethodsEnabled() && (aWTEvent instanceof InputMethodEvent && !(this instanceof CompositionArea) || aWTEvent instanceof InputEvent || aWTEvent instanceof FocusEvent) && (object = this.getInputContext()) != null) {
            ((InputContext)object).dispatchEvent(aWTEvent);
            if (aWTEvent.isConsumed()) {
                if (aWTEvent instanceof FocusEvent && focusLog.isLoggable(Level.FINER)) {
                    focusLog.finer("3579: Skipping " + aWTEvent);
                }
                return;
            }
        }
        switch (n2) {
            case 401: 
            case 402: {
                object = (Container)(this instanceof Container ? this : this.parent);
                if (object == null) break;
                ((Container)object).preProcessKeyEvent((KeyEvent)aWTEvent);
                if (!aWTEvent.isConsumed()) break;
                return;
            }
            case 201: {
                if (!(toolkit instanceof WindowClosingListener)) break;
                this.windowClosingException = ((WindowClosingListener)((Object)toolkit)).windowClosingNotify((WindowEvent)aWTEvent);
                if (!this.checkWindowClosingException()) break;
                return;
            }
        }
        if (this.newEventsOnly) {
            if (this.eventEnabled(aWTEvent)) {
                this.processEvent(aWTEvent);
            }
        } else if (n2 == 507) {
            this.autoProcessMouseWheel((MouseWheelEvent)aWTEvent);
        } else if ((!(aWTEvent instanceof MouseEvent) || this.postsOldMouseEvents()) && (object = aWTEvent.convertToOld()) != null) {
            int n3 = ((Event)object).key;
            int n4 = ((Event)object).modifiers;
            this.postEvent((Event)object);
            if (((Event)object).isConsumed()) {
                aWTEvent.consume();
            }
            switch (((Event)object).id) {
                case 401: 
                case 402: 
                case 403: 
                case 404: {
                    if (((Event)object).key != n3) {
                        ((KeyEvent)aWTEvent).setKeyChar(((Event)object).getKeyEventChar());
                    }
                    if (((Event)object).modifiers == n4) break;
                    ((KeyEvent)aWTEvent).setModifiers(((Event)object).modifiers);
                    break;
                }
            }
        }
        if (n2 == 201 && !aWTEvent.isConsumed() && toolkit instanceof WindowClosingListener) {
            this.windowClosingException = ((WindowClosingListener)((Object)toolkit)).windowClosingDelivered((WindowEvent)aWTEvent);
            if (this.checkWindowClosingException()) {
                return;
            }
        }
        if (!(aWTEvent instanceof KeyEvent)) {
            Container container;
            Component component;
            object = this.peer;
            if (aWTEvent instanceof FocusEvent && (object == null || object instanceof LightweightPeer) && (component = (Component)aWTEvent.getSource()) != null && (container = component.getNativeContainer()) != null) {
                object = container.getPeer();
            }
            if (object != null) {
                object.handleEvent(aWTEvent);
            }
        }
    }

    void autoProcessMouseWheel(MouseWheelEvent mouseWheelEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dispatchMouseWheelToAncestor(MouseWheelEvent mouseWheelEvent) {
        int n2 = mouseWheelEvent.getX() + this.getX();
        int n3 = mouseWheelEvent.getY() + this.getY();
        Object object = this.getTreeLock();
        synchronized (object) {
            Container container;
            for (container = this.getParent(); container != null && !container.eventEnabled(mouseWheelEvent); container = container.getParent()) {
                n2 += container.getX();
                n3 += container.getY();
                if (container instanceof Window) break;
            }
            if (container != null && container.eventEnabled(mouseWheelEvent)) {
                MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent(container, mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), n2, n3, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
                mouseWheelEvent.copyPrivateDataInto(mouseWheelEvent2);
                container.dispatchEventImpl(mouseWheelEvent2);
            }
        }
        return true;
    }

    boolean checkWindowClosingException() {
        if (this.windowClosingException != null) {
            if (this instanceof Dialog) {
                ((Dialog)this).interruptBlocking();
            } else {
                this.windowClosingException.fillInStackTrace();
                this.windowClosingException.printStackTrace();
                this.windowClosingException = null;
            }
            return true;
        }
        return false;
    }

    boolean areInputMethodsEnabled() {
        return (this.eventMask & 0x1000L) != 0L && ((this.eventMask & 8L) != 0L || this.keyListener != null);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        return this.eventTypeEnabled(aWTEvent.id);
    }

    boolean eventTypeEnabled(int n2) {
        switch (n2) {
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                if ((this.eventMask & 1L) == 0L && this.componentListener == null) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this.eventMask & 4L) == 0L && this.focusListener == null) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this.eventMask & 8L) == 0L && this.keyListener == null) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this.eventMask & 0x10L) == 0L && this.mouseListener == null) break;
                return true;
            }
            case 503: 
            case 506: {
                if ((this.eventMask & 0x20L) == 0L && this.mouseMotionListener == null) break;
                return true;
            }
            case 507: {
                if ((this.eventMask & 0x20000L) == 0L && this.mouseWheelListener == null) break;
                return true;
            }
            case 1100: 
            case 1101: {
                if ((this.eventMask & 0x800L) == 0L && this.inputMethodListener == null) break;
                return true;
            }
            case 1400: {
                if ((this.eventMask & 0x8000L) == 0L && this.hierarchyListener == null) break;
                return true;
            }
            case 1401: 
            case 1402: {
                if ((this.eventMask & 0x10000L) == 0L && this.hierarchyBoundsListener == null) break;
                return true;
            }
            case 1001: {
                if ((this.eventMask & 0x80L) == 0L) break;
                return true;
            }
            case 900: {
                if ((this.eventMask & 0x400L) == 0L) break;
                return true;
            }
            case 701: {
                if ((this.eventMask & 0x200L) == 0L) break;
                return true;
            }
            case 601: {
                if ((this.eventMask & 0x100L) == 0L) break;
                return true;
            }
        }
        return n2 > 1999;
    }

    @Override
    public boolean postEvent(Event event) {
        ComponentPeer componentPeer = this.peer;
        if (this.handleEvent(event)) {
            event.consume();
            return true;
        }
        Container container = this.parent;
        int n2 = event.x;
        int n3 = event.y;
        if (container != null) {
            event.translate(this.x, this.y);
            if (container.postEvent(event)) {
                event.consume();
                return true;
            }
            event.x = n2;
            event.y = n3;
        }
        return false;
    }

    public synchronized void addComponentListener(ComponentListener componentListener) {
        if (componentListener == null) {
            return;
        }
        this.componentListener = AWTEventMulticaster.add(this.componentListener, componentListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeComponentListener(ComponentListener componentListener) {
        if (componentListener == null) {
            return;
        }
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, componentListener);
    }

    public synchronized ComponentListener[] getComponentListeners() {
        return (ComponentListener[])this.getListeners(ComponentListener.class);
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.focusListener = AWTEventMulticaster.add(this.focusListener, focusListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(4L);
        }
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        if (focusListener == null) {
            return;
        }
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, focusListener);
    }

    public synchronized FocusListener[] getFocusListeners() {
        return (FocusListener[])this.getListeners(FocusListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHierarchyListener(HierarchyListener hierarchyListener) {
        boolean bl2;
        if (hierarchyListener == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            bl2 = this.hierarchyListener == null && (this.eventMask & 0x8000L) == 0L;
            this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, hierarchyListener);
            bl2 = bl2 && this.hierarchyListener != null;
            this.newEventsOnly = true;
        }
        if (bl2) {
            object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(32768L, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHierarchyListener(HierarchyListener hierarchyListener) {
        boolean bl2;
        if (hierarchyListener == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            bl2 = this.hierarchyListener != null && (this.eventMask & 0x8000L) == 0L;
            this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, hierarchyListener);
            bl2 = bl2 && this.hierarchyListener == null;
        }
        if (bl2) {
            object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(32768L, -1);
            }
        }
    }

    public synchronized HierarchyListener[] getHierarchyListeners() {
        return (HierarchyListener[])this.getListeners(HierarchyListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        boolean bl2;
        if (hierarchyBoundsListener == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            bl2 = this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) == 0L;
            this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, hierarchyBoundsListener);
            bl2 = bl2 && this.hierarchyBoundsListener != null;
            this.newEventsOnly = true;
        }
        if (bl2) {
            object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(65536L, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHierarchyBoundsListener(HierarchyBoundsListener hierarchyBoundsListener) {
        boolean bl2;
        if (hierarchyBoundsListener == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            bl2 = this.hierarchyBoundsListener != null && (this.eventMask & 0x10000L) == 0L;
            this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, hierarchyBoundsListener);
            bl2 = bl2 && this.hierarchyBoundsListener == null;
        }
        if (bl2) {
            object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(65536L, -1);
            }
        }
    }

    int numListening(long l2) {
        if (l2 == 32768L && (this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L) || l2 == 65536L && (this.hierarchyBoundsListener != null || (this.eventMask & 0x10000L) != 0L)) {
            return 1;
        }
        return 0;
    }

    int countHierarchyMembers() {
        return 1;
    }

    int createHierarchyEvents(int n2, Component component, Container container, long l2, boolean bl2) {
        switch (n2) {
            case 1400: {
                if (this.hierarchyListener == null && (this.eventMask & 0x8000L) == 0L && !bl2) break;
                HierarchyEvent hierarchyEvent = new HierarchyEvent(this, n2, component, container, l2);
                this.dispatchEvent(hierarchyEvent);
                return 1;
            }
            case 1401: 
            case 1402: {
                if (this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) == 0L && !bl2) break;
                HierarchyEvent hierarchyEvent = new HierarchyEvent(this, n2, component, container);
                this.dispatchEvent(hierarchyEvent);
                return 1;
            }
        }
        return 0;
    }

    public synchronized HierarchyBoundsListener[] getHierarchyBoundsListeners() {
        return (HierarchyBoundsListener[])this.getListeners(HierarchyBoundsListener.class);
    }

    void adjustListeningChildrenOnParent(long l2, int n2) {
        if (this.parent != null) {
            this.parent.adjustListeningChildren(l2, n2);
        }
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        this.keyListener = AWTEventMulticaster.add(this.keyListener, keyListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(8L);
        }
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        if (keyListener == null) {
            return;
        }
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, keyListener);
    }

    public synchronized KeyListener[] getKeyListeners() {
        return (KeyListener[])this.getListeners(KeyListener.class);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(16L);
        }
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public synchronized MouseListener[] getMouseListeners() {
        return (MouseListener[])this.getListeners(MouseListener.class);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, mouseMotionListener);
        this.newEventsOnly = true;
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(32L);
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (mouseMotionListener == null) {
            return;
        }
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, mouseMotionListener);
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        return (MouseMotionListener[])this.getListeners(MouseMotionListener.class);
    }

    public synchronized void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (mouseWheelListener == null) {
            return;
        }
        this.mouseWheelListener = AWTEventMulticaster.add(this.mouseWheelListener, mouseWheelListener);
        this.newEventsOnly = true;
        dbg.println("Component.addMouseWheelListener(): newEventsOnly = " + this.newEventsOnly);
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(131072L);
        }
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        if (mouseWheelListener == null) {
            return;
        }
        this.mouseWheelListener = AWTEventMulticaster.remove(this.mouseWheelListener, mouseWheelListener);
    }

    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        return (MouseWheelListener[])this.getListeners(MouseWheelListener.class);
    }

    public synchronized void addInputMethodListener(InputMethodListener inputMethodListener) {
        if (inputMethodListener == null) {
            return;
        }
        this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, inputMethodListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeInputMethodListener(InputMethodListener inputMethodListener) {
        if (inputMethodListener == null) {
            return;
        }
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, inputMethodListener);
    }

    public synchronized InputMethodListener[] getInputMethodListeners() {
        return (InputMethodListener[])this.getListeners(InputMethodListener.class);
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener eventListener = null;
        if (clazz == ComponentListener.class) {
            eventListener = this.componentListener;
        } else if (clazz == FocusListener.class) {
            eventListener = this.focusListener;
        } else if (clazz == HierarchyListener.class) {
            eventListener = this.hierarchyListener;
        } else if (clazz == HierarchyBoundsListener.class) {
            eventListener = this.hierarchyBoundsListener;
        } else if (clazz == KeyListener.class) {
            eventListener = this.keyListener;
        } else if (clazz == MouseListener.class) {
            eventListener = this.mouseListener;
        } else if (clazz == MouseMotionListener.class) {
            eventListener = this.mouseMotionListener;
        } else if (clazz == MouseWheelListener.class) {
            eventListener = this.mouseWheelListener;
        } else if (clazz == InputMethodListener.class) {
            eventListener = this.inputMethodListener;
        } else if (clazz == PropertyChangeListener.class) {
            return this.getPropertyChangeListeners();
        }
        return AWTEventMulticaster.getListeners((EventListener)eventListener, clazz);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public InputContext getInputContext() {
        Container container = this.parent;
        if (container == null) {
            return null;
        }
        return container.getInputContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void enableEvents(long l2) {
        long l3 = 0L;
        Object object = this;
        synchronized (object) {
            if ((l2 & 0x8000L) != 0L && this.hierarchyListener == null && (this.eventMask & 0x8000L) == 0L) {
                l3 |= 0x8000L;
            }
            if ((l2 & 0x10000L) != 0L && this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) == 0L) {
                l3 |= 0x10000L;
            }
            this.eventMask |= l2;
            this.newEventsOnly = true;
        }
        if (this.peer instanceof LightweightPeer) {
            this.parent.proxyEnableEvents(this.eventMask);
        }
        if (l3 != 0L) {
            object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(l3, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disableEvents(long l2) {
        long l3 = 0L;
        Object object = this;
        synchronized (object) {
            if ((l2 & 0x8000L) != 0L && this.hierarchyListener == null && (this.eventMask & 0x8000L) != 0L) {
                l3 |= 0x8000L;
            }
            if ((l2 & 0x10000L) != 0L && this.hierarchyBoundsListener == null && (this.eventMask & 0x10000L) != 0L) {
                l3 |= 0x10000L;
            }
            this.eventMask &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (l3 != 0L) {
            object = this.getTreeLock();
            synchronized (object) {
                this.adjustListeningChildrenOnParent(l3, -1);
            }
        }
    }

    protected AWTEvent coalesceEvents(AWTEvent aWTEvent, AWTEvent aWTEvent2) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 503: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (mouseEvent.getModifiers() != ((MouseEvent)aWTEvent2).getModifiers()) break;
                return aWTEvent2;
            }
            case 800: 
            case 801: {
                if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
                    return aWTEvent2;
                }
                PaintEvent paintEvent = (PaintEvent)aWTEvent;
                PaintEvent paintEvent2 = (PaintEvent)aWTEvent2;
                Rectangle rectangle = paintEvent.getUpdateRect();
                Rectangle rectangle2 = paintEvent2.getUpdateRect();
                if (rectangle.contains(rectangle2)) {
                    return aWTEvent;
                }
                if (!rectangle2.contains(rectangle)) break;
                return aWTEvent2;
            }
        }
        return null;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)aWTEvent);
        } else if (aWTEvent instanceof MouseEvent) {
            switch (aWTEvent.getID()) {
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent((MouseEvent)aWTEvent);
                    break;
                }
                case 503: 
                case 506: {
                    this.processMouseMotionEvent((MouseEvent)aWTEvent);
                    break;
                }
                case 507: {
                    this.processMouseWheelEvent((MouseWheelEvent)aWTEvent);
                }
            }
        } else if (aWTEvent instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)aWTEvent);
        } else if (aWTEvent instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)aWTEvent);
        } else if (aWTEvent instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)aWTEvent);
        } else if (aWTEvent instanceof HierarchyEvent) {
            switch (aWTEvent.getID()) {
                case 1400: {
                    this.processHierarchyEvent((HierarchyEvent)aWTEvent);
                    break;
                }
                case 1401: 
                case 1402: {
                    this.processHierarchyBoundsEvent((HierarchyEvent)aWTEvent);
                }
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        ComponentListener componentListener = this.componentListener;
        if (componentListener != null) {
            int n2 = componentEvent.getID();
            switch (n2) {
                case 101: {
                    componentListener.componentResized(componentEvent);
                    break;
                }
                case 100: {
                    componentListener.componentMoved(componentEvent);
                    break;
                }
                case 102: {
                    componentListener.componentShown(componentEvent);
                    break;
                }
                case 103: {
                    componentListener.componentHidden(componentEvent);
                }
            }
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        FocusListener focusListener = this.focusListener;
        if (focusListener != null) {
            int n2 = focusEvent.getID();
            switch (n2) {
                case 1004: {
                    focusListener.focusGained(focusEvent);
                    break;
                }
                case 1005: {
                    focusListener.focusLost(focusEvent);
                }
            }
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        KeyListener keyListener = this.keyListener;
        if (keyListener != null) {
            int n2 = keyEvent.getID();
            switch (n2) {
                case 400: {
                    keyListener.keyTyped(keyEvent);
                    break;
                }
                case 401: {
                    keyListener.keyPressed(keyEvent);
                    break;
                }
                case 402: {
                    keyListener.keyReleased(keyEvent);
                }
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        MouseListener mouseListener = this.mouseListener;
        if (mouseListener != null) {
            int n2 = mouseEvent.getID();
            switch (n2) {
                case 501: {
                    mouseListener.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    mouseListener.mouseReleased(mouseEvent);
                    break;
                }
                case 500: {
                    mouseListener.mouseClicked(mouseEvent);
                    break;
                }
                case 505: {
                    mouseListener.mouseExited(mouseEvent);
                    break;
                }
                case 504: {
                    mouseListener.mouseEntered(mouseEvent);
                }
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        MouseMotionListener mouseMotionListener = this.mouseMotionListener;
        if (mouseMotionListener != null) {
            int n2 = mouseEvent.getID();
            switch (n2) {
                case 503: {
                    mouseMotionListener.mouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    mouseMotionListener.mouseDragged(mouseEvent);
                }
            }
        }
    }

    protected void processMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        MouseWheelListener mouseWheelListener = this.mouseWheelListener;
        if (mouseWheelListener != null) {
            int n2 = mouseWheelEvent.getID();
            switch (n2) {
                case 507: {
                    mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
                }
            }
        }
    }

    boolean postsOldMouseEvents() {
        return false;
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        InputMethodListener inputMethodListener = this.inputMethodListener;
        if (inputMethodListener != null) {
            int n2 = inputMethodEvent.getID();
            switch (n2) {
                case 1100: {
                    inputMethodListener.inputMethodTextChanged(inputMethodEvent);
                    break;
                }
                case 1101: {
                    inputMethodListener.caretPositionChanged(inputMethodEvent);
                }
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        HierarchyListener hierarchyListener = this.hierarchyListener;
        if (hierarchyListener != null) {
            int n2 = hierarchyEvent.getID();
            switch (n2) {
                case 1400: {
                    hierarchyListener.hierarchyChanged(hierarchyEvent);
                }
            }
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent hierarchyEvent) {
        HierarchyBoundsListener hierarchyBoundsListener = this.hierarchyBoundsListener;
        if (hierarchyBoundsListener != null) {
            int n2 = hierarchyEvent.getID();
            switch (n2) {
                case 1401: {
                    hierarchyBoundsListener.ancestorMoved(hierarchyEvent);
                    break;
                }
                case 1402: {
                    hierarchyBoundsListener.ancestorResized(hierarchyEvent);
                }
            }
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 504: {
                return this.mouseEnter(event, event.x, event.y);
            }
            case 505: {
                return this.mouseExit(event, event.x, event.y);
            }
            case 503: {
                return this.mouseMove(event, event.x, event.y);
            }
            case 501: {
                return this.mouseDown(event, event.x, event.y);
            }
            case 506: {
                return this.mouseDrag(event, event.x, event.y);
            }
            case 502: {
                return this.mouseUp(event, event.x, event.y);
            }
            case 401: 
            case 403: {
                return this.keyDown(event, event.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(event, event.key);
            }
            case 1001: {
                return this.action(event, event.arg);
            }
            case 1004: {
                return this.gotFocus(event, event.arg);
            }
            case 1005: {
                return this.lostFocus(event, event.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseDrag(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseUp(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseMove(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseEnter(Event event, int n2, int n3) {
        return false;
    }

    public boolean mouseExit(Event event, int n2, int n3) {
        return false;
    }

    public boolean keyDown(Event event, int n2) {
        return false;
    }

    public boolean keyUp(Event event, int n2) {
        return false;
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuContainer menuContainer;
            ComponentPeer componentPeer = this.peer;
            if (componentPeer == null || componentPeer instanceof LightweightPeer) {
                if (componentPeer == null) {
                    this.peer = componentPeer = this.getToolkit().createComponent(this);
                }
                if (this.parent != null) {
                    long l2 = 0L;
                    if (this.mouseListener != null || (this.eventMask & 0x10L) != 0L) {
                        l2 |= 0x10L;
                    }
                    if (this.mouseMotionListener != null || (this.eventMask & 0x20L) != 0L) {
                        l2 |= 0x20L;
                    }
                    if (this.mouseWheelListener != null || (this.eventMask & 0x20000L) != 0L) {
                        l2 |= 0x20000L;
                    }
                    if (this.focusListener != null || (this.eventMask & 4L) != 0L) {
                        l2 |= 4L;
                    }
                    if (this.keyListener != null || (this.eventMask & 8L) != 0L) {
                        l2 |= 8L;
                    }
                    if (l2 != 0L) {
                        this.parent.proxyEnableEvents(l2);
                    }
                }
            } else {
                Container container = this.parent;
                if (container != null && container.peer instanceof LightweightPeer) {
                    this.nativeInLightFixer = new NativeInLightFixer();
                }
            }
            this.invalidate();
            int n2 = this.popups != null ? this.popups.size() : 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                menuContainer = (PopupMenu)this.popups.elementAt(i2);
                menuContainer.addNotify();
            }
            if (this.dropTarget != null) {
                this.dropTarget.addNotify(componentPeer);
            }
            this.peerFont = this.getFont();
            if (this.parent != null && this.parent.peer != null) {
                ContainerPeer containerPeer = (ContainerPeer)this.parent.peer;
                if (containerPeer instanceof LightweightPeer && !(componentPeer instanceof LightweightPeer) && (menuContainer = this.getNativeContainer()) != null && ((Container)menuContainer).peer != null) {
                    containerPeer = (ContainerPeer)((Container)menuContainer).peer;
                }
                if (containerPeer.isRestackSupported()) {
                    containerPeer.restack();
                }
            }
            if (this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L || Toolkit.enabledOnToolkit(32768L)) {
                HierarchyEvent hierarchyEvent = new HierarchyEvent(this, 1400, this, this.parent, 2 | (this.isRecursivelyVisible() ? 4 : 0));
                this.dispatchEvent(hierarchyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        KeyboardFocusManager.clearMostRecentFocusOwner(this);
        if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == this) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalPermanentFocusOwner(null);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            ComponentPeer componentPeer;
            InputContext inputContext;
            Serializable serializable;
            if (this.isFocusOwner() && !this.nextFocusHelper()) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
            int n2 = this.popups != null ? this.popups.size() : 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                serializable = (PopupMenu)this.popups.elementAt(i2);
                serializable.removeNotify();
            }
            if ((this.eventMask & 0x1000L) != 0L && (inputContext = this.getInputContext()) != null) {
                inputContext.removeNotify(this);
            }
            if ((componentPeer = this.peer) != null) {
                if (this.bufferStrategy instanceof FlipBufferStrategy) {
                    ((FlipBufferStrategy)this.bufferStrategy).destroyBuffers();
                }
                if (this.dropTarget != null) {
                    this.dropTarget.removeNotify(this.peer);
                }
                if (this.visible) {
                    componentPeer.hide();
                }
                this.peer = null;
                this.peerFont = null;
                Toolkit.getEventQueue().removeSourceEvents(this, false);
                KeyboardFocusManager.getCurrentKeyboardFocusManager().discardKeyEvents(this);
                componentPeer.dispose();
            }
            if (this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L || Toolkit.enabledOnToolkit(32768L)) {
                serializable = new HierarchyEvent(this, 1400, this, this.parent, 2 | (this.isRecursivelyVisible() ? 4 : 0));
                this.dispatchEvent((AWTEvent)serializable);
            }
        }
    }

    public boolean gotFocus(Event event, Object object) {
        return false;
    }

    public boolean lostFocus(Event event, Object object) {
        return false;
    }

    public boolean isFocusTraversable() {
        if (this.isFocusTraversableOverridden == 0) {
            this.isFocusTraversableOverridden = 1;
        }
        return this.focusable;
    }

    public boolean isFocusable() {
        return this.isFocusTraversable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusable(boolean bl2) {
        boolean bl3;
        Component component = this;
        synchronized (component) {
            bl3 = this.focusable;
            this.focusable = bl2;
        }
        this.isFocusTraversableOverridden = 2;
        this.firePropertyChange("focusable", bl3, bl2);
        if (bl3 && !bl2) {
            if (this.isFocusOwner()) {
                this.autoTransferFocus(true);
            }
            KeyboardFocusManager.clearMostRecentFocusOwner(this);
        }
    }

    final boolean isFocusTraversableOverridden() {
        return this.isFocusTraversableOverridden != 1;
    }

    public void setFocusTraversalKeys(int n2, Set<? extends AWTKeyStroke> set) {
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        this.setFocusTraversalKeys_NoIDCheck(n2, set);
    }

    public Set<AWTKeyStroke> getFocusTraversalKeys(int n2) {
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.getFocusTraversalKeys_NoIDCheck(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setFocusTraversalKeys_NoIDCheck(int n2, Set set) {
        Set set2;
        Component component = this;
        synchronized (component) {
            if (this.focusTraversalKeys == null) {
                this.initializeFocusTraversalKeys();
            }
            if (set != null) {
                for (Object e2 : set) {
                    if (e2 == null) {
                        throw new IllegalArgumentException("cannot set null focus traversal key");
                    }
                    AWTKeyStroke aWTKeyStroke = (AWTKeyStroke)e2;
                    if (aWTKeyStroke.getKeyChar() != '\uffff') {
                        throw new IllegalArgumentException("focus traversal keys cannot map to KEY_TYPED events");
                    }
                    for (int i2 = 0; i2 < this.focusTraversalKeys.length; ++i2) {
                        if (i2 == n2 || !this.getFocusTraversalKeys_NoIDCheck(i2).contains(aWTKeyStroke)) continue;
                        throw new IllegalArgumentException("focus traversal keys must be unique for a Component");
                    }
                }
            }
            set2 = this.focusTraversalKeys[n2];
            this.focusTraversalKeys[n2] = set != null ? Collections.unmodifiableSet(new HashSet(set)) : null;
        }
        this.firePropertyChange(focusTraversalKeyPropertyNames[n2], set2, set);
    }

    final Set getFocusTraversalKeys_NoIDCheck(int n2) {
        Set set;
        Set set2 = set = this.focusTraversalKeys != null ? this.focusTraversalKeys[n2] : null;
        if (set != null) {
            return set;
        }
        Container container = this.parent;
        if (container != null) {
            return container.getFocusTraversalKeys(n2);
        }
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(n2);
    }

    public boolean areFocusTraversalKeysSet(int n2) {
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[n2] != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocusTraversalKeysEnabled(boolean bl2) {
        boolean bl3;
        Component component = this;
        synchronized (component) {
            bl3 = this.focusTraversalKeysEnabled;
            this.focusTraversalKeysEnabled = bl2;
        }
        this.firePropertyChange("focusTraversalKeysEnabled", bl3, bl2);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return this.focusTraversalKeysEnabled;
    }

    public void requestFocus() {
        this.requestFocusHelper(false, true);
    }

    protected boolean requestFocus(boolean bl2) {
        return this.requestFocusHelper(bl2, true);
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusHelper(false, false);
    }

    protected boolean requestFocusInWindow(boolean bl2) {
        return this.requestFocusHelper(bl2, false);
    }

    final boolean requestFocusHelper(boolean bl2, boolean bl3) {
        ComponentPeer componentPeer;
        if (this.isFocusable() && this.isVisible() && (componentPeer = this.peer) != null) {
            Component component;
            boolean bl4 = false;
            Component component2 = this;
            while (!(component2 instanceof Window)) {
                if (!component2.isVisible()) {
                    bl4 = true;
                }
                component2 = component2.parent;
            }
            if (component2 == null || !((Window)component2).isFocusableWindow()) {
                focusLog.finest("FAIL 1");
                return false;
            }
            KeyboardFocusManager.setMostRecentFocusOwner(this);
            if (bl4) {
                focusLog.finest("FAIL 1.5");
                return false;
            }
            Component component3 = component = componentPeer instanceof LightweightPeer ? this.getNativeContainer() : this;
            if (component == null || !component.isVisible()) {
                focusLog.finest("FAIL 2");
                return false;
            }
            componentPeer = component.peer;
            if (componentPeer == null) {
                focusLog.finest("FAIL 3");
                return false;
            }
            long l2 = EventQueue.getMostRecentEventTime();
            boolean bl5 = componentPeer.requestFocus(this, bl2, bl3, l2);
            if (!bl5) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager(this.appContext).dequeueKeyEvents(l2, this);
                focusLog.finest("FAIL 4");
            } else if (focusLog.isLoggable(Level.FINEST)) {
                focusLog.finest("Pass for " + this);
            }
            return bl5;
        }
        focusLog.finest("FAIL 5");
        return false;
    }

    final void autoTransferFocus(boolean bl2) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != this) {
            if (component != null) {
                component.autoTransferFocus(bl2);
            }
            return;
        }
        if (!(this.isDisplayable() && this.isVisible() && this.isEnabled() && this.isFocusable())) {
            this.doAutoTransfer(bl2);
            return;
        }
        for (component = this.getParent(); component != null && !(component instanceof Window); component = component.getParent()) {
            if (component.isDisplayable() && component.isVisible() && (component.isEnabled() || component.isLightweight())) continue;
            this.doAutoTransfer(bl2);
            return;
        }
    }

    private void doAutoTransfer(boolean bl2) {
        if (bl2) {
            if (!this.nextFocusHelper()) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
        } else {
            this.transferFocus();
        }
    }

    public void transferFocus() {
        this.nextFocus();
    }

    public Container getFocusCycleRootAncestor() {
        Container container = this.parent;
        while (container != null && !container.isFocusCycleRoot()) {
            container = container.parent;
        }
        return container;
    }

    public boolean isFocusCycleRoot(Container container) {
        Container container2 = this.getFocusCycleRootAncestor();
        return container2 == container;
    }

    public void nextFocus() {
        this.nextFocusHelper();
    }

    boolean nextFocusHelper() {
        Container container = this.getFocusCycleRootAncestor();
        Component component = this;
        while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
            component = container;
            container = component.getFocusCycleRootAncestor();
        }
        if (container != null) {
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component2 = focusTraversalPolicy.getComponentAfter(container, component);
            if (component2 == null) {
                component2 = focusTraversalPolicy.getDefaultComponent(container);
            }
            if (component2 != null) {
                if (focusLog.isLoggable(Level.FINER)) {
                    focusLog.finer("Next component " + component2);
                }
                boolean bl2 = component2.requestFocus(false);
                if (focusLog.isLoggable(Level.FINER)) {
                    focusLog.finer("Request focus returned " + bl2);
                }
                return bl2;
            }
        }
        return false;
    }

    public void transferFocusBackward() {
        Container container = this.getFocusCycleRootAncestor();
        Component component = this;
        while (!(container == null || container.isShowing() && container.isFocusable() && container.isEnabled())) {
            component = container;
            container = component.getFocusCycleRootAncestor();
        }
        if (container != null) {
            FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
            Component component2 = focusTraversalPolicy.getComponentBefore(container, component);
            if (component2 == null) {
                component2 = focusTraversalPolicy.getDefaultComponent(container);
            }
            if (component2 != null) {
                component2.requestFocus();
            }
        }
    }

    public void transferFocusUpCycle() {
        Container container;
        for (container = this.getFocusCycleRootAncestor(); !(container == null || container.isShowing() && container.isFocusable() && container.isEnabled()); container = container.getFocusCycleRootAncestor()) {
        }
        if (container != null) {
            Container container2 = container.getFocusCycleRootAncestor();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(container2 != null ? container2 : container);
            container.requestFocus();
        } else {
            Component component;
            Container container3;
            Container container4 = container3 = this instanceof Container ? (Container)this : this.getParent();
            while (container3 != null && !(container3 instanceof Window)) {
                container3 = container3.getParent();
            }
            if (container3 != null && (component = container3.getFocusTraversalPolicy().getDefaultComponent(container3)) != null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().setGlobalCurrentFocusCycleRoot(container3);
                component.requestFocus();
            }
        }
    }

    public boolean hasFocus() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == this;
    }

    public boolean isFocusOwner() {
        return this.hasFocus();
    }

    public synchronized void add(PopupMenu popupMenu) {
        if (popupMenu.parent != null) {
            popupMenu.parent.remove(popupMenu);
        }
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.addElement(popupMenu);
        popupMenu.parent = this;
        if (this.peer != null && popupMenu.peer == null) {
            popupMenu.addNotify();
        }
    }

    @Override
    public synchronized void remove(MenuComponent menuComponent) {
        int n2;
        if (this.popups != null && (n2 = this.popups.indexOf(menuComponent)) >= 0) {
            PopupMenu popupMenu = (PopupMenu)menuComponent;
            if (popupMenu.peer != null) {
                popupMenu.removeNotify();
            }
            popupMenu.parent = null;
            this.popups.removeElementAt(n2);
            if (this.popups.size() == 0) {
                this.popups = null;
            }
        }
    }

    protected String paramString() {
        String string = this.getName();
        String string2 = (string != null ? string : "") + "," + this.x + "," + this.y + "," + this.width + "x" + this.height;
        if (!this.valid) {
            string2 = string2 + ",invalid";
        }
        if (!this.visible) {
            string2 = string2 + ",hidden";
        }
        if (!this.enabled) {
            string2 = string2 + ",disabled";
        }
        return string2;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream printStream) {
        this.list(printStream, 0);
    }

    public void list(PrintStream printStream, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            printStream.print(" ");
        }
        printStream.println(this);
    }

    public void list(PrintWriter printWriter) {
        this.list(printWriter, 0);
    }

    public void list(PrintWriter printWriter, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            printWriter.print(" ");
        }
        printWriter.println(this);
    }

    Container getNativeContainer() {
        Container container;
        for (container = this.parent; container != null && container.peer instanceof LightweightPeer; container = container.getParent()) {
        }
        return container;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null || object != null && object2 != null && object.equals(object2)) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl2, boolean bl3) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null || bl2 == bl3) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl2, bl3);
    }

    protected void firePropertyChange(String string, int n2, int n3) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null || n2 == n3) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n2, n3);
    }

    public void firePropertyChange(String string, byte by, byte by2) {
        if (this.changeSupport == null || by == by2) {
            return;
        }
        this.firePropertyChange(string, new Byte(by), new Byte(by2));
    }

    public void firePropertyChange(String string, char c2, char c3) {
        if (this.changeSupport == null || c2 == c3) {
            return;
        }
        this.firePropertyChange(string, new Character(c2), new Character(c3));
    }

    public void firePropertyChange(String string, short s2, short s3) {
        if (this.changeSupport == null || s2 == s3) {
            return;
        }
        this.firePropertyChange(string, new Short(s2), new Short(s3));
    }

    public void firePropertyChange(String string, long l2, long l3) {
        if (this.changeSupport == null || l2 == l3) {
            return;
        }
        this.firePropertyChange(string, new Long(l2), new Long(l3));
    }

    public void firePropertyChange(String string, float f2, float f3) {
        if (this.changeSupport == null || f2 == f3) {
            return;
        }
        this.firePropertyChange(string, new Float(f2), new Float(f3));
    }

    public void firePropertyChange(String string, double d2, double d3) {
        if (this.changeSupport == null || d2 == d3) {
            return;
        }
        this.firePropertyChange(string, new Double(d2), new Double(d3));
    }

    private void doSwingSerialization() {
        Class<? extends Object> clazz;
        Package package_ = Package.getPackage("javax.swing");
        for (clazz = this.getClass(); clazz != null && clazz.getPackage() != package_ && clazz.getClassLoader() == null; clazz = clazz.getSuperclass()) {
        }
        while (clazz != null && clazz.getClassLoader() == null) {
            if (clazz.getPackage() == package_) {
                final Class<? extends Object> clazz2 = clazz;
                Method[] methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return clazz2.getDeclaredMethods();
                    }
                });
                for (int i2 = methodArray.length - 1; i2 >= 0; --i2) {
                    final Method method = methodArray[i2];
                    if (!method.getName().equals("compWriteObjectNotify")) continue;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            method.setAccessible(true);
                            return null;
                        }
                    });
                    try {
                        method.invoke(this, null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    return;
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.doSwingSerialization();
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, componentListenerK, this.componentListener);
        AWTEventMulticaster.save(objectOutputStream, focusListenerK, this.focusListener);
        AWTEventMulticaster.save(objectOutputStream, keyListenerK, this.keyListener);
        AWTEventMulticaster.save(objectOutputStream, mouseListenerK, this.mouseListener);
        AWTEventMulticaster.save(objectOutputStream, mouseMotionListenerK, this.mouseMotionListener);
        AWTEventMulticaster.save(objectOutputStream, inputMethodListenerK, this.inputMethodListener);
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(this.componentOrientation);
        AWTEventMulticaster.save(objectOutputStream, hierarchyListenerK, this.hierarchyListener);
        AWTEventMulticaster.save(objectOutputStream, hierarchyBoundsListenerK, this.hierarchyBoundsListener);
        objectOutputStream.writeObject(null);
        AWTEventMulticaster.save(objectOutputStream, mouseWheelListenerK, this.mouseWheelListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        block23: {
            String string;
            Object object;
            block22: {
                Object object2;
                block21: {
                    objectInputStream.defaultReadObject();
                    this.privateKey = new Object();
                    this.appContext = AppContext.getAppContext();
                    if (this.componentSerializedDataVersion < 4) {
                        this.focusable = true;
                        this.isFocusTraversableOverridden = 0;
                        this.initializeFocusTraversalKeys();
                        this.focusTraversalKeysEnabled = true;
                    }
                    while (null != (object = objectInputStream.readObject())) {
                        object2 = ((String)object).intern();
                        if (componentListenerK == object2) {
                            this.addComponentListener((ComponentListener)objectInputStream.readObject());
                            continue;
                        }
                        if (focusListenerK == object2) {
                            this.addFocusListener((FocusListener)objectInputStream.readObject());
                            continue;
                        }
                        if (keyListenerK == object2) {
                            this.addKeyListener((KeyListener)objectInputStream.readObject());
                            continue;
                        }
                        if (mouseListenerK == object2) {
                            this.addMouseListener((MouseListener)objectInputStream.readObject());
                            continue;
                        }
                        if (mouseMotionListenerK == object2) {
                            this.addMouseMotionListener((MouseMotionListener)objectInputStream.readObject());
                            continue;
                        }
                        if (inputMethodListenerK == object2) {
                            this.addInputMethodListener((InputMethodListener)objectInputStream.readObject());
                            continue;
                        }
                        objectInputStream.readObject();
                    }
                    object2 = null;
                    try {
                        object2 = objectInputStream.readObject();
                    }
                    catch (OptionalDataException optionalDataException) {
                        if (optionalDataException.eof) break block21;
                        throw optionalDataException;
                    }
                }
                this.componentOrientation = object2 != null ? (ComponentOrientation)object2 : ComponentOrientation.UNKNOWN;
                try {
                    while (null != (object = objectInputStream.readObject())) {
                        string = ((String)object).intern();
                        if (hierarchyListenerK == string) {
                            this.addHierarchyListener((HierarchyListener)objectInputStream.readObject());
                            continue;
                        }
                        if (hierarchyBoundsListenerK == string) {
                            this.addHierarchyBoundsListener((HierarchyBoundsListener)objectInputStream.readObject());
                            continue;
                        }
                        objectInputStream.readObject();
                    }
                }
                catch (OptionalDataException optionalDataException) {
                    if (optionalDataException.eof) break block22;
                    throw optionalDataException;
                }
            }
            try {
                while (null != (object = objectInputStream.readObject())) {
                    string = ((String)object).intern();
                    if (mouseWheelListenerK == string) {
                        this.addMouseWheelListener((MouseWheelListener)objectInputStream.readObject());
                        continue;
                    }
                    objectInputStream.readObject();
                }
            }
            catch (OptionalDataException optionalDataException) {
                if (optionalDataException.eof) break block23;
                throw optionalDataException;
            }
        }
        if (this.popups != null) {
            int n2 = this.popups.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                PopupMenu popupMenu = (PopupMenu)this.popups.elementAt(i2);
                popupMenu.parent = this;
            }
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        ComponentOrientation componentOrientation2 = this.componentOrientation;
        this.componentOrientation = componentOrientation;
        this.firePropertyChange("componentOrientation", componentOrientation2, componentOrientation);
        if (this.valid) {
            this.invalidate();
        }
    }

    public ComponentOrientation getComponentOrientation() {
        return this.componentOrientation;
    }

    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation == null) {
            throw new NullPointerException();
        }
        this.setComponentOrientation(componentOrientation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean canBeFocusOwner() {
        if (!(this.isEnabled() && this.isDisplayable() && this.isVisible() && this.isFocusable())) {
            return false;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null) {
                return this.parent.canContainFocusOwner(this);
            }
        }
        return true;
    }

    Window getContainingWindow() {
        return Component.getContainingWindow(this);
    }

    static Window getContainingWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    private static native void initIDs();

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getAccessibleIndexInParent() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = -1;
            Container container = this.getParent();
            if (container != null && container instanceof Accessible) {
                Component[] componentArray = container.getComponents();
                for (int i2 = 0; i2 < componentArray.length; ++i2) {
                    if (componentArray[i2] instanceof Accessible) {
                        ++n2;
                    }
                    if (!this.equals(componentArray[i2])) continue;
                    return n2;
                }
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccessibleStateSet getAccessibleStateSet() {
        Object object = this.getTreeLock();
        synchronized (object) {
            AccessibleSelection accessibleSelection;
            AccessibleContext accessibleContext;
            Accessible accessible;
            AccessibleContext accessibleContext2;
            AccessibleStateSet accessibleStateSet = new AccessibleStateSet();
            if (this.isEnabled()) {
                accessibleStateSet.add(AccessibleState.ENABLED);
            }
            if (this.isFocusTraversable()) {
                accessibleStateSet.add(AccessibleState.FOCUSABLE);
            }
            if (this.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            }
            if (this.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            }
            if (this.isFocusOwner()) {
                accessibleStateSet.add(AccessibleState.FOCUSED);
            }
            if (this instanceof Accessible && (accessibleContext2 = ((Accessible)((Object)this)).getAccessibleContext()) != null && (accessible = accessibleContext2.getAccessibleParent()) != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                int n2 = accessibleContext2.getAccessibleIndexInParent();
                if (n2 >= 0 && accessibleSelection.isAccessibleChildSelected(n2)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
            }
            if (this instanceof JComponent && ((JComponent)this).isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            return accessibleStateSet;
        }
    }

    static {
        String string;
        focusLog = Logger.getLogger("java.awt.focus.Component");
        log = Logger.getLogger("java.awt.Component");
        focusTraversalKeyPropertyNames = new String[]{"forwardFocusTraversalKeys", "backwardFocusTraversalKeys", "upCycleFocusTraversalKeys", "downCycleFocusTraversalKeys"};
        LOCK = new AWTTreeLock();
        dbg = DebugHelper.create(Component.class);
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Component.initIDs();
        }
        isInc = (string = (String)AccessController.doPrivileged(new GetPropertyAction("awt.image.incrementaldraw"))) == null || string.equals("true");
        string = (String)AccessController.doPrivileged(new GetPropertyAction("awt.image.redrawrate"));
        incRate = string != null ? Integer.parseInt(string) : 100;
        metrics = new Hashtable();
    }

    static class AWTTreeLock {
        AWTTreeLock() {
        }
    }

    protected abstract class AccessibleAWTComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        private static final long serialVersionUID = 642321655757800191L;
        protected ComponentListener accessibleAWTComponentHandler = null;
        protected FocusListener accessibleAWTFocusHandler = null;

        protected AccessibleAWTComponent() {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleAWTComponentHandler == null) {
                this.accessibleAWTComponentHandler = new AccessibleAWTComponentHandler();
                Component.this.addComponentListener(this.accessibleAWTComponentHandler);
            }
            if (this.accessibleAWTFocusHandler == null) {
                this.accessibleAWTFocusHandler = new AccessibleAWTFocusHandler();
                Component.this.addFocusListener(this.accessibleAWTFocusHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleAWTComponentHandler != null) {
                Component.this.removeComponentListener(this.accessibleAWTComponentHandler);
                this.accessibleAWTComponentHandler = null;
            }
            if (this.accessibleAWTFocusHandler != null) {
                Component.this.removeFocusListener(this.accessibleAWTFocusHandler);
                this.accessibleAWTFocusHandler = null;
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        public String getAccessibleName() {
            return this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return Component.this.getAccessibleStateSet();
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = Component.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public int getAccessibleIndexInParent() {
            return Component.this.getAccessibleIndexInParent();
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n2) {
            return null;
        }

        public Locale getLocale() {
            return Component.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return Component.this.getBackground();
        }

        public void setBackground(Color color) {
            Component.this.setBackground(color);
        }

        public Color getForeground() {
            return Component.this.getForeground();
        }

        public void setForeground(Color color) {
            Component.this.setForeground(color);
        }

        public Cursor getCursor() {
            return Component.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            Component.this.setCursor(cursor);
        }

        public Font getFont() {
            return Component.this.getFont();
        }

        public void setFont(Font font) {
            Component.this.setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            if (font == null) {
                return null;
            }
            return Component.this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return Component.this.isEnabled();
        }

        public void setEnabled(boolean bl2) {
            boolean bl3 = Component.this.isEnabled();
            Component.this.setEnabled(bl2);
            if (bl2 != bl3 && Component.this.accessibleContext != null) {
                if (bl2) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
                } else {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
                }
            }
        }

        public boolean isVisible() {
            return Component.this.isVisible();
        }

        public void setVisible(boolean bl2) {
            boolean bl3 = Component.this.isVisible();
            Component.this.setVisible(bl2);
            if (bl2 != bl3 && Component.this.accessibleContext != null) {
                if (bl2) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                } else {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
                }
            }
        }

        public boolean isShowing() {
            return Component.this.isShowing();
        }

        public boolean contains(Point point) {
            return Component.this.contains(point);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Point getLocationOnScreen() {
            Object object = Component.this.getTreeLock();
            synchronized (object) {
                if (Component.this.isShowing()) {
                    return Component.this.getLocationOnScreen();
                }
                return null;
            }
        }

        public Point getLocation() {
            return Component.this.getLocation();
        }

        public void setLocation(Point point) {
            Component.this.setLocation(point);
        }

        public Rectangle getBounds() {
            return Component.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
            Component.this.setBounds(rectangle);
        }

        public Dimension getSize() {
            return Component.this.getSize();
        }

        public void setSize(Dimension dimension) {
            Component.this.setSize(dimension);
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return Component.this.isFocusTraversable();
        }

        public void requestFocus() {
            Component.this.requestFocus();
        }

        public void addFocusListener(FocusListener focusListener) {
            Component.this.addFocusListener(focusListener);
        }

        public void removeFocusListener(FocusListener focusListener) {
            Component.this.removeFocusListener(focusListener);
        }

        protected class AccessibleAWTComponentHandler
        implements ComponentListener {
            protected AccessibleAWTComponentHandler() {
            }

            public void componentHidden(ComponentEvent componentEvent) {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
                }
            }

            public void componentShown(ComponentEvent componentEvent) {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }
        }

        protected class AccessibleAWTFocusHandler
        implements FocusListener {
            protected AccessibleAWTFocusHandler() {
            }

            public void focusGained(FocusEvent focusEvent) {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        }
    }

    protected class BltBufferStrategy
    extends BufferStrategy {
        protected BufferCapabilities caps;
        protected VolatileImage[] backBuffers;
        protected boolean validatedContents;
        protected int width;
        protected int height;

        protected BltBufferStrategy(int n2, BufferCapabilities bufferCapabilities) {
            this.caps = bufferCapabilities;
            this.createBackBuffers(n2 - 1);
        }

        protected void createBackBuffers(int n2) {
            if (n2 == 0) {
                this.backBuffers = null;
            } else {
                this.width = Component.this.getWidth();
                this.height = Component.this.getHeight();
                this.backBuffers = new VolatileImage[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.backBuffers[i2] = Component.this.createVolatileImage(this.width, this.height);
                }
            }
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            this.revalidate();
            Image image = this.getBackBuffer();
            if (image == null) {
                return Component.this.getGraphics();
            }
            return image.getGraphics();
        }

        Image getBackBuffer() {
            if (this.backBuffers != null) {
                return this.backBuffers[this.backBuffers.length - 1];
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void show() {
            if (this.backBuffers == null) {
                return;
            }
            Graphics graphics = Component.this.getGraphics();
            try {
                for (int i2 = 0; i2 < this.backBuffers.length; ++i2) {
                    graphics.drawImage(this.backBuffers[i2], 0, 0, Component.this);
                    graphics.dispose();
                    graphics = null;
                    graphics = this.backBuffers[i2].getGraphics();
                }
            }
            finally {
                if (graphics != null) {
                    graphics.dispose();
                }
            }
        }

        protected void revalidate() {
            if (this.backBuffers == null) {
                this.validatedContents = false;
            } else if (Component.this.getWidth() != this.width || Component.this.getHeight() != this.height) {
                this.createBackBuffers(this.backBuffers.length);
                this.validatedContents = true;
            } else {
                this.validatedContents = this.backBuffers[this.backBuffers.length - 1].validate(Component.this.getGraphicsConfiguration()) == 1;
            }
        }

        public boolean contentsLost() {
            if (this.width < Component.this.getWidth() || this.height < Component.this.getHeight()) {
                return true;
            }
            return this.backBuffers[this.backBuffers.length - 1].contentsLost();
        }

        public boolean contentsRestored() {
            return this.validatedContents;
        }
    }

    protected class FlipBufferStrategy
    extends BufferStrategy {
        protected int numBuffers;
        protected BufferCapabilities caps;
        protected Image drawBuffer;
        protected VolatileImage drawVBuffer;
        protected boolean validatedContents;

        protected FlipBufferStrategy(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
            if (!(Component.this instanceof Window) && !(Component.this instanceof Canvas)) {
                throw new ClassCastException("Component must be a Canvas or Window");
            }
            this.numBuffers = n2;
            this.caps = bufferCapabilities;
            this.createBuffers(n2, bufferCapabilities);
        }

        protected void createBuffers(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
            if (n2 < 2) {
                throw new IllegalArgumentException("Number of buffers cannot be less than two");
            }
            if (Component.this.peer == null) {
                throw new IllegalStateException("Component must have a valid peer");
            }
            if (bufferCapabilities == null || !bufferCapabilities.isPageFlipping()) {
                throw new IllegalArgumentException("Page flipping capabilities must be specified");
            }
            Component.this.peer.createBuffers(n2, bufferCapabilities);
        }

        protected Image getBackBuffer() {
            if (Component.this.peer != null) {
                Image image = Component.this.peer.getBackBuffer();
                if (image instanceof VolatileImage) {
                    this.drawVBuffer = (VolatileImage)image;
                }
                this.revalidate();
                return image;
            }
            throw new IllegalStateException("Component must have a valid peer");
        }

        protected void flip(BufferCapabilities.FlipContents flipContents) {
            if (Component.this.peer == null) {
                throw new IllegalStateException("Component must have a valid peer");
            }
            Component.this.peer.flip(flipContents);
        }

        protected void destroyBuffers() {
            if (Component.this.peer == null) {
                throw new IllegalStateException("Component must have a valid peer");
            }
            Component.this.peer.destroyBuffers();
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            if (this.drawBuffer == null) {
                this.drawBuffer = this.getBackBuffer();
                if (this.drawBuffer instanceof VolatileImage) {
                    this.drawVBuffer = (VolatileImage)this.drawBuffer;
                }
            }
            this.revalidate();
            return this.drawBuffer.getGraphics();
        }

        protected void revalidate() {
            this.validatedContents = this.drawVBuffer != null ? this.drawVBuffer.validate(Component.this.getGraphicsConfiguration()) == 1 : false;
        }

        public boolean contentsLost() {
            if (this.drawVBuffer == null) {
                return false;
            }
            return this.drawVBuffer.contentsLost();
        }

        public boolean contentsRestored() {
            return this.validatedContents;
        }

        public void show() {
            this.flip(this.caps.getFlipContents());
        }
    }

    final class NativeInLightFixer
    implements ComponentListener,
    ContainerListener {
        Vector lightParents = new Vector();
        Container nativeHost;

        NativeInLightFixer() {
            this.install(Component.this.parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void install(Container container) {
            this.lightParents.clear();
            Container container2 = container;
            boolean bl2 = true;
            while (container2.peer instanceof LightweightPeer) {
                container2.addComponentListener(this);
                container2.addContainerListener(this);
                this.lightParents.addElement(container2);
                bl2 &= container2.isVisible();
                container2 = container2.parent;
            }
            this.nativeHost = container2;
            container2.addContainerListener(this);
            this.componentMoved(null);
            if (!bl2) {
                Object object = Component.this.getTreeLock();
                synchronized (object) {
                    if (Component.this.peer != null) {
                        Component.this.peer.hide();
                    }
                }
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentMoved(ComponentEvent componentEvent) {
            Object object = Component.this.getTreeLock();
            synchronized (object) {
                int n2 = Component.this.x;
                int n3 = Component.this.y;
                Container container = Component.this.parent;
                while (container != null && container.peer instanceof LightweightPeer) {
                    n2 += container.x;
                    n3 += container.y;
                    container = container.parent;
                }
                if (Component.this.peer != null) {
                    Component.this.peer.setBounds(n2, n3, Component.this.width, Component.this.height, 1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentShown(ComponentEvent componentEvent) {
            if (Component.this.isShowing()) {
                Object object = Component.this.getTreeLock();
                synchronized (object) {
                    if (Component.this.peer != null) {
                        Component.this.peer.show();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentHidden(ComponentEvent componentEvent) {
            if (Component.this.visible) {
                Object object = Component.this.getTreeLock();
                synchronized (object) {
                    if (Component.this.peer != null) {
                        Component.this.peer.hide();
                    }
                }
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component == Component.this) {
                this.removeReferences();
            } else {
                int n2 = this.lightParents.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Container container = (Container)this.lightParents.elementAt(i2);
                    if (container != component) continue;
                    this.removeReferences();
                    break;
                }
            }
        }

        void removeReferences() {
            int n2 = this.lightParents.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Container container = (Container)this.lightParents.elementAt(i2);
                container.removeComponentListener(this);
                container.removeContainerListener(this);
            }
            this.nativeHost.removeContainerListener(this);
            this.lightParents.clear();
            this.nativeHost = null;
        }
    }

    private class SingleBufferStrategy
    extends BufferStrategy {
        private BufferCapabilities caps;

        public SingleBufferStrategy(BufferCapabilities bufferCapabilities) {
            this.caps = bufferCapabilities;
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return Component.this.getGraphics();
        }

        public boolean contentsLost() {
            return false;
        }

        public boolean contentsRestored() {
            return false;
        }

        public void show() {
        }
    }
}

