/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import sun.font.CompositeFont;
import sun.font.CoreMetrics;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontLineMetrics;
import sun.font.FontManager;
import sun.font.GlyphLayout;
import sun.font.StandardGlyphVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
implements Serializable {
    private Hashtable fRequestedAttributes;
    private static final Map EMPTY_MAP;
    private static final TransformAttribute IDENT_TX_ATTRIBUTE;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    public static final int TYPE1_FONT = 1;
    protected String name;
    protected int style;
    protected int size;
    protected float pointSize;
    private transient FontPeer peer;
    private transient long pData;
    private transient Font2DHandle font2DHandle;
    private transient int superscript;
    private transient float width = 1.0f;
    private transient boolean createdFont = false;
    private transient double[] matrix;
    private transient boolean nonIdentityTx;
    private static final AffineTransform identityTx;
    private static final long serialVersionUID = -4206021311591459213L;
    private static SoftReference cacheRef;
    private static final float[] ssinfo;
    private int fontSerializedDataVersion = 1;
    private static double[] cachedMat;
    private transient SoftReference flmref;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;

    public FontPeer getPeer() {
        return this.getPeer_NoClientCode();
    }

    final FontPeer getPeer_NoClientCode() {
        if (this.peer == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.peer = toolkit.getFontPeer(this.name, this.style);
        }
        return this.peer;
    }

    private Hashtable getRequestedAttributes() {
        if (this.fRequestedAttributes == null) {
            this.fRequestedAttributes = new Hashtable(7, 0.9f);
            this.fRequestedAttributes.put(TextAttribute.TRANSFORM, IDENT_TX_ATTRIBUTE);
            this.fRequestedAttributes.put(TextAttribute.FAMILY, this.name);
            this.fRequestedAttributes.put(TextAttribute.SIZE, new Float(this.size));
            this.fRequestedAttributes.put(TextAttribute.WEIGHT, (this.style & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            this.fRequestedAttributes.put(TextAttribute.POSTURE, (this.style & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            this.fRequestedAttributes.put(TextAttribute.SUPERSCRIPT, new Integer(this.superscript));
            this.fRequestedAttributes.put(TextAttribute.WIDTH, new Float(this.width));
        }
        return this.fRequestedAttributes;
    }

    private void initializeFont(Hashtable hashtable) {
        if (hashtable != null) {
            Object v2 = hashtable.get(TextAttribute.TRANSFORM);
            if (v2 instanceof TransformAttribute) {
                this.nonIdentityTx = !((TransformAttribute)v2).isIdentity();
            } else if (v2 instanceof AffineTransform) {
                this.nonIdentityTx = !((AffineTransform)v2).isIdentity();
            }
            v2 = hashtable.get(TextAttribute.SUPERSCRIPT);
            if (v2 instanceof Integer) {
                this.superscript = (Integer)v2;
                this.nonIdentityTx |= this.superscript != 0;
            }
            if ((v2 = hashtable.get(TextAttribute.WIDTH)) instanceof Integer) {
                this.width = ((Float)v2).floatValue();
                this.nonIdentityTx |= this.width != 1.0f;
            }
        }
    }

    private Font2D getFont2D() {
        if (FontManager.usingPerAppContextComposites && this.font2DHandle != null && this.font2DHandle.font2D instanceof CompositeFont && ((CompositeFont)this.font2DHandle.font2D).isStdComposite()) {
            return FontManager.findFont2D(this.name, this.style, 2);
        }
        if (this.font2DHandle == null) {
            this.font2DHandle = FontManager.findFont2D((String)this.name, (int)this.style, (int)2).handle;
        }
        return this.font2DHandle.font2D;
    }

    public Font(String string, int n2, int n3) {
        this.name = string != null ? string : "Default";
        this.style = (n2 & 0xFFFFFFFC) == 0 ? n2 : 0;
        this.size = n3;
        this.pointSize = n3;
    }

    private Font(String string, int n2, float f2) {
        this.name = string != null ? string : "Default";
        this.style = (n2 & 0xFFFFFFFC) == 0 ? n2 : 0;
        this.size = (int)((double)f2 + 0.5);
        this.pointSize = f2;
    }

    private Font(File file, int n2, boolean bl2) throws FontFormatException {
        this.createdFont = true;
        this.font2DHandle = FontManager.createFont2D((File)file, (int)n2, (boolean)bl2).handle;
        this.name = this.font2DHandle.font2D.getFontName(Locale.getDefault());
        this.style = 0;
        this.size = 1;
        this.pointSize = 1.0f;
    }

    private Font(Map map, boolean bl2, Font2DHandle font2DHandle) {
        this.createdFont = bl2;
        if (bl2) {
            this.font2DHandle = font2DHandle;
        }
        this.initFromMap(map);
    }

    public Font(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        this.initFromMap(map);
    }

    private void initFromMap(Map map) {
        this.name = "Dialog";
        this.pointSize = 12.0f;
        this.size = 12;
        if (map != null && !((Object)map).equals(EMPTY_MAP)) {
            this.fRequestedAttributes = new Hashtable(map);
            Object v2 = map.get(TextAttribute.FAMILY);
            if (v2 != null) {
                this.name = (String)v2;
            }
            if ((v2 = map.get(TextAttribute.WEIGHT)) != null && v2.equals(TextAttribute.WEIGHT_BOLD)) {
                this.style |= 1;
            }
            if ((v2 = map.get(TextAttribute.POSTURE)) != null && v2.equals(TextAttribute.POSTURE_OBLIQUE)) {
                this.style |= 2;
            }
            if ((v2 = map.get(TextAttribute.SIZE)) != null) {
                this.pointSize = ((Float)v2).floatValue();
                this.size = (int)((double)this.pointSize + 0.5);
            }
            if ((v2 = map.get(TextAttribute.TRANSFORM)) != null) {
                if (v2 instanceof TransformAttribute) {
                    this.nonIdentityTx = !((TransformAttribute)v2).isIdentity();
                } else if (v2 instanceof AffineTransform) {
                    boolean bl2 = this.nonIdentityTx = !((AffineTransform)v2).isIdentity();
                }
            }
            if ((v2 = map.get(TextAttribute.SUPERSCRIPT)) != null && v2 instanceof Integer) {
                this.superscript = (Integer)v2;
                this.nonIdentityTx |= this.superscript != 0;
            }
            if ((v2 = map.get(TextAttribute.WIDTH)) != null && v2 instanceof Float) {
                this.width = ((Float)v2).floatValue();
                this.nonIdentityTx |= this.width != 1.0f;
            }
        }
    }

    public static Font getFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        Font font = (Font)map.get(TextAttribute.FONT);
        if (font != null) {
            return font;
        }
        return Font.get(new Key(map));
    }

    private static Font get(Key key) {
        Font font = null;
        HashMap<Key, Font> hashMap = (HashMap<Key, Font>)cacheRef.get();
        if (hashMap == null) {
            hashMap = new HashMap<Key, Font>();
            cacheRef = new SoftReference(hashMap);
        } else {
            font = (Font)hashMap.get(key);
        }
        if (font == null) {
            font = new Font(key.attrs);
            hashMap.put(key, font);
        }
        return font;
    }

    public static Font createFont(int n2, InputStream inputStream) throws FontFormatException, IOException {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("font format not recognized");
        }
        final InputStream inputStream2 = inputStream;
        Object t2 = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = null;
                try {
                    file = File.createTempFile("+~JF", ".tmp", null);
                    file.deleteOnExit();
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream2);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    int n2 = 0;
                    int n3 = 8192;
                    byte[] byArray = new byte[n3];
                    while (n2 != -1) {
                        n2 = bufferedInputStream.read(byArray, 0, n3);
                        if (n2 == -1) continue;
                        fileOutputStream.write(byArray, 0, n2);
                    }
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    return iOException;
                }
                return file;
            }
        });
        if (t2 instanceof File) {
            return new Font((File)t2, n2, true);
        }
        if (t2 instanceof IOException) {
            throw (IOException)t2;
        }
        throw new FontFormatException("Couldn't access font stream");
    }

    public static Font createFont(int n2, File file) throws FontFormatException, IOException {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("font format not recognized");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            FilePermission filePermission = new FilePermission(file.getPath(), "read");
            securityManager.checkPermission(filePermission);
        }
        if (!file.canRead()) {
            throw new IOException("Can't read " + file);
        }
        return new Font(file, n2, false);
    }

    public AffineTransform getTransform() {
        if (this.nonIdentityTx) {
            AffineTransform affineTransform = null;
            Object v2 = this.getRequestedAttributes().get(TextAttribute.TRANSFORM);
            if (v2 != null) {
                if (v2 instanceof TransformAttribute) {
                    affineTransform = ((TransformAttribute)v2).getTransform();
                } else if (v2 instanceof AffineTransform) {
                    affineTransform = new AffineTransform((AffineTransform)v2);
                }
            } else {
                affineTransform = new AffineTransform();
            }
            if (this.superscript != 0) {
                int n2;
                double d2 = 0.0;
                int n3 = 0;
                boolean bl2 = this.superscript > 0;
                int n4 = bl2 ? -1 : 1;
                int n5 = n2 = bl2 ? this.superscript : -this.superscript;
                while ((n2 & 7) > n3) {
                    int n6 = n2 & 7;
                    d2 += (double)((float)n4 * (ssinfo[n6] - ssinfo[n3]));
                    n2 >>= 3;
                    n4 = -n4;
                    n3 = n6;
                }
                double d3 = Math.pow(0.6666666666666666, n3);
                affineTransform.preConcatenate(AffineTransform.getTranslateInstance(0.0, d2 *= (double)this.pointSize));
                affineTransform.scale(d3, d3);
            }
            if (this.width != 1.0f) {
                affineTransform.scale(this.width, 1.0);
            }
            return affineTransform;
        }
        return new AffineTransform();
    }

    public String getFamily() {
        return this.getFamily_NoClientCode();
    }

    final String getFamily_NoClientCode() {
        return this.getFamily(Locale.getDefault());
    }

    public String getFamily(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("null locale doesn't mean default");
        }
        return this.getFont2D().getFamilyName(locale);
    }

    public String getPSName() {
        return this.getFont2D().getPostscriptName();
    }

    public String getName() {
        return this.name;
    }

    public String getFontName() {
        return this.getFontName(Locale.getDefault());
    }

    public String getFontName(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("null locale doesn't mean default");
        }
        return this.getFont2D().getFontName(locale);
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isTransformed() {
        return this.nonIdentityTx;
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public static Font decode(String string) {
        int n2;
        int n3;
        int n4;
        char c2;
        int n5;
        int n6;
        String string2;
        String string3;
        block18: {
            int n7;
            string3 = string;
            string2 = "";
            n6 = 12;
            n5 = 0;
            if (string == null) {
                return new Font("Dialog", n5, n6);
            }
            int n8 = string.lastIndexOf(45);
            c2 = n8 > (n7 = string.lastIndexOf(32)) ? (char)'-' : ' ';
            n4 = string.lastIndexOf(c2);
            n3 = string.lastIndexOf(c2, n4 - 1);
            n2 = string.length();
            if (n4 > 0 && n4 + 1 < n2) {
                try {
                    n6 = Integer.valueOf(string.substring(n4 + 1));
                    if (n6 <= 0) {
                        n6 = 12;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = n4;
                    n4 = n2;
                    if (string.charAt(n4 - 1) != c2) break block18;
                    --n4;
                }
            }
        }
        if (n3 >= 0 && n3 + 1 < n2) {
            string2 = string.substring(n3 + 1, n4);
            if ((string2 = string2.toLowerCase(Locale.ENGLISH)).equals("bolditalic")) {
                n5 = 3;
            } else if (string2.equals("italic")) {
                n5 = 2;
            } else if (string2.equals("bold")) {
                n5 = 1;
            } else {
                n3 = n4;
                if (string.charAt(n3 - 1) == c2) {
                    --n3;
                }
            }
            string3 = string.substring(0, n3);
        } else {
            int n9 = n2;
            if (n3 > 0) {
                n9 = n3;
            } else if (n4 > 0) {
                n9 = n4;
            }
            if (n9 > 0 && string.charAt(n9 - 1) == c2) {
                --n9;
            }
            string3 = string.substring(0, n9);
        }
        return new Font(string3, n5, n6);
    }

    public static Font getFont(String string, Font font) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.style ^ this.size;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            try {
                Font font = (Font)object;
                if (this.size == font.size && this.pointSize == font.pointSize && this.style == font.style && this.superscript == font.superscript && this.width == font.width && this.name.equals(font.name)) {
                    double[] dArray;
                    double[] dArray2 = this.getMatrix();
                    return dArray2[0] == (dArray = font.getMatrix())[0] && dArray2[1] == dArray[1] && dArray2[2] == dArray[2] && dArray2[3] == dArray[3] && dArray2[4] == dArray[4] && dArray2[5] == dArray[5];
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return this.getClass().getName() + "[family=" + this.getFamily() + ",name=" + this.name + ",style=" + string + ",size=" + this.size + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.pointSize == 0.0f) {
            this.pointSize = this.size;
        }
        this.width = 1.0f;
        this.initializeFont(this.fRequestedAttributes);
    }

    public int getNumGlyphs() {
        return this.getFont2D().getNumGlyphs();
    }

    public int getMissingGlyphCode() {
        return this.getFont2D().getMissingGlyphCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double[] getMatrix() {
        if (this.matrix != null) return this.matrix;
        double d2 = this.getSize2D();
        if (this.nonIdentityTx) {
            AffineTransform affineTransform = this.getTransform();
            affineTransform.scale(d2, d2);
            this.matrix = new double[6];
            affineTransform.getMatrix(this.matrix);
            return this.matrix;
        }
        Class<Font> clazz = Font.class;
        synchronized (Font.class) {
            double[] dArray = cachedMat;
            if (dArray == null || dArray[0] != d2) {
                dArray = new double[]{d2, 0.0, 0.0, d2, 0.0, 0.0};
                cachedMat = dArray;
            }
            this.matrix = dArray;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.matrix;
        }
    }

    public byte getBaselineFor(char c2) {
        return this.getFont2D().getBaselineFor(c2);
    }

    public Map<TextAttribute, ?> getAttributes() {
        return (Map)this.getRequestedAttributes().clone();
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        AttributedCharacterIterator.Attribute[] attributeArray = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.WEIGHT, TextAttribute.POSTURE, TextAttribute.SIZE, TextAttribute.TRANSFORM, TextAttribute.SUPERSCRIPT, TextAttribute.WIDTH};
        return attributeArray;
    }

    public Font deriveFont(int n2, float f2) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applyStyle(n2, hashtable);
        Font.applySize(f2, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(int n2, AffineTransform affineTransform) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applyStyle(n2, hashtable);
        Font.applyTransform(affineTransform, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(float f2) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applySize(f2, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(AffineTransform affineTransform) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applyTransform(affineTransform, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(int n2) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applyStyle(n2, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        if (map == null || map.size() == 0) {
            return this;
        }
        Hashtable hashtable = new Hashtable(this.getAttributes());
        AttributedCharacterIterator.Attribute[] attributeArray = this.getAvailableAttributes();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            Object obj = map.get(attributeArray[i2]);
            if (obj == null) continue;
            hashtable.put((TextAttribute)attributeArray[i2], obj);
        }
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public boolean canDisplay(char c2) {
        return this.getFont2D().canDisplay(c2);
    }

    public boolean canDisplay(int n2) {
        if (!Character.isValidCodePoint(n2)) {
            throw new IllegalArgumentException("invalid code point: " + Integer.toHexString(n2));
        }
        return this.getFont2D().canDisplay(n2);
    }

    public int canDisplayUpTo(String string) {
        return this.canDisplayUpTo(new StringCharacterIterator(string), 0, string.length());
    }

    public int canDisplayUpTo(char[] cArray, int n2, int n3) {
        while (n2 < n3 && this.canDisplay(cArray[n2])) {
            ++n2;
        }
        return n2 == n3 ? -1 : n2;
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n2, int n3) {
        int n4 = characterIterator.setIndex(n2);
        while (characterIterator.getIndex() < n3 && this.canDisplay((char)n4)) {
            n4 = characterIterator.next();
        }
        n4 = characterIterator.getIndex();
        return n4 == n3 ? -1 : n4;
    }

    public float getItalicAngle() {
        AffineTransform affineTransform = this.isTransformed() ? this.getTransform() : identityTx;
        return this.getFont2D().getItalicAngle(this, affineTransform, false, false);
    }

    public boolean hasUniformLineMetrics() {
        return false;
    }

    private FontLineMetrics defaultLineMetrics(FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = null;
        if (this.flmref == null || (fontLineMetrics = (FontLineMetrics)this.flmref.get()) == null || !fontLineMetrics.frc.equals(fontRenderContext)) {
            float[] fArray = new float[4];
            this.getFont2D().getFontMetrics(this, identityTx, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), fArray);
            float f2 = fArray[0];
            float f3 = fArray[1];
            float f4 = fArray[2];
            float f5 = 0.0f;
            if (this.superscript != 0) {
                f5 = (float)this.getTransform().getTranslateY();
                f2 -= f5;
                f3 += f5;
            }
            float f6 = f2 + f3 + f4;
            int n2 = 0;
            float[] fArray2 = new float[]{0.0f, (f3 / 2.0f - f2) / 2.0f, -f2};
            float f7 = f5 - fArray[0] / 2.5f;
            float f8 = (float)Math.log(this.pointSize / 4.0f);
            float f9 = f5 + f8 / 1.5f;
            float f10 = f8;
            float f11 = this.getItalicAngle();
            CoreMetrics coreMetrics = new CoreMetrics(f2, f3, f4, f6, n2, fArray2, f7, f8, f9, f10, f5, f11);
            fontLineMetrics = new FontLineMetrics(0, coreMetrics, fontRenderContext);
            this.flmref = new SoftReference<FontLineMetrics>(fontLineMetrics);
        }
        return (FontLineMetrics)fontLineMetrics.clone();
    }

    public LineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        fontLineMetrics.numchars = string.length();
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(String string, int n2, int n3, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n4 = n3 - n2;
        fontLineMetrics.numchars = n4 < 0 ? 0 : n4;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(char[] cArray, int n2, int n3, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n4 = n3 - n2;
        fontLineMetrics.numchars = n4 < 0 ? 0 : n4;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n2, int n3, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n4 = n3 - n2;
        fontLineMetrics.numchars = n4 < 0 ? 0 : n4;
        return fontLineMetrics;
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        char[] cArray = string.toCharArray();
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getStringBounds(String string, int n2, int n3, FontRenderContext fontRenderContext) {
        String string2 = string.substring(n2, n3);
        return this.getStringBounds(string2, fontRenderContext);
    }

    public Rectangle2D getStringBounds(char[] cArray, int n2, int n3, FontRenderContext fontRenderContext) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2);
        }
        if (n3 > cArray.length) {
            throw new IndexOutOfBoundsException("limit: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("range length: " + (n3 - n2));
        }
        boolean bl2 = true;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = cArray[i2];
            if (c2 < '\u0590' || c2 > '\u206f') continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this, cArray, n2, n3 - n2, fontRenderContext);
            return ((GlyphVector)standardGlyphVector).getLogicalBounds();
        }
        String string = new String(cArray, n2, n3 - n2);
        TextLayout textLayout = new TextLayout(string, this, fontRenderContext);
        return new Rectangle2D.Float(0.0f, -textLayout.getAscent(), textLayout.getAdvance(), textLayout.getDescent() + textLayout.getLeading());
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n2, int n3, FontRenderContext fontRenderContext) {
        int n4 = characterIterator.getBeginIndex();
        int n5 = characterIterator.getEndIndex();
        if (n2 < n4) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2);
        }
        if (n3 > n5) {
            throw new IndexOutOfBoundsException("limit: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("range length: " + (n3 - n2));
        }
        char[] cArray = new char[n3 - n2];
        characterIterator.setIndex(n2);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = characterIterator.current();
            characterIterator.next();
        }
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext fontRenderContext) {
        float[] fArray = new float[4];
        this.getFont2D().getFontMetrics(this, fontRenderContext, fArray);
        return new Rectangle2D.Float(0.0f, -fArray[0], fArray[3], fArray[0] + fArray[1] + fArray[2]);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        return new StandardGlyphVector(this, string, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        return new StandardGlyphVector(this, cArray, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return new StandardGlyphVector(this, characterIterator, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray) {
        return new StandardGlyphVector(this, nArray, fontRenderContext);
    }

    public GlyphVector layoutGlyphVector(FontRenderContext fontRenderContext, char[] cArray, int n2, int n3, int n4) {
        GlyphLayout glyphLayout = GlyphLayout.get(null);
        StandardGlyphVector standardGlyphVector = glyphLayout.layout(this, fontRenderContext, cArray, n2, n3, n4, null);
        GlyphLayout.done(glyphLayout);
        return standardGlyphVector;
    }

    private static void applyTransform(AffineTransform affineTransform, Map map) {
        if (affineTransform == null) {
            throw new IllegalArgumentException("transform must not be null");
        }
        if (affineTransform.isIdentity()) {
            map.remove(TextAttribute.TRANSFORM);
        } else {
            map.put(TextAttribute.TRANSFORM, new TransformAttribute(affineTransform));
        }
    }

    private static void applyStyle(int n2, Map map) {
        if ((n2 & 1) != 0) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            map.remove(TextAttribute.WEIGHT);
        }
        if ((n2 & 2) != 0) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            map.remove(TextAttribute.POSTURE);
        }
    }

    private static void applySize(float f2, Map map) {
        map.put(TextAttribute.SIZE, new Float(f2));
    }

    private static native void initIDs();

    private native void pDispose();

    protected void finalize() throws Throwable {
        if (this.peer != null) {
            this.pDispose();
        }
        super.finalize();
    }

    static {
        Toolkit.loadLibraries();
        Font.initIDs();
        EMPTY_MAP = new Hashtable(5, 0.9f);
        IDENT_TX_ATTRIBUTE = new TransformAttribute(new AffineTransform());
        identityTx = new AffineTransform();
        cacheRef = new SoftReference(new HashMap());
        ssinfo = new float[]{0.0f, 0.375f, 0.625f, 0.7916667f, 0.9027778f, 0.9768519f, 1.0262346f, 1.0591564f};
    }

    private static class Key {
        String family = "Dialog";
        float weight = 1.0f;
        float posture = 0.0f;
        float size = 12.0f;
        int superscript = 0;
        float width = 1.0f;
        double[] txdata = null;
        Map attrs;
        int hashCode = 0;

        Key(Map map) {
            float f2;
            this.attrs = map;
            Object v2 = map.get(TextAttribute.FAMILY);
            if (v2 != null) {
                this.family = (String)v2;
            }
            this.hashCode = this.family.hashCode();
            v2 = map.get(TextAttribute.WEIGHT);
            if (v2 != null && v2 != TextAttribute.WEIGHT_REGULAR && (f2 = ((Float)v2).floatValue()) == TextAttribute.WEIGHT_BOLD.floatValue()) {
                this.weight = f2;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.weight);
            }
            if ((v2 = map.get(TextAttribute.POSTURE)) != null && v2 != TextAttribute.POSTURE_REGULAR && (f2 = ((Float)v2).floatValue()) == TextAttribute.POSTURE_OBLIQUE.floatValue()) {
                this.posture = f2;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.posture);
            }
            if ((v2 = map.get(TextAttribute.SIZE)) != null) {
                this.size = ((Float)v2).floatValue();
                if (this.size != 12.0f) {
                    this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.size);
                }
            }
            if ((v2 = map.get(TextAttribute.TRANSFORM)) != null) {
                AffineTransform affineTransform;
                AffineTransform affineTransform2 = null;
                if (v2 instanceof TransformAttribute) {
                    TransformAttribute transformAttribute = (TransformAttribute)v2;
                    if (!transformAttribute.isIdentity()) {
                        affineTransform2 = transformAttribute.getTransform();
                    }
                } else if (v2 instanceof AffineTransform && !(affineTransform = (AffineTransform)v2).isIdentity()) {
                    affineTransform2 = affineTransform;
                }
                if (affineTransform2 != null) {
                    this.txdata = new double[6];
                    affineTransform2.getMatrix(this.txdata);
                    this.hashCode = this.hashCode << 3 ^ new Double(this.txdata[0]).hashCode();
                }
            }
            if ((v2 = map.get(TextAttribute.SUPERSCRIPT)) != null && v2 instanceof Integer) {
                this.superscript = (Integer)v2;
                this.hashCode = this.hashCode << 3 ^ this.superscript;
            }
            if ((v2 = map.get(TextAttribute.WIDTH)) != null && v2 instanceof Float) {
                this.width = ((Float)v2).floatValue();
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.width);
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            Key key = (Key)object;
            if (this.hashCode == key.hashCode && this.size == key.size && this.weight == key.weight && this.posture == key.posture && this.superscript == key.superscript && this.width == key.width && this.family.equals(key.family) && this.txdata == null == (key.txdata == null)) {
                if (this.txdata != null) {
                    for (int i2 = 0; i2 < this.txdata.length; ++i2) {
                        if (this.txdata[i2] == key.txdata[i2]) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

