/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridBagLayout
implements LayoutManager2,
Serializable {
    protected static final int MAXGRIDSIZE = 512;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected Hashtable<Component, GridBagConstraints> comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    protected GridBagLayoutInfo layoutInfo;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    private static final Integer ZERO = new Integer(0);
    transient boolean rightToLeft = false;
    static final long serialVersionUID = 8838754796412211005L;

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.comptable.put(component, (GridBagConstraints)gridBagConstraints.clone());
    }

    public GridBagConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = this.comptable.get(component);
        }
        return (GridBagConstraints)gridBagConstraints.clone();
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = this.comptable.get(component);
        }
        return gridBagConstraints;
    }

    private void removeConstraints(Component component) {
        this.comptable.remove(component);
    }

    public Point getLayoutOrigin() {
        Point point = new Point(0, 0);
        if (this.layoutInfo != null) {
            point.x = this.layoutInfo.startx;
            point.y = this.layoutInfo.starty;
        }
        return point;
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[][] nArrayArray = new int[][]{new int[this.layoutInfo.width], new int[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.minWidth, 0, nArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.minHeight, 0, nArrayArray[1], 0, this.layoutInfo.height);
        return nArrayArray;
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[][] dArrayArray = new double[][]{new double[this.layoutInfo.width], new double[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.weightX, 0, dArrayArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.weightY, 0, dArrayArray[1], 0, this.layoutInfo.height);
        return dArrayArray;
    }

    public Point location(int n2, int n3) {
        int n4;
        Point point = new Point(0, 0);
        if (this.layoutInfo == null) {
            return point;
        }
        int n5 = this.layoutInfo.startx;
        if (!this.rightToLeft) {
            for (n4 = 0; n4 < this.layoutInfo.width && (n5 += this.layoutInfo.minWidth[n4]) <= n2; ++n4) {
            }
        } else {
            for (n4 = this.layoutInfo.width - 1; n4 >= 0 && n5 <= n2; n5 += this.layoutInfo.minWidth[n4], --n4) {
            }
            ++n4;
        }
        point.x = n4;
        n5 = this.layoutInfo.starty;
        for (n4 = 0; n4 < this.layoutInfo.height && (n5 += this.layoutInfo.minHeight[n4]) <= n3; ++n4) {
        }
        point.y = n4;
        return point;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof GridBagConstraints) {
            this.setConstraints(component, (GridBagConstraints)object);
        } else if (object != null) {
            throw new IllegalArgumentException("cannot add to layout: constraints must be a GridBagConstraint");
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.removeConstraints(component);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 1);
        return this.getMinSize(container, gridBagLayoutInfo);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public void layoutContainer(Container container) {
        this.arrangeGrid(container);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected GridBagLayoutInfo getLayoutInfo(Container container, int n2) {
        return this.GetLayoutInfo(container, n2);
    }

    private static void ensureSize(ArrayList<Integer> arrayList, int n2) {
        arrayList.ensureCapacity(n2);
        while (arrayList.size() < n2) {
            arrayList.add(ZERO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GridBagLayoutInfo GetLayoutInfo(Container container, int n2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            GridBagConstraints gridBagConstraints;
            Component component;
            int n10;
            Component[] componentArray = container.getComponents();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(componentArray.length);
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(componentArray.length);
            int n11 = 0;
            int n12 = 0;
            int n13 = -1;
            int n14 = -1;
            for (n10 = 0; n10 < componentArray.length; ++n10) {
                component = componentArray[n10];
                if (!component.isVisible()) continue;
                gridBagConstraints = this.lookupConstraints(component);
                n9 = gridBagConstraints.gridx;
                n8 = gridBagConstraints.gridy;
                n7 = gridBagConstraints.gridwidth;
                if (n7 <= 0) {
                    n7 = 1;
                }
                if ((n6 = gridBagConstraints.gridheight) <= 0) {
                    n6 = 1;
                }
                if (n9 < 0 && n8 < 0) {
                    if (n14 >= 0) {
                        n8 = n14;
                    } else if (n13 >= 0) {
                        n9 = n13;
                    } else {
                        n8 = 0;
                    }
                }
                if (n9 < 0) {
                    n5 = 0;
                    GridBagLayout.ensureSize(arrayList, n8 + n6);
                    for (n4 = n8; n4 < n8 + n6; ++n4) {
                        n5 = Math.max(n5, arrayList.get(n4));
                    }
                    if ((n9 = n5 - n9 - 1) < 0) {
                        n9 = 0;
                    }
                } else if (n8 < 0) {
                    n3 = 0;
                    GridBagLayout.ensureSize(arrayList2, n9 + n7);
                    for (n4 = n9; n4 < n9 + n7; ++n4) {
                        n3 = Math.max(n3, arrayList2.get(n4));
                    }
                    if ((n8 = n3 - n8 - 1) < 0) {
                        n8 = 0;
                    }
                }
                n5 = n9 + n7;
                while (n12 < n5) {
                    ++n12;
                }
                n3 = n8 + n6;
                while (n11 < n3) {
                    ++n11;
                }
                GridBagLayout.ensureSize(arrayList2, n9 + n7);
                for (n4 = n9; n4 < n9 + n7; ++n4) {
                    arrayList2.set(n4, new Integer(n3));
                }
                GridBagLayout.ensureSize(arrayList, n8 + n6);
                for (n4 = n8; n4 < n8 + n6; ++n4) {
                    arrayList.set(n4, new Integer(n5));
                }
                Dimension dimension = n2 == 2 ? component.getPreferredSize() : component.getMinimumSize();
                gridBagConstraints.minWidth = dimension.width;
                gridBagConstraints.minHeight = dimension.height;
                if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                    n13 = -1;
                    n14 = -1;
                }
                if (gridBagConstraints.gridheight == 0 && n14 < 0) {
                    n13 = n9 + n7;
                    continue;
                }
                if (gridBagConstraints.gridwidth != 0 || n13 >= 0) continue;
                n14 = n8 + n6;
            }
            if (this.columnWidths != null && n12 < this.columnWidths.length) {
                n12 = this.columnWidths.length;
            }
            if (this.rowHeights != null && n11 < this.rowHeights.length) {
                n11 = this.rowHeights.length;
            }
            GridBagLayoutInfo gridBagLayoutInfo = new GridBagLayoutInfo(n12, n11);
            n13 = -1;
            n14 = -1;
            int[] nArray = new int[n11];
            int[] nArray2 = new int[n12];
            for (n10 = 0; n10 < componentArray.length; ++n10) {
                component = componentArray[n10];
                if (!component.isVisible()) continue;
                gridBagConstraints = this.lookupConstraints(component);
                n9 = gridBagConstraints.gridx;
                n8 = gridBagConstraints.gridy;
                n7 = gridBagConstraints.gridwidth;
                n6 = gridBagConstraints.gridheight;
                if (n9 < 0 && n8 < 0) {
                    if (n14 >= 0) {
                        n8 = n14;
                    } else if (n13 >= 0) {
                        n9 = n13;
                    } else {
                        n8 = 0;
                    }
                }
                if (n9 < 0) {
                    if (n6 <= 0 && (n6 += gridBagLayoutInfo.height - n8) < 1) {
                        n6 = 1;
                    }
                    n5 = 0;
                    for (n4 = n8; n4 < n8 + n6; ++n4) {
                        n5 = Math.max(n5, nArray[n4]);
                    }
                    if ((n9 = n5 - n9 - 1) < 0) {
                        n9 = 0;
                    }
                } else if (n8 < 0) {
                    if (n7 <= 0 && (n7 += gridBagLayoutInfo.width - n9) < 1) {
                        n7 = 1;
                    }
                    n3 = 0;
                    for (n4 = n9; n4 < n9 + n7; ++n4) {
                        n3 = Math.max(n3, nArray2[n4]);
                    }
                    if ((n8 = n3 - n8 - 1) < 0) {
                        n8 = 0;
                    }
                }
                if (n7 <= 0 && (n7 += gridBagLayoutInfo.width - n9) < 1) {
                    n7 = 1;
                }
                if (n6 <= 0 && (n6 += gridBagLayoutInfo.height - n8) < 1) {
                    n6 = 1;
                }
                n5 = n9 + n7;
                n3 = n8 + n6;
                for (n4 = n9; n4 < n9 + n7; ++n4) {
                    nArray2[n4] = n3;
                }
                for (n4 = n8; n4 < n8 + n6; ++n4) {
                    nArray[n4] = n5;
                }
                if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                    n13 = -1;
                    n14 = -1;
                }
                if (gridBagConstraints.gridheight == 0 && n14 < 0) {
                    n13 = n9 + n7;
                } else if (gridBagConstraints.gridwidth == 0 && n13 < 0) {
                    n14 = n8 + n6;
                }
                gridBagConstraints.tempX = n9;
                gridBagConstraints.tempY = n8;
                gridBagConstraints.tempWidth = n7;
                gridBagConstraints.tempHeight = n6;
            }
            if (this.columnWidths != null) {
                System.arraycopy(this.columnWidths, 0, gridBagLayoutInfo.minWidth, 0, this.columnWidths.length);
            }
            if (this.rowHeights != null) {
                System.arraycopy(this.rowHeights, 0, gridBagLayoutInfo.minHeight, 0, this.rowHeights.length);
            }
            if (this.columnWeights != null) {
                System.arraycopy(this.columnWeights, 0, gridBagLayoutInfo.weightX, 0, Math.min(gridBagLayoutInfo.weightX.length, this.columnWeights.length));
            }
            if (this.rowWeights != null) {
                System.arraycopy(this.rowWeights, 0, gridBagLayoutInfo.weightY, 0, Math.min(gridBagLayoutInfo.weightY.length, this.rowWeights.length));
            }
            int n15 = Integer.MAX_VALUE;
            n4 = 1;
            while (n4 != Integer.MAX_VALUE) {
                for (n10 = 0; n10 < componentArray.length; ++n10) {
                    int n16;
                    double d2;
                    double d3;
                    int n17;
                    double d4;
                    component = componentArray[n10];
                    if (!component.isVisible()) continue;
                    gridBagConstraints = this.lookupConstraints(component);
                    if (gridBagConstraints.tempWidth == n4) {
                        n5 = gridBagConstraints.tempX + gridBagConstraints.tempWidth;
                        d4 = gridBagConstraints.weightx;
                        for (n17 = gridBagConstraints.tempX; n17 < n5; ++n17) {
                            d4 -= gridBagLayoutInfo.weightX[n17];
                        }
                        if (d4 > 0.0) {
                            d3 = 0.0;
                            for (n17 = gridBagConstraints.tempX; n17 < n5; ++n17) {
                                d3 += gridBagLayoutInfo.weightX[n17];
                            }
                            n17 = gridBagConstraints.tempX;
                            while (d3 > 0.0 && n17 < n5) {
                                d2 = gridBagLayoutInfo.weightX[n17];
                                double d5 = d2 * d4 / d3;
                                int n18 = n17++;
                                gridBagLayoutInfo.weightX[n18] = gridBagLayoutInfo.weightX[n18] + d5;
                                d4 -= d5;
                                d3 -= d2;
                            }
                            int n19 = n5 - 1;
                            gridBagLayoutInfo.weightX[n19] = gridBagLayoutInfo.weightX[n19] + d4;
                        }
                        n16 = gridBagConstraints.minWidth + gridBagConstraints.ipadx + gridBagConstraints.insets.left + gridBagConstraints.insets.right;
                        for (n17 = gridBagConstraints.tempX; n17 < n5; ++n17) {
                            n16 -= gridBagLayoutInfo.minWidth[n17];
                        }
                        if (n16 > 0) {
                            d3 = 0.0;
                            for (n17 = gridBagConstraints.tempX; n17 < n5; ++n17) {
                                d3 += gridBagLayoutInfo.weightX[n17];
                            }
                            n17 = gridBagConstraints.tempX;
                            while (d3 > 0.0 && n17 < n5) {
                                d2 = gridBagLayoutInfo.weightX[n17];
                                int n20 = (int)(d2 * (double)n16 / d3);
                                int n21 = n17++;
                                gridBagLayoutInfo.minWidth[n21] = gridBagLayoutInfo.minWidth[n21] + n20;
                                n16 -= n20;
                                d3 -= d2;
                            }
                            int n22 = n5 - 1;
                            gridBagLayoutInfo.minWidth[n22] = gridBagLayoutInfo.minWidth[n22] + n16;
                        }
                    } else if (gridBagConstraints.tempWidth > n4 && gridBagConstraints.tempWidth < n15) {
                        n15 = gridBagConstraints.tempWidth;
                    }
                    if (gridBagConstraints.tempHeight == n4) {
                        n3 = gridBagConstraints.tempY + gridBagConstraints.tempHeight;
                        d4 = gridBagConstraints.weighty;
                        for (n17 = gridBagConstraints.tempY; n17 < n3; ++n17) {
                            d4 -= gridBagLayoutInfo.weightY[n17];
                        }
                        if (d4 > 0.0) {
                            d3 = 0.0;
                            for (n17 = gridBagConstraints.tempY; n17 < n3; ++n17) {
                                d3 += gridBagLayoutInfo.weightY[n17];
                            }
                            n17 = gridBagConstraints.tempY;
                            while (d3 > 0.0 && n17 < n3) {
                                d2 = gridBagLayoutInfo.weightY[n17];
                                double d6 = d2 * d4 / d3;
                                int n23 = n17++;
                                gridBagLayoutInfo.weightY[n23] = gridBagLayoutInfo.weightY[n23] + d6;
                                d4 -= d6;
                                d3 -= d2;
                            }
                            int n24 = n3 - 1;
                            gridBagLayoutInfo.weightY[n24] = gridBagLayoutInfo.weightY[n24] + d4;
                        }
                        n16 = gridBagConstraints.minHeight + gridBagConstraints.ipady + gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
                        for (n17 = gridBagConstraints.tempY; n17 < n3; ++n17) {
                            n16 -= gridBagLayoutInfo.minHeight[n17];
                        }
                        if (n16 <= 0) continue;
                        d3 = 0.0;
                        for (n17 = gridBagConstraints.tempY; n17 < n3; ++n17) {
                            d3 += gridBagLayoutInfo.weightY[n17];
                        }
                        n17 = gridBagConstraints.tempY;
                        while (d3 > 0.0 && n17 < n3) {
                            d2 = gridBagLayoutInfo.weightY[n17];
                            int n25 = (int)(d2 * (double)n16 / d3);
                            int n26 = n17++;
                            gridBagLayoutInfo.minHeight[n26] = gridBagLayoutInfo.minHeight[n26] + n25;
                            n16 -= n25;
                            d3 -= d2;
                        }
                        int n27 = n3 - 1;
                        gridBagLayoutInfo.minHeight[n27] = gridBagLayoutInfo.minHeight[n27] + n16;
                        continue;
                    }
                    if (gridBagConstraints.tempHeight <= n4 || gridBagConstraints.tempHeight >= n15) continue;
                    n15 = gridBagConstraints.tempHeight;
                }
                n4 = n15;
                n15 = Integer.MAX_VALUE;
            }
            return gridBagLayoutInfo;
        }
    }

    protected void adjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        this.AdjustForGravity(gridBagConstraints, rectangle);
    }

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        rectangle.x = !this.rightToLeft ? (rectangle.x += gridBagConstraints.insets.left) : (rectangle.x -= rectangle.width - gridBagConstraints.insets.right);
        rectangle.width -= gridBagConstraints.insets.left + gridBagConstraints.insets.right;
        rectangle.y += gridBagConstraints.insets.top;
        rectangle.height -= gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
        int n2 = 0;
        if (gridBagConstraints.fill != 2 && gridBagConstraints.fill != 1 && rectangle.width > gridBagConstraints.minWidth + gridBagConstraints.ipadx) {
            n2 = rectangle.width - (gridBagConstraints.minWidth + gridBagConstraints.ipadx);
            rectangle.width = gridBagConstraints.minWidth + gridBagConstraints.ipadx;
        }
        int n3 = 0;
        if (gridBagConstraints.fill != 3 && gridBagConstraints.fill != 1 && rectangle.height > gridBagConstraints.minHeight + gridBagConstraints.ipady) {
            n3 = rectangle.height - (gridBagConstraints.minHeight + gridBagConstraints.ipady);
            rectangle.height = gridBagConstraints.minHeight + gridBagConstraints.ipady;
        }
        switch (gridBagConstraints.anchor) {
            case 10: {
                rectangle.x += n2 / 2;
                rectangle.y += n3 / 2;
                break;
            }
            case 11: 
            case 19: {
                rectangle.x += n2 / 2;
                break;
            }
            case 12: {
                rectangle.x += n2;
                break;
            }
            case 13: {
                rectangle.x += n2;
                rectangle.y += n3 / 2;
                break;
            }
            case 14: {
                rectangle.x += n2;
                rectangle.y += n3;
                break;
            }
            case 15: 
            case 20: {
                rectangle.x += n2 / 2;
                rectangle.y += n3;
                break;
            }
            case 16: {
                rectangle.y += n3;
                break;
            }
            case 17: {
                rectangle.y += n3 / 2;
                break;
            }
            case 18: {
                break;
            }
            case 21: {
                if (this.rightToLeft) {
                    rectangle.x += n2;
                }
                rectangle.y += n3 / 2;
                break;
            }
            case 22: {
                if (!this.rightToLeft) {
                    rectangle.x += n2;
                }
                rectangle.y += n3 / 2;
                break;
            }
            case 23: {
                if (!this.rightToLeft) break;
                rectangle.x += n2;
                break;
            }
            case 24: {
                if (this.rightToLeft) break;
                rectangle.x += n2;
                break;
            }
            case 25: {
                if (this.rightToLeft) {
                    rectangle.x += n2;
                }
                rectangle.y += n3;
                break;
            }
            case 26: {
                if (!this.rightToLeft) {
                    rectangle.x += n2;
                }
                rectangle.y += n3;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
        }
    }

    protected Dimension getMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        return this.GetMinSize(container, gridBagLayoutInfo);
    }

    protected Dimension GetMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        int n2;
        Dimension dimension = new Dimension();
        Insets insets = container.getInsets();
        int n3 = 0;
        for (n2 = 0; n2 < gridBagLayoutInfo.width; ++n2) {
            n3 += gridBagLayoutInfo.minWidth[n2];
        }
        dimension.width = n3 + insets.left + insets.right;
        n3 = 0;
        for (n2 = 0; n2 < gridBagLayoutInfo.height; ++n2) {
            n3 += gridBagLayoutInfo.minHeight[n2];
        }
        dimension.height = n3 + insets.top + insets.bottom;
        return dimension;
    }

    protected void arrangeGrid(Container container) {
        this.ArrangeGrid(container);
    }

    protected void ArrangeGrid(Container container) {
        int n2;
        int n3;
        double d2;
        Insets insets = container.getInsets();
        Component[] componentArray = container.getComponents();
        Rectangle rectangle = new Rectangle();
        boolean bl2 = this.rightToLeft = !container.getComponentOrientation().isLeftToRight();
        if (!(componentArray.length != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.getLayoutInfo(container, 2);
        Dimension dimension = this.getMinSize(container, gridBagLayoutInfo);
        if (container.width < dimension.width || container.height < dimension.height) {
            gridBagLayoutInfo = this.getLayoutInfo(container, 1);
            dimension = this.getMinSize(container, gridBagLayoutInfo);
        }
        this.layoutInfo = gridBagLayoutInfo;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        int n4 = container.width - rectangle.width;
        if (n4 != 0) {
            d2 = 0.0;
            for (n3 = 0; n3 < gridBagLayoutInfo.width; ++n3) {
                d2 += gridBagLayoutInfo.weightX[n3];
            }
            if (d2 > 0.0) {
                for (n3 = 0; n3 < gridBagLayoutInfo.width; ++n3) {
                    n2 = (int)((double)n4 * gridBagLayoutInfo.weightX[n3] / d2);
                    int n5 = n3;
                    gridBagLayoutInfo.minWidth[n5] = gridBagLayoutInfo.minWidth[n5] + n2;
                    rectangle.width += n2;
                    if (gridBagLayoutInfo.minWidth[n3] >= 0) continue;
                    rectangle.width -= gridBagLayoutInfo.minWidth[n3];
                    gridBagLayoutInfo.minWidth[n3] = 0;
                }
            }
            n4 = container.width - rectangle.width;
        } else {
            n4 = 0;
        }
        int n6 = container.height - rectangle.height;
        if (n6 != 0) {
            d2 = 0.0;
            for (n3 = 0; n3 < gridBagLayoutInfo.height; ++n3) {
                d2 += gridBagLayoutInfo.weightY[n3];
            }
            if (d2 > 0.0) {
                for (n3 = 0; n3 < gridBagLayoutInfo.height; ++n3) {
                    n2 = (int)((double)n6 * gridBagLayoutInfo.weightY[n3] / d2);
                    int n7 = n3;
                    gridBagLayoutInfo.minHeight[n7] = gridBagLayoutInfo.minHeight[n7] + n2;
                    rectangle.height += n2;
                    if (gridBagLayoutInfo.minHeight[n3] >= 0) continue;
                    rectangle.height -= gridBagLayoutInfo.minHeight[n3];
                    gridBagLayoutInfo.minHeight[n3] = 0;
                }
            }
            n6 = container.height - rectangle.height;
        } else {
            n6 = 0;
        }
        gridBagLayoutInfo.startx = n4 / 2 + insets.left;
        gridBagLayoutInfo.starty = n6 / 2 + insets.top;
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Component component = componentArray[i2];
            if (!component.isVisible()) continue;
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            if (!this.rightToLeft) {
                rectangle.x = gridBagLayoutInfo.startx;
                for (n3 = 0; n3 < gridBagConstraints.tempX; ++n3) {
                    rectangle.x += gridBagLayoutInfo.minWidth[n3];
                }
            } else {
                rectangle.x = container.width - (n4 / 2 + insets.right);
                for (n3 = 0; n3 < gridBagConstraints.tempX; ++n3) {
                    rectangle.x -= gridBagLayoutInfo.minWidth[n3];
                }
            }
            rectangle.y = gridBagLayoutInfo.starty;
            for (n3 = 0; n3 < gridBagConstraints.tempY; ++n3) {
                rectangle.y += gridBagLayoutInfo.minHeight[n3];
            }
            rectangle.width = 0;
            for (n3 = gridBagConstraints.tempX; n3 < gridBagConstraints.tempX + gridBagConstraints.tempWidth; ++n3) {
                rectangle.width += gridBagLayoutInfo.minWidth[n3];
            }
            rectangle.height = 0;
            for (n3 = gridBagConstraints.tempY; n3 < gridBagConstraints.tempY + gridBagConstraints.tempHeight; ++n3) {
                rectangle.height += gridBagLayoutInfo.minHeight[n3];
            }
            this.adjustForGravity(gridBagConstraints, rectangle);
            if (rectangle.x < 0) {
                rectangle.width += rectangle.x;
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.height += rectangle.y;
                rectangle.y = 0;
            }
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                component.setBounds(0, 0, 0, 0);
                continue;
            }
            if (component.x == rectangle.x && component.y == rectangle.y && component.width == rectangle.width && component.height == rectangle.height) continue;
            component.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

