/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class CharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;

    public CharArrayWriter() {
        this(32);
    }

    public CharArrayWriter(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.buf = new char[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n2) {
        Object object = this.lock;
        synchronized (object) {
            int n3 = this.count + 1;
            if (n3 > this.buf.length) {
                char[] cArray = new char[Math.max(this.buf.length << 1, n3)];
                System.arraycopy(this.buf, 0, cArray, 0, this.count);
                this.buf = cArray;
            }
            this.buf[this.count] = (char)n2;
            this.count = n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n2, int n3) {
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            int n4 = this.count + n3;
            if (n4 > this.buf.length) {
                char[] cArray2 = new char[Math.max(this.buf.length << 1, n4)];
                System.arraycopy(this.buf, 0, cArray2, 0, this.count);
                this.buf = cArray2;
            }
            System.arraycopy(cArray, n2, this.buf, this.count, n3);
            this.count = n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n2, int n3) {
        Object object = this.lock;
        synchronized (object) {
            int n4 = this.count + n3;
            if (n4 > this.buf.length) {
                char[] cArray = new char[Math.max(this.buf.length << 1, n4)];
                System.arraycopy(this.buf, 0, cArray, 0, this.count);
                this.buf = cArray;
            }
            string.getChars(n2, n2 + n3, this.buf, this.count);
            this.count = n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            writer.write(this.buf, 0, this.count);
        }
    }

    public CharArrayWriter append(CharSequence charSequence) {
        String string = charSequence == null ? "null" : ((Object)charSequence).toString();
        this.write(string, 0, string.length());
        return this;
    }

    public CharArrayWriter append(char c2) {
        this.write(c2);
        return this;
    }

    public void reset() {
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] toCharArray() {
        Object object = this.lock;
        synchronized (object) {
            char[] cArray = new char[this.count];
            System.arraycopy(this.buf, 0, cArray, 0, this.count);
            return cArray;
        }
    }

    public int size() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return new String(this.buf, 0, this.count);
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

