/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    private byte[] bytearr = new byte[80];
    private char[] chararr = new char[80];
    private byte[] readBuffer = new byte[8];
    private char[] lineBuffer;

    public DataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public final int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.in.read(byArray, n2, n3);
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = this.in.read(byArray, n2 + i2, n3 - i2);
            if (n4 >= 0) continue;
            throw new EOFException();
        }
    }

    public final int skipBytes(int n2) throws IOException {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n2 && (n4 = (int)this.in.skip(n2 - n3)) > 0; n3 += n4) {
        }
        return n3;
    }

    public final boolean readBoolean() throws IOException {
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    public final byte readByte() throws IOException {
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public final int readUnsignedByte() throws IOException {
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public final short readShort() throws IOException {
        int n2;
        int n3 = this.in.read();
        if ((n3 | (n2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n3 << 8) + (n2 << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int n2;
        int n3 = this.in.read();
        if ((n3 | (n2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + (n2 << 0);
    }

    public final char readChar() throws IOException {
        int n2;
        int n3 = this.in.read();
        if ((n3 | (n2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 8) + (n2 << 0));
    }

    public final int readInt() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.in.read();
        if ((n5 | (n4 = this.in.read()) | (n3 = this.in.read()) | (n2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
    }

    public final long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        int n2;
        char[] cArray = this.lineBuffer;
        if (cArray == null) {
            cArray = this.lineBuffer = new char[128];
        }
        int n3 = cArray.length;
        int n4 = 0;
        block4: while (true) {
            n2 = this.in.read();
            switch (n2) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int n5 = this.in.read();
                    if (n5 == 10 || n5 == -1) break block4;
                    if (!(this.in instanceof PushbackInputStream)) {
                        this.in = new PushbackInputStream(this.in);
                    }
                    ((PushbackInputStream)this.in).unread(n5);
                    break block4;
                }
                default: {
                    if (--n3 < 0) {
                        cArray = new char[n4 + 128];
                        n3 = cArray.length - n4 - 1;
                        System.arraycopy(this.lineBuffer, 0, cArray, 0, n4);
                        this.lineBuffer = cArray;
                    }
                    cArray[n4++] = (char)n2;
                    continue block4;
                }
            }
            break;
        }
        if (n2 == -1 && n4 == 0) {
            return null;
        }
        return String.copyValueOf(cArray, 0, n4);
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        int n2;
        int n3;
        int n4 = dataInput.readUnsignedShort();
        byte[] byArray = null;
        char[] cArray = null;
        if (dataInput instanceof DataInputStream) {
            DataInputStream dataInputStream = (DataInputStream)dataInput;
            if (dataInputStream.bytearr.length < n4) {
                dataInputStream.bytearr = new byte[n4 * 2];
                dataInputStream.chararr = new char[n4 * 2];
            }
            cArray = dataInputStream.chararr;
            byArray = dataInputStream.bytearr;
        } else {
            byArray = new byte[n4];
            cArray = new char[n4];
        }
        int n5 = 0;
        dataInput.readFully(byArray, 0, n4);
        for (n3 = 0; n3 < n4 && (n2 = byArray[n3] & 0xFF) <= 127; ++n3) {
            cArray[n5++] = (char)n2;
        }
        block6: while (n3 < n4) {
            int n6 = byArray[n3] & 0xFF;
            switch (n6 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n3;
                    cArray[n5++] = (char)n6;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((n3 += 2) > n4) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n3 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + n3);
                    }
                    cArray[n5++] = (char)((n6 & 0x1F) << 6 | by & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((n3 += 3) > n4) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte by = byArray[n3 - 2];
                    byte by2 = byArray[n3 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (n3 - 1));
                    }
                    cArray[n5++] = (char)((n6 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + n3);
        }
        return new String(cArray, 0, n5);
    }
}

