/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.util.Formatter;
import java.util.Locale;
import sun.security.action.GetPropertyAction;

public class PrintWriter
extends Writer {
    protected Writer out;
    private boolean autoFlush = false;
    private boolean trouble = false;
    private Formatter formatter;
    private String lineSeparator;

    public PrintWriter(Writer writer) {
        this(writer, false);
    }

    public PrintWriter(Writer writer, boolean bl2) {
        super(writer);
        this.out = writer;
        this.autoFlush = bl2;
        this.lineSeparator = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public PrintWriter(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintWriter(OutputStream outputStream, boolean bl2) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), bl2);
    }

    public PrintWriter(String string) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string))), false);
    }

    public PrintWriter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2)), false);
    }

    public PrintWriter(File file) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))), false);
    }

    public PrintWriter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string)), false);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    return;
                }
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
        try {
            throw new IOException();
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n2) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(n2);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n2, int n3) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(cArray, n2, n3);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n2, int n3) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(string, n2, n3);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(this.lineSeparator);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
    }

    public void print(boolean bl2) {
        this.write(bl2 ? "true" : "false");
    }

    public void print(char c2) {
        this.write(c2);
    }

    public void print(int n2) {
        this.write(String.valueOf(n2));
    }

    public void print(long l2) {
        this.write(String.valueOf(l2));
    }

    public void print(float f2) {
        this.write(String.valueOf(f2));
    }

    public void print(double d2) {
        this.write(String.valueOf(d2));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(String.valueOf(object));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(bl2);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(c2);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(n2);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(l2);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(f2);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d2) {
        Object object = this.lock;
        synchronized (object) {
            this.print(d2);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        Object object = this.lock;
        synchronized (object) {
            this.print(cArray);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        Object object = this.lock;
        synchronized (object) {
            this.print(string);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            this.print(object);
            this.println();
        }
    }

    public PrintWriter printf(String string, Object ... objectArray) {
        return this.format(string, objectArray);
    }

    public PrintWriter printf(Locale locale, String string, Object ... objectArray) {
        return this.format(locale, string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter format(String string, Object ... objectArray) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.formatter == null || this.formatter.locale() != Locale.getDefault()) {
                    this.formatter = new Formatter(this);
                }
                this.formatter.format(Locale.getDefault(), string, objectArray);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter format(Locale locale, String string, Object ... objectArray) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.formatter == null || this.formatter.locale() != locale) {
                    this.formatter = new Formatter(this, locale);
                }
                this.formatter.format(locale, string, objectArray);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.trouble = true;
        }
        return this;
    }

    public PrintWriter append(CharSequence charSequence) {
        if (charSequence == null) {
            this.write("null");
        } else {
            this.write(((Object)charSequence).toString());
        }
        return this;
    }

    public PrintWriter append(char c2) {
        this.write(c2);
        return this;
    }
}

