/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;
import sun.misc.FpUtils;

public strictfp final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static Random randomNumberGenerator;
    private static long negativeZeroFloatBits;
    private static long negativeZeroDoubleBits;

    private Math() {
    }

    public static double sin(double d2) {
        return StrictMath.sin(d2);
    }

    public static double cos(double d2) {
        return StrictMath.cos(d2);
    }

    public static double tan(double d2) {
        return StrictMath.tan(d2);
    }

    public static double asin(double d2) {
        return StrictMath.asin(d2);
    }

    public static double acos(double d2) {
        return StrictMath.acos(d2);
    }

    public static double atan(double d2) {
        return StrictMath.atan(d2);
    }

    public static double toRadians(double d2) {
        return d2 / 180.0 * Math.PI;
    }

    public static double toDegrees(double d2) {
        return d2 * 180.0 / Math.PI;
    }

    public static double exp(double d2) {
        return StrictMath.exp(d2);
    }

    public static double log(double d2) {
        return StrictMath.log(d2);
    }

    public static double log10(double d2) {
        return StrictMath.log10(d2);
    }

    public static double sqrt(double d2) {
        return StrictMath.sqrt(d2);
    }

    public static double cbrt(double d2) {
        return StrictMath.cbrt(d2);
    }

    public static double IEEEremainder(double d2, double d3) {
        return StrictMath.IEEEremainder(d2, d3);
    }

    public static double ceil(double d2) {
        return StrictMath.ceil(d2);
    }

    public static double floor(double d2) {
        return StrictMath.floor(d2);
    }

    public static double rint(double d2) {
        return StrictMath.rint(d2);
    }

    public static double atan2(double d2, double d3) {
        return StrictMath.atan2(d2, d3);
    }

    public static double pow(double d2, double d3) {
        return StrictMath.pow(d2, d3);
    }

    public static int round(float f2) {
        return (int)Math.floor(f2 + 0.5f);
    }

    public static long round(double d2) {
        return (long)Math.floor(d2 + 0.5);
    }

    private static synchronized void initRNG() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
    }

    public static double random() {
        if (randomNumberGenerator == null) {
            Math.initRNG();
        }
        return randomNumberGenerator.nextDouble();
    }

    public static int abs(int n2) {
        return n2 < 0 ? -n2 : n2;
    }

    public static long abs(long l2) {
        return l2 < 0L ? -l2 : l2;
    }

    public static float abs(float f2) {
        return f2 <= 0.0f ? 0.0f - f2 : f2;
    }

    public static double abs(double d2) {
        return d2 <= 0.0 ? 0.0 - d2 : d2;
    }

    public static int max(int n2, int n3) {
        return n2 >= n3 ? n2 : n3;
    }

    public static long max(long l2, long l3) {
        return l2 >= l3 ? l2 : l3;
    }

    public static float max(float f2, float f3) {
        if (f2 != f2) {
            return f2;
        }
        if (f2 == 0.0f && f3 == 0.0f && (long)Float.floatToIntBits(f2) == negativeZeroFloatBits) {
            return f3;
        }
        return f2 >= f3 ? f2 : f3;
    }

    public static double max(double d2, double d3) {
        if (d2 != d2) {
            return d2;
        }
        if (d2 == 0.0 && d3 == 0.0 && Double.doubleToLongBits(d2) == negativeZeroDoubleBits) {
            return d3;
        }
        return d2 >= d3 ? d2 : d3;
    }

    public static int min(int n2, int n3) {
        return n2 <= n3 ? n2 : n3;
    }

    public static long min(long l2, long l3) {
        return l2 <= l3 ? l2 : l3;
    }

    public static float min(float f2, float f3) {
        if (f2 != f2) {
            return f2;
        }
        if (f2 == 0.0f && f3 == 0.0f && (long)Float.floatToIntBits(f3) == negativeZeroFloatBits) {
            return f3;
        }
        return f2 <= f3 ? f2 : f3;
    }

    public static double min(double d2, double d3) {
        if (d2 != d2) {
            return d2;
        }
        if (d2 == 0.0 && d3 == 0.0 && Double.doubleToLongBits(d3) == negativeZeroDoubleBits) {
            return d3;
        }
        return d2 <= d3 ? d2 : d3;
    }

    public static double ulp(double d2) {
        return FpUtils.ulp(d2);
    }

    public static float ulp(float f2) {
        return FpUtils.ulp(f2);
    }

    public static double signum(double d2) {
        return FpUtils.signum(d2);
    }

    public static float signum(float f2) {
        return FpUtils.signum(f2);
    }

    public static double sinh(double d2) {
        return StrictMath.sinh(d2);
    }

    public static double cosh(double d2) {
        return StrictMath.cosh(d2);
    }

    public static double tanh(double d2) {
        return StrictMath.tanh(d2);
    }

    public static double hypot(double d2, double d3) {
        return StrictMath.hypot(d2, d3);
    }

    public static double expm1(double d2) {
        return StrictMath.expm1(d2);
    }

    public static double log1p(double d2) {
        return StrictMath.log1p(d2);
    }

    static {
        negativeZeroFloatBits = Float.floatToIntBits(-0.0f);
        negativeZeroDoubleBits = Double.doubleToLongBits(-0.0);
    }
}

