/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.misc.SoftCache;
import sun.misc.VM;
import sun.nio.ch.Interruptible;
import sun.security.util.SecurityConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thread
implements Runnable {
    private char[] name;
    private int priority;
    private Thread threadQ;
    private long eetop;
    private boolean started;
    private boolean single_step;
    private boolean daemon = false;
    private boolean stillborn = false;
    private Runnable target;
    private ThreadGroup group;
    private ClassLoader contextClassLoader;
    private AccessControlContext inheritedAccessControlContext;
    private static int threadInitNumber;
    ThreadLocal.ThreadLocalMap threadLocals = null;
    ThreadLocal.ThreadLocalMap inheritableThreadLocals = null;
    private long stackSize;
    private long tid;
    private static long threadSeqNumber;
    private int threadStatus = 0;
    private volatile Interruptible blocker;
    private Object blockerLock = new Object();
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static final StackTraceElement[] EMPTY_STACK_TRACE;
    private static final RuntimePermission SUBCLASS_IMPLEMENTATION_PERMISSION;
    private static final SoftCache subclassAudits;
    private volatile UncaughtExceptionHandler uncaughtExceptionHandler;
    private static volatile UncaughtExceptionHandler defaultUncaughtExceptionHandler;

    private static native void registerNatives();

    private static synchronized int nextThreadNum() {
        return threadInitNumber++;
    }

    private static synchronized long nextThreadID() {
        return ++threadSeqNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockedOn(Interruptible interruptible) {
        Object object = this.blockerLock;
        synchronized (object) {
            this.blocker = interruptible;
        }
    }

    public static native Thread currentThread();

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    public static void sleep(long l2, int n2) throws InterruptedException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n2 < 0 || n2 > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n2 >= 500000 || n2 != 0 && l2 == 0L) {
            ++l2;
        }
        Thread.sleep(l2);
    }

    private void init(ThreadGroup threadGroup, Runnable runnable, String string, long l2) {
        Thread thread = Thread.currentThread();
        SecurityManager securityManager = System.getSecurityManager();
        if (threadGroup == null) {
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.getThreadGroup();
            }
        }
        threadGroup.checkAccess();
        if (securityManager != null && Thread.isCCLOverridden(this.getClass())) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        threadGroup.addUnstarted();
        this.group = threadGroup;
        this.daemon = thread.isDaemon();
        this.priority = thread.getPriority();
        this.name = string.toCharArray();
        this.contextClassLoader = securityManager == null || Thread.isCCLOverridden(thread.getClass()) ? thread.getContextClassLoader() : thread.contextClassLoader;
        this.inheritedAccessControlContext = AccessController.getContext();
        this.target = runnable;
        this.setPriority(this.priority);
        if (thread.inheritableThreadLocals != null) {
            this.inheritableThreadLocals = ThreadLocal.createInheritedMap(thread.inheritableThreadLocals);
        }
        this.stackSize = l2;
        this.tid = Thread.nextThreadID();
    }

    public Thread() {
        this.init(null, null, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(Runnable runnable) {
        this.init(null, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this.init(threadGroup, runnable, "Thread-" + Thread.nextThreadNum(), 0L);
    }

    public Thread(String string) {
        this.init(null, null, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this.init(threadGroup, null, string, 0L);
    }

    public Thread(Runnable runnable, String string) {
        this.init(null, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this.init(threadGroup, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l2) {
        this.init(threadGroup, runnable, string, l2);
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalThreadStateException();
        }
        this.started = true;
        this.group.add(this);
        this.start0();
    }

    private native void start0();

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    private void exit() {
        if (this.group != null) {
            this.group.remove(this);
            this.group = null;
        }
        this.target = null;
        this.threadLocals = null;
        this.inheritableThreadLocals = null;
        this.inheritedAccessControlContext = null;
        this.blocker = null;
        this.uncaughtExceptionHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Thread thread = this;
        synchronized (thread) {
            if (!this.isAlive()) {
                return;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                this.checkAccess();
                if (this != Thread.currentThread()) {
                    securityManager.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
                }
            }
            this.resume();
            this.stop0(new ThreadDeath());
        }
    }

    public final synchronized void stop(Throwable throwable) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.checkAccess();
            if (this != Thread.currentThread() || !(throwable instanceof ThreadDeath)) {
                securityManager.checkPermission(SecurityConstants.STOP_THREAD_PERMISSION);
            }
        }
        this.resume();
        this.stop0(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (this != Thread.currentThread()) {
            this.checkAccess();
        }
        Object object = this.blockerLock;
        synchronized (object) {
            Interruptible interruptible = this.blocker;
            if (interruptible != null) {
                this.interrupt0();
                interruptible.interrupt();
                return;
            }
        }
        this.interrupt0();
    }

    public static boolean interrupted() {
        return Thread.currentThread().isInterrupted(true);
    }

    public boolean isInterrupted() {
        return this.isInterrupted(false);
    }

    private native boolean isInterrupted(boolean var1);

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public final native boolean isAlive();

    public final void suspend() {
        this.checkAccess();
        this.suspend0();
    }

    public final void resume() {
        this.checkAccess();
        this.resume0();
    }

    public final void setPriority(int n2) {
        this.checkAccess();
        if (n2 > 10 || n2 < 1) {
            throw new IllegalArgumentException();
        }
        if (n2 > this.group.getMaxPriority()) {
            n2 = this.group.getMaxPriority();
        }
        this.priority = n2;
        this.setPriority0(this.priority);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setName(String string) {
        this.checkAccess();
        this.name = string.toCharArray();
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().getThreadGroup().enumerate(threadArray);
    }

    public native int countStackFrames();

    public final synchronized void join(long l2) throws InterruptedException {
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        if (l2 < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (l2 == 0L) {
            while (this.isAlive()) {
                this.wait(0L);
            }
        } else {
            long l5;
            while (this.isAlive() && (l5 = l2 - l4) > 0L) {
                this.wait(l5);
                l4 = System.currentTimeMillis() - l3;
            }
        }
    }

    public final synchronized void join(long l2, int n2) throws InterruptedException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        if (n2 < 0 || n2 > 999999) {
            throw new IllegalArgumentException("nanosecond timeout value out of range");
        }
        if (n2 >= 500000 || n2 != 0 && l2 == 0L) {
            ++l2;
        }
        this.join(l2);
    }

    public final void join() throws InterruptedException {
        this.join(0L);
    }

    public static void dumpStack() {
        new Exception("Stack trace").printStackTrace();
    }

    public final void setDaemon(boolean bl2) {
        this.checkAccess();
        if (this.isAlive()) {
            throw new IllegalThreadStateException();
        }
        this.daemon = bl2;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public final void checkAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public String toString() {
        ThreadGroup threadGroup = this.getThreadGroup();
        if (threadGroup != null) {
            return "Thread[" + this.getName() + "," + this.getPriority() + "," + threadGroup.getName() + "]";
        }
        return "Thread[" + this.getName() + "," + this.getPriority() + "," + "" + "]";
    }

    public ClassLoader getContextClassLoader() {
        ClassLoader classLoader;
        if (this.contextClassLoader == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != this.contextClassLoader && !this.contextClassLoader.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.contextClassLoader;
    }

    public void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classLoader;
    }

    public static native boolean holdsLock(Object var0);

    public StackTraceElement[] getStackTrace() {
        Thread[] threadArray;
        if (this != Thread.currentThread() && (threadArray = System.getSecurityManager()) != null) {
            threadArray.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
        }
        if (!this.isAlive()) {
            return EMPTY_STACK_TRACE;
        }
        threadArray = new Thread[]{this};
        StackTraceElement[][] stackTraceElementArray = Thread.dumpThreads(threadArray);
        return stackTraceElementArray[0];
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_STACK_TRACE_PERMISSION);
            securityManager.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        }
        Thread[] threadArray = Thread.getThreads();
        StackTraceElement[][] stackTraceElementArray = Thread.dumpThreads(threadArray);
        HashMap<Thread, StackTraceElement[]> hashMap = new HashMap<Thread, StackTraceElement[]>(threadArray.length);
        for (int i2 = 0; i2 < threadArray.length; ++i2) {
            if (!threadArray[i2].isAlive()) continue;
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray[i2];
            if (stackTraceElementArray2 == null) {
                stackTraceElementArray2 = EMPTY_STACK_TRACE;
            }
            hashMap.put(threadArray[i2], stackTraceElementArray2);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isCCLOverridden(Class clazz) {
        if (clazz == Thread.class) {
            return false;
        }
        Boolean bl2 = null;
        SoftCache softCache = subclassAudits;
        synchronized (softCache) {
            bl2 = (Boolean)subclassAudits.get(clazz);
            if (bl2 == null) {
                bl2 = new Boolean(Thread.auditSubclass(clazz));
                subclassAudits.put(clazz, bl2);
            }
        }
        return bl2;
    }

    private static boolean auditSubclass(final Class clazz) {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class clazz2 = clazz; clazz2 != Thread.class; clazz2 = clazz2.getSuperclass()) {
                    try {
                        clazz2.getDeclaredMethod("getContextClassLoader", new Class[0]);
                        return Boolean.TRUE;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Class[] classArray = new Class[]{ClassLoader.class};
                            clazz2.getDeclaredMethod("setContextClassLoader", classArray);
                            return Boolean.TRUE;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            continue;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        return bl2;
    }

    private static native StackTraceElement[][] dumpThreads(Thread[] var0);

    private static native Thread[] getThreads();

    public long getId() {
        return this.tid;
    }

    public State getState() {
        return VM.toThreadState(this.threadStatus);
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setDefaultUncaughtExceptionHandler"));
        }
        defaultUncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtExceptionHandler;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler != null ? this.uncaughtExceptionHandler : this.group;
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.checkAccess();
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    private void dispatchUncaughtException(Throwable throwable) {
        this.getUncaughtExceptionHandler().uncaughtException(this, throwable);
    }

    private native void setPriority0(int var1);

    private native void stop0(Object var1);

    private native void suspend0();

    private native void resume0();

    private native void interrupt0();

    static {
        Thread.registerNatives();
        EMPTY_STACK_TRACE = new StackTraceElement[0];
        SUBCLASS_IMPLEMENTATION_PERMISSION = new RuntimePermission("enableContextClassLoaderOverride");
        subclassAudits = new SoftCache(10);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }
}

