/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.jca.JCAUtil;

public abstract class SignatureSpi {
    protected SecureRandom appRandom = null;

    protected abstract void engineInitVerify(PublicKey var1) throws InvalidKeyException;

    protected abstract void engineInitSign(PrivateKey var1) throws InvalidKeyException;

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.appRandom = secureRandom;
        this.engineInitSign(privateKey);
    }

    protected abstract void engineUpdate(byte var1) throws SignatureException;

    protected abstract void engineUpdate(byte[] var1, int var2, int var3) throws SignatureException;

    protected void engineUpdate(ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return;
        }
        try {
            if (byteBuffer.hasArray()) {
                byte[] byArray = byteBuffer.array();
                int n2 = byteBuffer.arrayOffset();
                int n3 = byteBuffer.position();
                int n4 = byteBuffer.limit();
                this.engineUpdate(byArray, n2 + n3, n4 - n3);
                byteBuffer.position(n4);
            } else {
                int n5;
                int n6;
                byte[] byArray = new byte[JCAUtil.getTempArraySize(n6)];
                for (n6 = byteBuffer.remaining(); n6 > 0; n6 -= n5) {
                    n5 = Math.min(n6, byArray.length);
                    byteBuffer.get(byArray, 0, n5);
                    this.engineUpdate(byArray, 0, n5);
                }
            }
        }
        catch (SignatureException signatureException) {
            throw new ProviderException("update() failed", signatureException);
        }
    }

    protected abstract byte[] engineSign() throws SignatureException;

    protected int engineSign(byte[] byArray, int n2, int n3) throws SignatureException {
        byte[] byArray2 = this.engineSign();
        if (n3 < byArray2.length) {
            throw new SignatureException("partial signatures not returned");
        }
        if (byArray.length - n2 < byArray2.length) {
            throw new SignatureException("insufficient space in the output buffer to store the signature");
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return byArray2.length;
    }

    protected abstract boolean engineVerify(byte[] var1) throws SignatureException;

    protected boolean engineVerify(byte[] byArray, int n2, int n3) throws SignatureException {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return this.engineVerify(byArray2);
    }

    protected abstract void engineSetParameter(String var1, Object var2) throws InvalidParameterException;

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    protected AlgorithmParameters engineGetParameters() {
        throw new UnsupportedOperationException();
    }

    protected abstract Object engineGetParameter(String var1) throws InvalidParameterException;

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }
}

