/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverInfo;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverManager {
    static final SQLPermission SET_LOG_PERMISSION = new SQLPermission("setLog");
    private static Vector drivers = new Vector();
    private static int loginTimeout = 0;
    private static PrintWriter logWriter = null;
    private static PrintStream logStream = null;
    private static boolean initialized = false;
    private static Object logSync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintWriter getLogWriter() {
        Object object = logSync;
        synchronized (object) {
            return logWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogWriter(PrintWriter printWriter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOG_PERMISSION);
        }
        Object object = logSync;
        synchronized (object) {
            logStream = null;
            logWriter = printWriter;
        }
    }

    public static synchronized Connection getConnection(String string, Properties properties) throws SQLException {
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(string, properties, classLoader);
    }

    public static synchronized Connection getConnection(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (string3 != null) {
            properties.put("password", string3);
        }
        return DriverManager.getConnection(string, properties, classLoader);
    }

    public static synchronized Connection getConnection(String string) throws SQLException {
        Properties properties = new Properties();
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(string, properties, classLoader);
    }

    public static synchronized Driver getDriver(String string) throws SQLException {
        DriverManager.println("DriverManager.getDriver(\"" + string + "\")");
        if (!initialized) {
            DriverManager.initialize();
        }
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        for (int i2 = 0; i2 < drivers.size(); ++i2) {
            DriverInfo driverInfo = (DriverInfo)drivers.elementAt(i2);
            if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
                DriverManager.println("    skipping: " + driverInfo);
                continue;
            }
            try {
                DriverManager.println("    trying " + driverInfo);
                if (!driverInfo.driver.acceptsURL(string)) continue;
                DriverManager.println("getDriver returning " + driverInfo);
                return driverInfo.driver;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        DriverManager.println("getDriver: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    public static synchronized void registerDriver(Driver driver) throws SQLException {
        if (!initialized) {
            DriverManager.initialize();
        }
        DriverInfo driverInfo = new DriverInfo();
        driverInfo.driver = driver;
        driverInfo.driverClass = driver.getClass();
        driverInfo.driverClassName = driverInfo.driverClass.getName();
        drivers.addElement(driverInfo);
        DriverManager.println("registerDriver: " + driverInfo);
    }

    public static synchronized void deregisterDriver(Driver driver) throws SQLException {
        int n2;
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        DriverManager.println("DriverManager.deregisterDriver: " + driver);
        DriverInfo driverInfo = null;
        for (n2 = 0; n2 < drivers.size(); ++n2) {
            driverInfo = (DriverInfo)drivers.elementAt(n2);
            if (driverInfo.driver == driver) break;
        }
        if (n2 >= drivers.size()) {
            DriverManager.println("    couldn't find driver to unload");
            return;
        }
        if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
            throw new SecurityException();
        }
        drivers.removeElementAt(n2);
    }

    public static synchronized Enumeration<Driver> getDrivers() {
        Vector<Driver> vector = new Vector<Driver>();
        if (!initialized) {
            DriverManager.initialize();
        }
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        for (int i2 = 0; i2 < drivers.size(); ++i2) {
            DriverInfo driverInfo = (DriverInfo)drivers.elementAt(i2);
            if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
                DriverManager.println("    skipping: " + driverInfo);
                continue;
            }
            vector.addElement(driverInfo.driver);
        }
        return vector.elements();
    }

    public static void setLoginTimeout(int n2) {
        loginTimeout = n2;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static synchronized void setLogStream(PrintStream printStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = printStream;
        logWriter = printStream != null ? new PrintWriter(printStream) : null;
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String string) {
        Object object = logSync;
        synchronized (object) {
            if (logWriter != null) {
                logWriter.println(string);
                logWriter.flush();
            }
        }
    }

    private static Class getCallerClass(ClassLoader classLoader, String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string, true, classLoader);
        }
        catch (Exception exception) {
            clazz = null;
        }
        return clazz;
    }

    private static void loadInitialDrivers() {
        String string;
        try {
            string = (String)AccessController.doPrivileged(new GetPropertyAction("jdbc.drivers"));
        }
        catch (Exception exception) {
            string = null;
        }
        DriverManager.println("DriverManager.initialize: jdbc.drivers = " + string);
        if (string == null) {
            return;
        }
        while (string.length() != 0) {
            String string2;
            int n2 = string.indexOf(58);
            if (n2 < 0) {
                string2 = string;
                string = "";
            } else {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1);
            }
            if (string2.length() == 0) continue;
            try {
                DriverManager.println("DriverManager.Initialize: loading " + string2);
                Class.forName(string2, true, ClassLoader.getSystemClassLoader());
            }
            catch (Exception exception) {
                DriverManager.println("DriverManager.Initialize: load failed: " + exception);
            }
        }
    }

    private static synchronized Connection getConnection(String string, Properties properties, ClassLoader classLoader) throws SQLException {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (string == null) {
            throw new SQLException("The url cannot be null", "08001");
        }
        DriverManager.println("DriverManager.getConnection(\"" + string + "\")");
        if (!initialized) {
            DriverManager.initialize();
        }
        SQLException sQLException = null;
        for (int i2 = 0; i2 < drivers.size(); ++i2) {
            DriverInfo driverInfo = (DriverInfo)drivers.elementAt(i2);
            if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
                DriverManager.println("    skipping: " + driverInfo);
                continue;
            }
            try {
                DriverManager.println("    trying " + driverInfo);
                Connection connection = driverInfo.driver.connect(string, properties);
                if (connection == null) continue;
                DriverManager.println("getConnection returning " + driverInfo);
                return connection;
            }
            catch (SQLException sQLException2) {
                if (sQLException != null) continue;
                sQLException = sQLException2;
            }
        }
        if (sQLException != null) {
            DriverManager.println("getConnection failed: " + sQLException);
            throw sQLException;
        }
        DriverManager.println("getConnection: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        DriverManager.loadInitialDrivers();
        DriverManager.println("JDBC DriverManager initialized");
    }

    private DriverManager() {
    }

    private static native ClassLoader getCallerClassLoader();
}

