/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMap<K extends Enum<K>, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private final Class<K> keyType;
    private transient K[] keyUniverse;
    private transient Object[] vals;
    private transient int size = 0;
    private static final Object NULL = new Object();
    private static Enum[] ZERO_LENGTH_ENUM_ARRAY = new Enum[0];
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 458661240069192865L;

    private Object maskNull(Object object) {
        return object == null ? NULL : object;
    }

    private V unmaskNull(Object object) {
        return (V)(object == NULL ? null : object);
    }

    public EnumMap(Class<K> clazz) {
        this.keyType = clazz;
        this.keyUniverse = (Enum[])clazz.getEnumConstants();
        this.vals = new Object[this.keyUniverse.length];
    }

    public EnumMap(EnumMap<K, ? extends V> enumMap) {
        this.keyType = enumMap.keyType;
        this.keyUniverse = enumMap.keyUniverse;
        this.vals = (Object[])enumMap.vals.clone();
        this.size = enumMap.size;
    }

    public EnumMap(Map<K, ? extends V> map) {
        if (map instanceof EnumMap) {
            EnumMap enumMap = (EnumMap)map;
            this.keyType = enumMap.keyType;
            this.keyUniverse = enumMap.keyUniverse;
            this.vals = (Object[])enumMap.vals.clone();
            this.size = enumMap.size;
        } else {
            if (map.isEmpty()) {
                throw new IllegalArgumentException("Specified map is empty");
            }
            this.keyType = ((Enum)map.keySet().iterator().next()).getDeclaringClass();
            this.keyUniverse = (Enum[])this.keyType.getEnumConstants();
            this.vals = new Object[this.keyUniverse.length];
            this.putAll(map);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean containsValue(Object object) {
        object = this.maskNull(object);
        for (Object object2 : this.vals) {
            if (!object.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.isValidKey(object) && this.vals[((Enum)object).ordinal()] != null;
    }

    private boolean containsMapping(Object object, Object object2) {
        return this.isValidKey(object) && this.maskNull(object2).equals(this.vals[((Enum)object).ordinal()]);
    }

    @Override
    public V get(Object object) {
        return this.isValidKey(object) ? (V)this.unmaskNull(this.vals[((Enum)object).ordinal()]) : null;
    }

    @Override
    public V put(K k2, V v2) {
        int n2 = ((Enum)k2).ordinal();
        Object object = this.vals[n2];
        this.vals[n2] = this.maskNull(v2);
        if (object == null) {
            ++this.size;
        }
        return this.unmaskNull(object);
    }

    @Override
    public V remove(Object object) {
        if (!this.isValidKey(object)) {
            return null;
        }
        int n2 = ((Enum)object).ordinal();
        Object object2 = this.vals[n2];
        this.vals[n2] = null;
        if (object2 != null) {
            --this.size;
        }
        return this.unmaskNull(object2);
    }

    private boolean removeMapping(Object object, Object object2) {
        if (!this.isValidKey(object)) {
            return false;
        }
        int n2 = ((Enum)object).ordinal();
        if (this.maskNull(object2).equals(this.vals[n2])) {
            this.vals[n2] = null;
            --this.size;
            return true;
        }
        return false;
    }

    private boolean isValidKey(Object object) {
        if (object == null) {
            return false;
        }
        Class<? extends Object> clazz = object.getClass();
        return clazz == this.keyType || clazz.getSuperclass() == this.keyType;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map instanceof EnumMap) {
            EnumMap enumMap = (EnumMap)map;
            for (int i2 = 0; i2 < this.keyUniverse.length; ++i2) {
                Object object = enumMap.vals[i2];
                if (object == null) continue;
                if (this.vals[i2] == null) {
                    ++this.size;
                }
                this.vals[i2] = object;
            }
        } else {
            super.putAll(map);
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.vals, null);
        this.size = 0;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        if (set != null) {
            return set;
        }
        this.keySet = new KeySet();
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        if (collection != null) {
            return collection;
        }
        this.values = new Values();
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set != null) {
            return set;
        }
        this.entrySet = new EntrySet();
        return this.entrySet;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof EnumMap)) {
            return super.equals(object);
        }
        EnumMap enumMap = (EnumMap)object;
        if (enumMap.keyType != this.keyType) {
            return this.size == 0 && enumMap.size == 0;
        }
        for (int i2 = 0; i2 < this.keyUniverse.length; ++i2) {
            Object object2 = enumMap.vals[i2];
            Object object3 = this.vals[i2];
            if (object2 == object3 || object2 != null && object2.equals(object3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public EnumMap<K, V> clone() {
        EnumMap enumMap = null;
        try {
            enumMap = (EnumMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
        enumMap.vals = (Object[])enumMap.vals.clone();
        return enumMap;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        for (Map.Entry<K, V> entry : this.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.keyUniverse = (Enum[])this.keyType.getEnumConstants();
        this.vals = new Object[this.keyUniverse.length];
        int n2 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            Enum enum_ = (Enum)objectInputStream.readObject();
            Object object = objectInputStream.readObject();
            this.put((K)enum_, (V)object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends EnumMapIterator<Map.Entry<K, V>>
    implements Map.Entry<K, V> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return this;
        }

        @Override
        public K getKey() {
            this.checkLastReturnedIndexForEntryUse();
            return EnumMap.this.keyUniverse[this.lastReturnedIndex];
        }

        @Override
        public V getValue() {
            this.checkLastReturnedIndexForEntryUse();
            return EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
        }

        @Override
        public V setValue(V v2) {
            this.checkLastReturnedIndexForEntryUse();
            Object object = EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
            ((EnumMap)EnumMap.this).vals[this.lastReturnedIndex] = EnumMap.this.maskNull(v2);
            return object;
        }

        @Override
        public boolean equals(Object object) {
            if (this.lastReturnedIndex < 0) {
                return object == this;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
            Object v2 = entry.getValue();
            return entry.getKey() == EnumMap.this.keyUniverse[this.lastReturnedIndex] && (object2 == v2 || object2 != null && object2.equals(v2));
        }

        @Override
        public int hashCode() {
            if (this.lastReturnedIndex < 0) {
                return super.hashCode();
            }
            Object object = EnumMap.this.vals[this.lastReturnedIndex];
            return EnumMap.this.keyUniverse[this.lastReturnedIndex].hashCode() ^ (object == NULL ? 0 : object.hashCode());
        }

        public String toString() {
            if (this.lastReturnedIndex < 0) {
                return super.toString();
            }
            return EnumMap.this.keyUniverse[this.lastReturnedIndex] + "=" + EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
        }

        private void checkLastReturnedIndexForEntryUse() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException("Entry was removed");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return EnumMap.this.containsMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return EnumMap.this.removeMapping(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            return this.fillEntryArray(new Object[EnumMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), EnumMap.this.size);
            return this.fillEntryArray(objectArray);
        }

        private Object[] fillEntryArray(Object[] objectArray) {
            int n2 = 0;
            for (int i2 = 0; i2 < EnumMap.this.vals.length; ++i2) {
                if (EnumMap.this.vals[i2] == null) continue;
                objectArray[n2++] = new AbstractMap.SimpleEntry<Enum, Object>(EnumMap.this.keyUniverse[i2], EnumMap.this.unmaskNull(EnumMap.this.vals[i2]));
            }
            return objectArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class EnumMapIterator<T>
    implements Iterator<T> {
        int index = 0;
        int lastReturnedIndex = -1;

        private EnumMapIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.index < EnumMap.this.vals.length && EnumMap.this.vals[this.index] == null) {
                ++this.index;
            }
            return this.index != EnumMap.this.vals.length;
        }

        @Override
        public void remove() {
            this.checkLastReturnedIndex();
            if (EnumMap.this.vals[this.lastReturnedIndex] != null) {
                ((EnumMap)EnumMap.this).vals[this.lastReturnedIndex] = null;
                EnumMap.this.size--;
            }
            this.lastReturnedIndex = -1;
        }

        private void checkLastReturnedIndex() {
            if (this.lastReturnedIndex < 0) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    extends EnumMapIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumMap.this.keyUniverse[this.lastReturnedIndex];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return EnumMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            int n2 = EnumMap.this.size;
            EnumMap.this.remove(object);
            return EnumMap.this.size != n2;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueIterator
    extends EnumMapIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return EnumMap.this.unmaskNull(EnumMap.this.vals[this.lastReturnedIndex]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return EnumMap.this.size;
        }

        @Override
        public boolean contains(Object object) {
            return EnumMap.this.containsValue(object);
        }

        @Override
        public boolean remove(Object object) {
            object = EnumMap.this.maskNull(object);
            for (int i2 = 0; i2 < EnumMap.this.vals.length; ++i2) {
                if (!object.equals(EnumMap.this.vals[i2])) continue;
                ((EnumMap)EnumMap.this).vals[i2] = null;
                EnumMap.this.size--;
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            EnumMap.this.clear();
        }
    }
}

