/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.JumboEnumSet;
import java.util.RegularEnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumSet<E extends Enum<E>>
extends AbstractSet<E>
implements Cloneable,
Serializable {
    final Class<E> elementType;
    final Enum[] universe;
    private static Enum[] ZERO_LENGTH_ENUM_ARRAY = new Enum[0];

    EnumSet(Class<E> clazz, Enum[] enumArray) {
        this.elementType = clazz;
        this.universe = enumArray;
    }

    public static <E extends Enum<E>> EnumSet<E> noneOf(Class<E> clazz) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        if (enumArray == null) {
            throw new ClassCastException(clazz + " not an enum");
        }
        if (enumArray.length <= 64) {
            return new RegularEnumSet<E>(clazz, enumArray);
        }
        return new JumboEnumSet<E>(clazz, enumArray);
    }

    public static <E extends Enum<E>> EnumSet<E> allOf(Class<E> clazz) {
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        enumSet.addAll();
        return enumSet;
    }

    abstract void addAll();

    public static <E extends Enum<E>> EnumSet<E> copyOf(EnumSet<E> enumSet) {
        return enumSet.clone();
    }

    public static <E extends Enum<E>> EnumSet<E> copyOf(Collection<E> collection) {
        if (collection instanceof EnumSet) {
            return ((EnumSet)collection).clone();
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Collection is empty");
        }
        Iterator<E> iterator = collection.iterator();
        Enum enum_ = (Enum)iterator.next();
        EnumSet<Enum> enumSet = EnumSet.of(enum_);
        while (iterator.hasNext()) {
            enumSet.add(iterator.next());
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(EnumSet<E> enumSet) {
        EnumSet<E> enumSet2 = EnumSet.copyOf(enumSet);
        enumSet2.complement();
        return enumSet2;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2) {
        EnumSet<E> enumSet = EnumSet.noneOf(e2.getDeclaringClass());
        enumSet.add((Object)e2);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2, E e3) {
        EnumSet<E> enumSet = EnumSet.noneOf(e2.getDeclaringClass());
        enumSet.add((Object)e2);
        enumSet.add((Object)e3);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2, E e3, E e4) {
        EnumSet<E> enumSet = EnumSet.noneOf(e2.getDeclaringClass());
        enumSet.add((Object)e2);
        enumSet.add((Object)e3);
        enumSet.add((Object)e4);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2, E e3, E e4, E e5) {
        EnumSet<E> enumSet = EnumSet.noneOf(e2.getDeclaringClass());
        enumSet.add((Object)e2);
        enumSet.add((Object)e3);
        enumSet.add((Object)e4);
        enumSet.add((Object)e5);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2, E e3, E e4, E e5, E e6) {
        EnumSet<E> enumSet = EnumSet.noneOf(e2.getDeclaringClass());
        enumSet.add((Object)e2);
        enumSet.add((Object)e3);
        enumSet.add((Object)e4);
        enumSet.add((Object)e5);
        enumSet.add((Object)e6);
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> of(E e2, E ... EArray) {
        EnumSet<E> enumSet = EnumSet.noneOf(e2.getDeclaringClass());
        enumSet.add((Object)e2);
        for (E e3 : EArray) {
            enumSet.add((Object)e3);
        }
        return enumSet;
    }

    public static <E extends Enum<E>> EnumSet<E> range(E e2, E e3) {
        if (e2.compareTo(e3) > 0) {
            throw new IllegalArgumentException(e2 + " > " + e3);
        }
        EnumSet<E> enumSet = EnumSet.noneOf(e2.getDeclaringClass());
        enumSet.addRange(e2, e3);
        return enumSet;
    }

    abstract void addRange(E var1, E var2);

    public EnumSet<E> clone() {
        try {
            return (EnumSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    abstract void complement();

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<E extends Enum<E>>
    implements Serializable {
        private final Class<E> elementType;
        private final Enum[] elements;
        private static final long serialVersionUID = 362491234563181265L;

        SerializationProxy(EnumSet<E> enumSet) {
            this.elementType = enumSet.elementType;
            this.elements = enumSet.toArray(ZERO_LENGTH_ENUM_ARRAY);
        }

        private Object readResolve() {
            EnumSet<E> enumSet = EnumSet.noneOf(this.elementType);
            for (Enum enum_ : this.elements) {
                enumSet.add(enum_);
            }
            return enumSet;
        }
    }
}

