/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formattable;
import java.util.FormatterClosedException;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.TimeZone;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.FormattedFloatingDecimal;
import sun.misc.FpUtils;

public final class Formatter
implements Closeable,
Flushable {
    private Appendable a;
    private Locale l;
    private IOException lastException;
    private char zero = (char)48;
    private static double scaleUp;
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static Pattern fsPattern;

    public Formatter() {
        this(new StringBuilder(), Locale.getDefault());
    }

    public Formatter(Appendable appendable) {
        this(appendable, Locale.getDefault());
    }

    public Formatter(Locale locale) {
        this(new StringBuilder(), locale);
    }

    public Formatter(Appendable appendable, Locale locale) {
        this.a = appendable == null ? new StringBuilder() : appendable;
        this.l = locale;
        this.setZero();
    }

    public Formatter(String string) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string))), Locale.getDefault());
    }

    public Formatter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(string, string2, Locale.getDefault());
    }

    public Formatter(String string, String string2, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2)), locale);
    }

    public Formatter(File file) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))), Locale.getDefault());
    }

    public Formatter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, string, Locale.getDefault());
    }

    public Formatter(File file, String string, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string)), locale);
    }

    public Formatter(OutputStream outputStream) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), Locale.getDefault());
    }

    public Formatter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, string, Locale.getDefault());
    }

    public Formatter(OutputStream outputStream, String string, Locale locale) throws UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter(outputStream, string)), locale);
    }

    private void setZero() {
        if (this.l != null && !this.l.equals(Locale.US)) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(this.l);
            this.zero = decimalFormatSymbols.getZeroDigit();
        }
    }

    public Locale locale() {
        this.ensureOpen();
        return this.l;
    }

    public Appendable out() {
        this.ensureOpen();
        return this.a;
    }

    public String toString() {
        this.ensureOpen();
        return this.a.toString();
    }

    public void flush() {
        this.ensureOpen();
        if (this.a instanceof Flushable) {
            try {
                ((Flushable)((Object)this.a)).flush();
            }
            catch (IOException iOException) {
                this.lastException = iOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.a == null) {
            return;
        }
        try {
            if (this.a instanceof Closeable) {
                ((Closeable)((Object)this.a)).close();
            }
        }
        catch (IOException iOException) {
            this.lastException = iOException;
        }
        finally {
            this.a = null;
        }
    }

    private void ensureOpen() {
        if (this.a == null) {
            throw new FormatterClosedException();
        }
    }

    public IOException ioException() {
        return this.lastException;
    }

    public Formatter format(String string, Object ... objectArray) {
        return this.format(this.l, string, objectArray);
    }

    public Formatter format(Locale locale, String string, Object ... objectArray) {
        this.ensureOpen();
        int n2 = -1;
        int n3 = -1;
        FormatString[] formatStringArray = this.parse(string);
        for (int i2 = 0; i2 < formatStringArray.length; ++i2) {
            FormatString formatString = formatStringArray[i2];
            int n4 = formatString.index();
            try {
                switch (n4) {
                    case -2: {
                        formatString.print(null, locale);
                        break;
                    }
                    case -1: {
                        if (n2 < 0 || objectArray != null && n2 > objectArray.length - 1) {
                            throw new MissingFormatArgumentException(((Object)formatString).toString());
                        }
                        formatString.print(objectArray == null ? null : objectArray[n2], locale);
                        break;
                    }
                    case 0: {
                        n2 = ++n3;
                        if (objectArray != null && n3 > objectArray.length - 1) {
                            throw new MissingFormatArgumentException(((Object)formatString).toString());
                        }
                        formatString.print(objectArray == null ? null : objectArray[n3], locale);
                        break;
                    }
                    default: {
                        n2 = n4 - 1;
                        if (objectArray != null && n2 > objectArray.length - 1) {
                            throw new MissingFormatArgumentException(((Object)formatString).toString());
                        }
                        formatString.print(objectArray == null ? null : objectArray[n2], locale);
                        break;
                    }
                }
                continue;
            }
            catch (IOException iOException) {
                this.lastException = iOException;
            }
        }
        return this;
    }

    private FormatString[] parse(String string) {
        ArrayList<FormatString> arrayList = new ArrayList<FormatString>();
        Matcher matcher = fsPattern.matcher(string);
        int n2 = 0;
        while (n2 < string.length()) {
            if (matcher.find(n2)) {
                if (matcher.start() != n2) {
                    this.checkText(string.substring(n2, matcher.start()));
                    arrayList.add(new FixedString(string.substring(n2, matcher.start())));
                }
                String[] stringArray = new String[6];
                for (int i2 = 0; i2 < matcher.groupCount(); ++i2) {
                    stringArray[i2] = matcher.group(i2 + 1);
                }
                arrayList.add(new FormatSpecifier(this, stringArray));
                n2 = matcher.end();
                continue;
            }
            this.checkText(string.substring(n2));
            arrayList.add(new FixedString(string.substring(n2)));
            break;
        }
        return arrayList.toArray(new FormatString[0]);
    }

    private void checkText(String string) {
        int n2 = string.indexOf(37);
        if (n2 != -1) {
            char c2 = n2 > string.length() - 2 ? (char)'%' : (char)string.charAt(n2 + 1);
            throw new UnknownFormatConversionException(String.valueOf(c2));
        }
    }

    static {
        fsPattern = Pattern.compile(formatSpecifier);
    }

    private static class Conversion {
        static final char DECIMAL_INTEGER = 'd';
        static final char OCTAL_INTEGER = 'o';
        static final char HEXADECIMAL_INTEGER = 'x';
        static final char HEXADECIMAL_INTEGER_UPPER = 'X';
        static final char SCIENTIFIC = 'e';
        static final char SCIENTIFIC_UPPER = 'E';
        static final char GENERAL = 'g';
        static final char GENERAL_UPPER = 'G';
        static final char DECIMAL_FLOAT = 'f';
        static final char HEXADECIMAL_FLOAT = 'a';
        static final char HEXADECIMAL_FLOAT_UPPER = 'A';
        static final char CHARACTER = 'c';
        static final char CHARACTER_UPPER = 'C';
        static final char DATE_TIME = 't';
        static final char DATE_TIME_UPPER = 'T';
        static final char BOOLEAN = 'b';
        static final char BOOLEAN_UPPER = 'B';
        static final char STRING = 's';
        static final char STRING_UPPER = 'S';
        static final char HASHCODE = 'h';
        static final char HASHCODE_UPPER = 'H';
        static final char LINE_SEPARATOR = 'n';
        static final char PERCENT_SIGN = '%';

        private Conversion() {
        }

        static boolean isValid(char c2) {
            return Conversion.isGeneral(c2) || Conversion.isInteger(c2) || Conversion.isFloat(c2) || Conversion.isText(c2) || c2 == 't' || c2 == 'c';
        }

        static boolean isGeneral(char c2) {
            switch (c2) {
                case 'B': 
                case 'H': 
                case 'S': 
                case 'b': 
                case 'h': 
                case 's': {
                    return true;
                }
            }
            return false;
        }

        static boolean isInteger(char c2) {
            switch (c2) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    return true;
                }
            }
            return false;
        }

        static boolean isFloat(char c2) {
            switch (c2) {
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    return true;
                }
            }
            return false;
        }

        static boolean isText(char c2) {
            switch (c2) {
                case '%': 
                case 'n': {
                    return true;
                }
            }
            return false;
        }
    }

    private static class DateTime {
        static final char HOUR_OF_DAY_0 = 'H';
        static final char HOUR_0 = 'I';
        static final char HOUR_OF_DAY = 'k';
        static final char HOUR = 'l';
        static final char MINUTE = 'M';
        static final char NANOSECOND = 'N';
        static final char MILLISECOND = 'L';
        static final char MILLISECOND_SINCE_EPOCH = 'Q';
        static final char AM_PM_UPPER = 'P';
        static final char AM_PM_LOWER = 'p';
        static final char SECONDS_SINCE_EPOCH = 's';
        static final char SECOND = 'S';
        static final char TIME = 'T';
        static final char ZONE_NUMERIC = 'z';
        static final char ZONE = 'Z';
        static final char NAME_OF_DAY_ABBREV = 'a';
        static final char NAME_OF_DAY = 'A';
        static final char NAME_OF_MONTH_ABBREV = 'b';
        static final char NAME_OF_MONTH = 'B';
        static final char CENTURY = 'C';
        static final char DAY_OF_MONTH_0 = 'd';
        static final char DAY_OF_MONTH = 'e';
        static final char NAME_OF_MONTH_ABBREV_X = 'h';
        static final char DAY_OF_YEAR = 'j';
        static final char MONTH = 'm';
        static final char YEAR_2 = 'y';
        static final char YEAR_4 = 'Y';
        static final char TIME_12_HOUR = 'r';
        static final char TIME_24_HOUR = 'R';
        static final char DATE_TIME = 'c';
        static final char DATE = 'D';
        static final char ISO_STANDARD_DATE = 'F';

        private DateTime() {
        }

        static boolean isValid(char c2) {
            switch (c2) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'I': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'p': 
                case 'r': 
                case 's': 
                case 'y': 
                case 'z': {
                    return true;
                }
            }
            return false;
        }
    }

    private class FixedString
    implements FormatString {
        private String s;

        FixedString(String string) {
            this.s = string;
        }

        public int index() {
            return -2;
        }

        public void print(Object object, Locale locale) throws IOException {
            Formatter.this.a.append(this.s);
        }

        public String toString() {
            return this.s;
        }
    }

    private static class Flags {
        private int flags;
        static final Flags NONE = new Flags(0);
        static final Flags LEFT_JUSTIFY = new Flags(1);
        static final Flags UPPERCASE = new Flags(2);
        static final Flags ALTERNATE = new Flags(4);
        static final Flags PLUS = new Flags(8);
        static final Flags LEADING_SPACE = new Flags(16);
        static final Flags ZERO_PAD = new Flags(32);
        static final Flags GROUP = new Flags(64);
        static final Flags PARENTHESES = new Flags(128);
        static final Flags PREVIOUS = new Flags(256);

        private Flags(int n2) {
            this.flags = n2;
        }

        public int valueOf() {
            return this.flags;
        }

        public boolean contains(Flags flags) {
            return (this.flags & flags.valueOf()) == flags.valueOf();
        }

        public Flags dup() {
            return new Flags(this.flags);
        }

        private Flags add(Flags flags) {
            this.flags |= flags.valueOf();
            return this;
        }

        public Flags remove(Flags flags) {
            this.flags &= ~flags.valueOf();
            return this;
        }

        public static Flags parse(String string) {
            char[] cArray = string.toCharArray();
            Flags flags = new Flags(0);
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                Flags flags2 = Flags.parse(cArray[i2]);
                if (flags.contains(flags2)) {
                    throw new DuplicateFormatFlagsException(flags2.toString());
                }
                flags.add(flags2);
            }
            return flags;
        }

        private static Flags parse(char c2) {
            switch (c2) {
                case '-': {
                    return LEFT_JUSTIFY;
                }
                case '#': {
                    return ALTERNATE;
                }
                case '+': {
                    return PLUS;
                }
                case ' ': {
                    return LEADING_SPACE;
                }
                case '0': {
                    return ZERO_PAD;
                }
                case ',': {
                    return GROUP;
                }
                case '(': {
                    return PARENTHESES;
                }
                case '<': {
                    return PREVIOUS;
                }
            }
            throw new UnknownFormatFlagsException(String.valueOf(c2));
        }

        public static String toString(Flags flags) {
            return flags.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.contains(LEFT_JUSTIFY)) {
                stringBuilder.append('-');
            }
            if (this.contains(UPPERCASE)) {
                stringBuilder.append('^');
            }
            if (this.contains(ALTERNATE)) {
                stringBuilder.append('#');
            }
            if (this.contains(PLUS)) {
                stringBuilder.append('+');
            }
            if (this.contains(LEADING_SPACE)) {
                stringBuilder.append(' ');
            }
            if (this.contains(ZERO_PAD)) {
                stringBuilder.append('0');
            }
            if (this.contains(GROUP)) {
                stringBuilder.append(',');
            }
            if (this.contains(PARENTHESES)) {
                stringBuilder.append('(');
            }
            if (this.contains(PREVIOUS)) {
                stringBuilder.append('<');
            }
            return stringBuilder.toString();
        }
    }

    private class FormatSpecifier
    implements FormatString {
        private int index = -1;
        private Flags f = Flags.NONE;
        private int width;
        private int precision;
        private boolean dt = false;
        private char c;
        private Formatter formatter;
        private String ls;

        private int index(String string) {
            if (string != null) {
                try {
                    this.index = Integer.parseInt(string.substring(0, string.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    assert (false);
                }
            } else {
                this.index = 0;
            }
            return this.index;
        }

        public int index() {
            return this.index;
        }

        private Flags flags(String string) {
            this.f = Flags.parse(string);
            if (this.f.contains(Flags.PREVIOUS)) {
                this.index = -1;
            }
            return this.f;
        }

        Flags flags() {
            return this.f;
        }

        private int width(String string) {
            block4: {
                this.width = -1;
                if (string != null) {
                    try {
                        this.width = Integer.parseInt(string);
                        if (this.width < 0) {
                            throw new IllegalFormatWidthException(this.width);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.width;
        }

        int width() {
            return this.width;
        }

        private int precision(String string) {
            block4: {
                this.precision = -1;
                if (string != null) {
                    try {
                        this.precision = Integer.parseInt(string.substring(1));
                        if (this.precision < 0) {
                            throw new IllegalFormatPrecisionException(this.precision);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.precision;
        }

        int precision() {
            return this.precision;
        }

        private char conversion(String string) {
            this.c = string.charAt(0);
            if (!this.dt) {
                if (!Conversion.isValid(this.c)) {
                    throw new UnknownFormatConversionException(String.valueOf(this.c));
                }
                if (Character.isUpperCase(this.c)) {
                    this.f.add(Flags.UPPERCASE);
                }
                this.c = Character.toLowerCase(this.c);
                if (Conversion.isText(this.c)) {
                    this.index = -2;
                }
            }
            return this.c;
        }

        private char conversion() {
            return this.c;
        }

        FormatSpecifier(Formatter formatter2, String[] stringArray) {
            this.formatter = formatter2;
            int n2 = 0;
            this.index(stringArray[n2++]);
            this.flags(stringArray[n2++]);
            this.width(stringArray[n2++]);
            this.precision(stringArray[n2++]);
            if (stringArray[n2] != null) {
                this.dt = true;
                if (stringArray[n2].equals("T")) {
                    this.f.add(Flags.UPPERCASE);
                }
            }
            this.conversion(stringArray[++n2]);
            if (this.dt) {
                this.checkDateTime();
            } else if (Conversion.isGeneral(this.c)) {
                this.checkGeneral();
            } else if (this.c == 'c') {
                this.checkCharacter();
            } else if (Conversion.isInteger(this.c)) {
                this.checkInteger();
            } else if (Conversion.isFloat(this.c)) {
                this.checkFloat();
            } else if (Conversion.isText(this.c)) {
                this.checkText();
            } else {
                throw new UnknownFormatConversionException(String.valueOf(this.c));
            }
        }

        public void print(Object object, Locale locale) throws IOException {
            if (this.dt) {
                this.printDateTime(object, locale);
                return;
            }
            switch (this.c) {
                case 'd': 
                case 'o': 
                case 'x': {
                    this.printInteger(object, locale);
                    break;
                }
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    this.printFloat(object, locale);
                    break;
                }
                case 'c': {
                    this.printCharacter(object);
                    break;
                }
                case 'b': {
                    this.printBoolean(object);
                    break;
                }
                case 's': {
                    this.printString(object, locale);
                    break;
                }
                case 'h': {
                    this.printHashCode(object);
                    break;
                }
                case 'n': {
                    if (this.ls == null) {
                        this.ls = System.getProperty("line.separator");
                    }
                    Formatter.this.a.append(this.ls);
                    break;
                }
                case '%': {
                    Formatter.this.a.append('%');
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void printInteger(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
            } else if (object instanceof Byte) {
                this.print((Byte)object, locale);
            } else if (object instanceof Short) {
                this.print((Short)object, locale);
            } else if (object instanceof Integer) {
                this.print((Integer)object, locale);
            } else if (object instanceof Long) {
                this.print((Long)object, locale);
            } else if (object instanceof BigInteger) {
                this.print((BigInteger)object, locale);
            } else {
                this.failConversion(this.c, object);
            }
        }

        private void printFloat(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
            } else if (object instanceof Float) {
                this.print(((Float)object).floatValue(), locale);
            } else if (object instanceof Double) {
                this.print((Double)object, locale);
            } else if (object instanceof BigDecimal) {
                this.print((BigDecimal)object, locale);
            } else {
                this.failConversion(this.c, object);
            }
        }

        private void printDateTime(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
                return;
            }
            Calendar calendar = null;
            if (object instanceof Long) {
                calendar = Calendar.getInstance(locale);
                calendar.setTimeInMillis((Long)object);
            } else if (object instanceof Date) {
                calendar = Calendar.getInstance(locale);
                calendar.setTime((Date)object);
            } else if (object instanceof Calendar) {
                calendar = (Calendar)((Calendar)object).clone();
                calendar.setLenient(true);
            } else {
                this.failConversion(this.c, object);
            }
            this.print(calendar, this.c, locale);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void printCharacter(Object object) throws IOException {
            if (object == null) {
                this.print("null");
                return;
            }
            String string = null;
            if (object instanceof Character) {
                string = ((Character)object).toString();
            } else if (object instanceof Byte) {
                byte by = (Byte)object;
                if (!Character.isValidCodePoint(by)) throw new IllegalFormatCodePointException(by);
                string = new String(Character.toChars(by));
            } else if (object instanceof Short) {
                short s2 = (Short)object;
                if (!Character.isValidCodePoint(s2)) throw new IllegalFormatCodePointException(s2);
                string = new String(Character.toChars(s2));
            } else if (object instanceof Integer) {
                int n2 = (Integer)object;
                if (!Character.isValidCodePoint(n2)) throw new IllegalFormatCodePointException(n2);
                string = new String(Character.toChars(n2));
            } else {
                this.failConversion(this.c, object);
            }
            this.print(string);
        }

        private void printString(Object object, Locale locale) throws IOException {
            if (object == null) {
                this.print("null");
            } else if (object instanceof Formattable) {
                Formatter formatter = this.formatter;
                if (this.formatter.locale() != locale) {
                    formatter = new Formatter(this.formatter.out(), locale);
                }
                ((Formattable)object).formatTo(formatter, this.f.valueOf(), this.width, this.precision);
            } else {
                this.print(object.toString());
            }
        }

        private void printBoolean(Object object) throws IOException {
            String string = object != null ? (object instanceof Boolean ? ((Boolean)object).toString() : Boolean.toString(true)) : Boolean.toString(false);
            this.print(string);
        }

        private void printHashCode(Object object) throws IOException {
            String string = object == null ? "null" : Integer.toHexString(object.hashCode());
            this.print(string);
        }

        private void print(String string) throws IOException {
            if (this.precision != -1 && this.precision < string.length()) {
                string = string.substring(0, this.precision);
            }
            if (this.f.contains(Flags.UPPERCASE)) {
                string = string.toUpperCase();
            }
            Formatter.this.a.append(this.justify(string));
        }

        private String justify(String string) {
            int n2;
            if (this.width == -1) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = this.f.contains(Flags.LEFT_JUSTIFY);
            int n3 = this.width - string.length();
            if (!bl2) {
                for (n2 = 0; n2 < n3; ++n2) {
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.append(string);
            if (bl2) {
                for (n2 = 0; n2 < n3; ++n2) {
                    stringBuilder.append(' ');
                }
            }
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(37);
            Flags flags = this.f.dup().remove(Flags.UPPERCASE);
            stringBuilder.append(flags.toString());
            if (this.index > 0) {
                stringBuilder.append(this.index).append('$');
            }
            if (this.width != -1) {
                stringBuilder.append(this.width);
            }
            if (this.precision != -1) {
                stringBuilder.append('.').append(this.precision);
            }
            if (this.dt) {
                stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? (char)'T' : 't');
            }
            stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? Character.toUpperCase(this.c) : this.c);
            return stringBuilder.toString();
        }

        private void checkGeneral() {
            if ((this.c == 'b' || this.c == 'h') && this.f.contains(Flags.ALTERNATE)) {
                this.failMismatch(Flags.ALTERNATE, this.c);
            }
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
            this.checkBadFlags(Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
        }

        private void checkDateTime() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (!DateTime.isValid(this.c)) {
                throw new UnknownFormatConversionException("t" + this.c);
            }
            this.checkBadFlags(Flags.ALTERNATE);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkCharacter() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            this.checkBadFlags(Flags.ALTERNATE);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkInteger() {
            this.checkNumeric();
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (this.c == 'd') {
                this.checkBadFlags(Flags.ALTERNATE);
            } else if (this.c == 'o') {
                this.checkBadFlags(Flags.GROUP);
            } else {
                this.checkBadFlags(Flags.GROUP);
            }
        }

        private void checkBadFlags(Flags ... flagsArray) {
            for (int i2 = 0; i2 < flagsArray.length; ++i2) {
                if (!this.f.contains(flagsArray[i2])) continue;
                this.failMismatch(flagsArray[i2], this.c);
            }
        }

        private void checkFloat() {
            this.checkNumeric();
            if (this.c != 'f') {
                if (this.c == 'a') {
                    this.checkBadFlags(Flags.PARENTHESES, Flags.GROUP);
                } else if (this.c == 'e') {
                    this.checkBadFlags(Flags.GROUP);
                } else if (this.c == 'g') {
                    this.checkBadFlags(Flags.ALTERNATE);
                }
            }
        }

        private void checkNumeric() {
            if (this.width != -1 && this.width < 0) {
                throw new IllegalFormatWidthException(this.width);
            }
            if (this.precision != -1 && this.precision < 0) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (this.width == -1 && (this.f.contains(Flags.LEFT_JUSTIFY) || this.f.contains(Flags.ZERO_PAD))) {
                throw new MissingFormatWidthException(this.toString());
            }
            if (this.f.contains(Flags.PLUS) && this.f.contains(Flags.LEADING_SPACE) || this.f.contains(Flags.LEFT_JUSTIFY) && this.f.contains(Flags.ZERO_PAD)) {
                throw new IllegalFormatFlagsException(this.f.toString());
            }
        }

        private void checkText() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            switch (this.c) {
                case '%': {
                    if (this.f.valueOf() != Flags.LEFT_JUSTIFY.valueOf() && this.f.valueOf() != Flags.NONE.valueOf()) {
                        throw new IllegalFormatFlagsException(this.f.toString());
                    }
                    if (this.width != -1 || !this.f.contains(Flags.LEFT_JUSTIFY)) break;
                    throw new MissingFormatWidthException(this.toString());
                }
                case 'n': {
                    if (this.width != -1) {
                        throw new IllegalFormatWidthException(this.width);
                    }
                    if (this.f.valueOf() == Flags.NONE.valueOf()) break;
                    throw new IllegalFormatFlagsException(this.f.toString());
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void print(byte by, Locale locale) throws IOException {
            long l2 = by;
            if (by < 0 && (this.c == 'o' || this.c == 'x')) assert ((l2 += 256L) >= 0L) : l2;
            this.print(l2, locale);
        }

        private void print(short s2, Locale locale) throws IOException {
            long l2 = s2;
            if (s2 < 0 && (this.c == 'o' || this.c == 'x')) assert ((l2 += 65536L) >= 0L) : l2;
            this.print(l2, locale);
        }

        private void print(int n2, Locale locale) throws IOException {
            long l2 = n2;
            if (n2 < 0 && (this.c == 'o' || this.c == 'x')) assert ((l2 += 0x100000000L) >= 0L) : l2;
            this.print(l2, locale);
        }

        private void print(long l2, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.c == 'd') {
                boolean bl2 = l2 < 0L;
                char[] cArray = l2 < 0L ? Long.toString(l2, 10).substring(1).toCharArray() : Long.toString(l2, 10).toCharArray();
                this.leadingSign(stringBuilder, bl2);
                this.localizedMagnitude(stringBuilder, cArray, this.f, this.adjustWidth(this.width, this.f, bl2), locale);
                this.trailingSign(stringBuilder, bl2);
            } else if (this.c == 'o') {
                int n2;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String string = Long.toOctalString(l2);
                int n3 = n2 = this.f.contains(Flags.ALTERNATE) ? string.length() + 1 : string.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    stringBuilder.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i2 = 0; i2 < this.width - n2; ++i2) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string);
            } else if (this.c == 'x') {
                int n4;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String string = Long.toHexString(l2);
                int n5 = n4 = this.f.contains(Flags.ALTERNATE) ? string.length() + 2 : string.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i3 = 0; i3 < this.width - n4; ++i3) {
                        stringBuilder.append('0');
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    string = string.toUpperCase();
                }
                stringBuilder.append(string);
            }
            Formatter.this.a.append(this.justify(stringBuilder.toString()));
        }

        private StringBuilder leadingSign(StringBuilder stringBuilder, boolean bl2) {
            if (!bl2) {
                if (this.f.contains(Flags.PLUS)) {
                    stringBuilder.append('+');
                } else if (this.f.contains(Flags.LEADING_SPACE)) {
                    stringBuilder.append(' ');
                }
            } else if (this.f.contains(Flags.PARENTHESES)) {
                stringBuilder.append('(');
            } else {
                stringBuilder.append('-');
            }
            return stringBuilder;
        }

        private StringBuilder trailingSign(StringBuilder stringBuilder, boolean bl2) {
            if (bl2 && this.f.contains(Flags.PARENTHESES)) {
                stringBuilder.append(')');
            }
            return stringBuilder;
        }

        private void print(BigInteger bigInteger, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = bigInteger.signum() == -1;
            BigInteger bigInteger2 = bigInteger.abs();
            this.leadingSign(stringBuilder, bl2);
            if (this.c == 'd') {
                char[] cArray = bigInteger2.toString().toCharArray();
                this.localizedMagnitude(stringBuilder, cArray, this.f, this.adjustWidth(this.width, this.f, bl2), locale);
            } else if (this.c == 'o') {
                String string = bigInteger2.toString(8);
                int n2 = string.length() + stringBuilder.length();
                if (bl2 && this.f.contains(Flags.PARENTHESES)) {
                    ++n2;
                }
                if (this.f.contains(Flags.ALTERNATE)) {
                    ++n2;
                    stringBuilder.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i2 = 0; i2 < this.width - n2; ++i2) {
                        stringBuilder.append('0');
                    }
                }
                stringBuilder.append(string);
            } else if (this.c == 'x') {
                String string = bigInteger2.toString(16);
                int n3 = string.length() + stringBuilder.length();
                if (bl2 && this.f.contains(Flags.PARENTHESES)) {
                    ++n3;
                }
                if (this.f.contains(Flags.ALTERNATE)) {
                    n3 += 2;
                    stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i3 = 0; i3 < this.width - n3; ++i3) {
                        stringBuilder.append('0');
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    string = string.toUpperCase();
                }
                stringBuilder.append(string);
            }
            this.trailingSign(stringBuilder, bigInteger.signum() == -1);
            Formatter.this.a.append(this.justify(stringBuilder.toString()));
        }

        private void print(float f2, Locale locale) throws IOException {
            this.print((double)f2, locale);
        }

        private void print(double d2, Locale locale) throws IOException {
            boolean bl2;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = bl2 = Double.compare(d2, 0.0) == -1;
            if (!Double.isNaN(d2)) {
                double d3 = Math.abs(d2);
                this.leadingSign(stringBuilder, bl2);
                if (!Double.isInfinite(d3)) {
                    this.print(stringBuilder, d3, locale, this.f, this.c, this.precision, bl2);
                } else {
                    stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "INFINITY" : "Infinity");
                }
                this.trailingSign(stringBuilder, bl2);
            } else {
                stringBuilder.append(this.f.contains(Flags.UPPERCASE) ? "NAN" : "NaN");
            }
            Formatter.this.a.append(this.justify(stringBuilder.toString()));
        }

        private void print(StringBuilder stringBuilder, double d2, Locale locale, Flags flags, char c2, int n2, boolean bl2) throws IOException {
            if (c2 == 'e') {
                int n3 = n2 == -1 ? 6 : n2;
                FormattedFloatingDecimal formattedFloatingDecimal = new FormattedFloatingDecimal(d2, n3 + 1, FormattedFloatingDecimal.Form.SCIENTIFIC);
                char[] cArray = new char[19];
                int n4 = formattedFloatingDecimal.getChars(cArray);
                char[] cArray2 = this.addZeros(this.mantissa(cArray, n4), n3);
                if (flags.contains(Flags.ALTERNATE) && n3 == 0) {
                    cArray2 = this.addDot(cArray2);
                }
                char[] cArray3 = d2 == 0.0 ? new char[]{'+', '0', '0'} : this.exponent(cArray, n4);
                int n5 = this.width;
                if (this.width != -1) {
                    n5 = this.adjustWidth(this.width - cArray3.length - 1, flags, bl2);
                }
                this.localizedMagnitude(stringBuilder, cArray2, flags, n5, null);
                stringBuilder.append(flags.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                Flags flags2 = flags.dup().remove(Flags.GROUP);
                char c3 = cArray3[0];
                assert (c3 == '+' || c3 == '-');
                stringBuilder.append(c3);
                char[] cArray4 = new char[cArray3.length - 1];
                System.arraycopy(cArray3, 1, cArray4, 0, cArray3.length - 1);
                stringBuilder.append((CharSequence)this.localizedMagnitude(null, cArray4, flags2, -1, null));
            } else if (c2 == 'f') {
                int n6 = n2 == -1 ? 6 : n2;
                FormattedFloatingDecimal formattedFloatingDecimal = new FormattedFloatingDecimal(d2, n6, FormattedFloatingDecimal.Form.DECIMAL_FLOAT);
                char[] cArray = new char[19];
                int n7 = formattedFloatingDecimal.getChars(cArray);
                char[] cArray5 = this.addZeros(this.mantissa(cArray, n7), n6);
                if (flags.contains(Flags.ALTERNATE) && n6 == 0) {
                    cArray5 = this.addDot(cArray5);
                }
                int n8 = this.width;
                if (this.width != -1) {
                    n8 = this.adjustWidth(this.width, flags, bl2);
                }
                this.localizedMagnitude(stringBuilder, cArray5, flags, n8, locale);
            } else if (c2 == 'g') {
                int n9 = n2;
                if (n2 == -1) {
                    n9 = 6;
                } else if (n2 == 0) {
                    n9 = 1;
                }
                double d3 = 0.001;
                double d4 = 1.0E7;
                if (d2 == 0.0 || d2 >= d3 && d2 < d4) {
                    this.print(stringBuilder, d2, locale, flags, 'f', n9, bl2);
                } else {
                    this.print(stringBuilder, d2, locale, flags, 'e', n9, bl2);
                }
            } else if (c2 == 'a') {
                int n10;
                int n11 = n2;
                if (n2 == -1) {
                    n11 = 0;
                } else if (n2 == 0) {
                    n11 = 1;
                }
                String string = this.hexDouble(d2, n11);
                boolean bl3 = flags.contains(Flags.UPPERCASE);
                stringBuilder.append(bl3 ? "0X" : "0x");
                if (flags.contains(Flags.ZERO_PAD)) {
                    for (n10 = 0; n10 < this.width - string.length() - 2; ++n10) {
                        stringBuilder.append('0');
                    }
                }
                n10 = string.indexOf(112);
                char[] cArray = string.substring(0, n10).toCharArray();
                if (bl3) {
                    String string2 = new String(cArray);
                    string2 = string2.toUpperCase(Locale.US);
                    cArray = string2.toCharArray();
                }
                stringBuilder.append(n11 != 0 ? this.addZeros(cArray, n11) : cArray);
                stringBuilder.append(bl3 ? (char)'P' : 'p');
                stringBuilder.append(string.substring(n10 + 1));
            }
        }

        private char[] mantissa(char[] cArray, int n2) {
            int n3;
            for (n3 = 0; n3 < n2 && cArray[n3] != 'e'; ++n3) {
            }
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, 0, cArray2, 0, n3);
            return cArray2;
        }

        private char[] exponent(char[] cArray, int n2) {
            int n3;
            for (n3 = n2 - 1; n3 >= 0 && cArray[n3] != 'e'; --n3) {
            }
            char[] cArray2 = new char[n2 - n3 - 1];
            System.arraycopy(cArray, n3 + 1, cArray2, 0, n2 - n3 - 1);
            return cArray2;
        }

        private char[] addZeros(char[] cArray, int n2) {
            int n3;
            for (n3 = 0; n3 < cArray.length && cArray[n3] != '.'; ++n3) {
            }
            boolean bl2 = false;
            if (n3 == cArray.length) {
                bl2 = true;
            }
            int n4 = cArray.length - n3 - (bl2 ? 0 : 1);
            assert (n4 <= n2);
            if (n4 == n2) {
                return cArray;
            }
            char[] cArray2 = new char[cArray.length + n2 - n4 + (bl2 ? 1 : 0)];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            int n5 = cArray.length;
            if (bl2) {
                cArray2[cArray.length] = 46;
                ++n5;
            }
            for (int i2 = n5; i2 < cArray2.length; ++i2) {
                cArray2[i2] = 48;
            }
            return cArray2;
        }

        private String hexDouble(double d2, int n2) {
            long l2;
            double d3;
            boolean bl2;
            boolean bl3;
            if (!FpUtils.isFinite(d2) || d2 == 0.0 || n2 == 0 || n2 >= 13) {
                return Double.toHexString(d2).substring(2);
            }
            assert (n2 >= 1 && n2 <= 12);
            int n3 = FpUtils.getExponent(d2);
            boolean bl4 = bl3 = n3 == -1023;
            if (bl3) {
                scaleUp = FpUtils.scalb(1.0, 54);
                n3 = FpUtils.getExponent(d2 *= scaleUp);
                assert (n3 >= -1022 && n3 <= 1023) : n3;
            }
            int n4 = 1 + n2 * 4;
            int n5 = 53 - n4;
            assert (n5 >= 1 && n5 < 53);
            long l3 = Double.doubleToLongBits(d2);
            long l4 = (l3 & Long.MAX_VALUE) >> n5;
            long l5 = l3 & (-1L << n5 ^ 0xFFFFFFFFFFFFFFFFL);
            boolean bl5 = (l4 & 1L) == 0L;
            boolean bl6 = (1L << n5 - 1 & l5) != 0L;
            boolean bl7 = bl2 = n5 > 1 && ((1L << n5 - 1 ^ 0xFFFFFFFFFFFFFFFFL) & l5) != 0L;
            if (bl5 && bl6 && bl2 || !bl5 && bl6) {
                ++l4;
            }
            if (Double.isInfinite(d3 = Double.longBitsToDouble(l4 = (l2 = l3 & Long.MIN_VALUE) | l4 << n5))) {
                return "1.0p1024";
            }
            String string = Double.toHexString(d3).substring(2);
            if (!bl3) {
                return string;
            }
            int n6 = string.indexOf(112);
            if (n6 == -1) {
                assert (false);
                return null;
            }
            String string2 = string.substring(n6 + 1);
            int n7 = Integer.parseInt(string2) - 54;
            return string.substring(0, n6) + "p" + Integer.toString(n7);
        }

        private void print(BigDecimal bigDecimal, Locale locale) throws IOException {
            if (this.c == 'a') {
                this.failConversion(this.c, bigDecimal);
            }
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl2 = bigDecimal.signum() == -1;
            BigDecimal bigDecimal2 = bigDecimal.abs();
            this.leadingSign(stringBuilder, bl2);
            this.print(stringBuilder, bigDecimal2, locale, this.f, this.c, this.precision, bl2);
            this.trailingSign(stringBuilder, bl2);
            Formatter.this.a.append(this.justify(stringBuilder.toString()));
        }

        private void print(StringBuilder stringBuilder, BigDecimal bigDecimal, Locale locale, Flags flags, char c2, int n2, boolean bl2) throws IOException {
            if (c2 == 'e') {
                int n3;
                int n4 = n2 == -1 ? 6 : n2;
                int n5 = bigDecimal.scale();
                int n6 = bigDecimal.precision();
                int n7 = 0;
                if (n4 > n6 - 1) {
                    n3 = n6;
                    n7 = n4 - (n6 - 1);
                } else {
                    n3 = n4 + 1;
                }
                MathContext mathContext = new MathContext(n3);
                BigDecimal bigDecimal2 = new BigDecimal(bigDecimal.unscaledValue(), n5, mathContext);
                BigDecimalLayout bigDecimalLayout = new BigDecimalLayout(bigDecimal2.unscaledValue(), bigDecimal2.scale(), BigDecimalLayout.Form.SCIENTIFIC);
                char[] cArray = bigDecimalLayout.mantissa();
                if (!(n6 != 1 && n5 != 0 || n7 <= 0 && !flags.contains(Flags.ALTERNATE))) {
                    cArray = this.addDot(cArray);
                }
                cArray = this.trailingZeros(cArray, n7);
                char[] cArray2 = bigDecimalLayout.exponent();
                int n8 = this.width;
                if (this.width != -1) {
                    n8 = this.adjustWidth(this.width - cArray2.length - 1, flags, bl2);
                }
                this.localizedMagnitude(stringBuilder, cArray, flags, n8, null);
                stringBuilder.append(flags.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                Flags flags2 = flags.dup().remove(Flags.GROUP);
                char c3 = cArray2[0];
                assert (c3 == '+' || c3 == '-');
                stringBuilder.append(cArray2[0]);
                char[] cArray3 = new char[cArray2.length - 1];
                System.arraycopy(cArray2, 1, cArray3, 0, cArray2.length - 1);
                stringBuilder.append((CharSequence)this.localizedMagnitude(null, cArray3, flags2, -1, null));
            } else if (c2 == 'f') {
                int n9;
                int n10 = n2 == -1 ? 6 : n2;
                int n11 = bigDecimal.scale();
                int n12 = bigDecimal.precision();
                int n13 = 0;
                if (n11 < n10) {
                    n9 = n12;
                    n13 = n10 - n11;
                } else {
                    n9 = n12 - (n11 - n10);
                }
                MathContext mathContext = new MathContext(n9);
                BigDecimal bigDecimal3 = new BigDecimal(bigDecimal.unscaledValue(), n11, mathContext);
                BigDecimalLayout bigDecimalLayout = new BigDecimalLayout(bigDecimal3.unscaledValue(), bigDecimal3.scale(), BigDecimalLayout.Form.DECIMAL_FLOAT);
                char[] cArray = bigDecimalLayout.mantissa();
                if (n11 == 0 && (flags.contains(Flags.ALTERNATE) || n13 > 0)) {
                    cArray = this.addDot(bigDecimalLayout.mantissa());
                }
                cArray = this.trailingZeros(cArray, n13);
                this.localizedMagnitude(stringBuilder, cArray, flags, this.adjustWidth(this.width, flags, bl2), locale);
            } else if (c2 == 'g') {
                int n14 = n2;
                if (n2 == -1) {
                    n14 = 6;
                } else if (n2 == 0) {
                    n14 = 1;
                }
                BigDecimal bigDecimal4 = BigDecimal.valueOf(1L, 3);
                BigDecimal bigDecimal5 = BigDecimal.valueOf(1L, -7);
                if (bigDecimal.equals(BigDecimal.ZERO) || bigDecimal.compareTo(bigDecimal4) != -1 && bigDecimal.compareTo(bigDecimal5) == -1) {
                    this.print(stringBuilder, bigDecimal, locale, flags, 'f', n14, bl2);
                } else {
                    this.print(stringBuilder, bigDecimal, locale, flags, 'e', n14, bl2);
                }
            } else if (c2 == 'a') assert (false);
        }

        private int adjustWidth(int n2, Flags flags, boolean bl2) {
            int n3 = n2;
            if (n3 != -1 && bl2 && flags.contains(Flags.PARENTHESES)) {
                --n3;
            }
            return n3;
        }

        private char[] addDot(char[] cArray) {
            char[] cArray2 = cArray;
            cArray2 = new char[cArray.length + 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            cArray2[cArray2.length - 1] = 46;
            return cArray2;
        }

        private char[] trailingZeros(char[] cArray, int n2) {
            char[] cArray2 = cArray;
            if (n2 > 0) {
                cArray2 = new char[cArray.length + n2];
                System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                for (int i2 = cArray.length; i2 < cArray2.length; ++i2) {
                    cArray2[i2] = 48;
                }
            }
            return cArray2;
        }

        private void print(Calendar calendar, char c2, Locale locale) throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            this.print(stringBuilder, calendar, c2, locale);
            String string = this.justify(stringBuilder.toString());
            if (this.f.contains(Flags.UPPERCASE)) {
                string = string.toUpperCase();
            }
            Formatter.this.a.append(string);
        }

        private Appendable print(StringBuilder stringBuilder, Calendar calendar, char c2, Locale locale) throws IOException {
            assert (this.width == -1);
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            switch (c2) {
                case 'H': 
                case 'I': 
                case 'k': 
                case 'l': {
                    int n2 = calendar.get(11);
                    if (c2 == 'I' || c2 == 'l') {
                        n2 = n2 == 0 ? 12 : n2 % 12;
                    }
                    Flags flags = c2 == 'H' || c2 == 'I' ? Flags.ZERO_PAD : Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n2, flags, 2, locale));
                    break;
                }
                case 'M': {
                    int n3 = calendar.get(12);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n3, flags, 2, locale));
                    break;
                }
                case 'N': {
                    int n4 = calendar.get(14) * 1000000;
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n4, flags, 9, locale));
                    break;
                }
                case 'L': {
                    int n5 = calendar.get(14);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n5, flags, 3, locale));
                    break;
                }
                case 'Q': {
                    long l2 = calendar.getTimeInMillis();
                    Flags flags = Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, l2, flags, this.width, locale));
                    break;
                }
                case 'P': 
                case 'p': {
                    Object object;
                    String[] stringArray = new String[]{"AM", "PM"};
                    if (locale != null && locale != Locale.US) {
                        object = new DateFormatSymbols(locale);
                        stringArray = ((DateFormatSymbols)object).getAmPmStrings();
                    }
                    object = stringArray[calendar.get(9)];
                    if (c2 == 'p') {
                        stringBuilder.append(((String)object).toLowerCase(locale != null ? locale : Locale.US));
                        break;
                    }
                    stringBuilder.append((String)object);
                    break;
                }
                case 's': {
                    long l3 = calendar.getTimeInMillis() / 1000L;
                    Flags flags = Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, l3, flags, this.width, locale));
                    break;
                }
                case 'S': {
                    int n6 = calendar.get(13);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n6, flags, 2, locale));
                    break;
                }
                case 'z': {
                    int n7 = calendar.get(15);
                    boolean bl2 = n7 < 0;
                    stringBuilder.append(bl2 ? (char)'-' : '+');
                    if (bl2) {
                        n7 = -n7;
                    }
                    int n8 = n7 / 60000;
                    int n9 = n8 / 60 * 100 + n8 % 60;
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n9, flags, 4, locale));
                    break;
                }
                case 'Z': {
                    TimeZone timeZone = calendar.getTimeZone();
                    stringBuilder.append(timeZone.getDisplayName(calendar.get(16) != 0, 0, locale));
                    break;
                }
                case 'A': 
                case 'a': {
                    int n10 = calendar.get(7);
                    Locale locale2 = locale == null ? Locale.US : locale;
                    DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale2);
                    if (c2 == 'A') {
                        stringBuilder.append(dateFormatSymbols.getWeekdays()[n10]);
                        break;
                    }
                    stringBuilder.append(dateFormatSymbols.getShortWeekdays()[n10]);
                    break;
                }
                case 'B': 
                case 'b': 
                case 'h': {
                    int n11 = calendar.get(2);
                    Locale locale3 = locale == null ? Locale.US : locale;
                    DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale3);
                    if (c2 == 'B') {
                        stringBuilder.append(dateFormatSymbols.getMonths()[n11]);
                        break;
                    }
                    stringBuilder.append(dateFormatSymbols.getShortMonths()[n11]);
                    break;
                }
                case 'C': 
                case 'Y': 
                case 'y': {
                    int n12 = calendar.get(1);
                    int n13 = 2;
                    switch (c2) {
                        case 'C': {
                            n12 /= 100;
                            break;
                        }
                        case 'y': {
                            n12 %= 100;
                            break;
                        }
                        case 'Y': {
                            n13 = 4;
                        }
                    }
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n12, flags, n13, locale));
                    break;
                }
                case 'd': 
                case 'e': {
                    int n14 = calendar.get(5);
                    Flags flags = c2 == 'd' ? Flags.ZERO_PAD : Flags.NONE;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n14, flags, 2, locale));
                    break;
                }
                case 'j': {
                    int n15 = calendar.get(6);
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n15, flags, 3, locale));
                    break;
                }
                case 'm': {
                    int n16 = calendar.get(2) + 1;
                    Flags flags = Flags.ZERO_PAD;
                    stringBuilder.append((CharSequence)this.localizedMagnitude(null, n16, flags, 2, locale));
                    break;
                }
                case 'R': 
                case 'T': {
                    char c3 = ':';
                    this.print(stringBuilder, calendar, 'H', locale).append(c3);
                    this.print(stringBuilder, calendar, 'M', locale);
                    if (c2 != 'T') break;
                    stringBuilder.append(c3);
                    this.print(stringBuilder, calendar, 'S', locale);
                    break;
                }
                case 'r': {
                    char c4 = ':';
                    this.print(stringBuilder, calendar, 'I', locale).append(c4);
                    this.print(stringBuilder, calendar, 'M', locale).append(c4);
                    this.print(stringBuilder, calendar, 'S', locale).append(' ');
                    this.print(stringBuilder, calendar, 'P', locale);
                    break;
                }
                case 'c': {
                    char c5 = ' ';
                    this.print(stringBuilder, calendar, 'a', locale).append(c5);
                    this.print(stringBuilder, calendar, 'b', locale).append(c5);
                    this.print(stringBuilder, calendar, 'd', locale).append(c5);
                    this.print(stringBuilder, calendar, 'T', locale).append(c5);
                    this.print(stringBuilder, calendar, 'Z', locale).append(c5);
                    this.print(stringBuilder, calendar, 'Y', locale);
                    break;
                }
                case 'D': {
                    char c6 = '/';
                    this.print(stringBuilder, calendar, 'm', locale).append(c6);
                    this.print(stringBuilder, calendar, 'd', locale).append(c6);
                    this.print(stringBuilder, calendar, 'y', locale);
                    break;
                }
                case 'F': {
                    char c7 = '-';
                    this.print(stringBuilder, calendar, 'Y', locale).append(c7);
                    this.print(stringBuilder, calendar, 'm', locale).append(c7);
                    this.print(stringBuilder, calendar, 'd', locale);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return stringBuilder;
        }

        private void failMismatch(Flags flags, char c2) {
            String string = flags.toString();
            throw new FormatFlagsConversionMismatchException(string, c2);
        }

        private void failConversion(char c2, Object object) {
            throw new IllegalFormatConversionException(c2, object.getClass());
        }

        private char getZero(Locale locale) {
            if (locale != null && !locale.equals(Formatter.this.locale())) {
                DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                return decimalFormatSymbols.getZeroDigit();
            }
            return Formatter.this.zero;
        }

        private StringBuilder localizedMagnitude(StringBuilder stringBuilder, long l2, Flags flags, int n2, Locale locale) {
            char[] cArray = Long.toString(l2, 10).toCharArray();
            return this.localizedMagnitude(stringBuilder, cArray, flags, n2, locale);
        }

        private StringBuilder localizedMagnitude(StringBuilder stringBuilder, char[] cArray, Flags flags, int n2, Locale locale) {
            int n3;
            int n4;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            int n5 = stringBuilder.length();
            char c2 = this.getZero(locale);
            char c3 = '\u0000';
            int n6 = -1;
            char c4 = '\u0000';
            int n7 = n4 = cArray.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (cArray[n3] != '.') continue;
                n7 = n3;
                break;
            }
            if (n7 < n4) {
                if (locale == null || locale.equals(Locale.US)) {
                    c4 = '.';
                } else {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                    c4 = decimalFormatSymbols.getDecimalSeparator();
                }
            }
            if (flags.contains(Flags.GROUP)) {
                if (locale == null || locale.equals(Locale.US)) {
                    c3 = ',';
                    n6 = 3;
                } else {
                    DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
                    c3 = decimalFormatSymbols.getGroupingSeparator();
                    DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getIntegerInstance(locale);
                    n6 = decimalFormat.getGroupingSize();
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                if (n3 == n7) {
                    stringBuilder.append(c4);
                    c3 = '\u0000';
                    continue;
                }
                char c5 = cArray[n3];
                stringBuilder.append((char)(c5 - 48 + c2));
                if (c3 == '\u0000' || n3 == n7 - 1 || (n7 - n3) % n6 != 1) continue;
                stringBuilder.append(c3);
            }
            n4 = stringBuilder.length();
            if (n2 != -1 && flags.contains(Flags.ZERO_PAD)) {
                for (n3 = 0; n3 < n2 - n4; ++n3) {
                    stringBuilder.insert(n5, c2);
                }
            }
            return stringBuilder;
        }

        private class BigDecimalLayout {
            private StringBuilder mant;
            private StringBuilder exp;

            public BigDecimalLayout(BigInteger bigInteger, int n2, Form form) {
                this.layout(bigInteger, n2, form);
            }

            public char[] layoutChars() {
                StringBuilder stringBuilder = new StringBuilder(this.mant);
                if (this.exp != null) {
                    stringBuilder.append('E');
                    stringBuilder.append((CharSequence)this.exp);
                }
                return this.toCharArray(stringBuilder);
            }

            public char[] mantissa() {
                return this.toCharArray(this.mant);
            }

            public char[] exponent() {
                return this.toCharArray(this.exp);
            }

            private char[] toCharArray(StringBuilder stringBuilder) {
                if (stringBuilder == null) {
                    return null;
                }
                char[] cArray = new char[stringBuilder.length()];
                stringBuilder.getChars(0, cArray.length, cArray, 0);
                return cArray;
            }

            private void layout(BigInteger bigInteger, int n2, Form form) {
                char[] cArray = bigInteger.toString().toCharArray();
                this.mant = new StringBuilder(cArray.length + 14);
                if (n2 == 0) {
                    this.mant.append(bigInteger.toString());
                    if (form == Form.SCIENTIFIC) {
                        this.exp = new StringBuilder("+00");
                    }
                    return;
                }
                long l2 = -((long)n2) + (long)(cArray.length - 1);
                if (form == Form.DECIMAL_FLOAT) {
                    int n3 = n2 - cArray.length;
                    if (n3 >= 0) {
                        this.mant.append("0.");
                        while (n3 > 0) {
                            this.mant.append('0');
                            --n3;
                        }
                        this.mant.append(cArray);
                    } else {
                        this.mant.append(cArray, 0, -n3);
                        this.mant.append('.');
                        this.mant.append(cArray, -n3, n2);
                    }
                } else {
                    this.mant.append(cArray[0]);
                    if (cArray.length > 1) {
                        this.mant.append('.');
                        this.mant.append(cArray, 1, cArray.length - 1);
                    }
                    this.exp = new StringBuilder();
                    if (l2 != 0L) {
                        long l3 = Math.abs(l2);
                        this.exp.append(l2 < 0L ? (char)'-' : '+');
                        if (l3 < 10L) {
                            this.exp.append('0');
                        }
                        this.exp.append(l3);
                    } else {
                        this.exp.append("+00");
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static enum Form {
                SCIENTIFIC,
                DECIMAL_FLOAT;

            }
        }
    }

    private static interface FormatString {
        public int index();

        public void print(Object var1, Locale var2) throws IOException;

        public String toString();
    }
}

