/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JumboEnumSet<E extends Enum<E>>
extends EnumSet<E> {
    private long[] elements;
    private int size = 0;

    JumboEnumSet(Class<E> clazz, Enum[] enumArray) {
        super(clazz, enumArray);
        this.elements = new long[enumArray.length + 63 >>> 6];
    }

    @Override
    void addRange(E e2, E e3) {
        int n2;
        int n3 = ((Enum)e2).ordinal() >>> 6;
        if (n3 == (n2 = ((Enum)e3).ordinal() >>> 6)) {
            this.elements[n3] = -1L >>> ((Enum)e2).ordinal() - ((Enum)e3).ordinal() - 1 << ((Enum)e2).ordinal();
        } else {
            this.elements[n3] = -1L << ((Enum)e2).ordinal();
            for (int i2 = n3 + 1; i2 < n2; ++i2) {
                this.elements[i2] = -1L;
            }
            this.elements[n2] = -1L >>> 63 - ((Enum)e3).ordinal();
        }
        this.size = ((Enum)e3).ordinal() - ((Enum)e2).ordinal() + 1;
    }

    @Override
    void addAll() {
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            this.elements[i2] = -1L;
        }
        int n2 = this.elements.length - 1;
        this.elements[n2] = this.elements[n2] >>> -this.universe.length;
        this.size = this.universe.length;
    }

    @Override
    void complement() {
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            this.elements[i2] = this.elements[i2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = this.elements.length - 1;
        this.elements[n2] = this.elements[n2] & -1L >>> -this.universe.length;
        this.size = this.universe.length - this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new EnumSetIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        Class<? extends Object> clazz = object.getClass();
        if (clazz != this.elementType && clazz.getSuperclass() != this.elementType) {
            return false;
        }
        int n2 = ((Enum)object).ordinal();
        return (this.elements[n2 >>> 6] & 1L << n2) != 0L;
    }

    @Override
    public boolean add(E e2) {
        boolean bl2;
        int n2 = ((Enum)e2).ordinal();
        int n3 = n2 >>> 6;
        long l2 = this.elements[n3];
        int n4 = n3;
        this.elements[n4] = this.elements[n4] | 1L << n2;
        boolean bl3 = bl2 = this.elements[n3] != l2;
        if (bl2) {
            ++this.size;
        }
        return bl2;
    }

    @Override
    public boolean remove(Object object) {
        boolean bl2;
        if (object == null) {
            return false;
        }
        Class<? extends Object> clazz = object.getClass();
        if (clazz != this.elementType && clazz.getSuperclass() != this.elementType) {
            return false;
        }
        int n2 = ((Enum)object).ordinal();
        int n3 = n2 >>> 6;
        long l2 = this.elements[n3];
        int n4 = n3;
        this.elements[n4] = this.elements[n4] & (1L << n2 ^ 0xFFFFFFFFFFFFFFFFL);
        boolean bl3 = bl2 = this.elements[n3] != l2;
        if (bl2) {
            --this.size;
        }
        return bl2;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (!(collection instanceof JumboEnumSet)) {
            return super.containsAll(collection);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)collection;
        if (jumboEnumSet.elementType != this.elementType) {
            return jumboEnumSet.isEmpty();
        }
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            if ((jumboEnumSet.elements[i2] & (this.elements[i2] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (!(collection instanceof JumboEnumSet)) {
            return super.addAll(collection);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)collection;
        if (jumboEnumSet.elementType != this.elementType) {
            if (jumboEnumSet.isEmpty()) {
                return false;
            }
            throw new ClassCastException(jumboEnumSet.elementType + " != " + this.elementType);
        }
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            int n2 = i2;
            this.elements[n2] = this.elements[n2] | jumboEnumSet.elements[i2];
        }
        return this.recalculateSize();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        if (!(collection instanceof JumboEnumSet)) {
            return super.removeAll(collection);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)collection;
        if (jumboEnumSet.elementType != this.elementType) {
            return false;
        }
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            int n2 = i2;
            this.elements[n2] = this.elements[n2] & (jumboEnumSet.elements[i2] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return this.recalculateSize();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        if (!(collection instanceof JumboEnumSet)) {
            return super.retainAll(collection);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)collection;
        if (jumboEnumSet.elementType != this.elementType) {
            this.clear();
            return true;
        }
        for (int i2 = 0; i2 < this.elements.length; ++i2) {
            int n2 = i2;
            this.elements[n2] = this.elements[n2] & jumboEnumSet.elements[i2];
        }
        return this.recalculateSize();
    }

    @Override
    public void clear() {
        Arrays.fill(this.elements, 0L);
        this.size = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof JumboEnumSet)) {
            return super.equals(object);
        }
        JumboEnumSet jumboEnumSet = (JumboEnumSet)object;
        if (jumboEnumSet.elementType != this.elementType) {
            return this.size == 0 && jumboEnumSet.size == 0;
        }
        return Arrays.equals(jumboEnumSet.elements, this.elements);
    }

    private boolean recalculateSize() {
        int n2 = this.size;
        this.size = 0;
        for (long l2 : this.elements) {
            this.size += Long.bitCount(l2);
        }
        return this.size != n2;
    }

    @Override
    public EnumSet<E> clone() {
        JumboEnumSet jumboEnumSet = (JumboEnumSet)super.clone();
        jumboEnumSet.elements = (long[])jumboEnumSet.elements.clone();
        return jumboEnumSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnumSetIterator<E extends Enum<E>>
    implements Iterator<E> {
        long unseen;
        int unseenIndex = 0;
        long lastReturned = 0L;
        int lastReturnedIndex = 0;

        EnumSetIterator() {
            this.unseen = JumboEnumSet.this.elements[0];
        }

        @Override
        public boolean hasNext() {
            while (this.unseen == 0L && this.unseenIndex < JumboEnumSet.this.elements.length - 1) {
                this.unseen = JumboEnumSet.this.elements[++this.unseenIndex];
            }
            return this.unseen != 0L;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.unseen & -this.unseen;
            this.lastReturnedIndex = this.unseenIndex;
            this.unseen -= this.lastReturned;
            return (E)JumboEnumSet.this.universe[(this.lastReturnedIndex << 6) + Long.numberOfTrailingZeros(this.lastReturned)];
        }

        @Override
        public void remove() {
            if (this.lastReturned == 0L) {
                throw new IllegalStateException();
            }
            long[] lArray = JumboEnumSet.this.elements;
            int n2 = this.lastReturnedIndex;
            lArray[n2] = lArray[n2] - this.lastReturned;
            JumboEnumSet.this.size--;
            this.lastReturned = 0L;
        }
    }
}

