/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.InvalidPropertiesFormatException;
import java.util.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Properties
extends Hashtable<Object, Object> {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Properties() {
        this((Properties)null);
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    public synchronized Object setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        int n2;
        char[] cArray = new char[1024];
        LineReader lineReader = new LineReader(inputStream);
        while ((n2 = lineReader.readLine()) >= 0) {
            int n3;
            char c2 = '\u0000';
            int n4 = n2;
            boolean bl2 = false;
            boolean bl3 = false;
            for (n3 = 0; n3 < n2; ++n3) {
                c2 = lineReader.lineBuf[n3];
                if (!(c2 != '=' && c2 != ':' || bl3)) {
                    n4 = n3 + 1;
                    bl2 = true;
                    break;
                }
                if (!(c2 != ' ' && c2 != '\t' && c2 != '\f' || bl3)) {
                    n4 = n3 + 1;
                    break;
                }
                bl3 = c2 == '\\' ? !bl3 : false;
            }
            while (n4 < n2) {
                c2 = lineReader.lineBuf[n4];
                if (c2 != ' ' && c2 != '\t' && c2 != '\f') {
                    if (bl2 || c2 != '=' && c2 != ':') break;
                    bl2 = true;
                }
                ++n4;
            }
            String string = this.loadConvert(lineReader.lineBuf, 0, n3, cArray);
            String string2 = this.loadConvert(lineReader.lineBuf, n4, n2 - n4, cArray);
            this.put(string, string2);
        }
    }

    private String loadConvert(char[] cArray, int n2, int n3, char[] cArray2) {
        int n4;
        if (cArray2.length < n3) {
            n4 = n3 * 2;
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            cArray2 = new char[n4];
        }
        char[] cArray3 = cArray2;
        int n5 = 0;
        int n6 = n2 + n3;
        while (n2 < n6) {
            if ((n4 = cArray[n2++]) == 92) {
                if ((n4 = cArray[n2++]) == 117) {
                    int n7 = 0;
                    block6: for (int i2 = 0; i2 < 4; ++i2) {
                        n4 = cArray[n2++];
                        switch (n4) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n7 = (n7 << 4) + n4 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n7 = (n7 << 4) + 10 + n4 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n7 = (n7 << 4) + 10 + n4 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    cArray3[n5++] = (char)n7;
                    continue;
                }
                if (n4 == 116) {
                    n4 = 9;
                } else if (n4 == 114) {
                    n4 = 13;
                } else if (n4 == 110) {
                    n4 = 10;
                } else if (n4 == 102) {
                    n4 = 12;
                }
                cArray3[n5++] = n4;
                continue;
            }
            cArray3[n5++] = n4;
        }
        return new String(cArray3, 0, n5);
    }

    private String saveConvert(String string, boolean bl2) {
        int n2 = string.length();
        int n3 = n2 * 2;
        if (n3 < 0) {
            n3 = Integer.MAX_VALUE;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '=' && c2 < '\u007f') {
                if (c2 == '\\') {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            switch (c2) {
                case ' ': {
                    if (i2 == 0 || bl2) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    stringBuffer.append('\\');
                    stringBuffer.append(c2);
                    continue block8;
                }
                default: {
                    if (c2 < ' ' || c2 > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(Properties.toHex(c2 >> 12 & 0xF));
                        stringBuffer.append(Properties.toHex(c2 >> 8 & 0xF));
                        stringBuffer.append(Properties.toHex(c2 >> 4 & 0xF));
                        stringBuffer.append(Properties.toHex(c2 & 0xF));
                        continue block8;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public synchronized void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            Properties.writeln(bufferedWriter, "#" + string);
        }
        Properties.writeln(bufferedWriter, "#" + new Date().toString());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.get(string2);
            string2 = this.saveConvert(string2, true);
            string3 = this.saveConvert(string3, false);
            Properties.writeln(bufferedWriter, string2 + "=" + string3);
        }
        bufferedWriter.flush();
    }

    private static void writeln(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    public synchronized void loadFromXML(InputStream inputStream) throws IOException, InvalidPropertiesFormatException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        XMLUtils.load(this, inputStream);
    }

    public synchronized void storeToXML(OutputStream outputStream, String string) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        this.storeToXML(outputStream, string, "UTF-8");
    }

    public synchronized void storeToXML(OutputStream outputStream, String string, String string2) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        XMLUtils.save(this, outputStream, string, string2);
    }

    public String getProperty(String string) {
        Object v2 = super.get(string);
        String string2 = v2 instanceof String ? (String)v2 : null;
        return string2 == null && this.defaults != null ? this.defaults.getProperty(string) : string2;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    public Enumeration<?> propertyNames() {
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        return hashtable.keys();
    }

    public void list(PrintStream printStream) {
        printStream.println("-- listing properties --");
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2.length() > 40) {
                string2 = string2.substring(0, 37) + "...";
            }
            printStream.println(string + "=" + string2);
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.println("-- listing properties --");
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2.length() > 40) {
                string2 = string2.substring(0, 37) + "...";
            }
            printWriter.println(string + "=" + string2);
        }
    }

    private synchronized void enumerate(Hashtable hashtable) {
        if (this.defaults != null) {
            this.defaults.enumerate(hashtable);
        }
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, this.get(string));
        }
    }

    private static char toHex(int n2) {
        return hexDigit[n2 & 0xF];
    }

    class LineReader {
        byte[] inBuf = new byte[8192];
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;

        public LineReader(InputStream inputStream) {
            this.inStream = inputStream;
        }

        int readLine() throws IOException {
            int n2 = 0;
            char c2 = '\u0000';
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = true;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (n2 == 0 || bl3) {
                            return -1;
                        }
                        return n2;
                    }
                }
                c2 = (char)(0xFF & this.inBuf[this.inOff++]);
                if (bl7) {
                    bl7 = false;
                    if (c2 == '\n') continue;
                }
                if (bl2) {
                    if (c2 == ' ' || c2 == '\t' || c2 == '\f' || !bl5 && (c2 == '\r' || c2 == '\n')) continue;
                    bl2 = false;
                    bl5 = false;
                }
                if (bl4) {
                    bl4 = false;
                    if (c2 == '#' || c2 == '!') {
                        bl3 = true;
                        continue;
                    }
                }
                if (c2 != '\n' && c2 != '\r') {
                    this.lineBuf[n2++] = c2;
                    if (n2 == this.lineBuf.length) {
                        int n3 = this.lineBuf.length * 2;
                        if (n3 < 0) {
                            n3 = Integer.MAX_VALUE;
                        }
                        char[] cArray = new char[n3];
                        System.arraycopy(this.lineBuf, 0, cArray, 0, this.lineBuf.length);
                        this.lineBuf = cArray;
                    }
                    if (c2 == '\\') {
                        bl6 = !bl6;
                        continue;
                    }
                    bl6 = false;
                    continue;
                }
                if (bl3 || n2 == 0) {
                    bl3 = false;
                    bl4 = true;
                    bl2 = true;
                    n2 = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return n2;
                    }
                }
                if (!bl6) break;
                --n2;
                bl2 = true;
                bl5 = true;
                bl6 = false;
                if (c2 != '\r') continue;
                bl7 = true;
            }
            return n2;
        }
    }
}

