/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.InvalidPropertiesFormatException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLUtils {
    private static final String PROPS_DTD_URI = "http://java.sun.com/dtd/properties.dtd";
    private static final String PROPS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for properties --><!ELEMENT properties ( comment?, entry* ) ><!ATTLIST properties version CDATA #FIXED \"1.0\"><!ELEMENT comment (#PCDATA) ><!ELEMENT entry (#PCDATA) ><!ATTLIST entry  key CDATA #REQUIRED>";
    private static final String EXTERNAL_XML_VERSION = "1.0";

    XMLUtils() {
    }

    static void load(Properties properties, InputStream inputStream) throws IOException, InvalidPropertiesFormatException {
        Document document = null;
        try {
            document = XMLUtils.getLoadingDoc(inputStream);
        }
        catch (SAXException sAXException) {
            throw new InvalidPropertiesFormatException(sAXException);
        }
        Element element = (Element)document.getChildNodes().item(1);
        String string = element.getAttribute("version");
        if (string.compareTo(EXTERNAL_XML_VERSION) > 0) {
            throw new InvalidPropertiesFormatException("Exported Properties file format version " + string + " is not supported. This java installation can read" + " versions " + EXTERNAL_XML_VERSION + " or older. You" + " may need to install a newer version of JDK.");
        }
        XMLUtils.importProperties(properties, element);
    }

    static Document getLoadingDoc(InputStream inputStream) throws SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setIgnoringComments(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new Resolver());
            documentBuilder.setErrorHandler(new EH());
            InputSource inputSource = new InputSource(inputStream);
            return documentBuilder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Error(parserConfigurationException);
        }
    }

    static void importProperties(Properties properties, Element element) {
        int n2;
        int n3;
        for (int i2 = n2 = (n3 = (nodeList = element.getChildNodes()).getLength()) > 0 && nodeList.item(0).getNodeName().equals("comment") ? 1 : 0; i2 < n3; ++i2) {
            NodeList nodeList;
            Element element2 = (Element)nodeList.item(i2);
            if (!element2.hasAttribute("key")) continue;
            properties.setProperty(element2.getAttribute("key"), element2.getFirstChild().getNodeValue());
        }
    }

    static void save(Properties properties, OutputStream outputStream, String string, String string2) throws IOException {
        Object object;
        DocumentBuilder documentBuilder;
        block4: {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = null;
            try {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        Document document = documentBuilder.newDocument();
        Element element = (Element)document.appendChild(document.createElement("properties"));
        if (string != null) {
            object = (Element)element.appendChild(document.createElement("comment"));
            object.appendChild(document.createTextNode(string));
        }
        object = properties.keySet();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Element element2 = (Element)element.appendChild(document.createElement("entry"));
            element2.setAttribute("key", string3);
            element2.appendChild(document.createTextNode(properties.getProperty(string3)));
        }
        XMLUtils.emitDocument(document, outputStream, string2);
    }

    static void emitDocument(Document document, OutputStream outputStream, String string) throws IOException {
        Transformer transformer;
        block4: {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformer = null;
            try {
                transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("doctype-system", PROPS_DTD_URI);
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", string);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        try {
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            IOException iOException = new IOException();
            iOException.initCause(transformerException);
            throw iOException;
        }
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (string2.equals(XMLUtils.PROPS_DTD_URI)) {
                InputSource inputSource = new InputSource(new StringReader(XMLUtils.PROPS_DTD));
                inputSource.setSystemId(XMLUtils.PROPS_DTD_URI);
                return inputSource;
            }
            throw new SAXException("Invalid system identifier: " + string2);
        }
    }
}

