/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExecutorService
implements ExecutorService {
    @Override
    public Future<?> submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        FutureTask<Object> futureTask = new FutureTask<Object>(runnable, null);
        this.execute(futureTask);
        return futureTask;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t2) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        FutureTask<T> futureTask = new FutureTask<T>(runnable, t2);
        this.execute(futureTask);
        return futureTask;
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        FutureTask<T> futureTask = new FutureTask<T>(callable);
        this.execute(futureTask);
        return futureTask;
    }

    private <T> T doInvokeAny(Collection<Callable<T>> collection, boolean bl2, long l2) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException executionException;
        ArrayList arrayList;
        block18: {
            if (collection == null) {
                throw new NullPointerException();
            }
            int n2 = collection.size();
            if (n2 == 0) {
                throw new IllegalArgumentException();
            }
            arrayList = new ArrayList(n2);
            ExecutorCompletionService<T> executorCompletionService = new ExecutorCompletionService<T>(this);
            executionException = null;
            long l3 = bl2 ? System.nanoTime() : 0L;
            Iterator<Callable<T>> iterator = collection.iterator();
            arrayList.add(executorCompletionService.submit(iterator.next()));
            --n2;
            int n3 = 1;
            while (true) {
                Object v2;
                Future future;
                if ((future = executorCompletionService.poll()) == null) {
                    if (n2 > 0) {
                        --n2;
                        arrayList.add(executorCompletionService.submit(iterator.next()));
                        ++n3;
                    } else {
                        if (n3 == 0) break;
                        if (bl2) {
                            future = executorCompletionService.poll(l2, TimeUnit.NANOSECONDS);
                            if (future == null) {
                                throw new TimeoutException();
                            }
                            long l4 = System.nanoTime();
                            l2 -= l4 - l3;
                            l3 = l4;
                        } else {
                            future = executorCompletionService.take();
                        }
                    }
                }
                if (future == null) continue;
                --n3;
                try {
                    v2 = future.get();
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (ExecutionException executionException2) {
                    executionException = executionException2;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    executionException = new ExecutionException(runtimeException);
                    continue;
                }
                return (T)v2;
                break;
            }
            if (executionException != null) break block18;
            executionException = new ExecutionException();
        }
        throw executionException;
        finally {
            for (Future future : arrayList) {
                future.cancel(true);
            }
        }
    }

    @Override
    public <T> T invokeAny(Collection<Callable<T>> collection) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(collection, false, 0L);
        }
        catch (TimeoutException timeoutException) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(collection, true, timeUnit.toNanos(l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> collection) throws InterruptedException {
        if (collection == null) {
            throw new NullPointerException();
        }
        ArrayList<FutureTask<T>> arrayList = new ArrayList<FutureTask<T>>(collection.size());
        boolean bl2 = false;
        try {
            for (Callable<T> object : collection) {
                FutureTask<T> futureTask = new FutureTask<T>(object);
                arrayList.add(futureTask);
                this.execute(futureTask);
            }
            for (Future future : arrayList) {
                if (future.isDone()) continue;
                try {
                    future.get();
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
            bl2 = true;
            ArrayList<FutureTask<T>> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (!bl2) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<Callable<T>> collection, long l2, TimeUnit timeUnit) throws InterruptedException {
        if (collection == null || timeUnit == null) {
            throw new NullPointerException();
        }
        long l3 = timeUnit.toNanos(l2);
        ArrayList<Future<T>> arrayList = new ArrayList<Future<T>>(collection.size());
        boolean bl2 = false;
        try {
            for (Callable<T> callable : collection) {
                arrayList.add(new FutureTask<T>(callable));
            }
            long l4 = System.nanoTime();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.execute((Runnable)iterator.next());
                long l5 = System.nanoTime();
                l4 = l5;
                if ((l3 -= l5 - l4) > 0L) continue;
                ArrayList<Future<T>> arrayList2 = arrayList;
                return arrayList2;
            }
            for (Future object : arrayList) {
                if (object.isDone()) continue;
                if (l3 <= 0L) {
                    ArrayList<Future<T>> arrayList3 = arrayList;
                    return arrayList3;
                }
                try {
                    object.get(l3, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    ArrayList<Future<T>> arrayList4 = arrayList;
                    if (!bl2) {
                        for (Future future : arrayList) {
                            future.cancel(true);
                        }
                    }
                    return arrayList4;
                }
                long l6 = System.nanoTime();
                l3 -= l6 - l4;
                l4 = l6;
            }
            bl2 = true;
            ArrayList<Future<T>> arrayList5 = arrayList;
            return arrayList5;
        }
        finally {
            if (!bl2) {
                for (Future future : arrayList) {
                    future.cancel(true);
                }
            }
        }
    }
}

