/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    static int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_SEGMENTS = 16;
    static final int MAX_SEGMENTS = 65536;
    static final int RETRIES_BEFORE_LOCK = 2;
    final int segmentMask;
    final int segmentShift;
    final Segment[] segments;
    transient Set<K> keySet;
    transient Set<Map.Entry<K, V>> entrySet;
    transient Collection<V> values;

    static int hash(Object object) {
        int n2 = object.hashCode();
        n2 += ~(n2 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2;
    }

    final Segment<K, V> segmentFor(int n2) {
        return this.segments[n2 >>> this.segmentShift & this.segmentMask];
    }

    public ConcurrentHashMap(int n2, float f2, int n3) {
        int n4;
        int n5;
        int n6;
        if (!(f2 > 0.0f) || n2 < 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n3 > 65536) {
            n3 = 65536;
        }
        int n7 = 0;
        for (n6 = 1; n6 < n3; n6 <<= 1) {
            ++n7;
        }
        this.segmentShift = 32 - n7;
        this.segmentMask = n6 - 1;
        this.segments = new Segment[n6];
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if ((n5 = n2 / n6) * n6 < n2) {
            ++n5;
        }
        for (n4 = 1; n4 < n5; n4 <<= 1) {
        }
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = new Segment(n4, f2);
        }
    }

    public ConcurrentHashMap(int n2) {
        this(n2, 0.75f, 16);
    }

    public ConcurrentHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f, 16);
    }

    public ConcurrentHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 11), 0.75f, 16);
        this.putAll(map);
    }

    @Override
    public boolean isEmpty() {
        int n2;
        Segment[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        int n3 = 0;
        for (n2 = 0; n2 < segmentArray.length; ++n2) {
            if (segmentArray[n2].count != 0) {
                return false;
            }
            nArray[n2] = segmentArray[n2].modCount;
            n3 += nArray[n2];
        }
        if (n3 != 0) {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                if (segmentArray[n2].count == 0 && nArray[n2] == segmentArray[n2].modCount) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int size() {
        int n2;
        Segment[] segmentArray = this.segments;
        long l2 = 0L;
        long l3 = 0L;
        int[] nArray = new int[segmentArray.length];
        for (n2 = 0; n2 < 2; ++n2) {
            int n3;
            l3 = 0L;
            l2 = 0L;
            int n4 = 0;
            for (n3 = 0; n3 < segmentArray.length; ++n3) {
                l2 += (long)segmentArray[n3].count;
                nArray[n3] = segmentArray[n3].modCount;
                n4 += nArray[n3];
            }
            if (n4 != 0) {
                for (n3 = 0; n3 < segmentArray.length; ++n3) {
                    l3 += (long)segmentArray[n3].count;
                    if (nArray[n3] == segmentArray[n3].modCount) continue;
                    l3 = -1L;
                    break;
                }
            }
            if (l3 == l2) break;
        }
        if (l3 != l2) {
            l2 = 0L;
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                segmentArray[n2].lock();
            }
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                l2 += (long)segmentArray[n2].count;
            }
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                segmentArray[n2].unlock();
            }
        }
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    @Override
    public V get(Object object) {
        int n2 = ConcurrentHashMap.hash(object);
        return this.segmentFor(n2).get(object, n2);
    }

    @Override
    public boolean containsKey(Object object) {
        int n2 = ConcurrentHashMap.hash(object);
        return this.segmentFor(n2).containsKey(object, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object object) {
        int n2;
        boolean bl2;
        if (object == null) {
            throw new NullPointerException();
        }
        Segment[] segmentArray = this.segments;
        int[] nArray = new int[segmentArray.length];
        for (bl2 = false; bl2 < 2 != 0; bl2 += 1) {
            int n3;
            int n4;
            n2 = 0;
            int n5 = 0;
            for (n4 = 0; n4 < segmentArray.length; ++n4) {
                n3 = segmentArray[n4].count;
                nArray[n4] = segmentArray[n4].modCount;
                n5 += nArray[n4];
                if (!segmentArray[n4].containsValue(object)) continue;
                return true;
            }
            n4 = 1;
            if (n5 != 0) {
                for (n3 = 0; n3 < segmentArray.length; ++n3) {
                    int n6 = segmentArray[n3].count;
                    if (nArray[n3] == segmentArray[n3].modCount) continue;
                    n4 = 0;
                    break;
                }
            }
            if (n4 == 0) continue;
            return false;
        }
        for (bl2 = false; bl2 < segmentArray.length; bl2 += 1) {
            segmentArray[bl2].lock();
        }
        bl2 = false;
        try {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                if (!segmentArray[n2].containsValue(object)) continue;
                bl2 = true;
                break;
            }
        }
        finally {
            for (n2 = 0; n2 < segmentArray.length; ++n2) {
                segmentArray[n2].unlock();
            }
        }
        return bl2;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public V put(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        int n2 = ConcurrentHashMap.hash(k2);
        return this.segmentFor(n2).put(k2, n2, v2, false);
    }

    @Override
    public V putIfAbsent(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        int n2 = ConcurrentHashMap.hash(k2);
        return this.segmentFor(n2).put(k2, n2, v2, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n2 = ConcurrentHashMap.hash(object);
        return this.segmentFor(n2).remove(object, n2, null);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        int n2 = ConcurrentHashMap.hash(object);
        return this.segmentFor(n2).remove(object, n2, object2) != null;
    }

    @Override
    public boolean replace(K k2, V v2, V v3) {
        if (v2 == null || v3 == null) {
            throw new NullPointerException();
        }
        int n2 = ConcurrentHashMap.hash(k2);
        return this.segmentFor(n2).replace(k2, n2, v2, v3);
    }

    @Override
    public V replace(K k2, V v2) {
        if (v2 == null) {
            throw new NullPointerException();
        }
        int n2 = ConcurrentHashMap.hash(k2);
        return this.segmentFor(n2).replace(k2, n2, v2);
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].clear();
        }
    }

    @Override
    public Object clone() {
        float f2 = this.segments[0].loadFactor;
        int n2 = this.segments.length;
        int n3 = (int)((float)this.size() / f2);
        if (n3 < n2) {
            n3 = n2;
        }
        ConcurrentHashMap<K, V> concurrentHashMap = new ConcurrentHashMap<K, V>(n3, f2, n2);
        concurrentHashMap.putAll(this);
        return concurrentHashMap;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    public Enumeration<K> keys() {
        return new KeyIterator();
    }

    public Enumeration<V> elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            Segment segment = this.segments[i2];
            segment.lock();
            try {
                HashEntry[] hashEntryArray = segment.table;
                for (int i3 = 0; i3 < hashEntryArray.length; ++i3) {
                    HashEntry hashEntry = hashEntryArray[i3];
                    while (hashEntry != null) {
                        objectOutputStream.writeObject(hashEntry.key);
                        objectOutputStream.writeObject(hashEntry.value);
                        hashEntry = hashEntry.next;
                    }
                }
                continue;
            }
            finally {
                segment.unlock();
            }
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2].setTable(new HashEntry[1]);
        }
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntryIterator
    extends HashIterator
    implements Map.Entry<K, V>,
    Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            this.nextEntry();
            return this;
        }

        @Override
        public K getKey() {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Entry was removed");
            }
            return this.lastReturned.key;
        }

        @Override
        public V getValue() {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Entry was removed");
            }
            return ConcurrentHashMap.this.get(this.lastReturned.key);
        }

        @Override
        public V setValue(V v2) {
            if (this.lastReturned == null) {
                throw new IllegalStateException("Entry was removed");
            }
            return ConcurrentHashMap.this.put(this.lastReturned.key, v2);
        }

        @Override
        public boolean equals(Object object) {
            if (this.lastReturned == null) {
                return super.equals(object);
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.eq(this.getKey(), entry.getKey()) && this.eq(this.getValue(), entry.getValue());
        }

        @Override
        public int hashCode() {
            if (this.lastReturned == null) {
                return super.hashCode();
            }
            Object k2 = this.getKey();
            Object v2 = this.getValue();
            return (k2 == null ? 0 : k2.hashCode()) ^ (v2 == null ? 0 : v2.hashCode());
        }

        public String toString() {
            if (this.lastReturned == null) {
                return super.toString();
            }
            return this.getKey() + "=" + this.getValue();
        }

        boolean eq(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object v2 = ConcurrentHashMap.this.get(entry.getKey());
            return v2 != null && v2.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentHashMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new SimpleEntry(iterator.next()));
            }
            return arrayList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            ArrayList arrayList = new ArrayList(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new SimpleEntry(iterator.next()));
            }
            return arrayList.toArray(TArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class HashEntry<K, V> {
        final K key;
        final int hash;
        volatile V value;
        final HashEntry<K, V> next;

        HashEntry(K k2, int n2, HashEntry<K, V> hashEntry, V v2) {
            this.key = k2;
            this.hash = n2;
            this.next = hashEntry;
            this.value = v2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class HashIterator {
        int nextSegmentIndex;
        int nextTableIndex;
        HashEntry[] currentTable;
        HashEntry<K, V> nextEntry;
        HashEntry<K, V> lastReturned;

        HashIterator() {
            this.nextSegmentIndex = ConcurrentHashMap.this.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        final void advance() {
            if (this.nextEntry != null && (this.nextEntry = this.nextEntry.next) != null) {
                return;
            }
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = this.currentTable[this.nextTableIndex--]) == null) continue;
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                Segment segment = ConcurrentHashMap.this.segments[this.nextSegmentIndex--];
                if (segment.count == 0) continue;
                this.currentTable = segment.table;
                for (int i2 = this.currentTable.length - 1; i2 >= 0; --i2) {
                    this.nextEntry = this.currentTable[i2];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = i2 - 1;
                    return;
                }
            }
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        HashEntry<K, V> nextEntry() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeyIterator
    extends HashIterator
    implements Iterator<K>,
    Enumeration<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return super.nextEntry().key;
        }

        @Override
        public K nextElement() {
            return super.nextEntry().key;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return ConcurrentHashMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Segment<K, V>
    extends ReentrantLock
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        volatile transient int count;
        transient int modCount;
        transient int threshold;
        volatile transient HashEntry[] table;
        final float loadFactor;

        Segment(int n2, float f2) {
            this.loadFactor = f2;
            this.setTable(new HashEntry[n2]);
        }

        void setTable(HashEntry[] hashEntryArray) {
            this.threshold = (int)((float)hashEntryArray.length * this.loadFactor);
            this.table = hashEntryArray;
        }

        HashEntry<K, V> getFirst(int n2) {
            HashEntry[] hashEntryArray = this.table;
            return hashEntryArray[n2 & hashEntryArray.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V readValueUnderLock(HashEntry<K, V> hashEntry) {
            this.lock();
            try {
                Object v2 = hashEntry.value;
                return v2;
            }
            finally {
                this.unlock();
            }
        }

        V get(Object object, int n2) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n2);
                while (hashEntry != null) {
                    if (hashEntry.hash == n2 && object.equals(hashEntry.key)) {
                        Object v2 = hashEntry.value;
                        if (v2 != null) {
                            return v2;
                        }
                        return this.readValueUnderLock(hashEntry);
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return null;
        }

        boolean containsKey(Object object, int n2) {
            if (this.count != 0) {
                HashEntry<K, V> hashEntry = this.getFirst(n2);
                while (hashEntry != null) {
                    if (hashEntry.hash == n2 && object.equals(hashEntry.key)) {
                        return true;
                    }
                    hashEntry = hashEntry.next;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        boolean containsValue(Object object) {
            if (this.count != 0) {
                for (HashEntry hashEntry : this.table) {
                    void hashEntry2;
                    while (hashEntry2 != null) {
                        Object v2 = hashEntry2.value;
                        if (v2 == null) {
                            v2 = this.readValueUnderLock((HashEntry<K, V>)hashEntry2);
                        }
                        if (object.equals(v2)) {
                            return true;
                        }
                        HashEntry hashEntry3 = hashEntry2.next;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean replace(K k2, int n2, V v2, V v3) {
            this.lock();
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n2);
                while (!(hashEntry == null || hashEntry.hash == n2 && k2.equals(hashEntry.key))) {
                    hashEntry = hashEntry.next;
                }
                boolean bl2 = false;
                if (hashEntry != null && v2.equals(hashEntry.value)) {
                    bl2 = true;
                    hashEntry.value = v3;
                }
                boolean bl3 = bl2;
                return bl3;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V replace(K k2, int n2, V v2) {
            this.lock();
            try {
                HashEntry<K, V> hashEntry = this.getFirst(n2);
                while (!(hashEntry == null || hashEntry.hash == n2 && k2.equals(hashEntry.key))) {
                    hashEntry = hashEntry.next;
                }
                V v3 = null;
                if (hashEntry != null) {
                    v3 = hashEntry.value;
                    hashEntry.value = v2;
                }
                V v4 = v3;
                return v4;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K k2, int n2, V v2, boolean bl2) {
            this.lock();
            try {
                V v3;
                HashEntry hashEntry;
                int n3 = this.count;
                if (n3++ > this.threshold) {
                    this.rehash();
                }
                HashEntry[] hashEntryArray = this.table;
                int n4 = n2 & hashEntryArray.length - 1;
                HashEntry hashEntry2 = hashEntry = hashEntryArray[n4];
                while (!(hashEntry2 == null || hashEntry2.hash == n2 && k2.equals(hashEntry2.key))) {
                    hashEntry2 = hashEntry2.next;
                }
                if (hashEntry2 != null) {
                    v3 = hashEntry2.value;
                    if (!bl2) {
                        hashEntry2.value = v2;
                    }
                } else {
                    v3 = null;
                    ++this.modCount;
                    hashEntryArray[n4] = new HashEntry(k2, n2, hashEntry, v2);
                    this.count = n3;
                }
                V v4 = v3;
                return v4;
            }
            finally {
                this.unlock();
            }
        }

        void rehash() {
            HashEntry[] hashEntryArray = this.table;
            int n2 = hashEntryArray.length;
            if (n2 >= 0x40000000) {
                return;
            }
            HashEntry[] hashEntryArray2 = new HashEntry[n2 << 1];
            this.threshold = (int)((float)hashEntryArray2.length * this.loadFactor);
            int n3 = hashEntryArray2.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4;
                HashEntry hashEntry = hashEntryArray[i2];
                if (hashEntry == null) continue;
                HashEntry hashEntry2 = hashEntry.next;
                int n5 = hashEntry.hash & n3;
                if (hashEntry2 == null) {
                    hashEntryArray2[n5] = hashEntry;
                    continue;
                }
                HashEntry hashEntry3 = hashEntry;
                int n6 = n5;
                HashEntry hashEntry4 = hashEntry2;
                while (hashEntry4 != null) {
                    n4 = hashEntry4.hash & n3;
                    if (n4 != n6) {
                        n6 = n4;
                        hashEntry3 = hashEntry4;
                    }
                    hashEntry4 = hashEntry4.next;
                }
                hashEntryArray2[n6] = hashEntry3;
                hashEntry4 = hashEntry;
                while (hashEntry4 != hashEntry3) {
                    n4 = hashEntry4.hash & n3;
                    HashEntry hashEntry5 = hashEntryArray2[n4];
                    hashEntryArray2[n4] = new HashEntry(hashEntry4.key, hashEntry4.hash, hashEntry5, hashEntry4.value);
                    hashEntry4 = hashEntry4.next;
                }
            }
            this.table = hashEntryArray2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V remove(Object object, int n2, Object object2) {
            this.lock();
            try {
                V v2;
                HashEntry hashEntry;
                int n3 = this.count - 1;
                HashEntry[] hashEntryArray = this.table;
                int n4 = n2 & hashEntryArray.length - 1;
                HashEntry hashEntry2 = hashEntry = hashEntryArray[n4];
                while (!(hashEntry2 == null || hashEntry2.hash == n2 && object.equals(hashEntry2.key))) {
                    hashEntry2 = hashEntry2.next;
                }
                V v3 = null;
                if (hashEntry2 != null) {
                    v2 = hashEntry2.value;
                    if (object2 == null || object2.equals(v2)) {
                        v3 = v2;
                        ++this.modCount;
                        HashEntry hashEntry3 = hashEntry2.next;
                        HashEntry hashEntry4 = hashEntry;
                        while (hashEntry4 != hashEntry2) {
                            hashEntry3 = new HashEntry(hashEntry4.key, hashEntry4.hash, hashEntry3, hashEntry4.value);
                            hashEntry4 = hashEntry4.next;
                        }
                        hashEntryArray[n4] = hashEntry3;
                        this.count = n3;
                    }
                }
                v2 = v3;
                return v2;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    HashEntry[] hashEntryArray = this.table;
                    for (int i2 = 0; i2 < hashEntryArray.length; ++i2) {
                        hashEntryArray[i2] = null;
                    }
                    ++this.modCount;
                    this.count = 0;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        public SimpleEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        public SimpleEntry(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        static boolean eq(Object object, Object object2) {
            return object == null ? object2 == null : object.equals(object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ValueIterator
    extends HashIterator
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return super.nextEntry().value;
        }

        @Override
        public V nextElement() {
            return super.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }
}

