/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private static final Integer INTEGER_ZERO = new Integer(0);
    private Number[] threshold = new Number[16];
    private Number modulus = INTEGER_ZERO;
    private Number offset = INTEGER_ZERO;
    private boolean notify = false;
    private boolean differenceMode = false;
    private Number initThreshold = INTEGER_ZERO;
    private Number[] derivedGauge = new Number[16];
    private long[] derivedGaugeTimestamp = new long[16];
    private Number[] previousScanCounter = new Number[16];
    private boolean[] modulusExceeded = new boolean[16];
    private Number[] derivedGaugeExceeded = new Number[16];
    private boolean[] eventAlreadyNotified = new boolean[16];
    private int[] type = new int[16];
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private Timer timer = null;

    String makeDebugTag() {
        return "CounterMonitor";
    }

    public CounterMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDeregister() throws Exception {
        super.preDeregister();
        if (CounterMonitor.isTraceOn()) {
            this.trace("preDeregister", "reset the threshold values");
        }
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.threshold[i2] = this.initThreshold;
            }
        }
    }

    public synchronized void start() {
        if (CounterMonitor.isTraceOn()) {
            this.trace("start", "start the counter monitor");
        }
        if (this.isActive()) {
            if (CounterMonitor.isTraceOn()) {
                this.trace("start", "the counter monitor is already activated");
            }
            return;
        }
        this.isActive = true;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.threshold[i2] = this.initThreshold;
            this.modulusExceeded[i2] = false;
            this.eventAlreadyNotified[i2] = false;
            this.previousScanCounter[i2] = null;
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
    }

    public synchronized void stop() {
        if (CounterMonitor.isTraceOn()) {
            this.trace("stop", "stop the counter monitor");
        }
        if (CounterMonitor.isTraceOn()) {
            this.trace("stop", "the counter monitor is not started");
            return;
        }
        this.isActive = false;
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public synchronized void setGranularityPeriod(long l2) throws IllegalArgumentException {
        super.setGranularityPeriod(l2);
        if (this.isActive()) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public synchronized Number getDerivedGauge(ObjectName objectName) {
        int n2 = this.indexOf(objectName);
        if (n2 != -1) {
            return this.derivedGauge[n2];
        }
        return null;
    }

    public synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
        int n2 = this.indexOf(objectName);
        if (n2 != -1) {
            return this.derivedGaugeTimestamp[n2];
        }
        return 0L;
    }

    public synchronized Number getThreshold(ObjectName objectName) {
        int n2 = this.indexOf(objectName);
        if (n2 != -1) {
            return this.threshold[n2];
        }
        return null;
    }

    public synchronized Number getInitThreshold() {
        return this.initThreshold;
    }

    public synchronized void setInitThreshold(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null threshold");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Negative threshold");
        }
        this.initThreshold = number;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.threshold[i2] = number;
            this.resetAlreadyNotified(i2, 16);
            this.modulusExceeded[i2] = false;
            this.eventAlreadyNotified[i2] = false;
        }
    }

    public synchronized Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public synchronized Number getThreshold() {
        return this.threshold[0];
    }

    public synchronized void setThreshold(Number number) throws IllegalArgumentException {
        this.setInitThreshold(number);
    }

    public synchronized Number getOffset() {
        return this.offset;
    }

    public synchronized void setOffset(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null offset");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Negative offset");
        }
        this.offset = number;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.resetAlreadyNotified(i2, 16);
        }
    }

    public synchronized Number getModulus() {
        return this.modulus;
    }

    public synchronized void setModulus(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("Null modulus");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("Negative modulus");
        }
        this.modulus = number;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.resetAlreadyNotified(i2, 16);
            this.modulusExceeded[i2] = false;
        }
    }

    public synchronized boolean getNotify() {
        return this.notify;
    }

    public synchronized void setNotify(boolean bl2) {
        this.notify = bl2;
    }

    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public synchronized void setDifferenceMode(boolean bl2) {
        this.differenceMode = bl2;
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.threshold[i2] = this.initThreshold;
            this.modulusExceeded[i2] = false;
            this.eventAlreadyNotified[i2] = false;
            this.previousScanCounter[i2] = null;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.monitor.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    private synchronized boolean updateDerivedGauge(Object object, int n2) {
        boolean bl2;
        this.derivedGaugeTimestamp[n2] = System.currentTimeMillis();
        if (this.differenceMode) {
            if (this.previousScanCounter[n2] != null) {
                this.setDerivedGaugeWithDifference((Number)object, null, n2);
                if (this.derivedGauge[n2].longValue() < 0L) {
                    if (this.modulus.longValue() > 0L) {
                        this.setDerivedGaugeWithDifference((Number)object, this.modulus, n2);
                    }
                    this.threshold[n2] = this.initThreshold;
                    this.eventAlreadyNotified[n2] = false;
                }
                bl2 = true;
            } else {
                bl2 = false;
            }
            this.previousScanCounter[n2] = (Number)object;
        } else {
            this.derivedGauge[n2] = (Number)object;
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotifications(int n2) {
        boolean bl2 = false;
        String string = null;
        long l2 = 0L;
        String string2 = null;
        Number number = null;
        Number number2 = null;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (!this.eventAlreadyNotified[n2]) {
                if (this.derivedGauge[n2].longValue() >= this.threshold[n2].longValue()) {
                    if (this.notify) {
                        bl2 = true;
                        string = "jmx.monitor.counter.threshold";
                        l2 = this.derivedGaugeTimestamp[n2];
                        string2 = "";
                        number = this.derivedGauge[n2];
                        number2 = this.threshold[n2];
                    }
                    if (!this.differenceMode) {
                        this.eventAlreadyNotified[n2] = true;
                    }
                }
            } else if (CounterMonitor.isTraceOn()) {
                this.trace("updateNotifications", "the notification:\n\tNotification observed object = " + this.getObservedObject(n2) + "\n\tNotification observed attribute = " + this.getObservedAttribute() + "\n\tNotification derived gauge = " + this.derivedGauge[n2] + "\nhas already been sent");
            }
        }
        if (bl2) {
            this.sendNotification(string, l2, string2, number, number2, n2);
        }
    }

    private synchronized void updateThreshold(int n2) {
        if (this.derivedGauge[n2].longValue() >= this.threshold[n2].longValue()) {
            if (this.offset.longValue() > 0L) {
                long l2;
                for (l2 = this.threshold[n2].longValue(); this.derivedGauge[n2].longValue() >= l2; l2 += this.offset.longValue()) {
                }
                switch (this.type[n2]) {
                    case 0: {
                        this.threshold[n2] = new Integer((int)l2);
                        break;
                    }
                    case 1: {
                        this.threshold[n2] = new Byte((byte)l2);
                        break;
                    }
                    case 2: {
                        this.threshold[n2] = new Short((short)l2);
                        break;
                    }
                    case 3: {
                        this.threshold[n2] = new Long(l2);
                        break;
                    }
                    default: {
                        if (!CounterMonitor.isDebugOn()) break;
                        this.debug("updateThreshold", "the threshold type is invalid");
                    }
                }
                if (!this.differenceMode && this.modulus.longValue() > 0L && this.threshold[n2].longValue() > this.modulus.longValue()) {
                    this.modulusExceeded[n2] = true;
                    this.derivedGaugeExceeded[n2] = this.derivedGauge[n2];
                }
                this.eventAlreadyNotified[n2] = false;
            } else {
                this.modulusExceeded[n2] = true;
                this.derivedGaugeExceeded[n2] = this.derivedGauge[n2];
            }
        }
    }

    private synchronized boolean isThresholdTypeValid(int n2) {
        switch (this.type[n2]) {
            case 0: {
                return !(!(this.threshold[n2] instanceof Integer) || this.offset != INTEGER_ZERO && !(this.offset instanceof Integer) || this.modulus != INTEGER_ZERO && !(this.modulus instanceof Integer));
            }
            case 1: {
                return !(!(this.threshold[n2] instanceof Byte) || this.offset != INTEGER_ZERO && !(this.offset instanceof Byte) || this.modulus != INTEGER_ZERO && !(this.modulus instanceof Byte));
            }
            case 2: {
                return !(!(this.threshold[n2] instanceof Short) || this.offset != INTEGER_ZERO && !(this.offset instanceof Short) || this.modulus != INTEGER_ZERO && !(this.modulus instanceof Short));
            }
            case 3: {
                return !(!(this.threshold[n2] instanceof Long) || this.offset != INTEGER_ZERO && !(this.offset instanceof Long) || this.modulus != INTEGER_ZERO && !(this.modulus instanceof Long));
            }
        }
        if (CounterMonitor.isDebugOn()) {
            this.debug("isThresholdTypeValid", "The threshold type is invalid");
        }
        return false;
    }

    private synchronized void setDerivedGaugeWithDifference(Number number, Number number2, int n2) {
        long l2 = number.longValue() - this.previousScanCounter[n2].longValue();
        if (number2 != null) {
            l2 += this.modulus.longValue();
        }
        switch (this.type[n2]) {
            case 0: {
                this.derivedGauge[n2] = new Integer((int)l2);
                break;
            }
            case 1: {
                this.derivedGauge[n2] = new Byte((byte)l2);
                break;
            }
            case 2: {
                this.derivedGauge[n2] = new Short((short)l2);
                break;
            }
            case 3: {
                this.derivedGauge[n2] = new Long(l2);
                break;
            }
            default: {
                if (!CounterMonitor.isDebugOn()) break;
                this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAlarmClock(int n2) {
        long l2 = 0L;
        String string = null;
        Number number = null;
        Object object = null;
        String string2 = null;
        CounterMonitor counterMonitor = this;
        synchronized (counterMonitor) {
            if (!this.isActive()) {
                return;
            }
            if (this.getObservedObject(n2) == null || this.getObservedAttribute() == null) {
                return;
            }
            try {
                object = this.server.getAttribute(this.getObservedObject(n2), this.getObservedAttribute());
                if (object == null) {
                    return;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (this.alreadyNotified(n2, 8)) {
                    return;
                }
                string2 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n2, 8);
                string = "The counter monitor must be registered in the MBean server.";
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.alreadyNotified(n2, 1)) {
                    return;
                }
                string2 = "jmx.monitor.error.mbean";
                this.setAlreadyNotified(n2, 1);
                string = "The observed object must be registered in the MBean server.";
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                if (this.alreadyNotified(n2, 2)) {
                    return;
                }
                string2 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n2, 2);
                string = "The observed attribute must be accessible in the observed object.";
            }
            catch (MBeanException mBeanException) {
                if (this.alreadyNotified(n2, 8)) {
                    return;
                }
                string2 = "jmx.monitor.error.runtime";
                this.setAlreadyNotified(n2, 8);
                string = mBeanException.getMessage();
            }
            catch (ReflectionException reflectionException) {
                if (this.alreadyNotified(n2, 2)) {
                    return;
                }
                string2 = "jmx.monitor.error.attribute";
                this.setAlreadyNotified(n2, 2);
                string = reflectionException.getMessage();
            }
            if (string == null) {
                if (object instanceof Integer) {
                    this.type[n2] = 0;
                } else if (object instanceof Byte) {
                    this.type[n2] = 1;
                } else if (object instanceof Short) {
                    this.type[n2] = 2;
                } else if (object instanceof Long) {
                    this.type[n2] = 3;
                } else {
                    if (this.alreadyNotified(n2, 4)) {
                        return;
                    }
                    string2 = "jmx.monitor.error.type";
                    this.setAlreadyNotified(n2, 4);
                    string = "The observed attribute type must be an integer type.";
                }
            }
            if (string == null && !this.isThresholdTypeValid(n2)) {
                if (this.alreadyNotified(n2, 16)) {
                    return;
                }
                string2 = "jmx.monitor.error.threshold";
                this.setAlreadyNotified(n2, 16);
                string = "The threshold, offset and modulus must be of the same type as the counter.";
            }
            if (string == null) {
                boolean bl2;
                this.resetAllAlreadyNotified(n2);
                if (this.modulusExceeded[n2] && this.derivedGauge[n2].longValue() < this.derivedGaugeExceeded[n2].longValue()) {
                    this.threshold[n2] = this.initThreshold;
                    this.modulusExceeded[n2] = false;
                    this.eventAlreadyNotified[n2] = false;
                }
                if (bl2 = this.updateDerivedGauge(object, n2)) {
                    this.updateNotifications(n2);
                    this.updateThreshold(n2);
                }
            } else {
                l2 = this.derivedGaugeTimestamp[n2];
                number = this.derivedGauge[n2];
                this.modulusExceeded[n2] = false;
                this.eventAlreadyNotified[n2] = false;
                this.previousScanCounter[n2] = null;
            }
        }
        if (string != null) {
            this.sendNotification(string2, l2, string, number, null, n2);
        }
    }

    synchronized void insertSpecificElementAt(int n2) {
        if (n2 != this.elementCount) {
            throw new Error("Internal error: index != elementCount");
        }
        if (this.elementCount >= this.threshold.length) {
            this.threshold = this.expandArray(this.threshold);
            this.derivedGauge = this.expandArray(this.derivedGauge);
            this.previousScanCounter = this.expandArray(this.previousScanCounter);
            this.derivedGaugeExceeded = this.expandArray(this.derivedGaugeExceeded);
            this.derivedGaugeTimestamp = this.expandArray(this.derivedGaugeTimestamp);
            this.modulusExceeded = this.expandArray(this.modulusExceeded);
            this.eventAlreadyNotified = this.expandArray(this.eventAlreadyNotified);
            this.type = this.expandArray(this.type);
        }
        this.threshold[n2] = INTEGER_ZERO;
        this.derivedGauge[n2] = INTEGER_ZERO;
        this.previousScanCounter[n2] = null;
        this.derivedGaugeExceeded[n2] = null;
        this.derivedGaugeTimestamp[n2] = System.currentTimeMillis();
        this.modulusExceeded[n2] = false;
        this.eventAlreadyNotified[n2] = false;
        this.type[n2] = 0;
    }

    synchronized void removeSpecificElementAt(int n2) {
        this.removeElementAt(this.threshold, n2);
        this.removeElementAt(this.derivedGauge, n2);
        this.removeElementAt(this.previousScanCounter, n2);
        this.removeElementAt(this.derivedGaugeExceeded, n2);
        this.removeElementAt(this.derivedGaugeTimestamp, n2);
        this.removeElementAt(this.modulusExceeded, n2);
        this.removeElementAt(this.eventAlreadyNotified, n2);
        this.removeElementAt(this.type, n2);
    }

    private static class CounterAlarmClock
    extends TimerTask {
        CounterMonitor listener = null;

        public CounterAlarmClock(CounterMonitor counterMonitor) {
            this.listener = counterMonitor;
        }

        public void run() {
            if (this.listener.isActive()) {
                for (int i2 = 0; i2 < this.listener.elementCount; ++i2) {
                    this.listener.notifyAlarmClock(i2);
                }
            }
        }
    }
}

