/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    private List observedObjects = new ArrayList();
    private String observedAttribute = null;
    private long granularityPeriod = 10000L;
    protected static final int capacityIncrement = 16;
    protected int elementCount = 0;
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[16];
    protected MBeanServer server = null;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected String dbgTag = "Monitor";
    boolean isActive = false;
    long sequenceNumber = 0L;

    static boolean isTraceOn() {
        return Trace.isSelected(1, 4);
    }

    static void trace(String string, String string2, String string3) {
        Trace.send(1, 4, string, string2, string3);
    }

    void trace(String string, String string2) {
        Monitor.trace(this.dbgTag, string, string2);
    }

    static boolean isDebugOn() {
        return Trace.isSelected(2, 4);
    }

    static void debug(String string, String string2, String string3) {
        Trace.send(2, 4, string, string2, string3);
    }

    void debug(String string, String string2) {
        Monitor.debug(this.dbgTag, string, string2);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (Monitor.isTraceOn()) {
            this.trace("preRegister", "initialize the reference on the MBean server");
        }
        this.server = mBeanServer;
        return objectName;
    }

    public void postRegister(Boolean bl2) {
    }

    public void preDeregister() throws Exception {
        if (Monitor.isTraceOn()) {
            this.trace("preDeregister", "stop the monitor");
        }
        this.stop();
    }

    public void postDeregister() {
    }

    public abstract void start();

    public abstract void stop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName getObservedObject() {
        Monitor monitor = this;
        synchronized (monitor) {
            if (this.observedObjects.isEmpty()) {
                return null;
            }
            return (ObjectName)this.observedObjects.get(0);
        }
    }

    public synchronized void setObservedObject(ObjectName objectName) throws IllegalArgumentException {
        while (!this.observedObjects.isEmpty()) {
            this.removeObservedObject((ObjectName)this.observedObjects.get(0));
        }
        this.addObservedObject(objectName);
    }

    public synchronized void addObservedObject(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("Null observed object");
        }
        if (this.observedObjects.contains(objectName)) {
            return;
        }
        this.observedObjects.add(objectName);
        int n2 = 0;
        n2 &= 0xFFFFFFF8;
        if (this.alreadyNotifieds.length >= this.elementCount) {
            this.alreadyNotifieds = this.expandArray(this.alreadyNotifieds);
        }
        this.alreadyNotifieds[this.elementCount] = n2;
        this.updateDeprecatedAlreadyNotified();
        this.insertSpecificElementAt(this.elementCount);
        ++this.elementCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObservedObject(ObjectName objectName) {
        Monitor monitor = this;
        synchronized (monitor) {
            int n2 = this.observedObjects.indexOf(objectName);
            if (n2 >= 0) {
                this.observedObjects.remove(n2);
                this.removeElementAt(this.alreadyNotifieds, n2);
                this.updateDeprecatedAlreadyNotified();
                this.removeSpecificElementAt(n2);
                --this.elementCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsObservedObject(ObjectName objectName) {
        Monitor monitor = this;
        synchronized (monitor) {
            return this.observedObjects.contains(objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName[] getObservedObjects() {
        ObjectName[] objectNameArray;
        Monitor monitor = this;
        synchronized (monitor) {
            objectNameArray = new ObjectName[this.elementCount];
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                objectNameArray[i2] = (ObjectName)this.observedObjects.get(i2);
            }
        }
        return objectNameArray;
    }

    public String getObservedAttribute() {
        return this.observedAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservedAttribute(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Null observed attribute");
        }
        Monitor monitor = this;
        synchronized (monitor) {
            this.observedAttribute = string;
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                this.resetAlreadyNotified(i2, 6);
            }
        }
    }

    public synchronized long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public synchronized void setGranularityPeriod(long l2) throws IllegalArgumentException {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Nonpositive granularity period");
        }
        this.granularityPeriod = l2;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    synchronized ObjectName getObservedObject(int n2) throws ArrayIndexOutOfBoundsException {
        return (ObjectName)this.observedObjects.get(n2);
    }

    synchronized void updateDeprecatedAlreadyNotified() {
        this.alreadyNotified = this.elementCount > 0 ? this.alreadyNotifieds[0] : 0;
    }

    synchronized void setAlreadyNotified(int n2, int n3) {
        int n4 = n2;
        this.alreadyNotifieds[n4] = this.alreadyNotifieds[n4] | n3;
        if (n2 == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    synchronized void resetAlreadyNotified(int n2, int n3) {
        int n4 = n2;
        this.alreadyNotifieds[n4] = this.alreadyNotifieds[n4] & ~n3;
        if (n2 == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    synchronized boolean alreadyNotified(int n2, int n3) {
        return (this.alreadyNotifieds[n2] & n3) != 0;
    }

    synchronized void resetAllAlreadyNotified(int n2) {
        this.alreadyNotifieds[n2] = 0;
        if (n2 == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    int[] expandArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length + 16];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    long[] expandArray(long[] lArray) {
        long[] lArray2 = new long[lArray.length + 16];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        return lArray2;
    }

    Number[] expandArray(Number[] numberArray) {
        Number[] numberArray2 = new Number[numberArray.length + 16];
        System.arraycopy(numberArray, 0, numberArray2, 0, numberArray.length);
        return numberArray2;
    }

    boolean[] expandArray(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length + 16];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        return blArray2;
    }

    String[] expandArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length + 16];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    synchronized void removeElementAt(int[] nArray, int n2) {
        if (n2 < 0 || n2 >= this.elementCount) {
            return;
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(nArray, n2 + 1, nArray, n2, n3);
        }
    }

    synchronized void removeElementAt(long[] lArray, int n2) {
        if (n2 < 0 || n2 >= this.elementCount) {
            return;
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(lArray, n2 + 1, lArray, n2, n3);
        }
    }

    synchronized void removeElementAt(boolean[] blArray, int n2) {
        if (n2 < 0 || n2 >= this.elementCount) {
            return;
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(blArray, n2 + 1, blArray, n2, n3);
        }
    }

    synchronized void removeElementAt(Object[] objectArray, int n2) {
        if (n2 < 0 || n2 >= this.elementCount) {
            return;
        }
        int n3 = this.elementCount - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n3);
        }
        objectArray[this.elementCount - 1] = null;
    }

    synchronized int indexOf(ObjectName objectName) {
        return this.observedObjects.indexOf(objectName);
    }

    void insertSpecificElementAt(int n2) {
    }

    void removeSpecificElementAt(int n2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(String string, long l2, String string2, Object object, Object object2, int n2) {
        long l3;
        if (Monitor.isTraceOn()) {
            this.trace("sendNotification", "send notification:\n\tNotification observed object = " + this.getObservedObject(n2) + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + object);
        }
        Monitor monitor = this;
        synchronized (monitor) {
            l3 = this.sequenceNumber++;
        }
        this.sendNotification(new MonitorNotification(string, this, l3, l2, string2, this.getObservedObject(n2), this.observedAttribute, object, object2));
    }
}

