/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import com.sun.jmx.remote.util.EnvHelp;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.StringTokenizer;

public class JMXServiceURL
implements Serializable {
    private static final long serialVersionUID = 8173364409860779292L;
    private static final Exception randomException;
    private static final BitSet alphaBitSet;
    private static final BitSet numericBitSet;
    private static final BitSet alphaNumericBitSet;
    private static final BitSet protocolBitSet;
    private static final BitSet hostNameBitSet;
    private final String protocol;
    private final String host;
    private final int port;
    private final String urlPath;
    private transient String toString;

    public JMXServiceURL(String string) throws MalformedURLException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = string.length();
        for (int i2 = 0; i2 < n6; ++i2) {
            n5 = string.charAt(i2);
            if (n5 >= 32 && n5 < 127) continue;
            throw new MalformedURLException("Service URL contains non-ASCII character 0x" + Integer.toHexString(n5));
        }
        n5 = "service:jmx:".length();
        if (!string.regionMatches(true, 0, "service:jmx:", 0, n5)) {
            throw new MalformedURLException("Service URL must start with service:jmx:");
        }
        int[] nArray = new int[1];
        int n7 = n5;
        int n8 = JMXServiceURL.indexOf(string, ':', n7);
        this.protocol = string.substring(n7, n8).toLowerCase();
        if (!string.regionMatches(n8, "://", 0, 3)) {
            throw new MalformedURLException("Missing \"://\" after protocol name");
        }
        int n9 = n8 + 3;
        if (n9 < n6 && string.charAt(n9) == '[') {
            n4 = string.indexOf(93, n9) + 1;
            if (n4 == 0) {
                throw new MalformedURLException("Bad host name: [ without ]");
            }
            this.host = string.substring(n9 + 1, n4 - 1);
            if (!JMXServiceURL.isNumericIPv6Address(this.host)) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
        } else {
            n4 = JMXServiceURL.indexOfFirstNotInSet(string, hostNameBitSet, n9);
            this.host = string.substring(n9, n4);
        }
        if (n4 < n6 && string.charAt(n4) == ':') {
            if (this.host.length() == 0) {
                throw new MalformedURLException("Cannot give port number without host name");
            }
            n3 = n4 + 1;
            n2 = JMXServiceURL.indexOfFirstNotInSet(string, numericBitSet, n3);
            String string2 = string.substring(n3, n2);
            try {
                this.port = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException("Bad port number: \"" + string2 + "\": " + numberFormatException);
            }
        } else {
            n2 = n4;
            this.port = 0;
        }
        this.urlPath = (n3 = n2) < n6 ? string.substring(n3) : "";
        this.validate();
    }

    public JMXServiceURL(String string, String string2, int n2) throws MalformedURLException {
        this(string, string2, n2, null);
    }

    public JMXServiceURL(String string, String string2, int n2, String string3) throws MalformedURLException {
        if (string == null) {
            string = "jmxmp";
        }
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                throw new MalformedURLException("Local host name unknown: " + unknownHostException);
            }
        }
        if (string2.startsWith("[")) {
            if (!string2.endsWith("]")) {
                throw new MalformedURLException("Host starts with [ but does not end with ]");
            }
            if (!JMXServiceURL.isNumericIPv6Address(string2 = string2.substring(1, string2.length() - 1))) {
                throw new MalformedURLException("Address inside [...] must be numeric IPv6 address");
            }
            if (string2.startsWith("[")) {
                throw new MalformedURLException("More than one [[...]]");
            }
        }
        this.protocol = string.toLowerCase();
        this.host = string2;
        this.port = n2;
        if (string3 == null) {
            string3 = "";
        }
        this.urlPath = string3;
        this.validate();
    }

    private void validate() throws MalformedURLException {
        int n2 = JMXServiceURL.indexOfFirstNotInSet(this.protocol, protocolBitSet, 0);
        if (n2 == 0 || n2 < this.protocol.length() || !alphaBitSet.get(this.protocol.charAt(0))) {
            throw new MalformedURLException("Missing or invalid protocol name: \"" + this.protocol + "\"");
        }
        this.validateHost();
        if (this.port < 0) {
            throw new MalformedURLException("Bad port: " + this.port);
        }
        if (this.urlPath.length() > 0 && !this.urlPath.startsWith("/") && !this.urlPath.startsWith(";")) {
            throw new MalformedURLException("Bad URL path: " + this.urlPath);
        }
    }

    private void validateHost() throws MalformedURLException {
        int n2;
        if (this.host.length() == 0) {
            if (this.port != 0) {
                throw new MalformedURLException("Cannot give port number without host name");
            }
            return;
        }
        if (JMXServiceURL.isNumericIPv6Address(this.host)) {
            try {
                InetAddress.getByName(this.host);
            }
            catch (Exception exception) {
                MalformedURLException malformedURLException = new MalformedURLException("Bad IPv6 address: " + this.host);
                EnvHelp.initCause(malformedURLException, exception);
                throw malformedURLException;
            }
        }
        int n3 = this.host.length();
        int n4 = 46;
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = this.host.charAt(i2);
            boolean bl2 = alphaNumericBitSet.get(n2);
            if (n4 == 46) {
                n5 = n2;
            }
            if (bl2) {
                n4 = 97;
                continue;
            }
            if (n2 == 45) {
                if (n4 == 46) break;
                n4 = 45;
                continue;
            }
            if (n2 == 46) {
                if (n4 != 97) break;
                n4 = 46;
                continue;
            }
            n4 = 46;
            break;
        }
        try {
            if (n4 != 97) {
                throw randomException;
            }
            if (!alphaBitSet.get(n5)) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.host, ".", true);
                for (n2 = 0; n2 < 4; ++n2) {
                    String string = stringTokenizer.nextToken();
                    int n6 = Integer.parseInt(string);
                    if (n6 < 0 || n6 > 255) {
                        throw randomException;
                    }
                    if (n2 >= 3 || stringTokenizer.nextToken().equals(".")) continue;
                    throw randomException;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    throw randomException;
                }
            }
        }
        catch (Exception exception) {
            throw new MalformedURLException("Bad host: \"" + this.host + "\"");
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getURLPath() {
        return this.urlPath;
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        StringBuffer stringBuffer = new StringBuffer("service:jmx:");
        stringBuffer.append(this.getProtocol()).append("://");
        String string = this.getHost();
        if (JMXServiceURL.isNumericIPv6Address(string)) {
            stringBuffer.append('[').append(string).append(']');
        } else {
            stringBuffer.append(string);
        }
        int n2 = this.getPort();
        if (n2 != 0) {
            stringBuffer.append(':').append(n2);
        }
        stringBuffer.append(this.getURLPath());
        this.toString = stringBuffer.toString();
        return this.toString;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JMXServiceURL)) {
            return false;
        }
        JMXServiceURL jMXServiceURL = (JMXServiceURL)object;
        return jMXServiceURL.getProtocol().equalsIgnoreCase(this.getProtocol()) && jMXServiceURL.getHost().equalsIgnoreCase(this.getHost()) && jMXServiceURL.getPort() == this.getPort() && jMXServiceURL.getURLPath().equals(this.getURLPath());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static boolean isNumericIPv6Address(String string) {
        return string.indexOf(58) >= 0;
    }

    private static int indexOf(String string, char c2, int n2) {
        int n3 = string.indexOf(c2, n2);
        if (n3 < 0) {
            return string.length();
        }
        return n3;
    }

    private static int indexOfFirstNotInSet(String string, BitSet bitSet, int n2) {
        char c2;
        int n3;
        int n4 = string.length();
        for (n3 = n2; n3 < n4 && (c2 = string.charAt(n3)) < '\u0080' && bitSet.get(c2); ++n3) {
        }
        return n3;
    }

    private static void addCharsToBitSet(BitSet bitSet, String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            bitSet.set(string.charAt(i2));
        }
    }

    static {
        int n2;
        randomException = new Exception();
        alphaBitSet = new BitSet(128);
        numericBitSet = new BitSet(128);
        alphaNumericBitSet = new BitSet(128);
        protocolBitSet = new BitSet(128);
        hostNameBitSet = new BitSet(128);
        for (n2 = 48; n2 <= 57; n2 = (int)((char)(n2 + 1))) {
            numericBitSet.set(n2);
        }
        for (n2 = 65; n2 <= 90; n2 = (int)((char)(n2 + 1))) {
            alphaBitSet.set(n2);
        }
        for (n2 = 97; n2 <= 122; n2 = (int)((char)(n2 + 1))) {
            alphaBitSet.set(n2);
        }
        alphaNumericBitSet.or(alphaBitSet);
        alphaNumericBitSet.or(numericBitSet);
        protocolBitSet.or(alphaNumericBitSet);
        protocolBitSet.set(43);
        protocolBitSet.set(45);
        hostNameBitSet.or(alphaNumericBitSet);
        hostNameBitSet.set(45);
        hostNameBitSet.set(46);
    }
}

