/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.security.MBeanServerFileAccessController;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIIIOPServerImpl;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.management.remote.rmi.RMIServer;
import javax.management.remote.rmi.RMIServerImpl;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.CORBA.Stub;
import org.omg.CORBA.BAD_OPERATION;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIConnectorServer
extends JMXConnectorServer {
    public static final String JNDI_REBIND_ATTRIBUTE = "jmx.remote.jndi.rebind";
    public static final String RMI_CLIENT_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.client.socket.factory";
    public static final String RMI_SERVER_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.server.socket.factory";
    private static final char[] intToAlpha = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static ClassLogger logger = new ClassLogger("javax.management.remote.rmi", "RMIConnectorServer");
    private JMXServiceURL address;
    private RMIServerImpl rmiServerImpl;
    private final Map attributes;
    private ClassLoader defaultClassLoader = null;
    private String boundJndiUrl;
    private static final int CREATED = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private int state = 0;
    private static final Set openedServers = new HashSet();

    public RMIConnectorServer(JMXServiceURL jMXServiceURL, Map<String, ?> map) throws IOException {
        this(jMXServiceURL, map, null);
    }

    public RMIConnectorServer(JMXServiceURL jMXServiceURL, Map<String, ?> map, MBeanServer mBeanServer) throws IOException {
        this(jMXServiceURL, map, null, mBeanServer);
    }

    public RMIConnectorServer(JMXServiceURL jMXServiceURL, Map<String, ?> map, RMIServerImpl rMIServerImpl, MBeanServer mBeanServer) throws IOException {
        super(mBeanServer);
        if (jMXServiceURL == null) {
            throw new IllegalArgumentException("Null JMXServiceURL");
        }
        if (rMIServerImpl == null) {
            String string = jMXServiceURL.getProtocol();
            if (string == null || !string.equals("rmi") && !string.equals("iiop")) {
                String string2 = "Invalid protocol type: " + string;
                throw new MalformedURLException(string2);
            }
            String string3 = jMXServiceURL.getURLPath();
            if (!(string3.equals("") || string3.equals("/") || string3.startsWith("/jndi/"))) {
                throw new MalformedURLException("URL path must be empty or start with /jndi/");
            }
        }
        if (map == null) {
            this.attributes = Collections.EMPTY_MAP;
        } else {
            EnvHelp.checkAttributes(map);
            this.attributes = Collections.unmodifiableMap(map);
        }
        this.address = jMXServiceURL;
        this.rmiServerImpl = rMIServerImpl;
    }

    @Override
    public JMXConnector toJMXConnector(Map<String, ?> map) throws IOException {
        if (!this.isActive()) {
            throw new IllegalStateException("Connector is not active");
        }
        Map<String, Object> map2 = new HashMap(this.attributes == null ? Collections.EMPTY_MAP : this.attributes);
        if (map != null) {
            EnvHelp.checkAttributes(map);
            map2.putAll(map);
        }
        map2 = EnvHelp.filterAttributes(map2);
        RMIServer rMIServer = (RMIServer)this.rmiServerImpl.toStub();
        return new RMIConnector(rMIServer, map2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws IOException {
        Object object;
        Object object2;
        Object object3;
        boolean bl2 = logger.traceOn();
        if (this.state == 1) {
            if (bl2) {
                logger.trace("start", "already started");
            }
            return;
        }
        if (this.state == 2) {
            if (bl2) {
                logger.trace("start", "already stopped");
            }
            throw new IOException("The server has been stopped.");
        }
        MBeanServer mBeanServer = this.getMBeanServer();
        if (mBeanServer == null) {
            throw new IllegalStateException("This connector server is not attached to an MBean server");
        }
        if (this.attributes != null && (object3 = (String)this.attributes.get("jmx.remote.x.access.file")) != null) {
            object2 = null;
            try {
                object2 = new MBeanServerFileAccessController((String)object3);
            }
            catch (IOException iOException) {
                throw (IllegalArgumentException)EnvHelp.initCause(new IllegalArgumentException(iOException.getMessage()), iOException);
            }
            this.setMBeanServerForwarder((MBeanServerForwarder)object2);
            mBeanServer = this.getMBeanServer();
        }
        try {
            if (bl2) {
                logger.trace("start", "setting default class loader");
            }
            this.defaultClassLoader = EnvHelp.resolveServerClassLoader(this.attributes, mBeanServer);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            object2 = new IllegalArgumentException("ClassLoader not found: " + instanceNotFoundException);
            throw (IllegalArgumentException)EnvHelp.initCause((Throwable)object2, instanceNotFoundException);
        }
        if (bl2) {
            logger.trace("start", "setting RMIServer object");
        }
        object3 = this.rmiServerImpl != null ? this.rmiServerImpl : this.newServer();
        ((RMIServerImpl)object3).setMBeanServer(mBeanServer);
        ((RMIServerImpl)object3).setDefaultClassLoader(this.defaultClassLoader);
        ((RMIServerImpl)object3).setRMIConnectorServer(this);
        ((RMIServerImpl)object3).export();
        if (bl2) {
            logger.trace("start", "getting RMIServer object to export");
        }
        object2 = RMIConnectorServer.objectToBind((RMIServerImpl)object3, this.attributes);
        if (this.address != null && this.address.getURLPath().startsWith("/jndi/")) {
            boolean bl3;
            String string;
            object = this.address.getURLPath().substring(6);
            if (bl2) {
                logger.trace("start", "Using external directory: " + (String)object);
            }
            if ((string = (String)this.attributes.get(JNDI_REBIND_ATTRIBUTE)) == null) {
                bl3 = false;
            } else if (string.equalsIgnoreCase("true")) {
                bl3 = true;
            } else if (string.equalsIgnoreCase("false")) {
                bl3 = false;
            } else {
                throw new IllegalArgumentException("jmx.remote.jndi.rebindmust be \"true\" or \"false\"");
            }
            if (bl2) {
                logger.trace("start", "jmx.remote.jndi.rebind=" + bl3);
            }
            try {
                if (bl2) {
                    logger.trace("start", "binding to " + (String)object);
                }
                Hashtable hashtable = EnvHelp.mapToHashtable(this.attributes);
                boolean bl4 = RMIConnectorServer.isIiopURL(this.address, true);
                if (bl4) {
                    hashtable.put("java.naming.corba.orb", RMIConnector.resolveOrb(this.attributes));
                }
                this.bind((String)object, hashtable, (RMIServer)object2, bl3);
                this.boundJndiUrl = object;
            }
            catch (NamingException namingException) {
                throw RMIConnectorServer.newIOException("Cannot bind to URL [" + (String)object + "]: " + namingException, namingException);
            }
        } else {
            if (bl2) {
                logger.trace("start", "Encoding URL");
            }
            this.encodeStubInAddress((RMIServer)object2, this.attributes);
            if (bl2) {
                logger.trace("start", "Encoded URL: " + this.address);
            }
        }
        this.rmiServerImpl = object3;
        object = openedServers;
        synchronized (object) {
            openedServers.add(this);
        }
        this.state = 1;
        if (bl2) {
            logger.trace("start", "Connector Server Address = " + this.address);
            logger.trace("start", "started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        Object object;
        boolean bl2;
        block25: {
            bl2 = logger.traceOn();
            object = this;
            synchronized (object) {
                if (this.state == 2) {
                    if (bl2) {
                        logger.trace("stop", "already stopped.");
                    }
                    return;
                }
                if (this.state == 0 && bl2) {
                    logger.trace("stop", "not started yet.");
                }
                if (bl2) {
                    logger.trace("stop", "stopping.");
                }
                this.state = 2;
            }
            object = openedServers;
            synchronized (object) {
                openedServers.remove(this);
            }
            object = null;
            if (this.rmiServerImpl != null) {
                try {
                    if (bl2) {
                        logger.trace("stop", "closing RMI server.");
                    }
                    this.rmiServerImpl.close();
                }
                catch (IOException iOException) {
                    if (bl2) {
                        logger.trace("stop", "failed to close RMI server: " + iOException);
                    }
                    if (logger.debugOn()) {
                        logger.debug("stop", iOException);
                    }
                    object = iOException;
                }
            }
            if (this.boundJndiUrl != null) {
                try {
                    if (bl2) {
                        logger.trace("stop", "unbind from external directory: " + this.boundJndiUrl);
                    }
                    Hashtable hashtable = EnvHelp.mapToHashtable(this.attributes);
                    boolean bl3 = RMIConnectorServer.isIiopURL(this.address, true);
                    if (bl3) {
                        hashtable.put("java.naming.corba.orb", RMIConnector.resolveOrb(this.attributes));
                    }
                    InitialContext initialContext = new InitialContext(hashtable);
                    initialContext.unbind(this.boundJndiUrl);
                    initialContext.close();
                }
                catch (NamingException namingException) {
                    if (bl2) {
                        logger.trace("stop", "failed to unbind RMI server: " + namingException);
                    }
                    if (logger.debugOn()) {
                        logger.debug("stop", namingException);
                    }
                    if (object != null) break block25;
                    object = RMIConnectorServer.newIOException("Cannot bind to URL: " + namingException, namingException);
                }
            }
        }
        if (object != null) {
            throw object;
        }
        if (bl2) {
            logger.trace("stop", "stopped");
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.state == 1;
    }

    @Override
    public JMXServiceURL getAddress() {
        if (!this.isActive()) {
            return null;
        }
        return this.address;
    }

    @Override
    public Map<String, ?> getAttributes() {
        Map map = EnvHelp.filterAttributes(this.attributes);
        return Collections.unmodifiableMap(map);
    }

    @Override
    protected void connectionOpened(String string, String string2, Object object) {
        super.connectionOpened(string, string2, object);
    }

    @Override
    protected void connectionClosed(String string, String string2, Object object) {
        super.connectionClosed(string, string2, object);
    }

    @Override
    protected void connectionFailed(String string, String string2, Object object) {
        super.connectionFailed(string, string2, object);
    }

    void bind(String string, Hashtable hashtable, RMIServer rMIServer, boolean bl2) throws NamingException, MalformedURLException {
        InitialContext initialContext = new InitialContext(hashtable);
        if (bl2) {
            initialContext.rebind(string, (Object)rMIServer);
        } else {
            initialContext.bind(string, (Object)rMIServer);
        }
        initialContext.close();
    }

    RMIServerImpl newServer() throws IOException {
        boolean bl2 = RMIConnectorServer.isIiopURL(this.address, true);
        int n2 = this.address == null ? 0 : this.address.getPort();
        if (bl2) {
            return RMIConnectorServer.newIIOPServer(this.attributes);
        }
        return RMIConnectorServer.newJRMPServer(this.attributes, n2);
    }

    private void encodeStubInAddress(RMIServer rMIServer, Map map) throws IOException {
        int n2;
        String string;
        String string2;
        if (this.address == null) {
            string2 = rMIServer instanceof Stub ? "iiop" : "rmi";
            string = null;
            n2 = 0;
        } else {
            string2 = this.address.getProtocol();
            string = this.address.getHost().equals("") ? null : this.address.getHost();
            n2 = this.address.getPort();
        }
        String string3 = RMIConnectorServer.encodeStub(rMIServer, map);
        this.address = new JMXServiceURL(string2, string, n2, string3);
    }

    static boolean isIiopURL(JMXServiceURL jMXServiceURL, boolean bl2) throws MalformedURLException {
        String string = jMXServiceURL.getProtocol();
        if (string.equals("rmi")) {
            return false;
        }
        if (string.equals("iiop")) {
            return true;
        }
        if (bl2) {
            throw new MalformedURLException("URL must have protocol \"rmi\" or \"iiop\": \"" + string + "\"");
        }
        return false;
    }

    static String encodeStub(RMIServer rMIServer, Map map) throws IOException {
        if (rMIServer instanceof Stub) {
            return "/ior/" + RMIConnectorServer.encodeIIOPStub(rMIServer, map);
        }
        return "/stub/" + RMIConnectorServer.encodeJRMPStub(rMIServer, map);
    }

    static String encodeJRMPStub(RMIServer rMIServer, Map map) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(rMIServer);
        objectOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return RMIConnectorServer.byteArrayToBase64(byArray);
    }

    static String encodeIIOPStub(RMIServer rMIServer, Map map) throws IOException {
        try {
            Stub stub = (Stub)((Object)rMIServer);
            return stub._orb().object_to_string(stub);
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            throw RMIConnectorServer.newIOException(bAD_OPERATION.getMessage(), bAD_OPERATION);
        }
    }

    private static RMIServer objectToBind(RMIServerImpl rMIServerImpl, Map map) throws IOException {
        return RMIConnector.connectStub((RMIServer)rMIServerImpl.toStub(), map);
    }

    private static RMIServerImpl newJRMPServer(Map map, int n2) throws IOException {
        RMIClientSocketFactory rMIClientSocketFactory = (RMIClientSocketFactory)map.get(RMI_CLIENT_SOCKET_FACTORY_ATTRIBUTE);
        RMIServerSocketFactory rMIServerSocketFactory = (RMIServerSocketFactory)map.get(RMI_SERVER_SOCKET_FACTORY_ATTRIBUTE);
        return new RMIJRMPServerImpl(n2, rMIClientSocketFactory, rMIServerSocketFactory, map);
    }

    private static RMIServerImpl newIIOPServer(Map map) throws IOException {
        return new RMIIIOPServerImpl(map);
    }

    private static String byteArrayToBase64(byte[] byArray) {
        int n2;
        int n3;
        int n4 = byArray.length;
        int n5 = n4 / 3;
        int n6 = n4 - 3 * n5;
        int n7 = 4 * ((n4 + 2) / 3);
        StringBuffer stringBuffer = new StringBuffer(n7);
        int n8 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = byArray[n8++] & 0xFF;
            int n9 = byArray[n8++] & 0xFF;
            int n10 = byArray[n8++] & 0xFF;
            stringBuffer.append(intToAlpha[n2 >> 2]);
            stringBuffer.append(intToAlpha[n2 << 4 & 0x3F | n9 >> 4]);
            stringBuffer.append(intToAlpha[n9 << 2 & 0x3F | n10 >> 6]);
            stringBuffer.append(intToAlpha[n10 & 0x3F]);
        }
        if (n6 != 0) {
            n3 = byArray[n8++] & 0xFF;
            stringBuffer.append(intToAlpha[n3 >> 2]);
            if (n6 == 1) {
                stringBuffer.append(intToAlpha[n3 << 4 & 0x3F]);
                stringBuffer.append("==");
            } else {
                n2 = byArray[n8++] & 0xFF;
                stringBuffer.append(intToAlpha[n3 << 4 & 0x3F | n2 >> 4]);
                stringBuffer.append(intToAlpha[n2 << 2 & 0x3F]);
                stringBuffer.append('=');
            }
        }
        return stringBuffer.toString();
    }

    private static IOException newIOException(String string, Throwable throwable) {
        IOException iOException = new IOException(string);
        return (IOException)EnvHelp.initCause(iOException, throwable);
    }
}

