/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.RefreshFailedException;
import javax.security.auth.Refreshable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;
import sun.misc.HexDumpEncoder;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;

public class KerberosTicket
implements Destroyable,
Refreshable,
Serializable {
    private static final long serialVersionUID = 7395334370157380539L;
    private static final int FORWARDABLE_TICKET_FLAG = 1;
    private static final int FORWARDED_TICKET_FLAG = 2;
    private static final int PROXIABLE_TICKET_FLAG = 3;
    private static final int PROXY_TICKET_FLAG = 4;
    private static final int POSTDATED_TICKET_FLAG = 6;
    private static final int RENEWABLE_TICKET_FLAG = 8;
    private static final int INITIAL_TICKET_FLAG = 9;
    private static final int NUM_FLAGS = 32;
    private byte[] asn1Encoding;
    private KeyImpl sessionKey;
    private boolean[] flags;
    private Date authTime;
    private Date startTime;
    private Date endTime;
    private Date renewTill;
    private KerberosPrincipal client;
    private KerberosPrincipal server;
    private InetAddress[] clientAddresses;
    private transient boolean destroyed = false;

    public KerberosTicket(byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) {
        this.init(byArray, kerberosPrincipal, kerberosPrincipal2, byArray2, n2, blArray, date, date2, date3, date4, inetAddressArray);
    }

    private void init(byte[] byArray, KerberosPrincipal kerberosPrincipal, KerberosPrincipal kerberosPrincipal2, byte[] byArray2, int n2, boolean[] blArray, Date date, Date date2, Date date3, Date date4, InetAddress[] inetAddressArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("ASN.1 encoding of ticket cannot be null");
        }
        this.asn1Encoding = byArray;
        if (kerberosPrincipal == null) {
            throw new IllegalArgumentException("Client name in ticket cannot be null");
        }
        this.client = kerberosPrincipal;
        if (kerberosPrincipal2 == null) {
            throw new IllegalArgumentException("Server name in ticket cannot be null");
        }
        this.server = kerberosPrincipal2;
        if (byArray2 == null) {
            throw new IllegalArgumentException("Session key for ticket cannot be null");
        }
        this.sessionKey = new KeyImpl(byArray2, n2);
        if (blArray != null) {
            if (blArray.length >= 32) {
                this.flags = (boolean[])blArray.clone();
            } else {
                this.flags = new boolean[32];
                for (int i2 = 0; i2 < blArray.length; ++i2) {
                    this.flags[i2] = blArray[i2];
                }
            }
        } else {
            this.flags = new boolean[32];
        }
        if (blArray[8]) {
            if (date4 == null) {
                throw new IllegalArgumentException("The renewable period end time cannot be null for renewable tickets.");
            }
            this.renewTill = date4;
        }
        if (date == null) {
            throw new IllegalArgumentException("Authentication time of ticket cannot be null");
        }
        this.authTime = date;
        Date date5 = this.startTime = date2 != null ? date2 : date;
        if (date3 == null) {
            throw new IllegalArgumentException("End time for ticket validity cannot be null");
        }
        this.endTime = date3;
        if (inetAddressArray != null) {
            this.clientAddresses = (InetAddress[])inetAddressArray.clone();
        }
    }

    public final KerberosPrincipal getClient() {
        return this.client;
    }

    public final KerberosPrincipal getServer() {
        return this.server;
    }

    public final SecretKey getSessionKey() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return this.sessionKey;
    }

    public final int getSessionKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return this.sessionKey.getKeyType();
    }

    public final boolean isForwardable() {
        return this.flags[1];
    }

    public final boolean isForwarded() {
        return this.flags[2];
    }

    public final boolean isProxiable() {
        return this.flags[3];
    }

    public final boolean isProxy() {
        return this.flags[4];
    }

    public final boolean isPostdated() {
        return this.flags[6];
    }

    public final boolean isRenewable() {
        return this.flags[8];
    }

    public final boolean isInitial() {
        return this.flags[9];
    }

    public final boolean[] getFlags() {
        return this.flags == null ? null : (boolean[])this.flags.clone();
    }

    public final Date getAuthTime() {
        return this.authTime;
    }

    public final Date getStartTime() {
        return this.startTime;
    }

    public final Date getEndTime() {
        return this.endTime;
    }

    public final Date getRenewTill() {
        return this.renewTill;
    }

    public final InetAddress[] getClientAddresses() {
        return this.clientAddresses == null ? null : (InetAddress[])this.clientAddresses.clone();
    }

    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        return (byte[])this.asn1Encoding.clone();
    }

    public boolean isCurrent() {
        return System.currentTimeMillis() <= this.getEndTime().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws RefreshFailedException {
        Serializable serializable;
        if (this.destroyed) {
            throw new RefreshFailedException("A destroyed ticket cannot be renewd.");
        }
        if (!this.isRenewable()) {
            throw new RefreshFailedException("This ticket is not renewable");
        }
        if (System.currentTimeMillis() > this.getRenewTill().getTime()) {
            throw new RefreshFailedException("This ticket is past its last renewal time.");
        }
        Exception exception = null;
        Credentials credentials = null;
        try {
            credentials = new Credentials(this.asn1Encoding, this.client.toString(), this.server.toString(), this.sessionKey.getEncoded(), this.sessionKey.getKeyType(), this.flags, this.authTime, this.startTime, this.endTime, this.renewTill, this.clientAddresses);
            credentials = credentials.renew();
        }
        catch (KrbException krbException) {
            exception = krbException;
        }
        catch (IOException iOException) {
            exception = iOException;
        }
        if (exception != null) {
            serializable = new RefreshFailedException("Failed to renew Kerberos Ticket for client " + this.client + " and server " + this.server + " - " + exception.getMessage());
            ((Throwable)serializable).initCause(exception);
            throw serializable;
        }
        serializable = this;
        synchronized (serializable) {
            try {
                this.destroy();
            }
            catch (DestroyFailedException destroyFailedException) {
                // empty catch block
            }
            this.init(credentials.getEncoded(), new KerberosPrincipal(credentials.getClient().getName()), new KerberosPrincipal(credentials.getServer().getName()), credentials.getSessionKey().getBytes(), credentials.getSessionKey().getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
            this.destroyed = false;
        }
    }

    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            Arrays.fill(this.asn1Encoding, (byte)0);
            this.client = null;
            this.server = null;
            this.sessionKey.destroy();
            this.flags = null;
            this.authTime = null;
            this.startTime = null;
            this.endTime = null;
            this.renewTill = null;
            this.clientAddresses = null;
            this.destroyed = true;
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String toString() {
        if (this.destroyed) {
            throw new IllegalStateException("This ticket is no longer valid");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.clientAddresses != null) {
            for (int i2 = 0; i2 < this.clientAddresses.length; ++i2) {
                stringBuffer.append("clientAddresses[" + i2 + "] = " + this.clientAddresses[i2].toString());
            }
        }
        return "Ticket (hex) = \n" + new HexDumpEncoder().encode(this.asn1Encoding) + "\n" + "Client Principal = " + this.client.toString() + "\n" + "Server Principal = " + this.server.toString() + "\n" + "Session Key = " + this.sessionKey.toString() + "\n" + "Forwardable Ticket " + this.flags[1] + "\n" + "Forwarded Ticket " + this.flags[2] + "\n" + "Proxiable Ticket " + this.flags[3] + "\n" + "Proxy Ticket " + this.flags[4] + "\n" + "Postdated Ticket " + this.flags[6] + "\n" + "Renewable Ticket " + this.flags[8] + "\n" + "Initial Ticket " + this.flags[8] + "\n" + "Auth Time = " + this.authTime.toString() + "\n" + "Start Time = " + this.startTime.toString() + "\n" + "End Time = " + this.endTime.toString() + "\n" + "Renew Till = " + (this.renewTill == null ? "Null " : this.renewTill.toString()) + "\n" + "Client Addresses " + (this.clientAddresses == null ? " Null " : stringBuffer.toString() + "\n");
    }
}

