/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import sun.awt.SunToolkit;

public class JFrame
extends Frame
implements WindowConstants,
Accessible,
RootPaneContainer {
    public static final int EXIT_ON_CLOSE = 3;
    private static final Object defaultLookAndFeelDecoratedKey = new StringBuffer("JFrame.defaultLookAndFeelDecorated");
    private int defaultCloseOperation = 1;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public JFrame() throws HeadlessException {
        this.frameInit();
    }

    public JFrame(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.frameInit();
    }

    public JFrame(String string) throws HeadlessException {
        super(string);
        this.frameInit();
    }

    public JFrame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        this.frameInit();
    }

    protected void frameInit() {
        boolean bl2;
        this.enableEvents(72L);
        this.setLocale(JComponent.getDefaultLocale());
        this.setRootPane(this.createRootPane());
        this.setBackground(UIManager.getColor("control"));
        this.setRootPaneCheckingEnabled(true);
        if (JFrame.isDefaultLookAndFeelDecorated() && (bl2 = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        SunToolkit.checkAndSetPolicy(this, true);
    }

    protected JRootPane createRootPane() {
        JRootPane jRootPane = new JRootPane();
        jRootPane.setOpaque(true);
        return jRootPane;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            switch (this.defaultCloseOperation) {
                case 1: {
                    this.setVisible(false);
                    break;
                }
                case 2: {
                    this.setVisible(false);
                    this.dispose();
                    break;
                }
                default: {
                    break;
                }
                case 3: {
                    System.exit(0);
                }
            }
        }
    }

    public void setDefaultCloseOperation(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2 && n2 != 3) {
            throw new IllegalArgumentException("defaultCloseOperation must be one of: DO_NOTHING_ON_CLOSE, HIDE_ON_CLOSE, DISPOSE_ON_CLOSE, or EXIT_ON_CLOSE");
        }
        if (this.defaultCloseOperation != n2) {
            SecurityManager securityManager;
            if (n2 == 3 && (securityManager = System.getSecurityManager()) != null) {
                securityManager.checkExit(0);
            }
            int n3 = this.defaultCloseOperation;
            this.defaultCloseOperation = n2;
            this.firePropertyChange("defaultCloseOperation", n3, n2);
        }
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean bl2) {
        this.rootPaneCheckingEnabled = bl2;
    }

    protected void addImpl(Component component, Object object, int n2) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n2);
        } else {
            super.addImpl(component, object, n2);
        }
    }

    public void remove(Component component) {
        if (component == this.rootPane) {
            super.remove(component);
        } else {
            this.getContentPane().remove(component);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl2 = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(bl2);
            }
        }
    }

    public void setIconImage(Image image) {
        Image image2 = this.getIconImage();
        super.setIconImage(image);
        this.firePropertyChange("iconImage", image2, image);
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public static void setDefaultLookAndFeelDecorated(boolean bl2) {
        if (bl2) {
            SwingUtilities.appContextPut(defaultLookAndFeelDecoratedKey, Boolean.TRUE);
        } else {
            SwingUtilities.appContextPut(defaultLookAndFeelDecoratedKey, Boolean.FALSE);
        }
    }

    public static boolean isDefaultLookAndFeelDecorated() {
        Boolean bl2 = (Boolean)SwingUtilities.appContextGet(defaultLookAndFeelDecoratedKey);
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        return bl2;
    }

    protected String paramString() {
        String string = this.defaultCloseOperation == 1 ? "HIDE_ON_CLOSE" : (this.defaultCloseOperation == 2 ? "DISPOSE_ON_CLOSE" : (this.defaultCloseOperation == 0 ? "DO_NOTHING_ON_CLOSE" : (this.defaultCloseOperation == 3 ? "EXIT_ON_CLOSE" : "")));
        String string2 = this.rootPane != null ? this.rootPane.toString() : "";
        String string3 = this.rootPaneCheckingEnabled ? "true" : "false";
        return super.paramString() + ",defaultCloseOperation=" + string + ",rootPane=" + string2 + ",rootPaneCheckingEnabled=" + string3;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJFrame();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJFrame
    extends Frame.AccessibleAWTFrame {
        protected AccessibleJFrame() {
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JFrame.this.getTitle() == null) {
                return super.getAccessibleName();
            }
            return JFrame.this.getTitle();
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JFrame.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (JFrame.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }
    }
}

