/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleTableModelChange;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.TablePrintable;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTable
extends JComponent
implements TableModelListener,
Scrollable,
TableColumnModelListener,
ListSelectionListener,
CellEditorListener,
Accessible {
    private static final String uiClassID = "TableUI";
    public static final int AUTO_RESIZE_OFF = 0;
    public static final int AUTO_RESIZE_NEXT_COLUMN = 1;
    public static final int AUTO_RESIZE_SUBSEQUENT_COLUMNS = 2;
    public static final int AUTO_RESIZE_LAST_COLUMN = 3;
    public static final int AUTO_RESIZE_ALL_COLUMNS = 4;
    protected TableModel dataModel;
    protected TableColumnModel columnModel;
    protected ListSelectionModel selectionModel;
    protected JTableHeader tableHeader;
    protected int rowHeight;
    protected int rowMargin;
    protected Color gridColor;
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    protected int autoResizeMode;
    protected boolean autoCreateColumnsFromModel;
    protected Dimension preferredViewportSize;
    protected boolean rowSelectionAllowed;
    protected boolean cellSelectionEnabled;
    protected transient Component editorComp;
    protected transient TableCellEditor cellEditor;
    protected transient int editingColumn;
    protected transient int editingRow;
    protected transient Hashtable defaultRenderersByColumnClass;
    protected transient Hashtable defaultEditorsByColumnClass;
    protected Color selectionForeground;
    protected Color selectionBackground;
    private SizeSequence rowModel;
    private boolean dragEnabled;
    private boolean surrendersFocusOnKeystroke;
    private PropertyChangeListener editorRemover = null;
    private boolean columnSelectionAdjusting;
    private boolean rowSelectionAdjusting;
    private boolean isPrinting = false;
    private Throwable printError;
    private boolean isRowHeightSet;

    public JTable() {
        this(null, null, null);
    }

    public JTable(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        this(tableModel, tableColumnModel, null);
    }

    public JTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        this.setLayout(null);
        this.setFocusTraversalKeys(0, JComponent.getManagingFocusForwardTraversalKeys());
        this.setFocusTraversalKeys(1, JComponent.getManagingFocusBackwardTraversalKeys());
        if (tableColumnModel == null) {
            tableColumnModel = this.createDefaultColumnModel();
            this.autoCreateColumnsFromModel = true;
        }
        this.setColumnModel(tableColumnModel);
        if (listSelectionModel == null) {
            listSelectionModel = this.createDefaultSelectionModel();
        }
        this.setSelectionModel(listSelectionModel);
        if (tableModel == null) {
            tableModel = this.createDefaultDataModel();
        }
        this.setModel(tableModel);
        this.initializeLocalVars();
        this.updateUI();
    }

    public JTable(int n2, int n3) {
        this(new DefaultTableModel(n2, n3));
    }

    public JTable(Vector vector, Vector vector2) {
        this(new DefaultTableModel(vector, vector2));
    }

    public JTable(final Object[][] objectArray, final Object[] objectArray2) {
        this(new AbstractTableModel(){

            public String getColumnName(int n2) {
                return objectArray2[n2].toString();
            }

            public int getRowCount() {
                return objectArray.length;
            }

            public int getColumnCount() {
                return objectArray2.length;
            }

            public Object getValueAt(int n2, int n3) {
                return objectArray[n2][n3];
            }

            public boolean isCellEditable(int n2, int n3) {
                return true;
            }

            public void setValueAt(Object object, int n2, int n3) {
                objectArray[n2][n3] = object;
                this.fireTableCellUpdated(n2, n3);
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.configureEnclosingScrollPane();
    }

    protected void configureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(this.getTableHeader());
            Border border = jScrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                jScrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
        }
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        this.unconfigureEnclosingScrollPane();
        super.removeNotify();
    }

    protected void unconfigureEnclosingScrollPane() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            jScrollPane.setColumnHeaderView(null);
        }
    }

    @Override
    void setUIProperty(String string, Object object) {
        if (string == "rowHeight") {
            if (!this.isRowHeightSet) {
                this.setRowHeight(((Number)object).intValue());
                this.isRowHeightSet = false;
            }
            return;
        }
        super.setUIProperty(string, object);
    }

    public static JScrollPane createScrollPaneForTable(JTable jTable) {
        return new JScrollPane(jTable);
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.tableHeader != jTableHeader) {
            JTableHeader jTableHeader2 = this.tableHeader;
            if (jTableHeader2 != null) {
                jTableHeader2.setTable(null);
            }
            this.tableHeader = jTableHeader;
            if (jTableHeader != null) {
                jTableHeader.setTable(this);
            }
            this.firePropertyChange("tableHeader", jTableHeader2, jTableHeader);
        }
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setRowHeight(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        int n3 = this.rowHeight;
        this.rowHeight = n2;
        this.rowModel = null;
        this.isRowHeightSet = true;
        this.resizeAndRepaint();
        this.firePropertyChange("rowHeight", n3, n2);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    private SizeSequence getRowModel() {
        if (this.rowModel == null) {
            this.rowModel = new SizeSequence(this.getRowCount(), this.getRowHeight());
        }
        return this.rowModel;
    }

    public void setRowHeight(int n2, int n3) {
        if (n3 <= 0) {
            throw new IllegalArgumentException("New row height less than 1");
        }
        this.getRowModel().setSize(n2, n3);
        this.resizeAndRepaint();
    }

    public int getRowHeight(int n2) {
        return this.rowModel == null ? this.getRowHeight() : this.rowModel.getSize(n2);
    }

    public void setRowMargin(int n2) {
        int n3 = this.rowMargin;
        this.rowMargin = n2;
        this.resizeAndRepaint();
        this.firePropertyChange("rowMargin", n3, n2);
    }

    public int getRowMargin() {
        return this.rowMargin;
    }

    public void setIntercellSpacing(Dimension dimension) {
        this.setRowMargin(dimension.height);
        this.getColumnModel().setColumnMargin(dimension.width);
        this.resizeAndRepaint();
    }

    public Dimension getIntercellSpacing() {
        return new Dimension(this.getColumnModel().getColumnMargin(), this.rowMargin);
    }

    public void setGridColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("New color is null");
        }
        Color color2 = this.gridColor;
        this.gridColor = color;
        this.firePropertyChange("gridColor", color2, color);
        this.repaint();
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setShowGrid(boolean bl2) {
        this.setShowHorizontalLines(bl2);
        this.setShowVerticalLines(bl2);
        this.repaint();
    }

    public void setShowHorizontalLines(boolean bl2) {
        boolean bl3 = this.showHorizontalLines;
        this.showHorizontalLines = bl2;
        this.firePropertyChange("showHorizontalLines", bl3, bl2);
        this.repaint();
    }

    public void setShowVerticalLines(boolean bl2) {
        boolean bl3 = this.showVerticalLines;
        this.showVerticalLines = bl2;
        this.firePropertyChange("showVerticalLines", bl3, bl2);
        this.repaint();
    }

    public boolean getShowHorizontalLines() {
        return this.showHorizontalLines;
    }

    public boolean getShowVerticalLines() {
        return this.showVerticalLines;
    }

    public void setAutoResizeMode(int n2) {
        if (n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4) {
            int n3 = this.autoResizeMode;
            this.autoResizeMode = n2;
            this.resizeAndRepaint();
            if (this.tableHeader != null) {
                this.tableHeader.resizeAndRepaint();
            }
            this.firePropertyChange("autoResizeMode", n3, this.autoResizeMode);
        }
    }

    public int getAutoResizeMode() {
        return this.autoResizeMode;
    }

    public void setAutoCreateColumnsFromModel(boolean bl2) {
        if (this.autoCreateColumnsFromModel != bl2) {
            boolean bl3 = this.autoCreateColumnsFromModel;
            this.autoCreateColumnsFromModel = bl2;
            if (bl2) {
                this.createDefaultColumnsFromModel();
            }
            this.firePropertyChange("autoCreateColumnsFromModel", bl3, bl2);
        }
    }

    public boolean getAutoCreateColumnsFromModel() {
        return this.autoCreateColumnsFromModel;
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            for (int i2 = 0; i2 < tableModel.getColumnCount(); ++i2) {
                TableColumn tableColumn = new TableColumn(i2);
                this.addColumn(tableColumn);
            }
        }
    }

    public void setDefaultRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer != null) {
            this.defaultRenderersByColumnClass.put(clazz, tableCellRenderer);
        } else {
            this.defaultRenderersByColumnClass.remove(clazz);
        }
    }

    public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Object v2 = this.defaultRenderersByColumnClass.get(clazz);
        if (v2 != null) {
            return (TableCellRenderer)v2;
        }
        return this.getDefaultRenderer(clazz.getSuperclass());
    }

    public void setDefaultEditor(Class<?> clazz, TableCellEditor tableCellEditor) {
        if (tableCellEditor != null) {
            this.defaultEditorsByColumnClass.put(clazz, tableCellEditor);
        } else {
            this.defaultEditorsByColumnClass.remove(clazz);
        }
    }

    public TableCellEditor getDefaultEditor(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Object v2 = this.defaultEditorsByColumnClass.get(clazz);
        if (v2 != null) {
            return (TableCellEditor)v2;
        }
        return this.getDefaultEditor(clazz.getSuperclass());
    }

    public void setDragEnabled(boolean bl2) {
        if (bl2 && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = bl2;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setSelectionMode(int n2) {
        this.clearSelection();
        this.getSelectionModel().setSelectionMode(n2);
        this.getColumnModel().getSelectionModel().setSelectionMode(n2);
    }

    public void setRowSelectionAllowed(boolean bl2) {
        boolean bl3 = this.rowSelectionAllowed;
        this.rowSelectionAllowed = bl2;
        if (bl3 != bl2) {
            this.repaint();
        }
        this.firePropertyChange("rowSelectionAllowed", bl3, bl2);
    }

    public boolean getRowSelectionAllowed() {
        return this.rowSelectionAllowed;
    }

    public void setColumnSelectionAllowed(boolean bl2) {
        boolean bl3 = this.columnModel.getColumnSelectionAllowed();
        this.columnModel.setColumnSelectionAllowed(bl2);
        if (bl3 != bl2) {
            this.repaint();
        }
        this.firePropertyChange("columnSelectionAllowed", bl3, bl2);
    }

    public boolean getColumnSelectionAllowed() {
        return this.columnModel.getColumnSelectionAllowed();
    }

    public void setCellSelectionEnabled(boolean bl2) {
        this.setRowSelectionAllowed(bl2);
        this.setColumnSelectionAllowed(bl2);
        boolean bl3 = this.cellSelectionEnabled;
        this.cellSelectionEnabled = bl2;
        this.firePropertyChange("cellSelectionEnabled", bl3, bl2);
    }

    public boolean getCellSelectionEnabled() {
        return this.getRowSelectionAllowed() && this.getColumnSelectionAllowed();
    }

    public void selectAll() {
        if (this.isEditing()) {
            this.removeEditor();
        }
        if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
            ListSelectionModel listSelectionModel = this.selectionModel;
            listSelectionModel.setValueIsAdjusting(true);
            int n2 = listSelectionModel.getLeadSelectionIndex();
            int n3 = listSelectionModel.getAnchorSelectionIndex();
            this.setRowSelectionInterval(0, this.getRowCount() - 1);
            listSelectionModel.addSelectionInterval(n3, n2);
            listSelectionModel.setValueIsAdjusting(false);
            listSelectionModel = this.columnModel.getSelectionModel();
            listSelectionModel.setValueIsAdjusting(true);
            n2 = listSelectionModel.getLeadSelectionIndex();
            n3 = listSelectionModel.getAnchorSelectionIndex();
            this.setColumnSelectionInterval(0, this.getColumnCount() - 1);
            listSelectionModel.addSelectionInterval(n3, n2);
            listSelectionModel.setValueIsAdjusting(false);
        }
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
        this.columnModel.getSelectionModel().clearSelection();
    }

    private int boundRow(int n2) throws IllegalArgumentException {
        if (n2 < 0 || n2 >= this.getRowCount()) {
            throw new IllegalArgumentException("Row index out of range");
        }
        return n2;
    }

    private int boundColumn(int n2) {
        if (n2 < 0 || n2 >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        return n2;
    }

    public void setRowSelectionInterval(int n2, int n3) {
        this.selectionModel.setSelectionInterval(this.boundRow(n2), this.boundRow(n3));
    }

    public void setColumnSelectionInterval(int n2, int n3) {
        this.columnModel.getSelectionModel().setSelectionInterval(this.boundColumn(n2), this.boundColumn(n3));
    }

    public void addRowSelectionInterval(int n2, int n3) {
        this.selectionModel.addSelectionInterval(this.boundRow(n2), this.boundRow(n3));
    }

    public void addColumnSelectionInterval(int n2, int n3) {
        this.columnModel.getSelectionModel().addSelectionInterval(this.boundColumn(n2), this.boundColumn(n3));
    }

    public void removeRowSelectionInterval(int n2, int n3) {
        this.selectionModel.removeSelectionInterval(this.boundRow(n2), this.boundRow(n3));
    }

    public void removeColumnSelectionInterval(int n2, int n3) {
        this.columnModel.getSelectionModel().removeSelectionInterval(this.boundColumn(n2), this.boundColumn(n3));
    }

    public int getSelectedRow() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public int getSelectedColumn() {
        return this.columnModel.getSelectionModel().getMinSelectionIndex();
    }

    public int[] getSelectedRows() {
        int n2 = this.selectionModel.getMinSelectionIndex();
        int n3 = this.selectionModel.getMaxSelectionIndex();
        if (n2 == -1 || n3 == -1) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n3 - n2)];
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.selectionModel.isSelectedIndex(i2)) continue;
            nArray[n4++] = i2;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        return nArray2;
    }

    public int[] getSelectedColumns() {
        return this.columnModel.getSelectedColumns();
    }

    public int getSelectedRowCount() {
        int n2 = this.selectionModel.getMinSelectionIndex();
        int n3 = this.selectionModel.getMaxSelectionIndex();
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (!this.selectionModel.isSelectedIndex(i2)) continue;
            ++n4;
        }
        return n4;
    }

    public int getSelectedColumnCount() {
        return this.columnModel.getSelectedColumnCount();
    }

    public boolean isRowSelected(int n2) {
        return this.selectionModel.isSelectedIndex(n2);
    }

    public boolean isColumnSelected(int n2) {
        return this.columnModel.getSelectionModel().isSelectedIndex(n2);
    }

    public boolean isCellSelected(int n2, int n3) {
        if (!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed()) {
            return false;
        }
        return !(this.getRowSelectionAllowed() && !this.isRowSelected(n2) || this.getColumnSelectionAllowed() && !this.isColumnSelected(n3));
    }

    private void changeSelectionModel(ListSelectionModel listSelectionModel, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (bl3) {
            if (bl2) {
                listSelectionModel.setAnchorSelectionIndex(n2);
            } else {
                listSelectionModel.setSelectionInterval(listSelectionModel.getAnchorSelectionIndex(), n2);
            }
        } else if (bl2) {
            if (bl4) {
                listSelectionModel.removeSelectionInterval(n2, n2);
            } else {
                listSelectionModel.addSelectionInterval(n2, n2);
            }
        } else {
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    public void changeSelection(int n2, int n3, boolean bl2, boolean bl3) {
        Rectangle rectangle;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        boolean bl4 = this.isCellSelected(n2, n3);
        this.changeSelectionModel(listSelectionModel2, n3, bl2, bl3, bl4);
        this.changeSelectionModel(listSelectionModel, n2, bl2, bl3, bl4);
        if (this.getAutoscrolls() && (rectangle = this.getCellRect(n2, n3, false)) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
        if (!color.equals(color2)) {
            this.repaint();
        }
    }

    public TableColumn getColumn(Object object) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n2 = tableColumnModel.getColumnIndex(object);
        return tableColumnModel.getColumn(n2);
    }

    public int convertColumnIndexToModel(int n2) {
        if (n2 < 0) {
            return n2;
        }
        return this.getColumnModel().getColumn(n2).getModelIndex();
    }

    public int convertColumnIndexToView(int n2) {
        if (n2 < 0) {
            return n2;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2).getModelIndex() != n2) continue;
            return i2;
        }
        return -1;
    }

    public int getRowCount() {
        return this.getModel().getRowCount();
    }

    public int getColumnCount() {
        return this.getColumnModel().getColumnCount();
    }

    public String getColumnName(int n2) {
        return this.getModel().getColumnName(this.convertColumnIndexToModel(n2));
    }

    public Class<?> getColumnClass(int n2) {
        return this.getModel().getColumnClass(this.convertColumnIndexToModel(n2));
    }

    public Object getValueAt(int n2, int n3) {
        return this.getModel().getValueAt(n2, this.convertColumnIndexToModel(n3));
    }

    public void setValueAt(Object object, int n2, int n3) {
        this.getModel().setValueAt(object, n2, this.convertColumnIndexToModel(n3));
    }

    public boolean isCellEditable(int n2, int n3) {
        return this.getModel().isCellEditable(n2, this.convertColumnIndexToModel(n3));
    }

    public void addColumn(TableColumn tableColumn) {
        if (tableColumn.getHeaderValue() == null) {
            int n2 = tableColumn.getModelIndex();
            String string = this.getModel().getColumnName(n2);
            tableColumn.setHeaderValue(string);
        }
        this.getColumnModel().addColumn(tableColumn);
    }

    public void removeColumn(TableColumn tableColumn) {
        this.getColumnModel().removeColumn(tableColumn);
    }

    public void moveColumn(int n2, int n3) {
        this.getColumnModel().moveColumn(n2, n3);
    }

    public int columnAtPoint(Point point) {
        int n2 = point.x;
        if (!this.getComponentOrientation().isLeftToRight()) {
            n2 = this.getWidth() - n2;
        }
        return this.getColumnModel().getColumnIndexAtX(n2);
    }

    public int rowAtPoint(Point point) {
        int n2;
        int n3 = point.y;
        int n4 = n2 = this.rowModel == null ? n3 / this.getRowHeight() : this.rowModel.getIndex(n3);
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= this.getRowCount()) {
            return -1;
        }
        return n2;
    }

    public Rectangle getCellRect(int n2, int n3, boolean bl2) {
        int n4;
        Rectangle rectangle = new Rectangle();
        boolean bl3 = true;
        if (n2 < 0) {
            bl3 = false;
        } else if (n2 >= this.getRowCount()) {
            rectangle.y = this.getHeight();
            bl3 = false;
        } else {
            rectangle.height = this.getRowHeight(n2);
            int n5 = rectangle.y = this.rowModel == null ? n2 * rectangle.height : this.rowModel.getPosition(n2);
        }
        if (n3 < 0) {
            if (!this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
            bl3 = false;
        } else if (n3 >= this.getColumnCount()) {
            if (this.getComponentOrientation().isLeftToRight()) {
                rectangle.x = this.getWidth();
            }
            bl3 = false;
        } else {
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (this.getComponentOrientation().isLeftToRight()) {
                for (n4 = 0; n4 < n3; ++n4) {
                    rectangle.x += tableColumnModel.getColumn(n4).getWidth();
                }
            } else {
                for (n4 = tableColumnModel.getColumnCount() - 1; n4 > n3; --n4) {
                    rectangle.x += tableColumnModel.getColumn(n4).getWidth();
                }
            }
            rectangle.width = tableColumnModel.getColumn(n3).getWidth();
        }
        if (bl3 && !bl2) {
            int n6 = this.getRowMargin();
            n4 = this.getColumnModel().getColumnMargin();
            rectangle.setBounds(rectangle.x + n4 / 2, rectangle.y + n6 / 2, rectangle.width - n4, rectangle.height - n6);
        }
        return rectangle;
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public void doLayout() {
        TableColumn tableColumn = this.getResizingColumn();
        if (tableColumn == null) {
            this.setWidthsFromPreferredWidths(false);
        } else {
            int n2 = this.viewIndexForColumn(tableColumn);
            int n3 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            this.accommodateDelta(n2, n3);
            n3 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            if (n3 != 0) {
                tableColumn.setWidth(tableColumn.getWidth() + n3);
            }
            this.setWidthsFromPreferredWidths(true);
        }
        super.doLayout();
    }

    private TableColumn getResizingColumn() {
        return this.tableHeader == null ? null : this.tableHeader.getResizingColumn();
    }

    public void sizeColumnsToFit(boolean bl2) {
        int n2 = this.autoResizeMode;
        this.setAutoResizeMode(bl2 ? 3 : 4);
        this.sizeColumnsToFit(-1);
        this.setAutoResizeMode(n2);
    }

    public void sizeColumnsToFit(int n2) {
        if (n2 == -1) {
            this.setWidthsFromPreferredWidths(false);
        } else if (this.autoResizeMode == 0) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        } else {
            int n3 = this.getWidth() - this.getColumnModel().getTotalColumnWidth();
            this.accommodateDelta(n2, n3);
            this.setWidthsFromPreferredWidths(true);
        }
    }

    private void setWidthsFromPreferredWidths(final boolean bl2) {
        int n2 = this.getWidth();
        int n3 = this.getPreferredSize().width;
        int n4 = !bl2 ? n2 : n3;
        final TableColumnModel tableColumnModel = this.columnModel;
        Resizable3 resizable3 = new Resizable3(){

            public int getElementCount() {
                return tableColumnModel.getColumnCount();
            }

            public int getLowerBoundAt(int n2) {
                return tableColumnModel.getColumn(n2).getMinWidth();
            }

            public int getUpperBoundAt(int n2) {
                return tableColumnModel.getColumn(n2).getMaxWidth();
            }

            public int getMidPointAt(int n2) {
                if (!bl2) {
                    return tableColumnModel.getColumn(n2).getPreferredWidth();
                }
                return tableColumnModel.getColumn(n2).getWidth();
            }

            public void setSizeAt(int n2, int n3) {
                if (!bl2) {
                    tableColumnModel.getColumn(n3).setWidth(n2);
                } else {
                    tableColumnModel.getColumn(n3).setPreferredWidth(n2);
                }
            }
        };
        this.adjustSizes((long)n4, resizable3, bl2);
    }

    private void accommodateDelta(int n2, int n3) {
        int n4 = this.getColumnCount();
        int n5 = n2;
        int n6 = n4;
        switch (this.autoResizeMode) {
            case 1: {
                n6 = Math.min(++n5 + 1, n4);
                break;
            }
            case 2: {
                ++n5;
                n6 = n4;
                break;
            }
            case 3: {
                n5 = n4 - 1;
                n6 = n5 + 1;
                break;
            }
            case 4: {
                n5 = 0;
                n6 = n4;
                break;
            }
            default: {
                return;
            }
        }
        final int n7 = n5;
        final int n8 = n6;
        final TableColumnModel tableColumnModel = this.columnModel;
        Resizable3 resizable3 = new Resizable3(){

            public int getElementCount() {
                return n8 - n7;
            }

            public int getLowerBoundAt(int n2) {
                return tableColumnModel.getColumn(n2 + n7).getMinWidth();
            }

            public int getUpperBoundAt(int n2) {
                return tableColumnModel.getColumn(n2 + n7).getMaxWidth();
            }

            public int getMidPointAt(int n2) {
                return tableColumnModel.getColumn(n2 + n7).getWidth();
            }

            public void setSizeAt(int n2, int n3) {
                tableColumnModel.getColumn(n3 + n7).setWidth(n2);
            }
        };
        int n9 = 0;
        for (int i2 = n5; i2 < n6; ++i2) {
            TableColumn tableColumn = this.columnModel.getColumn(i2);
            int n10 = tableColumn.getWidth();
            n9 += n10;
        }
        this.adjustSizes((long)(n9 + n3), resizable3, false);
    }

    private void adjustSizes(long l2, final Resizable3 resizable3, boolean bl2) {
        int n2 = resizable3.getElementCount();
        long l3 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l3 += (long)resizable3.getMidPointAt(i2);
        }
        Resizable2 resizable2 = l2 < l3 == !bl2 ? new Resizable2(){

            public int getElementCount() {
                return resizable3.getElementCount();
            }

            public int getLowerBoundAt(int n2) {
                return resizable3.getLowerBoundAt(n2);
            }

            public int getUpperBoundAt(int n2) {
                return resizable3.getMidPointAt(n2);
            }

            public void setSizeAt(int n2, int n3) {
                resizable3.setSizeAt(n2, n3);
            }
        } : new Resizable2(){

            public int getElementCount() {
                return resizable3.getElementCount();
            }

            public int getLowerBoundAt(int n2) {
                return resizable3.getMidPointAt(n2);
            }

            public int getUpperBoundAt(int n2) {
                return resizable3.getUpperBoundAt(n2);
            }

            public void setSizeAt(int n2, int n3) {
                resizable3.setSizeAt(n2, n3);
            }
        };
        this.adjustSizes(l2, resizable2, !bl2);
    }

    private void adjustSizes(long l2, Resizable2 resizable2, boolean bl2) {
        int n2;
        long l3 = 0L;
        long l4 = 0L;
        for (n2 = 0; n2 < resizable2.getElementCount(); ++n2) {
            l3 += (long)resizable2.getLowerBoundAt(n2);
            l4 += (long)resizable2.getUpperBoundAt(n2);
        }
        if (bl2) {
            l2 = Math.min(Math.max(l3, l2), l4);
        }
        for (n2 = 0; n2 < resizable2.getElementCount(); ++n2) {
            int n3;
            int n4 = resizable2.getLowerBoundAt(n2);
            int n5 = resizable2.getUpperBoundAt(n2);
            if (l3 == l4) {
                n3 = n4;
            } else {
                double d2 = (double)(l2 - l3) / (double)(l4 - l3);
                n3 = (int)Math.round((double)n4 + d2 * (double)(n5 - n4));
            }
            resizable2.setSizeAt(n3, n2);
            l2 -= (long)n3;
            l3 -= (long)n4;
            l4 -= (long)n5;
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TableCellRenderer tableCellRenderer;
        Component component;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n2 = this.columnAtPoint(point);
        int n3 = this.rowAtPoint(point);
        if (n2 != -1 && n3 != -1 && (component = this.prepareRenderer(tableCellRenderer = this.getCellRenderer(n3, n2), n3, n2)) instanceof JComponent) {
            Rectangle rectangle = this.getCellRect(n3, n2, false);
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            string = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public void setSurrendersFocusOnKeystroke(boolean bl2) {
        this.surrendersFocusOnKeystroke = bl2;
    }

    public boolean getSurrendersFocusOnKeystroke() {
        return this.surrendersFocusOnKeystroke;
    }

    public boolean editCellAt(int n2, int n3) {
        return this.editCellAt(n2, n3, null);
    }

    public boolean editCellAt(int n2, int n3, EventObject eventObject) {
        Object object;
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (n2 < 0 || n2 >= this.getRowCount() || n3 < 0 || n3 >= this.getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n2, n3)) {
            return false;
        }
        if (this.editorRemover == null) {
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.editorRemover = new CellEditorRemover((KeyboardFocusManager)object);
            ((KeyboardFocusManager)object).addPropertyChangeListener("permanentFocusOwner", this.editorRemover);
        }
        if ((object = this.getCellEditor(n2, n3)) != null && object.isCellEditable(eventObject)) {
            this.editorComp = this.prepareEditor((TableCellEditor)object, n2, n3);
            if (this.editorComp == null) {
                this.removeEditor();
                return false;
            }
            this.editorComp.setBounds(this.getCellRect(n2, n3, false));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.setCellEditor((TableCellEditor)object);
            this.setEditingRow(n2);
            this.setEditingColumn(n3);
            object.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    public boolean isEditing() {
        return this.cellEditor != null;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public int getEditingRow() {
        return this.editingRow;
    }

    public TableUI getUI() {
        return (TableUI)this.ui;
    }

    public void setUI(TableUI tableUI) {
        if (this.ui != tableUI) {
            super.setUI(tableUI);
            this.repaint();
        }
    }

    private void updateSubComponentUI(Object object) {
        if (object == null) {
            return;
        }
        Component component = null;
        if (object instanceof Component) {
            component = (Component)object;
        }
        if (object instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)object).getComponent();
        }
        if (component != null && component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
    }

    @Override
    public void updateUI() {
        Object object;
        TableColumnModel tableColumnModel = this.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            object = tableColumnModel.getColumn(i2);
            this.updateSubComponentUI(((TableColumn)object).getCellRenderer());
            this.updateSubComponentUI(((TableColumn)object).getCellEditor());
            this.updateSubComponentUI(((TableColumn)object).getHeaderRenderer());
        }
        Enumeration enumeration = this.defaultRenderersByColumnClass.elements();
        while (enumeration.hasMoreElements()) {
            this.updateSubComponentUI(enumeration.nextElement());
        }
        object = this.defaultEditorsByColumnClass.elements();
        while (object.hasMoreElements()) {
            this.updateSubComponentUI(object.nextElement());
        }
        if (this.tableHeader != null && this.tableHeader.getParent() == null) {
            this.tableHeader.updateUI();
        }
        this.setUI((TableUI)UIManager.getUI(this));
        this.resizeAndRepaint();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void setModel(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("Cannot set a null TableModel");
        }
        if (this.dataModel != tableModel) {
            TableModel tableModel2 = this.dataModel;
            if (tableModel2 != null) {
                tableModel2.removeTableModelListener(this);
            }
            this.dataModel = tableModel;
            tableModel.addTableModelListener(this);
            this.tableChanged(new TableModelEvent(tableModel, -1));
            this.firePropertyChange("model", tableModel2, tableModel);
        }
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
            if (this.tableHeader != null) {
                this.tableHeader.setColumnModel(tableColumnModel);
            }
            this.firePropertyChange("columnModel", tableColumnModel2, tableColumnModel);
            this.resizeAndRepaint();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("Cannot set a null SelectionModel");
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        if (listSelectionModel != listSelectionModel2) {
            if (listSelectionModel2 != null) {
                listSelectionModel2.removeListSelectionListener(this);
            }
            this.selectionModel = listSelectionModel;
            listSelectionModel.addListSelectionListener(this);
            this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
            this.repaint();
            this.checkLeadAnchor();
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private void checkLeadAnchor() {
        TableModel tableModel = this.getModel();
        if (tableModel == null) {
            return;
        }
        int n2 = this.selectionModel.getLeadSelectionIndex();
        int n3 = tableModel.getRowCount();
        if (n3 == 0) {
            if (n2 != -1) {
                this.selectionModel.setValueIsAdjusting(true);
                this.selectionModel.setAnchorSelectionIndex(-1);
                this.selectionModel.setLeadSelectionIndex(-1);
                this.selectionModel.setValueIsAdjusting(false);
            }
        } else if (n2 == -1) {
            if (this.selectionModel.isSelectedIndex(0)) {
                this.selectionModel.addSelectionInterval(0, 0);
            } else {
                this.selectionModel.removeSelectionInterval(0, 0);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Rectangle rectangle;
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1) {
            this.clearSelection();
            this.checkLeadAnchor();
            this.rowModel = null;
            if (this.getAutoCreateColumnsFromModel()) {
                this.createDefaultColumnsFromModel();
                return;
            }
            this.resizeAndRepaint();
            return;
        }
        if (this.rowModel != null) {
            this.repaint();
        }
        if (tableModelEvent.getType() == 1) {
            this.tableRowsInserted(tableModelEvent);
            return;
        }
        if (tableModelEvent.getType() == -1) {
            this.tableRowsDeleted(tableModelEvent);
            return;
        }
        int n2 = tableModelEvent.getColumn();
        int n3 = tableModelEvent.getFirstRow();
        int n4 = tableModelEvent.getLastRow();
        if (n2 == -1) {
            rectangle = new Rectangle(0, n3 * this.getRowHeight(), this.getColumnModel().getTotalColumnWidth(), 0);
        } else {
            int n5 = this.convertColumnIndexToView(n2);
            rectangle = this.getCellRect(n3, n5, false);
        }
        if (n4 != Integer.MAX_VALUE) {
            rectangle.height = (n4 - n3 + 1) * this.getRowHeight();
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.clearSelection();
            this.resizeAndRepaint();
            this.rowModel = null;
        }
    }

    private void tableRowsInserted(TableModelEvent tableModelEvent) {
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = this.getRowCount() - 1;
        }
        int n4 = n3 - n2 + 1;
        this.selectionModel.insertIndexInterval(n2, n4, true);
        this.checkLeadAnchor();
        if (this.rowModel != null) {
            this.rowModel.insertEntries(n2, n4, this.getRowHeight());
        }
        int n5 = this.getRowHeight();
        Rectangle rectangle = new Rectangle(0, n2 * n5, this.getColumnModel().getTotalColumnWidth(), (this.getRowCount() - n2) * n5);
        this.revalidate();
        this.repaint(rectangle);
    }

    private void tableRowsDeleted(TableModelEvent tableModelEvent) {
        int n2 = tableModelEvent.getFirstRow();
        int n3 = tableModelEvent.getLastRow();
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = this.getRowCount() - 1;
        }
        int n4 = n3 - n2 + 1;
        int n5 = this.getRowCount() + n4;
        this.selectionModel.removeIndexInterval(n2, n3);
        this.checkLeadAnchor();
        if (this.rowModel != null) {
            this.rowModel.removeEntries(n2, n4);
        }
        int n6 = this.getRowHeight();
        Rectangle rectangle = new Rectangle(0, n2 * n6, this.getColumnModel().getTotalColumnWidth(), (n5 - n2) * n6);
        this.revalidate();
        this.repaint(rectangle);
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.resizeAndRepaint();
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (this.isEditing()) {
            this.removeEditor();
        }
        this.repaint();
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        TableColumn tableColumn;
        if (this.isEditing()) {
            this.removeEditor();
        }
        if ((tableColumn = this.getResizingColumn()) != null && this.autoResizeMode == 0) {
            tableColumn.setPreferredWidth(tableColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    private int limit(int n2, int n3, int n4) {
        return Math.min(n4, Math.max(n2, n3));
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl2 = listSelectionEvent.getValueIsAdjusting();
        if (this.columnSelectionAdjusting && !bl2) {
            this.columnSelectionAdjusting = false;
            return;
        }
        this.columnSelectionAdjusting = bl2;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int n2 = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getColumnCount() - 1);
        int n3 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getColumnCount() - 1);
        int n4 = 0;
        int n5 = this.getRowCount() - 1;
        if (this.getRowSelectionAllowed()) {
            n4 = this.selectionModel.getMinSelectionIndex();
            n5 = this.selectionModel.getMaxSelectionIndex();
            int n6 = this.selectionModel.getLeadSelectionIndex();
            if (n4 == -1 || n5 == -1) {
                if (n6 == -1) {
                    return;
                }
                n4 = n5 = n6;
            } else if (n6 != -1) {
                n4 = Math.min(n4, n6);
                n5 = Math.max(n5, n6);
            }
        }
        Rectangle rectangle = this.getCellRect(n4, n2, false);
        Rectangle rectangle2 = this.getCellRect(n5, n3, false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl2 = listSelectionEvent.getValueIsAdjusting();
        if (this.rowSelectionAdjusting && !bl2) {
            this.rowSelectionAdjusting = false;
            return;
        }
        this.rowSelectionAdjusting = bl2;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return;
        }
        int n2 = this.limit(listSelectionEvent.getFirstIndex(), 0, this.getRowCount() - 1);
        int n3 = this.limit(listSelectionEvent.getLastIndex(), 0, this.getRowCount() - 1);
        Rectangle rectangle = this.getCellRect(n2, 0, false);
        Rectangle rectangle2 = this.getCellRect(n3, this.getColumnCount() - 1, false);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        this.repaint(rectangle3);
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            this.setValueAt(object, this.editingRow, this.editingColumn);
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.removeEditor();
    }

    public void setPreferredScrollableViewportSize(Dimension dimension) {
        this.preferredViewportSize = dimension;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.preferredViewportSize;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
        if (n2 == 0) {
            return 100;
        }
        return this.getRowHeight();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
        if (n2 == 1) {
            int n4 = this.getRowHeight();
            return n4 > 0 ? Math.max(n4, rectangle.height / n4 * n4) : rectangle.height;
        }
        return rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.autoResizeMode != 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n2, boolean bl2) {
        boolean bl3 = super.processKeyBinding(keyStroke, keyEvent, n2, bl2);
        if (!bl3 && n2 == 1 && this.isFocusOwner() && !Boolean.FALSE.equals((Boolean)this.getClientProperty("JTable.autoStartsEdit"))) {
            Component component = this.getEditorComponent();
            if (component == null) {
                if (keyEvent == null || keyEvent.getID() != 401) {
                    return false;
                }
                int n3 = keyEvent.getKeyCode();
                if (n3 == 16 || n3 == 17 || n3 == 18) {
                    return false;
                }
                int n4 = this.getSelectionModel().getLeadSelectionIndex();
                int n5 = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (n4 != -1 && n5 != -1 && !this.isEditing() && !this.editCellAt(n4, n5)) {
                    return false;
                }
                component = this.getEditorComponent();
                if (component == null) {
                    return false;
                }
            }
            if (component instanceof JComponent) {
                bl3 = ((JComponent)component).processKeyBinding(keyStroke, keyEvent, 0, bl2);
                if (this.getSurrendersFocusOnKeystroke()) {
                    component.requestFocus();
                }
            }
        }
        return bl3;
    }

    private void setLazyValue(Hashtable hashtable, Class clazz, String string) {
        hashtable.put(clazz, new UIDefaults.ProxyLazyValue(string));
    }

    private void setLazyRenderer(Class clazz, String string) {
        this.setLazyValue(this.defaultRenderersByColumnClass, clazz, string);
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults();
        this.setLazyRenderer(Object.class, "javax.swing.table.DefaultTableCellRenderer$UIResource");
        this.setLazyRenderer(Number.class, "javax.swing.JTable$NumberRenderer");
        this.setLazyRenderer(Float.class, "javax.swing.JTable$DoubleRenderer");
        this.setLazyRenderer(Double.class, "javax.swing.JTable$DoubleRenderer");
        this.setLazyRenderer(Date.class, "javax.swing.JTable$DateRenderer");
        this.setLazyRenderer(Icon.class, "javax.swing.JTable$IconRenderer");
        this.setLazyRenderer(ImageIcon.class, "javax.swing.JTable$IconRenderer");
        this.setLazyRenderer(Boolean.class, "javax.swing.JTable$BooleanRenderer");
    }

    private void setLazyEditor(Class clazz, String string) {
        this.setLazyValue(this.defaultEditorsByColumnClass, clazz, string);
    }

    protected void createDefaultEditors() {
        this.defaultEditorsByColumnClass = new UIDefaults();
        this.setLazyEditor(Object.class, "javax.swing.JTable$GenericEditor");
        this.setLazyEditor(Number.class, "javax.swing.JTable$NumberEditor");
        this.setLazyEditor(Boolean.class, "javax.swing.JTable$BooleanEditor");
    }

    protected void initializeLocalVars() {
        this.setOpaque(true);
        this.createDefaultRenderers();
        this.createDefaultEditors();
        this.setTableHeader(this.createDefaultTableHeader());
        this.setShowGrid(true);
        this.setAutoResizeMode(2);
        this.setRowHeight(16);
        this.isRowHeightSet = false;
        this.setRowMargin(1);
        this.setRowSelectionAllowed(true);
        this.setCellEditor(null);
        this.setEditingColumn(-1);
        this.setEditingRow(-1);
        this.setSurrendersFocusOnKeystroke(false);
        this.setPreferredScrollableViewportSize(new Dimension(450, 400));
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setAutoscrolls(true);
    }

    protected TableModel createDefaultDataModel() {
        return new DefaultTableModel();
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected ListSelectionModel createDefaultSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel);
    }

    protected void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this.cellEditor;
        this.cellEditor = tableCellEditor;
        this.firePropertyChange("tableCellEditor", tableCellEditor2, tableCellEditor);
    }

    public void setEditingColumn(int n2) {
        this.editingColumn = n2;
    }

    public void setEditingRow(int n2) {
        this.editingRow = n2;
    }

    public TableCellRenderer getCellRenderer(int n2, int n3) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n3);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n3));
        }
        return tableCellRenderer;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n2, int n3) {
        Object object = this.getValueAt(n2, n3);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!this.isPrinting) {
            bl2 = this.isCellSelected(n2, n3);
            boolean bl4 = this.selectionModel.getLeadSelectionIndex() == n2;
            boolean bl5 = this.columnModel.getSelectionModel().getLeadSelectionIndex() == n3;
            bl3 = bl4 && bl5 && this.isFocusOwner();
        }
        return tableCellRenderer.getTableCellRendererComponent(this, object, bl2, bl3, n2, n3);
    }

    public TableCellEditor getCellEditor(int n2, int n3) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n3);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n3));
        }
        return tableCellEditor;
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n2, int n3) {
        JComponent jComponent;
        boolean bl2;
        Object object = this.getValueAt(n2, n3);
        Component component = tableCellEditor.getTableCellEditorComponent(this, object, bl2 = this.isCellSelected(n2, n3), n2, n3);
        if (component instanceof JComponent && (jComponent = (JComponent)component).getNextFocusableComponent() == null) {
            jComponent.setNextFocusableComponent(this);
        }
        return component;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.editorRemover);
        this.editorRemover = null;
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.removeCellEditorListener(this);
            if (this.editorComp != null) {
                this.remove(this.editorComp);
            }
            Rectangle rectangle = this.getCellRect(this.editingRow, this.editingColumn, false);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.setEditingRow(-1);
            this.editorComp = null;
            this.repaint(rectangle);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        this.createDefaultRenderers();
        this.createDefaultEditors();
        if (this.getToolTipText() == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    @Override
    void compWriteObjectNotify() {
        super.compWriteObjectNotify();
        if (this.getToolTipText() == null) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    @Override
    protected String paramString() {
        String string;
        String string2 = this.gridColor != null ? this.gridColor.toString() : "";
        String string3 = this.showHorizontalLines ? "true" : "false";
        String string4 = string = this.showVerticalLines ? "true" : "false";
        String string5 = this.autoResizeMode == 0 ? "AUTO_RESIZE_OFF" : (this.autoResizeMode == 1 ? "AUTO_RESIZE_NEXT_COLUMN" : (this.autoResizeMode == 2 ? "AUTO_RESIZE_SUBSEQUENT_COLUMNS" : (this.autoResizeMode == 3 ? "AUTO_RESIZE_LAST_COLUMN" : (this.autoResizeMode == 4 ? "AUTO_RESIZE_ALL_COLUMNS" : ""))));
        String string6 = this.autoCreateColumnsFromModel ? "true" : "false";
        String string7 = this.preferredViewportSize != null ? this.preferredViewportSize.toString() : "";
        String string8 = this.rowSelectionAllowed ? "true" : "false";
        String string9 = this.cellSelectionEnabled ? "true" : "false";
        String string10 = this.selectionForeground != null ? this.selectionForeground.toString() : "";
        String string11 = this.selectionBackground != null ? this.selectionBackground.toString() : "";
        return super.paramString() + ",autoCreateColumnsFromModel=" + string6 + ",autoResizeMode=" + string5 + ",cellSelectionEnabled=" + string9 + ",editingColumn=" + this.editingColumn + ",editingRow=" + this.editingRow + ",gridColor=" + string2 + ",preferredViewportSize=" + string7 + ",rowHeight=" + this.rowHeight + ",rowMargin=" + this.rowMargin + ",rowSelectionAllowed=" + string8 + ",selectionBackground=" + string11 + ",selectionForeground=" + string10 + ",showHorizontalLines=" + string3 + ",showVerticalLines=" + string;
    }

    public boolean print() throws PrinterException {
        return this.print(PrintMode.FIT_WIDTH);
    }

    public boolean print(PrintMode printMode) throws PrinterException {
        return this.print(printMode, null, null);
    }

    public boolean print(PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        boolean bl2 = !GraphicsEnvironment.isHeadless();
        return this.print(printMode, messageFormat, messageFormat2, bl2, null, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean print(PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2, boolean bl2, PrintRequestAttributeSet printRequestAttributeSet, boolean bl3) throws PrinterException, HeadlessException {
        Throwable throwable;
        boolean bl4 = GraphicsEnvironment.isHeadless();
        if (bl4) {
            if (bl2) {
                throw new HeadlessException("Can't show print dialog.");
            }
            if (bl3) {
                throw new HeadlessException("Can't run interactively.");
            }
        }
        if (this.isEditing() && !this.getCellEditor().stopCellEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
        if (printRequestAttributeSet == null) {
            printRequestAttributeSet = new HashPrintRequestAttributeSet();
        }
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        Printable printable = this.getPrintable(printMode, messageFormat, messageFormat2);
        if (bl3) {
            printable = new ThreadSafePrintable(printable);
        }
        printerJob.setPrintable(printable);
        if (bl2 && !printerJob.printDialog(printRequestAttributeSet)) {
            return false;
        }
        if (!bl3) {
            this.isPrinting = true;
            try {
                printerJob.print(printRequestAttributeSet);
            }
            finally {
                this.isPrinting = false;
            }
            return true;
        }
        String string = UIManager.getString("PrintingDialog.titleProgressText");
        String string2 = UIManager.getString("PrintingDialog.contentInitialText");
        MessageFormat messageFormat3 = new MessageFormat(UIManager.getString("PrintingDialog.contentProgressText"));
        String string3 = UIManager.getString("PrintingDialog.abortButtonText");
        String string4 = UIManager.getString("PrintingDialog.abortButtonToolTipText");
        int n2 = UIManager.getInt((Object)"PrintingDialog.abortButtonMnemonic", -1);
        int n3 = UIManager.getInt((Object)"PrintingDialog.abortButtonDisplayedMnemonicIndex", -1);
        final JButton jButton = new JButton(string3);
        jButton.setToolTipText(string4);
        if (n2 != -1) {
            jButton.setMnemonic(n2);
        }
        if (n3 != -1) {
            jButton.setDisplayedMnemonicIndex(n3);
        }
        final JLabel jLabel = new JLabel(string2);
        JOptionPane jOptionPane = new JOptionPane(jLabel, 1, -1, null, new Object[]{jButton}, jButton);
        final ThreadSafePrintable threadSafePrintable = (ThreadSafePrintable)printable;
        threadSafePrintable.startUpdatingStatus(messageFormat3, jLabel);
        Container container = this.getParent() instanceof JViewport ? this.getParent() : this;
        final JDialog jDialog = jOptionPane.createDialog(container, string);
        jDialog.setDefaultCloseOperation(0);
        final AbstractAction abstractAction = new AbstractAction(){
            boolean isAborted = false;

            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.isAborted) {
                    this.isAborted = true;
                    jButton.setEnabled(false);
                    jDialog.setTitle(UIManager.getString("PrintingDialog.titleAbortingText"));
                    jLabel.setText(UIManager.getString("PrintingDialog.contentAbortingText"));
                    threadSafePrintable.stopUpdatingStatus();
                    printerJob.cancel();
                }
            }
        };
        jButton.addActionListener(abstractAction);
        jOptionPane.getActionMap().put("close", abstractAction);
        final WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                abstractAction.actionPerformed(null);
            }
        };
        jDialog.addWindowListener(windowAdapter);
        this.printError = null;
        final Object object = new Object();
        final PrintRequestAttributeSet printRequestAttributeSet2 = printRequestAttributeSet;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    printerJob.print(printRequestAttributeSet2);
                }
                catch (Throwable throwable) {
                    try {
                        Object object2 = object;
                        synchronized (object2) {
                            JTable.this.printError = throwable;
                        }
                    }
                    catch (Throwable throwable2) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                jDialog.removeWindowListener(windowAdapter);
                                jDialog.dispose();
                            }
                        });
                        throw throwable2;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        jDialog.setVisible(true);
        Object object2 = object;
        synchronized (object2) {
            throwable = this.printError;
            this.printError = null;
        }
        if (throwable != null) {
            if (throwable instanceof PrinterAbortException) {
                return false;
            }
            if (throwable instanceof PrinterException) {
                throw (PrinterException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)throwable);
        }
        return true;
    }

    public Printable getPrintable(PrintMode printMode, MessageFormat messageFormat, MessageFormat messageFormat2) {
        return new TablePrintable(this, printMode, messageFormat, messageFormat2);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTable();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTable
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ListSelectionListener,
    TableModelListener,
    TableColumnModelListener,
    CellEditorListener,
    PropertyChangeListener,
    AccessibleExtendedTable {
        int lastSelectedRow;
        int lastSelectedCol;
        private Accessible caption;
        private Accessible summary;
        private Accessible[] rowDescription;
        private Accessible[] columnDescription;

        protected AccessibleJTable() {
            JTable.this.addPropertyChangeListener(this);
            JTable.this.getSelectionModel().addListSelectionListener(this);
            TableColumnModel tableColumnModel = JTable.this.getColumnModel();
            tableColumnModel.addColumnModelListener(this);
            tableColumnModel.getSelectionModel().addListSelectionListener(this);
            JTable.this.getModel().addTableModelListener(this);
            this.lastSelectedRow = JTable.this.getSelectedRow();
            this.lastSelectedCol = JTable.this.getSelectedColumn();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (string.compareTo("model") == 0) {
                if (object != null && object instanceof TableModel) {
                    ((TableModel)object).removeTableModelListener(this);
                }
                if (object2 != null && object2 instanceof TableModel) {
                    ((TableModel)object2).addTableModelListener(this);
                }
            } else if (string.compareTo("selectionModel") == 0) {
                Object object3 = propertyChangeEvent.getSource();
                if (object3 == JTable.this) {
                    if (object != null && object instanceof ListSelectionModel) {
                        ((ListSelectionModel)object).removeListSelectionListener(this);
                    }
                    if (object2 != null && object2 instanceof ListSelectionModel) {
                        ((ListSelectionModel)object2).addListSelectionListener(this);
                    }
                } else if (object3 == JTable.this.getColumnModel()) {
                    if (object != null && object instanceof ListSelectionModel) {
                        ((ListSelectionModel)object).removeListSelectionListener(this);
                    }
                    if (object2 != null && object2 instanceof ListSelectionModel) {
                        ((ListSelectionModel)object2).addListSelectionListener(this);
                    }
                }
            } else if (string.compareTo("columnModel") == 0) {
                TableColumnModel tableColumnModel;
                if (object != null && object instanceof TableColumnModel) {
                    tableColumnModel = (TableColumnModel)object;
                    tableColumnModel.removeColumnModelListener(this);
                    tableColumnModel.getSelectionModel().removeListSelectionListener(this);
                }
                if (object2 != null && object2 instanceof TableColumnModel) {
                    tableColumnModel = (TableColumnModel)object2;
                    tableColumnModel.addColumnModelListener(this);
                    tableColumnModel.getSelectionModel().addListSelectionListener(this);
                }
            } else if (string.compareTo("tableCellEditor") == 0) {
                if (object != null && object instanceof TableCellEditor) {
                    ((TableCellEditor)object).removeCellEditorListener(this);
                }
                if (object2 != null && object2 instanceof TableCellEditor) {
                    ((TableCellEditor)object2).addCellEditorListener(this);
                }
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            if (tableModelEvent != null) {
                int n2 = tableModelEvent.getColumn();
                int n3 = tableModelEvent.getColumn();
                if (n2 == -1) {
                    n2 = 0;
                    n3 = JTable.this.getColumnCount() - 1;
                }
                AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n2, n3);
                this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
            }
        }

        public void tableRowsInserted(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = tableModelEvent.getColumn();
            int n3 = tableModelEvent.getColumn();
            if (n2 == -1) {
                n2 = 0;
                n3 = JTable.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n2, n3);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void tableRowsDeleted(TableModelEvent tableModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = tableModelEvent.getColumn();
            int n3 = tableModelEvent.getColumn();
            if (n2 == -1) {
                n2 = 0;
                n3 = JTable.this.getColumnCount() - 1;
            }
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(tableModelEvent.getType(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), n2, n3);
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = 1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(n2, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = -1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(n2, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
            int n2 = -1;
            AccessibleJTableModelChange accessibleJTableModelChange = new AccessibleJTableModelChange(n2, 0, 0, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getFromIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange);
            int n3 = 1;
            AccessibleJTableModelChange accessibleJTableModelChange2 = new AccessibleJTableModelChange(n3, 0, 0, tableColumnModelEvent.getToIndex(), tableColumnModelEvent.getToIndex());
            this.firePropertyChange("accessibleTableModelChanged", null, accessibleJTableModelChange2);
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void editingStopped(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", null, null);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.firePropertyChange("AccessibleSelection", false, true);
            int n2 = JTable.this.getSelectedRow();
            int n3 = JTable.this.getSelectedColumn();
            if (n2 != this.lastSelectedRow || n3 != this.lastSelectedCol) {
                Accessible accessible = this.getAccessibleAt(this.lastSelectedRow, this.lastSelectedCol);
                Accessible accessible2 = this.getAccessibleAt(n2, n3);
                this.firePropertyChange("AccessibleActiveDescendant", accessible, accessible2);
                this.lastSelectedRow = n2;
                this.lastSelectedCol = n3;
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public Accessible getAccessibleAt(Point point) {
            int n2 = JTable.this.columnAtPoint(point);
            int n3 = JTable.this.rowAtPoint(point);
            if (n2 != -1 && n3 != -1) {
                Serializable serializable;
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(n2);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    serializable = JTable.this.getColumnClass(n2);
                    tableCellRenderer = JTable.this.getDefaultRenderer((Class<?>)serializable);
                }
                serializable = tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, n3, n2);
                return new AccessibleJTableCell(JTable.this, n3, n2, this.getAccessibleIndexAt(n3, n2));
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return JTable.this.getColumnCount() * JTable.this.getRowCount();
        }

        public Accessible getAccessibleChild(int n2) {
            Serializable serializable;
            if (n2 < 0 || n2 >= this.getAccessibleChildrenCount()) {
                return null;
            }
            int n3 = this.getAccessibleColumnAtIndex(n2);
            int n4 = this.getAccessibleRowAtIndex(n2);
            TableColumn tableColumn = JTable.this.getColumnModel().getColumn(n3);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                serializable = JTable.this.getColumnClass(n3);
                tableCellRenderer = JTable.this.getDefaultRenderer((Class<?>)serializable);
            }
            serializable = tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, n4, n3);
            return new AccessibleJTableCell(JTable.this, n4, n3, this.getAccessibleIndexAt(n4, n3));
        }

        public int getAccessibleSelectionCount() {
            int n2 = JTable.this.getSelectedRowCount();
            int n3 = JTable.this.getSelectedColumnCount();
            if (JTable.this.cellSelectionEnabled) {
                return n2 * n3;
            }
            if (JTable.this.getRowSelectionAllowed() && JTable.this.getColumnSelectionAllowed()) {
                return n2 * JTable.this.getColumnCount() + n3 * JTable.this.getRowCount() - n2 * n3;
            }
            if (JTable.this.getRowSelectionAllowed()) {
                return n2 * JTable.this.getColumnCount();
            }
            if (JTable.this.getColumnSelectionAllowed()) {
                return n3 * JTable.this.getRowCount();
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n2) {
            if (n2 < 0 || n2 > this.getAccessibleSelectionCount()) {
                return null;
            }
            int n3 = JTable.this.getSelectedRowCount();
            int n4 = JTable.this.getSelectedColumnCount();
            int[] nArray = JTable.this.getSelectedRows();
            int[] nArray2 = JTable.this.getSelectedColumns();
            int n5 = JTable.this.getColumnCount();
            int n6 = JTable.this.getRowCount();
            if (JTable.this.cellSelectionEnabled) {
                int n7 = nArray[n2 / n4];
                int n8 = nArray2[n2 % n4];
                return this.getAccessibleChild(n7 * n5 + n8);
            }
            if (JTable.this.getRowSelectionAllowed() && JTable.this.getColumnSelectionAllowed()) {
                int n9 = n2;
                int n10 = nArray[0] == 0 ? 0 : 1;
                int n11 = 0;
                int n12 = -1;
                while (n11 < nArray.length) {
                    switch (n10) {
                        case 0: {
                            if (n9 < n5) {
                                int n13 = n9 % n5;
                                int n14 = nArray[n11];
                                return this.getAccessibleChild(n14 * n5 + n13);
                            }
                            n9 -= n5;
                            if (n11 + 1 == nArray.length || nArray[n11] != nArray[n11 + 1] - 1) {
                                n10 = 1;
                                n12 = nArray[n11];
                            }
                            ++n11;
                            break;
                        }
                        case 1: {
                            if (n9 < n4 * (nArray[n11] - (n12 == -1 ? 0 : n12 + 1))) {
                                int n15 = nArray2[n9 % n4];
                                int n16 = (n11 > 0 ? nArray[n11 - 1] + 1 : 0) + n9 / n4;
                                return this.getAccessibleChild(n16 * n5 + n15);
                            }
                            n9 -= n4 * (nArray[n11] - (n12 == -1 ? 0 : n12 + 1));
                            n10 = 0;
                        }
                    }
                }
                if (n9 < n4 * (n6 - (n12 == -1 ? 0 : n12 + 1))) {
                    int n17 = nArray2[n9 % n4];
                    int n18 = nArray[n11 - 1] + n9 / n4 + 1;
                    return this.getAccessibleChild(n18 * n5 + n17);
                }
            } else {
                if (JTable.this.getRowSelectionAllowed()) {
                    int n19 = n2 % n5;
                    int n20 = nArray[n2 / n5];
                    return this.getAccessibleChild(n20 * n5 + n19);
                }
                if (JTable.this.getColumnSelectionAllowed()) {
                    int n21 = nArray2[n2 % n4];
                    int n22 = n2 / n4;
                    return this.getAccessibleChild(n22 * n5 + n21);
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n2) {
            int n3 = this.getAccessibleColumnAtIndex(n2);
            int n4 = this.getAccessibleRowAtIndex(n2);
            return JTable.this.isCellSelected(n4, n3);
        }

        public void addAccessibleSelection(int n2) {
            int n3 = this.getAccessibleColumnAtIndex(n2);
            int n4 = this.getAccessibleRowAtIndex(n2);
            JTable.this.changeSelection(n4, n3, true, false);
        }

        public void removeAccessibleSelection(int n2) {
            if (JTable.this.cellSelectionEnabled) {
                int n3 = this.getAccessibleColumnAtIndex(n2);
                int n4 = this.getAccessibleRowAtIndex(n2);
                JTable.this.removeRowSelectionInterval(n4, n4);
                JTable.this.removeColumnSelectionInterval(n3, n3);
            }
        }

        public void clearAccessibleSelection() {
            JTable.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            if (JTable.this.cellSelectionEnabled) {
                JTable.this.selectAll();
            }
        }

        public int getAccessibleRow(int n2) {
            return this.getAccessibleRowAtIndex(n2);
        }

        public int getAccessibleColumn(int n2) {
            return this.getAccessibleColumnAtIndex(n2);
        }

        public int getAccessibleIndex(int n2, int n3) {
            return this.getAccessibleIndexAt(n2, n3);
        }

        public AccessibleTable getAccessibleTable() {
            return this;
        }

        public Accessible getAccessibleCaption() {
            return this.caption;
        }

        public void setAccessibleCaption(Accessible accessible) {
            Accessible accessible2 = this.caption;
            this.caption = accessible;
            this.firePropertyChange("accessibleTableCaptionChanged", accessible2, this.caption);
        }

        public Accessible getAccessibleSummary() {
            return this.summary;
        }

        public void setAccessibleSummary(Accessible accessible) {
            Accessible accessible2 = this.summary;
            this.summary = accessible;
            this.firePropertyChange("accessibleTableSummaryChanged", accessible2, this.summary);
        }

        public int getAccessibleRowCount() {
            return JTable.this.getRowCount();
        }

        public int getAccessibleColumnCount() {
            return JTable.this.getColumnCount();
        }

        public Accessible getAccessibleAt(int n2, int n3) {
            return this.getAccessibleChild(n2 * this.getAccessibleColumnCount() + n3);
        }

        public int getAccessibleRowExtentAt(int n2, int n3) {
            return 1;
        }

        public int getAccessibleColumnExtentAt(int n2, int n3) {
            return 1;
        }

        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
        }

        public AccessibleTable getAccessibleColumnHeader() {
            JTableHeader jTableHeader = JTable.this.getTableHeader();
            return jTableHeader == null ? null : new AccessibleTableHeader(jTableHeader);
        }

        public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
        }

        public Accessible getAccessibleRowDescription(int n2) {
            if (n2 < 0 || n2 >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(new Integer(n2).toString());
            }
            if (this.rowDescription == null) {
                return null;
            }
            return this.rowDescription[n2];
        }

        public void setAccessibleRowDescription(int n2, Accessible accessible) {
            if (n2 < 0 || n2 >= this.getAccessibleRowCount()) {
                throw new IllegalArgumentException(new Integer(n2).toString());
            }
            if (this.rowDescription == null) {
                int n3 = this.getAccessibleRowCount();
                this.rowDescription = new Accessible[n3];
            }
            this.rowDescription[n2] = accessible;
        }

        public Accessible getAccessibleColumnDescription(int n2) {
            if (n2 < 0 || n2 >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(new Integer(n2).toString());
            }
            if (this.columnDescription == null) {
                return null;
            }
            return this.columnDescription[n2];
        }

        public void setAccessibleColumnDescription(int n2, Accessible accessible) {
            if (n2 < 0 || n2 >= this.getAccessibleColumnCount()) {
                throw new IllegalArgumentException(new Integer(n2).toString());
            }
            if (this.columnDescription == null) {
                int n3 = this.getAccessibleColumnCount();
                this.columnDescription = new Accessible[n3];
            }
            this.columnDescription[n2] = accessible;
        }

        public boolean isAccessibleSelected(int n2, int n3) {
            return JTable.this.isCellSelected(n2, n3);
        }

        public boolean isAccessibleRowSelected(int n2) {
            return JTable.this.isRowSelected(n2);
        }

        public boolean isAccessibleColumnSelected(int n2) {
            return JTable.this.isColumnSelected(n2);
        }

        public int[] getSelectedAccessibleRows() {
            return JTable.this.getSelectedRows();
        }

        public int[] getSelectedAccessibleColumns() {
            return JTable.this.getSelectedColumns();
        }

        public int getAccessibleRowAtIndex(int n2) {
            int n3 = this.getAccessibleColumnCount();
            if (n3 == 0) {
                return -1;
            }
            return n2 / n3;
        }

        public int getAccessibleColumnAtIndex(int n2) {
            int n3 = this.getAccessibleColumnCount();
            if (n3 == 0) {
                return -1;
            }
            return n2 % n3;
        }

        public int getAccessibleIndexAt(int n2, int n3) {
            return n2 * this.getAccessibleColumnCount() + n3;
        }

        protected class AccessibleJTableCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTable parent;
            private int row;
            private int column;
            private int index;

            public AccessibleJTableCell(JTable jTable, int n2, int n3, int n4) {
                this.parent = jTable;
                this.row = n2;
                this.column = n3;
                this.index = n4;
                this.setAccessibleParent(this.parent);
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Serializable serializable;
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    serializable = JTable.this.getColumnClass(this.column);
                    tableCellRenderer = JTable.this.getDefaultRenderer((Class<?>)serializable);
                }
                if ((serializable = tableCellRenderer.getTableCellRendererComponent(JTable.this, JTable.this.getValueAt(this.row, this.column), false, false, this.row, this.column)) instanceof Accessible) {
                    return ((Accessible)((Object)serializable)).getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                TableColumn tableColumn = JTable.this.getColumnModel().getColumn(this.column);
                TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                if (tableCellRenderer == null) {
                    Class<?> clazz = JTable.this.getColumnClass(this.column);
                    tableCellRenderer = JTable.this.getDefaultRenderer(clazz);
                }
                return tableCellRenderer.getTableCellRendererComponent(JTable.this, null, false, false, this.row, this.column);
            }

            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return null;
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle rectangle;
                Rectangle rectangle2;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = null;
                if (accessibleContext != null) {
                    accessibleStateSet = accessibleContext.getAccessibleStateSet();
                }
                if (accessibleStateSet == null) {
                    accessibleStateSet = new AccessibleStateSet();
                }
                if ((rectangle2 = JTable.this.getVisibleRect()).intersects(rectangle = JTable.this.getCellRect(this.row, this.column, false))) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.parent.isCellSelected(this.row, this.column)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                } else if (accessibleStateSet.contains(AccessibleState.SELECTED)) {
                    accessibleStateSet.remove(AccessibleState.SELECTED);
                }
                if (this.row == JTable.this.getSelectedRow() && this.column == JTable.this.getSelectedColumn()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            public Accessible getAccessibleParent() {
                return this.parent;
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int n2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n2);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl2);
                    }
                }
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            public void setVisible(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setVisible(bl2);
                    }
                }
            }

            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    if (accessibleContext.getAccessibleParent() != null) {
                        return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
                    }
                    return this.isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isShowing();
                }
                return false;
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Point getLocation() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellRect(this.row, this.column, false);
                }
                return null;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            public Dimension getSize() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getCellRect(this.row, this.column, false)) != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }
        }

        private class AccessibleJTableHeaderCell
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private int row;
            private int column;
            private JTableHeader parent;
            private Component rendererComponent;

            public AccessibleJTableHeaderCell(int n2, int n3, JTableHeader jTableHeader, Component component) {
                this.row = n2;
                this.column = n3;
                this.parent = jTableHeader;
                this.rendererComponent = component;
                this.setAccessibleParent(jTableHeader);
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                return this.rendererComponent.getAccessibleContext();
            }

            private Component getCurrentComponent() {
                return this.rendererComponent;
            }

            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return null;
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                Rectangle rectangle;
                Rectangle rectangle2;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = null;
                if (accessibleContext != null) {
                    accessibleStateSet = accessibleContext.getAccessibleStateSet();
                }
                if (accessibleStateSet == null) {
                    accessibleStateSet = new AccessibleStateSet();
                }
                if ((rectangle2 = JTable.this.getVisibleRect()).intersects(rectangle = JTable.this.getCellRect(this.row, this.column, false))) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (JTable.this.isCellSelected(this.row, this.column)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                } else if (accessibleStateSet.contains(AccessibleState.SELECTED)) {
                    accessibleStateSet.remove(AccessibleState.SELECTED);
                }
                if (this.row == JTable.this.getSelectedRow() && this.column == JTable.this.getSelectedColumn()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            public Accessible getAccessibleParent() {
                return this.parent;
            }

            public int getAccessibleIndexInParent() {
                return this.column;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int n2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n2);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl2);
                    }
                }
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            public void setVisible(boolean bl2) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl2);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setVisible(bl2);
                    }
                }
            }

            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    if (accessibleContext.getAccessibleParent() != null) {
                        return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
                    }
                    return this.isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isShowing();
                }
                return false;
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Point getLocation() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getHeaderRect(this.column)) != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getHeaderRect(this.column);
                }
                return null;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            public Dimension getSize() {
                Rectangle rectangle;
                if (this.parent != null && (rectangle = this.parent.getHeaderRect(this.column)) != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }
        }

        protected class AccessibleJTableModelChange
        implements AccessibleTableModelChange {
            protected int type;
            protected int firstRow;
            protected int lastRow;
            protected int firstColumn;
            protected int lastColumn;

            protected AccessibleJTableModelChange(int n2, int n3, int n4, int n5, int n6) {
                this.type = n2;
                this.firstRow = n3;
                this.lastRow = n4;
                this.firstColumn = n5;
                this.lastColumn = n6;
            }

            public int getType() {
                return this.type;
            }

            public int getFirstRow() {
                return this.firstRow;
            }

            public int getLastRow() {
                return this.lastRow;
            }

            public int getFirstColumn() {
                return this.firstColumn;
            }

            public int getLastColumn() {
                return this.lastColumn;
            }
        }

        private class AccessibleTableHeader
        implements AccessibleTable {
            private JTableHeader header;
            private TableColumnModel headerModel;

            AccessibleTableHeader(JTableHeader jTableHeader) {
                this.header = jTableHeader;
                this.headerModel = jTableHeader.getColumnModel();
            }

            public Accessible getAccessibleCaption() {
                return null;
            }

            public void setAccessibleCaption(Accessible accessible) {
            }

            public Accessible getAccessibleSummary() {
                return null;
            }

            public void setAccessibleSummary(Accessible accessible) {
            }

            public int getAccessibleRowCount() {
                return 1;
            }

            public int getAccessibleColumnCount() {
                return this.headerModel.getColumnCount();
            }

            public Accessible getAccessibleAt(int n2, int n3) {
                TableColumn tableColumn = this.headerModel.getColumn(n3);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = this.header.getDefaultRenderer();
                }
                Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n3);
                return new AccessibleJTableHeaderCell(n2, n3, JTable.this.getTableHeader(), component);
            }

            public int getAccessibleRowExtentAt(int n2, int n3) {
                return 1;
            }

            public int getAccessibleColumnExtentAt(int n2, int n3) {
                return 1;
            }

            public AccessibleTable getAccessibleRowHeader() {
                return null;
            }

            public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
            }

            public AccessibleTable getAccessibleColumnHeader() {
                return null;
            }

            public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
            }

            public Accessible getAccessibleRowDescription(int n2) {
                return null;
            }

            public void setAccessibleRowDescription(int n2, Accessible accessible) {
            }

            public Accessible getAccessibleColumnDescription(int n2) {
                return null;
            }

            public void setAccessibleColumnDescription(int n2, Accessible accessible) {
            }

            public boolean isAccessibleSelected(int n2, int n3) {
                return false;
            }

            public boolean isAccessibleRowSelected(int n2) {
                return false;
            }

            public boolean isAccessibleColumnSelected(int n2) {
                return false;
            }

            public int[] getSelectedAccessibleRows() {
                return new int[0];
            }

            public int[] getSelectedAccessibleColumns() {
                return new int[0];
            }
        }
    }

    static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setHorizontalAlignment(0);
        }
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (bl2) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl3) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!JTable.this.isEditing() || JTable.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                return;
            }
            for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                if (component == JTable.this) {
                    return;
                }
                if (!(component instanceof Window) && (!(component instanceof Applet) || component.getParent() != null)) continue;
                if (component != SwingUtilities.getRoot(JTable.this) || JTable.this.getCellEditor().stopCellEditing()) break;
                JTable.this.getCellEditor().cancelCellEditing();
                break;
            }
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer.UIResource {
        DateFormat formatter;

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    static class DoubleRenderer
    extends NumberRenderer {
        NumberFormat formatter;

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    static class GenericEditor
    extends DefaultCellEditor {
        Class[] argTypes = new Class[]{String.class};
        Constructor constructor;
        Object value;

        public GenericEditor() {
            super(new JTextField());
            this.getComponent().setName("Table.editor");
        }

        public boolean stopCellEditing() {
            String string = (String)super.getCellEditorValue();
            if ("".equals(string)) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = string;
                }
                super.stopCellEditing();
            }
            try {
                this.value = this.constructor.newInstance(string);
            }
            catch (Exception exception) {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
            return super.stopCellEditing();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> clazz = jTable.getColumnClass(n3);
                if (clazz == Object.class) {
                    clazz = String.class;
                }
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
        }

        public Object getCellEditorValue() {
            return this.value;
        }
    }

    static class IconRenderer
    extends DefaultTableCellRenderer.UIResource {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object object) {
            this.setIcon(object instanceof Icon ? (Icon)object : null);
        }
    }

    static class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    static class NumberRenderer
    extends DefaultTableCellRenderer.UIResource {
        public NumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrintMode {
        NORMAL,
        FIT_WIDTH;

    }

    private static interface Resizable2 {
        public int getElementCount();

        public int getLowerBoundAt(int var1);

        public int getUpperBoundAt(int var1);

        public void setSizeAt(int var1, int var2);
    }

    private static interface Resizable3
    extends Resizable2 {
        public int getMidPointAt(int var1);
    }

    private class ThreadSafePrintable
    implements Printable {
        private Printable printDelegate;
        private MessageFormat statusFormat;
        private JLabel statusLabel;
        private int retVal;
        private Throwable retThrowable;

        public ThreadSafePrintable(Printable printable) {
            this.printDelegate = printable;
        }

        public void startUpdatingStatus(MessageFormat messageFormat, JLabel jLabel) {
            this.statusFormat = messageFormat;
            this.statusLabel = jLabel;
        }

        public void stopUpdatingStatus() {
            this.statusFormat = null;
            this.statusLabel = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int print(final Graphics graphics, final PageFormat pageFormat, final int n2) throws PrinterException {
            Runnable runnable;
            Runnable runnable2 = runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public synchronized void run() {
                    JTable.this.isPrinting = true;
                    try {
                        if (ThreadSafePrintable.this.statusLabel != null) {
                            Object[] objectArray = new Object[]{new Integer(n2 + 1)};
                            ThreadSafePrintable.this.statusLabel.setText(ThreadSafePrintable.this.statusFormat.format(objectArray));
                        }
                        ThreadSafePrintable.this.retVal = ThreadSafePrintable.this.printDelegate.print(graphics, pageFormat, n2);
                    }
                    catch (Throwable throwable) {
                        ThreadSafePrintable.this.retThrowable = throwable;
                    }
                    finally {
                        JTable.this.isPrinting = false;
                        this.notifyAll();
                    }
                }
            };
            synchronized (runnable2) {
                this.retVal = -1;
                this.retThrowable = null;
                SwingUtilities.invokeLater(runnable);
                while (this.retVal == -1 && this.retThrowable == null) {
                    try {
                        runnable.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.retThrowable != null) {
                    if (this.retThrowable instanceof PrinterException) {
                        throw (PrinterException)this.retThrowable;
                    }
                    if (this.retThrowable instanceof RuntimeException) {
                        throw (RuntimeException)this.retThrowable;
                    }
                    if (this.retThrowable instanceof Error) {
                        throw (Error)this.retThrowable;
                    }
                    throw new AssertionError((Object)this.retThrowable);
                }
                return this.retVal;
            }
        }
    }
}

