/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.View;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    protected JTabbedPane tabPane;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected Color darkShadow;
    protected Color focus;
    private Color selectedColor;
    protected int textIconGap;
    protected int tabRunOverlay;
    protected Insets tabInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets contentBorderInsets;
    private boolean tabsOverlapBorder;
    private boolean tabsOpaque = true;
    private boolean contentOpaque = true;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected int[] tabRuns = new int[10];
    protected int runCount = 0;
    protected int selectedRun = -1;
    protected Rectangle[] rects = new Rectangle[0];
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected ChangeListener tabChangeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MouseListener mouseListener;
    protected FocusListener focusListener;
    private Insets currentPadInsets = new Insets(0, 0, 0, 0);
    private Insets currentTabAreaInsets = new Insets(0, 0, 0, 0);
    private Component visibleComponent;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    protected transient Rectangle calcRect = new Rectangle(0, 0, 0, 0);
    private int focusIndex;
    private Handler handler;
    private int rolloverTabIndex;
    private boolean isRunsDirty;
    private int[] xCropLen = new int[]{1, 1, 0, 0, 1, 1, 2, 2};
    private int[] yCropLen = new int[]{0, 3, 3, 6, 6, 9, 9, 12};
    private static final int CROP_SEGMENT = 12;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTabbedPaneUI();
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("navigateNext"));
        lazyActionMap.put(new Actions("navigatePrevious"));
        lazyActionMap.put(new Actions("navigateRight"));
        lazyActionMap.put(new Actions("navigateLeft"));
        lazyActionMap.put(new Actions("navigateUp"));
        lazyActionMap.put(new Actions("navigateDown"));
        lazyActionMap.put(new Actions("navigatePageUp"));
        lazyActionMap.put(new Actions("navigatePageDown"));
        lazyActionMap.put(new Actions("requestFocus"));
        lazyActionMap.put(new Actions("requestFocusForVisibleComponent"));
        lazyActionMap.put(new Actions("setSelectedIndex"));
        lazyActionMap.put(new Actions("selectTabWithFocus"));
        lazyActionMap.put(new Actions("scrollTabsForwardAction"));
        lazyActionMap.put(new Actions("scrollTabsBackwardAction"));
    }

    public void installUI(JComponent jComponent) {
        this.tabPane = (JTabbedPane)jComponent;
        this.rolloverTabIndex = -1;
        jComponent.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        jComponent.setLayout(null);
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return new TabbedPaneScrollLayout();
        }
        return new TabbedPaneLayout();
    }

    private boolean scrollableTabLayoutEnabled() {
        return this.tabPane.getLayout() instanceof TabbedPaneScrollLayout;
    }

    protected void installComponents() {
        if (this.scrollableTabLayoutEnabled() && this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
        }
    }

    protected JButton createScrollButton(int n2) {
        if (n2 != 5 && n2 != 1 && n2 != 3 && n2 != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new ScrollableTabButton(n2);
    }

    protected void uninstallComponents() {
        if (this.scrollableTabLayoutEnabled()) {
            this.tabPane.remove(this.tabScroller.viewport);
            this.tabPane.remove(this.tabScroller.scrollForwardButton);
            this.tabPane.remove(this.tabScroller.scrollBackwardButton);
            this.tabScroller = null;
        }
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.highlight = UIManager.getColor("TabbedPane.light");
        this.lightHighlight = UIManager.getColor("TabbedPane.highlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.selectedColor = UIManager.getColor("TabbedPane.selected");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.selectedTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabAreaInsets");
        this.tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.contentBorderInsets");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.contentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        Object object = UIManager.get("TabbedPane.opaque");
        if (object == null) {
            object = Boolean.FALSE;
        }
        LookAndFeel.installProperty(this.tabPane, "opaque", object);
    }

    protected void uninstallDefaults() {
        this.highlight = null;
        this.lightHighlight = null;
        this.shadow = null;
        this.darkShadow = null;
        this.focus = null;
        this.tabInsets = null;
        this.selectedTabPadInsets = null;
        this.tabAreaInsets = null;
        this.contentBorderInsets = null;
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabPane.addMouseListener(this.mouseListener);
        }
        this.tabPane.addMouseMotionListener(this.getHandler());
        this.focusListener = this.createFocusListener();
        if (this.focusListener != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        this.tabPane.addContainerListener(this.getHandler());
        if (this.tabPane.getTabCount() > 0) {
            this.htmlViews = this.createHTMLVector();
        }
    }

    protected void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabPane.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        this.tabPane.removeMouseMotionListener(this.getHandler());
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        this.tabPane.removeContainerListener(this.getHandler());
        if (this.htmlViews != null) {
            this.htmlViews.removeAllElements();
            this.htmlViews = null;
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        this.handler = null;
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected ChangeListener createChangeListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.tabPane, BasicTabbedPaneUI.class, "TabbedPane.actionMap");
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.ancestorInputMap");
        }
        if (n2 == 0) {
            return (InputMap)DefaultLookup.get(this.tabPane, this, "TabbedPane.focusInputMap");
        }
        return null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int i2 = this.tabPane.getTabCount() - 1; i2 >= 0; --i2) {
            int n2 = this.tabPane.getMnemonicAt(i2);
            if (n2 <= 0) continue;
            this.addMnemonic(i2, n2);
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int n2, int n3) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(n3, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(n3), new Integer(n2));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new ComponentInputMapUIResource(this.tabPane);
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 2));
        SwingUtilities.replaceUIInputMap(this.tabPane, 2, this.mnemonicInputMap);
    }

    private void setRolloverTab(int n2, int n3) {
        this.setRolloverTab(this.tabForCoordinate(this.tabPane, n2, n3, false));
    }

    protected void setRolloverTab(int n2) {
        this.rolloverTabIndex = n2;
    }

    protected int getRolloverTab() {
        return this.rolloverTabIndex;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n2 = this.tabPane.getSelectedIndex();
        int n3 = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        if (this.tabsOverlapBorder) {
            this.paintContentBorder(graphics, n3, n2);
        }
        if (!this.scrollableTabLayoutEnabled()) {
            this.paintTabArea(graphics, n3, n2);
        }
        if (!this.tabsOverlapBorder) {
            this.paintContentBorder(graphics, n3, n2);
        }
    }

    protected void paintTabArea(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getTabCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = graphics.getClipBounds();
        for (int i2 = this.runCount - 1; i2 >= 0; --i2) {
            int n5 = this.tabRuns[i2];
            int n6 = this.tabRuns[i2 == this.runCount - 1 ? 0 : i2 + 1];
            int n7 = n6 != 0 ? n6 - 1 : n4 - 1;
            for (int i3 = n5; i3 <= n7; ++i3) {
                if (i3 == n3 || !this.rects[i3].intersects(rectangle3)) continue;
                this.paintTab(graphics, n2, this.rects, i3, rectangle, rectangle2);
            }
        }
        if (n3 >= 0 && this.rects[n3].intersects(rectangle3)) {
            this.paintTab(graphics, n2, this.rects, n3, rectangle, rectangle2);
        }
    }

    protected void paintTab(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n3];
        int n4 = this.tabPane.getSelectedIndex();
        boolean bl2 = n4 == n3;
        Graphics2D graphics2D = null;
        Polygon polygon = null;
        Shape shape = null;
        int n5 = 0;
        int n6 = 0;
        if (this.scrollableTabLayoutEnabled() && graphics instanceof Graphics2D) {
            graphics2D = (Graphics2D)graphics;
            object = this.tabScroller.viewport.getViewRect();
            switch (n2) {
                case 2: 
                case 4: {
                    int n7 = ((Rectangle)object).y + ((Rectangle)object).height;
                    if (rectangle3.y >= n7 || rectangle3.y + rectangle3.height <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = rectangle3.x;
                    n6 = n7 - 1;
                    break;
                }
                default: {
                    int n7 = ((Rectangle)object).x + ((Rectangle)object).width;
                    if (rectangle3.x >= n7 || rectangle3.x + rectangle3.width <= n7) break;
                    polygon = this.createCroppedTabClip(n2, rectangle3, n7);
                    n5 = n7 - 1;
                    n6 = rectangle3.y;
                }
            }
            if (polygon != null) {
                shape = graphics2D.getClip();
                graphics2D.clip(polygon);
            }
        }
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        }
        this.paintTabBorder(graphics, n2, n3, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl2);
        object = this.tabPane.getTitleAt(n3);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.tabPane, graphics, font);
        Icon icon = this.getIconForTab(n3);
        this.layoutLabel(n2, fontMetrics, n3, (String)object, icon, rectangle3, rectangle, rectangle2, bl2);
        this.paintText(graphics, n2, font, fontMetrics, n3, (String)object, rectangle2, bl2);
        this.paintIcon(graphics, n2, n3, icon, rectangle, bl2);
        this.paintFocusIndicator(graphics, n2, rectangleArray, n3, rectangle, rectangle2, bl2);
        if (polygon != null) {
            this.paintCroppedTabEdge(graphics, n2, n3, bl2, n5, n6);
            graphics2D.setClip(shape);
        }
    }

    private Polygon createCroppedTabClip(int n2, Rectangle rectangle, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (n2) {
            case 2: 
            case 4: {
                n4 = rectangle.width;
                n5 = rectangle.x;
                n6 = rectangle.x + rectangle.width;
                n7 = rectangle.y;
                break;
            }
            default: {
                n4 = rectangle.height;
                n5 = rectangle.y;
                n6 = rectangle.y + rectangle.height;
                n7 = rectangle.x;
            }
        }
        int n8 = n4 / 12;
        if (n4 % 12 > 0) {
            ++n8;
        }
        int n9 = 2 + n8 * 8;
        int[] nArray = new int[n9];
        int[] nArray2 = new int[n9];
        int n10 = 0;
        nArray[n10] = n7;
        nArray2[n10++] = n6;
        nArray[n10] = n7;
        nArray2[n10++] = n5;
        block3: for (int i2 = 0; i2 < n8; ++i2) {
            for (int i3 = 0; i3 < this.xCropLen.length; ++i3) {
                nArray[n10] = n3 - this.xCropLen[i3];
                nArray2[n10] = n5 + i2 * 12 + this.yCropLen[i3];
                if (nArray2[n10] >= n6) {
                    nArray2[n10] = n6;
                    ++n10;
                    continue block3;
                }
                ++n10;
            }
        }
        if (n2 == 1 || n2 == 3) {
            return new Polygon(nArray, nArray2, n10);
        }
        return new Polygon(nArray2, nArray, n10);
    }

    private void paintCroppedTabEdge(Graphics graphics, int n2, int n3, boolean bl2, int n4, int n5) {
        switch (n2) {
            case 2: 
            case 4: {
                graphics.setColor(this.shadow);
                for (int i2 = n4; i2 <= n4 + this.rects[n3].width; i2 += 12) {
                    for (int i3 = 0; i3 < this.xCropLen.length; i3 += 2) {
                        graphics.drawLine(i2 + this.yCropLen[i3], n5 - this.xCropLen[i3], i2 + this.yCropLen[i3 + 1] - 1, n5 - this.xCropLen[i3 + 1]);
                    }
                }
                break;
            }
            default: {
                graphics.setColor(this.shadow);
                for (int i4 = n5; i4 <= n5 + this.rects[n3].height; i4 += 12) {
                    for (int i5 = 0; i5 < this.xCropLen.length; i5 += 2) {
                        graphics.drawLine(n4 - this.xCropLen[i5], i4 + this.yCropLen[i5], n4 - this.xCropLen[i5 + 1], i4 + this.yCropLen[i5 + 1] - 1);
                    }
                }
            }
        }
    }

    protected void layoutLabel(int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl2) {
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, 0, 0, 11, rectangle, rectangle2, rectangle3, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        int n4 = this.getTabLabelShiftX(n2, n3, bl2);
        int n5 = this.getTabLabelShiftY(n2, n3, bl2);
        rectangle2.x += n4;
        rectangle2.y += n5;
        rectangle3.x += n4;
        rectangle3.y += n5;
    }

    protected void paintIcon(Graphics graphics, int n2, int n3, Icon icon, Rectangle rectangle, boolean bl2) {
        if (icon != null) {
            icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, int n2, Font font, FontMetrics fontMetrics, int n3, String string, Rectangle rectangle, boolean bl2) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            view.paint(graphics, rectangle);
        } else {
            int n4 = this.tabPane.getDisplayedMnemonicIndexAt(n3);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(n3)) {
                Color color;
                Color color2 = this.tabPane.getForegroundAt(n3);
                if (bl2 && color2 instanceof UIResource && (color = UIManager.getColor("TabbedPane.selectedForeground")) != null) {
                    color2 = color;
                }
                graphics.setColor(color2);
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, graphics, string, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n3).brighter());
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, graphics, string, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
                graphics.setColor(this.tabPane.getBackgroundAt(n3).darker());
                SwingUtilities2.drawStringUnderlineCharAt(this.tabPane, graphics, string, n4, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
            }
        }
    }

    protected int getTabLabelShiftX(int n2, int n3, boolean bl2) {
        Rectangle rectangle = this.rects[n3];
        int n4 = 0;
        switch (n2) {
            case 2: {
                n4 = bl2 ? -1 : 1;
                break;
            }
            case 4: {
                n4 = bl2 ? 1 : -1;
                break;
            }
            default: {
                n4 = rectangle.width % 2;
            }
        }
        return n4;
    }

    protected int getTabLabelShiftY(int n2, int n3, boolean bl2) {
        Rectangle rectangle = this.rects[n3];
        int n4 = 0;
        switch (n2) {
            case 3: {
                n4 = bl2 ? 1 : -1;
                break;
            }
            case 2: 
            case 4: {
                n4 = rectangle.height % 2;
                break;
            }
            default: {
                n4 = bl2 ? -1 : 1;
            }
        }
        return n4;
    }

    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        Rectangle rectangle3 = rectangleArray[n3];
        if (this.tabPane.hasFocus() && bl2) {
            int n4;
            int n5;
            int n6;
            int n7;
            graphics.setColor(this.focus);
            switch (n2) {
                case 2: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 5;
                    n4 = rectangle3.height - 6;
                    break;
                }
                case 4: {
                    n7 = rectangle3.x + 2;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 5;
                    n4 = rectangle3.height - 6;
                    break;
                }
                case 3: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 2;
                    n5 = rectangle3.width - 6;
                    n4 = rectangle3.height - 5;
                    break;
                }
                default: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 6;
                    n4 = rectangle3.height - 5;
                }
            }
            BasicGraphicsUtils.drawDashedRect(graphics, n7, n6, n5, n4);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        graphics.setColor(this.lightHighlight);
        switch (n2) {
            case 2: {
                graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 3);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                graphics.drawLine(n4 + 2, n5, n4 + n6 - 1, n5);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + n6 - 1, n5 + n7 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                break;
            }
            case 4: {
                graphics.drawLine(n4, n5, n4 + n6 - 3, n5);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 3);
                graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                break;
            }
            case 3: {
                graphics.drawLine(n4, n5, n4, n5 + n7 - 3);
                graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + 1, n5 + n7 - 2);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 2, n5 + n7 - 3);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + 2, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 3);
                break;
            }
            default: {
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 1);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 1);
                graphics.drawLine(n4 + 2, n5, n4 + n6 - 3, n5);
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, n5 + 2, n4 + n6 - 2, n5 + n7 - 1);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 1);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        graphics.setColor(!bl2 || this.selectedColor == null ? this.tabPane.getBackgroundAt(n3) : this.selectedColor);
        switch (n2) {
            case 2: {
                graphics.fillRect(n4 + 1, n5 + 1, n6 - 1, n7 - 3);
                break;
            }
            case 4: {
                graphics.fillRect(n4, n5 + 1, n6 - 2, n7 - 3);
                break;
            }
            case 3: {
                graphics.fillRect(n4 + 1, n5, n6 - 3, n7 - 1);
                break;
            }
            default: {
                graphics.fillRect(n4 + 1, n5 + 1, n6 - 3, n7 - 1);
            }
        }
    }

    protected void paintContentBorder(Graphics graphics, int n2, int n3) {
        int n4 = this.tabPane.getWidth();
        int n5 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(n2);
        int n6 = insets.left;
        int n7 = insets.top;
        int n8 = n4 - insets.right - insets.left;
        int n9 = n5 - insets.top - insets.bottom;
        switch (n2) {
            case 2: {
                n6 += this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                if (this.tabsOverlapBorder) {
                    n6 -= insets2.right;
                }
                n8 -= n6 - insets.left;
                break;
            }
            case 4: {
                n8 -= this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                if (!this.tabsOverlapBorder) break;
                n8 += insets2.left;
                break;
            }
            case 3: {
                n9 -= this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                if (!this.tabsOverlapBorder) break;
                n9 += insets2.top;
                break;
            }
            default: {
                n7 += this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                if (this.tabsOverlapBorder) {
                    n7 -= insets2.bottom;
                }
                n9 -= n7 - insets.top;
            }
        }
        if (this.contentOpaque || this.tabPane.isOpaque()) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            if (color != null) {
                graphics.setColor(color);
            } else if (this.selectedColor == null) {
                graphics.setColor(this.tabPane.getBackground());
            } else {
                graphics.setColor(this.selectedColor);
            }
            graphics.fillRect(n6, n7, n8, n9);
        }
        this.paintContentBorderTopEdge(graphics, n2, n3, n6, n7, n8, n9);
        this.paintContentBorderLeftEdge(graphics, n2, n3, n6, n7, n8, n9);
        this.paintContentBorderBottomEdge(graphics, n2, n3, n6, n7, n8, n9);
        this.paintContentBorderRightEdge(graphics, n2, n3, n6, n7, n8, n9);
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n2 != 1 || n3 < 0 || rectangle.y + rectangle.height + 1 < n5 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4, n5, n4 + n6 - 2, n5);
        } else {
            graphics.drawLine(n4, n5, rectangle.x - 1, n5);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n5, n4 + n6 - 2, n5);
            } else {
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, n5, n4 + n6 - 2, n5);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n2 != 2 || n3 < 0 || rectangle.x + rectangle.width + 1 < n4 || rectangle.y < n5 || rectangle.y > n5 + n7) {
            graphics.drawLine(n4, n5, n4, n5 + n7 - 2);
        } else {
            graphics.drawLine(n4, n5, n4, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n5 + n7 - 2) {
                graphics.drawLine(n4, rectangle.y + rectangle.height, n4, n5 + n7 - 2);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 3 || n3 < 0 || rectangle.y - 1 > n7 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4 + 1, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            graphics.drawLine(n4 + 1, n5 + n7 - 2, rectangle.x - 1, n5 + n7 - 2);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4, n5 + n7 - 1, rectangle.x - 1, n5 + n7 - 1);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(rectangle.x + rectangle.width, n5 + n7 - 2, n4 + n6 - 2, n5 + n7 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(rectangle.x + rectangle.width, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 4 || n3 < 0 || rectangle.x - 1 > n6 || rectangle.y < n5 || rectangle.y > n5 + n7) {
            graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + n7 - 3);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, rectangle.y - 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n5 + n7 - 2) {
                graphics.setColor(this.shadow);
                graphics.drawLine(n4 + n6 - 2, rectangle.y + rectangle.height, n4 + n6 - 2, n5 + n7 - 2);
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n4 + n6 - 1, rectangle.y + rectangle.height, n4 + n6 - 1, n5 + n7 - 2);
            }
        }
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            TabbedPaneLayout tabbedPaneLayout = (TabbedPaneLayout)this.tabPane.getLayout();
            tabbedPaneLayout.calculateLayoutInfo();
        }
    }

    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n2) {
        this.ensureCurrentLayout();
        Rectangle rectangle = new Rectangle();
        return this.getTabBounds(n2, rectangle);
    }

    public int getTabRunCount(JTabbedPane jTabbedPane) {
        this.ensureCurrentLayout();
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        return this.tabForCoordinate(jTabbedPane, n2, n3, true);
    }

    private int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3, boolean bl2) {
        if (bl2) {
            this.ensureCurrentLayout();
        }
        if (this.isRunsDirty) {
            return -1;
        }
        Point point = new Point(n2, n3);
        if (this.scrollableTabLayoutEnabled()) {
            this.translatePointToTabPanel(n2, n3, point);
            Rectangle rectangle = this.tabScroller.viewport.getViewRect();
            if (!rectangle.contains(point)) {
                return -1;
            }
        }
        int n4 = this.tabPane.getTabCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!this.rects[i2].contains(point.x, point.y)) continue;
            return i2;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int n2, Rectangle rectangle) {
        rectangle.width = this.rects[n2].width;
        rectangle.height = this.rects[n2].height;
        if (this.scrollableTabLayoutEnabled()) {
            Point point = this.tabScroller.viewport.getLocation();
            Point point2 = this.tabScroller.viewport.getViewPosition();
            rectangle.x = this.rects[n2].x + point.x - point2.x;
            rectangle.y = this.rects[n2].y + point.y - point2.y;
        } else {
            rectangle.x = this.rects[n2].x;
            rectangle.y = this.rects[n2].y;
        }
        return rectangle;
    }

    private int getClosestTab(int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = n5 = Math.min(this.rects.length, this.tabPane.getTabCount());
        int n8 = this.tabPane.getTabPlacement();
        boolean bl2 = n8 == 1 || n8 == 3;
        int n9 = n4 = bl2 ? n2 : n3;
        while (n6 != n7) {
            int n10;
            int n11;
            int n12 = (n7 + n6) / 2;
            if (bl2) {
                n11 = this.rects[n12].x;
                n10 = n11 + this.rects[n12].width;
            } else {
                n11 = this.rects[n12].y;
                n10 = n11 + this.rects[n12].height;
            }
            if (n4 < n11) {
                n7 = n12;
                if (n6 != n7) continue;
                return Math.max(0, n12 - 1);
            }
            if (n4 >= n10) {
                n6 = n12;
                if (n7 - n6 > 1) continue;
                return Math.max(n12 + 1, n5 - 1);
            }
            return n12;
        }
        return n6;
    }

    private Point translatePointToTabPanel(int n2, int n3, Point point) {
        Point point2 = this.tabScroller.viewport.getLocation();
        Point point3 = this.tabScroller.viewport.getViewPosition();
        point.x = n2 - point2.x + point3.x;
        point.y = n3 - point2.y + point3.y;
        return point;
    }

    protected Component getVisibleComponent() {
        return this.visibleComponent;
    }

    protected void setVisibleComponent(Component component) {
        if (this.visibleComponent != null && this.visibleComponent != component && this.visibleComponent.getParent() == this.tabPane) {
            this.visibleComponent.setVisible(false);
        }
        if (component != null && !component.isVisible()) {
            component.setVisible(true);
        }
        this.visibleComponent = component;
    }

    protected void assureRectsCreated(int n2) {
        int n3 = this.rects.length;
        if (n2 != n3) {
            Rectangle[] rectangleArray = new Rectangle[n2];
            System.arraycopy(this.rects, 0, rectangleArray, 0, Math.min(n3, n2));
            this.rects = rectangleArray;
            for (int i2 = n3; i2 < n2; ++i2) {
                this.rects[i2] = new Rectangle();
            }
        }
    }

    protected void expandTabRunsArray() {
        int n2 = this.tabRuns.length;
        int[] nArray = new int[n2 + 10];
        System.arraycopy(this.tabRuns, 0, nArray, 0, this.runCount);
        this.tabRuns = nArray;
    }

    protected int getRunForTab(int n2, int n3) {
        for (int i2 = 0; i2 < this.runCount; ++i2) {
            int n4 = this.tabRuns[i2];
            int n5 = this.lastTabInRun(n2, i2);
            if (n3 < n4 || n3 > n5) continue;
            return i2;
        }
        return 0;
    }

    protected int lastTabInRun(int n2, int n3) {
        int n4;
        if (this.runCount == 1) {
            return n2 - 1;
        }
        int n5 = n4 = n3 == this.runCount - 1 ? 0 : n3 + 1;
        if (this.tabRuns[n4] == 0) {
            return n2 - 1;
        }
        return this.tabRuns[n4] - 1;
    }

    protected int getTabRunOverlay(int n2) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int n2, int n3) {
        return 0;
    }

    protected boolean shouldPadTabRun(int n2, int n3) {
        return this.runCount > 1;
    }

    protected boolean shouldRotateTabRuns(int n2) {
        return true;
    }

    protected Icon getIconForTab(int n2) {
        return !this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n2) ? this.tabPane.getDisabledIconAt(n2) : this.tabPane.getIconAt(n2);
    }

    protected View getTextViewForTab(int n2) {
        if (this.htmlViews != null) {
            return (View)this.htmlViews.elementAt(n2);
        }
        return null;
    }

    protected int calculateTabHeight(int n2, int n3, int n4) {
        int n5 = 0;
        View view = this.getTextViewForTab(n3);
        n5 = view != null ? (n5 += (int)view.getPreferredSpan(1)) : (n5 += n4);
        Icon icon = this.getIconForTab(n3);
        Insets insets = this.getTabInsets(n2, n3);
        if (icon != null) {
            n5 = Math.max(n5, icon.getIconHeight());
        }
        return n5 += insets.top + insets.bottom + 2;
    }

    protected int calculateMaxTabHeight(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        int n5 = fontMetrics.getHeight();
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = Math.max(this.calculateTabHeight(n2, i2, n5), n4);
        }
        return n4;
    }

    protected int calculateTabWidth(int n2, int n3, FontMetrics fontMetrics) {
        View view;
        Icon icon = this.getIconForTab(n3);
        Insets insets = this.getTabInsets(n2, n3);
        int n4 = insets.left + insets.right + 3;
        if (icon != null) {
            n4 += icon.getIconWidth() + this.textIconGap;
        }
        if ((view = this.getTextViewForTab(n3)) != null) {
            n4 += (int)view.getPreferredSpan(0);
        } else {
            String string = this.tabPane.getTitleAt(n3);
            n4 += SwingUtilities2.stringWidth(this.tabPane, fontMetrics, string);
        }
        return n4;
    }

    protected int calculateMaxTabWidth(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics();
        int n3 = this.tabPane.getTabCount();
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = Math.max(this.calculateTabWidth(n2, i2, fontMetrics), n4);
        }
        return n4;
    }

    protected int calculateTabAreaHeight(int n2, int n3, int n4) {
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.top + insets.bottom : 0;
    }

    protected int calculateTabAreaWidth(int n2, int n3, int n4) {
        Insets insets = this.getTabAreaInsets(n2);
        int n5 = this.getTabRunOverlay(n2);
        return n3 > 0 ? n3 * (n4 - n5) + n5 + insets.left + insets.right : 0;
    }

    protected Insets getTabInsets(int n2, int n3) {
        return this.tabInsets;
    }

    protected Insets getSelectedTabPadInsets(int n2) {
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, this.currentPadInsets, n2);
        return this.currentPadInsets;
    }

    protected Insets getTabAreaInsets(int n2) {
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, this.currentTabAreaInsets, n2);
        return this.currentTabAreaInsets;
    }

    protected Insets getContentBorderInsets(int n2) {
        return this.contentBorderInsets;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont();
        return this.tabPane.getFontMetrics(font);
    }

    protected void navigateSelectedTab(int n2) {
        int n3 = this.tabPane.getTabPlacement();
        int n4 = DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true) ? this.tabPane.getSelectedIndex() : this.getFocusIndex();
        int n5 = this.tabPane.getTabCount();
        boolean bl2 = BasicGraphicsUtils.isLeftToRight(this.tabPane);
        if (n5 <= 0) {
            return;
        }
        block0 : switch (n3) {
            case 2: 
            case 4: {
                switch (n2) {
                    case 12: {
                        this.selectNextTab(n4);
                        break block0;
                    }
                    case 13: {
                        this.selectPreviousTab(n4);
                        break block0;
                    }
                    case 1: {
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                    case 5: {
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        int n6 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n6);
                        break block0;
                    }
                    case 3: {
                        int n7 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n7);
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (n2) {
                    case 12: {
                        this.selectNextTab(n4);
                        break block0;
                    }
                    case 13: {
                        this.selectPreviousTab(n4);
                        break block0;
                    }
                    case 1: {
                        int n8 = this.getTabRunOffset(n3, n5, n4, false);
                        this.selectAdjacentRunTab(n3, n4, n8);
                        break block0;
                    }
                    case 5: {
                        int n9 = this.getTabRunOffset(n3, n5, n4, true);
                        this.selectAdjacentRunTab(n3, n4, n9);
                        break block0;
                    }
                    case 3: {
                        if (bl2) {
                            this.selectNextTabInRun(n4);
                            break block0;
                        }
                        this.selectPreviousTabInRun(n4);
                        break block0;
                    }
                    case 7: {
                        if (bl2) {
                            this.selectPreviousTabInRun(n4);
                            break block0;
                        }
                        this.selectNextTabInRun(n4);
                        break block0;
                    }
                }
            }
        }
    }

    protected void selectNextTabInRun(int n2) {
        int n3 = this.tabPane.getTabCount();
        int n4 = this.getNextTabIndexInRun(n3, n2);
        while (n4 != n2 && !this.tabPane.isEnabledAt(n4)) {
            n4 = this.getNextTabIndexInRun(n3, n4);
        }
        this.navigateTo(n4);
    }

    protected void selectPreviousTabInRun(int n2) {
        int n3 = this.tabPane.getTabCount();
        int n4 = this.getPreviousTabIndexInRun(n3, n2);
        while (n4 != n2 && !this.tabPane.isEnabledAt(n4)) {
            n4 = this.getPreviousTabIndexInRun(n3, n4);
        }
        this.navigateTo(n4);
    }

    protected void selectNextTab(int n2) {
        int n3 = this.getNextTabIndex(n2);
        while (n3 != n2 && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getNextTabIndex(n3);
        }
        this.navigateTo(n3);
    }

    protected void selectPreviousTab(int n2) {
        int n3 = this.getPreviousTabIndex(n2);
        while (n3 != n2 && !this.tabPane.isEnabledAt(n3)) {
            n3 = this.getPreviousTabIndex(n3);
        }
        this.navigateTo(n3);
    }

    protected void selectAdjacentRunTab(int n2, int n3, int n4) {
        int n5;
        if (this.runCount < 2) {
            return;
        }
        Rectangle rectangle = this.rects[n3];
        switch (n2) {
            case 2: 
            case 4: {
                n5 = this.tabForCoordinate(this.tabPane, rectangle.x + rectangle.width / 2 + n4, rectangle.y + rectangle.height / 2);
                break;
            }
            default: {
                n5 = this.tabForCoordinate(this.tabPane, rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2 + n4);
            }
        }
        if (n5 != -1) {
            while (!this.tabPane.isEnabledAt(n5) && n5 != n3) {
                n5 = this.getNextTabIndex(n5);
            }
            this.navigateTo(n5);
        }
    }

    private void navigateTo(int n2) {
        if (DefaultLookup.getBoolean(this.tabPane, this, "TabbedPane.selectionFollowsFocus", true)) {
            this.setFocusIndex(n2);
            this.tabPane.setSelectedIndex(n2);
        } else {
            int n3 = this.focusIndex;
            this.setFocusIndex(n2);
            this.tabPane.repaint(this.getTabBounds(this.tabPane, this.focusIndex));
            if (n3 != -1) {
                this.tabPane.repaint(this.getTabBounds(this.tabPane, n3));
            }
        }
    }

    void setFocusIndex(int n2) {
        this.focusIndex = n2;
    }

    protected int getFocusIndex() {
        return this.focusIndex;
    }

    protected int getTabRunOffset(int n2, int n3, int n4, boolean bl2) {
        int n5;
        int n6 = this.getRunForTab(n3, n4);
        switch (n2) {
            case 2: {
                if (n6 == 0) {
                    n5 = bl2 ? -(this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? this.maxTabWidth : this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                n5 = bl2 ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 4: {
                if (n6 == 0) {
                    n5 = bl2 ? this.maxTabWidth : this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? -(this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth) - this.maxTabWidth) : -this.maxTabWidth;
                    break;
                }
                n5 = bl2 ? this.maxTabWidth : -this.maxTabWidth;
                break;
            }
            case 3: {
                if (n6 == 0) {
                    n5 = bl2 ? this.maxTabHeight : this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight;
                    break;
                }
                if (n6 == this.runCount - 1) {
                    n5 = bl2 ? -(this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight;
                    break;
                }
                n5 = bl2 ? this.maxTabHeight : -this.maxTabHeight;
                break;
            }
            default: {
                n5 = n6 == 0 ? (bl2 ? -(this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : -this.maxTabHeight) : (n6 == this.runCount - 1 ? (bl2 ? this.maxTabHeight : this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight) - this.maxTabHeight) : (bl2 ? this.maxTabHeight : -this.maxTabHeight));
            }
        }
        return n5;
    }

    protected int getPreviousTabIndex(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this.tabPane.getTabCount() - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getNextTabIndex(int n2) {
        return (n2 + 1) % this.tabPane.getTabCount();
    }

    protected int getNextTabIndexInRun(int n2, int n3) {
        if (this.runCount < 2) {
            return this.getNextTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        int n5 = this.getNextTabIndex(n3);
        if (n5 == this.tabRuns[this.getNextTabRun(n4)]) {
            return this.tabRuns[n4];
        }
        return n5;
    }

    protected int getPreviousTabIndexInRun(int n2, int n3) {
        if (this.runCount < 2) {
            return this.getPreviousTabIndex(n3);
        }
        int n4 = this.getRunForTab(n2, n3);
        if (n3 == this.tabRuns[n4]) {
            int n5 = this.tabRuns[this.getNextTabRun(n4)] - 1;
            return n5 != -1 ? n5 : n2 - 1;
        }
        return this.getPreviousTabIndex(n3);
    }

    protected int getPreviousTabRun(int n2) {
        int n3 = n2 - 1 >= 0 ? n2 - 1 : this.runCount - 1;
        return n3 >= 0 ? n3 : 0;
    }

    protected int getNextTabRun(int n2) {
        return (n2 + 1) % this.runCount;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n2) {
        switch (n2) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.left;
                insets2.left = insets.bottom;
                insets2.bottom = insets.right;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    boolean requestFocusForVisibleComponent() {
        Component component = this.getVisibleComponent();
        if (component != null && component.isFocusTraversable()) {
            BasicLookAndFeel.compositeRequestFocus(component);
            return true;
        }
        return component instanceof JComponent && ((JComponent)component).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector<View> vector = new Vector<View>();
        int n2 = this.tabPane.getTabCount();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = this.tabPane.getTitleAt(i2);
                if (BasicHTML.isHTMLString(string)) {
                    vector.addElement(BasicHTML.createHTMLView(this.tabPane, string));
                    continue;
                }
                vector.addElement(null);
            }
        }
        return vector;
    }

    private static class Actions
    extends UIAction {
        static final String NEXT = "navigateNext";
        static final String PREVIOUS = "navigatePrevious";
        static final String RIGHT = "navigateRight";
        static final String LEFT = "navigateLeft";
        static final String UP = "navigateUp";
        static final String DOWN = "navigateDown";
        static final String PAGE_UP = "navigatePageUp";
        static final String PAGE_DOWN = "navigatePageDown";
        static final String REQUEST_FOCUS = "requestFocus";
        static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";
        static final String SET_SELECTED = "setSelectedIndex";
        static final String SELECT_FOCUSED = "selectTabWithFocus";
        static final String SCROLL_FORWARD = "scrollTabsForwardAction";
        static final String SCROLL_BACKWARD = "scrollTabsBackwardAction";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            BasicTabbedPaneUI basicTabbedPaneUI = (BasicTabbedPaneUI)BasicLookAndFeel.getUIOfType(jTabbedPane.getUI(), BasicTabbedPaneUI.class);
            if (basicTabbedPaneUI == null) {
                return;
            }
            if (string == NEXT) {
                basicTabbedPaneUI.navigateSelectedTab(12);
            } else if (string == PREVIOUS) {
                basicTabbedPaneUI.navigateSelectedTab(13);
            } else if (string == RIGHT) {
                basicTabbedPaneUI.navigateSelectedTab(3);
            } else if (string == LEFT) {
                basicTabbedPaneUI.navigateSelectedTab(7);
            } else if (string == UP) {
                basicTabbedPaneUI.navigateSelectedTab(1);
            } else if (string == DOWN) {
                basicTabbedPaneUI.navigateSelectedTab(5);
            } else if (string == PAGE_UP) {
                int n2 = jTabbedPane.getTabPlacement();
                if (n2 == 1 || n2 == 3) {
                    basicTabbedPaneUI.navigateSelectedTab(7);
                } else {
                    basicTabbedPaneUI.navigateSelectedTab(1);
                }
            } else if (string == PAGE_DOWN) {
                int n3 = jTabbedPane.getTabPlacement();
                if (n3 == 1 || n3 == 3) {
                    basicTabbedPaneUI.navigateSelectedTab(3);
                } else {
                    basicTabbedPaneUI.navigateSelectedTab(5);
                }
            } else if (string == REQUEST_FOCUS) {
                jTabbedPane.requestFocus();
            } else if (string == REQUEST_FOCUS_FOR_VISIBLE) {
                basicTabbedPaneUI.requestFocusForVisibleComponent();
            } else if (string == SET_SELECTED) {
                String string2 = actionEvent.getActionCommand();
                if (string2 != null && string2.length() > 0) {
                    Integer n4;
                    int n5 = actionEvent.getActionCommand().charAt(0);
                    if (n5 >= 97 && n5 <= 122) {
                        n5 -= 32;
                    }
                    if ((n4 = (Integer)basicTabbedPaneUI.mnemonicToIndexMap.get(new Integer(n5))) != null && jTabbedPane.isEnabledAt(n4)) {
                        jTabbedPane.setSelectedIndex(n4);
                    }
                }
            } else if (string == SELECT_FOCUSED) {
                int n6 = basicTabbedPaneUI.getFocusIndex();
                if (n6 != -1) {
                    jTabbedPane.setSelectedIndex(n6);
                }
            } else if (string == SCROLL_FORWARD) {
                if (basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                    basicTabbedPaneUI.tabScroller.scrollForward(jTabbedPane.getTabPlacement());
                }
            } else if (string == SCROLL_BACKWARD && basicTabbedPaneUI.scrollableTabLayoutEnabled()) {
                basicTabbedPaneUI.tabScroller.scrollBackward(jTabbedPane.getTabPlacement());
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent focusEvent) {
            BasicTabbedPaneUI.this.getHandler().focusGained(focusEvent);
        }

        public void focusLost(FocusEvent focusEvent) {
            BasicTabbedPaneUI.this.getHandler().focusLost(focusEvent);
        }
    }

    private class Handler
    implements ChangeListener,
    ContainerListener,
    FocusListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener {
        private Handler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            boolean bl2 = BasicTabbedPaneUI.this.scrollableTabLayoutEnabled();
            if (string == "mnemonicAt") {
                BasicTabbedPaneUI.this.updateMnemonics();
                jTabbedPane.repaint();
            } else if (string == "displayedMnemonicIndexAt") {
                jTabbedPane.repaint();
            } else if (string == "indexForTitle") {
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                String string2 = BasicTabbedPaneUI.this.tabPane.getTitleAt(n2);
                if (BasicHTML.isHTMLString(string2)) {
                    if (BasicTabbedPaneUI.this.htmlViews == null) {
                        BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                    } else {
                        View view = BasicHTML.createHTMLView(BasicTabbedPaneUI.this.tabPane, string2);
                        BasicTabbedPaneUI.this.htmlViews.setElementAt(view, n2);
                    }
                } else if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.elementAt(n2) != null) {
                    BasicTabbedPaneUI.this.htmlViews.setElementAt(null, n2);
                }
                BasicTabbedPaneUI.this.updateMnemonics();
            } else if (string == "tabLayoutPolicy") {
                BasicTabbedPaneUI.this.uninstallUI(jTabbedPane);
                BasicTabbedPaneUI.this.installUI(jTabbedPane);
            } else if (string == "tabPlacement") {
                if (BasicTabbedPaneUI.this.scrollableTabLayoutEnabled()) {
                    BasicTabbedPaneUI.this.tabScroller.createButtons();
                }
            } else if (string == "opaque" && bl2) {
                boolean bl3 = (Boolean)propertyChangeEvent.getNewValue();
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.setOpaque(bl3);
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.viewport.setOpaque(bl3);
            } else if (string == "background" && bl2) {
                Color color = (Color)propertyChangeEvent.getNewValue();
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.setBackground(color);
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.viewport.setBackground(color);
                Color color2 = BasicTabbedPaneUI.this.selectedColor == null ? color : BasicTabbedPaneUI.this.selectedColor;
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton.setBackground(color2);
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollBackwardButton.setBackground(color2);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n2;
            JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
            jTabbedPane.revalidate();
            jTabbedPane.repaint();
            if (BasicTabbedPaneUI.this.scrollableTabLayoutEnabled() && (n2 = jTabbedPane.getSelectedIndex()) < BasicTabbedPaneUI.this.rects.length && n2 != -1) {
                ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.scrollRectToVisible((Rectangle)BasicTabbedPaneUI.this.rects[n2].clone());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            BasicTabbedPaneUI.this.setRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            BasicTabbedPaneUI.this.setRolloverTab(-1);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicTabbedPaneUI.this.tabPane.isEnabled()) {
                return;
            }
            int n2 = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (n2 >= 0 && BasicTabbedPaneUI.this.tabPane.isEnabledAt(n2)) {
                if (n2 != BasicTabbedPaneUI.this.tabPane.getSelectedIndex()) {
                    BasicTabbedPaneUI.this.tabPane.setSelectedIndex(n2);
                }
                if (BasicTabbedPaneUI.this.tabPane.isRequestFocusEnabled() && n2 != BasicTabbedPaneUI.this.focusIndex) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                    int n3 = BasicTabbedPaneUI.this.focusIndex;
                    BasicTabbedPaneUI.this.setFocusIndex(n2);
                    BasicTabbedPaneUI.this.tabPane.repaint(BasicTabbedPaneUI.this.getTabBounds(BasicTabbedPaneUI.this.tabPane, BasicTabbedPaneUI.this.focusIndex));
                    if (n3 != -1) {
                        BasicTabbedPaneUI.this.tabPane.repaint(BasicTabbedPaneUI.this.getTabBounds(BasicTabbedPaneUI.this.tabPane, n3));
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            BasicTabbedPaneUI.this.setRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }

        public void focusGained(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n2 = jTabbedPane.getTabCount();
            int n3 = BasicTabbedPaneUI.this.getFocusIndex();
            if (n3 == -1) {
                n3 = jTabbedPane.getSelectedIndex();
                BasicTabbedPaneUI.this.setFocusIndex(n3);
            }
            if (n3 != -1 && n2 > 0 && n2 == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.getTabBounds(jTabbedPane, n3));
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n2 = jTabbedPane.getTabCount();
            int n3 = BasicTabbedPaneUI.this.getFocusIndex();
            if (n3 != -1 && n2 > 0 && n2 == BasicTabbedPaneUI.this.rects.length) {
                jTabbedPane.repaint(BasicTabbedPaneUI.this.getTabBounds(jTabbedPane, n3));
                BasicTabbedPaneUI.this.setFocusIndex(-1);
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            int n2 = jTabbedPane.indexOfComponent(component);
            String string = jTabbedPane.getTitleAt(n2);
            boolean bl2 = BasicHTML.isHTMLString(string);
            if (bl2) {
                if (BasicTabbedPaneUI.this.htmlViews == null) {
                    BasicTabbedPaneUI.this.htmlViews = BasicTabbedPaneUI.this.createHTMLVector();
                } else {
                    View view = BasicHTML.createHTMLView(jTabbedPane, string);
                    BasicTabbedPaneUI.this.htmlViews.insertElementAt(view, n2);
                }
            } else if (BasicTabbedPaneUI.this.htmlViews != null) {
                BasicTabbedPaneUI.this.htmlViews.insertElementAt(null, n2);
            }
            BasicTabbedPaneUI.this.isRunsDirty = true;
            BasicTabbedPaneUI.this.updateMnemonics();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof UIResource) {
                return;
            }
            Integer n2 = (Integer)jTabbedPane.getClientProperty("__index_to_remove__");
            if (n2 != null) {
                int n3 = n2;
                if (BasicTabbedPaneUI.this.htmlViews != null && BasicTabbedPaneUI.this.htmlViews.size() >= n3) {
                    BasicTabbedPaneUI.this.htmlViews.removeElementAt(n3);
                }
            }
            BasicTabbedPaneUI.this.isRunsDirty = true;
            BasicTabbedPaneUI.this.updateMnemonics();
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            BasicTabbedPaneUI.this.getHandler().mousePressed(mouseEvent);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicTabbedPaneUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    private class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int n2) {
            super(n2, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
        }
    }

    private class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
            this.setOpaque(BasicTabbedPaneUI.this.tabPane.isOpaque());
            Color color = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (color == null) {
                color = BasicTabbedPaneUI.this.tabPane.getBackground();
            }
            this.setBackground(color);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            BasicTabbedPaneUI.this.paintTabArea(graphics, BasicTabbedPaneUI.this.tabPane.getTabPlacement(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    private class ScrollableTabSupport
    implements ActionListener,
    ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public JButton scrollForwardButton;
        public JButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int n2) {
            this.viewport = new ScrollableTabViewport();
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.createButtons();
        }

        void createButtons() {
            int n2;
            if (this.scrollForwardButton != null) {
                BasicTabbedPaneUI.this.tabPane.remove(this.scrollForwardButton);
                this.scrollForwardButton.removeActionListener(this);
                BasicTabbedPaneUI.this.tabPane.remove(this.scrollBackwardButton);
                this.scrollBackwardButton.removeActionListener(this);
            }
            if ((n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement()) == 1 || n2 == 3) {
                this.scrollForwardButton = BasicTabbedPaneUI.this.createScrollButton(3);
                this.scrollBackwardButton = BasicTabbedPaneUI.this.createScrollButton(7);
            } else {
                this.scrollForwardButton = BasicTabbedPaneUI.this.createScrollButton(5);
                this.scrollBackwardButton = BasicTabbedPaneUI.this.createScrollButton(1);
            }
            this.scrollForwardButton.addActionListener(this);
            this.scrollBackwardButton.addActionListener(this);
            BasicTabbedPaneUI.this.tabPane.add(this.scrollForwardButton);
            BasicTabbedPaneUI.this.tabPane.add(this.scrollBackwardButton);
        }

        public void scrollForward(int n2) {
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            if (n2 == 1 || n2 == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex + 1);
        }

        public void scrollBackward(int n2) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(n2, this.leadingTabIndex - 1);
        }

        public void setLeadingTabIndex(int n2, int n3) {
            this.leadingTabIndex = n3;
            Dimension dimension = this.viewport.getViewSize();
            Rectangle rectangle = this.viewport.getViewRect();
            switch (n2) {
                case 1: 
                case 3: {
                    int n4 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x;
                    if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                    Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                    this.viewport.setExtentSize(dimension2);
                    break;
                }
                case 2: 
                case 4: {
                    int n5 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y;
                    if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                    Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                    this.viewport.setExtentSize(dimension3);
                }
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = (JViewport)changeEvent.getSource();
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle rectangle = jViewport.getBounds();
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            this.leadingTabIndex = BasicTabbedPaneUI.this.getClosestTab(rectangle2.x, rectangle2.y);
            if (this.leadingTabIndex + 1 < n3) {
                switch (n2) {
                    case 1: 
                    case 3: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].x >= rectangle2.x) break;
                        ++this.leadingTabIndex;
                        break;
                    }
                    case 2: 
                    case 4: {
                        if (BasicTabbedPaneUI.this.rects[this.leadingTabIndex].y >= rectangle2.y) break;
                        ++this.leadingTabIndex;
                    }
                }
            }
            Insets insets = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
            switch (n2) {
                case 2: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                    this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.tabPane.repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                    this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                    this.scrollForwardButton.setEnabled(this.leadingTabIndex < n3 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            Action action;
            ActionMap actionMap = BasicTabbedPaneUI.this.tabPane.getActionMap();
            if (actionMap != null && (action = actionMap.get(string = actionEvent.getSource() == this.scrollForwardButton ? "scrollTabsForwardAction" : "scrollTabsBackwardAction")) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(BasicTabbedPaneUI.this.tabPane, 1001, null, actionEvent.getWhen(), actionEvent.getModifiers()));
            }
        }

        public String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport() {
            this.setName("TabbedPane.scrollableViewport");
            this.setScrollMode(0);
            this.setOpaque(BasicTabbedPaneUI.this.tabPane.isOpaque());
            Color color = UIManager.getColor("TabbedPane.tabAreaBackground");
            if (color == null) {
                color = BasicTabbedPaneUI.this.tabPane.getBackground();
            }
            this.setBackground(color);
        }
    }

    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicTabbedPaneUI.this.getHandler().stateChanged(changeEvent);
        }
    }

    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculateSize(false);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculateSize(true);
        }

        protected Dimension calculateSize(boolean bl2) {
            int n2;
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n3);
            Insets insets3 = BasicTabbedPaneUI.this.getTabAreaInsets(n3);
            Dimension dimension = new Dimension(0, 0);
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            for (n2 = 0; n2 < BasicTabbedPaneUI.this.tabPane.getTabCount(); ++n2) {
                Component component = BasicTabbedPaneUI.this.tabPane.getComponentAt(n2);
                if (component == null) continue;
                Dimension dimension2 = dimension;
                Dimension dimension3 = dimension2 = bl2 ? component.getMinimumSize() : component.getPreferredSize();
                if (dimension2 == null) continue;
                n7 = Math.max(dimension2.height, n7);
                n6 = Math.max(dimension2.width, n6);
            }
            n5 += n6;
            n4 += n7;
            n2 = 0;
            switch (n3) {
                case 2: 
                case 4: {
                    n4 = Math.max(n4, BasicTabbedPaneUI.this.calculateMaxTabHeight(n3));
                    n2 = this.preferredTabAreaWidth(n3, n4 - insets3.top - insets3.bottom);
                    n5 += n2;
                    break;
                }
                default: {
                    n5 = Math.max(n5, BasicTabbedPaneUI.this.calculateMaxTabWidth(n3));
                    n2 = this.preferredTabAreaHeight(n3, n5 - insets3.left - insets3.right);
                    n4 += n2;
                }
            }
            return new Dimension(n5 + insets.left + insets.right + insets2.left + insets2.right, n4 + insets.bottom + insets.top + insets2.top + insets2.bottom);
        }

        protected int preferredTabAreaHeight(int n2, int n3) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n4 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                int n8 = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n9 = BasicTabbedPaneUI.this.calculateTabWidth(n2, i2, fontMetrics);
                    if (n7 != 0 && n7 + n9 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n9;
                }
                n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, n6, n8);
            }
            return n5;
        }

        protected int preferredTabAreaWidth(int n2, int n3) {
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            int n4 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            int n5 = 0;
            if (n4 > 0) {
                int n6 = 1;
                int n7 = 0;
                int n8 = fontMetrics.getHeight();
                BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n9 = BasicTabbedPaneUI.this.calculateTabHeight(n2, i2, n8);
                    if (n7 != 0 && n7 + n9 > n3) {
                        ++n6;
                        n7 = 0;
                    }
                    n7 += n9;
                }
                n5 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, n6, BasicTabbedPaneUI.this.maxTabWidth);
            }
            return n5;
        }

        public void layoutContainer(Container container) {
            BasicTabbedPaneUI.this.setRolloverTab(-1);
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n3 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n3 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                int n4 = 0;
                int n5 = 0;
                Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
                Component component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n3);
                boolean bl2 = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl2 = true;
                    }
                    BasicTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n6 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
                if (n6 > 0) {
                    int n7;
                    int n8;
                    switch (n2) {
                        case 2: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n8 = insets.left + n4 + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        case 4: {
                            n4 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        case 3: {
                            n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + insets2.top;
                            break;
                        }
                        default: {
                            n5 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n8 = insets.left + insets2.left;
                            n7 = insets.top + n5 + insets2.top;
                        }
                    }
                    int n9 = rectangle.width - n4 - insets.left - insets.right - insets2.left - insets2.right;
                    int n10 = rectangle.height - n5 - insets.top - insets.bottom - insets2.top - insets2.bottom;
                    for (int i2 = 0; i2 < n6; ++i2) {
                        Component component3 = BasicTabbedPaneUI.this.tabPane.getComponent(i2);
                        component3.setBounds(n8, n7, n9, n10);
                    }
                }
                if (bl2 && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                    BasicTabbedPaneUI.this.tabPane.requestFocus();
                }
            }
        }

        public void calculateLayoutInfo() {
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            BasicTabbedPaneUI.this.assureRectsCreated(n2);
            this.calculateTabRects(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), n2);
            BasicTabbedPaneUI.this.isRunsDirty = false;
        }

        protected void calculateTabRects(int n2, int n3) {
            int n4;
            Rectangle rectangle;
            int n5;
            int n6;
            int n7;
            int n8;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n2);
            int n9 = fontMetrics.getHeight();
            int n10 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            switch (n2) {
                case 2: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    n8 = insets.left + insets2.left;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    n8 = dimension.width - insets.right - insets2.right - BasicTabbedPaneUI.this.maxTabWidth;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                    n8 = insets.left + insets2.left;
                    n7 = dimension.height - insets.bottom - insets2.bottom - BasicTabbedPaneUI.this.maxTabHeight;
                    n6 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                    n8 = insets.left + insets2.left;
                    n7 = insets.top + insets2.top;
                    n6 = dimension.width - (insets.right + insets2.right);
                }
            }
            int n11 = BasicTabbedPaneUI.this.getTabRunOverlay(n2);
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                rectangle = BasicTabbedPaneUI.this.rects[n5];
                if (!bl2) {
                    if (n5 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n5 - 1].x + BasicTabbedPaneUI.this.rects[n5 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        rectangle.x = n8;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n2, n5, fontMetrics);
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    if (rectangle.x != 2 + insets.left && rectangle.x + rectangle.width > n6) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n5;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.x = n8;
                    }
                    rectangle.y = n7;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (n5 > 0) {
                        rectangle.y = BasicTabbedPaneUI.this.rects[n5 - 1].y + BasicTabbedPaneUI.this.rects[n5 - 1].height;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.runCount = 1;
                        BasicTabbedPaneUI.this.maxTabHeight = 0;
                        rectangle.y = n7;
                    }
                    rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n2, n5, n9);
                    BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                    if (rectangle.y != 2 + insets.top && rectangle.y + rectangle.height > n6) {
                        if (BasicTabbedPaneUI.this.runCount > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount] = n5;
                        ++BasicTabbedPaneUI.this.runCount;
                        rectangle.y = n7;
                    }
                    rectangle.x = n8;
                    rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
                }
                if (n5 != n10) continue;
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.runCount - 1;
            }
            if (BasicTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(n2, n3, bl2 ? n7 : n8, n6);
                BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(n3, n10);
                if (BasicTabbedPaneUI.this.shouldRotateTabRuns(n2)) {
                    this.rotateTabRuns(n2, BasicTabbedPaneUI.this.selectedRun);
                }
            }
            for (n5 = BasicTabbedPaneUI.this.runCount - 1; n5 >= 0; --n5) {
                int n12;
                int n13;
                n4 = BasicTabbedPaneUI.this.tabRuns[n5];
                int n14 = BasicTabbedPaneUI.this.tabRuns[n5 == BasicTabbedPaneUI.this.runCount - 1 ? 0 : n5 + 1];
                int n15 = n13 = n14 != 0 ? n14 - 1 : n3 - 1;
                if (!bl2) {
                    for (n12 = n4; n12 <= n13; ++n12) {
                        rectangle = BasicTabbedPaneUI.this.rects[n12];
                        rectangle.y = n7;
                        rectangle.x += BasicTabbedPaneUI.this.getTabRunIndent(n2, n5);
                    }
                    if (BasicTabbedPaneUI.this.shouldPadTabRun(n2, n5)) {
                        this.padTabRun(n2, n4, n13, n6);
                    }
                    if (n2 == 3) {
                        n7 -= BasicTabbedPaneUI.this.maxTabHeight - n11;
                        continue;
                    }
                    n7 += BasicTabbedPaneUI.this.maxTabHeight - n11;
                    continue;
                }
                for (n12 = n4; n12 <= n13; ++n12) {
                    rectangle = BasicTabbedPaneUI.this.rects[n12];
                    rectangle.x = n8;
                    rectangle.y += BasicTabbedPaneUI.this.getTabRunIndent(n2, n5);
                }
                if (BasicTabbedPaneUI.this.shouldPadTabRun(n2, n5)) {
                    this.padTabRun(n2, n4, n13, n6);
                }
                if (n2 == 4) {
                    n8 -= BasicTabbedPaneUI.this.maxTabWidth - n11;
                    continue;
                }
                n8 += BasicTabbedPaneUI.this.maxTabWidth - n11;
            }
            this.padSelectedTab(n2, n10);
            if (!bl3 && !bl2) {
                n4 = dimension.width - (insets.right + insets2.right);
                for (n5 = 0; n5 < n3; ++n5) {
                    BasicTabbedPaneUI.this.rects[n5].x = n4 - BasicTabbedPaneUI.this.rects[n5].x - BasicTabbedPaneUI.this.rects[n5].width;
                }
            }
        }

        protected void rotateTabRuns(int n2, int n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = BasicTabbedPaneUI.this.tabRuns[0];
                for (int i3 = 1; i3 < BasicTabbedPaneUI.this.runCount; ++i3) {
                    BasicTabbedPaneUI.this.tabRuns[i3 - 1] = BasicTabbedPaneUI.this.tabRuns[i3];
                }
                BasicTabbedPaneUI.this.tabRuns[BasicTabbedPaneUI.this.runCount - 1] = n4;
            }
        }

        protected void normalizeTabRuns(int n2, int n3, int n4, int n5) {
            boolean bl2 = n2 == 2 || n2 == 4;
            int n6 = BasicTabbedPaneUI.this.runCount - 1;
            boolean bl3 = true;
            double d2 = 1.25;
            while (bl3) {
                int n7;
                int n8;
                int n9 = BasicTabbedPaneUI.this.lastTabInRun(n3, n6);
                int n10 = BasicTabbedPaneUI.this.lastTabInRun(n3, n6 - 1);
                if (!bl2) {
                    n8 = BasicTabbedPaneUI.this.rects[n9].x + BasicTabbedPaneUI.this.rects[n9].width;
                    n7 = (int)((double)BasicTabbedPaneUI.this.maxTabWidth * d2);
                } else {
                    n8 = BasicTabbedPaneUI.this.rects[n9].y + BasicTabbedPaneUI.this.rects[n9].height;
                    n7 = (int)((double)BasicTabbedPaneUI.this.maxTabHeight * d2 * 2.0);
                }
                if (n5 - n8 > n7) {
                    BasicTabbedPaneUI.this.tabRuns[n6] = n10;
                    if (!bl2) {
                        BasicTabbedPaneUI.this.rects[n10].x = n4;
                    } else {
                        BasicTabbedPaneUI.this.rects[n10].y = n4;
                    }
                    for (int i2 = n10 + 1; i2 <= n9; ++i2) {
                        if (!bl2) {
                            BasicTabbedPaneUI.this.rects[i2].x = BasicTabbedPaneUI.this.rects[i2 - 1].x + BasicTabbedPaneUI.this.rects[i2 - 1].width;
                            continue;
                        }
                        BasicTabbedPaneUI.this.rects[i2].y = BasicTabbedPaneUI.this.rects[i2 - 1].y + BasicTabbedPaneUI.this.rects[i2 - 1].height;
                    }
                } else if (n6 == BasicTabbedPaneUI.this.runCount - 1) {
                    bl3 = false;
                }
                if (n6 - 1 > 0) {
                    --n6;
                    continue;
                }
                n6 = BasicTabbedPaneUI.this.runCount - 1;
                d2 += 0.25;
            }
        }

        protected void padTabRun(int n2, int n3, int n4, int n5) {
            Rectangle rectangle = BasicTabbedPaneUI.this.rects[n4];
            if (n2 == 1 || n2 == 3) {
                int n6 = rectangle.x + rectangle.width - BasicTabbedPaneUI.this.rects[n3].x;
                int n7 = n5 - (rectangle.x + rectangle.width);
                float f2 = (float)n7 / (float)n6;
                for (int i2 = n3; i2 <= n4; ++i2) {
                    Rectangle rectangle2 = BasicTabbedPaneUI.this.rects[i2];
                    if (i2 > n3) {
                        rectangle2.x = BasicTabbedPaneUI.this.rects[i2 - 1].x + BasicTabbedPaneUI.this.rects[i2 - 1].width;
                    }
                    rectangle2.width += Math.round((float)rectangle2.width * f2);
                }
                rectangle.width = n5 - rectangle.x;
            } else {
                int n8 = rectangle.y + rectangle.height - BasicTabbedPaneUI.this.rects[n3].y;
                int n9 = n5 - (rectangle.y + rectangle.height);
                float f3 = (float)n9 / (float)n8;
                for (int i3 = n3; i3 <= n4; ++i3) {
                    Rectangle rectangle3 = BasicTabbedPaneUI.this.rects[i3];
                    if (i3 > n3) {
                        rectangle3.y = BasicTabbedPaneUI.this.rects[i3 - 1].y + BasicTabbedPaneUI.this.rects[i3 - 1].height;
                    }
                    rectangle3.height += Math.round((float)rectangle3.height * f3);
                }
                rectangle.height = n5 - rectangle.y;
            }
        }

        protected void padSelectedTab(int n2, int n3) {
            if (n3 >= 0) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n3];
                Insets insets = BasicTabbedPaneUI.this.getSelectedTabPadInsets(n2);
                rectangle.x -= insets.left;
                rectangle.width += insets.left + insets.right;
                rectangle.y -= insets.top;
                rectangle.height += insets.top + insets.bottom;
            }
        }
    }

    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
        }

        protected int preferredTabAreaHeight(int n2, int n3) {
            return BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
        }

        protected int preferredTabAreaWidth(int n2, int n3) {
            return BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
        }

        public void layoutContainer(Container container) {
            BasicTabbedPaneUI.this.setRolloverTab(-1);
            int n2 = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int n4 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component component = BasicTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (n4 < 0) {
                if (component != null) {
                    BasicTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component component2 = BasicTabbedPaneUI.this.tabPane.getComponentAt(n4);
                boolean bl2 = false;
                if (component2 != null) {
                    if (component2 != component && component != null && SwingUtilities.findFocusOwner(component) != null) {
                        bl2 = true;
                    }
                    BasicTabbedPaneUI.this.setVisibleComponent(component2);
                }
                Insets insets2 = BasicTabbedPaneUI.this.getContentBorderInsets(n2);
                Rectangle rectangle = BasicTabbedPaneUI.this.tabPane.getBounds();
                int n5 = BasicTabbedPaneUI.this.tabPane.getComponentCount();
                if (n5 > 0) {
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    switch (n2) {
                        case 2: {
                            n13 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + n13 + insets2.left;
                            n8 = n10 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 4: {
                            n13 = BasicTabbedPaneUI.this.calculateTabAreaWidth(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabWidth);
                            n12 = rectangle.height - insets.top - insets.bottom;
                            n11 = rectangle.width - insets.right - n13;
                            n10 = insets.top;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - n13 - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - insets2.top - insets2.bottom;
                            break;
                        }
                        case 3: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n11 = insets.left;
                            n10 = rectangle.height - insets.bottom - n12;
                            n9 = insets.left + insets2.left;
                            n8 = insets.top + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                            break;
                        }
                        default: {
                            n13 = rectangle.width - insets.left - insets.right;
                            n12 = BasicTabbedPaneUI.this.calculateTabAreaHeight(n2, BasicTabbedPaneUI.this.runCount, BasicTabbedPaneUI.this.maxTabHeight);
                            n11 = insets.left;
                            n10 = insets.top;
                            n9 = n11 + insets2.left;
                            n8 = n10 + n12 + insets2.top;
                            n7 = rectangle.width - insets.left - insets.right - insets2.left - insets2.right;
                            n6 = rectangle.height - insets.top - insets.bottom - n12 - insets2.top - insets2.bottom;
                        }
                    }
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        Cloneable cloneable;
                        Component component3;
                        Component component4 = BasicTabbedPaneUI.this.tabPane.getComponent(i2);
                        if (BasicTabbedPaneUI.this.tabScroller != null && component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.viewport) {
                            component3 = (JViewport)component4;
                            cloneable = ((JViewport)component3).getViewRect();
                            n17 = n13;
                            n16 = n12;
                            Dimension dimension = ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton.getPreferredSize();
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    n15 = BasicTabbedPaneUI.this.rects[n3 - 1].y + BasicTabbedPaneUI.this.rects[n3 - 1].height;
                                    if (n15 <= n12) break;
                                    int n18 = n16 = n12 > 2 * dimension.height ? n12 - 2 * dimension.height : 0;
                                    if (n15 - cloneable.y > n16) break;
                                    n16 = n15 - cloneable.y;
                                    break;
                                }
                                default: {
                                    n14 = BasicTabbedPaneUI.this.rects[n3 - 1].x + BasicTabbedPaneUI.this.rects[n3 - 1].width;
                                    if (n14 <= n13) break;
                                    int n19 = n17 = n13 > 2 * dimension.width ? n13 - 2 * dimension.width : 0;
                                    if (n14 - cloneable.x > n17) break;
                                    n17 = n14 - cloneable.x;
                                }
                            }
                            component4.setBounds(n11, n10, n17, n16);
                            continue;
                        }
                        if (BasicTabbedPaneUI.this.tabScroller != null && (component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton || component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollBackwardButton)) {
                            component3 = component4;
                            cloneable = component3.getPreferredSize();
                            n17 = 0;
                            n16 = 0;
                            int n20 = ((Dimension)cloneable).width;
                            n15 = ((Dimension)cloneable).height;
                            n14 = 0;
                            switch (n2) {
                                case 2: 
                                case 4: {
                                    int n21 = BasicTabbedPaneUI.this.rects[n3 - 1].y + BasicTabbedPaneUI.this.rects[n3 - 1].height;
                                    if (n21 <= n12) break;
                                    n14 = 1;
                                    n17 = n2 == 2 ? n11 + n13 - ((Dimension)cloneable).width : n11;
                                    n16 = component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton ? rectangle.height - insets.bottom - ((Dimension)cloneable).height : rectangle.height - insets.bottom - 2 * ((Dimension)cloneable).height;
                                    break;
                                }
                                default: {
                                    int n22 = BasicTabbedPaneUI.this.rects[n3 - 1].x + BasicTabbedPaneUI.this.rects[n3 - 1].width;
                                    if (n22 <= n13) break;
                                    n14 = 1;
                                    n17 = component4 == ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.scrollForwardButton ? rectangle.width - insets.left - ((Dimension)cloneable).width : rectangle.width - insets.left - 2 * ((Dimension)cloneable).width;
                                    n16 = n2 == 1 ? n10 + n12 - ((Dimension)cloneable).height : n10;
                                }
                            }
                            component4.setVisible(n14 != 0);
                            if (n14 == 0) continue;
                            component4.setBounds(n17, n16, n20, n15);
                            continue;
                        }
                        component4.setBounds(n9, n8, n7, n6);
                    }
                    if (bl2 && !BasicTabbedPaneUI.this.requestFocusForVisibleComponent()) {
                        BasicTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        protected void calculateTabRects(int n2, int n3) {
            int n4;
            FontMetrics fontMetrics = BasicTabbedPaneUI.this.getFontMetrics();
            Dimension dimension = BasicTabbedPaneUI.this.tabPane.getSize();
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = BasicTabbedPaneUI.this.getTabAreaInsets(n2);
            int n5 = fontMetrics.getHeight();
            int n6 = BasicTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean bl2 = n2 == 2 || n2 == 4;
            boolean bl3 = BasicGraphicsUtils.isLeftToRight(BasicTabbedPaneUI.this.tabPane);
            int n7 = insets2.left;
            int n8 = insets2.top;
            int n9 = 0;
            int n10 = 0;
            switch (n2) {
                case 2: 
                case 4: {
                    BasicTabbedPaneUI.this.maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(n2);
                    break;
                }
                default: {
                    BasicTabbedPaneUI.this.maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(n2);
                }
            }
            BasicTabbedPaneUI.this.runCount = 0;
            BasicTabbedPaneUI.this.selectedRun = -1;
            if (n3 == 0) {
                return;
            }
            BasicTabbedPaneUI.this.selectedRun = 0;
            BasicTabbedPaneUI.this.runCount = 1;
            for (n4 = 0; n4 < n3; ++n4) {
                Rectangle rectangle = BasicTabbedPaneUI.this.rects[n4];
                if (!bl2) {
                    if (n4 > 0) {
                        rectangle.x = BasicTabbedPaneUI.this.rects[n4 - 1].x + BasicTabbedPaneUI.this.rects[n4 - 1].width;
                    } else {
                        BasicTabbedPaneUI.this.tabRuns[0] = 0;
                        BasicTabbedPaneUI.this.maxTabWidth = 0;
                        n10 += BasicTabbedPaneUI.this.maxTabHeight;
                        rectangle.x = n7;
                    }
                    rectangle.width = BasicTabbedPaneUI.this.calculateTabWidth(n2, n4, fontMetrics);
                    n9 = rectangle.x + rectangle.width;
                    BasicTabbedPaneUI.this.maxTabWidth = Math.max(BasicTabbedPaneUI.this.maxTabWidth, rectangle.width);
                    rectangle.y = n8;
                    rectangle.height = BasicTabbedPaneUI.this.maxTabHeight;
                    continue;
                }
                if (n4 > 0) {
                    rectangle.y = BasicTabbedPaneUI.this.rects[n4 - 1].y + BasicTabbedPaneUI.this.rects[n4 - 1].height;
                } else {
                    BasicTabbedPaneUI.this.tabRuns[0] = 0;
                    BasicTabbedPaneUI.this.maxTabHeight = 0;
                    n9 = BasicTabbedPaneUI.this.maxTabWidth;
                    rectangle.y = n8;
                }
                rectangle.height = BasicTabbedPaneUI.this.calculateTabHeight(n2, n4, n5);
                n10 = rectangle.y + rectangle.height;
                BasicTabbedPaneUI.this.maxTabHeight = Math.max(BasicTabbedPaneUI.this.maxTabHeight, rectangle.height);
                rectangle.x = n7;
                rectangle.width = BasicTabbedPaneUI.this.maxTabWidth;
            }
            if (BasicTabbedPaneUI.this.tabsOverlapBorder) {
                this.padSelectedTab(n2, n6);
            }
            if (!bl3 && !bl2) {
                int n11 = dimension.width - (insets.right + insets2.right);
                for (n4 = 0; n4 < n3; ++n4) {
                    BasicTabbedPaneUI.this.rects[n4].x = n11 - BasicTabbedPaneUI.this.rects[n4].x - BasicTabbedPaneUI.this.rects[n4].width;
                }
            }
            ((BasicTabbedPaneUI)BasicTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(n9, n10));
        }
    }
}

