/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import sun.swing.plaf.synth.SynthUI;

class SynthTextFieldUI
extends BasicTextFieldUI
implements SynthUI {
    private SynthStyle style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTextFieldUI();
    }

    private void updateStyle(JTextComponent jTextComponent) {
        SynthContext synthContext = this.getContext(jTextComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            SynthTextFieldUI.updateStyle(jTextComponent, synthContext, this.getPropertyPrefix());
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    static void updateStyle(JTextComponent jTextComponent, SynthContext synthContext, String string) {
        Object object;
        Caret caret;
        Insets insets;
        Color color;
        Color color2;
        SynthStyle synthStyle = synthContext.getStyle();
        Color color3 = jTextComponent.getCaretColor();
        if (color3 == null || color3 instanceof UIResource) {
            jTextComponent.setCaretColor((Color)synthStyle.get(synthContext, string + ".caretForeground"));
        }
        if (((color2 = jTextComponent.getForeground()) == null || color2 instanceof UIResource) && (color2 = synthStyle.getColorForState(synthContext, ColorType.TEXT_FOREGROUND)) != null) {
            jTextComponent.setForeground(color2);
        }
        synthContext.setComponentState(768);
        Color color4 = jTextComponent.getSelectionColor();
        if (color4 == null || color4 instanceof UIResource) {
            jTextComponent.setSelectionColor(synthStyle.getColor(synthContext, ColorType.TEXT_BACKGROUND));
        }
        if ((color = jTextComponent.getSelectedTextColor()) == null || color instanceof UIResource) {
            jTextComponent.setSelectedTextColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
        }
        synthContext.setComponentState(8);
        Color color5 = jTextComponent.getDisabledTextColor();
        if (color5 == null || color5 instanceof UIResource) {
            jTextComponent.setDisabledTextColor(synthStyle.getColor(synthContext, ColorType.TEXT_FOREGROUND));
        }
        if ((insets = jTextComponent.getMargin()) == null || insets instanceof UIResource) {
            insets = (Insets)synthStyle.get(synthContext, string + ".margin");
            if (insets == null) {
                insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
            }
            jTextComponent.setMargin(insets);
        }
        if ((caret = jTextComponent.getCaret()) instanceof UIResource && (object = synthStyle.get(synthContext, string + ".caretBlinkRate")) != null && object instanceof Integer) {
            Integer n2 = (Integer)object;
            caret.setBlinkRate(n2);
        }
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paintBackground(synthContext, graphics, jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        super.paint(graphics, this.getComponent());
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, JComponent jComponent) {
        synthContext.getPainter().paintTextFieldBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        synthContext.getPainter().paintTextFieldBorder(synthContext, graphics, n2, n3, n4, n5);
    }

    protected void paintBackground(Graphics graphics) {
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JTextComponent)propertyChangeEvent.getSource());
        }
        super.propertyChange(propertyChangeEvent);
    }

    protected void installDefaults() {
        this.updateStyle(this.getComponent());
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.getComponent(), 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        super.uninstallDefaults();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }
}

