/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CSSParser;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.MuxingAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheet
extends StyleContext {
    static final Border noBorder = new EmptyBorder(0, 0, 0, 0);
    static final int DEFAULT_FONT_SIZE = 3;
    private CSS css;
    private SelectorMapping selectorMapping = new SelectorMapping(0);
    private Hashtable resolvedStyles = new Hashtable();
    private Vector linkedStyleSheets;
    private URL base;

    public StyleSheet() {
        if (this.css == null) {
            this.css = new CSS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Style getRule(HTML.Tag tag, Element element) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        try {
            Style style;
            AttributeSet attributeSet;
            Vector vector = searchBuffer.getVector();
            for (Element element2 = element; element2 != null; element2 = element2.getParentElement()) {
                vector.addElement(element2);
            }
            int n2 = vector.size();
            StringBuffer stringBuffer = searchBuffer.getStringBuffer();
            for (int i2 = n2 - 1; i2 >= 1; --i2) {
                element = (Element)vector.elementAt(i2);
                attributeSet = element.getAttributes();
                Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
                String string = object.toString();
                stringBuffer.append(string);
                if (attributeSet != null) {
                    if (attributeSet.isDefined(HTML.Attribute.ID)) {
                        stringBuffer.append('#');
                        stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.ID));
                    } else if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                        stringBuffer.append('.');
                        stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
                    }
                }
                stringBuffer.append(' ');
            }
            stringBuffer.append(tag.toString());
            element = (Element)vector.elementAt(0);
            attributeSet = element.getAttributes();
            if (element.isLeaf()) {
                Object object = attributeSet.getAttribute(tag);
                attributeSet = object instanceof AttributeSet ? (AttributeSet)object : null;
            }
            if (attributeSet != null) {
                if (attributeSet.isDefined(HTML.Attribute.ID)) {
                    stringBuffer.append('#');
                    stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.ID));
                } else if (attributeSet.isDefined(HTML.Attribute.CLASS)) {
                    stringBuffer.append('.');
                    stringBuffer.append(attributeSet.getAttribute(HTML.Attribute.CLASS));
                }
            }
            Style style2 = style = this.getResolvedStyle(stringBuffer.toString(), vector, tag);
            return style2;
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
    }

    public Style getRule(String string) {
        if ((string = this.cleanSelectorString(string)) != null) {
            Style style = this.getResolvedStyle(string);
            return style;
        }
        return null;
    }

    public void addRule(String string) {
        if (string != null) {
            CssParser cssParser = new CssParser();
            try {
                cssParser.parse(this.getBase(), new StringReader(string), false, false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public AttributeSet getDeclaration(String string) {
        if (string == null) {
            return SimpleAttributeSet.EMPTY;
        }
        CssParser cssParser = new CssParser();
        return cssParser.parseDeclaration(string);
    }

    public void loadRules(Reader reader, URL uRL) throws IOException {
        CssParser cssParser = new CssParser();
        cssParser.parse(uRL, reader, false, false);
    }

    public AttributeSet getViewAttributes(View view) {
        return new ViewAttributeSet(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStyle(String string) {
        Style style = this.getStyle(string);
        if (style != null) {
            String string2 = this.cleanSelectorString(string);
            String[] stringArray = this.getSimpleSelectors(string2);
            StyleSheet styleSheet = this;
            synchronized (styleSheet) {
                SelectorMapping selectorMapping = this.getRootSelectorMapping();
                for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                    selectorMapping = selectorMapping.getChildSelectorMapping(stringArray[i2], true);
                }
                Style style2 = selectorMapping.getStyle();
                if (style2 != null) {
                    selectorMapping.setStyle(null);
                    if (this.resolvedStyles.size() > 0) {
                        Enumeration enumeration = this.resolvedStyles.elements();
                        while (enumeration.hasMoreElements()) {
                            ResolvedStyle resolvedStyle = (ResolvedStyle)enumeration.nextElement();
                            resolvedStyle.removeStyle(style2);
                        }
                    }
                }
            }
        }
        super.removeStyle(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStyleSheet(StyleSheet styleSheet) {
        StyleSheet styleSheet2 = this;
        synchronized (styleSheet2) {
            if (this.linkedStyleSheets == null) {
                this.linkedStyleSheets = new Vector();
            }
            if (!this.linkedStyleSheets.contains(styleSheet)) {
                this.linkedStyleSheets.insertElementAt(styleSheet, 0);
                this.linkStyleSheetAt(styleSheet, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStyleSheet(StyleSheet styleSheet) {
        StyleSheet styleSheet2 = this;
        synchronized (styleSheet2) {
            int n2;
            if (this.linkedStyleSheets != null && (n2 = this.linkedStyleSheets.indexOf(styleSheet)) != -1) {
                this.linkedStyleSheets.removeElementAt(n2);
                this.unlinkStyleSheet(styleSheet, n2);
                if (n2 == 0 && this.linkedStyleSheets.size() == 0) {
                    this.linkedStyleSheets = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleSheet[] getStyleSheets() {
        Object[] objectArray;
        StyleSheet styleSheet = this;
        synchronized (styleSheet) {
            if (this.linkedStyleSheets != null) {
                objectArray = new StyleSheet[this.linkedStyleSheets.size()];
                this.linkedStyleSheets.copyInto(objectArray);
            } else {
                objectArray = null;
            }
        }
        return objectArray;
    }

    public void importStyleSheet(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            CssParser cssParser = new CssParser();
            cssParser.parse(uRL, bufferedReader, false, true);
            ((Reader)bufferedReader).close();
            inputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBase(URL uRL) {
        this.base = uRL;
    }

    public URL getBase() {
        return this.base;
    }

    public void addCSSAttribute(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        this.css.addInternalCSSValue(mutableAttributeSet, attribute, string);
    }

    public boolean addCSSAttributeFromHTML(MutableAttributeSet mutableAttributeSet, CSS.Attribute attribute, String string) {
        Object object = this.css.getCssValue(attribute, string);
        if (object != null) {
            mutableAttributeSet.addAttribute(attribute, object);
            return true;
        }
        return false;
    }

    public AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        AttributeSet attributeSet2 = this.css.translateHTMLToCSS(attributeSet);
        Style style = this.addStyle(null, null);
        style.addAttributes(attributeSet2);
        return style;
    }

    @Override
    public AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (this.css == null) {
            this.css = new CSS();
        }
        if (object instanceof StyleConstants) {
            CSS.Attribute attribute;
            Object object3;
            HTML.Tag tag = HTML.getTagForStyleConstantsKey((StyleConstants)object);
            if (tag != null && attributeSet.isDefined(tag)) {
                attributeSet = this.removeAttribute(attributeSet, tag);
            }
            if ((object3 = this.css.styleConstantsValueToCSSValue((StyleConstants)object, object2)) != null && (attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.addAttribute(attributeSet, attribute, object3);
            }
        }
        return super.addAttribute(attributeSet, object, object2);
    }

    @Override
    public AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (!(attributeSet2 instanceof HTMLDocument.TaggedAttributeSet)) {
            attributeSet = this.removeHTMLTags(attributeSet, attributeSet2);
        }
        return super.addAttributes(attributeSet, this.convertAttributeSet(attributeSet2));
    }

    @Override
    public AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (object instanceof StyleConstants) {
            CSS.Attribute attribute;
            HTML.Tag tag = HTML.getTagForStyleConstantsKey((StyleConstants)object);
            if (tag != null) {
                attributeSet = super.removeAttribute(attributeSet, tag);
            }
            if ((attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.removeAttribute(attributeSet, attribute);
            }
        }
        return super.removeAttribute(attributeSet, object);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration<?> enumeration) {
        return super.removeAttributes(attributeSet, enumeration);
    }

    @Override
    public AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet != attributeSet2) {
            attributeSet = this.removeHTMLTags(attributeSet, attributeSet2);
        }
        return super.removeAttributes(attributeSet, this.convertAttributeSet(attributeSet2));
    }

    @Override
    protected StyleContext.SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallConversionSet(attributeSet);
    }

    @Override
    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new LargeConversionSet(attributeSet);
    }

    private AttributeSet removeHTMLTags(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (!(attributeSet2 instanceof LargeConversionSet) && !(attributeSet2 instanceof SmallConversionSet)) {
            Enumeration<?> enumeration = attributeSet2.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                HTML.Tag tag;
                Object obj = enumeration.nextElement();
                if (!(obj instanceof StyleConstants) || (tag = HTML.getTagForStyleConstantsKey((StyleConstants)obj)) == null || !attributeSet.isDefined(tag)) continue;
                attributeSet = super.removeAttribute(attributeSet, tag);
            }
        }
        return attributeSet;
    }

    AttributeSet convertAttributeSet(AttributeSet attributeSet) {
        if (attributeSet instanceof LargeConversionSet || attributeSet instanceof SmallConversionSet) {
            return attributeSet;
        }
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof StyleConstants)) continue;
            LargeConversionSet largeConversionSet = new LargeConversionSet();
            Enumeration<?> enumeration2 = attributeSet.getAttributeNames();
            while (enumeration2.hasMoreElements()) {
                Object object;
                CSS.Attribute attribute;
                Object obj2 = enumeration2.nextElement();
                Object object2 = null;
                if (obj2 instanceof StyleConstants && (attribute = this.css.styleConstantsKeyToCSSKey((StyleConstants)obj2)) != null && (object2 = this.css.styleConstantsValueToCSSValue((StyleConstants)obj2, object = attributeSet.getAttribute(obj2))) != null) {
                    largeConversionSet.addAttribute(attribute, object2);
                }
                if (object2 != null) continue;
                largeConversionSet.addAttribute(obj2, attributeSet.getAttribute(obj2));
            }
            return largeConversionSet;
        }
        return attributeSet;
    }

    @Override
    public Font getFont(AttributeSet attributeSet) {
        return this.css.getFont(this, attributeSet, 12);
    }

    @Override
    public Color getForeground(AttributeSet attributeSet) {
        Color color = this.css.getColor(attributeSet, CSS.Attribute.COLOR);
        if (color == null) {
            return Color.black;
        }
        return color;
    }

    @Override
    public Color getBackground(AttributeSet attributeSet) {
        return this.css.getColor(attributeSet, CSS.Attribute.BACKGROUND_COLOR);
    }

    public BoxPainter getBoxPainter(AttributeSet attributeSet) {
        return new BoxPainter(attributeSet, this.css, this);
    }

    public ListPainter getListPainter(AttributeSet attributeSet) {
        return new ListPainter(attributeSet, this);
    }

    public void setBaseFontSize(int n2) {
        this.css.setBaseFontSize(n2);
    }

    public void setBaseFontSize(String string) {
        this.css.setBaseFontSize(string);
    }

    public static int getIndexOfSize(float f2) {
        return CSS.getIndexOfSize(f2);
    }

    public float getPointSize(int n2) {
        return this.css.getPointSize(n2);
    }

    public float getPointSize(String string) {
        return this.css.getPointSize(string);
    }

    public Color stringToColor(String string) {
        return CSS.stringToColor(string);
    }

    ImageIcon getBackgroundImage(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(CSS.Attribute.BACKGROUND_IMAGE);
        if (object != null) {
            return ((CSS.BackgroundImage)object).getImage(this.getBase());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRule(String[] stringArray, AttributeSet attributeSet, boolean bl2) {
        int n2 = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[i2]);
        }
        String string = stringBuffer.toString();
        Style style = this.getStyle(string);
        if (style == null) {
            Style style2 = this.addStyle(string, null);
            StyleSheet styleSheet = this;
            synchronized (styleSheet) {
                SelectorMapping selectorMapping = this.getRootSelectorMapping();
                for (int i3 = n2 - 1; i3 >= 0; --i3) {
                    selectorMapping = selectorMapping.getChildSelectorMapping(stringArray[i3], true);
                }
                style = selectorMapping.getStyle();
                if (style == null) {
                    style = style2;
                    selectorMapping.setStyle(style);
                    this.refreshResolvedRules(string, stringArray, style, selectorMapping.getSpecificity());
                }
            }
        }
        if (bl2) {
            style = this.getLinkedStyle(style);
        }
        style.addAttributes(attributeSet);
    }

    private synchronized void linkStyleSheetAt(StyleSheet styleSheet, int n2) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = (ResolvedStyle)enumeration.nextElement();
                resolvedStyle.insertExtendedStyleAt(styleSheet.getRule(resolvedStyle.getName()), n2);
            }
        }
    }

    private synchronized void unlinkStyleSheet(StyleSheet styleSheet, int n2) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = (ResolvedStyle)enumeration.nextElement();
                resolvedStyle.removeExtendedStyleAt(n2);
            }
        }
    }

    String[] getSimpleSelectors(String string) {
        string = this.cleanSelectorString(string);
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        int n2 = 0;
        int n3 = string.length();
        while (n2 != -1) {
            int n4 = string.indexOf(32, n2);
            if (n4 != -1) {
                vector.addElement(string.substring(n2, n4));
                if (++n4 == n3) {
                    n2 = -1;
                    continue;
                }
                n2 = n4;
                continue;
            }
            vector.addElement(string.substring(n2));
            n2 = -1;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        SearchBuffer.releaseSearchBuffer(searchBuffer);
        return objectArray;
    }

    String cleanSelectorString(String string) {
        boolean bl2 = true;
        int n2 = string.length();
        block4: for (int i2 = 0; i2 < n2; ++i2) {
            switch (string.charAt(i2)) {
                case ' ': {
                    if (bl2) {
                        return this._cleanSelectorString(string);
                    }
                    bl2 = true;
                    continue block4;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    return this._cleanSelectorString(string);
                }
                default: {
                    bl2 = false;
                }
            }
        }
        if (bl2) {
            return this._cleanSelectorString(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _cleanSelectorString(String string) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        StringBuffer stringBuffer = searchBuffer.getStringBuffer();
        boolean bl2 = true;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        String string2 = null;
        try {
            block7: for (int i2 = 0; i2 < n3; ++i2) {
                switch (cArray[i2]) {
                    case ' ': {
                        if (!bl2) {
                            bl2 = true;
                            if (n2 < i2) {
                                stringBuffer.append(cArray, n2, 1 + i2 - n2);
                            }
                        }
                        n2 = i2 + 1;
                        continue block7;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': {
                        if (!bl2) {
                            bl2 = true;
                            if (n2 < i2) {
                                stringBuffer.append(cArray, n2, i2 - n2);
                                stringBuffer.append(' ');
                            }
                        }
                        n2 = i2 + 1;
                        continue block7;
                    }
                    default: {
                        bl2 = false;
                    }
                }
            }
            if (bl2 && stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            } else if (n2 < n3) {
                stringBuffer.append(cArray, n2, n3 - n2);
            }
            string2 = stringBuffer.toString();
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
        return string2;
    }

    private SelectorMapping getRootSelectorMapping() {
        return this.selectorMapping;
    }

    static int getSpecificity(String string) {
        int n2 = 0;
        boolean bl2 = true;
        int n3 = string.length();
        block5: for (int i2 = 0; i2 < n3; ++i2) {
            switch (string.charAt(i2)) {
                case '.': {
                    n2 += 100;
                    continue block5;
                }
                case '#': {
                    n2 += 10000;
                    continue block5;
                }
                case ' ': {
                    bl2 = true;
                    continue block5;
                }
                default: {
                    if (!bl2) continue block5;
                    bl2 = false;
                    ++n2;
                }
            }
        }
        return n2;
    }

    private Style getLinkedStyle(Style style) {
        Style style2 = (Style)style.getResolveParent();
        if (style2 == null) {
            style2 = this.addStyle(null, null);
            style.setResolveParent(style2);
        }
        return style2;
    }

    private synchronized Style getResolvedStyle(String string, Vector vector, HTML.Tag tag) {
        Style style = (Style)this.resolvedStyles.get(string);
        if (style == null) {
            style = this.createResolvedStyle(string, vector, tag);
        }
        return style;
    }

    private synchronized Style getResolvedStyle(String string) {
        Style style = (Style)this.resolvedStyles.get(string);
        if (style == null) {
            style = this.createResolvedStyle(string);
        }
        return style;
    }

    private void addSortedStyle(SelectorMapping selectorMapping, Vector vector) {
        int n2 = vector.size();
        if (n2 > 0) {
            int n3 = selectorMapping.getSpecificity();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (n3 < ((SelectorMapping)vector.elementAt(i2)).getSpecificity()) continue;
                vector.insertElementAt(selectorMapping, i2);
                return;
            }
        }
        vector.addElement(selectorMapping);
    }

    private synchronized void getStyles(SelectorMapping selectorMapping, Vector vector, String[] stringArray, String[] stringArray2, String[] stringArray3, int n2, int n3, Hashtable hashtable) {
        if (hashtable.contains(selectorMapping)) {
            return;
        }
        hashtable.put(selectorMapping, selectorMapping);
        Style style = selectorMapping.getStyle();
        if (style != null) {
            this.addSortedStyle(selectorMapping, vector);
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            String string;
            String string2 = stringArray[i2];
            if (string2 == null) continue;
            SelectorMapping selectorMapping2 = selectorMapping.getChildSelectorMapping(string2, false);
            if (selectorMapping2 != null) {
                this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i2 + 1, n3, hashtable);
            }
            if (stringArray3[i2] != null) {
                string = stringArray3[i2];
                selectorMapping2 = selectorMapping.getChildSelectorMapping(string2 + "." + string, false);
                if (selectorMapping2 != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i2 + 1, n3, hashtable);
                }
                if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("." + string, false)) != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i2 + 1, n3, hashtable);
                }
            }
            if (stringArray2[i2] == null) continue;
            string = stringArray2[i2];
            selectorMapping2 = selectorMapping.getChildSelectorMapping(string2 + "#" + string, false);
            if (selectorMapping2 != null) {
                this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i2 + 1, n3, hashtable);
            }
            if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("#" + string, false)) == null) continue;
            this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, i2 + 1, n3, hashtable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Style createResolvedStyle(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        Hashtable hashtable = searchBuffer.getHashtable();
        try {
            Style style;
            int n2;
            String string2;
            SelectorMapping selectorMapping = this.getRootSelectorMapping();
            int n3 = stringArray.length;
            String string3 = stringArray[0];
            SelectorMapping selectorMapping2 = selectorMapping.getChildSelectorMapping(string3, false);
            if (selectorMapping2 != null) {
                this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n3, hashtable);
            }
            if (stringArray3[0] != null) {
                string2 = stringArray3[0];
                selectorMapping2 = selectorMapping.getChildSelectorMapping(string3 + "." + string2, false);
                if (selectorMapping2 != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n3, hashtable);
                }
                if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("." + string2, false)) != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n3, hashtable);
                }
            }
            if (stringArray2[0] != null) {
                string2 = stringArray2[0];
                selectorMapping2 = selectorMapping.getChildSelectorMapping(string3 + "#" + string2, false);
                if (selectorMapping2 != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n3, hashtable);
                }
                if ((selectorMapping2 = selectorMapping.getChildSelectorMapping("#" + string2, false)) != null) {
                    this.getStyles(selectorMapping2, vector, stringArray, stringArray2, stringArray3, 1, n3, hashtable);
                }
            }
            int n4 = this.linkedStyleSheets != null ? this.linkedStyleSheets.size() : 0;
            int n5 = vector.size();
            AttributeSet[] attributeSetArray = new AttributeSet[n5 + n4];
            for (n2 = 0; n2 < n5; ++n2) {
                attributeSetArray[n2] = ((SelectorMapping)vector.elementAt(n2)).getStyle();
            }
            for (n2 = 0; n2 < n4; ++n2) {
                style = ((StyleSheet)this.linkedStyleSheets.elementAt(n2)).getRule(string);
                attributeSetArray[n2 + n5] = style == null ? SimpleAttributeSet.EMPTY : style;
            }
            ResolvedStyle resolvedStyle = new ResolvedStyle(string, attributeSetArray, n5);
            this.resolvedStyles.put(string, resolvedStyle);
            style = resolvedStyle;
            return style;
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
    }

    private Style createResolvedStyle(String string, Vector vector, HTML.Tag tag) {
        int n2 = vector.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            Element element = (Element)vector.elementAt(i2);
            AttributeSet attributeSet = element.getAttributes();
            if (i2 == 0 && element.isLeaf()) {
                object = attributeSet.getAttribute(tag);
                attributeSet = object instanceof AttributeSet ? (AttributeSet)object : null;
            }
            if (attributeSet != null) {
                object = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                stringArray[i2] = object != null ? ((HTML.Tag)object).toString() : null;
                stringArray3[i2] = attributeSet.isDefined(HTML.Attribute.CLASS) ? attributeSet.getAttribute(HTML.Attribute.CLASS).toString() : null;
                if (attributeSet.isDefined(HTML.Attribute.ID)) {
                    stringArray2[i2] = attributeSet.getAttribute(HTML.Attribute.ID).toString();
                    continue;
                }
                stringArray2[i2] = null;
                continue;
            }
            stringArray3[i2] = null;
            stringArray2[i2] = null;
            stringArray[i2] = null;
        }
        stringArray[0] = tag.toString();
        return this.createResolvedStyle(string, stringArray, stringArray2, stringArray3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Style createResolvedStyle(String string) {
        SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
        Vector vector = searchBuffer.getVector();
        try {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = string.length();
            while (n5 < n6) {
                if (n2 == n5) {
                    n2 = string.indexOf(46, n5);
                }
                if (n4 == n5) {
                    n4 = string.indexOf(35, n5);
                }
                if ((n3 = string.indexOf(32, n5)) == -1) {
                    n3 = n6;
                }
                if (n2 != -1 && n4 != -1 && n2 < n3 && n4 < n3) {
                    if (n4 < n2) {
                        if (n5 == n4) {
                            vector.addElement("");
                        } else {
                            vector.addElement(string.substring(n5, n4));
                        }
                        if (n2 + 1 < n3) {
                            vector.addElement(string.substring(n2 + 1, n3));
                        } else {
                            vector.addElement(null);
                        }
                        if (n4 + 1 == n2) {
                            vector.addElement(null);
                        } else {
                            vector.addElement(string.substring(n4 + 1, n2));
                        }
                    } else if (n4 < n3) {
                        if (n5 == n2) {
                            vector.addElement("");
                        } else {
                            vector.addElement(string.substring(n5, n2));
                        }
                        if (n2 + 1 < n4) {
                            vector.addElement(string.substring(n2 + 1, n4));
                        } else {
                            vector.addElement(null);
                        }
                        if (n4 + 1 == n3) {
                            vector.addElement(null);
                        } else {
                            vector.addElement(string.substring(n4 + 1, n3));
                        }
                    }
                    n2 = n4 = n3 + 1;
                } else if (n2 != -1 && n2 < n3) {
                    if (n2 == n5) {
                        vector.addElement("");
                    } else {
                        vector.addElement(string.substring(n5, n2));
                    }
                    if (n2 + 1 == n3) {
                        vector.addElement(null);
                    } else {
                        vector.addElement(string.substring(n2 + 1, n3));
                    }
                    vector.addElement(null);
                    n2 = n3 + 1;
                } else if (n4 != -1 && n4 < n3) {
                    if (n4 == n5) {
                        vector.addElement("");
                    } else {
                        vector.addElement(string.substring(n5, n4));
                    }
                    vector.addElement(null);
                    if (n4 + 1 == n3) {
                        vector.addElement(null);
                    } else {
                        vector.addElement(string.substring(n4 + 1, n3));
                    }
                    n4 = n3 + 1;
                } else {
                    vector.addElement(string.substring(n5, n3));
                    vector.addElement(null);
                    vector.addElement(null);
                }
                n5 = n3 + 1;
            }
            int n7 = vector.size();
            int n8 = n7 / 3;
            String[] stringArray = new String[n8];
            String[] stringArray2 = new String[n8];
            String[] stringArray3 = new String[n8];
            int n9 = 0;
            int n10 = n7 - 3;
            while (n9 < n8) {
                stringArray[n9] = (String)vector.elementAt(n10);
                stringArray3[n9] = (String)vector.elementAt(n10 + 1);
                stringArray2[n9] = (String)vector.elementAt(n10 + 2);
                ++n9;
                n10 -= 3;
            }
            Style style = this.createResolvedStyle(string, stringArray, stringArray2, stringArray3);
            return style;
        }
        finally {
            SearchBuffer.releaseSearchBuffer(searchBuffer);
        }
    }

    private synchronized void refreshResolvedRules(String string, String[] stringArray, Style style, int n2) {
        if (this.resolvedStyles.size() > 0) {
            Enumeration enumeration = this.resolvedStyles.elements();
            while (enumeration.hasMoreElements()) {
                ResolvedStyle resolvedStyle = (ResolvedStyle)enumeration.nextElement();
                if (!resolvedStyle.matches(string)) continue;
                resolvedStyle.insertStyle(style, n2);
            }
        }
    }

    static class BackgroundImagePainter
    implements Serializable {
        ImageIcon backgroundImage;
        float hPosition;
        float vPosition;
        short flags;
        private int paintX;
        private int paintY;
        private int paintMaxX;
        private int paintMaxY;

        BackgroundImagePainter(AttributeSet attributeSet, CSS cSS, StyleSheet styleSheet) {
            CSS.Value value;
            this.backgroundImage = styleSheet.getBackgroundImage(attributeSet);
            CSS.BackgroundPosition backgroundPosition = (CSS.BackgroundPosition)attributeSet.getAttribute(CSS.Attribute.BACKGROUND_POSITION);
            if (backgroundPosition != null) {
                this.hPosition = backgroundPosition.getHorizontalPosition();
                this.vPosition = backgroundPosition.getVerticalPosition();
                if (backgroundPosition.isHorizontalPositionRelativeToSize()) {
                    this.flags = (short)(this.flags | 4);
                } else if (backgroundPosition.isHorizontalPositionRelativeToSize()) {
                    this.hPosition *= (float)CSS.getFontSize(attributeSet, 12);
                }
                if (backgroundPosition.isVerticalPositionRelativeToSize()) {
                    this.flags = (short)(this.flags | 8);
                } else if (backgroundPosition.isVerticalPositionRelativeToFontSize()) {
                    this.vPosition *= (float)CSS.getFontSize(attributeSet, 12);
                }
            }
            if ((value = (CSS.Value)attributeSet.getAttribute(CSS.Attribute.BACKGROUND_REPEAT)) == null || value == CSS.Value.BACKGROUND_REPEAT) {
                this.flags = (short)(this.flags | 3);
            } else if (value == CSS.Value.BACKGROUND_REPEAT_X) {
                this.flags = (short)(this.flags | 1);
            } else if (value == CSS.Value.BACKGROUND_REPEAT_Y) {
                this.flags = (short)(this.flags | 2);
            }
        }

        void paint(Graphics graphics, float f2, float f3, float f4, float f5, View view) {
            Rectangle rectangle = graphics.getClipRect();
            if (rectangle != null) {
                graphics.clipRect((int)f2, (int)f3, (int)f4, (int)f5);
            }
            if ((this.flags & 3) == 0) {
                int n2 = this.backgroundImage.getIconWidth();
                int n3 = this.backgroundImage.getIconWidth();
                this.paintX = (this.flags & 4) == 4 ? (int)(f2 + f4 * this.hPosition - (float)n2 * this.hPosition) : (int)f2 + (int)this.hPosition;
                this.paintY = (this.flags & 8) == 8 ? (int)(f3 + f5 * this.vPosition - (float)n3 * this.vPosition) : (int)f3 + (int)this.vPosition;
                if (rectangle == null || this.paintX + n2 > rectangle.x && this.paintY + n3 > rectangle.y && this.paintX < rectangle.x + rectangle.width && this.paintY < rectangle.y + rectangle.height) {
                    this.backgroundImage.paintIcon(null, graphics, this.paintX, this.paintY);
                }
            } else {
                int n4 = this.backgroundImage.getIconWidth();
                int n5 = this.backgroundImage.getIconHeight();
                if (n4 > 0 && n5 > 0) {
                    this.paintX = (int)f2;
                    this.paintY = (int)f3;
                    this.paintMaxX = (int)(f2 + f4);
                    this.paintMaxY = (int)(f3 + f5);
                    if (this.updatePaintCoordinates(rectangle, n4, n5)) {
                        while (this.paintX < this.paintMaxX) {
                            for (int i2 = this.paintY; i2 < this.paintMaxY; i2 += n5) {
                                this.backgroundImage.paintIcon(null, graphics, this.paintX, i2);
                            }
                            this.paintX += n4;
                        }
                    }
                }
            }
            if (rectangle != null) {
                graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        private boolean updatePaintCoordinates(Rectangle rectangle, int n2, int n3) {
            if ((this.flags & 3) == 1) {
                this.paintMaxY = this.paintY + 1;
            } else if ((this.flags & 3) == 2) {
                this.paintMaxX = this.paintX + 1;
            }
            if (rectangle != null) {
                if ((this.flags & 3) == 1 && (this.paintY + n3 <= rectangle.y || this.paintY > rectangle.y + rectangle.height)) {
                    return false;
                }
                if ((this.flags & 3) == 2 && (this.paintX + n2 <= rectangle.x || this.paintX > rectangle.x + rectangle.width)) {
                    return false;
                }
                if ((this.flags & 1) == 1) {
                    if (rectangle.x + rectangle.width < this.paintMaxX) {
                        this.paintMaxX = (rectangle.x + rectangle.width - this.paintX) % n2 == 0 ? rectangle.x + rectangle.width : ((rectangle.x + rectangle.width - this.paintX) / n2 + 1) * n2 + this.paintX;
                    }
                    if (rectangle.x > this.paintX) {
                        this.paintX = (rectangle.x - this.paintX) / n2 * n2 + this.paintX;
                    }
                }
                if ((this.flags & 2) == 2) {
                    if (rectangle.y + rectangle.height < this.paintMaxY) {
                        this.paintMaxY = (rectangle.y + rectangle.height - this.paintY) % n3 == 0 ? rectangle.y + rectangle.height : ((rectangle.y + rectangle.height - this.paintY) / n3 + 1) * n3 + this.paintY;
                    }
                    if (rectangle.y > this.paintY) {
                        this.paintY = (rectangle.y - this.paintY) / n3 * n3 + this.paintY;
                    }
                }
            }
            return true;
        }
    }

    public static class BoxPainter
    implements Serializable {
        float topMargin;
        float bottomMargin;
        float leftMargin;
        float rightMargin;
        short marginFlags;
        Border border;
        Insets binsets;
        CSS css;
        StyleSheet ss;
        Color bg;
        BackgroundImagePainter bgPainter;

        BoxPainter(AttributeSet attributeSet, CSS cSS, StyleSheet styleSheet) {
            this.ss = styleSheet;
            this.css = cSS;
            this.border = this.getBorder(attributeSet);
            this.binsets = this.border.getBorderInsets(null);
            this.topMargin = this.getLength(CSS.Attribute.MARGIN_TOP, attributeSet);
            this.bottomMargin = this.getLength(CSS.Attribute.MARGIN_BOTTOM, attributeSet);
            this.leftMargin = this.getLength(CSS.Attribute.MARGIN_LEFT, attributeSet);
            this.rightMargin = this.getLength(CSS.Attribute.MARGIN_RIGHT, attributeSet);
            this.bg = styleSheet.getBackground(attributeSet);
            if (styleSheet.getBackgroundImage(attributeSet) != null) {
                this.bgPainter = new BackgroundImagePainter(attributeSet, cSS, styleSheet);
            }
        }

        Border getBorder(AttributeSet attributeSet) {
            Border border = noBorder;
            Object object = attributeSet.getAttribute(CSS.Attribute.BORDER_STYLE);
            if (object != null) {
                String string = object.toString();
                int n2 = (int)this.getLength(CSS.Attribute.BORDER_TOP_WIDTH, attributeSet);
                if (n2 > 0) {
                    if (string.equals("inset")) {
                        Color color = this.getBorderColor(attributeSet);
                        border = new BevelBorder(1, color.brighter(), color.darker());
                    } else if (string.equals("outset")) {
                        Color color = this.getBorderColor(attributeSet);
                        border = new BevelBorder(0, color.brighter(), color.darker());
                    } else if (string.equals("solid")) {
                        Color color = this.getBorderColor(attributeSet);
                        border = new LineBorder(color);
                    }
                }
            }
            return border;
        }

        Color getBorderColor(AttributeSet attributeSet) {
            Color color = this.css.getColor(attributeSet, CSS.Attribute.BORDER_COLOR);
            if (color == null && (color = this.css.getColor(attributeSet, CSS.Attribute.COLOR)) == null) {
                return Color.black;
            }
            return color;
        }

        public float getInset(int n2, View view) {
            AttributeSet attributeSet = view.getAttributes();
            float f2 = 0.0f;
            switch (n2) {
                case 2: {
                    f2 += this.leftMargin;
                    f2 += (float)this.binsets.left;
                    f2 += this.getLength(CSS.Attribute.PADDING_LEFT, attributeSet);
                    break;
                }
                case 4: {
                    f2 += this.rightMargin;
                    f2 += (float)this.binsets.right;
                    f2 += this.getLength(CSS.Attribute.PADDING_RIGHT, attributeSet);
                    break;
                }
                case 1: {
                    f2 += this.topMargin;
                    f2 += (float)this.binsets.top;
                    f2 += this.getLength(CSS.Attribute.PADDING_TOP, attributeSet);
                    break;
                }
                case 3: {
                    f2 += this.bottomMargin;
                    f2 += (float)this.binsets.bottom;
                    f2 += this.getLength(CSS.Attribute.PADDING_BOTTOM, attributeSet);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid side: " + n2);
                }
            }
            return f2;
        }

        public void paint(Graphics graphics, float f2, float f3, float f4, float f5, View view) {
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            if (!(view instanceof HTMLEditorKit.HTMLFactory.BodyBlockView)) {
                f6 = this.leftMargin;
                f7 = this.topMargin;
                f8 = -(this.leftMargin + this.rightMargin);
                f9 = -(this.topMargin + this.bottomMargin);
            }
            if (this.bg != null) {
                graphics.setColor(this.bg);
                graphics.fillRect((int)(f2 + f6), (int)(f3 + f7), (int)(f4 + f8), (int)(f5 + f9));
            }
            if (this.bgPainter != null) {
                this.bgPainter.paint(graphics, f2 + f6, f3 + f7, f4 + f8, f5 + f9, view);
            }
            this.border.paintBorder(null, graphics, (int)(f2 += this.leftMargin), (int)(f3 += this.topMargin), (int)(f4 -= this.leftMargin + this.rightMargin), (int)(f5 -= this.topMargin + this.bottomMargin));
        }

        float getLength(CSS.Attribute attribute, AttributeSet attributeSet) {
            return this.css.getLength(attributeSet, attribute);
        }
    }

    class CssParser
    implements CSSParser.CSSParserCallback {
        Vector selectors = new Vector();
        Vector selectorTokens = new Vector();
        String propertyName;
        MutableAttributeSet declaration = new SimpleAttributeSet();
        boolean parsingDeclaration;
        boolean isLink;
        URL base;
        CSSParser parser = new CSSParser();

        CssParser() {
        }

        public AttributeSet parseDeclaration(String string) {
            try {
                return this.parseDeclaration(new StringReader(string));
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public AttributeSet parseDeclaration(Reader reader) throws IOException {
            this.parse(this.base, reader, true, false);
            return this.declaration.copyAttributes();
        }

        public void parse(URL uRL, Reader reader, boolean bl2, boolean bl3) throws IOException {
            this.base = uRL;
            this.isLink = bl3;
            this.parsingDeclaration = bl2;
            this.declaration.removeAttributes(this.declaration);
            this.selectorTokens.removeAllElements();
            this.selectors.removeAllElements();
            this.propertyName = null;
            this.parser.parse(reader, this, bl2);
        }

        public void handleImport(String string) {
            URL uRL = CSS.getURL(this.base, string);
            if (uRL != null) {
                StyleSheet.this.importStyleSheet(uRL);
            }
        }

        public void handleSelector(String string) {
            string = string.toLowerCase();
            int n2 = string.length();
            if (string.endsWith(",")) {
                if (n2 > 1) {
                    string = string.substring(0, n2 - 1);
                    this.selectorTokens.addElement(string);
                }
                this.addSelector();
            } else if (n2 > 0) {
                this.selectorTokens.addElement(string);
            }
        }

        public void startRule() {
            if (this.selectorTokens.size() > 0) {
                this.addSelector();
            }
            this.propertyName = null;
        }

        public void handleProperty(String string) {
            this.propertyName = string;
        }

        public void handleValue(String string) {
            if (this.propertyName != null && string != null && string.length() > 0) {
                CSS.Attribute attribute = CSS.getAttribute(this.propertyName);
                if (attribute != null) {
                    URL uRL;
                    if (attribute == CSS.Attribute.LIST_STYLE_IMAGE && string != null && !string.equals("none") && (uRL = CSS.getURL(this.base, string)) != null) {
                        string = uRL.toString();
                    }
                    StyleSheet.this.addCSSAttribute(this.declaration, attribute, string);
                }
                this.propertyName = null;
            }
        }

        public void endRule() {
            int n2 = this.selectors.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] stringArray = (String[])this.selectors.elementAt(i2);
                if (stringArray.length <= 0) continue;
                StyleSheet.this.addRule(stringArray, this.declaration, this.isLink);
            }
            this.declaration.removeAttributes(this.declaration);
            this.selectors.removeAllElements();
        }

        private void addSelector() {
            Object[] objectArray = new String[this.selectorTokens.size()];
            this.selectorTokens.copyInto(objectArray);
            this.selectors.addElement(objectArray);
            this.selectorTokens.removeAllElements();
        }
    }

    class LargeConversionSet
    extends SimpleAttributeSet {
        public LargeConversionSet(AttributeSet attributeSet) {
            super(attributeSet);
        }

        public LargeConversionSet() {
        }

        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.isDefined(attribute);
            }
            return super.isDefined(object);
        }

        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = super.getAttribute(attribute)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)object, object2);
            }
            return super.getAttribute(object);
        }
    }

    public static class ListPainter
    implements Serializable {
        static final char[][] romanChars = new char[][]{{'i', 'v'}, {'x', 'l'}, {'c', 'd'}, {'m', '?'}};
        private Rectangle paintRect;
        private boolean checkedForStart;
        private int start;
        private CSS.Value type;
        URL imageurl;
        private StyleSheet ss = null;
        Icon img = null;
        private int bulletgap = 5;
        private boolean isLeftToRight;

        ListPainter(AttributeSet attributeSet, StyleSheet styleSheet) {
            this.ss = styleSheet;
            String string = (String)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE_IMAGE);
            this.type = null;
            if (string != null && !string.equals("none")) {
                String string2 = null;
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "()");
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                    }
                    URL uRL = new URL(string2);
                    this.img = new ImageIcon(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    if (string2 != null && styleSheet != null && styleSheet.getBase() != null) {
                        try {
                            URL uRL = new URL(styleSheet.getBase(), string2);
                            this.img = new ImageIcon(uRL);
                        }
                        catch (MalformedURLException malformedURLException2) {
                            this.img = null;
                        }
                    }
                    this.img = null;
                }
            }
            if (this.img == null) {
                this.type = (CSS.Value)attributeSet.getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
            }
            this.start = 1;
            this.paintRect = new Rectangle();
        }

        private CSS.Value getChildType(View view) {
            CSS.Value value = (CSS.Value)view.getAttributes().getAttribute(CSS.Attribute.LIST_STYLE_TYPE);
            if (value == null) {
                if (this.type == null) {
                    View view2 = view.getParent();
                    HTMLDocument hTMLDocument = (HTMLDocument)view2.getDocument();
                    value = HTMLDocument.matchNameAttribute(view2.getElement().getAttributes(), HTML.Tag.OL) ? CSS.Value.DECIMAL : CSS.Value.DISC;
                } else {
                    value = this.type;
                }
            }
            return value;
        }

        private void getStart(View view) {
            Object object;
            AttributeSet attributeSet;
            this.checkedForStart = true;
            Element element = view.getElement();
            if (element != null && (attributeSet = element.getAttributes()) != null && attributeSet.isDefined(HTML.Attribute.START) && (object = attributeSet.getAttribute(HTML.Attribute.START)) != null && object instanceof String) {
                try {
                    this.start = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        private int getRenderIndex(View view, int n2) {
            if (!this.checkedForStart) {
                this.getStart(view);
            }
            int n3 = n2;
            for (int i2 = n2; i2 >= 0; --i2) {
                Object object;
                AttributeSet attributeSet = view.getElement().getElement(i2).getAttributes();
                if (attributeSet.getAttribute(StyleConstants.NameAttribute) != HTML.Tag.LI) {
                    --n3;
                    continue;
                }
                if (!attributeSet.isDefined(HTML.Attribute.VALUE) || (object = attributeSet.getAttribute(HTML.Attribute.VALUE)) == null || !(object instanceof String)) continue;
                try {
                    int n4 = Integer.parseInt((String)object);
                    return n3 - i2 + n4;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return n3 + this.start;
        }

        public void paint(Graphics graphics, float f2, float f3, float f4, float f5, View view, int n2) {
            Object object;
            Object object2;
            View view2 = view.getView(n2);
            Object object3 = view2.getElement().getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (!(object3 instanceof HTML.Tag) || object3 != HTML.Tag.LI) {
                return;
            }
            this.isLeftToRight = view2.getContainer().getComponentOrientation().isLeftToRight();
            float f6 = 0.0f;
            if (view2.getViewCount() > 0 && ((object2 = ((View)(object = view2.getView(0))).getElement().getAttributes().getAttribute(StyleConstants.NameAttribute)) == HTML.Tag.P || object2 == HTML.Tag.IMPLIED) && ((View)object).getViewCount() > 0) {
                this.paintRect.setBounds((int)f2, (int)f3, (int)f4, (int)f5);
                Shape shape = view2.getChildAllocation(0, this.paintRect);
                if (shape != null && (shape = ((View)object).getView(0).getChildAllocation(0, shape)) != null) {
                    Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                    f6 = ((View)object).getView(0).getAlignment(1);
                    f3 = rectangle.y;
                    f5 = rectangle.height;
                }
            }
            if (this.ss != null) {
                graphics.setColor(this.ss.getForeground(view2.getAttributes()));
            } else {
                graphics.setColor(Color.black);
            }
            if (this.img != null) {
                this.drawIcon(graphics, (int)f2, (int)f3, (int)f4, (int)f5, f6, view.getContainer());
                return;
            }
            object = this.getChildType(view2);
            object2 = ((StyledDocument)view2.getDocument()).getFont(view2.getAttributes());
            if (object2 != null) {
                graphics.setFont((Font)object2);
            }
            if (object == CSS.Value.SQUARE || object == CSS.Value.CIRCLE || object == CSS.Value.DISC) {
                this.drawShape(graphics, (CSS.Value)object, (int)f2, (int)f3, (int)f4, (int)f5, f6);
            } else if (object == CSS.Value.DECIMAL) {
                this.drawLetter(graphics, '1', (int)f2, (int)f3, (int)f4, (int)f5, f6, this.getRenderIndex(view, n2));
            } else if (object == CSS.Value.LOWER_ALPHA) {
                this.drawLetter(graphics, 'a', (int)f2, (int)f3, (int)f4, (int)f5, f6, this.getRenderIndex(view, n2));
            } else if (object == CSS.Value.UPPER_ALPHA) {
                this.drawLetter(graphics, 'A', (int)f2, (int)f3, (int)f4, (int)f5, f6, this.getRenderIndex(view, n2));
            } else if (object == CSS.Value.LOWER_ROMAN) {
                this.drawLetter(graphics, 'i', (int)f2, (int)f3, (int)f4, (int)f5, f6, this.getRenderIndex(view, n2));
            } else if (object == CSS.Value.UPPER_ROMAN) {
                this.drawLetter(graphics, 'I', (int)f2, (int)f3, (int)f4, (int)f5, f6, this.getRenderIndex(view, n2));
            }
        }

        void drawIcon(Graphics graphics, int n2, int n3, int n4, int n5, float f2, Component component) {
            int n6 = this.isLeftToRight ? -(this.img.getIconWidth() + this.bulletgap) : n4 + this.bulletgap;
            int n7 = n2 + n6;
            int n8 = Math.max(n3, n3 + (int)(f2 * (float)n5) - this.img.getIconHeight());
            this.img.paintIcon(component, graphics, n7, n8);
        }

        void drawShape(Graphics graphics, CSS.Value value, int n2, int n3, int n4, int n5, float f2) {
            int n6 = this.isLeftToRight ? -(this.bulletgap + 8) : n4 + this.bulletgap;
            int n7 = n2 + n6;
            int n8 = Math.max(n3, n3 + (int)(f2 * (float)n5) - 8);
            if (value == CSS.Value.SQUARE) {
                graphics.drawRect(n7, n8, 8, 8);
            } else if (value == CSS.Value.CIRCLE) {
                graphics.drawOval(n7, n8, 8, 8);
            } else {
                graphics.fillOval(n7, n8, 8, 8);
            }
        }

        void drawLetter(Graphics graphics, char c2, int n2, int n3, int n4, int n5, float f2, int n6) {
            String string = this.formatItemNum(n6, c2);
            string = this.isLeftToRight ? string + "." : "." + string;
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(null, graphics);
            int n7 = SwingUtilities2.stringWidth(null, fontMetrics, string);
            int n8 = this.isLeftToRight ? -(n7 + this.bulletgap) : n4 + this.bulletgap;
            int n9 = n2 + n8;
            int n10 = Math.max(n3 + fontMetrics.getAscent(), n3 + (int)((float)n5 * f2));
            SwingUtilities2.drawString(null, graphics, string, n9, n10);
        }

        String formatItemNum(int n2, char c2) {
            String string;
            String string2 = "1";
            boolean bl2 = false;
            switch (c2) {
                default: {
                    string = String.valueOf(n2);
                    break;
                }
                case 'A': {
                    bl2 = true;
                }
                case 'a': {
                    string = this.formatAlphaNumerals(n2);
                    break;
                }
                case 'I': {
                    bl2 = true;
                }
                case 'i': {
                    string = this.formatRomanNumerals(n2);
                }
            }
            if (bl2) {
                string = string.toUpperCase();
            }
            return string;
        }

        String formatAlphaNumerals(int n2) {
            String string = "";
            string = n2 > 26 ? this.formatAlphaNumerals(n2 / 26) + this.formatAlphaNumerals(n2 % 26) : String.valueOf((char)(97 + n2 - 1));
            return string;
        }

        String formatRomanNumerals(int n2) {
            return this.formatRomanNumerals(0, n2);
        }

        String formatRomanNumerals(int n2, int n3) {
            if (n3 < 10) {
                return this.formatRomanDigit(n2, n3);
            }
            return this.formatRomanNumerals(n2 + 1, n3 / 10) + this.formatRomanDigit(n2, n3 % 10);
        }

        String formatRomanDigit(int n2, int n3) {
            String string = "";
            if (n3 == 9) {
                string = string + romanChars[n2][0];
                string = string + romanChars[n2 + 1][0];
                return string;
            }
            if (n3 == 4) {
                string = string + romanChars[n2][0];
                string = string + romanChars[n2][1];
                return string;
            }
            if (n3 >= 5) {
                string = string + romanChars[n2][1];
                n3 -= 5;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                string = string + romanChars[n2][0];
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResolvedStyle
    extends MuxingAttributeSet
    implements Serializable,
    Style {
        String name;
        private int extendedIndex;

        ResolvedStyle(String string, AttributeSet[] attributeSetArray, int n2) {
            super(attributeSetArray);
            this.name = string;
            this.extendedIndex = n2;
        }

        synchronized void insertStyle(Style style, int n2) {
            int n3;
            AttributeSet[] attributeSetArray = this.getAttributes();
            int n4 = attributeSetArray.length;
            for (n3 = 0; n3 < this.extendedIndex && n2 <= StyleSheet.getSpecificity(((Style)attributeSetArray[n3]).getName()); ++n3) {
            }
            this.insertAttributeSetAt(style, n3);
            ++this.extendedIndex;
        }

        synchronized void removeStyle(Style style) {
            AttributeSet[] attributeSetArray = this.getAttributes();
            for (int i2 = attributeSetArray.length - 1; i2 >= 0; --i2) {
                if (attributeSetArray[i2] != style) continue;
                this.removeAttributeSetAt(i2);
                if (i2 >= this.extendedIndex) break;
                --this.extendedIndex;
                break;
            }
        }

        synchronized void insertExtendedStyleAt(Style style, int n2) {
            this.insertAttributeSetAt(style, this.extendedIndex + n2);
        }

        synchronized void addExtendedStyle(Style style) {
            this.insertAttributeSetAt(style, this.getAttributes().length);
        }

        synchronized void removeExtendedStyleAt(int n2) {
            this.removeAttributeSetAt(this.extendedIndex + n2);
        }

        protected boolean matches(String string) {
            int n2 = string.length();
            if (n2 == 0) {
                return false;
            }
            int n3 = this.name.length();
            int n4 = string.lastIndexOf(32);
            int n5 = this.name.lastIndexOf(32);
            if (n4 >= 0) {
                ++n4;
            }
            if (n5 >= 0) {
                ++n5;
            }
            if (!this.matches(string, n4, n2, n5, n3)) {
                return false;
            }
            while (n4 != -1) {
                n2 = n4 - 1;
                if ((n4 = string.lastIndexOf(32, n2 - 1)) >= 0) {
                    ++n4;
                }
                boolean bl2 = false;
                while (!bl2 && n5 != -1) {
                    n3 = n5 - 1;
                    if ((n5 = this.name.lastIndexOf(32, n3 - 1)) >= 0) {
                        ++n5;
                    }
                    bl2 = this.matches(string, n4, n2, n5, n3);
                }
                if (bl2) continue;
                return false;
            }
            return true;
        }

        boolean matches(String string, int n2, int n3, int n4, int n5) {
            n2 = Math.max(n2, 0);
            n4 = Math.max(n4, 0);
            int n6 = this.boundedIndexOf(this.name, '.', n4, n5);
            int n7 = this.boundedIndexOf(this.name, '#', n4, n5);
            int n8 = this.boundedIndexOf(string, '.', n2, n3);
            int n9 = this.boundedIndexOf(string, '#', n2, n3);
            if (n8 != -1) {
                if (n6 == -1) {
                    return false;
                }
                return !(n2 == n8 ? n5 - n6 != n3 - n8 || !string.regionMatches(n2, this.name, n6, n5 - n6) : n3 - n2 != n5 - n4 || !string.regionMatches(n2, this.name, n4, n5 - n4));
            }
            if (n9 != -1) {
                if (n7 == -1) {
                    return false;
                }
                return !(n2 == n9 ? n5 - n7 != n3 - n9 || !string.regionMatches(n2, this.name, n7, n5 - n7) : n3 - n2 != n5 - n4 || !string.regionMatches(n2, this.name, n4, n5 - n4));
            }
            if (n6 != -1) {
                return n6 - n4 == n3 - n2 && string.regionMatches(n2, this.name, n4, n6 - n4);
            }
            if (n7 != -1) {
                return n7 - n4 == n3 - n2 && string.regionMatches(n2, this.name, n4, n7 - n4);
            }
            return n5 - n4 == n3 - n2 && string.regionMatches(n2, this.name, n4, n5 - n4);
        }

        int boundedIndexOf(String string, char c2, int n2, int n3) {
            int n4 = string.indexOf(c2, n2);
            if (n4 >= n3) {
                return -1;
            }
            return n4;
        }

        @Override
        public void addAttribute(Object object, Object object2) {
        }

        @Override
        public void addAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void removeAttribute(Object object) {
        }

        @Override
        public void removeAttributes(Enumeration<?> enumeration) {
        }

        @Override
        public void removeAttributes(AttributeSet attributeSet) {
        }

        @Override
        public void setResolveParent(AttributeSet attributeSet) {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        public ChangeListener[] getChangeListeners() {
            return new ChangeListener[0];
        }
    }

    private static class SearchBuffer {
        static Stack searchBuffers = new Stack();
        Vector vector = null;
        StringBuffer stringBuffer = null;
        Hashtable hashtable = null;

        private SearchBuffer() {
        }

        static SearchBuffer obtainSearchBuffer() {
            SearchBuffer searchBuffer;
            try {
                searchBuffer = !searchBuffers.empty() ? (SearchBuffer)searchBuffers.pop() : new SearchBuffer();
            }
            catch (EmptyStackException emptyStackException) {
                searchBuffer = new SearchBuffer();
            }
            return searchBuffer;
        }

        static void releaseSearchBuffer(SearchBuffer searchBuffer) {
            searchBuffer.empty();
            searchBuffers.push(searchBuffer);
        }

        StringBuffer getStringBuffer() {
            if (this.stringBuffer == null) {
                this.stringBuffer = new StringBuffer();
            }
            return this.stringBuffer;
        }

        Vector getVector() {
            if (this.vector == null) {
                this.vector = new Vector();
            }
            return this.vector;
        }

        Hashtable getHashtable() {
            if (this.hashtable == null) {
                this.hashtable = new Hashtable();
            }
            return this.hashtable;
        }

        void empty() {
            if (this.stringBuffer != null) {
                this.stringBuffer.setLength(0);
            }
            if (this.vector != null) {
                this.vector.removeAllElements();
            }
            if (this.hashtable != null) {
                this.hashtable.clear();
            }
        }
    }

    static class SelectorMapping
    implements Serializable {
        private int specificity;
        private Style style;
        private HashMap children;

        public SelectorMapping(int n2) {
            this.specificity = n2;
        }

        public int getSpecificity() {
            return this.specificity;
        }

        public void setStyle(Style style) {
            this.style = style;
        }

        public Style getStyle() {
            return this.style;
        }

        public SelectorMapping getChildSelectorMapping(String string, boolean bl2) {
            SelectorMapping selectorMapping = null;
            if (this.children != null) {
                selectorMapping = (SelectorMapping)this.children.get(string);
            } else if (bl2) {
                this.children = new HashMap(7);
            }
            if (selectorMapping == null && bl2) {
                int n2 = this.getChildSpecificity(string);
                selectorMapping = this.createChildSelectorMapping(n2);
                this.children.put(string, selectorMapping);
            }
            return selectorMapping;
        }

        protected SelectorMapping createChildSelectorMapping(int n2) {
            return new SelectorMapping(n2);
        }

        protected int getChildSpecificity(String string) {
            char c2 = string.charAt(0);
            int n2 = this.getSpecificity();
            if (c2 == '.') {
                n2 += 100;
            } else if (c2 == '#') {
                n2 += 10000;
            } else {
                ++n2;
                if (string.indexOf(46) != -1) {
                    n2 += 100;
                }
                if (string.indexOf(35) != -1) {
                    n2 += 10000;
                }
            }
            return n2;
        }
    }

    class SmallConversionSet
    extends StyleContext.SmallAttributeSet {
        public SmallConversionSet(AttributeSet attributeSet) {
            super(attributeSet);
        }

        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                return super.isDefined(attribute);
            }
            return super.isDefined(object);
        }

        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = super.getAttribute(attribute)) != null) {
                return StyleSheet.this.css.cssValueToStyleConstantsValue((StyleConstants)object, object2);
            }
            return super.getAttribute(object);
        }
    }

    class ViewAttributeSet
    extends MuxingAttributeSet {
        View host;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ViewAttributeSet(View view) {
            this.host = view;
            Document document = view.getDocument();
            SearchBuffer searchBuffer = SearchBuffer.obtainSearchBuffer();
            Vector vector = searchBuffer.getVector();
            try {
                Object[] objectArray2;
                if (document instanceof HTMLDocument) {
                    objectArray2 = StyleSheet.this;
                    Element element = view.getElement();
                    AttributeSet attributeSet = element.getAttributes();
                    AttributeSet attributeSet2 = objectArray2.translateHTMLToCSS(attributeSet);
                    if (attributeSet2.getAttributeCount() != 0) {
                        vector.addElement(attributeSet2);
                    }
                    if (element.isLeaf()) {
                        Enumeration<?> enumeration = attributeSet.getAttributeNames();
                        while (enumeration.hasMoreElements()) {
                            AttributeSet attributeSet3;
                            Object object;
                            Object obj = enumeration.nextElement();
                            if (!(obj instanceof HTML.Tag) || (HTML.Tag)obj == HTML.Tag.A && (object = attributeSet.getAttribute((HTML.Tag)obj)) != null && object instanceof AttributeSet && (attributeSet3 = (AttributeSet)object).getAttribute(HTML.Attribute.HREF) == null || (object = objectArray2.getRule((HTML.Tag)obj, element)) == null) continue;
                            vector.addElement(object);
                        }
                    } else {
                        HTML.Tag tag = (HTML.Tag)attributeSet.getAttribute(StyleConstants.NameAttribute);
                        Style style = objectArray2.getRule(tag, element);
                        if (style != null) {
                            vector.addElement(style);
                        }
                    }
                }
                objectArray2 = new AttributeSet[vector.size()];
                vector.copyInto(objectArray2);
                this.setAttributes((AttributeSet[])objectArray2);
            }
            finally {
                SearchBuffer.releaseSearchBuffer(searchBuffer);
            }
        }

        public boolean isDefined(Object object) {
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null) {
                object = attribute;
            }
            return super.isDefined(object);
        }

        public Object getAttribute(Object object) {
            Object object2;
            CSS.Attribute attribute;
            if (object instanceof StyleConstants && (attribute = StyleSheet.this.css.styleConstantsKeyToCSSKey((StyleConstants)object)) != null && (object2 = this.doGetAttribute(attribute)) instanceof CSS.CssValue) {
                return ((CSS.CssValue)object2).toStyleConstants((StyleConstants)object, this.host);
            }
            return this.doGetAttribute(object);
        }

        Object doGetAttribute(Object object) {
            AttributeSet attributeSet;
            CSS.Attribute attribute;
            Object object2 = super.getAttribute(object);
            if (object2 != null) {
                return object2;
            }
            if (object instanceof CSS.Attribute && (attribute = (CSS.Attribute)object).isInherited() && (attributeSet = this.getResolveParent()) != null) {
                return attributeSet.getAttribute(object);
            }
            return null;
        }

        public AttributeSet getResolveParent() {
            if (this.host == null) {
                return null;
            }
            View view = this.host.getParent();
            return view != null ? view.getAttributes() : null;
        }
    }
}

