/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.namespace.QName;

public abstract class Duration {
    private static final boolean DEBUG = true;

    public abstract QName getXMLSchemaType();

    public abstract int getSign();

    public int getYears() {
        return this.getField(DatatypeConstants.YEARS).intValue();
    }

    public int getMonths() {
        return this.getField(DatatypeConstants.MONTHS).intValue();
    }

    public int getDays() {
        return this.getField(DatatypeConstants.DAYS).intValue();
    }

    public int getHours() {
        return this.getField(DatatypeConstants.HOURS).intValue();
    }

    public int getMinutes() {
        return this.getField(DatatypeConstants.MINUTES).intValue();
    }

    public int getSeconds() {
        return this.getField(DatatypeConstants.SECONDS).intValue();
    }

    public long getTimeInMillis(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        this.addTo(calendar2);
        return Duration.getCalendarTimeInMillis(calendar2) - Duration.getCalendarTimeInMillis(calendar);
    }

    public long getTimeInMillis(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.addTo(gregorianCalendar);
        return Duration.getCalendarTimeInMillis(gregorianCalendar) - date.getTime();
    }

    public abstract Number getField(DatatypeConstants.Field var1);

    public abstract boolean isSet(DatatypeConstants.Field var1);

    public abstract Duration add(Duration var1);

    public abstract void addTo(Calendar var1);

    public void addTo(Date date) {
        if (date == null) {
            throw new NullPointerException("Cannot call " + this.getClass().getName() + "#addTo(Date date) with date == null.");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.addTo(gregorianCalendar);
        date.setTime(Duration.getCalendarTimeInMillis(gregorianCalendar));
    }

    public Duration subtract(Duration duration) {
        return this.add(duration.negate());
    }

    public Duration multiply(int n2) {
        return this.multiply(new BigDecimal(String.valueOf(n2)));
    }

    public abstract Duration multiply(BigDecimal var1);

    public abstract Duration negate();

    public abstract Duration normalizeWith(Calendar var1);

    public abstract int compare(Duration var1);

    public boolean isLongerThan(Duration duration) {
        return this.compare(duration) == 1;
    }

    public boolean isShorterThan(Duration duration) {
        return this.compare(duration) == -1;
    }

    public boolean equals(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Duration)) {
            return false;
        }
        return this.compare((Duration)object) == 0;
    }

    public abstract int hashCode();

    public abstract String toString();

    private static long getCalendarTimeInMillis(Calendar calendar) {
        return calendar.getTime().getTime();
    }
}

