/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuBarPeer;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XMenuComponentPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;

public class XMenuBarPeer
extends XMenuComponentPeer
implements MenuBarPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XMenuBarPeer");
    private static final int GAP = 10;
    private XMenuPeer helpMenu;
    private XMenuPeer menu;
    private int menuSelected = -1;
    private Vector menus = new Vector();
    private static final String FRAME = "Frame";
    private static Field f_helpMenu = XToolkit.getField(MenuBar.class, "helpMenu");
    private static Field f_menus = XToolkit.getField(MenuBar.class, "menus");
    private int lastPaintHeight = 0;
    static final int W_DIFF = 12;
    static final int H_DIFF = 23;

    MenuData[] copyMenus() {
        return this.getMenus().toArray(new MenuData[0]);
    }

    public XMenuBarPeer(MenuBar menuBar) {
        super(menuBar);
    }

    void init(Frame frame) {
        XCreateWindowParams xCreateWindowParams = this.getDelayedParams();
        xCreateWindowParams.add((Object)FRAME, frame);
        xCreateWindowParams.remove("delayed");
        this.init(xCreateWindowParams);
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.add((Object)"parent window", ((XFramePeer)this.getPeer(this.getFrame())).getShell());
    }

    Menu[] copyTargetMenus() {
        return this.getTargetMenus().toArray(new Menu[0]);
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        Vector<MenuData> vector = new Vector<MenuData>();
        Menu[] menuArray = this.copyTargetMenus();
        int n2 = menuArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Menu menu = menuArray[i2];
            if (menu == null) continue;
            vector.add(new MenuData((XMenuPeer)this.getPeer(menu), i2));
        }
        this.setMenus(vector);
        this.addHelpMenu(this.targetGetHelpMenu());
        this.toFront();
    }

    int getHeight() {
        int n2 = 0;
        MenuData[] menuDataArray = this.copyMenus();
        int n3 = menuDataArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            XMenuPeer xMenuPeer = menuDataArray[i2].menu;
            n2 = Math.max(n2, this.getFontMetrics(xMenuPeer.getFont()).getHeight());
        }
        return n2 + 10;
    }

    public void addMenu(Menu menu) {
        if (this.getHelpMenu() != null) {
            this.getMenus().insertElementAt(new MenuData((XMenuPeer)this.getPeer(menu), this.getMenus().size()), this.getMenus().size() - 1);
        } else {
            this.getMenus().addElement(new MenuData((XMenuPeer)this.getPeer(menu), this.getMenus().size()));
        }
        this.repaint();
    }

    int peerToPeerIndex(XMenuPeer xMenuPeer) {
        for (int i2 = 0; i2 < this.getMenus().size(); ++i2) {
            if (xMenuPeer != this.getMenu(i2)) continue;
            return i2;
        }
        return -1;
    }

    int menuIndexToPeerIndex(int n2) {
        for (int i2 = 0; i2 < this.getMenus().size(); ++i2) {
            if (n2 != this.getMenuIndex(i2)) continue;
            return i2;
        }
        return -1;
    }

    void updateMenuIndexesAfterDeletion(int n2) {
        for (int i2 = 0; i2 < this.getMenus().size(); ++i2) {
            if (this.getMenuIndex(i2) <= n2) continue;
            --((MenuData)this.getMenus().elementAt((int)i2)).index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delMenu(int n2) {
        Vector vector = this.getMenus();
        synchronized (vector) {
            if (n2 < this.getMenus().size()) {
                int n3;
                if (this.getMenuSelected() >= 0) {
                    XMenuPeer xMenuPeer = this.getMenu();
                    if (xMenuPeer != null) {
                        xMenuPeer.popdown(null, false);
                        xMenuPeer.setPosted(false);
                        this.setMenu(null);
                    }
                    this.setMenuSelected(-1);
                }
                if (this.getMenu(n3 = this.menuIndexToPeerIndex(n2)) == this.getHelpMenu()) {
                    this.setHelpMenu(null);
                }
                this.getMenus().removeElementAt(n3);
                this.updateMenuIndexesAfterDeletion(n2);
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveHelpMenuToLast() {
        Vector vector = this.getMenus();
        synchronized (vector) {
            int n2 = this.peerToPeerIndex(this.getHelpMenu());
            if (n2 >= 0 && n2 < this.getMenus().size() - 1) {
                MenuData menuData = (MenuData)this.getMenus().elementAt(n2);
                this.getMenus().removeElementAt(n2);
                this.getMenus().addElement(menuData);
            }
        }
    }

    public void addHelpMenu(Menu menu) {
        if (menu == null) {
            this.setHelpMenu(null);
            return;
        }
        this.setHelpMenu((XMenuPeer)this.getPeer(menu));
        this.moveHelpMenuToLast();
        this.repaint();
    }

    XMenuPeer selectMenuByKeyPress(int n2, int n3) {
        if (XAwtState.getGrabWindow() != this) {
            return null;
        }
        this.setMenuSelected(n2);
        XMenuPeer xMenuPeer = this.getMenu();
        if (xMenuPeer == null && n3 != 32 && n3 != 10 && n3 != 40) {
            this.repaint();
            return null;
        }
        XMenuPeer xMenuPeer2 = xMenuPeer;
        XMenuPeer xMenuPeer3 = this.getHelpMenu();
        this.setMenu(this.getMenu(n2));
        xMenuPeer = this.getMenu();
        if (xMenuPeer != null) {
            MenuData[] menuDataArray = this.copyMenus();
            int n4 = menuDataArray.length;
            int n5 = 0;
            boolean bl2 = true;
            for (int i2 = 0; i2 < n4; ++i2) {
                XMenuPeer xMenuPeer4 = menuDataArray[i2].menu;
                String string = xMenuPeer4.getLabel();
                FontMetrics fontMetrics = this.getFontMetrics(xMenuPeer4.getFont());
                int n6 = fontMetrics.stringWidth(string) + 20;
                if (i2 == n2) {
                    if (xMenuPeer4 == xMenuPeer3) {
                        n5 = this.getWidth() - n6;
                    }
                    if (xMenuPeer4.isViewable()) {
                        Point point = this.toGlobal(n5 + 1, this.height - 4);
                        xMenuPeer.popup(point.x, point.y);
                        xMenuPeer.select(xMenuPeer.getDownSelected());
                    }
                    if (xMenuPeer2 != null && xMenuPeer2 != xMenuPeer) {
                        xMenuPeer2.setPosted(false);
                        xMenuPeer2.popdown(null, false);
                    }
                    this.repaint();
                    return xMenuPeer;
                }
                n5 += n6;
            }
        }
        return null;
    }

    XMenuPeer selectMenu(MouseEvent mouseEvent, int n2, int n3) {
        XMenuPeer xMenuPeer = this.getMenu();
        XMenuPeer xMenuPeer2 = this.getHelpMenu();
        int n4 = this.getWidth();
        if (n3 > this.height) {
            return xMenuPeer;
        }
        if (xMenuPeer != null && xMenuPeer.cascadeContains(this, new Point(n2, n3), 0)) {
            return xMenuPeer;
        }
        MenuData[] menuDataArray = this.copyMenus();
        int n5 = menuDataArray.length;
        int n6 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            XMenuPeer xMenuPeer3 = menuDataArray[i2].menu;
            if (!xMenuPeer3.isViewable()) {
                return xMenuPeer;
            }
            String string = xMenuPeer3.getLabel();
            FontMetrics fontMetrics = this.getFontMetrics(xMenuPeer3.getFont());
            int n7 = fontMetrics.stringWidth(string) + 20;
            if (xMenuPeer3 == xMenuPeer2) {
                n6 = n4 - n7;
            }
            if (xMenuPeer3.isEnabled() && n2 > n6 && n2 <= n6 + n7) {
                if (xMenuPeer != xMenuPeer3) {
                    XMenuPeer xMenuPeer4 = xMenuPeer;
                    Point point = this.toGlobal(n6 + 1, this.height - 4);
                    xMenuPeer = xMenuPeer3;
                    this.setMenu(xMenuPeer);
                    if (xMenuPeer != null) {
                        xMenuPeer.popup(point.x, point.y);
                    }
                    this.setMenuSelected(i2);
                    this.grabInput();
                    if (xMenuPeer4 != null) {
                        xMenuPeer4.setPosted(false);
                        xMenuPeer4.popdown(mouseEvent, false);
                    }
                    this.repaint();
                }
                return xMenuPeer;
            }
            n6 += n7;
        }
        return xMenuPeer;
    }

    void paint(Graphics graphics) {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        XMenuPeer xMenuPeer = this.getHelpMenu();
        int n4 = this.getMenuSelected();
        if (graphics == null) {
            return;
        }
        if (n3 != this.lastPaintHeight) {
            this.lastPaintHeight = n3;
            ((XFramePeer)this.getPeer(this.getFrame())).updateChildrenSizes();
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(1, 1, n2 - 2, n3 - 2);
        graphics.setColor(this.getLightShadow());
        graphics.drawLine(0, 0, n2 - 1, 0);
        graphics.drawLine(0, 0, 0, n3 - 1);
        graphics.setColor(this.getDarkShadow());
        graphics.drawLine(n2 - 1, 0, n2 - 1, n3 - 1);
        graphics.drawLine(0, n3 - 1, n2 - 1, n3 - 1);
        int n5 = 0;
        MenuData[] menuDataArray = this.copyMenus();
        int n6 = menuDataArray.length;
        for (int i2 = 0; i2 < n6; ++i2) {
            XMenuPeer xMenuPeer2 = menuDataArray[i2].menu;
            xMenuPeer2.setViewable(true);
            String string = xMenuPeer2.getLabel();
            graphics.setFont(xMenuPeer2.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n7 = (n3 + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
            int n8 = fontMetrics.stringWidth(string) + 20;
            if (xMenuPeer2 == xMenuPeer) {
                int n9 = n2 - n8;
                if (n9 >= n5) {
                    n5 = n9;
                } else {
                    xMenuPeer2.setViewable(false);
                }
            }
            if (n5 + n8 > n2) {
                xMenuPeer2.setViewable(false);
            }
            if (xMenuPeer2.isViewable()) {
                if (i2 == n4) {
                    graphics.setColor(this.getSelect());
                    graphics.fillRect(n5 + 1, 3, n8 - 1, n3 - 6);
                    this.draw3DRect(graphics, n5 + 1, 3, n8 - 2, n3 - 7, false);
                }
                graphics.setColor(xMenuPeer2.isEnabled() ? this.getForeground() : this.getDisabled());
                graphics.drawString(string, n5 + 10, n7);
            }
            n5 += n8;
        }
    }

    boolean contains(int n2, int n3, int n4) {
        return n2 >= n4 && n2 < this.getWidth() - n4 && n3 >= n4 && n3 < this.getHeight() - n4;
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        XMenuPeer xMenuPeer = this.getMenu();
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (!(XAwtState.getGrabWindow() != this || this.contains(mouseEvent.getX(), mouseEvent.getY(), 0) || xMenuPeer != null && xMenuPeer.cascadeContains(this, mouseEvent.getPoint(), 0))) {
                    XMenuBarPeer.ungrabInput();
                    this.setMenuSelected(-1);
                    if (xMenuPeer != null) {
                        xMenuPeer.setPosted(false);
                        xMenuPeer.popdown(mouseEvent, false);
                        this.setMenu(null);
                    }
                    this.repaint();
                    break;
                }
                xMenuPeer = this.selectMenu(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
                if (xMenuPeer == null) break;
                Point point = xMenuPeer.toLocal(this.toGlobal(mouseEvent.getX(), mouseEvent.getY()));
                MouseEvent mouseEvent2 = this.makeMouseEvent(mouseEvent, point.x, point.y);
                xMenuPeer.handleJavaMouseEvent(mouseEvent2);
                break;
            }
            case 502: {
                if (xMenuPeer != null && xMenuPeer.lastMenuContains(this, mouseEvent.getPoint(), 0)) {
                    xMenuPeer.setPosted(false);
                    xMenuPeer.popdown(mouseEvent, true);
                    this.setMenu(null);
                    this.setMenuSelected(-1);
                    this.repaint();
                    XMenuBarPeer.ungrabInput();
                    break;
                }
                this.doPosting(this, mouseEvent.getPoint(), 0);
                break;
            }
            case 506: {
                xMenuPeer = this.selectMenu(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
                if (xMenuPeer == null) break;
                Point point = xMenuPeer.toLocal(this.toGlobal(mouseEvent.getX(), mouseEvent.getY()));
                MouseEvent mouseEvent3 = this.makeMouseEvent(mouseEvent, point.x, point.y);
                xMenuPeer.handleJavaMouseEvent(mouseEvent3);
            }
        }
    }

    void handleEscapeKeyPress() {
        this.doPosting(this, new Point(0, 0), 0);
        this.setMenuSelected(-1);
        XMenuBarPeer.ungrabInput();
        this.repaint();
    }

    void handleF10KeyPress() {
        XMenuPeer xMenuPeer = this.getMenu();
        if (this.getMenuSelected() == -1) {
            this.setMenuSelected(0);
            this.grabInput();
        } else {
            if (xMenuPeer != null && xMenuPeer.isPosted()) {
                xMenuPeer.setPosted(false);
                xMenuPeer.popdown(null, false);
                this.setMenu(null);
            }
            this.setMenuSelected(-1);
            XMenuBarPeer.ungrabInput();
        }
        this.repaint();
    }

    int getLeftSelected() {
        XMenuPeer xMenuPeer;
        MenuData[] menuDataArray = this.copyMenus();
        int n2 = menuDataArray.length;
        int n3 = this.getMenuSelected();
        do {
            int n4 = n3 = n3 == 0 ? n2 - 1 : n3 - 1;
        } while (!(xMenuPeer = menuDataArray[n3].menu).isEnabled() || !xMenuPeer.isViewable());
        return n3;
    }

    int getRightSelected() {
        XMenuPeer xMenuPeer;
        MenuData[] menuDataArray = this.copyMenus();
        int n2 = menuDataArray.length;
        int n3 = this.getMenuSelected();
        do {
            n3 = (n3 + 1) % n2;
        } while (!(xMenuPeer = menuDataArray[n3].menu).isEnabled() || !xMenuPeer.isViewable());
        return n3;
    }

    public void handleKeyPress(long l2) {
        final int n2 = this.nativeGetKeyCode(this.getFrame(), 401, l2);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                XMenuBarPeer.this.handleKeyPressOnEDT(n2);
            }
        });
    }

    void handleKeyPressOnEDT(int n2) {
        XMenuPeer xMenuPeer = this.getMenu();
        XMenuPeer xMenuPeer2 = null;
        int n3 = this.getMenuSelected();
        boolean bl2 = false;
        if (xMenuPeer != null) {
            bl2 = xMenuPeer.handleKeyPress1(n2, null);
        }
        switch (n2) {
            case 38: {
                break;
            }
            case 40: {
                if (bl2) {
                    return;
                }
                if (n3 == -1 || xMenuPeer != null) break;
                xMenuPeer = this.selectMenuByKeyPress(n3, n2);
                this.doPosting(this, new Point(0, 0), 0);
                break;
            }
            case 37: {
                if (bl2) {
                    return;
                }
                xMenuPeer2 = this.getMenu();
                xMenuPeer = this.selectMenuByKeyPress(this.getLeftSelected(), n2);
                if (xMenuPeer == xMenuPeer2) break;
                this.doPosting(this, new Point(0, 0), 0);
                break;
            }
            case 39: {
                if (bl2) {
                    return;
                }
                xMenuPeer2 = this.getMenu();
                xMenuPeer = this.selectMenuByKeyPress(this.getRightSelected(), n2);
                if (xMenuPeer == xMenuPeer2) break;
                this.doPosting(this, new Point(0, 0), 0);
                break;
            }
            case 10: 
            case 32: {
                if (bl2) {
                    return;
                }
                if (n3 == -1) break;
                if (xMenuPeer == null) {
                    xMenuPeer = this.selectMenuByKeyPress(n3, n2);
                    this.doPosting(this, new Point(0, 0), 0);
                    break;
                }
                xMenuPeer.setPosted(false);
                xMenuPeer.popdown(new MouseEvent(this.getEventSource(), 502, 0L, 0, 0, 0, 0, false), true);
                this.setMenu(null);
                this.setMenuSelected(-1);
                this.repaint();
                XMenuBarPeer.ungrabInput();
                break;
            }
            case 27: {
                this.handleEscapeKeyPress();
                break;
            }
            case 121: {
                this.handleF10KeyPress();
                break;
            }
        }
    }

    XMenuPeer doPosting(XMenuWindow xMenuWindow, Point point, int n2) {
        XMenuPeer xMenuPeer = this.getMenu();
        Point point2 = new Point(point.x, point.y);
        if (this.contains(point2.x, point2.y, n2)) {
            XMenuPeer xMenuPeer2 = xMenuPeer;
            if (xMenuPeer != null) {
                if (xMenuPeer.isPosted()) {
                    xMenuPeer.setPosted(false);
                    xMenuPeer.popdown(null, false);
                    this.setMenu(null);
                    this.setMenuSelected(-1);
                    this.repaint();
                    XMenuBarPeer.ungrabInput();
                } else {
                    xMenuPeer.setPosted(true);
                }
            }
            return xMenuPeer2;
        }
        if (xMenuPeer == null) {
            return null;
        }
        point2 = xMenuPeer.toLocal(xMenuWindow.toGlobal(point2));
        return xMenuPeer.doPosting(this, point2, n2);
    }

    void print(Graphics graphics) {
        Object object;
        Frame frame = this.getFrame();
        Dimension dimension = frame.size();
        Insets insets = frame.insets();
        int n2 = dimension.width;
        int n3 = insets.top;
        if (this.getPeer(frame) instanceof XFramePeer) {
            object = (XFramePeer)this.getPeer(frame);
            if (((XWindowPeer)object).hasDecorations(XWindowAttributesData.AWT_DECOR_BORDER)) {
                n2 -= 12;
                n3 -= 6;
            }
            if (((XWindowPeer)object).hasDecorations(XWindowAttributesData.AWT_DECOR_MENU)) {
                n3 -= 17;
            }
        }
        object = new Dimension(n2, n3);
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        Color color = frame.getBackground();
        Color color2 = frame.getForeground();
        Color color3 = color.brighter();
        Color color4 = color.darker();
        if (color3.equals(Color.white)) {
            graphics.setColor(new Color(230, 230, 230));
        } else {
            graphics.setColor(color3);
        }
        graphics.drawLine(0, 0, ((Dimension)object).width, 0);
        graphics.drawLine(1, 1, ((Dimension)object).width - 1, 1);
        graphics.drawLine(0, 0, 0, ((Dimension)object).height);
        graphics.drawLine(1, 1, 1, ((Dimension)object).height - 1);
        graphics.setColor(color4);
        graphics.drawLine(((Dimension)object).width, 1, ((Dimension)object).width, ((Dimension)object).height);
        graphics.drawLine(((Dimension)object).width - 1, 2, ((Dimension)object).width - 1, ((Dimension)object).height);
        graphics.drawLine(1, ((Dimension)object).height, ((Dimension)object).width, ((Dimension)object).height);
        graphics.drawLine(2, ((Dimension)object).height - 1, ((Dimension)object).width, ((Dimension)object).height - 1);
        int n4 = 10;
        MenuData[] menuDataArray = this.copyMenus();
        int n5 = menuDataArray.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            XMenuPeer xMenuPeer = menuDataArray[i2].menu;
            String string = xMenuPeer.getLabel();
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n6 = ((Dimension)object).height / 2 + fontMetrics.getMaxDescent();
            int n7 = fontMetrics.stringWidth(string) + 20;
            if (n4 >= ((Dimension)object).width) break;
            if (xMenuPeer.isEnabled()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color4);
            }
            if (this.getHelpMenu() == xMenuPeer) {
                graphics.drawString(string, ((Dimension)object).width - n7 + 10, n6);
                continue;
            }
            graphics.drawString(string, n4, n6);
            n4 += n7;
        }
        graphics.setClip(shape);
    }

    public void dispose() {
        Iterator iterator = this.menus.iterator();
        while (iterator.hasNext()) {
            XMenuPeer xMenuPeer = ((MenuData)iterator.next()).menu;
            if (xMenuPeer == null) continue;
            xMenuPeer.dispose();
        }
        super.dispose();
    }

    Menu targetGetHelpMenu() {
        try {
            return (Menu)f_helpMenu.get(this.menuTarget);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    XMenuPeer getHelpMenu() {
        return this.helpMenu;
    }

    void setHelpMenu(XMenuPeer xMenuPeer) {
        this.helpMenu = xMenuPeer;
    }

    int getMenuCount() {
        return this.menus.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final XMenuPeer getMenu(int n2) {
        Vector vector = this.getMenus();
        synchronized (vector) {
            if (n2 < this.getMenus().size()) {
                return ((MenuData)this.getMenus().elementAt((int)n2)).menu;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getMenuIndex(int n2) {
        Vector vector = this.getMenus();
        synchronized (vector) {
            if (n2 < this.getMenus().size()) {
                return ((MenuData)this.getMenus().elementAt((int)n2)).index;
            }
            return -1;
        }
    }

    Vector getMenus() {
        return this.menus;
    }

    void setMenus(Vector vector) {
        this.menus = vector;
    }

    Vector getTargetMenus() {
        try {
            return (Vector)f_menus.get(this.menuTarget);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    XMenuPeer getMenu() {
        return this.menu;
    }

    void setMenu(XMenuPeer xMenuPeer) {
        this.menu = xMenuPeer;
    }

    int getMenuSelected() {
        return this.menuSelected;
    }

    void setMenuSelected(int n2) {
        this.menuSelected = n2;
    }

    class MenuData {
        XMenuPeer menu;
        int index;

        MenuData(XMenuPeer xMenuPeer, int n2) {
            this.menu = xMenuPeer;
            this.index = n2;
        }

        public String toString() {
            return this.getClass().getName() + "[menu=" + this.menu + ",index=" + this.index + "]";
        }
    }
}

