/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuPeer;
import java.lang.reflect.Field;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import sun.awt.X11.XCheckboxMenuItemPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XMenuComponentPeer;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XToolkit;

public class XMenuPeer
extends XMenuItemPeer
implements MenuPeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.menu.XMenuPeer");
    private static final int shortCutSpacing = 15;
    private int xIndent = 20;
    private int shortcutOffset = 0;
    private XMenuPeer menu;
    private XMenuComponentPeer parentMenu;
    private int selected;
    private boolean created = false;
    private Point pt;
    private int titleOffset = 0;
    private boolean titleShowing = false;
    private boolean posted = false;
    private int popup_i = -1;
    private Timer popupTimer = null;
    private Vector items = new Vector();
    private static Field f_items = XToolkit.getField(Menu.class, "items");
    private boolean viewable = false;
    static final int checkBorder = 6;

    XMenuItemPeer[] copyItems() {
        return this.getItems().toArray(new XMenuItemPeer[0]);
    }

    public XMenuPeer(Menu menu) {
        super(menu);
        this.pt = new Point(0, 0);
    }

    public XMenuPeer(Menu menu, boolean bl2) {
        this(menu);
        this.titleShowing = bl2;
    }

    public void instantPreInit(XCreateWindowParams xCreateWindowParams) {
        super.instantPreInit(xCreateWindowParams);
        MenuContainer menuContainer = this.getParent();
        if (menuContainer instanceof MenuComponent) {
            this.parentMenu = (XMenuComponentPeer)this.getPeer((MenuComponent)((Object)menuContainer));
        }
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        MenuContainer menuContainer;
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.add((Object)"overrideRedirect", Boolean.TRUE);
        if (this.parentMenu == null && (menuContainer = this.getParent()) instanceof MenuComponent) {
            this.parentMenu = (XMenuComponentPeer)this.getPeer((MenuComponent)((Object)menuContainer));
        }
    }

    void create() {
        this.setSelected(-1);
        if (!this.isCreated()) {
            XCreateWindowParams xCreateWindowParams = this.getDelayedParams();
            xCreateWindowParams.remove("delayed");
            this.init(xCreateWindowParams);
            this.initItems();
        }
        this.setCreated(true);
    }

    boolean isTitleShowing() {
        String string = this.getLabel();
        if (string == null || string.equals("")) {
            this.setTitleShowing(false);
        }
        return this.titleShowing;
    }

    void setTitleShowing(boolean bl2) {
        this.titleShowing = bl2;
    }

    int getWidestItemWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n2 = xMenuItemPeerArray.length;
        int n3 = this.isTitleShowing() ? fontMetrics.stringWidth(this.getLabel()) : 0;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return 0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = Math.max(n3, xMenuItemPeerArray[i2].getWidth(graphics));
        }
        graphics.dispose();
        return n3;
    }

    int getWidestShortcutWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n2 = xMenuItemPeerArray.length;
        int n3 = 0;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return 0;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = Math.max(n3, xMenuItemPeerArray[i2].getShortcutWidth(graphics));
        }
        graphics.dispose();
        return n3;
    }

    Point getTopBot(int n2) {
        int n3 = 0;
        int n4 = 2 + this.getTitleOffset();
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return new Point(0, 0);
        }
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n5 = xMenuItemPeerArray.length;
        if (n2 >= n5) {
            n2 = n5 - 1;
        }
        for (int i2 = 0; i2 < n2 + 1; ++i2) {
            XMenuItemPeer xMenuItemPeer = xMenuItemPeerArray[i2];
            String string = xMenuItemPeer.getLabel();
            if (string.equals("-")) {
                n3 = n4 + 1;
                n4 = n3 + 2;
                continue;
            }
            n3 = n4 + 1;
            n4 = n3 + xMenuItemPeer.getHeight(graphics) - 1;
        }
        graphics.dispose();
        return new Point(n3, n4);
    }

    int getTop(int n2) {
        return this.getTopBot((int)n2).x;
    }

    int getBot(int n2) {
        return this.getTopBot((int)n2).y;
    }

    MenuItem[] copyTargetItems() {
        return this.getTargetItems().toArray(new MenuItem[0]);
    }

    void initItems() {
        Vector<XMenuItemPeer> vector = new Vector<XMenuItemPeer>();
        for (MenuItem menuItem : this.copyTargetItems()) {
            XMenuItemPeer xMenuItemPeer = (XMenuItemPeer)this.getPeer(menuItem);
            if (xMenuItemPeer == null) continue;
            xMenuItemPeer.setMenuPeer(this);
            vector.add(xMenuItemPeer);
        }
        this.setItems(vector);
    }

    int computeXIndent() {
        int n2 = 0;
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n3 = xMenuItemPeerArray.length;
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return 0;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            XMenuItemPeer xMenuItemPeer = xMenuItemPeerArray[i2];
            if (!(xMenuItemPeer instanceof XCheckboxMenuItemPeer)) continue;
            int n5 = ((XCheckboxMenuItemPeer)xMenuItemPeer).getHeight(graphics);
            n4 = Math.max(n4, n5);
        }
        n2 = n4 != 0 ? n4 + 12 + 4 : 4;
        graphics.dispose();
        return n2;
    }

    void updateMenu(int n2, int n3) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.setTitleOffset(this.isTitleShowing() ? fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2 : 0);
        int n4 = this.getBot(this.getItems().size() - 1) + 2;
        this.setXIndent(this.computeXIndent());
        int n5 = this.getWidestShortcutWidth();
        int n6 = this.getWidestItemWidth();
        this.setShortcutOffset(n6 + 15);
        int n7 = n6 + this.getXIndent() * 2 + (n5 == 0 ? 0 : 15 + n5);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n8 = dimension.width;
        int n9 = dimension.height;
        if (n2 + n7 >= n8) {
            n2 = n8 - n7;
        }
        if (n3 + n4 >= n9) {
            n3 = n9 - n4;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.reshape(n2, n3, n7, n4);
    }

    void popup(int n2, int n3) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Popping up " + this + " at " + n2 + ", " + n3);
        }
        if (this.isDisposed()) {
            return;
        }
        this.create();
        this.updateMenu(n2, n3);
        this.setVisible(true);
        this.toFront();
        this.repaint();
    }

    void popdown(MouseEvent mouseEvent, boolean bl2) {
        XMenuItemPeer xMenuItemPeer;
        XMenuPeer xMenuPeer = this.getMenu();
        int n2 = this.getSelected();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Popping down " + this + " because " + mouseEvent + (bl2 ? " with action" : ""));
        }
        this.setVisible(false);
        this.setPosted(false);
        if (xMenuPeer != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Popping down child menu " + xMenuPeer);
            }
            xMenuPeer.popdown(mouseEvent, bl2);
            this.setMenu(null);
        } else if (bl2 && n2 >= 0 && (xMenuItemPeer = this.getItem(n2)) != null && !(xMenuItemPeer instanceof XMenuPeer)) {
            try {
                if (xMenuItemPeer instanceof XCheckboxMenuItemPeer) {
                    XCheckboxMenuItemPeer xCheckboxMenuItemPeer = (XCheckboxMenuItemPeer)xMenuItemPeer;
                    xCheckboxMenuItemPeer.action(mouseEvent.getWhen(), mouseEvent.getModifiers(), !xCheckboxMenuItemPeer.getState());
                } else {
                    xMenuItemPeer.action(mouseEvent.getWhen(), mouseEvent.getModifiers());
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.setSelected(-1);
    }

    void paint(Graphics graphics) {
        int n2;
        String string = this.getLabel();
        int n3 = this.getTitleOffset();
        this.draw3DRect(graphics, 0, 0, this.width - 1, this.height - 1, true);
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.isTitleShowing()) {
            int n4 = fontMetrics.stringWidth(string);
            n2 = this.width - n4 >> 1;
            graphics.setColor(this.getBackground());
            graphics.fillRect(1, 2, this.width - 4, n3);
            this.draw3DRect(graphics, 1, n3, this.width - 3, 1, false);
            graphics.setColor(this.getForeground());
            graphics.drawString(string, n2, 2 + fontMetrics.getMaxAscent());
        }
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        n2 = xMenuItemPeerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            xMenuItemPeerArray[i2].paint(graphics, this.getTop(i2), this.getBot(i2), this.width, this.getShortcutOffset(), i2 == this.selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void select(int n2) {
        int n3;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Selecting item " + n2);
        }
        if (n2 == (n3 = this.getSelected())) {
            return;
        }
        Graphics graphics = this.getGraphics();
        try {
            XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
            int n4 = this.getShortcutOffset();
            graphics.setFont(this.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            if (n3 >= 0) {
                int n5 = n3;
                this.setSelected(-1);
                if (n5 < xMenuItemPeerArray.length) {
                    xMenuItemPeerArray[n5].paint(graphics, this.getTop(n5), this.getBot(n5), this.width, n4, false);
                }
            }
            if (n2 < 0) {
                return;
            }
            XMenuItemPeer xMenuItemPeer = this.getItem(n2);
            if (xMenuItemPeer != null && xMenuItemPeer.isEnabled() && xMenuItemPeer.getLabel() != null && !xMenuItemPeer.getLabel().equals("-")) {
                if (n2 < xMenuItemPeerArray.length) {
                    xMenuItemPeerArray[n2].paint(graphics, this.getTop(n2), this.getBot(n2), this.width, n4, true);
                }
                this.setSelected(n2);
            } else {
                this.setSelected(-1);
            }
        }
        finally {
            graphics.dispose();
        }
    }

    boolean contains(int n2, int n3, int n4) {
        return n2 >= n4 && n2 < this.getWidth() - n4 && n3 >= n4 && n3 < this.getHeight() - n4;
    }

    boolean cascadeContains(XMenuWindow xMenuWindow, Point point, int n2) {
        XMenuPeer xMenuPeer = this.getMenu();
        Point point2 = new Point(point.x, point.y);
        point2 = this.toLocal(xMenuWindow.toGlobal(point2));
        if (xMenuPeer == null) {
            return this.contains(point2.x, point2.y, n2);
        }
        return this.contains(point2.x, point2.y, n2) || xMenuPeer.cascadeContains(this, point2, n2);
    }

    boolean cascadeContains(Point point, int n2) {
        XMenuPeer xMenuPeer = this.getMenu();
        if (xMenuPeer == null) {
            return this.contains(point.x, point.y, n2);
        }
        Point point2 = new Point(point.x, point.y);
        point2 = xMenuPeer.toLocal(this.toGlobal(point2));
        return this.contains(point.x, point.y, n2) || xMenuPeer.cascadeContains(point2, n2);
    }

    boolean lastMenuContains(XMenuWindow xMenuWindow, Point point, int n2) {
        XMenuPeer xMenuPeer = this.getMenu();
        Point point2 = new Point(point.x, point.y);
        point2 = this.toLocal(xMenuWindow.toGlobal(point2));
        if (xMenuPeer == null) {
            return this.contains(point2.x, point2.y, n2);
        }
        return xMenuPeer.lastMenuContains(this, point2, n2);
    }

    public boolean hasMenu() {
        return this.menu != null;
    }

    XMenuPeer doPosting(XMenuWindow xMenuWindow, Point point, int n2) {
        XMenuPeer xMenuPeer = this.getMenu();
        Point point2 = new Point(point.x, point.y);
        if (this.contains(point2.x, point2.y, n2)) {
            XMenuPeer xMenuPeer2 = xMenuPeer;
            if (xMenuPeer != null) {
                if (xMenuPeer.isPosted()) {
                    xMenuPeer.setPosted(false);
                    xMenuPeer.popdown(null, false);
                    this.setMenu(null);
                } else {
                    xMenuPeer.setPosted(true);
                }
            }
            return xMenuPeer2;
        }
        if (xMenuPeer == null) {
            return null;
        }
        point2 = xMenuPeer.toLocal(xMenuWindow.toGlobal(point2));
        return xMenuPeer.doPosting(this, point2, n2);
    }

    int getItemIndex(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getY();
        for (int i2 = 0; i2 < this.getItems().size(); ++i2) {
            if (n2 < this.getTop(i2) || n2 > this.getBot(i2)) continue;
            return i2;
        }
        return -1;
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        if (this.isDisposed()) {
            return;
        }
        XMenuPeer xMenuPeer = this.getMenu();
        final int n2 = this.getWidth();
        int n3 = this.getHeight();
        switch (mouseEvent.getID()) {
            case 501: 
            case 506: {
                XMenuItemPeer xMenuItemPeer;
                int n4;
                int n5 = this.getItemIndex(mouseEvent);
                if (xMenuPeer != null) {
                    this.pt = mouseEvent.getPoint();
                    n4 = this.pt.x;
                    int n6 = this.pt.y;
                    this.pt = xMenuPeer.toLocal(this.toGlobal(this.pt));
                    if (this.contains(n4, n6, 5) && n5 != this.popup_i) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Popping down child menu " + this.menu);
                        }
                        xMenuPeer.popdown(mouseEvent, false);
                        this.setMenu(null);
                    } else {
                        MouseEvent mouseEvent2 = this.makeMouseEvent(mouseEvent, this.pt.x, this.pt.y);
                        xMenuPeer.handleJavaMouseEvent(mouseEvent2);
                        return;
                    }
                }
                if (n5 == -1 || mouseEvent.getX() < 0 || mouseEvent.getX() > n2 || mouseEvent.getY() < 0 || mouseEvent.getY() > n3) {
                    this.select(-1);
                    return;
                }
                this.select(n5);
                n4 = this.getSelected();
                if (n4 < 0 || (xMenuItemPeer = this.getItem(n4)) == null || !(xMenuItemPeer instanceof XMenuPeer) || !xMenuItemPeer.isEnabled() || xMenuPeer != null) break;
                if (mouseEvent.getID() == 506 && mouseEvent.getX() > n2 - 20 || mouseEvent.getID() == 501) {
                    this.setMenu((XMenuPeer)xMenuItemPeer);
                    this.pt.x = n2 - 2;
                    this.pt.y = this.getTop(n4);
                    this.pt = this.toGlobal(this.pt);
                    this.popup_i = n5;
                    this.getMenu().popup(this.pt.x, this.pt.y);
                    if (!log.isLoggable(Level.FINE)) break;
                    log.fine("Popping up child menu " + this.getMenu());
                    break;
                }
                if (mouseEvent.getID() != 506 || n4 < 0 || this.popupTimer != null) break;
                AbstractAction abstractAction = new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        XMenuItemPeer xMenuItemPeer;
                        XMenuPeer.this.popupTimer.stop();
                        XMenuPeer.this.popupTimer = null;
                        if (n4 == XMenuPeer.this.getSelected() && (xMenuItemPeer = XMenuPeer.this.getItem(n4)) != null && xMenuItemPeer instanceof XMenuPeer && xMenuItemPeer.isEnabled() && XMenuPeer.this.getMenu() == null) {
                            XMenuPeer.this.setMenu((XMenuPeer)xMenuItemPeer);
                            ((XMenuPeer)XMenuPeer.this).pt.x = n2 - 2;
                            ((XMenuPeer)XMenuPeer.this).pt.y = XMenuPeer.this.getTop(n4);
                            XMenuPeer.this.pt = XMenuPeer.this.toGlobal(XMenuPeer.this.pt);
                            XMenuPeer.this.popup_i = n4;
                            XMenuPeer.this.getMenu().popup(((XMenuPeer)XMenuPeer.this).pt.x, ((XMenuPeer)XMenuPeer.this).pt.y);
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Popping up(from drag) child menu " + XMenuPeer.this.getMenu());
                            }
                        }
                    }
                };
                this.popupTimer = new Timer(200, abstractAction);
                this.popupTimer.setRepeats(false);
                this.popupTimer.start();
            }
        }
    }

    public void addSeparator() {
    }

    public void addItem(MenuItem menuItem) {
        XMenuItemPeer xMenuItemPeer = (XMenuItemPeer)this.getPeer(menuItem);
        xMenuItemPeer.setMenuPeer(this);
        this.getItems().add(xMenuItemPeer);
        this.updateMenuWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delItem(int n2) {
        Vector vector = this.getItems();
        synchronized (vector) {
            if (n2 < this.getItems().size()) {
                XMenuItemPeer xMenuItemPeer = (XMenuItemPeer)this.getItems().elementAt(n2);
                xMenuItemPeer.setVisible(false);
                this.getItems().removeElementAt(n2);
                this.setSelected(-1);
            }
        }
        this.updateMenuWindow();
    }

    private void updateMenuWindow() {
        if (!this.isVisible() || !this.isCreated()) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        this.updateMenu(rectangle.x, rectangle.y);
        this.repaint();
    }

    public void setEnabled(boolean bl2) {
    }

    public void enable() {
    }

    public void disable() {
    }

    public void dispose() {
        this.setDisposed(true);
        this.setCreated(false);
        super.dispose();
    }

    void setPosted(boolean bl2) {
        this.posted = bl2;
        XMenuPeer xMenuPeer = this.getMenu();
        if (xMenuPeer != null) {
            xMenuPeer.setPosted(bl2);
        }
    }

    boolean isPosted() {
        XMenuPeer xMenuPeer = this.getMenu();
        if (xMenuPeer == null) {
            return this.posted;
        }
        return xMenuPeer.isPosted();
    }

    int getUpSelected() {
        XMenuItemPeer xMenuItemPeer;
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n2 = xMenuItemPeerArray.length;
        if (n2 == 0) {
            return -1;
        }
        int n3 = this.getSelected();
        if (n3 < 0) {
            return -1;
        }
        while (!(xMenuItemPeer = xMenuItemPeerArray[n3 = n3 == 0 ? n2 - 1 : (n3 - 1) % n2]).isEnabled() || xMenuItemPeer.getLabel() != null && xMenuItemPeer.getLabel().equals("-")) {
        }
        return n3;
    }

    int getDownSelected() {
        XMenuItemPeer xMenuItemPeer;
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n2 = xMenuItemPeerArray.length;
        if (n2 == 0) {
            return -1;
        }
        int n3 = this.getSelected();
        while (!(xMenuItemPeer = xMenuItemPeerArray[n3 = (n3 + 1) % n2]).isEnabled() || xMenuItemPeer.getLabel() != null && xMenuItemPeer.getLabel().equals("-")) {
        }
        return n3;
    }

    boolean handleKeyPress1(int n2, XMenuPeer xMenuPeer) {
        XMenuPeer xMenuPeer2 = this.getMenu();
        if (xMenuPeer2 != null) {
            return xMenuPeer2.handleKeyPress1(n2, this);
        }
        switch (n2) {
            case 38: {
                this.select(this.getUpSelected());
                break;
            }
            case 40: {
                this.select(this.getDownSelected());
                return true;
            }
            case 37: {
                if (xMenuPeer == null) break;
                this.setPosted(false);
                this.popdown(null, false);
                xMenuPeer.setMenu(null);
                return true;
            }
            case 10: 
            case 32: 
            case 39: {
                XMenuItemPeer xMenuItemPeer;
                int n3 = this.getSelected();
                if (n3 < 0 || (xMenuItemPeer = this.getItem(n3)) == null || !(xMenuItemPeer instanceof XMenuPeer) || !xMenuItemPeer.isEnabled() || xMenuPeer2 != null) break;
                this.setMenu((XMenuPeer)xMenuItemPeer);
                xMenuPeer2 = this.getMenu();
                this.pt.x = this.getWidth() - 2;
                this.pt.y = this.getTop(n3);
                this.pt = this.toGlobal(this.pt);
                xMenuPeer2.popup(this.pt.x, this.pt.y);
                xMenuPeer2.select(0);
                xMenuPeer2.setPosted(true);
                return true;
            }
        }
        return false;
    }

    int getXIndent() {
        return this.xIndent;
    }

    void setXIndent(int n2) {
        this.xIndent = n2;
    }

    int getItemCount() {
        return this.getItems().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XMenuItemPeer getItem(int n2) {
        Vector vector = this.getItems();
        synchronized (vector) {
            if (n2 < this.getItems().size()) {
                return (XMenuItemPeer)this.getItems().elementAt(n2);
            }
            return null;
        }
    }

    Vector getTargetItems() {
        try {
            return (Vector)f_items.get(this.menuTarget);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    void setCreated(boolean bl2) {
        this.created = bl2;
    }

    boolean isCreated() {
        return this.created;
    }

    XMenuPeer getMenu() {
        return this.menu;
    }

    void setMenu(XMenuPeer xMenuPeer) {
        this.menu = xMenuPeer;
    }

    int getSelected() {
        return this.selected;
    }

    void setSelected(int n2) {
        this.selected = n2;
    }

    int getTitleOffset() {
        return this.titleOffset;
    }

    void setTitleOffset(int n2) {
        this.titleOffset = n2;
    }

    int getShortcutOffset() {
        return this.shortcutOffset;
    }

    void setShortcutOffset(int n2) {
        this.shortcutOffset = n2;
    }

    Vector getItems() {
        return this.items;
    }

    void setItems(Vector vector) {
        this.items = vector;
    }

    void setVisible(boolean bl2) {
        this.xSetVisible(bl2);
    }

    boolean isViewable() {
        return this.viewable;
    }

    void setViewable(boolean bl2) {
        this.viewable = bl2;
    }
}

