/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import com.sun.java.swing.plaf.motif.MotifTextAreaUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.ComponentPeer;
import java.awt.peer.TextAreaPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XTextTransferHelper;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;

class XTextAreaPeer
extends XComponentPeer
implements TextAreaPeer {
    boolean editable;
    boolean scrollGrab;
    Component grabbedScrollbar;
    AWTTextPane textPane;
    AWTTextArea jtext;
    boolean firstChangeSkipped;

    public long filterEvents(long l2) {
        Thread.dumpStack();
        return 0L;
    }

    public Rectangle getCharacterBounds(int n2) {
        Thread.dumpStack();
        return null;
    }

    public int getIndexAtPoint(int n2, int n3) {
        Thread.dumpStack();
        return 0;
    }

    XTextAreaPeer(TextArea textArea) {
        super(textArea);
        this.target = textArea;
        textArea.enableInputMethods(true);
        this.firstChangeSkipped = false;
        String string = textArea.getText();
        this.jtext = new AWTTextArea(string, this);
        this.jtext.setWrapStyleWord(true);
        this.jtext.getDocument().addDocumentListener(this.jtext);
        XToolkit.specialPeerMap.put(this.jtext, this);
        this.jtext.enableInputMethods(true);
        this.textPane = new AWTTextPane(this.jtext, this, textArea.getParent());
        this.setBounds(this.x, this.y, this.width, this.height, 3);
        this.textPane.setVisible(true);
        this.textPane.validate();
        this.foreground = ComponentAccessor.getForeground(textArea);
        if (this.foreground == null) {
            this.foreground = SystemColor.textText;
        }
        this.setForeground(this.foreground);
        this.background = ComponentAccessor.getBackground(textArea);
        if (this.background == null) {
            this.background = textArea.isEditable() ? SystemColor.text : SystemColor.control;
        }
        this.setBackground(this.background);
        if (!textArea.isBackgroundSet()) {
            ComponentAccessor.setBackground(textArea, this.background);
        }
        if (!textArea.isForegroundSet()) {
            textArea.setForeground(SystemColor.textText);
        }
        this.setFont(this.font);
        int n2 = textArea.getSelectionStart();
        int n3 = textArea.getSelectionEnd();
        if (n3 > n2) {
            this.select(n2, n3);
        } else {
            this.setCaretPosition(n2);
        }
        this.setEditable(textArea.isEditable());
        this.setScrollBarVisibility();
        this.setTextImpl(textArea.getText());
        this.firstChangeSkipped = true;
    }

    public void dispose() {
        XToolkit.specialPeerMap.remove(this.jtext);
        this.jtext.removeNotify();
        this.textPane.removeNotify();
        super.dispose();
    }

    void setScrollBarVisibility() {
        int n2 = ((TextArea)this.target).getScrollbarVisibility();
        this.jtext.setLineWrap(false);
        if (n2 == 3) {
            this.textPane.setHorizontalScrollBarPolicy(31);
            this.textPane.setVerticalScrollBarPolicy(21);
            this.jtext.setLineWrap(true);
        } else if (n2 == 0) {
            this.textPane.setHorizontalScrollBarPolicy(32);
            this.textPane.setVerticalScrollBarPolicy(22);
        } else if (n2 == 1) {
            this.textPane.setHorizontalScrollBarPolicy(31);
            this.textPane.setVerticalScrollBarPolicy(22);
            this.jtext.setLineWrap(true);
        } else if (n2 == 2) {
            this.textPane.setVerticalScrollBarPolicy(21);
            this.textPane.setHorizontalScrollBarPolicy(32);
        }
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(10, 60);
    }

    public Dimension getPreferredSize(int n2, int n3) {
        return this.getMinimumSize(n2, n3);
    }

    public Dimension getMinimumSize(int n2, int n3) {
        JScrollBar jScrollBar;
        int n4 = 0;
        int n5 = 0;
        JScrollBar jScrollBar2 = this.textPane.getVerticalScrollBar();
        if (jScrollBar2 != null) {
            n4 = jScrollBar2.getMinimumSize().width;
        }
        if ((jScrollBar = this.textPane.getHorizontalScrollBar()) != null) {
            n5 = jScrollBar.getMinimumSize().height;
        }
        Font font = this.jtext.getFont();
        FontMetrics fontMetrics = this.jtext.getFontMetrics(font);
        return new Dimension(fontMetrics.charWidth('0') * n3 + n4, fontMetrics.getHeight() * n2 + n5);
    }

    public boolean isFocusable() {
        return true;
    }

    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        if (this.textPane != null) {
            this.textPane.setVisible(bl2);
        }
    }

    void repaintText() {
        this.jtext.repaintNow();
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.jtext.forwardFocusGained(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.jtext.forwardFocusLost(focusEvent);
    }

    public void repaint() {
        if (this.textPane != null) {
            this.textPane.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.textPane != null) {
            this.textPane.paint(graphics);
        }
    }

    public void setBounds(int n2, int n3, int n4, int n5, int n6) {
        super.setBounds(n2, n3, n4, n5, n6);
        if (this.textPane != null) {
            this.textPane.setBounds(0, 0, n4, n5);
            this.textPane.validate();
        }
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
        ComponentAccessor.processEvent(this.jtext, keyEvent);
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    void handleJavaMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        ComponentAccessor.processEvent(this.textPane, mouseWheelEvent);
    }

    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        Serializable serializable;
        super.handleJavaMouseEvent(mouseEvent);
        Component component = null;
        int n2 = mouseEvent.getID();
        JScrollBar jScrollBar = this.textPane.getVerticalScrollBar();
        if (jScrollBar != null && ((Rectangle)(serializable = jScrollBar.getBounds())).contains(mouseEvent.getX(), mouseEvent.getY())) {
            component = jScrollBar;
        }
        if ((jScrollBar = this.textPane.getHorizontalScrollBar()) != null && ((Rectangle)(serializable = jScrollBar.getBounds())).contains(mouseEvent.getX(), mouseEvent.getY())) {
            component = jScrollBar;
        }
        if (component == null && !this.scrollGrab) {
            this.pSetCursor(this.target.getCursor());
            serializable = this.textPane.getViewport();
            Point point = ((JViewport)serializable).getViewPosition();
            int n3 = mouseEvent.getX() + point.x;
            int n4 = mouseEvent.getY() + point.y;
            MouseEvent mouseEvent2 = new MouseEvent(this.jtext, n2, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), n3, n4, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            if (n2 == 506 || n2 == 503) {
                this.jtext.processMouseMotionEventPublic(mouseEvent2);
            } else {
                this.jtext.processMouseEventPublic(mouseEvent2);
            }
        } else {
            if (this.scrollGrab) {
                component = this.grabbedScrollbar;
            }
            this.pSetCursor(component.getCursor());
            serializable = component.getLocation();
            int n5 = mouseEvent.getX() - ((Point)serializable).x;
            int n6 = mouseEvent.getY() - ((Point)serializable).y;
            if (n2 == 501) {
                this.scrollGrab = true;
                this.grabbedScrollbar = component;
            } else if (n2 == 502) {
                this.scrollGrab = false;
            }
            MouseEvent mouseEvent3 = new MouseEvent(this.target, n2, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), n5, n6, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            ComponentAccessor.processEvent(component, mouseEvent3);
        }
    }

    void handleJavaInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (this.jtext != null) {
            this.jtext.processInputMethodEventPublic(inputMethodEvent);
        }
    }

    public void select(int n2, int n3) {
        if (this.jtext != null) {
            this.jtext.select(n2, n3);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.jtext != null) {
            this.jtext.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.jtext != null) {
            this.jtext.setForeground(this.foreground);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.jtext != null) {
            this.jtext.setFont(this.font);
        }
        this.textPane.validate();
    }

    public void setEditable(boolean bl2) {
        this.editable = bl2;
        if (this.jtext != null) {
            this.jtext.setEditable(bl2);
        }
        this.repaintText();
        this.setBackground(this.target.getBackground());
    }

    public InputMethodRequests getInputMethodRequests() {
        if (this.jtext != null) {
            return this.jtext.getInputMethodRequests();
        }
        return null;
    }

    public int getSelectionStart() {
        return this.jtext.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.jtext.getSelectionEnd();
    }

    public String getText() {
        return this.jtext.getText();
    }

    public void setText(String string) {
        this.setTextImpl(string);
        this.repaintText();
    }

    protected boolean setTextImpl(String string) {
        if (this.jtext != null) {
            if (this.jtext.getDocument().getLength() == 0 && string.length() == 0) {
                return true;
            }
            this.jtext.getDocument().removeDocumentListener(this.jtext);
            this.jtext.setText(string);
            if (this.firstChangeSkipped) {
                this.postEvent(new TextEvent(this.target, 900));
            }
            this.jtext.getDocument().addDocumentListener(this.jtext);
        }
        return true;
    }

    public void insert(String string, int n2) {
        if (this.jtext != null) {
            JScrollBar jScrollBar;
            boolean bl2 = n2 >= this.jtext.getDocument().getLength() && this.jtext.getDocument().getLength() != 0;
            this.jtext.insert(string, n2);
            if (bl2 && (jScrollBar = this.textPane.getVerticalScrollBar()) != null) {
                jScrollBar.setValue(jScrollBar.getMaximum());
            }
        }
    }

    public void replaceRange(String string, int n2, int n3) {
        if (this.jtext != null) {
            this.jtext.getDocument().removeDocumentListener(this.jtext);
            this.jtext.replaceRange(string, n2, n3);
            this.postEvent(new TextEvent(this.target, 900));
            this.jtext.getDocument().addDocumentListener(this.jtext);
        }
    }

    public void setCaretPosition(int n2) {
        this.jtext.setCaretPosition(n2);
    }

    public int getCaretPosition() {
        return this.jtext.getCaretPosition();
    }

    public void insertText(String string, int n2) {
        this.insert(string, n2);
    }

    public void replaceText(String string, int n2, int n3) {
        this.replaceRange(string, n2, n3);
    }

    public Dimension minimumSize(int n2, int n3) {
        return this.getMinimumSize(n2, n3);
    }

    public Dimension preferredSize(int n2, int n3) {
        return this.getPreferredSize(n2, n3);
    }

    class AWTTextArea
    extends JTextArea
    implements DocumentListener {
        boolean isFocused;
        XTextAreaPeer peer;

        public AWTTextArea(String string, XTextAreaPeer xTextAreaPeer2) {
            super(string);
            this.isFocused = false;
            this.setFocusable(false);
            this.peer = xTextAreaPeer2;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        void forwardFocusGained(FocusEvent focusEvent) {
            this.isFocused = true;
            FocusEvent focusEvent2 = new FocusEvent(this, 1004);
            super.processFocusEvent(focusEvent2);
        }

        void forwardFocusLost(FocusEvent focusEvent) {
            this.isFocused = false;
            FocusEvent focusEvent2 = new FocusEvent(this, 1005);
            super.processFocusEvent(focusEvent2);
        }

        public boolean hasFocus() {
            return this.isFocused;
        }

        public void repaintNow() {
            this.paintImmediately(this.getBounds());
        }

        public void processMouseEventPublic(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void processMouseMotionEventPublic(MouseEvent mouseEvent) {
            this.processMouseMotionEvent(mouseEvent);
        }

        public void processInputMethodEventPublic(InputMethodEvent inputMethodEvent) {
            this.processInputMethodEvent(inputMethodEvent);
        }

        public void updateUI() {
            AWTTextAreaUI aWTTextAreaUI = new AWTTextAreaUI();
            this.setUI((ComponentUI)aWTTextAreaUI);
        }

        protected void processComponentKeyEvent(KeyEvent keyEvent) {
            super.processComponentKeyEvent(keyEvent);
            XTextTransferHelper.processKeyEvent(this, keyEvent);
        }

        public void setTransferHandler(TransferHandler transferHandler) {
            TransferHandler transferHandler2 = (TransferHandler)this.getClientProperty(XTextTransferHelper.getTransferHandlerKey());
            this.putClientProperty(XTextTransferHelper.getTransferHandlerKey(), transferHandler);
            this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
        }
    }

    class AWTTextAreaUI
    extends MotifTextAreaUI {
        JTextArea jta;

        AWTTextAreaUI() {
        }

        protected String getPropertyPrefix() {
            return "TextArea";
        }

        public void installUI(JComponent jComponent) {
            Color color;
            Color color2;
            Color color3;
            Color color4;
            Color color5;
            Color color6;
            super.installUI(jComponent);
            JTextArea jTextArea = this.jta = (JTextArea)jComponent;
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            String string = this.getPropertyPrefix();
            Font font = jTextArea.getFont();
            if (font == null || font instanceof UIResource) {
                jTextArea.setFont(uIDefaults.getFont(string + ".font"));
            }
            if ((color6 = jTextArea.getBackground()) == null || color6 instanceof UIResource) {
                jTextArea.setBackground(uIDefaults.getColor(string + ".background"));
            }
            if ((color5 = jTextArea.getForeground()) == null || color5 instanceof UIResource) {
                jTextArea.setForeground(uIDefaults.getColor(string + ".foreground"));
            }
            if ((color4 = jTextArea.getCaretColor()) == null || color4 instanceof UIResource) {
                jTextArea.setCaretColor(uIDefaults.getColor(string + ".caretForeground"));
            }
            if ((color3 = jTextArea.getSelectionColor()) == null || color3 instanceof UIResource) {
                jTextArea.setSelectionColor(uIDefaults.getColor(string + ".selectionBackground"));
            }
            if ((color2 = jTextArea.getSelectedTextColor()) == null || color2 instanceof UIResource) {
                jTextArea.setSelectedTextColor(uIDefaults.getColor(string + ".selectionForeground"));
            }
            if ((color = jTextArea.getDisabledTextColor()) == null || color instanceof UIResource) {
                jTextArea.setDisabledTextColor(uIDefaults.getColor(string + ".inactiveForeground"));
            }
            BevelBorder bevelBorder = new BevelBorder(false, SystemColor.controlDkShadow, SystemColor.controlLtHighlight);
            jTextArea.setBorder(new BorderUIResource.CompoundBorderUIResource(bevelBorder, new EmptyBorder(2, 2, 2, 2)));
            Insets insets = jTextArea.getMargin();
            if (insets == null || insets instanceof UIResource) {
                jTextArea.setMargin(uIDefaults.getInsets(string + ".margin"));
            }
        }

        protected void installKeyboardActions() {
            super.installKeyboardActions();
            JTextComponent jTextComponent = this.getComponent();
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            String string = this.getPropertyPrefix();
            InputMap inputMap = (InputMap)uIDefaults.get(string + ".focusInputMap");
            if (inputMap != null) {
                SwingUtilities.replaceUIInputMap(jTextComponent, 0, inputMap);
            }
        }

        protected Caret createCaret() {
            return new XAWTCaret();
        }
    }

    class AWTTextPane
    extends JScrollPane
    implements FocusListener {
        JTextArea jtext;
        XWindow xwin;
        Color control;
        Color focus;

        public AWTTextPane(JTextArea jTextArea, XWindow xWindow, Container container) {
            super(jTextArea);
            this.control = SystemColor.control;
            this.focus = SystemColor.activeCaptionBorder;
            this.xwin = xWindow;
            jTextArea.addFocusListener(this);
            ComponentAccessor.setParent(this, container);
            this.setViewportBorder(new BevelBorder(false, SystemColor.controlDkShadow, SystemColor.controlLtHighlight));
            this.jtext = jTextArea;
            this.setFocusable(false);
            this.addNotify();
        }

        public void focusGained(FocusEvent focusEvent) {
            Graphics graphics = this.getGraphics();
            Rectangle rectangle = this.getViewportBorderBounds();
            graphics.setColor(this.focus);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.dispose();
        }

        public void focusLost(FocusEvent focusEvent) {
            Graphics graphics = this.getGraphics();
            Rectangle rectangle = this.getViewportBorderBounds();
            graphics.setColor(this.control);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.dispose();
        }

        public Window getRealParent() {
            return (Window)this.xwin.target;
        }

        public ComponentPeer getPeer() {
            return (ComponentPeer)((Object)this.xwin);
        }

        public void updateUI() {
            XAWTScrollPaneUI xAWTScrollPaneUI = new XAWTScrollPaneUI();
            this.setUI((ComponentUI)xAWTScrollPaneUI);
        }

        public JScrollBar createVerticalScrollBar() {
            return new XAWTScrollBar(1);
        }

        public JScrollBar createHorizontalScrollBar() {
            return new XAWTScrollBar(0);
        }

        public JTextArea getTextArea() {
            return this.jtext;
        }

        public Graphics getGraphics() {
            return this.xwin.getGraphics();
        }

        public void processMouseEventPublic(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void processMouseMotionEventPublic(MouseEvent mouseEvent) {
            this.processMouseMotionEvent(mouseEvent);
        }

        class XAWTScrollBar
        extends JScrollPane.ScrollBar {
            public XAWTScrollBar(int n2) {
                super(AWTTextPane.this, n2);
                this.setFocusable(false);
            }

            public void updateUI() {
                XAWTScrollBarUI xAWTScrollBarUI = new XAWTScrollBarUI();
                this.setUI((ComponentUI)xAWTScrollBarUI);
            }
        }
    }

    static class BevelBorder
    extends AbstractBorder
    implements UIResource {
        private Color darkShadow = SystemColor.controlDkShadow;
        private Color lightShadow = SystemColor.controlLtHighlight;
        private Color control = SystemColor.controlShadow;
        private boolean isRaised;

        public BevelBorder(boolean bl2, Color color, Color color2) {
            this.isRaised = bl2;
            this.darkShadow = color;
            this.lightShadow = color2;
        }

        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            graphics.setColor(this.isRaised ? this.lightShadow : this.darkShadow);
            graphics.drawLine(n2, n3, n2 + n4 - 1, n3);
            graphics.drawLine(n2, n3 + n5 - 1, n2, n3 + 1);
            graphics.setColor(this.control);
            graphics.drawLine(n2 + 1, n3 + 1, n2 + n4 - 2, n3 + 1);
            graphics.drawLine(n2 + 1, n3 + n5 - 1, n2 + 1, n3 + 1);
            graphics.setColor(this.isRaised ? this.darkShadow : this.lightShadow);
            graphics.drawLine(n2 + 1, n3 + n5 - 1, n2 + n4 - 1, n3 + n5 - 1);
            graphics.drawLine(n2 + n4 - 1, n3 + n5 - 1, n2 + n4 - 1, n3 + 1);
            graphics.setColor(this.control);
            graphics.drawLine(n2 + 1, n3 + n5 - 2, n2 + n4 - 2, n3 + n5 - 2);
            graphics.drawLine(n2 + n4 - 2, n3 + n5 - 2, n2 + n4 - 2, n3 + 1);
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.right = 2;
            insets.bottom = 2;
            insets.left = 2;
            insets.top = 2;
            return insets;
        }

        public boolean isOpaque(Component component) {
            return true;
        }
    }

    class XAWTCaret
    extends DefaultCaret {
        XAWTCaret() {
        }

        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            this.getComponent().repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            this.getComponent().repaint();
        }
    }

    class XAWTScrollBarButton
    extends BasicArrowButton {
        UIDefaults uidefaults;
        private Color darkShadow;
        private Color lightShadow;
        private Color buttonBack;

        public XAWTScrollBarButton(int n2) {
            super(n2);
            this.uidefaults = XToolkit.getUIDefaults();
            this.darkShadow = SystemColor.controlShadow;
            this.lightShadow = SystemColor.controlLtHighlight;
            this.buttonBack = this.uidefaults.getColor("ScrollBar.track");
            switch (n2) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    this.direction = n2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid direction");
                }
            }
            this.setRequestFocusEnabled(false);
            this.setOpaque(true);
            this.setBackground(this.uidefaults.getColor("ScrollBar.thumb"));
            this.setForeground(this.uidefaults.getColor("ScrollBar.foreground"));
        }

        public Dimension getPreferredSize() {
            switch (this.direction) {
                case 1: 
                case 5: {
                    return new Dimension(11, 12);
                }
            }
            return new Dimension(12, 11);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics graphics) {
            boolean bl2;
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            if (this.isOpaque()) {
                graphics.setColor(this.buttonBack);
                graphics.fillRect(0, 0, n2, n3);
            }
            Color color = (bl2 = this.getModel().isPressed()) ? this.darkShadow : this.lightShadow;
            Color color2 = bl2 ? this.lightShadow : this.darkShadow;
            Color color3 = this.getBackground();
            int n4 = n2 / 2;
            int n5 = n3 / 2;
            int n6 = Math.min(n2, n3);
            switch (this.direction) {
                case 1: {
                    graphics.setColor(color);
                    graphics.drawLine(n4, 0, n4, 0);
                    int n7 = n4 - 1;
                    int n8 = 1;
                    for (int i2 = 1; i2 <= n6 - 2; i2 += 2) {
                        graphics.setColor(color);
                        graphics.drawLine(n7, i2, n7, i2);
                        if (i2 >= n6 - 2) {
                            graphics.drawLine(n7, i2 + 1, n7, i2 + 1);
                        }
                        graphics.setColor(color3);
                        graphics.drawLine(n7 + 1, i2, n7 + n8, i2);
                        if (i2 < n6 - 2) {
                            graphics.drawLine(n7, i2 + 1, n7 + n8 + 1, i2 + 1);
                        }
                        graphics.setColor(color2);
                        graphics.drawLine(n7 + n8 + 1, i2, n7 + n8 + 1, i2);
                        if (i2 >= n6 - 2) {
                            graphics.drawLine(n7 + 1, i2 + 1, n7 + n8 + 1, i2 + 1);
                        }
                        n8 += 2;
                        --n7;
                    }
                    break;
                }
                case 5: {
                    graphics.setColor(color2);
                    graphics.drawLine(n4, n6, n4, n6);
                    int n9 = n4 - 1;
                    int n10 = 1;
                    for (int i3 = n6 - 1; i3 >= 1; i3 -= 2) {
                        graphics.setColor(color);
                        graphics.drawLine(n9, i3, n9, i3);
                        if (i3 <= 2) {
                            graphics.drawLine(n9, i3 - 1, n9 + n10 + 1, i3 - 1);
                        }
                        graphics.setColor(color3);
                        graphics.drawLine(n9 + 1, i3, n9 + n10, i3);
                        if (i3 > 2) {
                            graphics.drawLine(n9, i3 - 1, n9 + n10 + 1, i3 - 1);
                        }
                        graphics.setColor(color2);
                        graphics.drawLine(n9 + n10 + 1, i3, n9 + n10 + 1, i3);
                        n10 += 2;
                        --n9;
                    }
                    break;
                }
                case 3: {
                    graphics.setColor(color);
                    graphics.drawLine(n6, n5, n6, n5);
                    int n11 = n5 - 1;
                    int n12 = 1;
                    for (int i4 = n6 - 1; i4 >= 1; i4 -= 2) {
                        graphics.setColor(color);
                        graphics.drawLine(i4, n11, i4, n11);
                        if (i4 <= 2) {
                            graphics.drawLine(i4 - 1, n11, i4 - 1, n11 + n12 + 1);
                        }
                        graphics.setColor(color3);
                        graphics.drawLine(i4, n11 + 1, i4, n11 + n12);
                        if (i4 > 2) {
                            graphics.drawLine(i4 - 1, n11, i4 - 1, n11 + n12 + 1);
                        }
                        graphics.setColor(color2);
                        graphics.drawLine(i4, n11 + n12 + 1, i4, n11 + n12 + 1);
                        n12 += 2;
                        --n11;
                    }
                    break;
                }
                case 7: {
                    graphics.setColor(color2);
                    graphics.drawLine(0, n5, 0, n5);
                    int n13 = n5 - 1;
                    int n14 = 1;
                    for (int i5 = 1; i5 <= n6 - 2; i5 += 2) {
                        graphics.setColor(color);
                        graphics.drawLine(i5, n13, i5, n13);
                        if (i5 >= n6 - 2) {
                            graphics.drawLine(i5 + 1, n13, i5 + 1, n13);
                        }
                        graphics.setColor(color3);
                        graphics.drawLine(i5, n13 + 1, i5, n13 + n14);
                        if (i5 < n6 - 2) {
                            graphics.drawLine(i5 + 1, n13, i5 + 1, n13 + n14 + 1);
                        }
                        graphics.setColor(color2);
                        graphics.drawLine(i5, n13 + n14 + 1, i5, n13 + n14 + 1);
                        if (i5 >= n6 - 2) {
                            graphics.drawLine(i5 + 1, n13 + 1, i5 + 1, n13 + n14 + 1);
                        }
                        n14 += 2;
                        --n13;
                    }
                    break;
                }
            }
        }
    }

    class XAWTScrollBarUI
    extends BasicScrollBarUI {
        protected void installDefaults() {
            super.installDefaults();
            this.scrollbar.setBorder(new BevelBorder(false, SystemColor.controlDkShadow, SystemColor.controlLtHighlight));
        }

        protected void configureScrollBarColors() {
            Color color;
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            Color color2 = this.scrollbar.getBackground();
            if (color2 == null || color2 instanceof UIResource) {
                this.scrollbar.setBackground(uIDefaults.getColor("ScrollBar.background"));
            }
            if ((color = this.scrollbar.getForeground()) == null || color instanceof UIResource) {
                this.scrollbar.setForeground(uIDefaults.getColor("ScrollBar.foreground"));
            }
            this.thumbHighlightColor = uIDefaults.getColor("ScrollBar.thumbHighlight");
            this.thumbLightShadowColor = uIDefaults.getColor("ScrollBar.thumbShadow");
            this.thumbDarkShadowColor = uIDefaults.getColor("ScrollBar.thumbDarkShadow");
            this.thumbColor = uIDefaults.getColor("ScrollBar.thumb");
            this.trackColor = uIDefaults.getColor("ScrollBar.track");
            this.trackHighlightColor = uIDefaults.getColor("ScrollBar.trackHighlight");
        }

        protected JButton createDecreaseButton(int n2) {
            XAWTScrollBarButton xAWTScrollBarButton = new XAWTScrollBarButton(n2);
            return xAWTScrollBarButton;
        }

        protected JButton createIncreaseButton(int n2) {
            XAWTScrollBarButton xAWTScrollBarButton = new XAWTScrollBarButton(n2);
            return xAWTScrollBarButton;
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            this.paintTrack(graphics, jComponent, this.getTrackBounds());
            Rectangle rectangle = this.getThumbBounds();
            this.paintThumb(graphics, jComponent, rectangle);
        }

        public void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
            if (!this.scrollbar.isEnabled()) {
                return;
            }
            if (rectangle.isEmpty()) {
                rectangle = this.getTrackBounds();
            }
            int n2 = rectangle.width;
            int n3 = rectangle.height;
            graphics.translate(rectangle.x, rectangle.y);
            graphics.setColor(this.thumbColor);
            graphics.fillRect(0, 0, n2 - 1, n3 - 1);
            graphics.setColor(this.thumbHighlightColor);
            graphics.drawLine(0, 0, 0, n3 - 1);
            graphics.drawLine(1, 0, n2 - 1, 0);
            graphics.setColor(this.thumbLightShadowColor);
            graphics.drawLine(1, n3 - 1, n2 - 1, n3 - 1);
            graphics.drawLine(n2 - 1, 1, n2 - 1, n3 - 2);
            graphics.translate(-rectangle.x, -rectangle.y);
        }
    }

    class XAWTScrollPaneUI
    extends BasicScrollPaneUI {
        private final Border vsbMarginBorderR = new EmptyBorder(0, 2, 0, 0);
        private final Border vsbMarginBorderL = new EmptyBorder(0, 0, 0, 2);
        private final Border hsbMarginBorder = new EmptyBorder(2, 0, 0, 0);
        private Border vsbBorder;
        private Border hsbBorder;
        private PropertyChangeListener propertyChangeHandler;

        XAWTScrollPaneUI() {
        }

        protected void installListeners(JScrollPane jScrollPane) {
            super.installListeners(jScrollPane);
            this.propertyChangeHandler = this.createPropertyChangeHandler();
            jScrollPane.addPropertyChangeListener(this.propertyChangeHandler);
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            Border border = this.scrollpane.getViewportBorder();
            if (border != null) {
                Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
                border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        protected void uninstallListeners(JScrollPane jScrollPane) {
            super.uninstallListeners(jScrollPane);
            jScrollPane.removePropertyChangeListener(this.propertyChangeHandler);
        }

        private PropertyChangeListener createPropertyChangeHandler() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    JScrollPane jScrollPane;
                    JScrollBar jScrollBar;
                    String string = propertyChangeEvent.getPropertyName();
                    if (string.equals("componentOrientation") && (jScrollBar = (jScrollPane = (JScrollPane)propertyChangeEvent.getSource()).getVerticalScrollBar()) != null) {
                        if (XAWTScrollPaneUI.this.isLeftToRight(jScrollPane)) {
                            XAWTScrollPaneUI.this.vsbBorder = new CompoundBorder(new EmptyBorder(0, 4, 0, -4), jScrollBar.getBorder());
                        } else {
                            XAWTScrollPaneUI.this.vsbBorder = new CompoundBorder(new EmptyBorder(0, -4, 0, 4), jScrollBar.getBorder());
                        }
                        jScrollBar.setBorder(XAWTScrollPaneUI.this.vsbBorder);
                    }
                }
            };
        }

        boolean isLeftToRight(Component component) {
            return component.getComponentOrientation().isLeftToRight();
        }

        protected void installDefaults(JScrollPane jScrollPane) {
            JScrollBar jScrollBar;
            Border border = jScrollPane.getBorder();
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            jScrollPane.setBorder(uIDefaults.getBorder("ScrollPane.border"));
            jScrollPane.setBackground(uIDefaults.getColor("ScrollPane.background"));
            jScrollPane.setViewportBorder(uIDefaults.getBorder("TextField.border"));
            JScrollBar jScrollBar2 = jScrollPane.getVerticalScrollBar();
            if (jScrollBar2 != null) {
                this.vsbBorder = this.isLeftToRight(jScrollPane) ? new CompoundBorder(this.vsbMarginBorderR, jScrollBar2.getBorder()) : new CompoundBorder(this.vsbMarginBorderL, jScrollBar2.getBorder());
                jScrollBar2.setBorder(this.vsbBorder);
            }
            if ((jScrollBar = jScrollPane.getHorizontalScrollBar()) != null) {
                this.hsbBorder = new CompoundBorder(this.hsbMarginBorder, jScrollBar.getBorder());
                jScrollBar.setBorder(this.hsbBorder);
            }
        }

        protected void uninstallDefaults(JScrollPane jScrollPane) {
            JScrollBar jScrollBar;
            super.uninstallDefaults(jScrollPane);
            JScrollBar jScrollBar2 = this.scrollpane.getVerticalScrollBar();
            if (jScrollBar2 != null) {
                if (jScrollBar2.getBorder() == this.vsbBorder) {
                    jScrollBar2.setBorder(null);
                }
                this.vsbBorder = null;
            }
            if ((jScrollBar = this.scrollpane.getHorizontalScrollBar()) != null) {
                if (jScrollBar.getBorder() == this.hsbBorder) {
                    jScrollBar.setBorder(null);
                }
                this.hsbBorder = null;
            }
        }
    }
}

