/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import com.sun.java.swing.plaf.motif.MotifPasswordFieldUI;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.ComponentPeer;
import java.awt.peer.TextFieldPeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XTextTransferHelper;
import sun.awt.X11.XToolkit;

public class XTextFieldPeer
extends XComponentPeer
implements TextFieldPeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XTextField");
    String text;
    XAWTTextField xtext;
    boolean firstChangeSkipped = false;
    private static final int PADDING = 16;

    public XTextFieldPeer(TextField textField) {
        super(textField);
        this.text = textField.getText();
        this.xtext = new XAWTTextField(this.text, this, textField.getParent());
        this.xtext.getDocument().addDocumentListener(this.xtext);
        this.xtext.setCursor(textField.getCursor());
        textField.enableInputMethods(true);
        this.xtext.enableInputMethods(true);
        XToolkit.specialPeerMap.put(this.xtext, this);
        TextField textField2 = textField;
        this.initTextField();
        this.setText(textField2.getText());
        if (textField2.echoCharIsSet()) {
            this.setEchoChar(textField2.getEchoChar());
        } else {
            this.setEchoChar('\u0000');
        }
        int n2 = textField2.getSelectionStart();
        int n3 = textField2.getSelectionEnd();
        if (n3 > n2) {
            this.select(n2, n3);
        } else {
            this.setCaretPosition(n2);
        }
        this.setEditable(textField2.isEditable());
        this.firstChangeSkipped = true;
    }

    public void dispose() {
        XToolkit.specialPeerMap.remove(this.xtext);
        this.xtext.removeNotify();
        super.dispose();
    }

    void initTextField() {
        this.setVisible(this.target.isVisible());
        this.setBounds(this.x, this.y, this.width, this.height, 3);
        this.foreground = ComponentAccessor.getForeground(this.target);
        if (this.foreground == null) {
            this.foreground = SystemColor.textText;
        }
        this.setForeground(this.foreground);
        this.background = ComponentAccessor.getBackground(this.target);
        if (this.background == null) {
            this.background = SystemColor.text;
        }
        this.setBackground(this.background);
        if (!this.target.isBackgroundSet()) {
            ComponentAccessor.setBackground(this.target, this.background);
        }
        if (!this.target.isForegroundSet()) {
            this.target.setForeground(SystemColor.textText);
        }
        this.setFont(this.font);
    }

    public void setEditable(boolean bl2) {
        if (this.xtext != null) {
            this.xtext.setEditable(bl2);
            this.xtext.repaint();
        }
        this.setBackground(this.target.getBackground());
    }

    public InputMethodRequests getInputMethodRequests() {
        if (this.xtext != null) {
            return this.xtext.getInputMethodRequests();
        }
        return null;
    }

    void handleJavaInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (this.xtext != null) {
            this.xtext.processInputMethodEventImpl(inputMethodEvent);
        }
    }

    public void setEchoChar(char c2) {
        if (this.xtext != null) {
            this.xtext.setEchoChar(c2);
        }
    }

    public int getSelectionStart() {
        return this.xtext.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.xtext.getSelectionEnd();
    }

    public String getText() {
        return this.xtext.getText();
    }

    public void setText(String string) {
        this.setXAWTTextField(string);
        this.repaint();
    }

    protected boolean setXAWTTextField(String string) {
        this.text = string;
        if (this.xtext != null) {
            this.xtext.getDocument().removeDocumentListener(this.xtext);
            this.xtext.setText(string);
            if (this.firstChangeSkipped) {
                this.postEvent(new TextEvent(this.target, 900));
            }
            this.xtext.getDocument().addDocumentListener(this.xtext);
            this.xtext.setCaretPosition(0);
        }
        return true;
    }

    public void setCaretPosition(int n2) {
        if (this.xtext != null) {
            this.xtext.setCaretPosition(n2);
        }
    }

    public void setEchoCharacter(char c2) {
        this.setEchoChar(c2);
    }

    void repaintText() {
        this.xtext.repaintNow();
    }

    public void setBackground(Color color) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("target=" + this.target + ", old=" + this.background + ", new=" + color);
        }
        this.background = color;
        if (this.xtext != null) {
            this.xtext.setBackground(color);
        }
        this.repaintText();
    }

    public void setForeground(Color color) {
        this.foreground = color;
        if (this.xtext != null) {
            this.xtext.setForeground(this.foreground);
        }
        this.repaintText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.font = font;
            if (this.xtext != null) {
                this.xtext.setFont(this.font);
            }
        }
        this.xtext.validate();
    }

    public Dimension preferredSize(int n2) {
        return this.getPreferredSize(n2);
    }

    public void deselect() {
        int n2;
        int n3 = this.xtext.getSelectionStart();
        if (n3 != (n2 = this.xtext.getSelectionEnd())) {
            this.xtext.select(n3, n3);
        }
    }

    public int getCaretPosition() {
        return this.xtext.getCaretPosition();
    }

    public void select(int n2, int n3) {
        this.xtext.select(n2, n3);
    }

    public Dimension getMinimumSize() {
        return this.xtext.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.xtext.getPreferredSize();
    }

    public Dimension getPreferredSize(int n2) {
        return this.getMinimumSize(n2);
    }

    public Dimension getMinimumSize(int n2) {
        Font font = this.xtext.getFont();
        FontMetrics fontMetrics = this.xtext.getFontMetrics(font);
        return new Dimension(fontMetrics.charWidth('0') * n2 + 10, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 16);
    }

    public boolean isFocusable() {
        return true;
    }

    public void action(long l2, int n2) {
        this.postEvent(new ActionEvent(this.target, 1001, this.text, l2, n2));
    }

    protected void disposeImpl() {
    }

    public void repaint() {
        if (this.xtext != null) {
            this.xtext.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.xtext != null) {
            this.xtext.paint(graphics);
        }
    }

    public void print(Graphics graphics) {
        if (this.xtext != null) {
            this.xtext.print(graphics);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.xtext.forwardFocusLost(focusEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.xtext.forwardFocusGained(focusEvent);
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
        ComponentAccessor.processEvent(this.xtext, keyEvent);
    }

    public void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        if (this.xtext != null) {
            mouseEvent.setSource(this.xtext);
            int n2 = mouseEvent.getID();
            if (n2 == 506 || n2 == 503) {
                this.xtext.processMouseMotionEventImpl(mouseEvent);
            } else {
                this.xtext.processMouseEventImpl(mouseEvent);
            }
        }
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize(int n2) {
        return this.getMinimumSize(n2);
    }

    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        if (this.xtext != null) {
            this.xtext.setVisible(bl2);
        }
    }

    public void setBounds(int n2, int n3, int n4, int n5, int n6) {
        super.setBounds(n2, n3, n4, n5, n6);
        if (this.xtext != null) {
            this.xtext.setBounds(0, 0, n4, n5);
            this.xtext.validate();
        }
    }

    public int getIndexAtPoint(int n2, int n3) {
        return -1;
    }

    public Rectangle getCharacterBounds(int n2) {
        return null;
    }

    public long filterEvents(long l2) {
        return 0L;
    }

    class AWTTextFieldUI
    extends MotifPasswordFieldUI {
        JTextField jtf;

        AWTTextFieldUI() {
        }

        protected String getPropertyPrefix() {
            return "TextField";
        }

        public void installUI(JComponent jComponent) {
            Insets insets;
            Border border;
            Color color;
            Color color2;
            Color color3;
            Color color4;
            Color color5;
            Color color6;
            super.installUI(jComponent);
            JTextField jTextField = this.jtf = (JTextField)jComponent;
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            String string = this.getPropertyPrefix();
            Font font = jTextField.getFont();
            if (font == null || font instanceof UIResource) {
                jTextField.setFont(uIDefaults.getFont(string + ".font"));
            }
            if ((color6 = jTextField.getBackground()) == null || color6 instanceof UIResource) {
                jTextField.setBackground(uIDefaults.getColor(string + ".background"));
            }
            if ((color5 = jTextField.getForeground()) == null || color5 instanceof UIResource) {
                jTextField.setForeground(uIDefaults.getColor(string + ".foreground"));
            }
            if ((color4 = jTextField.getCaretColor()) == null || color4 instanceof UIResource) {
                jTextField.setCaretColor(uIDefaults.getColor(string + ".caretForeground"));
            }
            if ((color3 = jTextField.getSelectionColor()) == null || color3 instanceof UIResource) {
                jTextField.setSelectionColor(uIDefaults.getColor(string + ".selectionBackground"));
            }
            if ((color2 = jTextField.getSelectedTextColor()) == null || color2 instanceof UIResource) {
                jTextField.setSelectedTextColor(uIDefaults.getColor(string + ".selectionForeground"));
            }
            if ((color = jTextField.getDisabledTextColor()) == null || color instanceof UIResource) {
                jTextField.setDisabledTextColor(uIDefaults.getColor(string + ".inactiveForeground"));
            }
            if ((border = jTextField.getBorder()) == null || border instanceof UIResource) {
                jTextField.setBorder(uIDefaults.getBorder(string + ".border"));
            }
            if ((insets = jTextField.getMargin()) == null || insets instanceof UIResource) {
                jTextField.setMargin(uIDefaults.getInsets(string + ".margin"));
            }
        }

        protected void installKeyboardActions() {
            super.installKeyboardActions();
            JTextComponent jTextComponent = this.getComponent();
            UIDefaults uIDefaults = XToolkit.getUIDefaults();
            String string = this.getPropertyPrefix();
            InputMap inputMap = (InputMap)uIDefaults.get(string + ".focusInputMap");
            if (inputMap != null) {
                SwingUtilities.replaceUIInputMap(jTextComponent, 0, inputMap);
            }
        }

        protected Caret createCaret() {
            return new XAWTCaret();
        }
    }

    class XAWTCaret
    extends DefaultCaret {
        XAWTCaret() {
        }

        public void focusGained(FocusEvent focusEvent) {
            super.focusGained(focusEvent);
            this.getComponent().repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            this.getComponent().repaint();
        }
    }

    class XAWTTextField
    extends JPasswordField
    implements ActionListener,
    DocumentListener {
        boolean isFocused;
        XComponentPeer peer;

        public XAWTTextField(String string, XComponentPeer xComponentPeer, Container container) {
            super(string);
            this.isFocused = false;
            this.peer = xComponentPeer;
            this.putClientProperty("JPasswordField.cutCopyAllowed", Boolean.TRUE);
            this.setFocusable(false);
            ComponentAccessor.setParent(this, container);
            this.setBackground(xComponentPeer.getPeerBackground());
            this.setForeground(xComponentPeer.getPeerForeground());
            this.setFont(xComponentPeer.getPeerFont());
            this.setCaretPosition(0);
            this.addActionListener(this);
            this.addNotify();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.peer.postEvent(new ActionEvent(this.peer.target, 1001, this.getText()));
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        public ComponentPeer getPeer() {
            return this.peer;
        }

        public void repaintNow() {
            this.paintImmediately(this.getBounds());
        }

        public Graphics getGraphics() {
            return this.peer.getGraphics();
        }

        public void updateUI() {
            AWTTextFieldUI aWTTextFieldUI = new AWTTextFieldUI();
            this.setUI((ComponentUI)aWTTextFieldUI);
        }

        void forwardFocusGained(FocusEvent focusEvent) {
            this.isFocused = true;
            FocusEvent focusEvent2 = new FocusEvent(this, 1004);
            super.processFocusEvent(focusEvent2);
        }

        void forwardFocusLost(FocusEvent focusEvent) {
            this.isFocused = false;
            FocusEvent focusEvent2 = new FocusEvent(this, 1005);
            super.processFocusEvent(focusEvent2);
        }

        public boolean hasFocus() {
            return this.isFocused;
        }

        public void processInputMethodEventImpl(InputMethodEvent inputMethodEvent) {
            this.processInputMethodEvent(inputMethodEvent);
        }

        public void processMouseEventImpl(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void processMouseMotionEventImpl(MouseEvent mouseEvent) {
            this.processMouseMotionEvent(mouseEvent);
        }

        protected void processComponentKeyEvent(KeyEvent keyEvent) {
            super.processComponentKeyEvent(keyEvent);
            XTextTransferHelper.processKeyEvent(this, keyEvent);
        }

        public void setTransferHandler(TransferHandler transferHandler) {
            TransferHandler transferHandler2 = (TransferHandler)this.getClientProperty(XTextTransferHelper.getTransferHandlerKey());
            this.putClientProperty(XTextTransferHelper.getTransferHandlerKey(), transferHandler);
            this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
        }
    }
}

