/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import sun.awt.X11.XToolkit;

class XTextTransferHelper {
    private static final int CLIPBOARD_ACTION_NONE = 0;
    private static final int CLIPBOARD_ACTION_CUT = 2;
    private static final int CLIPBOARD_ACTION_COPY = 1;
    private static final int CLIPBOARD_ACTION_PASTE = 16;
    private static Field accessField = null;
    private static Object transferHandlerKey = null;

    XTextTransferHelper() {
    }

    private static boolean canAccessClipboard(InputEvent inputEvent) {
        try {
            if (accessField == null) {
                accessField = XToolkit.getField(InputEvent.class, "canAccessSystemClipboard");
            }
            return accessField.getBoolean(inputEvent);
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    static Object getTransferHandlerKey() {
        if (transferHandlerKey == null) {
            try {
                Field field = XToolkit.getField(JComponent.class, "TRANSFER_HANDLER_KEY");
                transferHandlerKey = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
        return transferHandlerKey;
    }

    static int getClipboardAction(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            int n2 = keyEvent.getKeyCode();
            int n3 = keyEvent.getModifiers();
            switch (n2) {
                case 65489: {
                    return 2;
                }
                case 65485: {
                    return 1;
                }
                case 65487: {
                    return 16;
                }
                case 127: {
                    if (n3 != 1) break;
                    return 2;
                }
                case 155: {
                    if (n3 == 2) {
                        return 1;
                    }
                    if (n3 != 1) break;
                    return 16;
                }
                case 88: {
                    if (n3 != 2) break;
                    return 2;
                }
                case 67: {
                    if (n3 != 2) break;
                    return 1;
                }
                case 86: {
                    if (n3 != 2) break;
                    return 16;
                }
            }
        }
        return 0;
    }

    static void processKeyEvent(JTextComponent jTextComponent, KeyEvent keyEvent) {
        int n2;
        if (!keyEvent.isConsumed() && XTextTransferHelper.canAccessClipboard(keyEvent) && (n2 = XTextTransferHelper.getClipboardAction(keyEvent)) != 0) {
            XTextTransferHelper.doClipboardAction(jTextComponent, n2);
            keyEvent.consume();
        }
    }

    static void doClipboardAction(JTextComponent jTextComponent, int n2) {
        TransferHandler transferHandler;
        if (jTextComponent.isEnabled() && (transferHandler = jTextComponent.getTransferHandler()) != null) {
            switch (n2) {
                case 2: {
                    if (!jTextComponent.isEditable()) break;
                    transferHandler.exportToClipboard(jTextComponent, Toolkit.getDefaultToolkit().getSystemClipboard(), n2);
                    break;
                }
                case 1: {
                    transferHandler.exportToClipboard(jTextComponent, Toolkit.getDefaultToolkit().getSystemClipboard(), n2);
                    break;
                }
                case 16: {
                    if (!jTextComponent.isEditable()) break;
                    Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                    transferHandler.importData(jTextComponent, transferable);
                }
            }
        }
    }
}

