/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.awt.peer.FramePeer;
import java.io.Serializable;
import java.util.Vector;
import sun.awt.im.InputMethodWindow;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MWindowAttributes;
import sun.awt.motif.MWindowPeer;

class MFramePeer
extends MWindowPeer
implements FramePeer,
MInputMethodControl {
    static Vector allFrames = new Vector();
    static final int CROSSHAIR_INSET = 5;
    static final int BUTTON_Y = 6;
    static final int BUTTON_W = 17;
    static final int BUTTON_H = 17;
    static final int SYS_MENU_X = 6;
    static final int SYS_MENU_CONTAINED_X = 11;
    static final int SYS_MENU_CONTAINED_Y = 13;
    static final int SYS_MENU_CONTAINED_W = 8;
    static final int SYS_MENU_CONTAINED_H = 3;
    static final int MAXIMIZE_X_DIFF = 22;
    static final int MAXIMIZE_CONTAINED_X_DIFF = 17;
    static final int MAXIMIZE_CONTAINED_Y = 11;
    static final int MAXIMIZE_CONTAINED_W = 8;
    static final int MAXIMIZE_CONTAINED_H = 8;
    static final int MINIMIZE_X_DIFF = 39;
    static final int MINIMIZE_CONTAINED_X_DIFF = 32;
    static final int MINIMIZE_CONTAINED_Y = 13;
    static final int MINIMIZE_CONTAINED_W = 3;
    static final int MINIMIZE_CONTAINED_H = 3;
    static final int TITLE_X = 23;
    static final int TITLE_W_DIFF = 60;
    static final int TITLE_MID_Y = 14;
    static final int MENUBAR_X = 6;
    static final int MENUBAR_Y = 23;
    static final int HORIZ_RESIZE_INSET = 22;
    static final int VERT_RESIZE_INSET = 22;

    public void setMaximizedBounds(Rectangle rectangle) {
    }

    public void create(MComponentPeer mComponentPeer, Object object) {
        super.create(mComponentPeer);
    }

    MFramePeer(Frame frame) {
        this.winAttr.nativeDecor = !frame.isUndecorated();
        this.winAttr.initialFocus = true;
        this.winAttr.isResizable = frame.isResizable();
        this.winAttr.initialState = frame.getState();
        this.winAttr.title = frame.getTitle();
        this.winAttr.icon = frame.getIconImage();
        this.winAttr.decorations = this.winAttr.nativeDecor ? MWindowAttributes.AWT_DECOR_ALL : MWindowAttributes.AWT_DECOR_NONE;
        if (frame instanceof InputMethodWindow) {
            this.winAttr.initialFocus = false;
            this.winAttr.decorations = MWindowAttributes.AWT_DECOR_TITLE | MWindowAttributes.AWT_DECOR_BORDER;
        }
        this.init(frame);
        if (this.winAttr.icon != null) {
            this.setIconImage(this.winAttr.icon);
        }
        allFrames.addElement(this);
    }

    public void setTitle(String string) {
        this.pSetTitle(string);
    }

    protected void disposeImpl() {
        allFrames.removeElement(this);
        super.disposeImpl();
    }

    public void setMenuBar(MenuBar menuBar) {
        MMenuBarPeer mMenuBarPeer = (MMenuBarPeer)MToolkit.targetToPeer(menuBar);
        this.pSetMenuBar(mMenuBarPeer);
        Rectangle rectangle = this.target.bounds();
        this.pReshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.target.isVisible()) {
            this.target.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconImage(Image image) {
        if (image != null) {
            int n2;
            int n3;
            Object object;
            if (image instanceof ToolkitImage) {
                object = ((ToolkitImage)image).getImageRep();
                ((ImageRepresentation)object).reconstruct(32);
                n3 = ((ImageRepresentation)object).getWidth();
                n2 = ((ImageRepresentation)object).getHeight();
            } else {
                n3 = image.getWidth(null);
                n2 = image.getHeight(null);
            }
            if (this.pGetIconSize(n3, n2)) {
                GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration().getDevice().getDefaultConfiguration();
                object = graphicsConfiguration.getColorModel();
                WritableRaster writableRaster = ((ColorModel)object).createCompatibleWritableRaster(this.iconWidth, this.iconHeight);
                BufferedImage bufferedImage = new BufferedImage((ColorModel)object, writableRaster, ((ColorModel)object).isAlphaPremultiplied(), null);
                BufferedImage bufferedImage2 = new BufferedImage(this.iconWidth, this.iconHeight, 2);
                ColorModel colorModel = bufferedImage2.getColorModel();
                Graphics graphics = ((Image)bufferedImage).getGraphics();
                Graphics graphics2 = bufferedImage2.getGraphics();
                try {
                    graphics.drawImage(image, 0, 0, this.iconWidth, this.iconHeight, null);
                    graphics2.drawImage(image, 0, 0, this.iconWidth, this.iconHeight, null);
                }
                finally {
                    graphics.dispose();
                    graphics2.dispose();
                }
                DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
                DataBuffer dataBuffer2 = bufferedImage2.getRaster().getDataBuffer();
                byte[] byArray = null;
                int[] nArray = null;
                int n4 = dataBuffer2.getSize();
                int n5 = this.getNativeColor(SystemColor.window, graphicsConfiguration);
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (colorModel.getAlpha(dataBuffer2.getElem(i2)) != 0) continue;
                    dataBuffer.setElem(i2, n5);
                }
                short[] sArray = null;
                if (dataBuffer instanceof DataBufferByte) {
                    byArray = ((DataBufferByte)dataBuffer).getData();
                } else if (dataBuffer instanceof DataBufferInt) {
                    nArray = ((DataBufferInt)dataBuffer).getData();
                } else if (dataBuffer instanceof DataBufferUShort) {
                    sArray = ((DataBufferUShort)dataBuffer).getData();
                }
                this.pSetIconImage(byArray, nArray, sArray, this.iconWidth, this.iconHeight);
            }
        }
    }

    native boolean pGetIconSize(int var1, int var2);

    native void pSetIconImage(byte[] var1, int[] var2, short[] var3, int var4, int var5);

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleMoved(int n2, int n3) {
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        Object object;
        Object object2;
        Serializable serializable;
        super.print(graphics);
        Frame frame = (Frame)this.target;
        Insets insets = frame.getInsets();
        Dimension dimension = frame.getSize();
        Color color = frame.getBackground();
        Color color2 = frame.getForeground();
        Color color3 = color.brighter();
        Color color4 = color.darker();
        if (this.hasDecorations(MWindowAttributes.AWT_DECOR_BORDER)) {
            if (color3.equals(Color.white)) {
                graphics.setColor(new Color(230, 230, 230));
            } else {
                graphics.setColor(color3);
            }
            graphics.drawLine(0, 0, dimension.width, 0);
            graphics.drawLine(0, 1, dimension.width - 1, 1);
            graphics.drawLine(0, 0, 0, dimension.height);
            graphics.drawLine(1, 0, 1, dimension.height - 1);
            graphics.setColor(color3);
            graphics.drawLine(6, dimension.height - 5, dimension.width - 5, dimension.height - 5);
            graphics.drawLine(dimension.width - 5, 6, dimension.width - 5, dimension.height - 5);
            graphics.setColor(color4);
            graphics.drawLine(1, dimension.height, dimension.width, dimension.height);
            graphics.drawLine(2, dimension.height - 1, dimension.width, dimension.height - 1);
            graphics.drawLine(dimension.width, 1, dimension.width, dimension.height);
            graphics.drawLine(dimension.width - 1, 2, dimension.width - 1, dimension.height);
            graphics.drawLine(5, 5, dimension.width - 5, 5);
            graphics.drawLine(5, 5, 5, dimension.height - 5);
        }
        if (this.hasDecorations(MWindowAttributes.AWT_DECOR_TITLE)) {
            if (this.hasDecorations(MWindowAttributes.AWT_DECOR_MENU)) {
                graphics.setColor(color);
                graphics.fill3DRect(6, 6, 17, 17, true);
                graphics.fill3DRect(11, 13, 8, 3, true);
            }
            graphics.fill3DRect(23, 6, dimension.width - 60, 17, true);
            if (this.hasDecorations(MWindowAttributes.AWT_DECOR_MINIMIZE)) {
                graphics.fill3DRect(dimension.width - 39, 6, 17, 17, true);
                graphics.fill3DRect(dimension.width - 32, 13, 3, 3, true);
            }
            if (this.hasDecorations(MWindowAttributes.AWT_DECOR_MAXIMIZE)) {
                graphics.fill3DRect(dimension.width - 22, 6, 17, 17, true);
                graphics.fill3DRect(dimension.width - 17, 11, 8, 8, true);
            }
            graphics.setColor(color2);
            serializable = new Font("SansSerif", 0, 10);
            graphics.setFont((Font)serializable);
            object2 = graphics.getFontMetrics();
            object = frame.getTitle();
            graphics.drawString((String)object, (46 + dimension.width - 60) / 2 - ((FontMetrics)object2).stringWidth((String)object) / 2, 14 + ((FontMetrics)object2).getMaxDescent());
        }
        if (frame.isResizable() && this.hasDecorations(MWindowAttributes.AWT_DECOR_RESIZEH)) {
            graphics.setColor(color4);
            graphics.drawLine(1, 22, 5, 22);
            graphics.drawLine(22, 1, 22, 5);
            graphics.drawLine(dimension.width - 5 + 1, 22, dimension.width, 22);
            graphics.drawLine(dimension.width - 22 - 1, 2, dimension.width - 22 - 1, 6);
            graphics.drawLine(1, dimension.height - 22 - 1, 5, dimension.height - 22 - 1);
            graphics.drawLine(22, dimension.height - 5 + 1, 22, dimension.height);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22 - 1, dimension.width, dimension.height - 22 - 1);
            graphics.drawLine(dimension.width - 22 - 1, dimension.height - 5 + 1, dimension.width - 22 - 1, dimension.height);
            graphics.setColor(color3);
            graphics.drawLine(2, 23, 5, 23);
            graphics.drawLine(23, 2, 23, 5);
            graphics.drawLine(dimension.width - 5 + 1, 23, dimension.width - 1, 23);
            graphics.drawLine(dimension.width - 22, 2, dimension.width - 22, 5);
            graphics.drawLine(2, dimension.height - 22, 5, dimension.height - 22);
            graphics.drawLine(23, dimension.height - 5 + 1, 23, dimension.height - 1);
            graphics.drawLine(dimension.width - 5 + 1, dimension.height - 22, dimension.width - 1, dimension.height - 22);
            graphics.drawLine(dimension.width - 22, dimension.height - 5 + 1, dimension.width - 22, dimension.height - 1);
        }
        if ((serializable = frame.getMenuBar()) != null && (object2 = (MMenuBarPeer)MToolkit.targetToPeer(serializable)) != null) {
            object = this.getInsets();
            Graphics graphics2 = graphics.create();
            int n2 = 0;
            int n3 = 0;
            if (this.hasDecorations(MWindowAttributes.AWT_DECOR_BORDER)) {
                n2 += 6;
                n3 += 6;
            }
            if (this.hasDecorations(MWindowAttributes.AWT_DECOR_TITLE)) {
                n3 += 17;
            }
            try {
                graphics2.translate(n2, n3);
                ((MMenuBarPeer)object2).print(graphics2);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    void setSaveUnder(boolean bl2) {
    }

    public boolean checkNativePaintOnSetBounds(int n2, int n3) {
        return ((Frame)this.target).isUndecorated() ? n2 > this.oldWidth || n3 > this.oldHeight : n2 != this.oldWidth || n3 != this.oldHeight;
    }
}

