/*
 * Decompiled with CFR 0.152.
 */
package sun.instrument;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import sun.instrument.TransformerManager;
import sun.misc.Launcher;

public class InstrumentationImpl
implements Instrumentation {
    private final TransformerManager mTransformerManager = new TransformerManager();
    private final long mNativeAgent;
    private final boolean mEnvironmentSupportsRedefineClasses;

    private InstrumentationImpl(long l2, boolean bl2) {
        this.mNativeAgent = l2;
        this.mEnvironmentSupportsRedefineClasses = bl2;
    }

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            throw new NullPointerException("null passed as 'transformer' in addTransformer");
        }
        this.mTransformerManager.addTransformer(classFileTransformer);
    }

    public boolean removeTransformer(ClassFileTransformer classFileTransformer) {
        if (classFileTransformer == null) {
            throw new NullPointerException("null passed as 'transformer' in removeTransformer");
        }
        return this.mTransformerManager.removeTransformer(classFileTransformer);
    }

    public boolean isRedefineClassesSupported() {
        return this.mEnvironmentSupportsRedefineClasses;
    }

    public void redefineClasses(ClassDefinition[] classDefinitionArray) throws ClassNotFoundException {
        if (!this.isRedefineClassesSupported()) {
            throw new UnsupportedOperationException("redefineClasses is not supported in this environment");
        }
        if (classDefinitionArray == null) {
            throw new NullPointerException("null passed as 'definitions' in redefineClasses");
        }
        for (int i2 = 0; i2 < classDefinitionArray.length; ++i2) {
            if (classDefinitionArray[i2] != null) continue;
            throw new NullPointerException("element of 'definitions' is null in redefineClasses");
        }
        if (classDefinitionArray.length == 0) {
            return;
        }
        this.redefineClasses0(classDefinitionArray);
    }

    public Class[] getAllLoadedClasses() {
        return this.getAllLoadedClasses0();
    }

    public Class[] getInitiatedClasses(ClassLoader classLoader) {
        return this.getInitiatedClasses0(classLoader);
    }

    public void appendToBootstrapClassLoaderSearch(String string) {
        if (string == null) {
            throw new NullPointerException("null passed as 'newSegment' in appendToBootstrapClassLoaderSearch");
        }
        this.appendToBootstrapClassPath0(string);
    }

    public void appendToClassPath(String string) {
        File file;
        if (string == null) {
            throw new NullPointerException("null passed as 'newSegment' in appendToClassPath");
        }
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            file = new File(string);
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("segment not a valid File");
            illegalArgumentException.initCause(iOException);
            throw illegalArgumentException;
        }
        if (!Launcher.appendToClassPathForInstrumentation(classLoader, file)) {
            throw new InternalError("Segment append failed");
        }
    }

    public long getObjectSize(Object object) {
        if (object == null) {
            throw new NullPointerException("null passed as 'objectToSize' in getObjectSize");
        }
        return this.getObjectSize0(object);
    }

    private native void redefineClasses0(ClassDefinition[] var1) throws ClassNotFoundException;

    public native Class[] getAllLoadedClasses0();

    public native Class[] getInitiatedClasses0(ClassLoader var1);

    private native void appendToBootstrapClassPath0(String var1);

    public native long getObjectSize0(Object var1);

    private long getNativeAgent() {
        return this.mNativeAgent;
    }

    private void loadClassAndCallPremain(String string, String string2) throws Throwable {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Class<?> clazz = classLoader.loadClass(string);
        Method method = clazz.getMethod("premain", String.class, Instrumentation.class);
        method.invoke(null, string2, this);
    }

    private byte[] transform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        return this.mTransformerManager.transform(classLoader, string, clazz, protectionDomain, byArray);
    }
}

