/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import sun.io.ConversionBufferFullException;
import sun.io.Converters;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class CharToByteConverter {
    protected boolean subMode = true;
    protected byte[] subBytes = new byte[]{63};
    protected int charOff;
    protected int byteOff;
    protected int badInputLength;

    public static CharToByteConverter getDefault() {
        Object object = Converters.newDefaultConverter(1);
        return (CharToByteConverter)object;
    }

    public static CharToByteConverter getConverter(String string) throws UnsupportedEncodingException {
        Object object = Converters.newConverter(1, string);
        return (CharToByteConverter)object;
    }

    public abstract String getCharacterEncoding();

    public abstract int convert(char[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException;

    public int convertAny(char[] cArray, int n2, int n3, byte[] byArray, int n4, int n5) throws ConversionBufferFullException {
        if (!this.subMode) {
            throw new IllegalStateException("Substitution mode is not on");
        }
        int n6 = n2;
        int n7 = n4;
        while (n6 < n3) {
            try {
                int n8 = this.convert(cArray, n6, n3, byArray, n7, n5);
                return this.nextByteIndex() - n4;
            }
            catch (MalformedInputException malformedInputException) {
                byte[] byArray2 = this.subBytes;
                int n9 = byArray2.length;
                n7 = this.nextByteIndex();
                if (n7 + n9 > n5) {
                    throw new ConversionBufferFullException();
                }
                for (int i2 = 0; i2 < n9; ++i2) {
                    byArray[n7++] = byArray2[i2];
                }
                n6 = this.nextCharIndex();
                this.badInputLength = 0;
                if ((n6 += this.badInputLength) < n3) continue;
                this.byteOff = n7;
                return this.byteOff - n4;
            }
            catch (UnknownCharacterException unknownCharacterException) {
                throw new Error("UnknownCharacterException thrown in substititution mode", unknownCharacterException);
            }
        }
        return this.nextByteIndex() - n4;
    }

    public byte[] convertAll(char[] cArray) throws MalformedInputException {
        this.reset();
        boolean bl2 = this.subMode;
        this.subMode = true;
        byte[] byArray = new byte[this.getMaxBytesPerChar() * cArray.length];
        try {
            int n2 = this.convert(cArray, 0, cArray.length, byArray, 0, byArray.length);
            byte[] byArray2 = new byte[n2 += this.flush(byArray, this.nextByteIndex(), byArray.length)];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byte[] byArray3 = byArray2;
            return byArray3;
        }
        catch (ConversionBufferFullException conversionBufferFullException) {
            throw new InternalError("this.getMaxBytesPerChar returned bad value");
        }
        catch (UnknownCharacterException unknownCharacterException) {
            throw new InternalError();
        }
        finally {
            this.subMode = bl2;
        }
    }

    public abstract int flush(byte[] var1, int var2, int var3) throws MalformedInputException, ConversionBufferFullException;

    public int flushAny(byte[] byArray, int n2, int n3) throws ConversionBufferFullException {
        if (!this.subMode) {
            throw new IllegalStateException("Substitution mode is not on");
        }
        try {
            return this.flush(byArray, n2, n3);
        }
        catch (MalformedInputException malformedInputException) {
            int n4 = this.subBytes.length;
            byte[] byArray2 = this.subBytes;
            int n5 = n2;
            if (n2 + n4 > n3) {
                throw new ConversionBufferFullException();
            }
            for (int i2 = 0; i2 < n4; ++i2) {
                byArray[n5++] = byArray2[i2];
            }
            this.charOff = 0;
            this.byteOff = 0;
            this.badInputLength = 0;
            return n4;
        }
    }

    public abstract void reset();

    public boolean canConvert(char c2) {
        try {
            char[] cArray = new char[1];
            byte[] byArray = new byte[3];
            cArray[0] = c2;
            this.convert(cArray, 0, 1, byArray, 0, 3);
            return true;
        }
        catch (CharConversionException charConversionException) {
            return false;
        }
    }

    public abstract int getMaxBytesPerChar();

    public int getBadInputLength() {
        return this.badInputLength;
    }

    public int nextCharIndex() {
        return this.charOff;
    }

    public int nextByteIndex() {
        return this.byteOff;
    }

    public void setSubstitutionMode(boolean bl2) {
        this.subMode = bl2;
    }

    public void setSubstitutionBytes(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length > this.getMaxBytesPerChar()) {
            throw new IllegalArgumentException();
        }
        this.subBytes = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.subBytes, 0, byArray.length);
    }

    public String toString() {
        return "CharToByteConverter: " + this.getCharacterEncoding();
    }
}

